// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/compute/region_backend_services/v1/region_backend_services.proto

#include "google/cloud/compute/region_backend_services/v1/region_backend_services_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_region_backend_services_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

RegionBackendServicesClient::RegionBackendServicesClient(
    std::shared_ptr<RegionBackendServicesConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
RegionBackendServicesClient::~RegionBackendServicesClient() = default;

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionBackendServicesClient::DeleteBackendService(
    std::string const& project, std::string const& region,
    std::string const& backend_service, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_backend_services::v1::
      DeleteBackendServiceRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_backend_service(backend_service);
  return connection_->DeleteBackendService(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RegionBackendServicesClient::DeleteBackendService(
    NoAwaitTag, std::string const& project, std::string const& region,
    std::string const& backend_service, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_backend_services::v1::
      DeleteBackendServiceRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_backend_service(backend_service);
  return connection_->DeleteBackendService(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionBackendServicesClient::DeleteBackendService(
    google::cloud::cpp::compute::region_backend_services::v1::
        DeleteBackendServiceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteBackendService(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RegionBackendServicesClient::DeleteBackendService(
    NoAwaitTag,
    google::cloud::cpp::compute::region_backend_services::v1::
        DeleteBackendServiceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteBackendService(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionBackendServicesClient::DeleteBackendService(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteBackendService(operation);
}

StatusOr<google::cloud::cpp::compute::v1::BackendService>
RegionBackendServicesClient::GetBackendService(
    std::string const& project, std::string const& region,
    std::string const& backend_service, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_backend_services::v1::
      GetBackendServiceRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_backend_service(backend_service);
  return connection_->GetBackendService(request);
}

StatusOr<google::cloud::cpp::compute::v1::BackendService>
RegionBackendServicesClient::GetBackendService(
    google::cloud::cpp::compute::region_backend_services::v1::
        GetBackendServiceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetBackendService(request);
}

StatusOr<google::cloud::cpp::compute::v1::BackendServiceGroupHealth>
RegionBackendServicesClient::GetHealth(
    std::string const& project, std::string const& region,
    std::string const& backend_service,
    google::cloud::cpp::compute::v1::ResourceGroupReference const&
        resource_group_reference_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_backend_services::v1::GetHealthRequest
      request;
  request.set_project(project);
  request.set_region(region);
  request.set_backend_service(backend_service);
  *request.mutable_resource_group_reference_resource() =
      resource_group_reference_resource;
  return connection_->GetHealth(request);
}

StatusOr<google::cloud::cpp::compute::v1::BackendServiceGroupHealth>
RegionBackendServicesClient::GetHealth(
    google::cloud::cpp::compute::region_backend_services::v1::
        GetHealthRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetHealth(request);
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
RegionBackendServicesClient::GetIamPolicy(std::string const& project,
                                          std::string const& region,
                                          std::string const& resource,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_backend_services::v1::GetIamPolicyRequest
      request;
  request.set_project(project);
  request.set_region(region);
  request.set_resource(resource);
  return connection_->GetIamPolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
RegionBackendServicesClient::GetIamPolicy(
    google::cloud::cpp::compute::region_backend_services::v1::
        GetIamPolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetIamPolicy(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionBackendServicesClient::InsertBackendService(
    std::string const& project, std::string const& region,
    google::cloud::cpp::compute::v1::BackendService const&
        backend_service_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_backend_services::v1::
      InsertBackendServiceRequest request;
  request.set_project(project);
  request.set_region(region);
  *request.mutable_backend_service_resource() = backend_service_resource;
  return connection_->InsertBackendService(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RegionBackendServicesClient::InsertBackendService(
    NoAwaitTag, std::string const& project, std::string const& region,
    google::cloud::cpp::compute::v1::BackendService const&
        backend_service_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_backend_services::v1::
      InsertBackendServiceRequest request;
  request.set_project(project);
  request.set_region(region);
  *request.mutable_backend_service_resource() = backend_service_resource;
  return connection_->InsertBackendService(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionBackendServicesClient::InsertBackendService(
    google::cloud::cpp::compute::region_backend_services::v1::
        InsertBackendServiceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertBackendService(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RegionBackendServicesClient::InsertBackendService(
    NoAwaitTag,
    google::cloud::cpp::compute::region_backend_services::v1::
        InsertBackendServiceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertBackendService(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionBackendServicesClient::InsertBackendService(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->InsertBackendService(operation);
}

StreamRange<google::cloud::cpp::compute::v1::BackendService>
RegionBackendServicesClient::ListRegionBackendServices(
    std::string const& project, std::string const& region, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_backend_services::v1::
      ListRegionBackendServicesRequest request;
  request.set_project(project);
  request.set_region(region);
  return connection_->ListRegionBackendServices(request);
}

StreamRange<google::cloud::cpp::compute::v1::BackendService>
RegionBackendServicesClient::ListRegionBackendServices(
    google::cloud::cpp::compute::region_backend_services::v1::
        ListRegionBackendServicesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListRegionBackendServices(std::move(request));
}

StreamRange<google::cloud::cpp::compute::v1::BackendService>
RegionBackendServicesClient::ListUsable(std::string const& project,
                                        std::string const& region,
                                        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_backend_services::v1::ListUsableRequest
      request;
  request.set_project(project);
  request.set_region(region);
  return connection_->ListUsable(request);
}

StreamRange<google::cloud::cpp::compute::v1::BackendService>
RegionBackendServicesClient::ListUsable(
    google::cloud::cpp::compute::region_backend_services::v1::ListUsableRequest
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListUsable(std::move(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionBackendServicesClient::PatchBackendService(
    std::string const& project, std::string const& region,
    std::string const& backend_service,
    google::cloud::cpp::compute::v1::BackendService const&
        backend_service_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_backend_services::v1::
      PatchBackendServiceRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_backend_service(backend_service);
  *request.mutable_backend_service_resource() = backend_service_resource;
  return connection_->PatchBackendService(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RegionBackendServicesClient::PatchBackendService(
    NoAwaitTag, std::string const& project, std::string const& region,
    std::string const& backend_service,
    google::cloud::cpp::compute::v1::BackendService const&
        backend_service_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_backend_services::v1::
      PatchBackendServiceRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_backend_service(backend_service);
  *request.mutable_backend_service_resource() = backend_service_resource;
  return connection_->PatchBackendService(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionBackendServicesClient::PatchBackendService(
    google::cloud::cpp::compute::region_backend_services::v1::
        PatchBackendServiceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PatchBackendService(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RegionBackendServicesClient::PatchBackendService(
    NoAwaitTag,
    google::cloud::cpp::compute::region_backend_services::v1::
        PatchBackendServiceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PatchBackendService(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionBackendServicesClient::PatchBackendService(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->PatchBackendService(operation);
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
RegionBackendServicesClient::SetIamPolicy(
    std::string const& project, std::string const& region,
    std::string const& resource,
    google::cloud::cpp::compute::v1::RegionSetPolicyRequest const&
        region_set_policy_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_backend_services::v1::SetIamPolicyRequest
      request;
  request.set_project(project);
  request.set_region(region);
  request.set_resource(resource);
  *request.mutable_region_set_policy_request_resource() =
      region_set_policy_request_resource;
  return connection_->SetIamPolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Policy>
RegionBackendServicesClient::SetIamPolicy(
    google::cloud::cpp::compute::region_backend_services::v1::
        SetIamPolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetIamPolicy(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionBackendServicesClient::SetSecurityPolicy(
    std::string const& project, std::string const& region,
    std::string const& backend_service,
    google::cloud::cpp::compute::v1::SecurityPolicyReference const&
        security_policy_reference_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_backend_services::v1::
      SetSecurityPolicyRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_backend_service(backend_service);
  *request.mutable_security_policy_reference_resource() =
      security_policy_reference_resource;
  return connection_->SetSecurityPolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RegionBackendServicesClient::SetSecurityPolicy(
    NoAwaitTag, std::string const& project, std::string const& region,
    std::string const& backend_service,
    google::cloud::cpp::compute::v1::SecurityPolicyReference const&
        security_policy_reference_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_backend_services::v1::
      SetSecurityPolicyRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_backend_service(backend_service);
  *request.mutable_security_policy_reference_resource() =
      security_policy_reference_resource;
  return connection_->SetSecurityPolicy(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionBackendServicesClient::SetSecurityPolicy(
    google::cloud::cpp::compute::region_backend_services::v1::
        SetSecurityPolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetSecurityPolicy(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RegionBackendServicesClient::SetSecurityPolicy(
    NoAwaitTag,
    google::cloud::cpp::compute::region_backend_services::v1::
        SetSecurityPolicyRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetSecurityPolicy(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionBackendServicesClient::SetSecurityPolicy(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->SetSecurityPolicy(operation);
}

StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
RegionBackendServicesClient::TestIamPermissions(
    std::string const& project, std::string const& region,
    std::string const& resource,
    google::cloud::cpp::compute::v1::TestPermissionsRequest const&
        test_permissions_request_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_backend_services::v1::
      TestIamPermissionsRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_resource(resource);
  *request.mutable_test_permissions_request_resource() =
      test_permissions_request_resource;
  return connection_->TestIamPermissions(request);
}

StatusOr<google::cloud::cpp::compute::v1::TestPermissionsResponse>
RegionBackendServicesClient::TestIamPermissions(
    google::cloud::cpp::compute::region_backend_services::v1::
        TestIamPermissionsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->TestIamPermissions(request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionBackendServicesClient::UpdateBackendService(
    std::string const& project, std::string const& region,
    std::string const& backend_service,
    google::cloud::cpp::compute::v1::BackendService const&
        backend_service_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_backend_services::v1::
      UpdateBackendServiceRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_backend_service(backend_service);
  *request.mutable_backend_service_resource() = backend_service_resource;
  return connection_->UpdateBackendService(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RegionBackendServicesClient::UpdateBackendService(
    NoAwaitTag, std::string const& project, std::string const& region,
    std::string const& backend_service,
    google::cloud::cpp::compute::v1::BackendService const&
        backend_service_resource,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::cpp::compute::region_backend_services::v1::
      UpdateBackendServiceRequest request;
  request.set_project(project);
  request.set_region(region);
  request.set_backend_service(backend_service);
  *request.mutable_backend_service_resource() = backend_service_resource;
  return connection_->UpdateBackendService(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionBackendServicesClient::UpdateBackendService(
    google::cloud::cpp::compute::region_backend_services::v1::
        UpdateBackendServiceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateBackendService(request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
RegionBackendServicesClient::UpdateBackendService(
    NoAwaitTag,
    google::cloud::cpp::compute::region_backend_services::v1::
        UpdateBackendServiceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateBackendService(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
RegionBackendServicesClient::UpdateBackendService(
    google::cloud::cpp::compute::v1::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateBackendService(operation);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_region_backend_services_v1
}  // namespace cloud
}  // namespace google
