// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/instance_groups/v1/instance_groups.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_INSTANCE_GROUPS_V1_INTERNAL_INSTANCE_GROUPS_TRACING_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_INSTANCE_GROUPS_V1_INTERNAL_INSTANCE_GROUPS_TRACING_CONNECTION_H

#include "google/cloud/compute/instance_groups/v1/instance_groups_connection.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace compute_instance_groups_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

class InstanceGroupsTracingConnection
    : public compute_instance_groups_v1::InstanceGroupsConnection {
 public:
  ~InstanceGroupsTracingConnection() override = default;

  explicit InstanceGroupsTracingConnection(
      std::shared_ptr<compute_instance_groups_v1::InstanceGroupsConnection>
          child);

  Options options() override { return child_->options(); }

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> AddInstances(
      google::cloud::cpp::compute::instance_groups::v1::
          AddInstancesRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::Operation> AddInstances(
      NoAwaitTag, google::cloud::cpp::compute::instance_groups::v1::
                      AddInstancesRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> AddInstances(
      google::cloud::cpp::compute::v1::Operation const& operation) override;

  StreamRange<std::pair<
      std::string, google::cloud::cpp::compute::v1::InstanceGroupsScopedList>>
  AggregatedListInstanceGroups(
      google::cloud::cpp::compute::instance_groups::v1::
          AggregatedListInstanceGroupsRequest request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  DeleteInstanceGroup(google::cloud::cpp::compute::instance_groups::v1::
                          DeleteInstanceGroupRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::Operation> DeleteInstanceGroup(
      NoAwaitTag, google::cloud::cpp::compute::instance_groups::v1::
                      DeleteInstanceGroupRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  DeleteInstanceGroup(
      google::cloud::cpp::compute::v1::Operation const& operation) override;

  StatusOr<google::cloud::cpp::compute::v1::InstanceGroup> GetInstanceGroup(
      google::cloud::cpp::compute::instance_groups::v1::
          GetInstanceGroupRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  InsertInstanceGroup(google::cloud::cpp::compute::instance_groups::v1::
                          InsertInstanceGroupRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::Operation> InsertInstanceGroup(
      NoAwaitTag, google::cloud::cpp::compute::instance_groups::v1::
                      InsertInstanceGroupRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
  InsertInstanceGroup(
      google::cloud::cpp::compute::v1::Operation const& operation) override;

  StreamRange<google::cloud::cpp::compute::v1::InstanceGroup>
  ListInstanceGroups(google::cloud::cpp::compute::instance_groups::v1::
                         ListInstanceGroupsRequest request) override;

  StreamRange<google::cloud::cpp::compute::v1::InstanceWithNamedPorts>
  ListInstances(
      google::cloud::cpp::compute::instance_groups::v1::ListInstancesRequest
          request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> RemoveInstances(
      google::cloud::cpp::compute::instance_groups::v1::
          RemoveInstancesRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::Operation> RemoveInstances(
      NoAwaitTag, google::cloud::cpp::compute::instance_groups::v1::
                      RemoveInstancesRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> RemoveInstances(
      google::cloud::cpp::compute::v1::Operation const& operation) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> SetNamedPorts(
      google::cloud::cpp::compute::instance_groups::v1::
          SetNamedPortsRequest const& request) override;

  StatusOr<google::cloud::cpp::compute::v1::Operation> SetNamedPorts(
      NoAwaitTag, google::cloud::cpp::compute::instance_groups::v1::
                      SetNamedPortsRequest const& request) override;

  future<StatusOr<google::cloud::cpp::compute::v1::Operation>> SetNamedPorts(
      google::cloud::cpp::compute::v1::Operation const& operation) override;

 private:
  std::shared_ptr<compute_instance_groups_v1::InstanceGroupsConnection> child_;
};

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

/**
 * Conditionally applies the tracing decorator to the given connection.
 *
 * The connection is only decorated if tracing is enabled (as determined by the
 * connection's options).
 */
std::shared_ptr<compute_instance_groups_v1::InstanceGroupsConnection>
MakeInstanceGroupsTracingConnection(
    std::shared_ptr<compute_instance_groups_v1::InstanceGroupsConnection> conn);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_instance_groups_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_COMPUTE_INSTANCE_GROUPS_V1_INTERNAL_INSTANCE_GROUPS_TRACING_CONNECTION_H
