// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source:
// google/cloud/compute/instance_group_manager_resize_requests/v1/instance_group_manager_resize_requests.proto

#include "google/cloud/compute/instance_group_manager_resize_requests/v1/internal/instance_group_manager_resize_requests_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_instance_group_manager_resize_requests_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

InstanceGroupManagerResizeRequestsTracingConnection::
    InstanceGroupManagerResizeRequestsTracingConnection(
        std::shared_ptr<compute_instance_group_manager_resize_requests_v1::
                            InstanceGroupManagerResizeRequestsConnection>
            child)
    : child_(std::move(child)) {}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagerResizeRequestsTracingConnection::Cancel(
    google::cloud::cpp::compute::instance_group_manager_resize_requests::v1::
        CancelRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_instance_group_manager_resize_requests_v1::"
      "InstanceGroupManagerResizeRequestsConnection::Cancel");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->Cancel(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
InstanceGroupManagerResizeRequestsTracingConnection::Cancel(
    NoAwaitTag,
    google::cloud::cpp::compute::instance_group_manager_resize_requests::v1::
        CancelRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_instance_group_manager_resize_requests_v1::"
      "InstanceGroupManagerResizeRequestsConnection::Cancel");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->Cancel(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagerResizeRequestsTracingConnection::Cancel(
    google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_instance_group_manager_resize_requests_v1::"
      "InstanceGroupManagerResizeRequestsConnection::Cancel");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->Cancel(operation));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagerResizeRequestsTracingConnection::
    DeleteInstanceGroupManagerResizeRequest(
        google::cloud::cpp::compute::instance_group_manager_resize_requests::
            v1::DeleteInstanceGroupManagerResizeRequestRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_instance_group_manager_resize_requests_v1::"
      "InstanceGroupManagerResizeRequestsConnection::"
      "DeleteInstanceGroupManagerResizeRequest");
  internal::OTelScope scope(span);
  return internal::EndSpan(
      std::move(span),
      child_->DeleteInstanceGroupManagerResizeRequest(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
InstanceGroupManagerResizeRequestsTracingConnection::
    DeleteInstanceGroupManagerResizeRequest(
        NoAwaitTag,
        google::cloud::cpp::compute::instance_group_manager_resize_requests::
            v1::DeleteInstanceGroupManagerResizeRequestRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_instance_group_manager_resize_requests_v1::"
      "InstanceGroupManagerResizeRequestsConnection::"
      "DeleteInstanceGroupManagerResizeRequest");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span,
      child_->DeleteInstanceGroupManagerResizeRequest(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagerResizeRequestsTracingConnection::
    DeleteInstanceGroupManagerResizeRequest(
        google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_instance_group_manager_resize_requests_v1::"
      "InstanceGroupManagerResizeRequestsConnection::"
      "DeleteInstanceGroupManagerResizeRequest");
  internal::OTelScope scope(span);
  return internal::EndSpan(
      std::move(span),
      child_->DeleteInstanceGroupManagerResizeRequest(operation));
}

StatusOr<google::cloud::cpp::compute::v1::InstanceGroupManagerResizeRequest>
InstanceGroupManagerResizeRequestsTracingConnection::
    GetInstanceGroupManagerResizeRequest(
        google::cloud::cpp::compute::instance_group_manager_resize_requests::
            v1::GetInstanceGroupManagerResizeRequestRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_instance_group_manager_resize_requests_v1::"
      "InstanceGroupManagerResizeRequestsConnection::"
      "GetInstanceGroupManagerResizeRequest");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(
      *span, child_->GetInstanceGroupManagerResizeRequest(request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagerResizeRequestsTracingConnection::
    InsertInstanceGroupManagerResizeRequest(
        google::cloud::cpp::compute::instance_group_manager_resize_requests::
            v1::InsertInstanceGroupManagerResizeRequestRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_instance_group_manager_resize_requests_v1::"
      "InstanceGroupManagerResizeRequestsConnection::"
      "InsertInstanceGroupManagerResizeRequest");
  internal::OTelScope scope(span);
  return internal::EndSpan(
      std::move(span),
      child_->InsertInstanceGroupManagerResizeRequest(request));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
InstanceGroupManagerResizeRequestsTracingConnection::
    InsertInstanceGroupManagerResizeRequest(
        NoAwaitTag,
        google::cloud::cpp::compute::instance_group_manager_resize_requests::
            v1::InsertInstanceGroupManagerResizeRequestRequest const& request) {
  auto span = internal::MakeSpan(
      "compute_instance_group_manager_resize_requests_v1::"
      "InstanceGroupManagerResizeRequestsConnection::"
      "InsertInstanceGroupManagerResizeRequest");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(
      *span,
      child_->InsertInstanceGroupManagerResizeRequest(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
InstanceGroupManagerResizeRequestsTracingConnection::
    InsertInstanceGroupManagerResizeRequest(
        google::cloud::cpp::compute::v1::Operation const& operation) {
  auto span = internal::MakeSpan(
      "compute_instance_group_manager_resize_requests_v1::"
      "InstanceGroupManagerResizeRequestsConnection::"
      "InsertInstanceGroupManagerResizeRequest");
  internal::OTelScope scope(span);
  return internal::EndSpan(
      std::move(span),
      child_->InsertInstanceGroupManagerResizeRequest(operation));
}

StreamRange<google::cloud::cpp::compute::v1::InstanceGroupManagerResizeRequest>
InstanceGroupManagerResizeRequestsTracingConnection::
    ListInstanceGroupManagerResizeRequests(
        google::cloud::cpp::compute::instance_group_manager_resize_requests::
            v1::ListInstanceGroupManagerResizeRequestsRequest request) {
  auto span = internal::MakeSpan(
      "compute_instance_group_manager_resize_requests_v1::"
      "InstanceGroupManagerResizeRequestsConnection::"
      "ListInstanceGroupManagerResizeRequests");
  internal::OTelScope scope(span);
  auto sr = child_->ListInstanceGroupManagerResizeRequests(std::move(request));
  return internal::MakeTracedStreamRange<
      google::cloud::cpp::compute::v1::InstanceGroupManagerResizeRequest>(
      std::move(span), std::move(sr));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<compute_instance_group_manager_resize_requests_v1::
                    InstanceGroupManagerResizeRequestsConnection>
MakeInstanceGroupManagerResizeRequestsTracingConnection(
    std::shared_ptr<compute_instance_group_manager_resize_requests_v1::
                        InstanceGroupManagerResizeRequestsConnection>
        conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn =
        std::make_shared<InstanceGroupManagerResizeRequestsTracingConnection>(
            std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_instance_group_manager_resize_requests_v1_internal
}  // namespace cloud
}  // namespace google
