// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/future_reservations/v1/future_reservations.proto

#include "google/cloud/compute/future_reservations/v1/future_reservations_connection.h"
#include "google/cloud/compute/future_reservations/v1/future_reservations_options.h"
#include "google/cloud/compute/future_reservations/v1/internal/future_reservations_option_defaults.h"
#include "google/cloud/compute/future_reservations/v1/internal/future_reservations_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_future_reservations_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

FutureReservationsConnection::~FutureReservationsConnection() = default;

StreamRange<std::pair<
    std::string, google::cloud::cpp::compute::v1::FutureReservationsScopedList>>
FutureReservationsConnection::AggregatedListFutureReservations(
    google::cloud::cpp::compute::future_reservations::v1::
        AggregatedListFutureReservationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<std::pair<std::string, google::cloud::cpp::compute::v1::
                                             FutureReservationsScopedList>>>();
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FutureReservationsConnection::Cancel(
    google::cloud::cpp::compute::future_reservations::v1::
        CancelRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
FutureReservationsConnection::Cancel(
    NoAwaitTag, google::cloud::cpp::compute::future_reservations::v1::
                    CancelRequest const&) {
  return StatusOr<google::cloud::cpp::compute::v1::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FutureReservationsConnection::Cancel(
    google::cloud::cpp::compute::v1::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FutureReservationsConnection::DeleteFutureReservation(
    google::cloud::cpp::compute::future_reservations::v1::
        DeleteFutureReservationRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
FutureReservationsConnection::DeleteFutureReservation(
    NoAwaitTag, google::cloud::cpp::compute::future_reservations::v1::
                    DeleteFutureReservationRequest const&) {
  return StatusOr<google::cloud::cpp::compute::v1::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FutureReservationsConnection::DeleteFutureReservation(
    google::cloud::cpp::compute::v1::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::cpp::compute::v1::FutureReservation>
FutureReservationsConnection::GetFutureReservation(
    google::cloud::cpp::compute::future_reservations::v1::
        GetFutureReservationRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FutureReservationsConnection::InsertFutureReservation(
    google::cloud::cpp::compute::future_reservations::v1::
        InsertFutureReservationRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
FutureReservationsConnection::InsertFutureReservation(
    NoAwaitTag, google::cloud::cpp::compute::future_reservations::v1::
                    InsertFutureReservationRequest const&) {
  return StatusOr<google::cloud::cpp::compute::v1::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FutureReservationsConnection::InsertFutureReservation(
    google::cloud::cpp::compute::v1::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StreamRange<google::cloud::cpp::compute::v1::FutureReservation>
FutureReservationsConnection::ListFutureReservations(
    google::cloud::cpp::compute::future_reservations::v1::
        ListFutureReservationsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::cpp::compute::v1::FutureReservation>>();
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FutureReservationsConnection::UpdateFutureReservation(
    google::cloud::cpp::compute::future_reservations::v1::
        UpdateFutureReservationRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
FutureReservationsConnection::UpdateFutureReservation(
    NoAwaitTag, google::cloud::cpp::compute::future_reservations::v1::
                    UpdateFutureReservationRequest const&) {
  return StatusOr<google::cloud::cpp::compute::v1::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FutureReservationsConnection::UpdateFutureReservation(
    google::cloud::cpp::compute::v1::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::cpp::compute::v1::Operation>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_future_reservations_v1
}  // namespace cloud
}  // namespace google
