// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/compute/firewalls/v1/firewalls.proto

#include "google/cloud/compute/firewalls/v1/internal/firewalls_rest_metadata_decorator.h"
#include "google/cloud/internal/absl_str_cat_quiet.h"
#include "google/cloud/internal/api_client_header.h"
#include "google/cloud/internal/rest_set_metadata.h"
#include "google/cloud/status_or.h"
#include "absl/strings/str_format.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace compute_firewalls_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

FirewallsRestMetadata::FirewallsRestMetadata(
    std::shared_ptr<FirewallsRestStub> child, std::string api_client_header)
    : child_(std::move(child)),
      api_client_header_(
          api_client_header.empty()
              ? google::cloud::internal::GeneratedLibClientHeader()
              : std::move(api_client_header)) {}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FirewallsRestMetadata::AsyncDeleteFirewall(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::firewalls::v1::DeleteFirewallRequest const&
        request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncDeleteFirewall(cq, std::move(rest_context),
                                     std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
FirewallsRestMetadata::DeleteFirewall(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::firewalls::v1::DeleteFirewallRequest const&
        request) {
  SetMetadata(rest_context, options);
  return child_->DeleteFirewall(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::Firewall>
FirewallsRestMetadata::GetFirewall(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::firewalls::v1::GetFirewallRequest const&
        request) {
  SetMetadata(rest_context, options);
  return child_->GetFirewall(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FirewallsRestMetadata::AsyncInsertFirewall(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::firewalls::v1::InsertFirewallRequest const&
        request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncInsertFirewall(cq, std::move(rest_context),
                                     std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
FirewallsRestMetadata::InsertFirewall(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::firewalls::v1::InsertFirewallRequest const&
        request) {
  SetMetadata(rest_context, options);
  return child_->InsertFirewall(rest_context, options, request);
}

StatusOr<google::cloud::cpp::compute::v1::FirewallList>
FirewallsRestMetadata::ListFirewalls(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::firewalls::v1::ListFirewallsRequest const&
        request) {
  SetMetadata(rest_context, options);
  return child_->ListFirewalls(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FirewallsRestMetadata::AsyncPatchFirewall(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::firewalls::v1::PatchFirewallRequest const&
        request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncPatchFirewall(cq, std::move(rest_context),
                                    std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
FirewallsRestMetadata::PatchFirewall(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::firewalls::v1::PatchFirewallRequest const&
        request) {
  SetMetadata(rest_context, options);
  return child_->PatchFirewall(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FirewallsRestMetadata::AsyncUpdateFirewall(
    CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::firewalls::v1::UpdateFirewallRequest const&
        request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncUpdateFirewall(cq, std::move(rest_context),
                                     std::move(options), request);
}

StatusOr<google::cloud::cpp::compute::v1::Operation>
FirewallsRestMetadata::UpdateFirewall(
    rest_internal::RestContext& rest_context, Options const& options,
    google::cloud::cpp::compute::firewalls::v1::UpdateFirewallRequest const&
        request) {
  SetMetadata(rest_context, options);
  return child_->UpdateFirewall(rest_context, options, request);
}

future<StatusOr<google::cloud::cpp::compute::v1::Operation>>
FirewallsRestMetadata::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::global_operations::v1::
        GetOperationRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncGetOperation(cq, std::move(rest_context),
                                   std::move(options), request);
}

future<Status> FirewallsRestMetadata::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::unique_ptr<rest_internal::RestContext> rest_context,
    google::cloud::internal::ImmutableOptions options,
    google::cloud::cpp::compute::global_operations::v1::
        DeleteOperationRequest const& request) {
  SetMetadata(*rest_context, *options);
  return child_->AsyncCancelOperation(cq, std::move(rest_context),
                                      std::move(options), request);
}

void FirewallsRestMetadata::SetMetadata(
    rest_internal::RestContext& rest_context, Options const& options,
    std::vector<std::string> const& params) {
  google::cloud::rest_internal::SetMetadata(rest_context, options, params,
                                            api_client_header_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace compute_firewalls_v1_internal
}  // namespace cloud
}  // namespace google
