// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/beyondcorp/appgateways/v1/app_gateways_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BEYONDCORP_APPGATEWAYS_V1_INTERNAL_APP_GATEWAYS_METADATA_DECORATOR_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BEYONDCORP_APPGATEWAYS_V1_INTERNAL_APP_GATEWAYS_METADATA_DECORATOR_H

#include "google/cloud/beyondcorp/appgateways/v1/internal/app_gateways_stub.h"
#include "google/cloud/options.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace beyondcorp_appgateways_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class AppGatewaysServiceMetadata : public AppGatewaysServiceStub {
 public:
  ~AppGatewaysServiceMetadata() override = default;
  AppGatewaysServiceMetadata(
      std::shared_ptr<AppGatewaysServiceStub> child,
      std::multimap<std::string, std::string> fixed_metadata,
      std::string api_client_header = "");

  StatusOr<google::cloud::beyondcorp::appgateways::v1::ListAppGatewaysResponse>
  ListAppGateways(
      grpc::ClientContext& context, Options const& options,
      google::cloud::beyondcorp::appgateways::v1::ListAppGatewaysRequest const&
          request) override;

  StatusOr<google::cloud::beyondcorp::appgateways::v1::AppGateway>
  GetAppGateway(
      grpc::ClientContext& context, Options const& options,
      google::cloud::beyondcorp::appgateways::v1::GetAppGatewayRequest const&
          request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncCreateAppGateway(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::beyondcorp::appgateways::v1::CreateAppGatewayRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> CreateAppGateway(
      grpc::ClientContext& context, Options options,
      google::cloud::beyondcorp::appgateways::v1::CreateAppGatewayRequest const&
          request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncDeleteAppGateway(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::cloud::beyondcorp::appgateways::v1::DeleteAppGatewayRequest const&
          request) override;

  StatusOr<google::longrunning::Operation> DeleteAppGateway(
      grpc::ClientContext& context, Options options,
      google::cloud::beyondcorp::appgateways::v1::DeleteAppGatewayRequest const&
          request) override;

  future<StatusOr<google::longrunning::Operation>> AsyncGetOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::GetOperationRequest const& request) override;

  future<Status> AsyncCancelOperation(
      google::cloud::CompletionQueue& cq,
      std::shared_ptr<grpc::ClientContext> context,
      google::cloud::internal::ImmutableOptions options,
      google::longrunning::CancelOperationRequest const& request) override;

 private:
  void SetMetadata(grpc::ClientContext& context, Options const& options,
                   std::string const& request_params);
  void SetMetadata(grpc::ClientContext& context, Options const& options);

  std::shared_ptr<AppGatewaysServiceStub> child_;
  std::multimap<std::string, std::string> fixed_metadata_;
  std::string api_client_header_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace beyondcorp_appgateways_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BEYONDCORP_APPGATEWAYS_V1_INTERNAL_APP_GATEWAYS_METADATA_DECORATOR_H
