// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/automl/v1/prediction_service.proto

#include "google/cloud/automl/v1/internal/prediction_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace automl_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

PredictionServiceTracingConnection::PredictionServiceTracingConnection(
    std::shared_ptr<automl_v1::PredictionServiceConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::cloud::automl::v1::PredictResponse>
PredictionServiceTracingConnection::Predict(
    google::cloud::automl::v1::PredictRequest const& request) {
  auto span =
      internal::MakeSpan("automl_v1::PredictionServiceConnection::Predict");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->Predict(request));
}

future<StatusOr<google::cloud::automl::v1::BatchPredictResult>>
PredictionServiceTracingConnection::BatchPredict(
    google::cloud::automl::v1::BatchPredictRequest const& request) {
  auto span = internal::MakeSpan(
      "automl_v1::PredictionServiceConnection::BatchPredict");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->BatchPredict(request));
}

StatusOr<google::longrunning::Operation>
PredictionServiceTracingConnection::BatchPredict(
    NoAwaitTag, google::cloud::automl::v1::BatchPredictRequest const& request) {
  auto span = internal::MakeSpan(
      "automl_v1::PredictionServiceConnection::BatchPredict");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span, child_->BatchPredict(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::automl::v1::BatchPredictResult>>
PredictionServiceTracingConnection::BatchPredict(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan(
      "automl_v1::PredictionServiceConnection::BatchPredict");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->BatchPredict(operation));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<automl_v1::PredictionServiceConnection>
MakePredictionServiceTracingConnection(
    std::shared_ptr<automl_v1::PredictionServiceConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn =
        std::make_shared<PredictionServiceTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace automl_v1_internal
}  // namespace cloud
}  // namespace google
