// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/tensorboard_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_TENSORBOARD_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_TENSORBOARD_CLIENT_H

#include "google/cloud/aiplatform/v1/tensorboard_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/longrunning/operations.grpc.pb.h>
#include <map>
#include <memory>
#include <string>

namespace google {
namespace cloud {
namespace aiplatform_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// TensorboardService
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class TensorboardServiceClient {
 public:
  explicit TensorboardServiceClient(
      std::shared_ptr<TensorboardServiceConnection> connection,
      Options opts = {});
  ~TensorboardServiceClient();

  ///@{
  /// @name Copy and move support
  TensorboardServiceClient(TensorboardServiceClient const&) = default;
  TensorboardServiceClient& operator=(TensorboardServiceClient const&) =
      default;
  TensorboardServiceClient(TensorboardServiceClient&&) = default;
  TensorboardServiceClient& operator=(TensorboardServiceClient&&) = default;
  ///@}

  ///@{
  /// @name Equality
  friend bool operator==(TensorboardServiceClient const& a,
                         TensorboardServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(TensorboardServiceClient const& a,
                         TensorboardServiceClient const& b) {
    return !(a == b);
  }
  ///@}

  // clang-format off
  ///
  /// Creates a Tensorboard.
  ///
  /// @param parent  Required. The resource name of the Location to create the Tensorboard in.
  ///  Format: `projects/{project}/locations/{location}`
  /// @param tensorboard  Required. The Tensorboard to create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.Tensorboard] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreateTensorboardRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L375}
  /// [google.cloud.aiplatform.v1.Tensorboard]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard.proto#L35}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::Tensorboard>>
  CreateTensorboard(
      std::string const& parent,
      google::cloud::aiplatform::v1::Tensorboard const& tensorboard,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateTensorboard
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateTensorboard(
      NoAwaitTag, std::string const& parent,
      google::cloud::aiplatform::v1::Tensorboard const& tensorboard,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a Tensorboard.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.CreateTensorboardRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.Tensorboard] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreateTensorboardRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L375}
  /// [google.cloud.aiplatform.v1.Tensorboard]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard.proto#L35}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::Tensorboard>>
  CreateTensorboard(
      google::cloud::aiplatform::v1::CreateTensorboardRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateTensorboard
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> CreateTensorboard(
      NoAwaitTag,
      google::cloud::aiplatform::v1::CreateTensorboardRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief CreateTensorboard
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::Tensorboard>>
  CreateTensorboard(google::longrunning::Operation const& operation,
                    Options opts = {});

  // clang-format off
  ///
  /// Gets a Tensorboard.
  ///
  /// @param name  Required. The name of the Tensorboard resource.
  ///  Format:
  ///  `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.Tensorboard])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.GetTensorboardRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L391}
  /// [google.cloud.aiplatform.v1.Tensorboard]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard.proto#L35}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::Tensorboard> GetTensorboard(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a Tensorboard.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.GetTensorboardRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.Tensorboard])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.GetTensorboardRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L391}
  /// [google.cloud.aiplatform.v1.Tensorboard]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard.proto#L35}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::Tensorboard> GetTensorboard(
      google::cloud::aiplatform::v1::GetTensorboardRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates a Tensorboard.
  ///
  /// @param tensorboard  Required. The Tensorboard's `name` field is used to identify the
  ///  Tensorboard to be updated. Format:
  ///  `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
  /// @param update_mask  Required. Field mask is used to specify the fields to be overwritten in the
  ///  Tensorboard resource by the update.
  ///  The fields specified in the update_mask are relative to the resource, not
  ///  the full request. A field is overwritten if it's in the mask. If the
  ///  user does not provide a mask then all fields are overwritten if new
  ///  values are specified.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.Tensorboard] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.Tensorboard]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard.proto#L35}
  /// [google.cloud.aiplatform.v1.UpdateTensorboardRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L456}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::Tensorboard>>
  UpdateTensorboard(
      google::cloud::aiplatform::v1::Tensorboard const& tensorboard,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateTensorboard
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateTensorboard(
      NoAwaitTag, google::cloud::aiplatform::v1::Tensorboard const& tensorboard,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates a Tensorboard.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.UpdateTensorboardRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.Tensorboard] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.Tensorboard]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard.proto#L35}
  /// [google.cloud.aiplatform.v1.UpdateTensorboardRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L456}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::Tensorboard>>
  UpdateTensorboard(
      google::cloud::aiplatform::v1::UpdateTensorboardRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateTensorboard
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> UpdateTensorboard(
      NoAwaitTag,
      google::cloud::aiplatform::v1::UpdateTensorboardRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief UpdateTensorboard
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::Tensorboard>>
  UpdateTensorboard(google::longrunning::Operation const& operation,
                    Options opts = {});

  // clang-format off
  ///
  /// Lists Tensorboards in a Location.
  ///
  /// @param parent  Required. The resource name of the Location to list Tensorboards.
  ///  Format:
  ///  `projects/{project}/locations/{location}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.Tensorboard], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ListTensorboardsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L405}
  /// [google.cloud.aiplatform.v1.Tensorboard]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard.proto#L35}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::Tensorboard> ListTensorboards(
      std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists Tensorboards in a Location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.ListTensorboardsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.Tensorboard], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ListTensorboardsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L405}
  /// [google.cloud.aiplatform.v1.Tensorboard]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard.proto#L35}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::Tensorboard> ListTensorboards(
      google::cloud::aiplatform::v1::ListTensorboardsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a Tensorboard.
  ///
  /// @param name  Required. The name of the Tensorboard to be deleted.
  ///  Format:
  ///  `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteOperationMetadata]: @googleapis_reference_link{google/cloud/aiplatform/v1/operation.proto#L52}
  /// [google.cloud.aiplatform.v1.DeleteTensorboardRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L474}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteTensorboard(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteTensorboard
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteTensorboard(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a Tensorboard.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.DeleteTensorboardRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteOperationMetadata]: @googleapis_reference_link{google/cloud/aiplatform/v1/operation.proto#L52}
  /// [google.cloud.aiplatform.v1.DeleteTensorboardRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L474}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteTensorboard(
      google::cloud::aiplatform::v1::DeleteTensorboardRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteTensorboard
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteTensorboard(
      NoAwaitTag,
      google::cloud::aiplatform::v1::DeleteTensorboardRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteTensorboard
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteTensorboard(google::longrunning::Operation const& operation,
                    Options opts = {});

  // clang-format off
  ///
  /// Returns a list of monthly active users for a given TensorBoard instance.
  ///
  /// @param tensorboard  Required. The name of the Tensorboard resource.
  ///  Format:
  ///  `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.ReadTensorboardUsageResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ReadTensorboardUsageRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L488}
  /// [google.cloud.aiplatform.v1.ReadTensorboardUsageResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L502}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::ReadTensorboardUsageResponse>
  ReadTensorboardUsage(std::string const& tensorboard, Options opts = {});

  // clang-format off
  ///
  /// Returns a list of monthly active users for a given TensorBoard instance.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.ReadTensorboardUsageRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.ReadTensorboardUsageResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ReadTensorboardUsageRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L488}
  /// [google.cloud.aiplatform.v1.ReadTensorboardUsageResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L502}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::ReadTensorboardUsageResponse>
  ReadTensorboardUsage(
      google::cloud::aiplatform::v1::ReadTensorboardUsageRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Returns the storage size for a given TensorBoard instance.
  ///
  /// @param tensorboard  Required. The name of the Tensorboard resource.
  ///  Format:
  ///  `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.ReadTensorboardSizeResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ReadTensorboardSizeRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L524}
  /// [google.cloud.aiplatform.v1.ReadTensorboardSizeResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L538}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::ReadTensorboardSizeResponse>
  ReadTensorboardSize(std::string const& tensorboard, Options opts = {});

  // clang-format off
  ///
  /// Returns the storage size for a given TensorBoard instance.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.ReadTensorboardSizeRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.ReadTensorboardSizeResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ReadTensorboardSizeRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L524}
  /// [google.cloud.aiplatform.v1.ReadTensorboardSizeResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L538}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::ReadTensorboardSizeResponse>
  ReadTensorboardSize(
      google::cloud::aiplatform::v1::ReadTensorboardSizeRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a TensorboardExperiment.
  ///
  /// @param parent  Required. The resource name of the Tensorboard to create the
  ///  TensorboardExperiment in. Format:
  ///  `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
  /// @param tensorboard_experiment  The TensorboardExperiment to create.
  /// @param tensorboard_experiment_id  Required. The ID to use for the Tensorboard experiment, which becomes the
  ///  final component of the Tensorboard experiment's resource name.
  ///  @n
  ///  This value should be 1-128 characters, and valid characters
  ///  are `/[a-z][0-9]-/`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.TensorboardExperiment])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreateTensorboardExperimentRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L545}
  /// [google.cloud.aiplatform.v1.TensorboardExperiment]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_experiment.proto#L33}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::TensorboardExperiment>
  CreateTensorboardExperiment(
      std::string const& parent,
      google::cloud::aiplatform::v1::TensorboardExperiment const&
          tensorboard_experiment,
      std::string const& tensorboard_experiment_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a TensorboardExperiment.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.CreateTensorboardExperimentRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.TensorboardExperiment])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreateTensorboardExperimentRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L545}
  /// [google.cloud.aiplatform.v1.TensorboardExperiment]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_experiment.proto#L33}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::TensorboardExperiment>
  CreateTensorboardExperiment(
      google::cloud::aiplatform::v1::CreateTensorboardExperimentRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a TensorboardExperiment.
  ///
  /// @param name  Required. The name of the TensorboardExperiment resource.
  ///  Format:
  ///  `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.TensorboardExperiment])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.GetTensorboardExperimentRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L569}
  /// [google.cloud.aiplatform.v1.TensorboardExperiment]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_experiment.proto#L33}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::TensorboardExperiment>
  GetTensorboardExperiment(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a TensorboardExperiment.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.GetTensorboardExperimentRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.TensorboardExperiment])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.GetTensorboardExperimentRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L569}
  /// [google.cloud.aiplatform.v1.TensorboardExperiment]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_experiment.proto#L33}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::TensorboardExperiment>
  GetTensorboardExperiment(
      google::cloud::aiplatform::v1::GetTensorboardExperimentRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates a TensorboardExperiment.
  ///
  /// @param tensorboard_experiment  Required. The TensorboardExperiment's `name` field is used to identify the
  ///  TensorboardExperiment to be updated. Format:
  ///  `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
  /// @param update_mask  Required. Field mask is used to specify the fields to be overwritten in the
  ///  TensorboardExperiment resource by the update.
  ///  The fields specified in the update_mask are relative to the resource, not
  ///  the full request. A field is overwritten if it's in the mask. If the
  ///  user does not provide a mask then all fields are overwritten if new
  ///  values are specified.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.TensorboardExperiment])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.TensorboardExperiment]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_experiment.proto#L33}
  /// [google.cloud.aiplatform.v1.UpdateTensorboardExperimentRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L634}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::TensorboardExperiment>
  UpdateTensorboardExperiment(
      google::cloud::aiplatform::v1::TensorboardExperiment const&
          tensorboard_experiment,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates a TensorboardExperiment.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.UpdateTensorboardExperimentRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.TensorboardExperiment])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.TensorboardExperiment]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_experiment.proto#L33}
  /// [google.cloud.aiplatform.v1.UpdateTensorboardExperimentRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L634}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::TensorboardExperiment>
  UpdateTensorboardExperiment(
      google::cloud::aiplatform::v1::UpdateTensorboardExperimentRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists TensorboardExperiments in a Location.
  ///
  /// @param parent  Required. The resource name of the Tensorboard to list
  ///  TensorboardExperiments. Format:
  ///  `projects/{project}/locations/{location}/tensorboards/{tensorboard}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.TensorboardExperiment], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ListTensorboardExperimentsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L583}
  /// [google.cloud.aiplatform.v1.TensorboardExperiment]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_experiment.proto#L33}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::TensorboardExperiment>
  ListTensorboardExperiments(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists TensorboardExperiments in a Location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.ListTensorboardExperimentsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.TensorboardExperiment], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ListTensorboardExperimentsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L583}
  /// [google.cloud.aiplatform.v1.TensorboardExperiment]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_experiment.proto#L33}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::TensorboardExperiment>
  ListTensorboardExperiments(
      google::cloud::aiplatform::v1::ListTensorboardExperimentsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a TensorboardExperiment.
  ///
  /// @param name  Required. The name of the TensorboardExperiment to be deleted.
  ///  Format:
  ///  `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteOperationMetadata]: @googleapis_reference_link{google/cloud/aiplatform/v1/operation.proto#L52}
  /// [google.cloud.aiplatform.v1.DeleteTensorboardExperimentRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L653}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteTensorboardExperiment(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteTensorboardExperiment
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteTensorboardExperiment(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a TensorboardExperiment.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.DeleteTensorboardExperimentRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteOperationMetadata]: @googleapis_reference_link{google/cloud/aiplatform/v1/operation.proto#L52}
  /// [google.cloud.aiplatform.v1.DeleteTensorboardExperimentRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L653}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteTensorboardExperiment(
      google::cloud::aiplatform::v1::DeleteTensorboardExperimentRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteTensorboardExperiment
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteTensorboardExperiment(
      NoAwaitTag,
      google::cloud::aiplatform::v1::DeleteTensorboardExperimentRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteTensorboardExperiment
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteTensorboardExperiment(google::longrunning::Operation const& operation,
                              Options opts = {});

  // clang-format off
  ///
  /// Creates a TensorboardRun.
  ///
  /// @param parent  Required. The resource name of the TensorboardExperiment to create the
  ///  TensorboardRun in. Format:
  ///  `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
  /// @param tensorboard_run  Required. The TensorboardRun to create.
  /// @param tensorboard_run_id  Required. The ID to use for the Tensorboard run, which becomes the final
  ///  component of the Tensorboard run's resource name.
  ///  @n
  ///  This value should be 1-128 characters, and valid characters
  ///  are `/[a-z][0-9]-/`.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.TensorboardRun])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreateTensorboardRunRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L695}
  /// [google.cloud.aiplatform.v1.TensorboardRun]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_run.proto#L33}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::TensorboardRun> CreateTensorboardRun(
      std::string const& parent,
      google::cloud::aiplatform::v1::TensorboardRun const& tensorboard_run,
      std::string const& tensorboard_run_id, Options opts = {});

  // clang-format off
  ///
  /// Creates a TensorboardRun.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.CreateTensorboardRunRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.TensorboardRun])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreateTensorboardRunRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L695}
  /// [google.cloud.aiplatform.v1.TensorboardRun]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_run.proto#L33}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::TensorboardRun> CreateTensorboardRun(
      google::cloud::aiplatform::v1::CreateTensorboardRunRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Batch create TensorboardRuns.
  ///
  /// @param parent  Required. The resource name of the TensorboardExperiment to create the
  ///  TensorboardRuns in. Format:
  ///  `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
  ///  The parent field in the CreateTensorboardRunRequest messages must match
  ///  this field.
  /// @param requests  Required. The request message specifying the TensorboardRuns to create.
  ///  A maximum of 1000 TensorboardRuns can be created in a batch.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.BatchCreateTensorboardRunsResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.BatchCreateTensorboardRunsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L667}
  /// [google.cloud.aiplatform.v1.BatchCreateTensorboardRunsResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L688}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::BatchCreateTensorboardRunsResponse>
  BatchCreateTensorboardRuns(
      std::string const& parent,
      std::vector<
          google::cloud::aiplatform::v1::CreateTensorboardRunRequest> const&
          requests,
      Options opts = {});

  // clang-format off
  ///
  /// Batch create TensorboardRuns.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.BatchCreateTensorboardRunsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.BatchCreateTensorboardRunsResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.BatchCreateTensorboardRunsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L667}
  /// [google.cloud.aiplatform.v1.BatchCreateTensorboardRunsResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L688}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::BatchCreateTensorboardRunsResponse>
  BatchCreateTensorboardRuns(
      google::cloud::aiplatform::v1::BatchCreateTensorboardRunsRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a TensorboardRun.
  ///
  /// @param name  Required. The name of the TensorboardRun resource.
  ///  Format:
  ///  `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.TensorboardRun])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.GetTensorboardRunRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L719}
  /// [google.cloud.aiplatform.v1.TensorboardRun]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_run.proto#L33}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::TensorboardRun> GetTensorboardRun(
      std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a TensorboardRun.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.GetTensorboardRunRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.TensorboardRun])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.GetTensorboardRunRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L719}
  /// [google.cloud.aiplatform.v1.TensorboardRun]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_run.proto#L33}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::TensorboardRun> GetTensorboardRun(
      google::cloud::aiplatform::v1::GetTensorboardRunRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates a TensorboardRun.
  ///
  /// @param tensorboard_run  Required. The TensorboardRun's `name` field is used to identify the
  ///  TensorboardRun to be updated. Format:
  ///  `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
  /// @param update_mask  Required. Field mask is used to specify the fields to be overwritten in the
  ///  TensorboardRun resource by the update.
  ///  The fields specified in the update_mask are relative to the resource, not
  ///  the full request. A field is overwritten if it's in the mask. If the
  ///  user does not provide a mask then all fields are overwritten if new
  ///  values are specified.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.TensorboardRun])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.TensorboardRun]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_run.proto#L33}
  /// [google.cloud.aiplatform.v1.UpdateTensorboardRunRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L808}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::TensorboardRun> UpdateTensorboardRun(
      google::cloud::aiplatform::v1::TensorboardRun const& tensorboard_run,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates a TensorboardRun.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.UpdateTensorboardRunRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.TensorboardRun])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.TensorboardRun]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_run.proto#L33}
  /// [google.cloud.aiplatform.v1.UpdateTensorboardRunRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L808}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::TensorboardRun> UpdateTensorboardRun(
      google::cloud::aiplatform::v1::UpdateTensorboardRunRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists TensorboardRuns in a Location.
  ///
  /// @param parent  Required. The resource name of the TensorboardExperiment to list
  ///  TensorboardRuns. Format:
  ///  `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.TensorboardRun], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ListTensorboardRunsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L757}
  /// [google.cloud.aiplatform.v1.TensorboardRun]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_run.proto#L33}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::TensorboardRun>
  ListTensorboardRuns(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists TensorboardRuns in a Location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.ListTensorboardRunsRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.TensorboardRun], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ListTensorboardRunsRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L757}
  /// [google.cloud.aiplatform.v1.TensorboardRun]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_run.proto#L33}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::TensorboardRun>
  ListTensorboardRuns(
      google::cloud::aiplatform::v1::ListTensorboardRunsRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a TensorboardRun.
  ///
  /// @param name  Required. The name of the TensorboardRun to be deleted.
  ///  Format:
  ///  `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteOperationMetadata]: @googleapis_reference_link{google/cloud/aiplatform/v1/operation.proto#L52}
  /// [google.cloud.aiplatform.v1.DeleteTensorboardRunRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L826}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteTensorboardRun(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteTensorboardRun
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteTensorboardRun(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a TensorboardRun.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.DeleteTensorboardRunRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteOperationMetadata]: @googleapis_reference_link{google/cloud/aiplatform/v1/operation.proto#L52}
  /// [google.cloud.aiplatform.v1.DeleteTensorboardRunRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L826}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteTensorboardRun(
      google::cloud::aiplatform::v1::DeleteTensorboardRunRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteTensorboardRun
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteTensorboardRun(
      NoAwaitTag,
      google::cloud::aiplatform::v1::DeleteTensorboardRunRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteTensorboardRun
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteTensorboardRun(google::longrunning::Operation const& operation,
                       Options opts = {});

  // clang-format off
  ///
  /// Batch create TensorboardTimeSeries that belong to a TensorboardExperiment.
  ///
  /// @param parent  Required. The resource name of the TensorboardExperiment to create the
  ///  TensorboardTimeSeries in.
  ///  Format:
  ///  `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
  ///  The TensorboardRuns referenced by the parent fields in the
  ///  CreateTensorboardTimeSeriesRequest messages must be sub resources of this
  ///  TensorboardExperiment.
  /// @param requests  Required. The request message specifying the TensorboardTimeSeries to
  ///  create. A maximum of 1000 TensorboardTimeSeries can be created in a batch.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.BatchCreateTensorboardTimeSeriesResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.BatchCreateTensorboardTimeSeriesRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L840}
  /// [google.cloud.aiplatform.v1.BatchCreateTensorboardTimeSeriesResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L863}
  ///
  // clang-format on
  StatusOr<
      google::cloud::aiplatform::v1::BatchCreateTensorboardTimeSeriesResponse>
  BatchCreateTensorboardTimeSeries(
      std::string const& parent,
      std::vector<google::cloud::aiplatform::v1::
                      CreateTensorboardTimeSeriesRequest> const& requests,
      Options opts = {});

  // clang-format off
  ///
  /// Batch create TensorboardTimeSeries that belong to a TensorboardExperiment.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.BatchCreateTensorboardTimeSeriesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.BatchCreateTensorboardTimeSeriesResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.BatchCreateTensorboardTimeSeriesRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L840}
  /// [google.cloud.aiplatform.v1.BatchCreateTensorboardTimeSeriesResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L863}
  ///
  // clang-format on
  StatusOr<
      google::cloud::aiplatform::v1::BatchCreateTensorboardTimeSeriesResponse>
  BatchCreateTensorboardTimeSeries(
      google::cloud::aiplatform::v1::
          BatchCreateTensorboardTimeSeriesRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a TensorboardTimeSeries.
  ///
  /// @param parent  Required. The resource name of the TensorboardRun to create the
  ///  TensorboardTimeSeries in.
  ///  Format:
  ///  `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
  /// @param tensorboard_time_series  Required. The TensorboardTimeSeries to create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.TensorboardTimeSeries])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreateTensorboardTimeSeriesRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L870}
  /// [google.cloud.aiplatform.v1.TensorboardTimeSeries]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_time_series.proto#L32}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::TensorboardTimeSeries>
  CreateTensorboardTimeSeries(
      std::string const& parent,
      google::cloud::aiplatform::v1::TensorboardTimeSeries const&
          tensorboard_time_series,
      Options opts = {});

  // clang-format off
  ///
  /// Creates a TensorboardTimeSeries.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.CreateTensorboardTimeSeriesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.TensorboardTimeSeries])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.CreateTensorboardTimeSeriesRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L870}
  /// [google.cloud.aiplatform.v1.TensorboardTimeSeries]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_time_series.proto#L32}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::TensorboardTimeSeries>
  CreateTensorboardTimeSeries(
      google::cloud::aiplatform::v1::CreateTensorboardTimeSeriesRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets a TensorboardTimeSeries.
  ///
  /// @param name  Required. The name of the TensorboardTimeSeries resource.
  ///  Format:
  ///  `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.TensorboardTimeSeries])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.GetTensorboardTimeSeriesRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L896}
  /// [google.cloud.aiplatform.v1.TensorboardTimeSeries]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_time_series.proto#L32}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::TensorboardTimeSeries>
  GetTensorboardTimeSeries(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Gets a TensorboardTimeSeries.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.GetTensorboardTimeSeriesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.TensorboardTimeSeries])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.GetTensorboardTimeSeriesRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L896}
  /// [google.cloud.aiplatform.v1.TensorboardTimeSeries]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_time_series.proto#L32}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::TensorboardTimeSeries>
  GetTensorboardTimeSeries(
      google::cloud::aiplatform::v1::GetTensorboardTimeSeriesRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Updates a TensorboardTimeSeries.
  ///
  /// @param tensorboard_time_series  Required. The TensorboardTimeSeries' `name` field is used to identify the
  ///  TensorboardTimeSeries to be updated.
  ///  Format:
  ///  `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
  /// @param update_mask  Required. Field mask is used to specify the fields to be overwritten in the
  ///  TensorboardTimeSeries resource by the update.
  ///  The fields specified in the update_mask are relative to the resource, not
  ///  the full request. A field is overwritten if it's in the mask. If the
  ///  user does not provide a mask then all fields are overwritten if new
  ///  values are specified.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.TensorboardTimeSeries])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.TensorboardTimeSeries]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_time_series.proto#L32}
  /// [google.cloud.aiplatform.v1.UpdateTensorboardTimeSeriesRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L961}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::TensorboardTimeSeries>
  UpdateTensorboardTimeSeries(
      google::cloud::aiplatform::v1::TensorboardTimeSeries const&
          tensorboard_time_series,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  // clang-format off
  ///
  /// Updates a TensorboardTimeSeries.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.UpdateTensorboardTimeSeriesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.TensorboardTimeSeries])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.TensorboardTimeSeries]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_time_series.proto#L32}
  /// [google.cloud.aiplatform.v1.UpdateTensorboardTimeSeriesRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L961}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::TensorboardTimeSeries>
  UpdateTensorboardTimeSeries(
      google::cloud::aiplatform::v1::UpdateTensorboardTimeSeriesRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Lists TensorboardTimeSeries in a Location.
  ///
  /// @param parent  Required. The resource name of the TensorboardRun to list
  ///  TensorboardTimeSeries. Format:
  ///  `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.TensorboardTimeSeries], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ListTensorboardTimeSeriesRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L910}
  /// [google.cloud.aiplatform.v1.TensorboardTimeSeries]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_time_series.proto#L32}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::TensorboardTimeSeries>
  ListTensorboardTimeSeries(std::string const& parent, Options opts = {});

  // clang-format off
  ///
  /// Lists TensorboardTimeSeries in a Location.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.ListTensorboardTimeSeriesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.TensorboardTimeSeries], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ListTensorboardTimeSeriesRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L910}
  /// [google.cloud.aiplatform.v1.TensorboardTimeSeries]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_time_series.proto#L32}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::TensorboardTimeSeries>
  ListTensorboardTimeSeries(
      google::cloud::aiplatform::v1::ListTensorboardTimeSeriesRequest request,
      Options opts = {});

  // clang-format off
  ///
  /// Deletes a TensorboardTimeSeries.
  ///
  /// @param name  Required. The name of the TensorboardTimeSeries to be deleted.
  ///  Format:
  ///  `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteOperationMetadata]: @googleapis_reference_link{google/cloud/aiplatform/v1/operation.proto#L52}
  /// [google.cloud.aiplatform.v1.DeleteTensorboardTimeSeriesRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L981}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteTensorboardTimeSeries(std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteTensorboardTimeSeries
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteTensorboardTimeSeries(
      NoAwaitTag, std::string const& name, Options opts = {});

  // clang-format off
  ///
  /// Deletes a TensorboardTimeSeries.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.DeleteTensorboardTimeSeriesRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return A [`future`] that becomes satisfied when the LRO
  ///     ([Long Running Operation]) completes or the polling policy in effect
  ///     for this call is exhausted. The future is satisfied with an error if
  ///     the LRO completes with an error or the polling policy is exhausted.
  ///     In this case the [`StatusOr`] returned by the future contains the
  ///     error. If the LRO completes successfully the value of the future
  ///     contains the LRO's result. For this RPC the result is a
  ///     [google.cloud.aiplatform.v1.DeleteOperationMetadata] proto message.
  ///     The C++ class representing this message is created by Protobuf, using
  ///     the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [Long Running Operation]: https://google.aip.dev/151
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.DeleteOperationMetadata]: @googleapis_reference_link{google/cloud/aiplatform/v1/operation.proto#L52}
  /// [google.cloud.aiplatform.v1.DeleteTensorboardTimeSeriesRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L981}
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteTensorboardTimeSeries(
      google::cloud::aiplatform::v1::DeleteTensorboardTimeSeriesRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteTensorboardTimeSeries
  ///
  /// Specifying the [`NoAwaitTag`] immediately returns the
  /// [`google::longrunning::Operation`] that corresponds to the Long Running
  /// Operation that has been started. No polling for operation status occurs.
  ///
  /// [`NoAwaitTag`]: @ref google::cloud::NoAwaitTag
  ///
  // clang-format on
  StatusOr<google::longrunning::Operation> DeleteTensorboardTimeSeries(
      NoAwaitTag,
      google::cloud::aiplatform::v1::DeleteTensorboardTimeSeriesRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// @copybrief DeleteTensorboardTimeSeries
  ///
  /// This method accepts a `google::longrunning::Operation` that corresponds
  /// to a previously started Long Running Operation (LRO) and polls the status
  /// of the LRO in the background.
  ///
  // clang-format on
  future<StatusOr<google::cloud::aiplatform::v1::DeleteOperationMetadata>>
  DeleteTensorboardTimeSeries(google::longrunning::Operation const& operation,
                              Options opts = {});

  // clang-format off
  ///
  /// Reads multiple TensorboardTimeSeries' data. The data point number limit is
  /// 1000 for scalars, 100 for tensors and blob references. If the number of
  /// data points stored is less than the limit, all data is returned.
  /// Otherwise, the number limit of data points is randomly selected from
  /// this time series and returned.
  ///
  /// @param tensorboard  Required. The resource name of the Tensorboard containing
  ///  TensorboardTimeSeries to read data from. Format:
  ///  `projects/{project}/locations/{location}/tensorboards/{tensorboard}`.
  ///  The TensorboardTimeSeries referenced by
  ///  [time_series][google.cloud.aiplatform.v1.BatchReadTensorboardTimeSeriesDataRequest.time_series]
  ///  must be sub resources of this Tensorboard.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.BatchReadTensorboardTimeSeriesDataResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.BatchReadTensorboardTimeSeriesDataRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L995}
  /// [google.cloud.aiplatform.v1.BatchReadTensorboardTimeSeriesDataRequest.time_series]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L1012}
  /// [google.cloud.aiplatform.v1.BatchReadTensorboardTimeSeriesDataResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L1022}
  ///
  // clang-format on
  StatusOr<
      google::cloud::aiplatform::v1::BatchReadTensorboardTimeSeriesDataResponse>
  BatchReadTensorboardTimeSeriesData(std::string const& tensorboard,
                                     Options opts = {});

  // clang-format off
  ///
  /// Reads multiple TensorboardTimeSeries' data. The data point number limit is
  /// 1000 for scalars, 100 for tensors and blob references. If the number of
  /// data points stored is less than the limit, all data is returned.
  /// Otherwise, the number limit of data points is randomly selected from
  /// this time series and returned.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.BatchReadTensorboardTimeSeriesDataRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.BatchReadTensorboardTimeSeriesDataResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.BatchReadTensorboardTimeSeriesDataRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L995}
  /// [google.cloud.aiplatform.v1.BatchReadTensorboardTimeSeriesDataResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L1022}
  ///
  // clang-format on
  StatusOr<
      google::cloud::aiplatform::v1::BatchReadTensorboardTimeSeriesDataResponse>
  BatchReadTensorboardTimeSeriesData(
      google::cloud::aiplatform::v1::
          BatchReadTensorboardTimeSeriesDataRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Reads a TensorboardTimeSeries' data. By default, if the number of data
  /// points stored is less than 1000, all data is returned. Otherwise, 1000
  /// data points is randomly selected from this time series and returned.
  /// This value can be changed by changing max_data_points, which can't be
  /// greater than 10k.
  ///
  /// @param tensorboard_time_series  Required. The resource name of the TensorboardTimeSeries to read data from.
  ///  Format:
  ///  `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.ReadTensorboardTimeSeriesDataResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ReadTensorboardTimeSeriesDataRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L1029}
  /// [google.cloud.aiplatform.v1.ReadTensorboardTimeSeriesDataResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L1052}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::ReadTensorboardTimeSeriesDataResponse>
  ReadTensorboardTimeSeriesData(std::string const& tensorboard_time_series,
                                Options opts = {});

  // clang-format off
  ///
  /// Reads a TensorboardTimeSeries' data. By default, if the number of data
  /// points stored is less than 1000, all data is returned. Otherwise, 1000
  /// data points is randomly selected from this time series and returned.
  /// This value can be changed by changing max_data_points, which can't be
  /// greater than 10k.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.ReadTensorboardTimeSeriesDataRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.ReadTensorboardTimeSeriesDataResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ReadTensorboardTimeSeriesDataRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L1029}
  /// [google.cloud.aiplatform.v1.ReadTensorboardTimeSeriesDataResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L1052}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::ReadTensorboardTimeSeriesDataResponse>
  ReadTensorboardTimeSeriesData(
      google::cloud::aiplatform::v1::ReadTensorboardTimeSeriesDataRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Gets bytes of TensorboardBlobs.
  /// This is to allow reading blob data stored in consumer project's Cloud
  /// Storage bucket without users having to obtain Cloud Storage access
  /// permission.
  ///
  /// @param time_series  Required. The resource name of the TensorboardTimeSeries to list Blobs.
  ///  Format:
  ///  `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.ReadTensorboardBlobDataResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ReadTensorboardBlobDataRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L733}
  /// [google.cloud.aiplatform.v1.ReadTensorboardBlobDataResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L750}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::ReadTensorboardBlobDataResponse>
  ReadTensorboardBlobData(std::string const& time_series, Options opts = {});

  // clang-format off
  ///
  /// Gets bytes of TensorboardBlobs.
  /// This is to allow reading blob data stored in consumer project's Cloud
  /// Storage bucket without users having to obtain Cloud Storage access
  /// permission.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.ReadTensorboardBlobDataRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.ReadTensorboardBlobDataResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ReadTensorboardBlobDataRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L733}
  /// [google.cloud.aiplatform.v1.ReadTensorboardBlobDataResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L750}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::ReadTensorboardBlobDataResponse>
  ReadTensorboardBlobData(
      google::cloud::aiplatform::v1::ReadTensorboardBlobDataRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Write time series data points of multiple TensorboardTimeSeries in multiple
  /// TensorboardRun's. If any data fail to be ingested, an error is returned.
  ///
  /// @param tensorboard_experiment  Required. The resource name of the TensorboardExperiment to write data to.
  ///  Format:
  ///  `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}`
  /// @param write_run_data_requests  Required. Requests containing per-run TensorboardTimeSeries data to write.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.WriteTensorboardExperimentDataResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.WriteTensorboardExperimentDataRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L1059}
  /// [google.cloud.aiplatform.v1.WriteTensorboardExperimentDataResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L1077}
  ///
  // clang-format on
  StatusOr<
      google::cloud::aiplatform::v1::WriteTensorboardExperimentDataResponse>
  WriteTensorboardExperimentData(
      std::string const& tensorboard_experiment,
      std::vector<
          google::cloud::aiplatform::v1::WriteTensorboardRunDataRequest> const&
          write_run_data_requests,
      Options opts = {});

  // clang-format off
  ///
  /// Write time series data points of multiple TensorboardTimeSeries in multiple
  /// TensorboardRun's. If any data fail to be ingested, an error is returned.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.WriteTensorboardExperimentDataRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.WriteTensorboardExperimentDataResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.WriteTensorboardExperimentDataRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L1059}
  /// [google.cloud.aiplatform.v1.WriteTensorboardExperimentDataResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L1077}
  ///
  // clang-format on
  StatusOr<
      google::cloud::aiplatform::v1::WriteTensorboardExperimentDataResponse>
  WriteTensorboardExperimentData(
      google::cloud::aiplatform::v1::
          WriteTensorboardExperimentDataRequest const& request,
      Options opts = {});

  // clang-format off
  ///
  /// Write time series data points into multiple TensorboardTimeSeries under
  /// a TensorboardRun. If any data fail to be ingested, an error is returned.
  ///
  /// @param tensorboard_run  Required. The resource name of the TensorboardRun to write data to.
  ///  Format:
  ///  `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}`
  /// @param time_series_data  Required. The TensorboardTimeSeries data to write.
  ///  Values with in a time series are indexed by their step value.
  ///  Repeated writes to the same step will overwrite the existing value for that
  ///  step.
  ///  The upper limit of data points per write request is 5000.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.WriteTensorboardRunDataResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.WriteTensorboardRunDataRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L1081}
  /// [google.cloud.aiplatform.v1.WriteTensorboardRunDataResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L1103}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::WriteTensorboardRunDataResponse>
  WriteTensorboardRunData(
      std::string const& tensorboard_run,
      std::vector<google::cloud::aiplatform::v1::TimeSeriesData> const&
          time_series_data,
      Options opts = {});

  // clang-format off
  ///
  /// Write time series data points into multiple TensorboardTimeSeries under
  /// a TensorboardRun. If any data fail to be ingested, an error is returned.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.WriteTensorboardRunDataRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return the result of the RPC. The response message type
  ///     ([google.cloud.aiplatform.v1.WriteTensorboardRunDataResponse])
  ///     is mapped to a C++ class using the [Protobuf mapping rules].
  ///     If the request fails, the [`StatusOr`] contains the error details.
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.WriteTensorboardRunDataRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L1081}
  /// [google.cloud.aiplatform.v1.WriteTensorboardRunDataResponse]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L1103}
  ///
  // clang-format on
  StatusOr<google::cloud::aiplatform::v1::WriteTensorboardRunDataResponse>
  WriteTensorboardRunData(
      google::cloud::aiplatform::v1::WriteTensorboardRunDataRequest const&
          request,
      Options opts = {});

  // clang-format off
  ///
  /// Exports a TensorboardTimeSeries' data. Data is returned in paginated
  /// responses.
  ///
  /// @param tensorboard_time_series  Required. The resource name of the TensorboardTimeSeries to export data
  ///  from. Format:
  ///  `projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}/runs/{run}/timeSeries/{time_series}`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.TimeSeriesDataPoint], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ExportTensorboardTimeSeriesDataRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L1107}
  /// [google.cloud.aiplatform.v1.TimeSeriesDataPoint]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_data.proto#L51}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::TimeSeriesDataPoint>
  ExportTensorboardTimeSeriesData(std::string const& tensorboard_time_series,
                                  Options opts = {});

  // clang-format off
  ///
  /// Exports a TensorboardTimeSeries' data. Data is returned in paginated
  /// responses.
  ///
  /// @param request Unary RPCs, such as the one wrapped by this
  ///     function, receive a single `request` proto message which includes all
  ///     the inputs for the RPC. In this case, the proto message is a
  ///     [google.cloud.aiplatform.v1.ExportTensorboardTimeSeriesDataRequest].
  ///     Proto messages are converted to C++ classes by Protobuf, using the
  ///     [Protobuf mapping rules].
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return a [StreamRange](@ref google::cloud::StreamRange)
  ///     to iterate of the results. See the documentation of this type for
  ///     details. In brief, this class has `begin()` and `end()` member
  ///     functions returning a iterator class meeting the
  ///     [input iterator requirements]. The value type for this iterator is a
  ///     [`StatusOr`] as the iteration may fail even after some values are
  ///     retrieved successfully, for example, if there is a network disconnect.
  ///     An empty set of results does not indicate an error, it indicates
  ///     that there are no resources meeting the request criteria.
  ///     On a successful iteration the `StatusOr<T>` contains elements of type
  ///     [google.cloud.aiplatform.v1.TimeSeriesDataPoint], or rather,
  ///     the C++ class generated by Protobuf from that type. Please consult the
  ///     Protobuf documentation for details on the [Protobuf mapping rules].
  ///
  /// [Protobuf mapping rules]: https://protobuf.dev/reference/cpp/cpp-generated/
  /// [input iterator requirements]: https://en.cppreference.com/w/cpp/named_req/InputIterator
  /// [`std::string`]: https://en.cppreference.com/w/cpp/string/basic_string
  /// [`future`]: @ref google::cloud::future
  /// [`StatusOr`]: @ref google::cloud::StatusOr
  /// [`Status`]: @ref google::cloud::Status
  /// [google.cloud.aiplatform.v1.ExportTensorboardTimeSeriesDataRequest]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_service.proto#L1107}
  /// [google.cloud.aiplatform.v1.TimeSeriesDataPoint]: @googleapis_reference_link{google/cloud/aiplatform/v1/tensorboard_data.proto#L51}
  ///
  // clang-format on
  StreamRange<google::cloud::aiplatform::v1::TimeSeriesDataPoint>
  ExportTensorboardTimeSeriesData(
      google::cloud::aiplatform::v1::ExportTensorboardTimeSeriesDataRequest
          request,
      Options opts = {});

 private:
  std::shared_ptr<TensorboardServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_TENSORBOARD_CLIENT_H
