// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/aiplatform/v1/featurestore_online_service.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_FEATURESTORE_ONLINE_SERVING_LOGGING_DECORATOR_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_FEATURESTORE_ONLINE_SERVING_LOGGING_DECORATOR_H

#include "google/cloud/aiplatform/v1/internal/featurestore_online_serving_stub.h"
#include "google/cloud/tracing_options.h"
#include "google/cloud/version.h"
#include <memory>
#include <set>
#include <string>

namespace google {
namespace cloud {
namespace aiplatform_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class FeaturestoreOnlineServingServiceLogging
    : public FeaturestoreOnlineServingServiceStub {
 public:
  ~FeaturestoreOnlineServingServiceLogging() override = default;
  FeaturestoreOnlineServingServiceLogging(
      std::shared_ptr<FeaturestoreOnlineServingServiceStub> child,
      TracingOptions tracing_options, std::set<std::string> const& components);

  StatusOr<google::cloud::aiplatform::v1::ReadFeatureValuesResponse>
  ReadFeatureValues(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::ReadFeatureValuesRequest const& request)
      override;

  std::unique_ptr<google::cloud::internal::StreamingReadRpc<
      google::cloud::aiplatform::v1::ReadFeatureValuesResponse>>
  StreamingReadFeatureValues(
      std::shared_ptr<grpc::ClientContext> context, Options const& options,
      google::cloud::aiplatform::v1::StreamingReadFeatureValuesRequest const&
          request) override;

  StatusOr<google::cloud::aiplatform::v1::WriteFeatureValuesResponse>
  WriteFeatureValues(
      grpc::ClientContext& context, Options const& options,
      google::cloud::aiplatform::v1::WriteFeatureValuesRequest const& request)
      override;

 private:
  std::shared_ptr<FeaturestoreOnlineServingServiceStub> child_;
  TracingOptions tracing_options_;
  bool stream_logging_;
};  // FeaturestoreOnlineServingServiceLogging

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace aiplatform_v1_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_AIPLATFORM_V1_INTERNAL_FEATURESTORE_ONLINE_SERVING_LOGGING_DECORATOR_H
