# Send alerts when CI builds fail

This notifier listens for failed builds (ignoring PR and manual builds) and
sends alerts as Google Chat messages to the webhook URL specified by the
`GCB_BUILD_ALERT_WEBHOOK` environment variable. This variable is injected from
Secret Manager.

## Prerequisites

Verify the [docker tool][docker] is functional on your workstation:

```shell
docker run hello-world
# Output: Hello from Docker! and then some more informational messages.
```

## Build and deploy

The steps to build and deploy this notifier are in the `deploy.sh` script. You
can read that for details or just run it.

```shell
deploy.sh
```

## One-time setup: Set the `GCB_*BUILD_ALERT_WEBHOOK` secrets

Note: This command only needs to be run once. It is here in case we ever move
the build to a different project.

Go to Secret Manager and create a secret named `GCB_BUILD_ALERT_WEBHOOK`. Set
its value to the Webhook URL for the Google Chat room of your choice.

Go to Secret Manager and create a secret named
`GCB_FRIENDS_BUILD_ALERT_WEBHOOK`. Set its value to the Webhook URL for the
Google Chat room of your choice.

Then go to Cloud Run in the UI and edit this deployment. There will be a
"Variables & Secrets" tab. On there you can configure this secret to be injected
into the job's environment.

## One-time setup: Set up a trigger

Note: This command only needs to be run once. It is here in case we ever move
the build to a different project.

Deployments in Cloud Run are (basically) http servers, a trigger converts the
Cloud Pub/Sub messages generated by Cloud Build into events that can be consumed
by the deployment. Note that this is the step where we specify the
`cloud-builds` topic as a source of these events.

```shell
gcloud beta eventarc triggers create send-build-alerts-trigger \
    --project="$GOOGLE_CLOUD_PROJECT" \
    --location="us-central1" \
    --destination-run-service="send-build-alerts" \
    --destination-run-region="us-central1" \
    --transport-topic="cloud-builds" \
    --matching-criteria="type=google.cloud.pubsub.topic.v1.messagePublished" \
    --service-account="$PROJECT_NUMBER-compute@developer.gserviceaccount.com"
```

[docker]: https://docker.com/
