package storsimple

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AlertEmailNotificationStatus enumerates the values for alert email notification status.
type AlertEmailNotificationStatus string

const (
	// Disabled ...
	Disabled AlertEmailNotificationStatus = "Disabled"
	// Enabled ...
	Enabled AlertEmailNotificationStatus = "Enabled"
)

// PossibleAlertEmailNotificationStatusValues returns an array of possible values for the AlertEmailNotificationStatus const type.
func PossibleAlertEmailNotificationStatusValues() []AlertEmailNotificationStatus {
	return []AlertEmailNotificationStatus{Disabled, Enabled}
}

// AlertScope enumerates the values for alert scope.
type AlertScope string

const (
	// AlertScopeDevice ...
	AlertScopeDevice AlertScope = "Device"
	// AlertScopeResource ...
	AlertScopeResource AlertScope = "Resource"
)

// PossibleAlertScopeValues returns an array of possible values for the AlertScope const type.
func PossibleAlertScopeValues() []AlertScope {
	return []AlertScope{AlertScopeDevice, AlertScopeResource}
}

// AlertSeverity enumerates the values for alert severity.
type AlertSeverity string

const (
	// Critical ...
	Critical AlertSeverity = "Critical"
	// Informational ...
	Informational AlertSeverity = "Informational"
	// Warning ...
	Warning AlertSeverity = "Warning"
)

// PossibleAlertSeverityValues returns an array of possible values for the AlertSeverity const type.
func PossibleAlertSeverityValues() []AlertSeverity {
	return []AlertSeverity{Critical, Informational, Warning}
}

// AlertSourceType enumerates the values for alert source type.
type AlertSourceType string

const (
	// AlertSourceTypeDevice ...
	AlertSourceTypeDevice AlertSourceType = "Device"
	// AlertSourceTypeResource ...
	AlertSourceTypeResource AlertSourceType = "Resource"
)

// PossibleAlertSourceTypeValues returns an array of possible values for the AlertSourceType const type.
func PossibleAlertSourceTypeValues() []AlertSourceType {
	return []AlertSourceType{AlertSourceTypeDevice, AlertSourceTypeResource}
}

// AlertStatus enumerates the values for alert status.
type AlertStatus string

const (
	// Active ...
	Active AlertStatus = "Active"
	// Cleared ...
	Cleared AlertStatus = "Cleared"
)

// PossibleAlertStatusValues returns an array of possible values for the AlertStatus const type.
func PossibleAlertStatusValues() []AlertStatus {
	return []AlertStatus{Active, Cleared}
}

// AuthType enumerates the values for auth type.
type AuthType string

const (
	// AccessControlService ...
	AccessControlService AuthType = "AccessControlService"
	// AzureActiveDirectory ...
	AzureActiveDirectory AuthType = "AzureActiveDirectory"
	// Invalid ...
	Invalid AuthType = "Invalid"
)

// PossibleAuthTypeValues returns an array of possible values for the AuthType const type.
func PossibleAuthTypeValues() []AuthType {
	return []AuthType{AccessControlService, AzureActiveDirectory, Invalid}
}

// CloudType enumerates the values for cloud type.
type CloudType string

const (
	// Azure ...
	Azure CloudType = "Azure"
	// HP ...
	HP CloudType = "HP"
	// OpenStack ...
	OpenStack CloudType = "OpenStack"
	// S3 ...
	S3 CloudType = "S3"
	// S3RRS ...
	S3RRS CloudType = "S3_RRS"
)

// PossibleCloudTypeValues returns an array of possible values for the CloudType const type.
func PossibleCloudTypeValues() []CloudType {
	return []CloudType{Azure, HP, OpenStack, S3, S3RRS}
}

// ContractVersions enumerates the values for contract versions.
type ContractVersions string

const (
	// InvalidVersion ...
	InvalidVersion ContractVersions = "InvalidVersion"
	// V201109 ...
	V201109 ContractVersions = "V2011_09"
	// V201202 ...
	V201202 ContractVersions = "V2012_02"
	// V201205 ...
	V201205 ContractVersions = "V2012_05"
	// V201212 ...
	V201212 ContractVersions = "V2012_12"
	// V201304 ...
	V201304 ContractVersions = "V2013_04"
	// V201310 ...
	V201310 ContractVersions = "V2013_10"
	// V201311 ...
	V201311 ContractVersions = "V2013_11"
	// V201404 ...
	V201404 ContractVersions = "V2014_04"
	// V201406 ...
	V201406 ContractVersions = "V2014_06"
	// V201407 ...
	V201407 ContractVersions = "V2014_07"
	// V201409 ...
	V201409 ContractVersions = "V2014_09"
	// V201410 ...
	V201410 ContractVersions = "V2014_10"
	// V201412 ...
	V201412 ContractVersions = "V2014_12"
	// V201501 ...
	V201501 ContractVersions = "V2015_01"
	// V201502 ...
	V201502 ContractVersions = "V2015_02"
	// V201504 ...
	V201504 ContractVersions = "V2015_04"
	// V201505 ...
	V201505 ContractVersions = "V2015_05"
	// V201506 ...
	V201506 ContractVersions = "V2015_06"
	// V201507 ...
	V201507 ContractVersions = "V2015_07"
	// V201508 ...
	V201508 ContractVersions = "V2015_08"
	// V201510 ...
	V201510 ContractVersions = "V2015_10"
	// V201512 ...
	V201512 ContractVersions = "V2015_12"
	// V201601 ...
	V201601 ContractVersions = "V2016_01"
	// V201602 ...
	V201602 ContractVersions = "V2016_02"
	// V201604 ...
	V201604 ContractVersions = "V2016_04"
	// V201605 ...
	V201605 ContractVersions = "V2016_05"
	// V201607 ...
	V201607 ContractVersions = "V2016_07"
	// V201608 ...
	V201608 ContractVersions = "V2016_08"
)

// PossibleContractVersionsValues returns an array of possible values for the ContractVersions const type.
func PossibleContractVersionsValues() []ContractVersions {
	return []ContractVersions{InvalidVersion, V201109, V201202, V201205, V201212, V201304, V201310, V201311, V201404, V201406, V201407, V201409, V201410, V201412, V201501, V201502, V201504, V201505, V201506, V201507, V201508, V201510, V201512, V201601, V201602, V201604, V201605, V201607, V201608}
}

// DataPolicy enumerates the values for data policy.
type DataPolicy string

const (
	// DataPolicyCloud ...
	DataPolicyCloud DataPolicy = "Cloud"
	// DataPolicyInvalid ...
	DataPolicyInvalid DataPolicy = "Invalid"
	// DataPolicyLocal ...
	DataPolicyLocal DataPolicy = "Local"
	// DataPolicyTiered ...
	DataPolicyTiered DataPolicy = "Tiered"
)

// PossibleDataPolicyValues returns an array of possible values for the DataPolicy const type.
func PossibleDataPolicyValues() []DataPolicy {
	return []DataPolicy{DataPolicyCloud, DataPolicyInvalid, DataPolicyLocal, DataPolicyTiered}
}

// DeviceConfigurationStatus enumerates the values for device configuration status.
type DeviceConfigurationStatus string

const (
	// Complete ...
	Complete DeviceConfigurationStatus = "Complete"
	// Pending ...
	Pending DeviceConfigurationStatus = "Pending"
)

// PossibleDeviceConfigurationStatusValues returns an array of possible values for the DeviceConfigurationStatus const type.
func PossibleDeviceConfigurationStatusValues() []DeviceConfigurationStatus {
	return []DeviceConfigurationStatus{Complete, Pending}
}

// DeviceOperation enumerates the values for device operation.
type DeviceOperation string

const (
	// Browsable ...
	Browsable DeviceOperation = "Browsable"
	// Deactivate ...
	Deactivate DeviceOperation = "Deactivate"
	// Delete ...
	Delete DeviceOperation = "Delete"
	// DeleteWithWarning ...
	DeleteWithWarning DeviceOperation = "DeleteWithWarning"
	// DRSource ...
	DRSource DeviceOperation = "DRSource"
	// DRTarget ...
	DRTarget DeviceOperation = "DRTarget"
	// None ...
	None DeviceOperation = "None"
	// ReadOnlyForDR ...
	ReadOnlyForDR DeviceOperation = "ReadOnlyForDR"
)

// PossibleDeviceOperationValues returns an array of possible values for the DeviceOperation const type.
func PossibleDeviceOperationValues() []DeviceOperation {
	return []DeviceOperation{Browsable, Deactivate, Delete, DeleteWithWarning, DRSource, DRTarget, None, ReadOnlyForDR}
}

// DeviceStatus enumerates the values for device status.
type DeviceStatus string

const (
	// Creating ...
	Creating DeviceStatus = "Creating"
	// Deactivated ...
	Deactivated DeviceStatus = "Deactivated"
	// Deactivating ...
	Deactivating DeviceStatus = "Deactivating"
	// Deleted ...
	Deleted DeviceStatus = "Deleted"
	// MaintenanceMode ...
	MaintenanceMode DeviceStatus = "MaintenanceMode"
	// Offline ...
	Offline DeviceStatus = "Offline"
	// Online ...
	Online DeviceStatus = "Online"
	// Provisioning ...
	Provisioning DeviceStatus = "Provisioning"
	// ReadyToSetup ...
	ReadyToSetup DeviceStatus = "ReadyToSetup"
	// RequiresAttention ...
	RequiresAttention DeviceStatus = "RequiresAttention"
	// Unknown ...
	Unknown DeviceStatus = "Unknown"
)

// PossibleDeviceStatusValues returns an array of possible values for the DeviceStatus const type.
func PossibleDeviceStatusValues() []DeviceStatus {
	return []DeviceStatus{Creating, Deactivated, Deactivating, Deleted, MaintenanceMode, Offline, Online, Provisioning, ReadyToSetup, RequiresAttention, Unknown}
}

// DeviceType enumerates the values for device type.
type DeviceType string

const (
	// DeviceTypeAppliance ...
	DeviceTypeAppliance DeviceType = "Appliance"
	// DeviceTypeInvalid ...
	DeviceTypeInvalid DeviceType = "Invalid"
	// DeviceTypeSeries9000OnPremVirtualAppliance ...
	DeviceTypeSeries9000OnPremVirtualAppliance DeviceType = "Series9000OnPremVirtualAppliance"
	// DeviceTypeSeries9000PhysicalAppliance ...
	DeviceTypeSeries9000PhysicalAppliance DeviceType = "Series9000PhysicalAppliance"
	// DeviceTypeSeries9000VirtualAppliance ...
	DeviceTypeSeries9000VirtualAppliance DeviceType = "Series9000VirtualAppliance"
	// DeviceTypeVirtualAppliance ...
	DeviceTypeVirtualAppliance DeviceType = "VirtualAppliance"
)

// PossibleDeviceTypeValues returns an array of possible values for the DeviceType const type.
func PossibleDeviceTypeValues() []DeviceType {
	return []DeviceType{DeviceTypeAppliance, DeviceTypeInvalid, DeviceTypeSeries9000OnPremVirtualAppliance, DeviceTypeSeries9000PhysicalAppliance, DeviceTypeSeries9000VirtualAppliance, DeviceTypeVirtualAppliance}
}

// DhcpStatus enumerates the values for dhcp status.
type DhcpStatus string

const (
	// DhcpStatusDisabled ...
	DhcpStatusDisabled DhcpStatus = "Disabled"
	// DhcpStatusEnabled ...
	DhcpStatusEnabled DhcpStatus = "Enabled"
)

// PossibleDhcpStatusValues returns an array of possible values for the DhcpStatus const type.
func PossibleDhcpStatusValues() []DhcpStatus {
	return []DhcpStatus{DhcpStatusDisabled, DhcpStatusEnabled}
}

// DiskStatus enumerates the values for disk status.
type DiskStatus string

const (
	// DiskStatusOffline ...
	DiskStatusOffline DiskStatus = "Offline"
	// DiskStatusOnline ...
	DiskStatusOnline DiskStatus = "Online"
)

// PossibleDiskStatusValues returns an array of possible values for the DiskStatus const type.
func PossibleDiskStatusValues() []DiskStatus {
	return []DiskStatus{DiskStatusOffline, DiskStatusOnline}
}

// DownloadPhase enumerates the values for download phase.
type DownloadPhase string

const (
	// DownloadPhaseDownloading ...
	DownloadPhaseDownloading DownloadPhase = "Downloading"
	// DownloadPhaseInitializing ...
	DownloadPhaseInitializing DownloadPhase = "Initializing"
	// DownloadPhaseUnknown ...
	DownloadPhaseUnknown DownloadPhase = "Unknown"
	// DownloadPhaseVerifying ...
	DownloadPhaseVerifying DownloadPhase = "Verifying"
)

// PossibleDownloadPhaseValues returns an array of possible values for the DownloadPhase const type.
func PossibleDownloadPhaseValues() []DownloadPhase {
	return []DownloadPhase{DownloadPhaseDownloading, DownloadPhaseInitializing, DownloadPhaseUnknown, DownloadPhaseVerifying}
}

// EncryptionAlgorithm enumerates the values for encryption algorithm.
type EncryptionAlgorithm string

const (
	// EncryptionAlgorithmAES256 ...
	EncryptionAlgorithmAES256 EncryptionAlgorithm = "AES256"
	// EncryptionAlgorithmNone ...
	EncryptionAlgorithmNone EncryptionAlgorithm = "None"
	// EncryptionAlgorithmRSAESPKCS1V15 ...
	EncryptionAlgorithmRSAESPKCS1V15 EncryptionAlgorithm = "RSAES_PKCS1_v_1_5"
)

// PossibleEncryptionAlgorithmValues returns an array of possible values for the EncryptionAlgorithm const type.
func PossibleEncryptionAlgorithmValues() []EncryptionAlgorithm {
	return []EncryptionAlgorithm{EncryptionAlgorithmAES256, EncryptionAlgorithmNone, EncryptionAlgorithmRSAESPKCS1V15}
}

// EncryptionStatus enumerates the values for encryption status.
type EncryptionStatus string

const (
	// EncryptionStatusDisabled ...
	EncryptionStatusDisabled EncryptionStatus = "Disabled"
	// EncryptionStatusEnabled ...
	EncryptionStatusEnabled EncryptionStatus = "Enabled"
)

// PossibleEncryptionStatusValues returns an array of possible values for the EncryptionStatus const type.
func PossibleEncryptionStatusValues() []EncryptionStatus {
	return []EncryptionStatus{EncryptionStatusDisabled, EncryptionStatusEnabled}
}

// InitiatedBy enumerates the values for initiated by.
type InitiatedBy string

const (
	// Manual ...
	Manual InitiatedBy = "Manual"
	// Scheduled ...
	Scheduled InitiatedBy = "Scheduled"
)

// PossibleInitiatedByValues returns an array of possible values for the InitiatedBy const type.
func PossibleInitiatedByValues() []InitiatedBy {
	return []InitiatedBy{Manual, Scheduled}
}

// JobStatus enumerates the values for job status.
type JobStatus string

const (
	// JobStatusCanceled ...
	JobStatusCanceled JobStatus = "Canceled"
	// JobStatusFailed ...
	JobStatusFailed JobStatus = "Failed"
	// JobStatusInvalid ...
	JobStatusInvalid JobStatus = "Invalid"
	// JobStatusPaused ...
	JobStatusPaused JobStatus = "Paused"
	// JobStatusRunning ...
	JobStatusRunning JobStatus = "Running"
	// JobStatusScheduled ...
	JobStatusScheduled JobStatus = "Scheduled"
	// JobStatusSucceeded ...
	JobStatusSucceeded JobStatus = "Succeeded"
)

// PossibleJobStatusValues returns an array of possible values for the JobStatus const type.
func PossibleJobStatusValues() []JobStatus {
	return []JobStatus{JobStatusCanceled, JobStatusFailed, JobStatusInvalid, JobStatusPaused, JobStatusRunning, JobStatusScheduled, JobStatusSucceeded}
}

// JobType enumerates the values for job type.
type JobType string

const (
	// JobTypeBackup ...
	JobTypeBackup JobType = "Backup"
	// JobTypeClone ...
	JobTypeClone JobType = "Clone"
	// JobTypeDownloadUpdates ...
	JobTypeDownloadUpdates JobType = "DownloadUpdates"
	// JobTypeFailover ...
	JobTypeFailover JobType = "Failover"
	// JobTypeInstallUpdates ...
	JobTypeInstallUpdates JobType = "InstallUpdates"
)

// PossibleJobTypeValues returns an array of possible values for the JobType const type.
func PossibleJobTypeValues() []JobType {
	return []JobType{JobTypeBackup, JobTypeClone, JobTypeDownloadUpdates, JobTypeFailover, JobTypeInstallUpdates}
}

// KeyRolloverStatus enumerates the values for key rollover status.
type KeyRolloverStatus string

const (
	// NotRequired ...
	NotRequired KeyRolloverStatus = "NotRequired"
	// Required ...
	Required KeyRolloverStatus = "Required"
)

// PossibleKeyRolloverStatusValues returns an array of possible values for the KeyRolloverStatus const type.
func PossibleKeyRolloverStatusValues() []KeyRolloverStatus {
	return []KeyRolloverStatus{NotRequired, Required}
}

// ManagerType enumerates the values for manager type.
type ManagerType string

const (
	// GardaV1 ...
	GardaV1 ManagerType = "GardaV1"
	// HelsinkiV1 ...
	HelsinkiV1 ManagerType = "HelsinkiV1"
)

// PossibleManagerTypeValues returns an array of possible values for the ManagerType const type.
func PossibleManagerTypeValues() []ManagerType {
	return []ManagerType{GardaV1, HelsinkiV1}
}

// MetricAggregationType enumerates the values for metric aggregation type.
type MetricAggregationType string

const (
	// MetricAggregationTypeAverage ...
	MetricAggregationTypeAverage MetricAggregationType = "Average"
	// MetricAggregationTypeLast ...
	MetricAggregationTypeLast MetricAggregationType = "Last"
	// MetricAggregationTypeMaximum ...
	MetricAggregationTypeMaximum MetricAggregationType = "Maximum"
	// MetricAggregationTypeMinimum ...
	MetricAggregationTypeMinimum MetricAggregationType = "Minimum"
	// MetricAggregationTypeNone ...
	MetricAggregationTypeNone MetricAggregationType = "None"
	// MetricAggregationTypeTotal ...
	MetricAggregationTypeTotal MetricAggregationType = "Total"
)

// PossibleMetricAggregationTypeValues returns an array of possible values for the MetricAggregationType const type.
func PossibleMetricAggregationTypeValues() []MetricAggregationType {
	return []MetricAggregationType{MetricAggregationTypeAverage, MetricAggregationTypeLast, MetricAggregationTypeMaximum, MetricAggregationTypeMinimum, MetricAggregationTypeNone, MetricAggregationTypeTotal}
}

// MetricUnit enumerates the values for metric unit.
type MetricUnit string

const (
	// Bytes ...
	Bytes MetricUnit = "Bytes"
	// BytesPerSecond ...
	BytesPerSecond MetricUnit = "BytesPerSecond"
	// Count ...
	Count MetricUnit = "Count"
	// CountPerSecond ...
	CountPerSecond MetricUnit = "CountPerSecond"
	// Percent ...
	Percent MetricUnit = "Percent"
	// Seconds ...
	Seconds MetricUnit = "Seconds"
)

// PossibleMetricUnitValues returns an array of possible values for the MetricUnit const type.
func PossibleMetricUnitValues() []MetricUnit {
	return []MetricUnit{Bytes, BytesPerSecond, Count, CountPerSecond, Percent, Seconds}
}

// MonitoringStatus enumerates the values for monitoring status.
type MonitoringStatus string

const (
	// MonitoringStatusDisabled ...
	MonitoringStatusDisabled MonitoringStatus = "Disabled"
	// MonitoringStatusEnabled ...
	MonitoringStatusEnabled MonitoringStatus = "Enabled"
)

// PossibleMonitoringStatusValues returns an array of possible values for the MonitoringStatus const type.
func PossibleMonitoringStatusValues() []MonitoringStatus {
	return []MonitoringStatus{MonitoringStatusDisabled, MonitoringStatusEnabled}
}

// ServiceOwnersAlertNotificationStatus enumerates the values for service owners alert notification status.
type ServiceOwnersAlertNotificationStatus string

const (
	// ServiceOwnersAlertNotificationStatusDisabled ...
	ServiceOwnersAlertNotificationStatusDisabled ServiceOwnersAlertNotificationStatus = "Disabled"
	// ServiceOwnersAlertNotificationStatusEnabled ...
	ServiceOwnersAlertNotificationStatusEnabled ServiceOwnersAlertNotificationStatus = "Enabled"
)

// PossibleServiceOwnersAlertNotificationStatusValues returns an array of possible values for the ServiceOwnersAlertNotificationStatus const type.
func PossibleServiceOwnersAlertNotificationStatusValues() []ServiceOwnersAlertNotificationStatus {
	return []ServiceOwnersAlertNotificationStatus{ServiceOwnersAlertNotificationStatusDisabled, ServiceOwnersAlertNotificationStatusEnabled}
}

// ShareStatus enumerates the values for share status.
type ShareStatus string

const (
	// ShareStatusOffline ...
	ShareStatusOffline ShareStatus = "Offline"
	// ShareStatusOnline ...
	ShareStatusOnline ShareStatus = "Online"
)

// PossibleShareStatusValues returns an array of possible values for the ShareStatus const type.
func PossibleShareStatusValues() []ShareStatus {
	return []ShareStatus{ShareStatusOffline, ShareStatusOnline}
}

// SslStatus enumerates the values for ssl status.
type SslStatus string

const (
	// SslStatusDisabled ...
	SslStatusDisabled SslStatus = "Disabled"
	// SslStatusEnabled ...
	SslStatusEnabled SslStatus = "Enabled"
)

// PossibleSslStatusValues returns an array of possible values for the SslStatus const type.
func PossibleSslStatusValues() []SslStatus {
	return []SslStatus{SslStatusDisabled, SslStatusEnabled}
}

// SupportedDeviceCapabilities enumerates the values for supported device capabilities.
type SupportedDeviceCapabilities string

const (
	// SupportedDeviceCapabilitiesFileServer ...
	SupportedDeviceCapabilitiesFileServer SupportedDeviceCapabilities = "FileServer"
	// SupportedDeviceCapabilitiesInvalid ...
	SupportedDeviceCapabilitiesInvalid SupportedDeviceCapabilities = "Invalid"
	// SupportedDeviceCapabilitiesIscsiServer ...
	SupportedDeviceCapabilitiesIscsiServer SupportedDeviceCapabilities = "IscsiServer"
)

// PossibleSupportedDeviceCapabilitiesValues returns an array of possible values for the SupportedDeviceCapabilities const type.
func PossibleSupportedDeviceCapabilitiesValues() []SupportedDeviceCapabilities {
	return []SupportedDeviceCapabilities{SupportedDeviceCapabilitiesFileServer, SupportedDeviceCapabilitiesInvalid, SupportedDeviceCapabilitiesIscsiServer}
}

// TargetType enumerates the values for target type.
type TargetType string

const (
	// TargetTypeDiskServer ...
	TargetTypeDiskServer TargetType = "DiskServer"
	// TargetTypeFileServer ...
	TargetTypeFileServer TargetType = "FileServer"
)

// PossibleTargetTypeValues returns an array of possible values for the TargetType const type.
func PossibleTargetTypeValues() []TargetType {
	return []TargetType{TargetTypeDiskServer, TargetTypeFileServer}
}

// UpdateOperation enumerates the values for update operation.
type UpdateOperation string

const (
	// Downloading ...
	Downloading UpdateOperation = "Downloading"
	// Idle ...
	Idle UpdateOperation = "Idle"
	// Installing ...
	Installing UpdateOperation = "Installing"
	// Scanning ...
	Scanning UpdateOperation = "Scanning"
)

// PossibleUpdateOperationValues returns an array of possible values for the UpdateOperation const type.
func PossibleUpdateOperationValues() []UpdateOperation {
	return []UpdateOperation{Downloading, Idle, Installing, Scanning}
}
