/*
 *  Copyright (C) 2005-2007 Renier Roth
 *  www.renier.de
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package de.renier.vdr.channel.editor.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.util.Enumeration;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;

import de.renier.vdr.channel.Channel;
import de.renier.vdr.channel.editor.ChannelEditor;
import de.renier.vdr.channel.editor.Messages;
import de.renier.vdr.channel.editor.util.Utils;

/**
 * ExportAliasAction
 * 
 * @author <a href="mailto:editor@renier.de">Renier Roth</a>
 */
public class ExportAliasAction extends AbstractAction {

  private static final long serialVersionUID = -1971749169917356554L;

  public ExportAliasAction() {
    super(Messages.getString("ExportAliasAction.0"), new ImageIcon(ExportAliasAction.class //$NON-NLS-1$
        .getResource("/org/javalobby/icons/20x20/DocumentOut.gif"))); //$NON-NLS-1$
  }

  /*
   * (non-Javadoc)
   * 
   * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
   */
  public void actionPerformed(ActionEvent e) {
    File saveFile = null;
    try {
      final JFileChooser fc = new JFileChooser();
      int ret = fc.showSaveDialog(ChannelEditor.application);
      if (ret == JFileChooser.APPROVE_OPTION) {
        saveFile = fc.getSelectedFile();
        // check if file exist
        if (saveFile.exists()) {
          // dialogbox to warn unsaved data
          int result = JOptionPane.showConfirmDialog(ChannelEditor.application, Messages.getString("ExportAliasAction.2") + saveFile.getPath() //$NON-NLS-1$
              + Messages.getString("ExportAliasAction.3"), //$NON-NLS-1$
                                                     Messages.getString("ExportAliasAction.4"), JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE); //$NON-NLS-1$
          if (result == JOptionPane.NO_OPTION) { return; }
        }
        // open output file
        FileWriter outFile = new FileWriter(saveFile);
        // traverse through tree and get id/alias
        DefaultMutableTreeNode rootNode = ChannelEditor.application.getChannelListingPanel().getRootNode();
        Enumeration enumer = rootNode.preorderEnumeration();
        int counter = 0;
        while (enumer.hasMoreElements()) {
          DefaultMutableTreeNode mutableNode = (DefaultMutableTreeNode) enumer.nextElement();
          if (mutableNode.getUserObject() instanceof Channel) {
            Channel channel = (Channel) mutableNode.getUserObject();
            // get id and alias from channel
            String outString = channel.getId() + ":" //$NON-NLS-1$
                + (Utils.isEmpty(channel.getAlias()) ? channel.getNameOnly() : channel.getAlias()) + (char) 10;
            outFile.write(outString);
            counter++;
          }
        }
        // close file
        outFile.flush();
        outFile.close();
        // info output
        JOptionPane.showMessageDialog(ChannelEditor.application, Messages.getString("ExportAliasAction.6") + counter //$NON-NLS-1$
            + Messages.getString("ExportAliasAction.7")); //$NON-NLS-1$
      }
    } catch (Exception ioe) {
      JOptionPane.showConfirmDialog(ChannelEditor.application,
                                    Messages.getString("ExportAliasAction.8") + saveFile != null ? saveFile.getPath() : "" //$NON-NLS-1$ //$NON-NLS-2$
                                        + Messages.getString("ExportAliasAction.10") + ioe.getMessage(), Messages.getString("ExportAliasAction.11"), JOptionPane.CLOSED_OPTION, //$NON-NLS-1$ //$NON-NLS-2$
                                    JOptionPane.ERROR_MESSAGE);
      ioe.printStackTrace();
    }
  }

}
