#! /bin/sh

# Guess values for system-dependent variables and create Makefiles.
# Generated automatically using autoconf version 2.13 
# Copyright (C) 1992, 93, 94, 95, 96 Free Software Foundation, Inc.
#
# This configure script is free software; the Free Software Foundation
# gives unlimited permission to copy, distribute and modify it.

# Defaults:
ac_help=
ac_default_prefix=/usr/local
# Any additions from configure.in:
ac_help="$ac_help
  --disable-ccdv          disable use of ccdv program in Makefiles"
ac_help="$ac_help
  --without-curses        do not try to find and use the curses library"
ac_help="$ac_help
  --enable-debug          enable debugging symbols"
ac_help="$ac_help
  --without-ncurses       do not try to find and use the ncurses library"
ac_help="$ac_help
  --disable-precomp       disable use of precompiled header files"
ac_help="$ac_help
  --with-socks5           try to find and use the SOCKS5 library"
ac_help="$ac_help
  --enable-ssp            use stack smashing protection if available"
ac_help="$ac_help
  --disable-universal     disable production of universal binaries on Mac OS X"
ac_help="$ac_help
  --with-dnssec-local-validation Enable local DNSSEC validation using libval (no)"

# Initialize some variables set by options.
# The variables have the same names as the options, with
# dashes changed to underlines.
build=NONE
cache_file=./config.cache
exec_prefix=NONE
host=NONE
no_create=
nonopt=NONE
no_recursion=
prefix=NONE
program_prefix=NONE
program_suffix=NONE
program_transform_name=s,x,x,
silent=
site=
srcdir=
target=NONE
verbose=
x_includes=NONE
x_libraries=NONE
bindir='${exec_prefix}/bin'
sbindir='${exec_prefix}/sbin'
libexecdir='${exec_prefix}/libexec'
datadir='${prefix}/share'
sysconfdir='${prefix}/etc'
sharedstatedir='${prefix}/com'
localstatedir='${prefix}/var'
libdir='${exec_prefix}/lib'
includedir='${prefix}/include'
oldincludedir='/usr/include'
infodir='${prefix}/info'
mandir='${prefix}/man'

# Initialize some other variables.
subdirs=
MFLAGS= MAKEFLAGS=
SHELL=${CONFIG_SHELL-/bin/sh}
# Maximum number of lines to put in a shell here document.
ac_max_here_lines=12

ac_prev=
for ac_option
do

  # If the previous option needs an argument, assign it.
  if test -n "$ac_prev"; then
    eval "$ac_prev=\$ac_option"
    ac_prev=
    continue
  fi

  case "$ac_option" in
  -*=*) ac_optarg=`echo "$ac_option" | sed 's/[-_a-zA-Z0-9]*=//'` ;;
  *) ac_optarg= ;;
  esac

  # Accept the important Cygnus configure options, so we can diagnose typos.

  case "$ac_option" in

  -bindir | --bindir | --bindi | --bind | --bin | --bi)
    ac_prev=bindir ;;
  -bindir=* | --bindir=* | --bindi=* | --bind=* | --bin=* | --bi=*)
    bindir="$ac_optarg" ;;

  -build | --build | --buil | --bui | --bu)
    ac_prev=build ;;
  -build=* | --build=* | --buil=* | --bui=* | --bu=*)
    build="$ac_optarg" ;;

  -cache-file | --cache-file | --cache-fil | --cache-fi \
  | --cache-f | --cache- | --cache | --cach | --cac | --ca | --c)
    ac_prev=cache_file ;;
  -cache-file=* | --cache-file=* | --cache-fil=* | --cache-fi=* \
  | --cache-f=* | --cache-=* | --cache=* | --cach=* | --cac=* | --ca=* | --c=*)
    cache_file="$ac_optarg" ;;

  -datadir | --datadir | --datadi | --datad | --data | --dat | --da)
    ac_prev=datadir ;;
  -datadir=* | --datadir=* | --datadi=* | --datad=* | --data=* | --dat=* \
  | --da=*)
    datadir="$ac_optarg" ;;

  -disable-* | --disable-*)
    ac_feature=`echo $ac_option|sed -e 's/-*disable-//'`
    # Reject names that are not valid shell variable names.
    if test -n "`echo $ac_feature| sed 's/[-a-zA-Z0-9_]//g'`"; then
      { echo "configure: error: $ac_feature: invalid feature name" 1>&2; exit 1; }
    fi
    ac_feature=`echo $ac_feature| sed 's/-/_/g'`
    eval "enable_${ac_feature}=no" ;;

  -enable-* | --enable-*)
    ac_feature=`echo $ac_option|sed -e 's/-*enable-//' -e 's/=.*//'`
    # Reject names that are not valid shell variable names.
    if test -n "`echo $ac_feature| sed 's/[-_a-zA-Z0-9]//g'`"; then
      { echo "configure: error: $ac_feature: invalid feature name" 1>&2; exit 1; }
    fi
    ac_feature=`echo $ac_feature| sed 's/-/_/g'`
    case "$ac_option" in
      *=*) ;;
      *) ac_optarg=yes ;;
    esac
    eval "enable_${ac_feature}='$ac_optarg'" ;;

  -exec-prefix | --exec_prefix | --exec-prefix | --exec-prefi \
  | --exec-pref | --exec-pre | --exec-pr | --exec-p | --exec- \
  | --exec | --exe | --ex)
    ac_prev=exec_prefix ;;
  -exec-prefix=* | --exec_prefix=* | --exec-prefix=* | --exec-prefi=* \
  | --exec-pref=* | --exec-pre=* | --exec-pr=* | --exec-p=* | --exec-=* \
  | --exec=* | --exe=* | --ex=*)
    exec_prefix="$ac_optarg" ;;

  -gas | --gas | --ga | --g)
    # Obsolete; use --with-gas.
    with_gas=yes ;;

  -help | --help | --hel | --he)
    # Omit some internal or obsolete options to make the list less imposing.
    # This message is too long to be a string in the A/UX 3.1 sh.
    cat << EOF
Usage: configure [options] [host]
Options: [defaults in brackets after descriptions]
Configuration:
  --cache-file=FILE       cache test results in FILE
  --help                  print this message
  --no-create             do not create output files
  --quiet, --silent       do not print \`checking...' messages
  --version               print the version of autoconf that created configure
Directory and file names:
  --prefix=PREFIX         install architecture-independent files in PREFIX
                          [$ac_default_prefix]
  --exec-prefix=EPREFIX   install architecture-dependent files in EPREFIX
                          [same as prefix]
  --bindir=DIR            user executables in DIR [EPREFIX/bin]
  --sbindir=DIR           system admin executables in DIR [EPREFIX/sbin]
  --libexecdir=DIR        program executables in DIR [EPREFIX/libexec]
  --datadir=DIR           read-only architecture-independent data in DIR
                          [PREFIX/share]
  --sysconfdir=DIR        read-only single-machine data in DIR [PREFIX/etc]
  --sharedstatedir=DIR    modifiable architecture-independent data in DIR
                          [PREFIX/com]
  --localstatedir=DIR     modifiable single-machine data in DIR [PREFIX/var]
  --libdir=DIR            object code libraries in DIR [EPREFIX/lib]
  --includedir=DIR        C header files in DIR [PREFIX/include]
  --oldincludedir=DIR     C header files for non-gcc in DIR [/usr/include]
  --infodir=DIR           info documentation in DIR [PREFIX/info]
  --mandir=DIR            man documentation in DIR [PREFIX/man]
  --srcdir=DIR            find the sources in DIR [configure dir or ..]
  --program-prefix=PREFIX prepend PREFIX to installed program names
  --program-suffix=SUFFIX append SUFFIX to installed program names
  --program-transform-name=PROGRAM
                          run sed PROGRAM on installed program names
EOF
    cat << EOF
Host type:
  --build=BUILD           configure for building on BUILD [BUILD=HOST]
  --host=HOST             configure for HOST [guessed]
  --target=TARGET         configure for TARGET [TARGET=HOST]
Features and packages:
  --disable-FEATURE       do not include FEATURE (same as --enable-FEATURE=no)
  --enable-FEATURE[=ARG]  include FEATURE [ARG=yes]
  --with-PACKAGE[=ARG]    use PACKAGE [ARG=yes]
  --without-PACKAGE       do not use PACKAGE (same as --with-PACKAGE=no)
  --x-includes=DIR        X include files are in DIR
  --x-libraries=DIR       X library files are in DIR
EOF
    if test -n "$ac_help"; then
      echo "--enable and --with options recognized:$ac_help"
    fi
    exit 0 ;;

  -host | --host | --hos | --ho)
    ac_prev=host ;;
  -host=* | --host=* | --hos=* | --ho=*)
    host="$ac_optarg" ;;

  -includedir | --includedir | --includedi | --included | --include \
  | --includ | --inclu | --incl | --inc)
    ac_prev=includedir ;;
  -includedir=* | --includedir=* | --includedi=* | --included=* | --include=* \
  | --includ=* | --inclu=* | --incl=* | --inc=*)
    includedir="$ac_optarg" ;;

  -infodir | --infodir | --infodi | --infod | --info | --inf)
    ac_prev=infodir ;;
  -infodir=* | --infodir=* | --infodi=* | --infod=* | --info=* | --inf=*)
    infodir="$ac_optarg" ;;

  -libdir | --libdir | --libdi | --libd)
    ac_prev=libdir ;;
  -libdir=* | --libdir=* | --libdi=* | --libd=*)
    libdir="$ac_optarg" ;;

  -libexecdir | --libexecdir | --libexecdi | --libexecd | --libexec \
  | --libexe | --libex | --libe)
    ac_prev=libexecdir ;;
  -libexecdir=* | --libexecdir=* | --libexecdi=* | --libexecd=* | --libexec=* \
  | --libexe=* | --libex=* | --libe=*)
    libexecdir="$ac_optarg" ;;

  -localstatedir | --localstatedir | --localstatedi | --localstated \
  | --localstate | --localstat | --localsta | --localst \
  | --locals | --local | --loca | --loc | --lo)
    ac_prev=localstatedir ;;
  -localstatedir=* | --localstatedir=* | --localstatedi=* | --localstated=* \
  | --localstate=* | --localstat=* | --localsta=* | --localst=* \
  | --locals=* | --local=* | --loca=* | --loc=* | --lo=*)
    localstatedir="$ac_optarg" ;;

  -mandir | --mandir | --mandi | --mand | --man | --ma | --m)
    ac_prev=mandir ;;
  -mandir=* | --mandir=* | --mandi=* | --mand=* | --man=* | --ma=* | --m=*)
    mandir="$ac_optarg" ;;

  -nfp | --nfp | --nf)
    # Obsolete; use --without-fp.
    with_fp=no ;;

  -no-create | --no-create | --no-creat | --no-crea | --no-cre \
  | --no-cr | --no-c)
    no_create=yes ;;

  -no-recursion | --no-recursion | --no-recursio | --no-recursi \
  | --no-recurs | --no-recur | --no-recu | --no-rec | --no-re | --no-r)
    no_recursion=yes ;;

  -oldincludedir | --oldincludedir | --oldincludedi | --oldincluded \
  | --oldinclude | --oldinclud | --oldinclu | --oldincl | --oldinc \
  | --oldin | --oldi | --old | --ol | --o)
    ac_prev=oldincludedir ;;
  -oldincludedir=* | --oldincludedir=* | --oldincludedi=* | --oldincluded=* \
  | --oldinclude=* | --oldinclud=* | --oldinclu=* | --oldincl=* | --oldinc=* \
  | --oldin=* | --oldi=* | --old=* | --ol=* | --o=*)
    oldincludedir="$ac_optarg" ;;

  -prefix | --prefix | --prefi | --pref | --pre | --pr | --p)
    ac_prev=prefix ;;
  -prefix=* | --prefix=* | --prefi=* | --pref=* | --pre=* | --pr=* | --p=*)
    prefix="$ac_optarg" ;;

  -program-prefix | --program-prefix | --program-prefi | --program-pref \
  | --program-pre | --program-pr | --program-p)
    ac_prev=program_prefix ;;
  -program-prefix=* | --program-prefix=* | --program-prefi=* \
  | --program-pref=* | --program-pre=* | --program-pr=* | --program-p=*)
    program_prefix="$ac_optarg" ;;

  -program-suffix | --program-suffix | --program-suffi | --program-suff \
  | --program-suf | --program-su | --program-s)
    ac_prev=program_suffix ;;
  -program-suffix=* | --program-suffix=* | --program-suffi=* \
  | --program-suff=* | --program-suf=* | --program-su=* | --program-s=*)
    program_suffix="$ac_optarg" ;;

  -program-transform-name | --program-transform-name \
  | --program-transform-nam | --program-transform-na \
  | --program-transform-n | --program-transform- \
  | --program-transform | --program-transfor \
  | --program-transfo | --program-transf \
  | --program-trans | --program-tran \
  | --progr-tra | --program-tr | --program-t)
    ac_prev=program_transform_name ;;
  -program-transform-name=* | --program-transform-name=* \
  | --program-transform-nam=* | --program-transform-na=* \
  | --program-transform-n=* | --program-transform-=* \
  | --program-transform=* | --program-transfor=* \
  | --program-transfo=* | --program-transf=* \
  | --program-trans=* | --program-tran=* \
  | --progr-tra=* | --program-tr=* | --program-t=*)
    program_transform_name="$ac_optarg" ;;

  -q | -quiet | --quiet | --quie | --qui | --qu | --q \
  | -silent | --silent | --silen | --sile | --sil)
    silent=yes ;;

  -sbindir | --sbindir | --sbindi | --sbind | --sbin | --sbi | --sb)
    ac_prev=sbindir ;;
  -sbindir=* | --sbindir=* | --sbindi=* | --sbind=* | --sbin=* \
  | --sbi=* | --sb=*)
    sbindir="$ac_optarg" ;;

  -sharedstatedir | --sharedstatedir | --sharedstatedi \
  | --sharedstated | --sharedstate | --sharedstat | --sharedsta \
  | --sharedst | --shareds | --shared | --share | --shar \
  | --sha | --sh)
    ac_prev=sharedstatedir ;;
  -sharedstatedir=* | --sharedstatedir=* | --sharedstatedi=* \
  | --sharedstated=* | --sharedstate=* | --sharedstat=* | --sharedsta=* \
  | --sharedst=* | --shareds=* | --shared=* | --share=* | --shar=* \
  | --sha=* | --sh=*)
    sharedstatedir="$ac_optarg" ;;

  -site | --site | --sit)
    ac_prev=site ;;
  -site=* | --site=* | --sit=*)
    site="$ac_optarg" ;;

  -srcdir | --srcdir | --srcdi | --srcd | --src | --sr)
    ac_prev=srcdir ;;
  -srcdir=* | --srcdir=* | --srcdi=* | --srcd=* | --src=* | --sr=*)
    srcdir="$ac_optarg" ;;

  -sysconfdir | --sysconfdir | --sysconfdi | --sysconfd | --sysconf \
  | --syscon | --sysco | --sysc | --sys | --sy)
    ac_prev=sysconfdir ;;
  -sysconfdir=* | --sysconfdir=* | --sysconfdi=* | --sysconfd=* | --sysconf=* \
  | --syscon=* | --sysco=* | --sysc=* | --sys=* | --sy=*)
    sysconfdir="$ac_optarg" ;;

  -target | --target | --targe | --targ | --tar | --ta | --t)
    ac_prev=target ;;
  -target=* | --target=* | --targe=* | --targ=* | --tar=* | --ta=* | --t=*)
    target="$ac_optarg" ;;

  -v | -verbose | --verbose | --verbos | --verbo | --verb)
    verbose=yes ;;

  -version | --version | --versio | --versi | --vers)
    echo "configure generated by autoconf version 2.13"
    exit 0 ;;

  -with-* | --with-*)
    ac_package=`echo $ac_option|sed -e 's/-*with-//' -e 's/=.*//'`
    # Reject names that are not valid shell variable names.
    if test -n "`echo $ac_package| sed 's/[-_a-zA-Z0-9]//g'`"; then
      { echo "configure: error: $ac_package: invalid package name" 1>&2; exit 1; }
    fi
    ac_package=`echo $ac_package| sed 's/-/_/g'`
    case "$ac_option" in
      *=*) ;;
      *) ac_optarg=yes ;;
    esac
    eval "with_${ac_package}='$ac_optarg'" ;;

  -without-* | --without-*)
    ac_package=`echo $ac_option|sed -e 's/-*without-//'`
    # Reject names that are not valid shell variable names.
    if test -n "`echo $ac_package| sed 's/[-a-zA-Z0-9_]//g'`"; then
      { echo "configure: error: $ac_package: invalid package name" 1>&2; exit 1; }
    fi
    ac_package=`echo $ac_package| sed 's/-/_/g'`
    eval "with_${ac_package}=no" ;;

  --x)
    # Obsolete; use --with-x.
    with_x=yes ;;

  -x-includes | --x-includes | --x-include | --x-includ | --x-inclu \
  | --x-incl | --x-inc | --x-in | --x-i)
    ac_prev=x_includes ;;
  -x-includes=* | --x-includes=* | --x-include=* | --x-includ=* | --x-inclu=* \
  | --x-incl=* | --x-inc=* | --x-in=* | --x-i=*)
    x_includes="$ac_optarg" ;;

  -x-libraries | --x-libraries | --x-librarie | --x-librari \
  | --x-librar | --x-libra | --x-libr | --x-lib | --x-li | --x-l)
    ac_prev=x_libraries ;;
  -x-libraries=* | --x-libraries=* | --x-librarie=* | --x-librari=* \
  | --x-librar=* | --x-libra=* | --x-libr=* | --x-lib=* | --x-li=* | --x-l=*)
    x_libraries="$ac_optarg" ;;

  -*) { echo "configure: error: $ac_option: invalid option; use --help to show usage" 1>&2; exit 1; }
    ;;

  *)
    if test -n "`echo $ac_option| sed 's/[-a-z0-9.]//g'`"; then
      echo "configure: warning: $ac_option: invalid host type" 1>&2
    fi
    if test "x$nonopt" != xNONE; then
      { echo "configure: error: can only configure for one host and one target at a time" 1>&2; exit 1; }
    fi
    nonopt="$ac_option"
    ;;

  esac
done

if test -n "$ac_prev"; then
  { echo "configure: error: missing argument to --`echo $ac_prev | sed 's/_/-/g'`" 1>&2; exit 1; }
fi

trap 'rm -fr conftest* confdefs* core core.* *.core $ac_clean_files; exit 1' 1 2 15

# File descriptor usage:
# 0 standard input
# 1 file creation
# 2 errors and warnings
# 3 some systems may open it to /dev/tty
# 4 used on the Kubota Titan
# 6 checking for... messages and results
# 5 compiler messages saved in config.log
if test "$silent" = yes; then
  exec 6>/dev/null
else
  exec 6>&1
fi
exec 5>./config.log

echo "\
This file contains any messages produced by compilers while
running configure, to aid debugging if configure makes a mistake.
" 1>&5

# Strip out --no-create and --no-recursion so they do not pile up.
# Also quote any args containing shell metacharacters.
ac_configure_args=
for ac_arg
do
  case "$ac_arg" in
  -no-create | --no-create | --no-creat | --no-crea | --no-cre \
  | --no-cr | --no-c) ;;
  -no-recursion | --no-recursion | --no-recursio | --no-recursi \
  | --no-recurs | --no-recur | --no-recu | --no-rec | --no-re | --no-r) ;;
  *" "*|*"	"*|*[\[\]\~\#\$\^\&\*\(\)\{\}\\\|\;\<\>\?]*)
  ac_configure_args="$ac_configure_args '$ac_arg'" ;;
  *) ac_configure_args="$ac_configure_args $ac_arg" ;;
  esac
done

# NLS nuisances.
# Only set these to C if already set.  These must not be set unconditionally
# because not all systems understand e.g. LANG=C (notably SCO).
# Fixing LC_MESSAGES prevents Solaris sh from translating var values in `set'!
# Non-C LC_CTYPE values break the ctype check.
if test "${LANG+set}"   = set; then LANG=C;   export LANG;   fi
if test "${LC_ALL+set}" = set; then LC_ALL=C; export LC_ALL; fi
if test "${LC_MESSAGES+set}" = set; then LC_MESSAGES=C; export LC_MESSAGES; fi
if test "${LC_CTYPE+set}"    = set; then LC_CTYPE=C;    export LC_CTYPE;    fi

# confdefs.h avoids OS command line length limits that DEFS can exceed.
rm -rf conftest* confdefs.h
# AIX cpp loses on an empty file, so make sure it contains at least a newline.
echo > confdefs.h

# A filename unique to this package, relative to the directory that
# configure is in, which we can look for to find out if srcdir is correct.
ac_unique_file=ncftp/main.c

# Find the source files, if location was not specified.
if test -z "$srcdir"; then
  ac_srcdir_defaulted=yes
  # Try the directory containing this script, then its parent.
  ac_prog=$0
  ac_confdir=`echo $ac_prog|sed 's%/[^/][^/]*$%%'`
  test "x$ac_confdir" = "x$ac_prog" && ac_confdir=.
  srcdir=$ac_confdir
  if test ! -r $srcdir/$ac_unique_file; then
    srcdir=..
  fi
else
  ac_srcdir_defaulted=no
fi
if test ! -r $srcdir/$ac_unique_file; then
  if test "$ac_srcdir_defaulted" = yes; then
    { echo "configure: error: can not find sources in $ac_confdir or .." 1>&2; exit 1; }
  else
    { echo "configure: error: can not find sources in $srcdir" 1>&2; exit 1; }
  fi
fi
srcdir=`echo "${srcdir}" | sed 's%\([^/]\)/*$%\1%'`

# Prefer explicitly selected file to automatically selected ones.
if test -z "$CONFIG_SITE"; then
  if test "x$prefix" != xNONE; then
    CONFIG_SITE="$prefix/share/config.site $prefix/etc/config.site"
  else
    CONFIG_SITE="$ac_default_prefix/share/config.site $ac_default_prefix/etc/config.site"
  fi
fi
for ac_site_file in $CONFIG_SITE; do
  if test -r "$ac_site_file"; then
    echo "loading site script $ac_site_file"
    . "$ac_site_file"
  fi
done

if test -r "$cache_file"; then
  echo "loading cache $cache_file"
  . $cache_file
else
  echo "creating cache $cache_file"
  > $cache_file
fi

ac_ext=c
# CFLAGS is not in ac_cpp because -g, -O, etc. are not valid cpp options.
ac_cpp='$CPP $CPPFLAGS'
ac_compile='${CC-cc} -c $CFLAGS $CPPFLAGS conftest.$ac_ext 1>&5'
ac_link='${CC-cc} -o conftest${ac_exeext} $CFLAGS $CPPFLAGS $LDFLAGS conftest.$ac_ext $LIBS 1>&5'
cross_compiling=$ac_cv_prog_cc_cross

ac_exeext=
ac_objext=o
if (echo "testing\c"; echo 1,2,3) | grep c >/dev/null; then
  # Stardent Vistra SVR4 grep lacks -e, says ghazi@caip.rutgers.edu.
  if (echo -n testing; echo 1,2,3) | sed s/-n/xn/ | grep xn >/dev/null; then
    ac_n= ac_c='
' ac_t='	'
  else
    ac_n=-n ac_c= ac_t=
  fi
else
  ac_n= ac_c='\c' ac_t=
fi





# Check whether --enable-ccdv or --disable-ccdv was given.
if test "${enable_ccdv+set}" = set; then
  enableval="$enable_ccdv"
  use_ccdv="$enableval"
else
  use_ccdv=yes
fi


# Check whether --with-curses or --without-curses was given.
if test "${with_curses+set}" = set; then
  withval="$with_curses"
  nc_cv_curses=$withval
else
  nc_cv_curses=yes
fi


# if DEBUGBUILD is yes, other macros try to set up a compilation environment
# with debugging symbols enabled.  Example macros which are affected are
# wi_CFLAGS and wi_SFLAG.
#
# Check whether --enable-debug or --disable-debug was given.
if test "${enable_debug+set}" = set; then
  enableval="$enable_debug"
  
	DEBUGBUILD=no
	DEBUGCONFIGUREFLAG=""
	if test "$enableval" != "no" ; then
		DEBUGBUILD=yes
		DEBUGCONFIGUREFLAG="--enable-debug"
	fi

else
  
	DEBUGBUILD=no
	DEBUGCONFIGUREFLAG=""

fi


# Check whether --with-ncurses or --without-ncurses was given.
if test "${with_ncurses+set}" = set; then
  withval="$with_ncurses"
  nc_cv_ncurses=$withval
else
  nc_cv_ncurses=yes
fi


# Check whether --enable-precomp or --disable-precomp was given.
if test "${enable_precomp+set}" = set; then
  enableval="$enable_precomp"
  use_precomp="$enableval"
else
  use_precomp=yes
fi



	# Check whether --with-socks5 or --without-socks5 was given.
if test "${with_socks5+set}" = set; then
  withval="$with_socks5"
  wi_want_socks5=$withval
else
  wi_want_socks5=no
fi



# Check whether --enable-ssp or --disable-ssp was given.
if test "${enable_ssp+set}" = set; then
  enableval="$enable_ssp"
  use_ssp="$enableval"
else
  use_ssp=no
fi



# Check whether --enable-universal or --disable-universal was given.
if test "${enable_universal+set}" = set; then
  enableval="$enable_universal"
  use_macosx_universal="$enableval"
else
  use_macosx_universal=yes
fi






echo $ac_n "checking if you set and exported the environment variable CC""... $ac_c" 1>&6
echo "configure:640: checking if you set and exported the environment variable CC" >&5
if test "x$CC" = x ; then
	echo "$ac_t""no (you may want to do that since configure scripts look for gcc first)" 1>&6
else
	echo "$ac_t""$CC" 1>&6
fi
echo $ac_n "checking for environment variable CFLAGS""... $ac_c" 1>&6
echo "configure:647: checking for environment variable CFLAGS" >&5
if test "x$CFLAGS" = x ; then
	echo "$ac_t""no (we will choose a default set for you)" 1>&6
else
	echo "$ac_t""$CFLAGS" 1>&6
fi
echo $ac_n "checking for environment variable CPPFLAGS""... $ac_c" 1>&6
echo "configure:654: checking for environment variable CPPFLAGS" >&5
echo "$ac_t""${CPPFLAGS-no}" 1>&6
echo $ac_n "checking for environment variable LDFLAGS""... $ac_c" 1>&6
echo "configure:657: checking for environment variable LDFLAGS" >&5
echo "$ac_t""${LDFLAGS-no}" 1>&6
echo $ac_n "checking for environment variable LIBS""... $ac_c" 1>&6
echo "configure:660: checking for environment variable LIBS" >&5
echo "$ac_t""${LIBS-no}" 1>&6


#
# Take note if the user is or is not exporting a CFLAGS env var.
#
wi_orig_CFLAGS="$CFLAGS"
wi_CFLAGS_TO_ADD_LATER=""
if [ -x "$HOME/bin/OS" ] ; then
	HOME_OS=`$HOME/bin/OS`
	HOME_OS="$HOME/$HOME_OS"
fi
host=`uname -n 2>/dev/null | tr '[A-Z]' '[a-z]'`
os=`uname -s 2>/dev/null | tr '[A-Z]' '[a-z]'`
if [ "$os" = "TvoPT" ] ; then os="sunos" ; fi
os_v=`uname -v 2>/dev/null | sed 's/^[^0-9.]*//;s/[^0-9.].*$//;' | awk '-F[-/: ]' '{n = 1; print $n; }'`
os_r=`uname -r 2>/dev/null | sed 's/^[^0-9.]*//;s/[^0-9.].*$//;' | awk '-F[-/: ]' '{n = 1; print $n; }'`
os_r1=`echo "${os_r}" | cut -c1`
arch=`uname -m 2>/dev/null | tr '[A-Z]' '[a-z]'`
archp=`uname -p 2>/dev/null | tr '[A-Z]' '[a-z]'`
OS=''
SYS=''
NDEFS=''
unset CDPATH	# Not relevant here, but needs to be done eventually.

# Special case a few systems where if your CFLAGS appear
# to want to generate for 32 bit, use that mode rather
# than 64 bit.
#
case "$os,$CFLAGS" in
	irix64,*-n32*)
		os=irix
		# then go to regular "irix" instead of "irix64" below.
		;;
esac

case "$os" in
	osf1)
		case "$os_r" in
			3*|4*)
				OS="digitalunix${os_r}-$arch"
				SYS=digitalunix
				NDEFS="$NDEFS -DDIGITAL_UNIX=$os_r1"
				;;
			*)
				OS="tru64unix${os_r}-$arch"
				SYS=tru64unix
				NDEFS="$NDEFS -DTRU64UNIX=$os_r1"
				;;
		esac
		;;
	aix)
		os_lev=`/usr/bin/oslevel 2>/dev/null`
		if [ "$os_lev" = "" ] ; then
			if [ "$os_r" = "" ] ; then os_r=0 ; fi
			OS="aix${os_v}.${os_r}"
			os_int=`expr $os_v$os_r '*' 10`
		else
			os_v=`echo "$os_lev" | cut -d. -f1-3`
			os_v1=`echo "$os_v" | cut -d. -f1`
			os_v2=`echo "$os_v" | cut -d. -f2`
			if [ "$os_v2" = "" ] ; then os_v2=0 ; fi
			os_v3=`echo "$os_v" | cut -d. -f3`
			if [ "$os_v3" = "" ] ; then os_v3=0 ; fi
			os_int=`expr "$os_v1" '*' 100 + "$os_v2" '*' 10 + "$os_v3"`
			OS="aix${os_v}"
		fi
		SYS=aix
		NDEFS="$NDEFS -DAIX=${os_int}"
		;;
	irix)
		OS="irix${os_r}"
		SYS=irix
		NDEFS="$NDEFS -DIRIX=$os_r1"
		;;
	irix64)
		OS="irix64_${os_r}"
		SYS=irix64
		NDEFS="$NDEFS -DIRIX=$os_r1 -DIRIX64=$os_r1"
		;;
	hp-ux)
		os_r=`echo "${os_r}" | cut -d. -f2-`
		os_r1=`echo "$os_r" | cut -d. -f1`
		os_r2=`echo "${os_r}" | cut -d. -f2`
		os_int=`expr "$os_r1" '*' 100 + "$os_r2"`
		if [ "$arch" != "ia64" ] ; then
			arch="hppa"
		fi
		OS="hpux${os_r}-$arch"
		SYS=hpux
		NDEFS="$NDEFS -DHPUX=$os_int"
		;;
	freebsd)
		if [ "$arch" = "amd64" ] ; then arch="x86_64" ; fi
		OS="freebsd${os_r}-$arch"
		os_r1=`echo "$os_r" | cut -d. -f1`
		os_r2=`echo "$os_r" | cut -d. -f2`
		if [ "$os_r2" = "" ] ; then os_r2=0 ; fi
		os_r3=`echo "$os_r" | cut -d. -f3`
		if [ "$os_r3" = "" ] ; then os_r3=0 ; fi
		os_int=`expr "$os_r1" '*' 100 + "$os_r2" '*' 10 + "$os_r3"`
		SYS=freebsd
		NDEFS="$NDEFS -DFREEBSD=$os_int"
		;;
	netbsd)
		if [ "$arch" = "amd64" ] ; then arch="x86_64" ; fi
		OS="netbsd${os_r}-$arch"
		os_r1=`echo "$os_r" | cut -d. -f1`
		os_r2=`echo "$os_r" | cut -d. -f2`
		if [ "$os_r2" = "" ] ; then os_r2=0 ; fi
		os_r3=`echo "$os_r" | cut -d. -f3`
		if [ "$os_r3" = "" ] ; then os_r3=0 ; fi
		os_int=`expr "$os_r1" '*' 100 + "$os_r2" '*' 10 + "$os_r3"`
		NDEFS="$NDEFS -DNETBSD=$os_int"
		SYS=netbsd
		;;
	openbsd)
		if [ "$arch" = "amd64" ] ; then arch="x86_64" ; fi
		OS="openbsd${os_r}-$arch"
		os_r1=`echo "$os_r" | cut -d. -f1`
		os_r2=`echo "$os_r" | cut -d. -f2`
		if [ "$os_r2" = "" ] ; then os_r2=0 ; fi
		os_r3=`echo "$os_r" | cut -d. -f3`
		if [ "$os_r3" = "" ] ; then os_r3=0 ; fi
		os_int=`expr "$os_r1" '*' 100 + "$os_r2" '*' 10 + "$os_r3"`
		SYS=openbsd
		NDEFS="$NDEFS -DOPENBSD=$os_int"
		;;
	sco*)
		OS=scosv
		SYS=sco
		os_v1=`echo "$os_v" | cut -d. -f1`
		case "$os_v1" in
			[1-9])
				os_v2=`echo "$os_v" | cut -d. -f2`
				if [ "$os_v2" = "" ] ; then os_v2=0 ; fi
				os_v3=`echo "$os_v" | cut -d. -f3`
				if [ "$os_v3" = "" ] ; then os_v3=0 ; fi
				os_int=`expr "$os_v1" '*' 100 + "$os_v2" '*' 10 + "$os_v3"`
				NDEFS="$NDEFS -DSCO=$os_int"
				;;
			*)
				NDEFS="$NDEFS -DSCO=1"
				;;
		esac
		;;
	dynix*)
		OS="dynixptx${os_v}"
		SYS=dynixptx
		os_v1=`echo "$os_v" | cut -d. -f1`
		os_v2=`echo "$os_v" | cut -d. -f2`
		os_v3=`echo "$os_v" | cut -d. -f3`
		if [ "$os_v3" = "" ] ; then os_v3=0 ; fi
		os_int=`expr "$os_v1" '*' 100 + "$os_v2" '*' 10 + "$os_v3"`
		NDEFS="$NDEFS -DDYNIX=$os_int"
		;;
	linux)
		case "$arch" in
			*86)
				arch=x86
				;;
		esac

		libc=""
		os_r1=`echo "$os_r" | cut -d. -f1`
		os_r2=`echo "$os_r" | cut -d. -f2`
		os_r3=`echo "$os_r" | cut -d- -f1 | cut -d. -f3`
		os_int=`expr "$os_r1" '*' 10000 + "$os_r2" '*' 1000 + "$os_r3"`
		NDEFS="$NDEFS -DLINUX=$os_int"

		vertest="./vertest.$$"
		rm -f "$vertest" "$vertest.c"
		cat <<EOF > "$vertest.c"
#include <stdio.h>
#include <gnu/libc-version.h>

main()
{
	const char *ver = gnu_get_libc_version();
	const char *rel = gnu_get_libc_release();

	fprintf(stdout, "glibc%s\n", ver);
	exit(0);
}
EOF
		echo $ac_n "checking version of C library""... $ac_c" 1>&6
		echo "configure:: checking version of C library" >&5
		${CC-cc} $DEFS $CPPFLAGS $CFLAGS "$vertest.c" -o "$vertest" >/dev/null 2>&1
		if [ -x "$vertest" ] ; then libc=`$vertest 2>/dev/null` ; fi
		rm -f "$vertest" "$vertest.c"

		if [ "$libc" = "" ] ; then
			libc_sysroot=`"${CC-gcc}" -v 2>&1 | sed -n '/with-libc_sysroot/{s/^.*--with-libc_sysroot=//;s/ .*//;p;q;}'`	# Only results in non-empty with a GCC cross-compiler

			libc_file=`/bin/ls -1 -t "${libc_sysroot}"/lib/libc.so.* 2>/dev/null | sed -n 1,1p`
			if [ "$libc_file" != "" ] ; then
				libc_file=`echo "$libc_file" | sed 's|^.*/||'`
				libc_file="$libc_sysroot/lib/$libc_file"
			elif [ -f "$libc_sysroot/usr/lib/libc.a" ] ; then
				libc_file="$libc_sysroot/usr/lib/libc.a"
			else
				libc_file="/error"
			fi

			libc=`strings -n 40 "$libc_file" 2>/dev/null | fgrep 'GNU C Library' | sed 's/^.*version //;s/[^0-9\.].*$//;' | sed -n 1,1p`

			if [ "$libc" != "" ] ; then
				libc="glibc${libc}"
			fi
		fi

		case "$libc" in
			glibc*)
				echo "$libc" 1>&6
				glibc_r=`echo "$libc" | sed 's/glibc//'`
				glibc_r1=`echo "$glibc_r" | cut -d. -f1`
				glibc_r2=`echo "$glibc_r" | cut -d. -f2`
				glibc_r3=`echo "$glibc_r" | cut -d- -f1 | cut -d. -f3`
				if test "$glibc_r1" = "" ; then glibc_r1=0 ; fi
				if test "$glibc_r2" = "" ; then glibc_r2=0 ; fi
				if test "$glibc_r3" = "" ; then glibc_r3=0 ; fi
				glibc_int=`expr "$glibc_r1" '*' 10000 + "$glibc_r2" '*' 100 + "$glibc_r3"`
				NDEFS="$NDEFS -DLINUX_GLIBC=$glibc_int"
				libc="glibc${glibc_r1}.${glibc_r2}"
				OS="linux-$arch"
				;;
			*)
				if test -f /lib/libc-2.1.3.so ; then
					NDEFS="$NDEFS -DLINUX_GLIBC=20103"
					libc="glibc2.1"
					OS="linux-$arch"
				elif test -f /lib/libc-2.1.2.so ; then
					NDEFS="$NDEFS -DLINUX_GLIBC=20102"
					libc="glibc2.1"
					OS="linux-$arch"
				elif test -f /lib/libc-2.1.1.so ; then
					NDEFS="$NDEFS -DLINUX_GLIBC=20101"
					libc="glibc2.1"
					OS="linux-$arch"
				elif test -f /lib/libc.so.6 ; then
					NDEFS="$NDEFS -DLINUX_GLIBC=20000"
					libc="glibc2.0"
					OS="linux-$arch"
				elif test -f /lib/libc.so.6.1 ; then
					NDEFS="$NDEFS -DLINUX_GLIBC=20001"
					libc="glibc2.0"
					OS="linux-$arch"
				else
					NDEFS="$NDEFS -DLINUX_LIBC=5"
					libc="libc5"
					OS="linux-$arch"
				fi
				echo "$libc" 1>&6
				;;
		esac
		SYS=linux
		;;
	bsd/os)
		OS="bsdos${os_r}"
		SYS=bsdos
		NDEFS="$NDEFS -DBSDOS=$os_r1"
		;;
	ultrix)
		OS="ultrix-$arch"
		SYS=ultrix
		NDEFS="$NDEFS -DULTRIX"
		;;
	unixware)
		OS="unixware${os_v}"
		SYS=unixware
		os_v1=`echo "$os_v" | cut -d. -f1`
		case "$os_v1" in
			[1-9])
				os_v2=`echo "$os_v" | cut -d. -f2`
				os_v3=`echo "$os_v" | cut -d. -f3`
				if [ "$os_v3" = "" ] ; then os_v3=0 ; fi
				os_int=`expr "$os_v1" '*' 100 + "$os_v2" '*' 10 + "$os_v3"`
				NDEFS="$NDEFS -DUNIXWARE=$os_int"
				;;
			*)
				NDEFS="$NDEFS -DUNIXWARE=1"
				;;
		esac
		;;
	openunix)
		OS="openunix${os_v}"
		SYS=openunix
		os_v1=`echo "$os_v" | cut -d. -f1`
		os_v2=`echo "$os_v" | cut -d. -f2`
		os_v3=`echo "$os_v" | cut -d. -f3`
		if [ "$os_v3" = "" ] ; then os_v3=0 ; fi
		os_int=`expr "$os_v1" '*' 100 + "$os_v2" '*' 10 + "$os_v3"`
		NDEFS="$NDEFS -DOPENUNIX=$os_int -DUNIXWARE=$os_int"
		;;
	macos*|darwin|rhapsody)
		OS="macosx"
		SYS="macosx"
		os_v=`perl -e '{open(F, "< /System/Library/CoreServices/SystemVersion.plist") or exit(2); my ($doc) = ""; my ($line); while (defined($line = <F>)) { $doc .= $line; } close(F); $doc =~ s/\s+//gs; if ($doc =~ /<key>ProductVersion<\/key><string>([^<]+)<\/string>/) { print , "\n"; exit(0); } exit(1); }' 2>/dev/null`
		if [ "$os_v" = "" ] && [ -x "$HOME/bin/macosver" ] ; then
			os_v=`"$HOME/bin/macosver" 2>/dev/null`
		fi
		if [ "$os_v" = "" ] ; then
			cat > "$HOME/macosver.c" <<EOF
/*
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE plist SYSTEM "file://localhost/System/Library/DTDs/PropertyList.dtd">
<plist version="0.9">
<dict>
	<key>ProductBuildVersion</key>
	<string>5S66</string>
	<key>ProductName</key>
	<string>Mac OS X</string>
	<key>ProductVersion</key>
	<string>10.1.5</string>
</dict>
</plist>
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

main()
{
	char line[256], *cp, *cp2; 
	FILE *fp;

	fp = fopen("/System/Library/CoreServices/SystemVersion.plist", "r");

	if (fp != NULL) {
		memset(line, 0, sizeof(line));
		while (fgets(line, sizeof(line) - 1, fp) != NULL) {
			cp = strstr(line, "<key>ProductVersion</key>");
			if (cp != NULL) {
				memset(line, 0, sizeof(line));
				if (fgets(line, sizeof(line) - 2, fp) != NULL) {
					for (cp = line; ((*cp != '\0') && (! isdigit(*cp))); ) cp++;
					for (cp2 = cp; ((*cp2 != '\0') && (! isspace(*cp2)) && (*cp2 != '<') && (*cp2 != '>')); ) cp2++;
					cp2[0] = '\0';
					fclose(fp);
					fprintf(stdout, "%s\n", cp);
					exit(0);
				}
			}
		}
	}
	fclose(fp);
	exit(1);
}
EOF
			${CC-cc} "$HOME/macosver.c" -o "$HOME/macosver" > /dev/null 2>&1
			os_v=`"$HOME/macosver" 2>/dev/null`
			mv "$HOME/macosver" "$HOME/bin/macosver" 2>/dev/null
			rm -f "$HOME/macosver.c" "$HOME/macosver"
		fi
		if [ "$os_v" != "" ] ; then
			OS="macosx${os_v}"
			os_v1=`echo "$os_v" | cut -d. -f1`
			os_v2=`echo "$os_v" | cut -d. -f2`
			os_v3=`echo "$os_v" | cut -d. -f3`
			if [ "$os_v3" = "" ] ; then os_v3=0 ; fi
			os_int=`expr "$os_v1" '*' 1000 + "$os_v2" '*' 100 + "$os_v3"`
			NDEFS="$NDEFS -DMACOSX=$os_int"
		else
			NDEFS="$NDEFS -DMACOSX"
		fi
		;;
	sunos)
		if [ "$arch" = "" ] ; then arch="sparc" ; fi
		if [ "$archp" = "" ] ; then archp="$arch" ; fi
		case "$os_r" in
			5.*)
				case "$os_r" in
					5.[023456]*|5.1)
						os_r=`echo "$os_r" | sed 's/^5/2/;'`
						os_r1=`echo "$os_r" | cut -d. -f1`
						os_r2=`echo "$os_r" | cut -d. -f2`
						if [ "$os_r2" = "" ] ; then os_r2=0 ; fi
						os_r3=`echo "$os_r" | cut -d. -f3`
						if [ "$os_r3" = "" ] ; then os_r3=0 ; fi
						os_int=`expr "$os_r1" '*' 100 + "$os_r2" '*' 10 + "$os_r3"`
						;;
					5.[789]*|5.1[0-9]*)
						os_r1=`echo "$os_r" | cut -d. -f2`
						os_r2=`echo "$os_r" | cut -d. -f3`
						if [ "$os_r2" = "" ] ; then os_r2=0 ; fi
						os_r3=`echo "$os_r" | cut -d. -f4`
						if [ "$os_r3" = "" ] ; then os_r3=0 ; fi
						os_int=`expr "$os_r1" '*' 100 + "$os_r2" '*' 10 + "$os_r3"`
						os_r=`echo "$os_r" | cut -c3-`
						;;
				esac
				case "`/usr/bin/isainfo -n 2>/dev/null`" in
					amd64)
						OS="solaris${os_r}-x86_64"
						;;
					*86)
						OS="solaris${os_r}-x86"
						;;
					sparcv9*|sparcv1[0-9]*)
						OS="solaris${os_r}-sparc64"
						;;
					*)
						OS="solaris${os_r}-$archp"
						;;
				esac
				NDEFS="$NDEFS -DSOLARIS=$os_int"
				SYS=solaris
				;;
			4.*)
				OS="sunos${os_r}-sparc"
				NDEFS="$NDEFS -DSUNOS=\\\"$os_r\\\""
				SYS=sunos
				;;
			*)
				os_r1=`echo "$os_r" | cut -d. -f1`
				if [ "$os_r1" = "" ] ; then os_r1=0 ; fi
				os_r2=`echo "$os_r" | cut -d. -f2`
				if [ "$os_r2" = "" ] ; then os_r2=0 ; fi
				os_r3=`echo "$os_r" | cut -d. -f3`
				if [ "$os_r3" = "" ] ; then os_r3=0 ; fi
				os_int=`expr "$os_r1" '*' 100 + "$os_r2" '*' 10 + "$os_r3"`
				OS="solaris${os_r}-$archp"
				NDEFS="$NDEFS -DSOLARIS=$os_int"
				SYS=solaris
				;;
		esac
		;;
	*)
		OS="$os"
		SYS="$os"

		if grep Novell /usr/include/sys/types.h ; then
			OS="unixware${os_v}"
			SYS="unixware"
		fi
		;;
esac

if [ "x$wi_cv_OS" != "x" ] && [ "$wi_cv_OS" != "$OS" ] ; then

	{ echo "configure: error: Your config.cache file is invalid.  It was created on $wi_cv_OS, but this machine is running $OS.  Remove the config.cache file if you wish to continue." 1>&2; exit 1; }
fi
wi_cv_OS="$OS"






echo $ac_n "checking platform""... $ac_c" 1>&6
echo "configure:1113: checking platform" >&5
echo "$ac_t"""$OS"" 1>&6


case "$os" in
	linux)
		OS="linux-$arch-$libc"
		;;
esac

if test -f sh/install-sh ; then chmod 755 sh/*.sh sh/config.* sh/install-sh ; fi
ac_aux_dir=
for ac_dir in sh $srcdir/sh; do
  if test -f $ac_dir/install-sh; then
    ac_aux_dir=$ac_dir
    ac_install_sh="$ac_aux_dir/install-sh -c"
    break
  elif test -f $ac_dir/install.sh; then
    ac_aux_dir=$ac_dir
    ac_install_sh="$ac_aux_dir/install.sh -c"
    break
  fi
done
if test -z "$ac_aux_dir"; then
  { echo "configure: error: can not find install-sh or install.sh in sh $srcdir/sh" 1>&2; exit 1; }
fi
ac_config_guess=$ac_aux_dir/config.guess
ac_config_sub=$ac_aux_dir/config.sub
ac_configure=$ac_aux_dir/configure # This should be Cygnus configure.

# Extract the first word of "gcc", so it can be a program name with args.
set dummy gcc; ac_word=$2
echo $ac_n "checking for $ac_word""... $ac_c" 1>&6
echo "configure:1146: checking for $ac_word" >&5
if eval "test \"`echo '$''{'ac_cv_prog_CC'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  if test -n "$CC"; then
  ac_cv_prog_CC="$CC" # Let the user override the test.
else
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS=":"
  ac_dummy="$PATH"
  for ac_dir in $ac_dummy; do
    test -z "$ac_dir" && ac_dir=.
    if test -f $ac_dir/$ac_word; then
      ac_cv_prog_CC="gcc"
      break
    fi
  done
  IFS="$ac_save_ifs"
fi
fi
CC="$ac_cv_prog_CC"
if test -n "$CC"; then
  echo "$ac_t""$CC" 1>&6
else
  echo "$ac_t""no" 1>&6
fi

if test -z "$CC"; then
  # Extract the first word of "cc", so it can be a program name with args.
set dummy cc; ac_word=$2
echo $ac_n "checking for $ac_word""... $ac_c" 1>&6
echo "configure:1176: checking for $ac_word" >&5
if eval "test \"`echo '$''{'ac_cv_prog_CC'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  if test -n "$CC"; then
  ac_cv_prog_CC="$CC" # Let the user override the test.
else
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS=":"
  ac_prog_rejected=no
  ac_dummy="$PATH"
  for ac_dir in $ac_dummy; do
    test -z "$ac_dir" && ac_dir=.
    if test -f $ac_dir/$ac_word; then
      if test "$ac_dir/$ac_word" = "/usr/ucb/cc"; then
        ac_prog_rejected=yes
	continue
      fi
      ac_cv_prog_CC="cc"
      break
    fi
  done
  IFS="$ac_save_ifs"
if test $ac_prog_rejected = yes; then
  # We found a bogon in the path, so make sure we never use it.
  set dummy $ac_cv_prog_CC
  shift
  if test $# -gt 0; then
    # We chose a different compiler from the bogus one.
    # However, it has the same basename, so the bogon will be chosen
    # first if we set CC to just the basename; use the full file name.
    shift
    set dummy "$ac_dir/$ac_word" "$@"
    shift
    ac_cv_prog_CC="$@"
  fi
fi
fi
fi
CC="$ac_cv_prog_CC"
if test -n "$CC"; then
  echo "$ac_t""$CC" 1>&6
else
  echo "$ac_t""no" 1>&6
fi

  if test -z "$CC"; then
    case "`uname -s`" in
    *win32* | *WIN32*)
      # Extract the first word of "cl", so it can be a program name with args.
set dummy cl; ac_word=$2
echo $ac_n "checking for $ac_word""... $ac_c" 1>&6
echo "configure:1227: checking for $ac_word" >&5
if eval "test \"`echo '$''{'ac_cv_prog_CC'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  if test -n "$CC"; then
  ac_cv_prog_CC="$CC" # Let the user override the test.
else
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS=":"
  ac_dummy="$PATH"
  for ac_dir in $ac_dummy; do
    test -z "$ac_dir" && ac_dir=.
    if test -f $ac_dir/$ac_word; then
      ac_cv_prog_CC="cl"
      break
    fi
  done
  IFS="$ac_save_ifs"
fi
fi
CC="$ac_cv_prog_CC"
if test -n "$CC"; then
  echo "$ac_t""$CC" 1>&6
else
  echo "$ac_t""no" 1>&6
fi
 ;;
    esac
  fi
  test -z "$CC" && { echo "configure: error: no acceptable cc found in \$PATH" 1>&2; exit 1; }
fi

echo $ac_n "checking whether the C compiler ($CC $CFLAGS $LDFLAGS) works""... $ac_c" 1>&6
echo "configure:1259: checking whether the C compiler ($CC $CFLAGS $LDFLAGS) works" >&5

ac_ext=c
# CFLAGS is not in ac_cpp because -g, -O, etc. are not valid cpp options.
ac_cpp='$CPP $CPPFLAGS'
ac_compile='${CC-cc} -c $CFLAGS $CPPFLAGS conftest.$ac_ext 1>&5'
ac_link='${CC-cc} -o conftest${ac_exeext} $CFLAGS $CPPFLAGS $LDFLAGS conftest.$ac_ext $LIBS 1>&5'
cross_compiling=$ac_cv_prog_cc_cross

cat > conftest.$ac_ext << EOF

#line 1270 "configure"
#include "confdefs.h"

main(){return(0);}
EOF
if { (eval echo configure:1275: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  ac_cv_prog_cc_works=yes
  # If we can't run a trivial program, we are probably using a cross compiler.
  if (./conftest; exit) 2>/dev/null; then
    ac_cv_prog_cc_cross=no
  else
    ac_cv_prog_cc_cross=yes
  fi
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  ac_cv_prog_cc_works=no
fi
rm -fr conftest*
ac_ext=c
# CFLAGS is not in ac_cpp because -g, -O, etc. are not valid cpp options.
ac_cpp='$CPP $CPPFLAGS'
ac_compile='${CC-cc} -c $CFLAGS $CPPFLAGS conftest.$ac_ext 1>&5'
ac_link='${CC-cc} -o conftest${ac_exeext} $CFLAGS $CPPFLAGS $LDFLAGS conftest.$ac_ext $LIBS 1>&5'
cross_compiling=$ac_cv_prog_cc_cross

echo "$ac_t""$ac_cv_prog_cc_works" 1>&6
if test $ac_cv_prog_cc_works = no; then
  { echo "configure: error: installation or configuration problem: C compiler cannot create executables." 1>&2; exit 1; }
fi
echo $ac_n "checking whether the C compiler ($CC $CFLAGS $LDFLAGS) is a cross-compiler""... $ac_c" 1>&6
echo "configure:1301: checking whether the C compiler ($CC $CFLAGS $LDFLAGS) is a cross-compiler" >&5
echo "$ac_t""$ac_cv_prog_cc_cross" 1>&6
cross_compiling=$ac_cv_prog_cc_cross

echo $ac_n "checking whether we are using GNU C""... $ac_c" 1>&6
echo "configure:1306: checking whether we are using GNU C" >&5
if eval "test \"`echo '$''{'ac_cv_prog_gcc'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.c <<EOF
#ifdef __GNUC__
  yes;
#endif
EOF
if { ac_try='${CC-cc} -E conftest.c'; { (eval echo configure:1315: \"$ac_try\") 1>&5; (eval $ac_try) 2>&5; }; } | egrep yes >/dev/null 2>&1; then
  ac_cv_prog_gcc=yes
else
  ac_cv_prog_gcc=no
fi
fi

echo "$ac_t""$ac_cv_prog_gcc" 1>&6

if test $ac_cv_prog_gcc = yes; then
  GCC=yes
else
  GCC=
fi

ac_test_CFLAGS="${CFLAGS+set}"
ac_save_CFLAGS="$CFLAGS"
CFLAGS=
echo $ac_n "checking whether ${CC-cc} accepts -g""... $ac_c" 1>&6
echo "configure:1334: checking whether ${CC-cc} accepts -g" >&5
if eval "test \"`echo '$''{'ac_cv_prog_cc_g'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  echo 'void f(){}' > conftest.c
if test -z "`${CC-cc} -g -c conftest.c 2>&1`"; then
  ac_cv_prog_cc_g=yes
else
  ac_cv_prog_cc_g=no
fi
rm -rf conftest*

fi

echo "$ac_t""$ac_cv_prog_cc_g" 1>&6
if test "$ac_test_CFLAGS" = set; then
  CFLAGS="$ac_save_CFLAGS"
elif test $ac_cv_prog_cc_g = yes; then
  if test "$GCC" = yes; then
    CFLAGS="-g -O2"
  else
    CFLAGS="-g"
  fi
else
  if test "$GCC" = yes; then
    CFLAGS="-O2"
  else
    CFLAGS=
  fi
fi


echo $ac_n "checking if the C compiler can use precompiled headers""... $ac_c" 1>&6
echo "configure:1367: checking if the C compiler can use precompiled headers" >&5
if eval "test \"`echo '$''{'wi_cv_cc_precomp'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  
	result="no"
	if test "${use_macosx_universal}" != no ; then
		# Precompiling the headers doesn't seem to work when building universal binaries
		use_precomp=no
	fi
	if test "${use_precomp-yes}" != no ; then
		wi_cv_cc_precomp_type="unknown"
		rm -f pchtest.h pchtest.p pchtest.c pchtest.o pchtest csetc.pch pchtest.pch pchtest.h.gch
		cat <<EOF > pchtest.h
/* pchtest.h */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#define FOOBAR 33	/* Make sure it can compile custom headers too */
EOF
		cat <<EOF > pchtest.c
/* pchtest.c */
#include "pchtest.h"

int main(int argc, char **argv)
{
	if (FOOBAR == 33)
		exit(0);
	exit(1);
}
EOF
		if test "$GCC" = yes ; then
			#
			# Try gcc 3.4's built-in implementation first
			#
			echo ${CC-cc} $CPPFLAGS pchtest.h -c >&5
			${CC-cc} $CPPFLAGS pchtest.h -c >&5 2>&5
			if test -f pchtest.h.gch ; then
				#
				# Good, the .gch file was created.
				# Odds are we're good to go.
				#
				echo "Successfully compiled pchtest.h into the precompiled header file pchtest.h.gch." >&5
				cat > conftest.$ac_ext <<EOF
#line 1411 "configure"
#include "confdefs.h"
#include "pchtest.h"
int main() {
if (FOOBAR == 33) exit(0)
; return 0; }
EOF
if { (eval echo configure:1418: \"$ac_compile\") 1>&5; (eval $ac_compile) 2>&5; }; then
  rm -rf conftest*
  result="yes" ; wi_cv_cc_precomp_type="gcc_gch_files"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  result="no"
fi
rm -rf conftest*
			else
				echo "This version of GCC did not compile pchtest.h into the precompiled header file pchtest.h.gch." >&5
				#
				# See if Apple's implementation works.
				#
				echo ${CC-cc} $CPPFLAGS -precomp pchtest.h -o pchtest.p >&5 
				${CC-cc} $CPPFLAGS -precomp pchtest.h -o pchtest.p >&5 2>&5
				if test -s pchtest.p ; then
					cat > conftest.$ac_ext <<EOF
#line 1437 "configure"
#include "confdefs.h"
#include "pchtest.h"
int main() {
if (FOOBAR == 33) exit(0)
; return 0; }
EOF
if { (eval echo configure:1444: \"$ac_compile\") 1>&5; (eval $ac_compile) 2>&5; }; then
  rm -rf conftest*
  result="yes" ; wi_cv_cc_precomp_type="gcc_dash_precomp"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  result="no"
fi
rm -rf conftest*
				fi
			fi
		elif test "${result}_${SYS-aix}_${GCC}" = "no_aix_no" ; then
			#
			# AIX xlc
			#
			echo ${CC-cc} $CPPFLAGS -qusepcomp -qgenpcomp pchtest.c -o pchtest >&5
			${CC-cc} $CPPFLAGS -qusepcomp -qgenpcomp pchtest.c -o pchtest >&5 2>&5
			if test -s pchtest ; then
				result="yes"
				wi_cv_cc_precomp_type="xlc"
				wi_CFLAGS_TO_ADD_LATER="$wi_CFLAGS_TO_ADD_LATER -qusepcomp -qgenpcomp"
			fi
		else
			#
			# IRIX, Compaq C, Sun C
			#
			cat <<EOF > pchtest.c
#include "pchtest.h"
#pragma hdrstop
#include <stdarg.h>

int main(int argc, char **argv)
{
	if (FOOBAR == 33)
		exit(0);
	exit(1);
}
EOF
			for pchflags in "-xpch=auto" "-pch -no_pch_messages" "-pch" "-LANG:pch"
			do
				rm -rf SunWS_cache pchtest.pch pchtest.cpch
				echo ${CC-cc} $CPPFLAGS $pchflags pchtest.c -o pchtest >&5
				${CC-cc} $CPPFLAGS $pchflags pchtest.c -o pchtest >&5 2>&5
				if test -f pchtest.pch ; then
					result="yes"
					wi_cv_cc_precomp_type="ccc"
					wi_CFLAGS_TO_ADD_LATER="$wi_CFLAGS_TO_ADD_LATER $pchflags"
					cat >> confdefs.h <<\EOF
#define PRAGMA_HDRSTOP 1
EOF

					break
				elif test -d SunWS_cache ; then
					result="yes"
					wi_cv_cc_precomp_type="SunWS"
					wi_CFLAGS_TO_ADD_LATER="$wi_CFLAGS_TO_ADD_LATER $pchflags -erroff=E_PCH_CONDITIONAL_PREFIX"
					cat >> confdefs.h <<\EOF
#define PRAGMA_HDRSTOP 1
EOF

					break
				fi
			done
			unset pchflags
		fi
		rm -rf SunWS_cache pchtest.h pchtest.p pchtest.c pchtest.o pchtest csetc.pch pchtest.pch pchtest.cpch pchtest.h.gch
	fi
	wi_cv_cc_precomp="$result"

fi

echo "$ac_t""$wi_cv_cc_precomp" 1>&6


	wi_request_no_y2k_warnings=yes

echo $ac_n "checking how to run the C preprocessor""... $ac_c" 1>&6
echo "configure:1522: checking how to run the C preprocessor" >&5
# On Suns, sometimes $CPP names a directory.
if test -n "$CPP" && test -d "$CPP"; then
  CPP=
fi
if test -z "$CPP"; then
if eval "test \"`echo '$''{'ac_cv_prog_CPP'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
    # This must be in double quotes, not single quotes, because CPP may get
  # substituted into the Makefile and "${CC-cc}" will confuse make.
  CPP="${CC-cc} -E"
  # On the NeXT, cc -E runs the code through the compiler's parser,
  # not just through cpp.
  cat > conftest.$ac_ext <<EOF
#line 1537 "configure"
#include "confdefs.h"
#include <assert.h>
Syntax Error
EOF
ac_try="$ac_cpp conftest.$ac_ext >/dev/null 2>conftest.out"
{ (eval echo configure:1543: \"$ac_try\") 1>&5; (eval $ac_try) 2>&5; }
ac_err=`grep -v '^ *+' conftest.out | grep -v "^conftest.${ac_ext}\$"`
if test -z "$ac_err"; then
  :
else
  echo "$ac_err" >&5
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  CPP="${CC-cc} -E -traditional-cpp"
  cat > conftest.$ac_ext <<EOF
#line 1554 "configure"
#include "confdefs.h"
#include <assert.h>
Syntax Error
EOF
ac_try="$ac_cpp conftest.$ac_ext >/dev/null 2>conftest.out"
{ (eval echo configure:1560: \"$ac_try\") 1>&5; (eval $ac_try) 2>&5; }
ac_err=`grep -v '^ *+' conftest.out | grep -v "^conftest.${ac_ext}\$"`
if test -z "$ac_err"; then
  :
else
  echo "$ac_err" >&5
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  CPP="${CC-cc} -nologo -E"
  cat > conftest.$ac_ext <<EOF
#line 1571 "configure"
#include "confdefs.h"
#include <assert.h>
Syntax Error
EOF
ac_try="$ac_cpp conftest.$ac_ext >/dev/null 2>conftest.out"
{ (eval echo configure:1577: \"$ac_try\") 1>&5; (eval $ac_try) 2>&5; }
ac_err=`grep -v '^ *+' conftest.out | grep -v "^conftest.${ac_ext}\$"`
if test -z "$ac_err"; then
  :
else
  echo "$ac_err" >&5
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  CPP=/lib/cpp
fi
rm -rf conftest*
fi
rm -rf conftest*
fi
rm -rf conftest*
  ac_cv_prog_CPP="$CPP"
fi
  CPP="$ac_cv_prog_CPP"
else
  ac_cv_prog_CPP="$CPP"
fi
echo "$ac_t""$CPP" 1>&6


wi_cv_lfs_type="lfs"
if test "$SYS" = "linux" ; then
	case "$libc" in
		libc5)
			wi_cv_lfs_type="lfs64"
			;;
		glibc2.[012]*)
			wi_cv_lfs_type="lfs64"
			;;
	esac
fi
case "$OS" in
	bsdos*)
		wi_cv_lfs_type="lfs64"
		;;
	freebsd[234]*)
		wi_cv_lfs_type="lfs64"
		;;
	hpux9.*|hpux10.*)
		wi_cv_lfs_type="lfs64"
		;;
	solaris2.*|solaris7*)
		wi_cv_lfs_type="lfs64"
		;;
esac
if test "$wi_cv_lfs_type" = "lfs64" ; then
	


	

if test "$GCC" = yes ; then
	echo $ac_n "checking the version of GCC""... $ac_c" 1>&6
echo "configure:1635: checking the version of GCC" >&5
if eval "test \"`echo '$''{'wi_cv_gcc_version'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  
	wi_cv_gcc_version=`$CC -v 2>&1 | sed -n '/gcc version/{s/^.*gcc version//;s/^[^1-9]*//;s/\ .*//;p;q;}'`

fi

echo "$ac_t""$wi_cv_gcc_version" 1>&6
else
	wi_cv_gcc_version="0"
fi

	
	

if test "${SYS}_${GCC}" != solaris_no ; then
	wi_cv_cc_is_sunwspro_cc="no"
	wi_cv_sunwspro_cc_version="0"
	wi_cv_sunwspro_cc_version2="0"
else
	echo $ac_n "checking if the C compiler is Sun WorkShop C""... $ac_c" 1>&6
echo "configure:1658: checking if the C compiler is Sun WorkShop C" >&5
if eval "test \"`echo '$''{'wi_cv_cc_is_sunwspro_cc'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  
#
# cc: Sun WorkShop 6 update 2 C 5.3 2001/05/15
# usage: cc [ options] files.  Use 'cc -flags' for details
#
# cc: WorkShop Compilers 4.2 30 Oct 1996 C 4.2
# usage: cc [ options] files.  Use 'cc -flags' for details
#
		wi_cv_sunwspro_cc_version=`$CC -V 2>&1 | sed -n '/WorkShop.*C\ [1-9]/{s/^.*C/C/;s/^C\ \([^\ ]*\).*/\1/;p;q;}'`
		case "$wi_cv_sunwspro_cc_version" in
			[1-9]*)
				wi_cv_cc_is_sunwspro_cc="yes"
				ver1=`echo "$wi_cv_sunwspro_cc_version" | cut -d. -f1`
				ver2=`echo "$wi_cv_sunwspro_cc_version" | cut -d. -f2`
				ver3=0
				wi_cv_sunwspro_cc_version2=`expr "$ver1" '*' 100 + "$ver2" "*" 10 + "$ver3"`
				unset ver1 ver2 ver3
				;;
			*)
				wi_cv_cc_is_sunwspro_cc="no"
				wi_cv_sunwspro_cc_version="0"
				wi_cv_sunwspro_cc_version2="0"
				;;
		esac
	
fi

echo "$ac_t""$wi_cv_cc_is_sunwspro_cc" 1>&6
	if test "$wi_cv_cc_is_sunwspro_cc" = yes ; then
		echo $ac_n "checking output of "cc -V" to determine version of Sun WorkShop C""... $ac_c" 1>&6
echo "configure:1692: checking output of "cc -V" to determine version of Sun WorkShop C" >&5
		echo "$ac_t"""version $wi_cv_sunwspro_cc_version"" 1>&6
	fi
fi

	
echo $ac_n "checking if we should customize your CFLAGS environment variable""... $ac_c" 1>&6
echo "configure:1699: checking if we should customize your CFLAGS environment variable" >&5
wi_replace_O_with_g="no"
case "$wi_orig_CFLAGS" in
	"")
		wi_replace_O_with_g="no"
		;;
	"-g -O2")
		wi_replace_O_with_g="no"
		;;
	"-g -O")
		wi_replace_O_with_g="no"
		;;
	"-O2 -g")
		wi_replace_O_with_g="no"
		;;
	"-O -g")
		wi_replace_O_with_g="no"
		;;
	-g)
		wi_replace_O_with_g="yes"
		;;
esac

#
# See if your CFLAGS environment variable wasn't set or exported,
# or if you are using a conservative default.  If so, we will
# add some additional flags for better performance, warning reporting,
# etc.
#
# Note we are now checking the current value of CFLAGS, which may have
# been changed by configure.
#
wi_os_default_cflags="no"
case "$CFLAGS" in
	"")
		wi_os_default_cflags="yes"
		;;
	"-g -O2")
		wi_os_default_cflags="yes"
		;;
	"-g -O")
		wi_os_default_cflags="yes"
		;;
	"-O2 -g")
		wi_os_default_cflags="yes"
		;;
	"-O -g")
		wi_os_default_cflags="yes"
		;;
	-g)
		wi_os_default_cflags="yes"
		;;
	-O)
		wi_os_default_cflags="yes"
		;;
	-O2)
		wi_os_default_cflags="yes"
		;;
esac

CC_is_clang="no"
case "$CC" in
	*clang*)
		CC_is_clang="yes"
		;;
	*)
		cc_dash_v=`${CC-gcc} -v 2>&1 | grep clang 2>/dev/null`
		if test -n "$cc_dash_v" ; then
			CC_is_clang="yes"
		fi
		;;
esac

if test "$wi_os_default_cflags" = yes ; then
	if test "$CC_is_clang" = yes ; then
		wi_os_default_cflags="-Weverything -Wno-unknown-warning-option -Wno-disabled-macro-expansion -Wno-missing-variable-declarations -Wno-date-time"
		if test "$wi_replace_O_with_g" = yes ; then
			wi_os_default_cflags="-g $wi_os_default_cflags"
		else
			wi_os_default_cflags="-O2 $wi_os_default_cflags"
		fi
	elif test "$GCC" = yes ; then
		#
		# gcc
		#
		wi_gcc_optimizer_flags=''
		case "$wi_cv_gcc_version" in
			2.7.*|2.8.*|2.9*)
				wi_os_default_cflags="-W -Wall -Wstrict-prototypes -Wmissing-prototypes -Wshadow -Wbad-function-cast -Wpointer-arith -Wcast-qual -Wcast-align -Wwrite-strings -Wmissing-declarations -Winline"
				;;
			345.*)
				wi_os_default_cflags="-W -Wall -Wstrict-prototypes -Wmissing-prototypes -Wshadow -Wbad-function-cast -Wpointer-arith -Wcast-qual -Wcast-align -Wwrite-strings -Wmissing-declarations -Winline -Wmissing-format-attribute -Wformat-security"
				wi_gcc_optimizer_flags='-Wdisabled-optimization'
				;;
			*)
				wi_os_default_cflags="-W -Wall"
				;;
		esac
		if test "$wi_replace_O_with_g" = yes ; then
			wi_os_default_cflags="-g $wi_os_default_cflags"
		else
			wi_os_default_cflags="-O2 $wi_os_default_cflags"
			if test "$wi_gcc_optimizer_flags" != "" ; then
				wi_os_default_cflags="$wi_os_default_cflags $wi_gcc_optimizer_flags"
			fi
		fi
		case "$OS" in
			hpux*)
				wi_os_default_cflags="-D_HPUX_SOURCE $wi_os_default_cflags"
				;;
			bsdos*)
				wi_os_default_cflags=`echo "$wi_os_default_cflags" | sed 's/\ -Wcast-qual//g'`		# avoid va_start() problem
				wi_os_default_cflags=`echo "$wi_os_default_cflags" | sed 's/\ -Wredundant-decls//g'`
				;;
			openbsd*|unixware*|openunix*)
				wi_os_default_cflags=`echo "$wi_os_default_cflags" | sed 's/\ -Wredundant-decls//g'`
				;;
		esac
	else
		#
		# regular cc
		#
		case "${wi_replace_O_with_g}_${OS}" in
			no_aix*)
				wi_os_default_cflags="-O -qinfo=cmp:cnd:dcl:eff:gen:ini:par:pro:rea:use -qlonglong -qro -qroconst -qlanglvl=extended -qsrcmsg -qmaxmem=20480 -qsuppress=1506-469:1506-409"
				;;
			yes_aix*)
				wi_os_default_cflags="-g -qinfo=cmp:cnd:dcl:eff:gen:ini:par:pro:rea:use -qlonglong -qro -qroconst -qlanglvl=extended -qsrcmsg -qmaxmem=20480 -qsuppress=1506-469:1506-409"
				;;
			no_irix2345*|no_irix6.01234*)
				wi_os_default_cflags="-O2 -xansi -fullwarn -use_readonly_const -G0 -rdata_shared"
				;;
			yes_irix2345*|yes_irix6.01234*)
				wi_os_default_cflags="-g -xansi -fullwarn -use_readonly_const -G0 -rdata_shared"
				;;
			no_irix*)
				wi_os_default_cflags="-O2 -IPA -xansi -fullwarn -use_readonly_const -G0 -rdata_shared -woff 1174"
				;;
			yes_irix*)
				wi_os_default_cflags="-g -xansi -fullwarn -use_readonly_const -G0 -rdata_shared -woff 1174"
				;;
			no_digitalunix*)
				wi_os_default_cflags="-O4 -std1 -portable -readonly_strings"
				;;
			yes_digitalunix*)
				wi_os_default_cflags="-g -std1 -portable -readonly_strings"
				;;
			no_hpux*)
				wi_os_default_cflags="-Ae +O2 +Ovolatile +Olibcalls +ESlit +w1 +DAportable"
				;;
			yes_hpux*)
				wi_os_default_cflags="-Ae -g +w1 +DAportable"
				;;
			no_solaris*86|no_solaris*intel)
				# Not really any significant differences
				# from the sparc flags, but reserved for
				# future use.
				#
				if test "$wi_cv_sunwspro_cc_version2" -ge 530 ; then
					wi_os_default_cflags="-xipo -xO4 -xc99 -xbuiltin -xstrconst -dalign -Qn -errtags=yes -erroff=E_END_OF_LOOP_CODE_NOT_REACHED -mc"
				else
					wi_os_default_cflags="-xO4 -xstrconst -dalign -Qn"
				fi
				;;
			yes_solaris*86|yes_solaris*intel)
				if test "$wi_cv_sunwspro_cc_version2" -ge 530 ; then
					wi_os_default_cflags="-g -xc99 -xstrconst -dalign -Qn -errtags=yes -erroff=E_END_OF_LOOP_CODE_NOT_REACHED"
				else
					wi_os_default_cflags="-g -xstrconst -dalign -Qn"
				fi
				;;
			no_solaris*)
				if test "$wi_cv_sunwspro_cc_version2" -ge 530 ; then
					wi_os_default_cflags="-xipo -xO5 -xc99 -xbuiltin -xstrconst -dalign -Qn -errtags=yes -erroff=E_END_OF_LOOP_CODE_NOT_REACHED -mc"
				else
					wi_os_default_cflags="-xO4 -xstrconst -dalign -Qn"
				fi
				;;
			yes_solaris*)
				if test "$wi_cv_sunwspro_cc_version2" -ge 530 ; then
					wi_os_default_cflags="-g -xc99 -xstrconst -dalign -Qn -errtags=yes -erroff=E_END_OF_LOOP_CODE_NOT_REACHED"
				else
					wi_os_default_cflags="-g -xstrconst -dalign -Qn"
				fi
				;;
			no_tru64*)
				wi_os_default_cflags="-O4 -tune host -std1 -readonly_strings -portable -warnprotos -msg_enable level6 -msg_disable longlongtype,hexoctunsign,unusedincl,unnecincl,nestincl,unusedtop,unknownmacro,ignorecallval,strctpadding,truncintasn,truncintcast,trunclongcast,ansialiascast,conststocls,unrefsdecl,subscrbounds2,intconcastsgn,longlongsufx,unreachcode,valuepres,embedcomment"
				;;
			yes_tru64*)
				wi_os_default_cflags="-g -std1 -readonly_strings -portable -warnprotos -msg_enable level6 -msg_disable longlongtype,hexoctunsign,unusedincl,unnecincl,nestincl,unusedtop,unknownmacro,ignorecallval,strctpadding,truncintasn,truncintcast,trunclongcast,ansialiascast,conststocls,unrefsdecl,subscrbounds2,intconcastsgn,longlongsufx,unreachcode,valuepres,embedcomment"
				;;
			no_unixware*|no_openunix*)
				wi_os_default_cflags='-O -K inline -K host -Q n'
				;;
			yes_unixware*|yes_openunix*)
				wi_os_default_cflags='-g -K host -Q n'
				;;
			*)
				wi_os_default_cflags="no"
				;;
		esac
	fi
fi
if test "$wi_os_default_cflags" != "no" ; then
	CFLAGS="$wi_os_default_cflags"
fi
echo "$ac_t""$wi_os_default_cflags" 1>&6

	
	case "$OS" in
		"solaris"*"-x86_64")
			if test "$GCC" = "yes" ; then
				case "$CFLAGS" in
					*"-m64"*)
						;;
					*)
						CFLAGS="-m64 $CFLAGS"
						;;
				esac
			fi
			;;
	esac

	

if test "x$wi_request_no_y2k_warnings" = xyes ; then
case "${wi_cv_gcc_version-0}" in
	0|1.*|2.[012345678].*)
		;;
	*)
		case "$CFLAGS" in
			*-Wno-format-y2k*)
				;;
			*)
				oldCFLAGS="$CFLAGS"
				CFLAGS="$CFLAGS -Wno-format-y2k"
				#
				# Now check if this version of GCC
				# accepts this flag...
				#
				cat > conftest.$ac_ext <<EOF
#line 1940 "configure"
#include "confdefs.h"

int main() {
int junk;
; return 0; }
EOF
if { (eval echo configure:1947: \"$ac_compile\") 1>&5; (eval $ac_compile) 2>&5; }; then
  :
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  CFLAGS="$oldCFLAGS"
fi
rm -rf conftest*
				unset oldCFLAGS
				;;
		esac
		;;
esac
fi

	
echo $ac_n "checking for ldd""... $ac_c" 1>&6
echo "configure:1965: checking for ldd" >&5
if eval "test \"`echo '$''{'wi_cv_prog_ldd'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  
wi_cv_prog_ldd="no"
	cat > conftest.c <<EOF
#include <stdio.h>
#include <stdlib.h>
int main(int argc, char **argv)
{
	(void) printf("%s\n", ((argc > 66) ? argv[0] : "Hello World"));
	exit(0);
}
EOF
	${CC-cc} $CFLAGS $CPPFLAGS conftest.c -o conftest 1>&5
	wi_cv_prog_ldd=`ldd ./conftest 2>&1 | sed -n -e '/lib/{s/.*/yes/g;p;q;}' -e '${s/.*/no/g;p;q;}'`
	/bin/rm -rf conftest*

fi

echo "$ac_t""$wi_cv_prog_ldd" 1>&6

	if test "$use_ssp" = yes  ;then
		

ac_cv_ssp_flags='-fstack-protector-all -D_FORTIFY_SOURCE=2'
oldCFLAGS="$CFLAGS"
# remove existing ssp flags, if present
CFLAGS=`echo "$CFLAGS" | sed 's/-D_FORTIFY_SOURCE//g'`
CFLAGS=`echo "$CFLAGS" | sed 's/-D_FORTIFY_SOURCE=.//g'`
CFLAGS=`echo "$CFLAGS" | sed 's/-fstack-prot[a-z\-]*//g'`
# try these
CFLAGS="$CFLAGS $ac_cv_ssp_flags"
cat > conftest.$ac_ext <<EOF
#line 2000 "configure"
#include "confdefs.h"

#include <stdio.h>
char testvar[64];

int main() {

	strncpy(testvar, "hello world", sizeof(testvar) - 1);

; return 0; }
EOF
if { (eval echo configure:2012: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  :
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  CFLAGS="$oldCFLAGS" ; ac_cv_ssp_flags="no"
fi
rm -rf conftest*
if test "$SYS" = macosx ; then
	if test "${use_macosx_universal}" != no ; then
		CFLAGS="$oldCFLAGS" ; ac_cv_ssp_flags="not compatible with Mac OS X universal"
	fi
fi
unset oldCFLAGS
echo $ac_n "checking if stack protection CFLAGS can be used""... $ac_c" 1>&6
echo "configure:2028: checking if stack protection CFLAGS can be used" >&5
echo "$ac_t""$ac_cv_ssp_flags" 1>&6

			fi
	
echo $ac_n "checking if compiled programs use a shared library version of libgcc""... $ac_c" 1>&6
echo "configure:2034: checking if compiled programs use a shared library version of libgcc" >&5
if eval "test \"`echo '$''{'wi_cv_shared_libgcc'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  
	if test "$wi_cv_prog_ldd" = no ; then
		wi_cv_shared_libgcc="unknown (ldd is not available to check)"
	else
		cat > conftest.c <<EOF
#include <stdio.h>
#include <stdlib.h>
int main(int argc, char **argv)
{
	(void) printf("%s\n", ((argc > 66) ? argv[0] : "Hello World"));
	exit(0);
}
EOF
		${CC-cc} $CFLAGS $CPPFLAGS conftest.c -o conftest 1>&5
		wi_cv_shared_libgcc=`ldd ./conftest 2>&1 | sed -n -e '/libgcc/{s/.*/yes/g;p;q;}' -e '${s/.*/no/g;p;q;}'`
		/bin/rm -rf conftest*
	fi

fi

echo "$ac_t""$wi_cv_shared_libgcc" 1>&6
	if test "$wi_cv_shared_libgcc" != no ; then
		
	if test "x$ac_cv_prog_gcc" = "xyes" ; then
		case "$CFLAGS" in
			*-static-libgcc*)
				;;
			*)
				oldCFLAGS="$CFLAGS"
				CFLAGS="$CFLAGS -static-libgcc"
				#
				# Now check if this version of GCC
				# accepts this flag...
				#
				cat > conftest.$ac_ext <<EOF
#line 2073 "configure"
#include "confdefs.h"

#include <stdio.h>
char testvar[64];

int main() {
strncpy(testvar, "hello world", sizeof(testvar) - 1);
; return 0; }
EOF
if { (eval echo configure:2083: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  :
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  CFLAGS="$oldCFLAGS"
fi
rm -rf conftest*
				unset oldCFLAGS
				;;
		esac
	fi

	fi

	
	if test "x$cross_compiling" = "xyes" ; then
		
	if test "x$ac_cv_prog_gcc" = "xyes" ; then
		case "$CFLAGS" in
			*-static-libgcc*)
				;;
			*)
				oldCFLAGS="$CFLAGS"
				CFLAGS="$CFLAGS -static-libgcc"
				#
				# Now check if this version of GCC
				# accepts this flag...
				#
				cat > conftest.$ac_ext <<EOF
#line 2114 "configure"
#include "confdefs.h"

#include <stdio.h>
char testvar[64];

int main() {
strncpy(testvar, "hello world", sizeof(testvar) - 1);
; return 0; }
EOF
if { (eval echo configure:2124: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  :
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  CFLAGS="$oldCFLAGS"
fi
rm -rf conftest*
				unset oldCFLAGS
				;;
		esac
	fi

	fi

	add_O0="no"
	if [ "$NOOPTCFLAGS" = "" ] ; then
		NOOPTCFLAGS=`echo "$CFLAGS" | sed 's/[-+]O[0-9A-Za-z]*//g;s/-xO[0-9]//g;s/-Wc,-O3//g;s/-IPA//g;s/-xipo=?[0-9]?//g;s/\ \ */ /g;s/^\ *//;s/\ *$//;'`
		if [ "$GCC" = "yes" ] ; then
			add_O0="yes"
		else
			case "$CC" in
				ccc|*/ccc)
					# Compaq CC
					add_O0="yes"
					;;
			esac
		fi
	fi
	if [ "$DEBUGCFLAGS" = "" ] ; then
		DEBUGCFLAGS="-g $NOOPTCFLAGS"
	fi
	if [ "$add_O0" = yes ] ; then
		NOOPTCFLAGS="-O0 $NOOPTCFLAGS"
	fi
	#
	# Was it ./configure --enable-debug ?
	#
	echo $ac_n "checking if this is a debug build""... $ac_c" 1>&6
echo "configure:2164: checking if this is a debug build" >&5
	if test "$DEBUGBUILD" = yes ; then
		echo "$ac_t""yes" 1>&6
		CFLAGS="$DEBUGCFLAGS"
	else
		echo "$ac_t""no" 1>&6
	fi

result="no"
wi_cv_lfs64="no"
if test "os_${os}_gcc_${GCC}" = os_hp-ux_gcc_yes ; then
	
CFLAGS=`echo "$CFLAGS" | sed s/-D__STDC_EXT__//g`
echo $ac_n "checking if -D__STDC_EXT__ is needed with GCC on HP-UX""... $ac_c" 1>&6
echo "configure:2178: checking if -D__STDC_EXT__ is needed with GCC on HP-UX" >&5
if test "$cross_compiling" = yes; then
  
	# action if cross-compiling, guess
	CFLAGS="-D__STDC_EXT__ $CFLAGS"
	echo "$ac_t""(guessing) yes" 1>&6

else
  cat > conftest.$ac_ext <<EOF
#line 2187 "configure"
#include "confdefs.h"

#include <stdio.h>
 
main()
{
#ifdef __STDC_EXT__
	if (__STDC_EXT__ == 0)
		exit(1);		/* have __STDC_EXT__=0 */
	exit(0);			/* have __STDC_EXT__=1 */
#else
	exit(1);			/* do not have __STDC_EXT__ */
#endif
}
EOF
if { (eval echo configure:2203: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext} && (./conftest; exit) 2>/dev/null
then
  
	# action if true
	#
	# Already have it defined.
	#
	echo "$ac_t""no" 1>&6

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -fr conftest*
  
	# action if false
	#
	# Not defined -- we need to define it then.
	# This is required for the extended
	# namespace symbols for Large Files.
	#
	CFLAGS="-D__STDC_EXT__ $CFLAGS"
	echo "$ac_t""yes" 1>&6

fi
rm -fr conftest*
fi


fi
for ac_hdr in unistd.h
do
ac_safe=`echo "$ac_hdr" | sed 'y%./+-%__p_%'`
echo $ac_n "checking for $ac_hdr""... $ac_c" 1>&6
echo "configure:2236: checking for $ac_hdr" >&5
if eval "test \"`echo '$''{'ac_cv_header_$ac_safe'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 2241 "configure"
#include "confdefs.h"
#include <$ac_hdr>
EOF
ac_try="$ac_cpp conftest.$ac_ext >/dev/null 2>conftest.out"
{ (eval echo configure:2246: \"$ac_try\") 1>&5; (eval $ac_try) 2>&5; }
ac_err=`grep -v '^ *+' conftest.out | grep -v "^conftest.${ac_ext}\$"`
if test -z "$ac_err"; then
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=yes"
else
  echo "$ac_err" >&5
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=no"
fi
rm -rf conftest*
fi
if eval "test \"`echo '$ac_cv_header_'$ac_safe`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_hdr=HAVE_`echo $ac_hdr | sed 'y%abcdefghijklmnopqrstuvwxyz./-%ABCDEFGHIJKLMNOPQRSTUVWXYZ___%'`
  cat >> confdefs.h <<EOF
#define $ac_tr_hdr 1
EOF
 
else
  echo "$ac_t""no" 1>&6
fi
done

if test "x$ac_cv_sizeof_stat_st_size" = x ; then
	
echo $ac_n "checking size of st_size field in struct stat""... $ac_c" 1>&6
echo "configure:2275: checking size of st_size field in struct stat" >&5

	if test "x$ac_cv_header_unistd_h" = x ; then
		{ echo "configure: error: Script needs to check for <unistd.h> before calling wi_SIZEOF_ST_SIZE." 1>&2; exit 1; }
	fi

if test "$cross_compiling" = yes; then
  
	# action if cross compiling
	x="unknown"
	ac_cv_sizeof_stat_st_size="4"
	rm -f conftest.out

else
  cat > conftest.$ac_ext <<EOF
#line 2290 "configure"
#include "confdefs.h"

	/* program */
#if defined(AIX) || defined(_AIX) || defined(__HOS_AIX__)
#	define _ALL_SOURCE 1
#endif
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
 
main()
{
	struct stat x;
	FILE *fp;

	fp = fopen("conftest.out", "w");
	if (fp != NULL) {
		fprintf(fp, "%u\n", (unsigned int) sizeof(x.st_size));
		fclose(fp);
		exit(0);	/* OK */
	}
	exit(1);		/* Not OK */
}

EOF
if { (eval echo configure:2320: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext} && (./conftest; exit) 2>/dev/null
then
  
	# action if true
	x=`cat conftest.out`
	case "$x" in
		[0-9]*)
												ac_cv_sizeof_stat_st_size="$x"
			;;
		*)
			x="failed"
			ac_cv_sizeof_stat_st_size="4"
			;;
	esac
	rm -f conftest.out

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -fr conftest*
  
	# action if false
	x="failed"
	ac_cv_sizeof_stat_st_size="4"
	rm -f conftest.out

fi
rm -fr conftest*
fi

echo "$ac_t""$x" 1>&6

fi
if test "x$ac_cv_sizeof_off_t" = x ; then
	
echo $ac_n "checking size of off_t""... $ac_c" 1>&6
echo "configure:2356: checking size of off_t" >&5

	if test "x$ac_cv_header_unistd_h" = x ; then
		{ echo "configure: error: Script needs to check for <unistd.h> before calling wi_SIZEOF_OFF_T." 1>&2; exit 1; }
	fi

if test "$cross_compiling" = yes; then
  
	# action if cross compiling
	x="unknown"
	ac_cv_sizeof_off_t="4"
	rm -f conftest.out

else
  cat > conftest.$ac_ext <<EOF
#line 2371 "configure"
#include "confdefs.h"

	/* program */
#if defined(AIX) || defined(_AIX) || defined(__HOS_AIX__)
#	define _ALL_SOURCE 1
#endif
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
 
main()
{
	off_t x = 0;
	FILE *fp;

	fp = fopen("conftest.out", "w");
	if (fp != NULL) {
		fprintf(fp, "%u\n", (unsigned int) sizeof(x));
		fclose(fp);
		exit(0);	/* OK */
	}
	exit(1);		/* Not OK */
}

EOF
if { (eval echo configure:2401: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext} && (./conftest; exit) 2>/dev/null
then
  
	# action if true
	x=`cat conftest.out`
	case "$x" in
		[0-9]*)
												ac_cv_sizeof_off_t="$x"
			;;
		*)
			x="failed"
			ac_cv_sizeof_off_t="4"
			;;
	esac
	rm -f conftest.out

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -fr conftest*
  
	# action if false
	x="failed"
	ac_cv_sizeof_off_t="4"
	rm -f conftest.out

fi
rm -fr conftest*
fi

echo "$ac_t""$x" 1>&6

fi
if test "$ac_cv_sizeof_stat_st_size" -le 4 || test "$ac_cv_sizeof_off_t" -le 4 ; then
	unset ac_cv_sizeof_stat_st_size ac_cv_sizeof_off_t
	case "$CFLAGS" in
		*-D_LARGEFILE64_SOURCE*)
			result="already included -D_LARGEFILE64_SOURCE"
			;;
		*)
			CFLAGS="-D_LARGEFILE64_SOURCE $CFLAGS"
			DEBUGCFLAGS="-D_LARGEFILE64_SOURCE $DEBUGCFLAGS"
			NOOPTCFLAGS="-D_LARGEFILE64_SOURCE $NOOPTCFLAGS"
			result="-D_LARGEFILE64_SOURCE"
			;;
	esac
	wi_cv_lfs64="yes"
	
echo $ac_n "checking size of st_size field in struct stat64""... $ac_c" 1>&6
echo "configure:2450: checking size of st_size field in struct stat64" >&5

	if test "x$ac_cv_header_unistd_h" = x ; then
		{ echo "configure: error: Script needs to check for <unistd.h> before calling wi_SIZEOF_STAT64_ST_SIZE." 1>&2; exit 1; }
	fi

if test "$cross_compiling" = yes; then
  
	# action if cross compiling
	x="unknown"
	ac_cv_sizeof_stat64_st_size="8"
	rm -f conftest.out

else
  cat > conftest.$ac_ext <<EOF
#line 2465 "configure"
#include "confdefs.h"

	/* program */
#if defined(AIX) || defined(_AIX) || defined(__HOS_AIX__)
#	define _ALL_SOURCE 1
#endif
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
 
main()
{
	struct stat64 x;
	FILE *fp;

	fp = fopen("conftest.out", "w");
	if (fp != NULL) {
		fprintf(fp, "%u\n", (unsigned int) sizeof(x.st_size));
		fclose(fp);
		exit(0);	/* OK */
	}
	exit(1);		/* Not OK */
}

EOF
if { (eval echo configure:2495: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext} && (./conftest; exit) 2>/dev/null
then
  
	# action if true
	x=`cat conftest.out`
	case "$x" in
		[0-9]*)
			cat >> confdefs.h <<EOF
#define SIZEOF_STAT64_ST_SIZE $x
EOF

			ac_cv_sizeof_stat64_st_size="$x"
			;;
		*)
			x="failed"
			ac_cv_sizeof_stat64_st_size="4"
			;;
	esac
	rm -f conftest.out

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -fr conftest*
  
	# action if false
	x="failed"
	ac_cv_sizeof_stat64_st_size="4"
	rm -f conftest.out

fi
rm -fr conftest*
fi

echo "$ac_t""$x" 1>&6

	
echo $ac_n "checking size of off64_t""... $ac_c" 1>&6
echo "configure:2533: checking size of off64_t" >&5

	if test "x$ac_cv_header_unistd_h" = x ; then
		{ echo "configure: error: Script needs to check for <unistd.h> before calling wi_SIZEOF_OFF64_T." 1>&2; exit 1; }
	fi

if test "$cross_compiling" = yes; then
  
	# action if cross compiling
	x="unknown"
	ac_cv_sizeof_off64_t="8"
	rm -f conftest.out

else
  cat > conftest.$ac_ext <<EOF
#line 2548 "configure"
#include "confdefs.h"

	/* program */
#if defined(AIX) || defined(_AIX) || defined(__HOS_AIX__)
#	define _ALL_SOURCE 1
#endif
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
 
main()
{
	off64_t x = 0;
	FILE *fp;

	fp = fopen("conftest.out", "w");
	if (fp != NULL) {
		fprintf(fp, "%u\n", (unsigned int) sizeof(x));
		fclose(fp);
		exit(0);	/* OK */
	}
	exit(1);		/* Not OK */
}

EOF
if { (eval echo configure:2578: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext} && (./conftest; exit) 2>/dev/null
then
  
	# action if true
	x=`cat conftest.out`
	case "$x" in
		[0-9]*)
			cat >> confdefs.h <<EOF
#define SIZEOF_OFF64_T $x
EOF

			ac_cv_sizeof_off64_t="$x"
			;;
		*)
			x="failed"
			ac_cv_sizeof_off64_t="4"
			;;
	esac
	rm -f conftest.out

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -fr conftest*
  
	# action if false
	x="failed"
	ac_cv_sizeof_off64_t="4"
	rm -f conftest.out

fi
rm -fr conftest*
fi

echo "$ac_t""$x" 1>&6

	
echo $ac_n "checking size of st_size field in struct stat""... $ac_c" 1>&6
echo "configure:2616: checking size of st_size field in struct stat" >&5

	if test "x$ac_cv_header_unistd_h" = x ; then
		{ echo "configure: error: Script needs to check for <unistd.h> before calling wi_SIZEOF_ST_SIZE." 1>&2; exit 1; }
	fi

if test "$cross_compiling" = yes; then
  
	# action if cross compiling
	x="unknown"
	ac_cv_sizeof_stat_st_size="4"
	rm -f conftest.out

else
  cat > conftest.$ac_ext <<EOF
#line 2631 "configure"
#include "confdefs.h"

	/* program */
#if defined(AIX) || defined(_AIX) || defined(__HOS_AIX__)
#	define _ALL_SOURCE 1
#endif
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
 
main()
{
	struct stat x;
	FILE *fp;

	fp = fopen("conftest.out", "w");
	if (fp != NULL) {
		fprintf(fp, "%u\n", (unsigned int) sizeof(x.st_size));
		fclose(fp);
		exit(0);	/* OK */
	}
	exit(1);		/* Not OK */
}

EOF
if { (eval echo configure:2661: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext} && (./conftest; exit) 2>/dev/null
then
  
	# action if true
	x=`cat conftest.out`
	case "$x" in
		[0-9]*)
												ac_cv_sizeof_stat_st_size="$x"
			;;
		*)
			x="failed"
			ac_cv_sizeof_stat_st_size="4"
			;;
	esac
	rm -f conftest.out

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -fr conftest*
  
	# action if false
	x="failed"
	ac_cv_sizeof_stat_st_size="4"
	rm -f conftest.out

fi
rm -fr conftest*
fi

echo "$ac_t""$x" 1>&6

	
echo $ac_n "checking size of off_t""... $ac_c" 1>&6
echo "configure:2695: checking size of off_t" >&5

	if test "x$ac_cv_header_unistd_h" = x ; then
		{ echo "configure: error: Script needs to check for <unistd.h> before calling wi_SIZEOF_OFF_T." 1>&2; exit 1; }
	fi

if test "$cross_compiling" = yes; then
  
	# action if cross compiling
	x="unknown"
	ac_cv_sizeof_off_t="4"
	rm -f conftest.out

else
  cat > conftest.$ac_ext <<EOF
#line 2710 "configure"
#include "confdefs.h"

	/* program */
#if defined(AIX) || defined(_AIX) || defined(__HOS_AIX__)
#	define _ALL_SOURCE 1
#endif
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
 
main()
{
	off_t x = 0;
	FILE *fp;

	fp = fopen("conftest.out", "w");
	if (fp != NULL) {
		fprintf(fp, "%u\n", (unsigned int) sizeof(x));
		fclose(fp);
		exit(0);	/* OK */
	}
	exit(1);		/* Not OK */
}

EOF
if { (eval echo configure:2740: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext} && (./conftest; exit) 2>/dev/null
then
  
	# action if true
	x=`cat conftest.out`
	case "$x" in
		[0-9]*)
												ac_cv_sizeof_off_t="$x"
			;;
		*)
			x="failed"
			ac_cv_sizeof_off_t="4"
			;;
	esac
	rm -f conftest.out

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -fr conftest*
  
	# action if false
	x="failed"
	ac_cv_sizeof_off_t="4"
	rm -f conftest.out

fi
rm -fr conftest*
fi

echo "$ac_t""$x" 1>&6

fi

if test "x$ac_cv_sizeof_stat_st_size" != x ; then
	cat >> confdefs.h <<EOF
#define SIZEOF_ST_SIZE $ac_cv_sizeof_stat_st_size
EOF

fi
if test "x$ac_cv_sizeof_off_t" != x ; then
	cat >> confdefs.h <<EOF
#define SIZEOF_OFF_T $ac_cv_sizeof_off_t
EOF

fi

echo $ac_n "checking if we should add CFLAGS for LFS64 support""... $ac_c" 1>&6
echo "configure:2788: checking if we should add CFLAGS for LFS64 support" >&5
echo "$ac_t""$result" 1>&6

else
	


	

if test "$GCC" = yes ; then
	echo $ac_n "checking the version of GCC""... $ac_c" 1>&6
echo "configure:2799: checking the version of GCC" >&5
if eval "test \"`echo '$''{'wi_cv_gcc_version'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  
	wi_cv_gcc_version=`$CC -v 2>&1 | sed -n '/gcc version/{s/^.*gcc version//;s/^[^1-9]*//;s/\ .*//;p;q;}'`

fi

echo "$ac_t""$wi_cv_gcc_version" 1>&6
else
	wi_cv_gcc_version="0"
fi

	
	

if test "${SYS}_${GCC}" != solaris_no ; then
	wi_cv_cc_is_sunwspro_cc="no"
	wi_cv_sunwspro_cc_version="0"
	wi_cv_sunwspro_cc_version2="0"
else
	echo $ac_n "checking if the C compiler is Sun WorkShop C""... $ac_c" 1>&6
echo "configure:2822: checking if the C compiler is Sun WorkShop C" >&5
if eval "test \"`echo '$''{'wi_cv_cc_is_sunwspro_cc'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  
#
# cc: Sun WorkShop 6 update 2 C 5.3 2001/05/15
# usage: cc [ options] files.  Use 'cc -flags' for details
#
# cc: WorkShop Compilers 4.2 30 Oct 1996 C 4.2
# usage: cc [ options] files.  Use 'cc -flags' for details
#
		wi_cv_sunwspro_cc_version=`$CC -V 2>&1 | sed -n '/WorkShop.*C\ [1-9]/{s/^.*C/C/;s/^C\ \([^\ ]*\).*/\1/;p;q;}'`
		case "$wi_cv_sunwspro_cc_version" in
			[1-9]*)
				wi_cv_cc_is_sunwspro_cc="yes"
				ver1=`echo "$wi_cv_sunwspro_cc_version" | cut -d. -f1`
				ver2=`echo "$wi_cv_sunwspro_cc_version" | cut -d. -f2`
				ver3=0
				wi_cv_sunwspro_cc_version2=`expr "$ver1" '*' 100 + "$ver2" "*" 10 + "$ver3"`
				unset ver1 ver2 ver3
				;;
			*)
				wi_cv_cc_is_sunwspro_cc="no"
				wi_cv_sunwspro_cc_version="0"
				wi_cv_sunwspro_cc_version2="0"
				;;
		esac
	
fi

echo "$ac_t""$wi_cv_cc_is_sunwspro_cc" 1>&6
	if test "$wi_cv_cc_is_sunwspro_cc" = yes ; then
		echo $ac_n "checking output of "cc -V" to determine version of Sun WorkShop C""... $ac_c" 1>&6
echo "configure:2856: checking output of "cc -V" to determine version of Sun WorkShop C" >&5
		echo "$ac_t"""version $wi_cv_sunwspro_cc_version"" 1>&6
	fi
fi

	
echo $ac_n "checking if we should customize your CFLAGS environment variable""... $ac_c" 1>&6
echo "configure:2863: checking if we should customize your CFLAGS environment variable" >&5
wi_replace_O_with_g="no"
case "$wi_orig_CFLAGS" in
	"")
		wi_replace_O_with_g="no"
		;;
	"-g -O2")
		wi_replace_O_with_g="no"
		;;
	"-g -O")
		wi_replace_O_with_g="no"
		;;
	"-O2 -g")
		wi_replace_O_with_g="no"
		;;
	"-O -g")
		wi_replace_O_with_g="no"
		;;
	-g)
		wi_replace_O_with_g="yes"
		;;
esac

#
# See if your CFLAGS environment variable wasn't set or exported,
# or if you are using a conservative default.  If so, we will
# add some additional flags for better performance, warning reporting,
# etc.
#
# Note we are now checking the current value of CFLAGS, which may have
# been changed by configure.
#
wi_os_default_cflags="no"
case "$CFLAGS" in
	"")
		wi_os_default_cflags="yes"
		;;
	"-g -O2")
		wi_os_default_cflags="yes"
		;;
	"-g -O")
		wi_os_default_cflags="yes"
		;;
	"-O2 -g")
		wi_os_default_cflags="yes"
		;;
	"-O -g")
		wi_os_default_cflags="yes"
		;;
	-g)
		wi_os_default_cflags="yes"
		;;
	-O)
		wi_os_default_cflags="yes"
		;;
	-O2)
		wi_os_default_cflags="yes"
		;;
esac

CC_is_clang="no"
case "$CC" in
	*clang*)
		CC_is_clang="yes"
		;;
	*)
		cc_dash_v=`${CC-gcc} -v 2>&1 | grep clang 2>/dev/null`
		if test -n "$cc_dash_v" ; then
			CC_is_clang="yes"
		fi
		;;
esac

if test "$wi_os_default_cflags" = yes ; then
	if test "$CC_is_clang" = yes ; then
		wi_os_default_cflags="-Weverything -Wno-unknown-warning-option -Wno-disabled-macro-expansion -Wno-missing-variable-declarations -Wno-date-time"
		if test "$wi_replace_O_with_g" = yes ; then
			wi_os_default_cflags="-g $wi_os_default_cflags"
		else
			wi_os_default_cflags="-O2 $wi_os_default_cflags"
		fi
	elif test "$GCC" = yes ; then
		#
		# gcc
		#
		wi_gcc_optimizer_flags=''
		case "$wi_cv_gcc_version" in
			2.7.*|2.8.*|2.9*)
				wi_os_default_cflags="-W -Wall -Wstrict-prototypes -Wmissing-prototypes -Wshadow -Wbad-function-cast -Wpointer-arith -Wcast-qual -Wcast-align -Wwrite-strings -Wmissing-declarations -Winline"
				;;
			345.*)
				wi_os_default_cflags="-W -Wall -Wstrict-prototypes -Wmissing-prototypes -Wshadow -Wbad-function-cast -Wpointer-arith -Wcast-qual -Wcast-align -Wwrite-strings -Wmissing-declarations -Winline -Wmissing-format-attribute -Wformat-security"
				wi_gcc_optimizer_flags='-Wdisabled-optimization'
				;;
			*)
				wi_os_default_cflags="-W -Wall"
				;;
		esac
		if test "$wi_replace_O_with_g" = yes ; then
			wi_os_default_cflags="-g $wi_os_default_cflags"
		else
			wi_os_default_cflags="-O2 $wi_os_default_cflags"
			if test "$wi_gcc_optimizer_flags" != "" ; then
				wi_os_default_cflags="$wi_os_default_cflags $wi_gcc_optimizer_flags"
			fi
		fi
		case "$OS" in
			hpux*)
				wi_os_default_cflags="-D_HPUX_SOURCE $wi_os_default_cflags"
				;;
			bsdos*)
				wi_os_default_cflags=`echo "$wi_os_default_cflags" | sed 's/\ -Wcast-qual//g'`		# avoid va_start() problem
				wi_os_default_cflags=`echo "$wi_os_default_cflags" | sed 's/\ -Wredundant-decls//g'`
				;;
			openbsd*|unixware*|openunix*)
				wi_os_default_cflags=`echo "$wi_os_default_cflags" | sed 's/\ -Wredundant-decls//g'`
				;;
		esac
	else
		#
		# regular cc
		#
		case "${wi_replace_O_with_g}_${OS}" in
			no_aix*)
				wi_os_default_cflags="-O -qinfo=cmp:cnd:dcl:eff:gen:ini:par:pro:rea:use -qlonglong -qro -qroconst -qlanglvl=extended -qsrcmsg -qmaxmem=20480 -qsuppress=1506-469:1506-409"
				;;
			yes_aix*)
				wi_os_default_cflags="-g -qinfo=cmp:cnd:dcl:eff:gen:ini:par:pro:rea:use -qlonglong -qro -qroconst -qlanglvl=extended -qsrcmsg -qmaxmem=20480 -qsuppress=1506-469:1506-409"
				;;
			no_irix2345*|no_irix6.01234*)
				wi_os_default_cflags="-O2 -xansi -fullwarn -use_readonly_const -G0 -rdata_shared"
				;;
			yes_irix2345*|yes_irix6.01234*)
				wi_os_default_cflags="-g -xansi -fullwarn -use_readonly_const -G0 -rdata_shared"
				;;
			no_irix*)
				wi_os_default_cflags="-O2 -IPA -xansi -fullwarn -use_readonly_const -G0 -rdata_shared -woff 1174"
				;;
			yes_irix*)
				wi_os_default_cflags="-g -xansi -fullwarn -use_readonly_const -G0 -rdata_shared -woff 1174"
				;;
			no_digitalunix*)
				wi_os_default_cflags="-O4 -std1 -portable -readonly_strings"
				;;
			yes_digitalunix*)
				wi_os_default_cflags="-g -std1 -portable -readonly_strings"
				;;
			no_hpux*)
				wi_os_default_cflags="-Ae +O2 +Ovolatile +Olibcalls +ESlit +w1 +DAportable"
				;;
			yes_hpux*)
				wi_os_default_cflags="-Ae -g +w1 +DAportable"
				;;
			no_solaris*86|no_solaris*intel)
				# Not really any significant differences
				# from the sparc flags, but reserved for
				# future use.
				#
				if test "$wi_cv_sunwspro_cc_version2" -ge 530 ; then
					wi_os_default_cflags="-xipo -xO4 -xc99 -xbuiltin -xstrconst -dalign -Qn -errtags=yes -erroff=E_END_OF_LOOP_CODE_NOT_REACHED -mc"
				else
					wi_os_default_cflags="-xO4 -xstrconst -dalign -Qn"
				fi
				;;
			yes_solaris*86|yes_solaris*intel)
				if test "$wi_cv_sunwspro_cc_version2" -ge 530 ; then
					wi_os_default_cflags="-g -xc99 -xstrconst -dalign -Qn -errtags=yes -erroff=E_END_OF_LOOP_CODE_NOT_REACHED"
				else
					wi_os_default_cflags="-g -xstrconst -dalign -Qn"
				fi
				;;
			no_solaris*)
				if test "$wi_cv_sunwspro_cc_version2" -ge 530 ; then
					wi_os_default_cflags="-xipo -xO5 -xc99 -xbuiltin -xstrconst -dalign -Qn -errtags=yes -erroff=E_END_OF_LOOP_CODE_NOT_REACHED -mc"
				else
					wi_os_default_cflags="-xO4 -xstrconst -dalign -Qn"
				fi
				;;
			yes_solaris*)
				if test "$wi_cv_sunwspro_cc_version2" -ge 530 ; then
					wi_os_default_cflags="-g -xc99 -xstrconst -dalign -Qn -errtags=yes -erroff=E_END_OF_LOOP_CODE_NOT_REACHED"
				else
					wi_os_default_cflags="-g -xstrconst -dalign -Qn"
				fi
				;;
			no_tru64*)
				wi_os_default_cflags="-O4 -tune host -std1 -readonly_strings -portable -warnprotos -msg_enable level6 -msg_disable longlongtype,hexoctunsign,unusedincl,unnecincl,nestincl,unusedtop,unknownmacro,ignorecallval,strctpadding,truncintasn,truncintcast,trunclongcast,ansialiascast,conststocls,unrefsdecl,subscrbounds2,intconcastsgn,longlongsufx,unreachcode,valuepres,embedcomment"
				;;
			yes_tru64*)
				wi_os_default_cflags="-g -std1 -readonly_strings -portable -warnprotos -msg_enable level6 -msg_disable longlongtype,hexoctunsign,unusedincl,unnecincl,nestincl,unusedtop,unknownmacro,ignorecallval,strctpadding,truncintasn,truncintcast,trunclongcast,ansialiascast,conststocls,unrefsdecl,subscrbounds2,intconcastsgn,longlongsufx,unreachcode,valuepres,embedcomment"
				;;
			no_unixware*|no_openunix*)
				wi_os_default_cflags='-O -K inline -K host -Q n'
				;;
			yes_unixware*|yes_openunix*)
				wi_os_default_cflags='-g -K host -Q n'
				;;
			*)
				wi_os_default_cflags="no"
				;;
		esac
	fi
fi
if test "$wi_os_default_cflags" != "no" ; then
	CFLAGS="$wi_os_default_cflags"
fi
echo "$ac_t""$wi_os_default_cflags" 1>&6

	
	case "$OS" in
		"solaris"*"-x86_64")
			if test "$GCC" = "yes" ; then
				case "$CFLAGS" in
					*"-m64"*)
						;;
					*)
						CFLAGS="-m64 $CFLAGS"
						;;
				esac
			fi
			;;
	esac

	

if test "x$wi_request_no_y2k_warnings" = xyes ; then
case "${wi_cv_gcc_version-0}" in
	0|1.*|2.[012345678].*)
		;;
	*)
		case "$CFLAGS" in
			*-Wno-format-y2k*)
				;;
			*)
				oldCFLAGS="$CFLAGS"
				CFLAGS="$CFLAGS -Wno-format-y2k"
				#
				# Now check if this version of GCC
				# accepts this flag...
				#
				cat > conftest.$ac_ext <<EOF
#line 3104 "configure"
#include "confdefs.h"

int main() {
int junk;
; return 0; }
EOF
if { (eval echo configure:3111: \"$ac_compile\") 1>&5; (eval $ac_compile) 2>&5; }; then
  :
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  CFLAGS="$oldCFLAGS"
fi
rm -rf conftest*
				unset oldCFLAGS
				;;
		esac
		;;
esac
fi

	
echo $ac_n "checking for ldd""... $ac_c" 1>&6
echo "configure:3129: checking for ldd" >&5
if eval "test \"`echo '$''{'wi_cv_prog_ldd'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  
wi_cv_prog_ldd="no"
	cat > conftest.c <<EOF
#include <stdio.h>
#include <stdlib.h>
int main(int argc, char **argv)
{
	(void) printf("%s\n", ((argc > 66) ? argv[0] : "Hello World"));
	exit(0);
}
EOF
	${CC-cc} $CFLAGS $CPPFLAGS conftest.c -o conftest 1>&5
	wi_cv_prog_ldd=`ldd ./conftest 2>&1 | sed -n -e '/lib/{s/.*/yes/g;p;q;}' -e '${s/.*/no/g;p;q;}'`
	/bin/rm -rf conftest*

fi

echo "$ac_t""$wi_cv_prog_ldd" 1>&6

	if test "$use_ssp" = yes  ;then
		

ac_cv_ssp_flags='-fstack-protector-all -D_FORTIFY_SOURCE=2'
oldCFLAGS="$CFLAGS"
# remove existing ssp flags, if present
CFLAGS=`echo "$CFLAGS" | sed 's/-D_FORTIFY_SOURCE//g'`
CFLAGS=`echo "$CFLAGS" | sed 's/-D_FORTIFY_SOURCE=.//g'`
CFLAGS=`echo "$CFLAGS" | sed 's/-fstack-prot[a-z\-]*//g'`
# try these
CFLAGS="$CFLAGS $ac_cv_ssp_flags"
cat > conftest.$ac_ext <<EOF
#line 3164 "configure"
#include "confdefs.h"

#include <stdio.h>
char testvar[64];

int main() {

	strncpy(testvar, "hello world", sizeof(testvar) - 1);

; return 0; }
EOF
if { (eval echo configure:3176: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  :
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  CFLAGS="$oldCFLAGS" ; ac_cv_ssp_flags="no"
fi
rm -rf conftest*
if test "$SYS" = macosx ; then
	if test "${use_macosx_universal}" != no ; then
		CFLAGS="$oldCFLAGS" ; ac_cv_ssp_flags="not compatible with Mac OS X universal"
	fi
fi
unset oldCFLAGS
echo $ac_n "checking if stack protection CFLAGS can be used""... $ac_c" 1>&6
echo "configure:3192: checking if stack protection CFLAGS can be used" >&5
echo "$ac_t""$ac_cv_ssp_flags" 1>&6

			fi
	
echo $ac_n "checking if compiled programs use a shared library version of libgcc""... $ac_c" 1>&6
echo "configure:3198: checking if compiled programs use a shared library version of libgcc" >&5
if eval "test \"`echo '$''{'wi_cv_shared_libgcc'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  
	if test "$wi_cv_prog_ldd" = no ; then
		wi_cv_shared_libgcc="unknown (ldd is not available to check)"
	else
		cat > conftest.c <<EOF
#include <stdio.h>
#include <stdlib.h>
int main(int argc, char **argv)
{
	(void) printf("%s\n", ((argc > 66) ? argv[0] : "Hello World"));
	exit(0);
}
EOF
		${CC-cc} $CFLAGS $CPPFLAGS conftest.c -o conftest 1>&5
		wi_cv_shared_libgcc=`ldd ./conftest 2>&1 | sed -n -e '/libgcc/{s/.*/yes/g;p;q;}' -e '${s/.*/no/g;p;q;}'`
		/bin/rm -rf conftest*
	fi

fi

echo "$ac_t""$wi_cv_shared_libgcc" 1>&6
	if test "$wi_cv_shared_libgcc" != no ; then
		
	if test "x$ac_cv_prog_gcc" = "xyes" ; then
		case "$CFLAGS" in
			*-static-libgcc*)
				;;
			*)
				oldCFLAGS="$CFLAGS"
				CFLAGS="$CFLAGS -static-libgcc"
				#
				# Now check if this version of GCC
				# accepts this flag...
				#
				cat > conftest.$ac_ext <<EOF
#line 3237 "configure"
#include "confdefs.h"

#include <stdio.h>
char testvar[64];

int main() {
strncpy(testvar, "hello world", sizeof(testvar) - 1);
; return 0; }
EOF
if { (eval echo configure:3247: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  :
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  CFLAGS="$oldCFLAGS"
fi
rm -rf conftest*
				unset oldCFLAGS
				;;
		esac
	fi

	fi

	
	if test "x$cross_compiling" = "xyes" ; then
		
	if test "x$ac_cv_prog_gcc" = "xyes" ; then
		case "$CFLAGS" in
			*-static-libgcc*)
				;;
			*)
				oldCFLAGS="$CFLAGS"
				CFLAGS="$CFLAGS -static-libgcc"
				#
				# Now check if this version of GCC
				# accepts this flag...
				#
				cat > conftest.$ac_ext <<EOF
#line 3278 "configure"
#include "confdefs.h"

#include <stdio.h>
char testvar[64];

int main() {
strncpy(testvar, "hello world", sizeof(testvar) - 1);
; return 0; }
EOF
if { (eval echo configure:3288: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  :
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  CFLAGS="$oldCFLAGS"
fi
rm -rf conftest*
				unset oldCFLAGS
				;;
		esac
	fi

	fi

	add_O0="no"
	if [ "$NOOPTCFLAGS" = "" ] ; then
		NOOPTCFLAGS=`echo "$CFLAGS" | sed 's/[-+]O[0-9A-Za-z]*//g;s/-xO[0-9]//g;s/-Wc,-O3//g;s/-IPA//g;s/-xipo=?[0-9]?//g;s/\ \ */ /g;s/^\ *//;s/\ *$//;'`
		if [ "$GCC" = "yes" ] ; then
			add_O0="yes"
		else
			case "$CC" in
				ccc|*/ccc)
					# Compaq CC
					add_O0="yes"
					;;
			esac
		fi
	fi
	if [ "$DEBUGCFLAGS" = "" ] ; then
		DEBUGCFLAGS="-g $NOOPTCFLAGS"
	fi
	if [ "$add_O0" = yes ] ; then
		NOOPTCFLAGS="-O0 $NOOPTCFLAGS"
	fi
	#
	# Was it ./configure --enable-debug ?
	#
	echo $ac_n "checking if this is a debug build""... $ac_c" 1>&6
echo "configure:3328: checking if this is a debug build" >&5
	if test "$DEBUGBUILD" = yes ; then
		echo "$ac_t""yes" 1>&6
		CFLAGS="$DEBUGCFLAGS"
	else
		echo "$ac_t""no" 1>&6
	fi

wi_cv_lfs="no"
result="no"
if test "os_${os}_gcc_${GCC}" = os_hp-ux_gcc_yes ; then
	
CFLAGS=`echo "$CFLAGS" | sed s/-D__STDC_EXT__//g`
echo $ac_n "checking if -D__STDC_EXT__ is needed with GCC on HP-UX""... $ac_c" 1>&6
echo "configure:3342: checking if -D__STDC_EXT__ is needed with GCC on HP-UX" >&5
if test "$cross_compiling" = yes; then
  
	# action if cross-compiling, guess
	CFLAGS="-D__STDC_EXT__ $CFLAGS"
	echo "$ac_t""(guessing) yes" 1>&6

else
  cat > conftest.$ac_ext <<EOF
#line 3351 "configure"
#include "confdefs.h"

#include <stdio.h>
 
main()
{
#ifdef __STDC_EXT__
	if (__STDC_EXT__ == 0)
		exit(1);		/* have __STDC_EXT__=0 */
	exit(0);			/* have __STDC_EXT__=1 */
#else
	exit(1);			/* do not have __STDC_EXT__ */
#endif
}
EOF
if { (eval echo configure:3367: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext} && (./conftest; exit) 2>/dev/null
then
  
	# action if true
	#
	# Already have it defined.
	#
	echo "$ac_t""no" 1>&6

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -fr conftest*
  
	# action if false
	#
	# Not defined -- we need to define it then.
	# This is required for the extended
	# namespace symbols for Large Files.
	#
	CFLAGS="-D__STDC_EXT__ $CFLAGS"
	echo "$ac_t""yes" 1>&6

fi
rm -fr conftest*
fi


fi
for ac_hdr in unistd.h
do
ac_safe=`echo "$ac_hdr" | sed 'y%./+-%__p_%'`
echo $ac_n "checking for $ac_hdr""... $ac_c" 1>&6
echo "configure:3400: checking for $ac_hdr" >&5
if eval "test \"`echo '$''{'ac_cv_header_$ac_safe'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 3405 "configure"
#include "confdefs.h"
#include <$ac_hdr>
EOF
ac_try="$ac_cpp conftest.$ac_ext >/dev/null 2>conftest.out"
{ (eval echo configure:3410: \"$ac_try\") 1>&5; (eval $ac_try) 2>&5; }
ac_err=`grep -v '^ *+' conftest.out | grep -v "^conftest.${ac_ext}\$"`
if test -z "$ac_err"; then
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=yes"
else
  echo "$ac_err" >&5
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=no"
fi
rm -rf conftest*
fi
if eval "test \"`echo '$ac_cv_header_'$ac_safe`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_hdr=HAVE_`echo $ac_hdr | sed 'y%abcdefghijklmnopqrstuvwxyz./-%ABCDEFGHIJKLMNOPQRSTUVWXYZ___%'`
  cat >> confdefs.h <<EOF
#define $ac_tr_hdr 1
EOF
 
else
  echo "$ac_t""no" 1>&6
fi
done

if test "x$ac_cv_sizeof_stat_st_size" = x ; then
	
echo $ac_n "checking size of st_size field in struct stat""... $ac_c" 1>&6
echo "configure:3439: checking size of st_size field in struct stat" >&5

	if test "x$ac_cv_header_unistd_h" = x ; then
		{ echo "configure: error: Script needs to check for <unistd.h> before calling wi_SIZEOF_ST_SIZE." 1>&2; exit 1; }
	fi

if test "$cross_compiling" = yes; then
  
	# action if cross compiling
	x="unknown"
	ac_cv_sizeof_stat_st_size="4"
	rm -f conftest.out

else
  cat > conftest.$ac_ext <<EOF
#line 3454 "configure"
#include "confdefs.h"

	/* program */
#if defined(AIX) || defined(_AIX) || defined(__HOS_AIX__)
#	define _ALL_SOURCE 1
#endif
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
 
main()
{
	struct stat x;
	FILE *fp;

	fp = fopen("conftest.out", "w");
	if (fp != NULL) {
		fprintf(fp, "%u\n", (unsigned int) sizeof(x.st_size));
		fclose(fp);
		exit(0);	/* OK */
	}
	exit(1);		/* Not OK */
}

EOF
if { (eval echo configure:3484: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext} && (./conftest; exit) 2>/dev/null
then
  
	# action if true
	x=`cat conftest.out`
	case "$x" in
		[0-9]*)
												ac_cv_sizeof_stat_st_size="$x"
			;;
		*)
			x="failed"
			ac_cv_sizeof_stat_st_size="4"
			;;
	esac
	rm -f conftest.out

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -fr conftest*
  
	# action if false
	x="failed"
	ac_cv_sizeof_stat_st_size="4"
	rm -f conftest.out

fi
rm -fr conftest*
fi

echo "$ac_t""$x" 1>&6

fi
if test "x$ac_cv_sizeof_off_t" = x ; then
	
echo $ac_n "checking size of off_t""... $ac_c" 1>&6
echo "configure:3520: checking size of off_t" >&5

	if test "x$ac_cv_header_unistd_h" = x ; then
		{ echo "configure: error: Script needs to check for <unistd.h> before calling wi_SIZEOF_OFF_T." 1>&2; exit 1; }
	fi

if test "$cross_compiling" = yes; then
  
	# action if cross compiling
	x="unknown"
	ac_cv_sizeof_off_t="4"
	rm -f conftest.out

else
  cat > conftest.$ac_ext <<EOF
#line 3535 "configure"
#include "confdefs.h"

	/* program */
#if defined(AIX) || defined(_AIX) || defined(__HOS_AIX__)
#	define _ALL_SOURCE 1
#endif
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
 
main()
{
	off_t x = 0;
	FILE *fp;

	fp = fopen("conftest.out", "w");
	if (fp != NULL) {
		fprintf(fp, "%u\n", (unsigned int) sizeof(x));
		fclose(fp);
		exit(0);	/* OK */
	}
	exit(1);		/* Not OK */
}

EOF
if { (eval echo configure:3565: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext} && (./conftest; exit) 2>/dev/null
then
  
	# action if true
	x=`cat conftest.out`
	case "$x" in
		[0-9]*)
												ac_cv_sizeof_off_t="$x"
			;;
		*)
			x="failed"
			ac_cv_sizeof_off_t="4"
			;;
	esac
	rm -f conftest.out

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -fr conftest*
  
	# action if false
	x="failed"
	ac_cv_sizeof_off_t="4"
	rm -f conftest.out

fi
rm -fr conftest*
fi

echo "$ac_t""$x" 1>&6

fi
if test "x$ac_cv_sizeof_size_t" = x ; then
	
echo $ac_n "checking size of size_t""... $ac_c" 1>&6
echo "configure:3601: checking size of size_t" >&5

	if test "x$ac_cv_header_unistd_h" = x ; then
		{ echo "configure: error: Script needs to check for <unistd.h> before calling wi_SIZEOF_SIZE_T." 1>&2; exit 1; }
	fi

if test "$cross_compiling" = yes; then
  
	# action if cross compiling
	x="unknown"
	ac_cv_sizeof_size_t="4"
	rm -f conftest.out

else
  cat > conftest.$ac_ext <<EOF
#line 3616 "configure"
#include "confdefs.h"

	/* program */
#if defined(AIX) || defined(_AIX) || defined(__HOS_AIX__)
#	define _ALL_SOURCE 1
#endif
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
 
main()
{
	size_t x = 0;
	FILE *fp;

	fp = fopen("conftest.out", "w");
	if (fp != NULL) {
		fprintf(fp, "%u\n", (unsigned int) sizeof(x));
		fclose(fp);
		exit(0);	/* OK */
	}
	exit(1);		/* Not OK */
}

EOF
if { (eval echo configure:3646: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext} && (./conftest; exit) 2>/dev/null
then
  
	# action if true
	x=`cat conftest.out`
	case "$x" in
		[0-9]*)
												ac_cv_sizeof_size_t="$x"
			;;
		*)
			x="failed"
			ac_cv_sizeof_size_t="4"
			;;
	esac
	rm -f conftest.out

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -fr conftest*
  
	# action if false
	x="failed"
	ac_cv_sizeof_size_t="4"
	rm -f conftest.out

fi
rm -fr conftest*
fi

echo "$ac_t""$x" 1>&6

fi
orig_CFLAGS="$CFLAGS"
if test "$ac_cv_sizeof_stat_st_size" -le 4 || test "$ac_cv_sizeof_off_t" -le 4 ; then
	unset ac_cv_sizeof_stat_st_size ac_cv_sizeof_off_t
	CFLAGS=`echo "$CFLAGS" | sed 's/-D_LARGEFILE64_SOURCE//g'`
	case "$CFLAGS" in
		*-D_LARGEFILE_SOURCE*)
			result="already included -D_LARGEFILE_SOURCE"
			;;
		*)
			CFLAGS="-D_LARGEFILE_SOURCE -D_FILE_OFFSET_BITS=64 $CFLAGS"
			DEBUGCFLAGS="-D_LARGEFILE_SOURCE -D_FILE_OFFSET_BITS=64 $DEBUGCFLAGS"
			NOOPTCFLAGS="-D_LARGEFILE_SOURCE -D_FILE_OFFSET_BITS=64 $NOOPTCFLAGS"
			result="-D_LARGEFILE_SOURCE -D_FILE_OFFSET_BITS=64"
			;;
	esac
	wi_cv_lfs="yes"
fi
if test "x$ac_cv_sizeof_off_t" = x ; then
	# Recheck, to see if the defines took effect.
	
echo $ac_n "checking size of st_size field in struct stat""... $ac_c" 1>&6
echo "configure:3700: checking size of st_size field in struct stat" >&5

	if test "x$ac_cv_header_unistd_h" = x ; then
		{ echo "configure: error: Script needs to check for <unistd.h> before calling wi_SIZEOF_ST_SIZE." 1>&2; exit 1; }
	fi

if test "$cross_compiling" = yes; then
  
	# action if cross compiling
	x="unknown"
	ac_cv_sizeof_stat_st_size="4"
	rm -f conftest.out

else
  cat > conftest.$ac_ext <<EOF
#line 3715 "configure"
#include "confdefs.h"

	/* program */
#if defined(AIX) || defined(_AIX) || defined(__HOS_AIX__)
#	define _ALL_SOURCE 1
#endif
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
 
main()
{
	struct stat x;
	FILE *fp;

	fp = fopen("conftest.out", "w");
	if (fp != NULL) {
		fprintf(fp, "%u\n", (unsigned int) sizeof(x.st_size));
		fclose(fp);
		exit(0);	/* OK */
	}
	exit(1);		/* Not OK */
}

EOF
if { (eval echo configure:3745: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext} && (./conftest; exit) 2>/dev/null
then
  
	# action if true
	x=`cat conftest.out`
	case "$x" in
		[0-9]*)
												ac_cv_sizeof_stat_st_size="$x"
			;;
		*)
			x="failed"
			ac_cv_sizeof_stat_st_size="4"
			;;
	esac
	rm -f conftest.out

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -fr conftest*
  
	# action if false
	x="failed"
	ac_cv_sizeof_stat_st_size="4"
	rm -f conftest.out

fi
rm -fr conftest*
fi

echo "$ac_t""$x" 1>&6

	
echo $ac_n "checking size of off_t""... $ac_c" 1>&6
echo "configure:3779: checking size of off_t" >&5

	if test "x$ac_cv_header_unistd_h" = x ; then
		{ echo "configure: error: Script needs to check for <unistd.h> before calling wi_SIZEOF_OFF_T." 1>&2; exit 1; }
	fi

if test "$cross_compiling" = yes; then
  
	# action if cross compiling
	x="unknown"
	ac_cv_sizeof_off_t="4"
	rm -f conftest.out

else
  cat > conftest.$ac_ext <<EOF
#line 3794 "configure"
#include "confdefs.h"

	/* program */
#if defined(AIX) || defined(_AIX) || defined(__HOS_AIX__)
#	define _ALL_SOURCE 1
#endif
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
 
main()
{
	off_t x = 0;
	FILE *fp;

	fp = fopen("conftest.out", "w");
	if (fp != NULL) {
		fprintf(fp, "%u\n", (unsigned int) sizeof(x));
		fclose(fp);
		exit(0);	/* OK */
	}
	exit(1);		/* Not OK */
}

EOF
if { (eval echo configure:3824: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext} && (./conftest; exit) 2>/dev/null
then
  
	# action if true
	x=`cat conftest.out`
	case "$x" in
		[0-9]*)
												ac_cv_sizeof_off_t="$x"
			;;
		*)
			x="failed"
			ac_cv_sizeof_off_t="4"
			;;
	esac
	rm -f conftest.out

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -fr conftest*
  
	# action if false
	x="failed"
	ac_cv_sizeof_off_t="4"
	rm -f conftest.out

fi
rm -fr conftest*
fi

echo "$ac_t""$x" 1>&6

	
echo $ac_n "checking size of size_t""... $ac_c" 1>&6
echo "configure:3858: checking size of size_t" >&5

	if test "x$ac_cv_header_unistd_h" = x ; then
		{ echo "configure: error: Script needs to check for <unistd.h> before calling wi_SIZEOF_SIZE_T." 1>&2; exit 1; }
	fi

if test "$cross_compiling" = yes; then
  
	# action if cross compiling
	x="unknown"
	ac_cv_sizeof_size_t="4"
	rm -f conftest.out

else
  cat > conftest.$ac_ext <<EOF
#line 3873 "configure"
#include "confdefs.h"

	/* program */
#if defined(AIX) || defined(_AIX) || defined(__HOS_AIX__)
#	define _ALL_SOURCE 1
#endif
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
 
main()
{
	size_t x = 0;
	FILE *fp;

	fp = fopen("conftest.out", "w");
	if (fp != NULL) {
		fprintf(fp, "%u\n", (unsigned int) sizeof(x));
		fclose(fp);
		exit(0);	/* OK */
	}
	exit(1);		/* Not OK */
}

EOF
if { (eval echo configure:3903: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext} && (./conftest; exit) 2>/dev/null
then
  
	# action if true
	x=`cat conftest.out`
	case "$x" in
		[0-9]*)
												ac_cv_sizeof_size_t="$x"
			;;
		*)
			x="failed"
			ac_cv_sizeof_size_t="4"
			;;
	esac
	rm -f conftest.out

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -fr conftest*
  
	# action if false
	x="failed"
	ac_cv_sizeof_size_t="4"
	rm -f conftest.out

fi
rm -fr conftest*
fi

echo "$ac_t""$x" 1>&6

	if test "$ac_cv_sizeof_stat_st_size" -le 4 || test "$ac_cv_sizeof_off_t" -le 4 ; then
		CFLAGS="$orig_CFLAGS"
		unset orig_CFLAGS
		wi_cv_lfs64="yes"
		CFLAGS="-D_LARGEFILE64_SOURCE $CFLAGS"
		DEBUGCFLAGS="-D_LARGEFILE64_SOURCE $DEBUGCFLAGS"
		NOOPTCFLAGS="-D_LARGEFILE64_SOURCE $NOOPTCFLAGS"
		result="-D_LARGEFILE64_SOURCE"
		# Re-re-check, to see if the defines took effect.
		unset ac_cv_sizeof_stat_st_size ac_cv_sizeof_off_t
		
echo $ac_n "checking size of st_size field in struct stat64""... $ac_c" 1>&6
echo "configure:3947: checking size of st_size field in struct stat64" >&5

	if test "x$ac_cv_header_unistd_h" = x ; then
		{ echo "configure: error: Script needs to check for <unistd.h> before calling wi_SIZEOF_STAT64_ST_SIZE." 1>&2; exit 1; }
	fi

if test "$cross_compiling" = yes; then
  
	# action if cross compiling
	x="unknown"
	ac_cv_sizeof_stat64_st_size="8"
	rm -f conftest.out

else
  cat > conftest.$ac_ext <<EOF
#line 3962 "configure"
#include "confdefs.h"

	/* program */
#if defined(AIX) || defined(_AIX) || defined(__HOS_AIX__)
#	define _ALL_SOURCE 1
#endif
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
 
main()
{
	struct stat64 x;
	FILE *fp;

	fp = fopen("conftest.out", "w");
	if (fp != NULL) {
		fprintf(fp, "%u\n", (unsigned int) sizeof(x.st_size));
		fclose(fp);
		exit(0);	/* OK */
	}
	exit(1);		/* Not OK */
}

EOF
if { (eval echo configure:3992: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext} && (./conftest; exit) 2>/dev/null
then
  
	# action if true
	x=`cat conftest.out`
	case "$x" in
		[0-9]*)
			cat >> confdefs.h <<EOF
#define SIZEOF_STAT64_ST_SIZE $x
EOF

			ac_cv_sizeof_stat64_st_size="$x"
			;;
		*)
			x="failed"
			ac_cv_sizeof_stat64_st_size="4"
			;;
	esac
	rm -f conftest.out

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -fr conftest*
  
	# action if false
	x="failed"
	ac_cv_sizeof_stat64_st_size="4"
	rm -f conftest.out

fi
rm -fr conftest*
fi

echo "$ac_t""$x" 1>&6

		
echo $ac_n "checking size of off64_t""... $ac_c" 1>&6
echo "configure:4030: checking size of off64_t" >&5

	if test "x$ac_cv_header_unistd_h" = x ; then
		{ echo "configure: error: Script needs to check for <unistd.h> before calling wi_SIZEOF_OFF64_T." 1>&2; exit 1; }
	fi

if test "$cross_compiling" = yes; then
  
	# action if cross compiling
	x="unknown"
	ac_cv_sizeof_off64_t="8"
	rm -f conftest.out

else
  cat > conftest.$ac_ext <<EOF
#line 4045 "configure"
#include "confdefs.h"

	/* program */
#if defined(AIX) || defined(_AIX) || defined(__HOS_AIX__)
#	define _ALL_SOURCE 1
#endif
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
 
main()
{
	off64_t x = 0;
	FILE *fp;

	fp = fopen("conftest.out", "w");
	if (fp != NULL) {
		fprintf(fp, "%u\n", (unsigned int) sizeof(x));
		fclose(fp);
		exit(0);	/* OK */
	}
	exit(1);		/* Not OK */
}

EOF
if { (eval echo configure:4075: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext} && (./conftest; exit) 2>/dev/null
then
  
	# action if true
	x=`cat conftest.out`
	case "$x" in
		[0-9]*)
			cat >> confdefs.h <<EOF
#define SIZEOF_OFF64_T $x
EOF

			ac_cv_sizeof_off64_t="$x"
			;;
		*)
			x="failed"
			ac_cv_sizeof_off64_t="4"
			;;
	esac
	rm -f conftest.out

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -fr conftest*
  
	# action if false
	x="failed"
	ac_cv_sizeof_off64_t="4"
	rm -f conftest.out

fi
rm -fr conftest*
fi

echo "$ac_t""$x" 1>&6

		
echo $ac_n "checking size of st_size field in struct stat""... $ac_c" 1>&6
echo "configure:4113: checking size of st_size field in struct stat" >&5

	if test "x$ac_cv_header_unistd_h" = x ; then
		{ echo "configure: error: Script needs to check for <unistd.h> before calling wi_SIZEOF_ST_SIZE." 1>&2; exit 1; }
	fi

if test "$cross_compiling" = yes; then
  
	# action if cross compiling
	x="unknown"
	ac_cv_sizeof_stat_st_size="4"
	rm -f conftest.out

else
  cat > conftest.$ac_ext <<EOF
#line 4128 "configure"
#include "confdefs.h"

	/* program */
#if defined(AIX) || defined(_AIX) || defined(__HOS_AIX__)
#	define _ALL_SOURCE 1
#endif
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
 
main()
{
	struct stat x;
	FILE *fp;

	fp = fopen("conftest.out", "w");
	if (fp != NULL) {
		fprintf(fp, "%u\n", (unsigned int) sizeof(x.st_size));
		fclose(fp);
		exit(0);	/* OK */
	}
	exit(1);		/* Not OK */
}

EOF
if { (eval echo configure:4158: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext} && (./conftest; exit) 2>/dev/null
then
  
	# action if true
	x=`cat conftest.out`
	case "$x" in
		[0-9]*)
												ac_cv_sizeof_stat_st_size="$x"
			;;
		*)
			x="failed"
			ac_cv_sizeof_stat_st_size="4"
			;;
	esac
	rm -f conftest.out

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -fr conftest*
  
	# action if false
	x="failed"
	ac_cv_sizeof_stat_st_size="4"
	rm -f conftest.out

fi
rm -fr conftest*
fi

echo "$ac_t""$x" 1>&6

		
echo $ac_n "checking size of off_t""... $ac_c" 1>&6
echo "configure:4192: checking size of off_t" >&5

	if test "x$ac_cv_header_unistd_h" = x ; then
		{ echo "configure: error: Script needs to check for <unistd.h> before calling wi_SIZEOF_OFF_T." 1>&2; exit 1; }
	fi

if test "$cross_compiling" = yes; then
  
	# action if cross compiling
	x="unknown"
	ac_cv_sizeof_off_t="4"
	rm -f conftest.out

else
  cat > conftest.$ac_ext <<EOF
#line 4207 "configure"
#include "confdefs.h"

	/* program */
#if defined(AIX) || defined(_AIX) || defined(__HOS_AIX__)
#	define _ALL_SOURCE 1
#endif
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
 
main()
{
	off_t x = 0;
	FILE *fp;

	fp = fopen("conftest.out", "w");
	if (fp != NULL) {
		fprintf(fp, "%u\n", (unsigned int) sizeof(x));
		fclose(fp);
		exit(0);	/* OK */
	}
	exit(1);		/* Not OK */
}

EOF
if { (eval echo configure:4237: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext} && (./conftest; exit) 2>/dev/null
then
  
	# action if true
	x=`cat conftest.out`
	case "$x" in
		[0-9]*)
												ac_cv_sizeof_off_t="$x"
			;;
		*)
			x="failed"
			ac_cv_sizeof_off_t="4"
			;;
	esac
	rm -f conftest.out

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -fr conftest*
  
	# action if false
	x="failed"
	ac_cv_sizeof_off_t="4"
	rm -f conftest.out

fi
rm -fr conftest*
fi

echo "$ac_t""$x" 1>&6

	fi
fi
echo $ac_n "checking if we should add CFLAGS for Large File Support""... $ac_c" 1>&6
echo "configure:4272: checking if we should add CFLAGS for Large File Support" >&5
echo "$ac_t""$result" 1>&6
unset orig_CFLAGS

if test "x$ac_cv_sizeof_stat_st_size" != x ; then
	cat >> confdefs.h <<EOF
#define SIZEOF_ST_SIZE $ac_cv_sizeof_stat_st_size
EOF

fi
if test "x$ac_cv_sizeof_off_t" != x ; then
	cat >> confdefs.h <<EOF
#define SIZEOF_OFF_T $ac_cv_sizeof_off_t
EOF

fi


fi


result="no"
case "$CFLAGS" in
	*-D_REENTRANT*)
		result="already included"
		;;
	*)
		CFLAGS="-D_REENTRANT $CFLAGS"
		result="-D_REENTRANT"
		;;
esac
echo $ac_n "checking if we should add CFLAGS for reentrancy""... $ac_c" 1>&6
echo "configure:4304: checking if we should add CFLAGS for reentrancy" >&5
echo "$ac_t""$result" 1>&6



if test "$SYS" = macosx ; then
	ac_cv_macosx_cflags=no
	ac_cv_macosx_ldflags=no

	echo $ac_n "checking if MACOSX_DEPLOYMENT_TARGET environment variable is set""... $ac_c" 1>&6
echo "configure:4314: checking if MACOSX_DEPLOYMENT_TARGET environment variable is set" >&5
	echo "$ac_t""${MACOSX_DEPLOYMENT_TARGET-no}" 1>&6

	test_macosx_sdk_path=`/bin/ls -1d /Developer/SDKs/MacOSX10.*u.sdk 2>/dev/null | sed -n 1,1p`
	if test "${test_macosx_sdk_path}" = "" ; then
		test_macosx_sdk_path="no"
	fi
	case "$test_macosx_sdk_path" in
		*/MacOSX10.4u.sdk)
			#
			# On Snow Leopard, you can't use gcc-4.2 to build the
			# universal binary, but you can use gcc-4.0 if that
			# is also installed.
			#
			case "$wi_cv_gcc_version" in
				[56789]*|4.[123456789]*)
					if [ -e "/usr/bin/gcc-4.0" ] ; then
						CC="/usr/bin/gcc-4.0"
						GCC="/usr/bin/gcc-4.0"
						wi_cv_gcc_version="4.0.1"
					else
						test_macosx_sdk_path="no"
					fi
					;;
			esac
			;;
	esac
	echo $ac_n "checking if Mac OS X universal SDK is available""... $ac_c" 1>&6
echo "configure:4342: checking if Mac OS X universal SDK is available" >&5
	echo "$ac_t""${test_macosx_sdk_path-no}" 1>&6

	if test "${use_macosx_universal}" != no && test "${test_macosx_sdk_path}" != "no" ; then
		# Note SDK path, e.g., macosx_sdk_path="/Developer/SDKs/MacOSX10.4u.sdk"
		macosx_sdk_path="$test_macosx_sdk_path"
		macosx_sdk_ver=`echo "$macosx_sdk_path" | sed 's/^.*OSX1/1/;s/u.sdk.*$//;'`	# E.g., "10.4"

		# Calculate corresponding ver_int, e.g., "10400"
		macosx_sdk_ver_int_maj=`echo "$macosx_sdk_ver" | cut -d. -f1`
		macosx_sdk_ver_int_min=`echo "$macosx_sdk_ver" | cut -d. -f2`
		macosx_sdk_ver_int_minmin=`echo "$macosx_sdk_ver" | cut -d. -f3`
		macosx_sdk_ver_int=`expr "$macosx_sdk_ver_int_maj" '*' 1000 + "$macosx_sdk_ver_int_min" '*' 100 + "${macosx_sdk_ver_int_minmin-0}"`

		os_base_int=`expr "$os_int" - '(' "$os_int" '%' 10 ')'`
		# Add OS X minimum version, if SDK is older than version of OS X on the build machine.
		if test "$os_base_int" -gt "$macosx_sdk_ver_int" && test "x$MACOSX_DEPLOYMENT_TARGET" = "x" ; then
			# Thanks, Toshi NAGATA
			macosx_sdk_path="${macosx_sdk_path} -mmacosx-version-min=${macosx_sdk_ver}"
		fi
		# macosx_arch_flags="-arch x86_64 -arch i386 -arch ppc"		# This works too
		macosx_arch_flags="-arch i386 -arch ppc"
		case "$CFLAGS" in
			*"-isysroot"*"-arch"*|*"-arch"*"-isysroot"*)
				# User already had both SDK path and desired architecture(s) in CFLAGS
				;;
			*"-arch"*)
				ac_cv_macosx_cflags="-isysroot ${macosx_sdk_path}"
				CFLAGS="${ac_cv_macosx_cflags} ${CFLAGS}"
				;;
			*"-isysroot"*)
				ac_cv_macosx_cflags="${macosx_arch_flags}"
				CFLAGS="${ac_cv_macosx_cflags} ${CFLAGS}"
				;;
			*)
				ac_cv_macosx_cflags="-isysroot ${macosx_sdk_path} ${macosx_arch_flags}"
				CFLAGS="${ac_cv_macosx_cflags} ${CFLAGS}"
				;;
		esac

	#
	# Apparently, only libtool (glibtool) needs this -syslibroot flag.
	#
	#	case "$LDFLAGS" in
	#		*"-syslibroot"*)
	#			# User already had SDK path in LDFLAGS
	#			;;
	#		*)
	#			ac_cv_macosx_ldflags="-syslibroot ${macosx_sdk_path}"
	#			LDFLAGS="${ac_cv_macosx_ldflags} ${LDFLAGS}"
	#			;;
	#	esac
	fi
echo $ac_n "checking if we should add CFLAGS for Mac OS X""... $ac_c" 1>&6
echo "configure:4396: checking if we should add CFLAGS for Mac OS X" >&5
echo "$ac_t""$ac_cv_macosx_cflags" 1>&6
fi


echo $ac_n "checking for strip""... $ac_c" 1>&6
echo "configure:4402: checking for strip" >&5
STRIP="strip"
if [ "x$cross_compiling" = "xyes" ] ; then
	machine=`${CC-gcc} -dumpmachine 2>/dev/null`
	case "$CC" in
		*${machine}*)
			f=`echo "$CC" | sed 's|/[^/]*$||'`
			if [ -x "$f/${machine}-strip" ] ; then
				STRIP="$f/${machine}-strip"
			elif [ -x "$f/strip" ] ; then
				STRIP="$f/strip"
			fi
			;;
	esac
	unset machine f
fi
echo "$ac_t""$STRIP" 1>&6

if test "$SFLAG" = "" ; then
	SFLAG="-s"
	case "$OS" in
		macosx*)
			SFLAG='-Wl,-x'
			;;
	esac
fi
#
# Was it ./configure --enable-debug ?
#
if test "$DEBUGBUILD" = yes ; then
	# It was directly indicated by the user with --enable-debug.
	SFLAG=""
	if test "x$STRIP" = "x" ; then
		STRIP=":"
	else
		STRIP=": #${STRIP}"
	fi
else
	# Not directly indicated, but maybe their CFLAGS hint at a debug build.
	case "$CFLAGS" in
		"-g"|"-g "*|*" -g"|*" -g "*|*"-g"0-9*)
			# SFLAG="# $SFLAG"
			SFLAG=""
			if test "x$STRIP" = "x" ; then
				STRIP=":"
			else
				STRIP=": #${STRIP}"
			fi
			;;
	esac
fi
STRIPFLAG="$SFLAG"

echo $ac_n "checking for object suffix""... $ac_c" 1>&6
echo "configure:4456: checking for object suffix" >&5
if eval "test \"`echo '$''{'ac_cv_objext'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  rm -rf conftest*
if test "x${SYS}" = "xmacosx" ; then
	ac_cv_objext="o"
else
echo 'int i = 1;' > conftest.$ac_ext
if { (eval echo configure:4465: \"$ac_compile\") 1>&5; (eval $ac_compile) 2>&5; }; then
  for ac_file in conftest.*; do
    case $ac_file in
    *.c) ;;
    *) ac_cv_objext=`echo $ac_file | sed -e s/conftest.//` ;;
    esac
  done
else
  { echo "configure: error: installation or configuration problem; compiler does not work" 1>&2; exit 1; }
fi
fi
rm -rf conftest*
fi

echo "$ac_t""$ac_cv_objext" 1>&6
OBJEXT=$ac_cv_objext
ac_objext=$ac_cv_objext

echo $ac_n "checking for Cygwin environment""... $ac_c" 1>&6
echo "configure:4484: checking for Cygwin environment" >&5
if eval "test \"`echo '$''{'ac_cv_cygwin'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 4489 "configure"
#include "confdefs.h"

int main() {

#ifndef __CYGWIN__
#define __CYGWIN__ __CYGWIN32__
#endif
return __CYGWIN__;
; return 0; }
EOF
if { (eval echo configure:4500: \"$ac_compile\") 1>&5; (eval $ac_compile) 2>&5; }; then
  rm -rf conftest*
  ac_cv_cygwin=yes
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  ac_cv_cygwin=no
fi
rm -rf conftest*
rm -rf conftest*
fi

echo "$ac_t""$ac_cv_cygwin" 1>&6
CYGWIN=
test "$ac_cv_cygwin" = yes && CYGWIN=yes
echo $ac_n "checking for mingw32 environment""... $ac_c" 1>&6
echo "configure:4517: checking for mingw32 environment" >&5
if eval "test \"`echo '$''{'ac_cv_mingw32'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 4522 "configure"
#include "confdefs.h"

int main() {
return __MINGW32__;
; return 0; }
EOF
if { (eval echo configure:4529: \"$ac_compile\") 1>&5; (eval $ac_compile) 2>&5; }; then
  rm -rf conftest*
  ac_cv_mingw32=yes
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  ac_cv_mingw32=no
fi
rm -rf conftest*
rm -rf conftest*
fi

echo "$ac_t""$ac_cv_mingw32" 1>&6
MINGW32=
test "$ac_cv_mingw32" = yes && MINGW32=yes


echo $ac_n "checking for executable suffix""... $ac_c" 1>&6
echo "configure:4548: checking for executable suffix" >&5
if eval "test \"`echo '$''{'ac_cv_exeext'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  if test "$CYGWIN" = yes || test "$MINGW32" = yes; then
  ac_cv_exeext=.exe
elif test "x${SYS}" = "xmacosx" ; then
  ac_cv_exeext=""
else
  rm -rf conftest*
  echo 'int main () { return 0; }' > conftest.$ac_ext
  ac_cv_exeext=
  if { (eval echo configure:4560: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; }; then
    for file in conftest.*; do
      case $file in
      *.c | *.o | *.obj) ;;
      *) ac_cv_exeext=`echo $file | sed -e s/conftest//` ;;
      esac
    done
  else
    { echo "configure: error: installation or configuration problem: compiler cannot create executables." 1>&2; exit 1; }
  fi
  rm -rf conftest*
  test x"${ac_cv_exeext}" = x && ac_cv_exeext=no
fi
fi

EXEEXT=""
test x"${ac_cv_exeext}" != xno && EXEEXT=${ac_cv_exeext}
echo "$ac_t""${ac_cv_exeext}" 1>&6
ac_exeext=$EXEEXT


# Get first 127 chars of all uname information.  Some folks have
# way too much stuff there, so grab only the first 127.
unam=`uname -a 2>/dev/null | cut -c1-127 | sed 's-"-\\"-g'`
if test "$unam" != "" ; then
	cat >> confdefs.h <<EOF
#define UNAME "$unam"
EOF

fi


if test "${SYS-sunos}" = sunos ; then
	echo $ac_n "checking for System V compatibility directories""... $ac_c" 1>&6
echo "configure:4594: checking for System V compatibility directories" >&5
	echo "$ac_t""" 1>&6
	
incdir=""/usr/5include""
if test -r $incdir ; then
	case "$CPPFLAGS" in
		*${incdir}*)
			# echo "   + already had $incdir" 1>&6
			;;
		*)
			if test "$CPPFLAGS" = "" ; then
				CPPFLAGS="-I$incdir"
			else
				CPPFLAGS="$CPPFLAGS -I$incdir"
			fi
			echo "   + found $incdir" 1>&6
			;;
	esac
fi

	
libdir=""/usr/5lib""
if test -r $libdir ; then
	case "$LDFLAGS" in
		*${libdir}*)
			# echo "   + already had $libdir" 1>&6
			;;
		*)
			if test "$LDFLAGS" = "" ; then
				LDFLAGS="-L$libdir"
			else
				LDFLAGS="$LDFLAGS -L$libdir"
			fi
			echo "   + found $libdir" 1>&6
			;;
	esac
fi

fi
	
if test "${prefix-NONE}" != "NONE" && test "$prefix" != "/usr/local" && test "$prefix" != "/usr"; then
	cat >> confdefs.h <<EOF
#define PREFIX_BINDIR "$prefix/bin"
EOF

fi



echo $ac_n "checking for ANSI C header files""... $ac_c" 1>&6
echo "configure:4644: checking for ANSI C header files" >&5
if eval "test \"`echo '$''{'ac_cv_header_stdc'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 4649 "configure"
#include "confdefs.h"
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <float.h>
EOF
ac_try="$ac_cpp conftest.$ac_ext >/dev/null 2>conftest.out"
{ (eval echo configure:4657: \"$ac_try\") 1>&5; (eval $ac_try) 2>&5; }
ac_err=`grep -v '^ *+' conftest.out | grep -v "^conftest.${ac_ext}\$"`
if test -z "$ac_err"; then
  rm -rf conftest*
  ac_cv_header_stdc=yes
else
  echo "$ac_err" >&5
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  ac_cv_header_stdc=no
fi
rm -rf conftest*

if test $ac_cv_header_stdc = yes; then
  # SunOS 4.x string.h does not declare mem*, contrary to ANSI.
cat > conftest.$ac_ext <<EOF
#line 4674 "configure"
#include "confdefs.h"
#include <string.h>
EOF
if (eval "$ac_cpp conftest.$ac_ext") 2>&5 |
  egrep "memchr" >/dev/null 2>&1; then
  :
else
  rm -rf conftest*
  ac_cv_header_stdc=no
fi
rm -rf conftest*

fi

if test $ac_cv_header_stdc = yes; then
  # ISC 2.0.2 stdlib.h does not declare free, contrary to ANSI.
cat > conftest.$ac_ext <<EOF
#line 4692 "configure"
#include "confdefs.h"
#include <stdlib.h>
EOF
if (eval "$ac_cpp conftest.$ac_ext") 2>&5 |
  egrep "free" >/dev/null 2>&1; then
  :
else
  rm -rf conftest*
  ac_cv_header_stdc=no
fi
rm -rf conftest*

fi

if test $ac_cv_header_stdc = yes; then
  # /bin/cc in Irix-4.0.5 gets non-ANSI ctype macros unless using -ansi.
if test "$cross_compiling" = yes; then
  :
else
  cat > conftest.$ac_ext <<EOF
#line 4713 "configure"
#include "confdefs.h"
#include <ctype.h>
#define ISLOWER(c) ('a' <= (c) && (c) <= 'z')
#define TOUPPER(c) (ISLOWER(c) ? 'A' + ((c) - 'a') : (c))
#define XOR(e, f) (((e) && !(f)) || (!(e) && (f)))
int main () { int i; for (i = 0; i < 256; i++)
if (XOR (islower (i), ISLOWER (i)) || toupper (i) != TOUPPER (i)) exit(2);
exit (0); }

EOF
if { (eval echo configure:4724: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext} && (./conftest; exit) 2>/dev/null
then
  :
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -fr conftest*
  ac_cv_header_stdc=no
fi
rm -fr conftest*
fi

fi
fi

echo "$ac_t""$ac_cv_header_stdc" 1>&6
if test $ac_cv_header_stdc = yes; then
  cat >> confdefs.h <<\EOF
#define STDC_HEADERS 1
EOF

fi

for ac_hdr in arpa/nameser.h gnu/libc-version.h locale.h net/errno.h nserve.h resolv.h sgtty.h string.h strings.h sys/id.h sys/ioctl.h syslog.h sys/sendfile.h sys/socket.h sys/time.h sys/types.h sys/utsname.h sys/systeminfo.h termio.h termios.h time.h utime.h unistd.h gnu/libc-version.h
do
ac_safe=`echo "$ac_hdr" | sed 'y%./+-%__p_%'`
echo $ac_n "checking for $ac_hdr""... $ac_c" 1>&6
echo "configure:4751: checking for $ac_hdr" >&5
if eval "test \"`echo '$''{'ac_cv_header_$ac_safe'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 4756 "configure"
#include "confdefs.h"
#include <$ac_hdr>
EOF
ac_try="$ac_cpp conftest.$ac_ext >/dev/null 2>conftest.out"
{ (eval echo configure:4761: \"$ac_try\") 1>&5; (eval $ac_try) 2>&5; }
ac_err=`grep -v '^ *+' conftest.out | grep -v "^conftest.${ac_ext}\$"`
if test -z "$ac_err"; then
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=yes"
else
  echo "$ac_err" >&5
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=no"
fi
rm -rf conftest*
fi
if eval "test \"`echo '$ac_cv_header_'$ac_safe`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_hdr=HAVE_`echo $ac_hdr | sed 'y%abcdefghijklmnopqrstuvwxyz./-%ABCDEFGHIJKLMNOPQRSTUVWXYZ___%'`
  cat >> confdefs.h <<EOF
#define $ac_tr_hdr 1
EOF
 
else
  echo "$ac_t""no" 1>&6
fi
done

echo $ac_n "checking whether time.h and sys/time.h may both be included""... $ac_c" 1>&6
echo "configure:4788: checking whether time.h and sys/time.h may both be included" >&5
if eval "test \"`echo '$''{'ac_cv_header_time'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 4793 "configure"
#include "confdefs.h"
#include <sys/types.h>
#include <sys/time.h>
#include <time.h>
int main() {
struct tm *tp;
; return 0; }
EOF
if { (eval echo configure:4802: \"$ac_compile\") 1>&5; (eval $ac_compile) 2>&5; }; then
  rm -rf conftest*
  ac_cv_header_time=yes
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  ac_cv_header_time=no
fi
rm -rf conftest*
fi

echo "$ac_t""$ac_cv_header_time" 1>&6
if test $ac_cv_header_time = yes; then
  cat >> confdefs.h <<\EOF
#define TIME_WITH_SYS_TIME 1
EOF

fi


if test "x$want_unix_domain_sockets" != xno ; then
	
	if test "x$ac_cv_header_unistd_h" = x ; then
		{ echo "configure: error: Script needs to check for <unistd.h> before calling wi_UNIX_DOMAIN_SOCKETS." 1>&2; exit 1; }
	fi

	for ac_hdr in sys/un.h
do
ac_safe=`echo "$ac_hdr" | sed 'y%./+-%__p_%'`
echo $ac_n "checking for $ac_hdr""... $ac_c" 1>&6
echo "configure:4833: checking for $ac_hdr" >&5
if eval "test \"`echo '$''{'ac_cv_header_$ac_safe'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 4838 "configure"
#include "confdefs.h"
#include <$ac_hdr>
EOF
ac_try="$ac_cpp conftest.$ac_ext >/dev/null 2>conftest.out"
{ (eval echo configure:4843: \"$ac_try\") 1>&5; (eval $ac_try) 2>&5; }
ac_err=`grep -v '^ *+' conftest.out | grep -v "^conftest.${ac_ext}\$"`
if test -z "$ac_err"; then
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=yes"
else
  echo "$ac_err" >&5
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=no"
fi
rm -rf conftest*
fi
if eval "test \"`echo '$ac_cv_header_'$ac_safe`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_hdr=HAVE_`echo $ac_hdr | sed 'y%abcdefghijklmnopqrstuvwxyz./-%ABCDEFGHIJKLMNOPQRSTUVWXYZ___%'`
  cat >> confdefs.h <<EOF
#define $ac_tr_hdr 1
EOF
 
else
  echo "$ac_t""no" 1>&6
fi
done

	echo $ac_n "checking for UNIX domain sockets""... $ac_c" 1>&6
echo "configure:4870: checking for UNIX domain sockets" >&5
if eval "test \"`echo '$''{'wi_cv_unix_domain_sockets'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  
	if test "$cross_compiling" = yes; then
  
	# action if cross-compiling, guess
	guess="(guessing) "
	wi_cv_unix_domain_sockets=yes

else
  cat > conftest.$ac_ext <<EOF
#line 4883 "configure"
#include "confdefs.h"

#if defined(AIX) || defined(_AIX) || defined(__HOS_AIX__)
#	define _ALL_SOURCE 1
#endif
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/socket.h>
#ifdef HAVE_SYS_UN_H
#include <sys/un.h>
#endif
 
main()
{
	int sfd;

	sfd = socket(AF_UNIX, SOCK_STREAM, 0);
	if (sfd < 0)
		exit(1);		/* do not have UNIX domain sockets */
	close(sfd);
	exit(0);			/* do have UNIX domain sockets */
}
EOF
if { (eval echo configure:4909: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext} && (./conftest; exit) 2>/dev/null
then
  
	# action if true
	guess=""
	wi_cv_unix_domain_sockets=yes

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -fr conftest*
  
	# action if false
	guess=""
	wi_cv_unix_domain_sockets=no

fi
rm -fr conftest*
fi


fi

echo "$ac_t""$guess$wi_cv_unix_domain_sockets" 1>&6
guess=""

	if test "x$wi_cv_unix_domain_sockets" = xyes ; then
		cat >> confdefs.h <<\EOF
#define HAVE_UNIX_DOMAIN_SOCKETS 1
EOF

	fi
	
echo $ac_n "checking for sun_len field in struct sockaddr_un""... $ac_c" 1>&6
echo "configure:4943: checking for sun_len field in struct sockaddr_un" >&5
if eval "test \"`echo '$''{'wi_cv_sockaddr_un_sun_len'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  
cat > conftest.$ac_ext <<EOF
#line 4949 "configure"
#include "confdefs.h"

	/* includes */
#include <unistd.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <sys/socket.h>
#include <sys/un.h>

int main() {

struct sockaddr_un uaddr;

uaddr.sun_len = strlen("/tmp/test.sock");
exit(((int) uaddr.sun_len);	/* bogus code, of course. */

; return 0; }
EOF
if { (eval echo configure:4968: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  
	wi_cv_sockaddr_un_sun_len=yes

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  
	wi_cv_sockaddr_un_sun_len=no

fi
rm -rf conftest*

fi

echo "$ac_t""$wi_cv_sockaddr_un_sun_len" 1>&6
if test "$wi_cv_sockaddr_un_sun_len" = yes ; then
	cat >> confdefs.h <<\EOF
#define HAVE_SOCKADDR_UN_SUN_LEN 1
EOF

fi

fi

SIO_OBJS_U=''
SIO_SOBJS_U=''
if test "$wi_cv_unix_domain_sockets" = yes ; then
	SIO_OBJS_U='$(OBJS_U) '
	SIO_SOBJS_U='$(SOBJS_U) '
fi






# Mostly for SunOS 4 -- needs to come first because other libs depend on it

echo $ac_n "checking for strerror""... $ac_c" 1>&6
echo "configure:5010: checking for strerror" >&5
if eval "test \"`echo '$''{'ac_cv_func_strerror'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 5015 "configure"
#include "confdefs.h"
/* System header to define __stub macros and hopefully few prototypes,
    which can conflict with char strerror(); below.  */
#include <assert.h>
/* Override any gcc2 internal prototype to avoid an error.  */
/* We use char because int might match the return type of a gcc2
    builtin and then its argument prototype would still apply.  */
char strerror();

int main() {

/* The GNU C library defines this for functions which it implements
    to always fail with ENOSYS.  Some functions are actually named
    something starting with __ and the normal name is an alias.  */
#if defined (__stub_strerror) || defined (__stub___strerror)
choke me
#else
strerror();
#endif

; return 0; }
EOF
if { (eval echo configure:5038: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  eval "ac_cv_func_strerror=yes"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_func_strerror=no"
fi
rm -rf conftest*
fi

if eval "test \"`echo '$ac_cv_func_'strerror`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  a=yes
else
  echo "$ac_t""no" 1>&6
a=no
fi

if test "$a" = no ; then
	# Not in libc, try lib44bsd.
	echo $ac_n "checking for strerror in -l44bsd""... $ac_c" 1>&6
echo "configure:5061: checking for strerror in -l44bsd" >&5
ac_lib_var=`echo 44bsd'_'strerror | sed 'y%./+-%__p_%'`
if eval "test \"`echo '$''{'ac_cv_lib_$ac_lib_var'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  ac_save_LIBS="$LIBS"
LIBS="-l44bsd  $LIBS"
cat > conftest.$ac_ext <<EOF
#line 5069 "configure"
#include "confdefs.h"
/* Override any gcc2 internal prototype to avoid an error.  */
/* We use char because int might match the return type of a gcc2
    builtin and then its argument prototype would still apply.  */
char strerror();

int main() {
strerror()
; return 0; }
EOF
if { (eval echo configure:5080: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=yes"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=no"
fi
rm -rf conftest*
LIBS="$ac_save_LIBS"

fi
if eval "test \"`echo '$ac_cv_lib_'$ac_lib_var`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_lib=HAVE_LIB`echo 44bsd | sed -e 's/[^a-zA-Z0-9_]/_/g' \
    -e 'y/abcdefghijklmnopqrstuvwxyz/ABCDEFGHIJKLMNOPQRSTUVWXYZ/'`
  cat >> confdefs.h <<EOF
#define $ac_tr_lib 1
EOF

  LIBS="-l44bsd $LIBS"

else
  echo "$ac_t""no" 1>&6
fi

fi



echo $ac_n "checking for socket""... $ac_c" 1>&6
echo "configure:5112: checking for socket" >&5
if eval "test \"`echo '$''{'ac_cv_func_socket'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 5117 "configure"
#include "confdefs.h"
/* System header to define __stub macros and hopefully few prototypes,
    which can conflict with char socket(); below.  */
#include <assert.h>
/* Override any gcc2 internal prototype to avoid an error.  */
/* We use char because int might match the return type of a gcc2
    builtin and then its argument prototype would still apply.  */
char socket();

int main() {

/* The GNU C library defines this for functions which it implements
    to always fail with ENOSYS.  Some functions are actually named
    something starting with __ and the normal name is an alias.  */
#if defined (__stub_socket) || defined (__stub___socket)
choke me
#else
socket();
#endif

; return 0; }
EOF
if { (eval echo configure:5140: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  eval "ac_cv_func_socket=yes"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_func_socket=no"
fi
rm -rf conftest*
fi

if eval "test \"`echo '$ac_cv_func_'socket`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  a=yes
else
  echo "$ac_t""no" 1>&6
a=no
fi

if test "$a" = no ; then
	# Not in libc, try libsocket.
	echo $ac_n "checking for socket in -lsocket""... $ac_c" 1>&6
echo "configure:5163: checking for socket in -lsocket" >&5
ac_lib_var=`echo socket'_'socket | sed 'y%./+-%__p_%'`
if eval "test \"`echo '$''{'ac_cv_lib_$ac_lib_var'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  ac_save_LIBS="$LIBS"
LIBS="-lsocket  $LIBS"
cat > conftest.$ac_ext <<EOF
#line 5171 "configure"
#include "confdefs.h"
/* Override any gcc2 internal prototype to avoid an error.  */
/* We use char because int might match the return type of a gcc2
    builtin and then its argument prototype would still apply.  */
char socket();

int main() {
socket()
; return 0; }
EOF
if { (eval echo configure:5182: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=yes"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=no"
fi
rm -rf conftest*
LIBS="$ac_save_LIBS"

fi
if eval "test \"`echo '$ac_cv_lib_'$ac_lib_var`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_lib=HAVE_LIB`echo socket | sed -e 's/[^a-zA-Z0-9_]/_/g' \
    -e 'y/abcdefghijklmnopqrstuvwxyz/ABCDEFGHIJKLMNOPQRSTUVWXYZ/'`
  cat >> confdefs.h <<EOF
#define $ac_tr_lib 1
EOF

  LIBS="-lsocket $LIBS"

else
  echo "$ac_t""no" 1>&6
fi

fi


if test "$SYS" = unixware ; then
	case "$OS" in
		unixware2*)
			# So far, only UnixWare needs this.
			echo $ac_n "checking for syslog in -lgen""... $ac_c" 1>&6
echo "configure:5217: checking for syslog in -lgen" >&5
ac_lib_var=`echo gen'_'syslog | sed 'y%./+-%__p_%'`
if eval "test \"`echo '$''{'ac_cv_lib_$ac_lib_var'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  ac_save_LIBS="$LIBS"
LIBS="-lgen  $LIBS"
cat > conftest.$ac_ext <<EOF
#line 5225 "configure"
#include "confdefs.h"
/* Override any gcc2 internal prototype to avoid an error.  */
/* We use char because int might match the return type of a gcc2
    builtin and then its argument prototype would still apply.  */
char syslog();

int main() {
syslog()
; return 0; }
EOF
if { (eval echo configure:5236: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=yes"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=no"
fi
rm -rf conftest*
LIBS="$ac_save_LIBS"

fi
if eval "test \"`echo '$ac_cv_lib_'$ac_lib_var`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_lib=HAVE_LIB`echo gen | sed -e 's/[^a-zA-Z0-9_]/_/g' \
    -e 'y/abcdefghijklmnopqrstuvwxyz/ABCDEFGHIJKLMNOPQRSTUVWXYZ/'`
  cat >> confdefs.h <<EOF
#define $ac_tr_lib 1
EOF

  LIBS="-lgen $LIBS"

else
  echo "$ac_t""no" 1>&6
fi


			if test -f /usr/ucblib/libucb.a ; then
				LDFLAGS="$LDFLAGS -L/usr/ucblib"
				LIBS="$LIBS -lucb"
			fi
			if test -f /usr/include/unistd.h ; then
				ac_cv_header_unistd_h=yes
			fi

			# UnixWare 2 needs both lsocket and lnsl, and configure
			# script won't detect this condition properly because 
			# the libraries are interdependent.
			#
			LIBS="$LIBS -lsocket -lnsl"

			# Now look for socket()
			#
			# AC_CHECK_FUNC(socket,[a=yes],[a=no])
			#
			echo $ac_n "checking for socket""... $ac_c" 1>&6
echo "configure:5283: checking for socket" >&5
if eval "test \"`echo '$''{'ac_cv_func_socket'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 5288 "configure"
#include "confdefs.h"
/* System header to define __stub macros and hopefully few prototypes,
    which can conflict with char socket(); below.  */
#include <assert.h>
/* Override any gcc2 internal prototype to avoid an error.  */
/* We use char because int might match the return type of a gcc2
    builtin and then its argument prototype would still apply.  */
char socket();

int main() {

/* The GNU C library defines this for functions which it implements
    to always fail with ENOSYS.  Some functions are actually named
    something starting with __ and the normal name is an alias.  */
#if defined (__stub_socket) || defined (__stub___socket)
choke me
#else
socket();
#endif

; return 0; }
EOF
if { (eval echo configure:5311: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  eval "ac_cv_func_socket=yes"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_func_socket=no"
fi
rm -rf conftest*
fi

if eval "test \"`echo '$ac_cv_func_'socket`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  a=yes
else
  echo "$ac_t""no" 1>&6
a=no
fi

			;;
		*)
			;;
	esac
fi




case "$OS" in
	hpux1123456789*)
		# HP-UX 11 uses NSL for YP services
		echo $ac_n "checking for getpwent in -lnsl""... $ac_c" 1>&6
echo "configure:5344: checking for getpwent in -lnsl" >&5
ac_lib_var=`echo nsl'_'getpwent | sed 'y%./+-%__p_%'`
if eval "test \"`echo '$''{'ac_cv_lib_$ac_lib_var'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  ac_save_LIBS="$LIBS"
LIBS="-lnsl  $LIBS"
cat > conftest.$ac_ext <<EOF
#line 5352 "configure"
#include "confdefs.h"
/* Override any gcc2 internal prototype to avoid an error.  */
/* We use char because int might match the return type of a gcc2
    builtin and then its argument prototype would still apply.  */
char getpwent();

int main() {
getpwent()
; return 0; }
EOF
if { (eval echo configure:5363: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=yes"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=no"
fi
rm -rf conftest*
LIBS="$ac_save_LIBS"

fi
if eval "test \"`echo '$ac_cv_lib_'$ac_lib_var`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_lib=HAVE_LIB`echo nsl | sed -e 's/[^a-zA-Z0-9_]/_/g' \
    -e 'y/abcdefghijklmnopqrstuvwxyz/ABCDEFGHIJKLMNOPQRSTUVWXYZ/'`
  cat >> confdefs.h <<EOF
#define $ac_tr_lib 1
EOF

  LIBS="-lnsl $LIBS"

else
  echo "$ac_t""no" 1>&6
fi

		;;

	*)
		echo $ac_n "checking for gethostbyname""... $ac_c" 1>&6
echo "configure:5394: checking for gethostbyname" >&5
if eval "test \"`echo '$''{'ac_cv_func_gethostbyname'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 5399 "configure"
#include "confdefs.h"
/* System header to define __stub macros and hopefully few prototypes,
    which can conflict with char gethostbyname(); below.  */
#include <assert.h>
/* Override any gcc2 internal prototype to avoid an error.  */
/* We use char because int might match the return type of a gcc2
    builtin and then its argument prototype would still apply.  */
char gethostbyname();

int main() {

/* The GNU C library defines this for functions which it implements
    to always fail with ENOSYS.  Some functions are actually named
    something starting with __ and the normal name is an alias.  */
#if defined (__stub_gethostbyname) || defined (__stub___gethostbyname)
choke me
#else
gethostbyname();
#endif

; return 0; }
EOF
if { (eval echo configure:5422: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  eval "ac_cv_func_gethostbyname=yes"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_func_gethostbyname=no"
fi
rm -rf conftest*
fi

if eval "test \"`echo '$ac_cv_func_'gethostbyname`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  a=yes
else
  echo "$ac_t""no" 1>&6
a=no
fi

		if test "$a" = no ; then
			# Not in libc, try libnsl.
			echo $ac_n "checking for gethostbyname in -lnsl""... $ac_c" 1>&6
echo "configure:5445: checking for gethostbyname in -lnsl" >&5
ac_lib_var=`echo nsl'_'gethostbyname | sed 'y%./+-%__p_%'`
if eval "test \"`echo '$''{'ac_cv_lib_$ac_lib_var'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  ac_save_LIBS="$LIBS"
LIBS="-lnsl  $LIBS"
cat > conftest.$ac_ext <<EOF
#line 5453 "configure"
#include "confdefs.h"
/* Override any gcc2 internal prototype to avoid an error.  */
/* We use char because int might match the return type of a gcc2
    builtin and then its argument prototype would still apply.  */
char gethostbyname();

int main() {
gethostbyname()
; return 0; }
EOF
if { (eval echo configure:5464: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=yes"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=no"
fi
rm -rf conftest*
LIBS="$ac_save_LIBS"

fi
if eval "test \"`echo '$ac_cv_lib_'$ac_lib_var`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_lib=HAVE_LIB`echo nsl | sed -e 's/[^a-zA-Z0-9_]/_/g' \
    -e 'y/abcdefghijklmnopqrstuvwxyz/ABCDEFGHIJKLMNOPQRSTUVWXYZ/'`
  cat >> confdefs.h <<EOF
#define $ac_tr_lib 1
EOF

  LIBS="-lnsl $LIBS"

else
  echo "$ac_t""no" 1>&6
fi

		fi
		;;
esac



# See if we could access two well-known sites without help of any special
# libraries, like resolv.
echo $ac_n "checking if we need to look for a separate DNS resolver library""... $ac_c" 1>&6
echo "configure:5500: checking if we need to look for a separate DNS resolver library" >&5
if eval "test \"`echo '$''{'wi_cv_look_for_resolv'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  

	if test "x$ac_cv_header_unistd_h" = x ; then
		{ echo "configure: error: Script needs to check for <unistd.h> before calling wi_LIB_RESOLV." 1>&2; exit 1; }
	fi

if test "$cross_compiling" = yes; then
  
	# action if cross compiling
	guess="(guessing) "
	wi_cv_look_for_resolv=yes

else
  cat > conftest.$ac_ext <<EOF
#line 5518 "configure"
#include "confdefs.h"

#if defined(AIX) || defined(_AIX) || defined(__HOS_AIX__)
#	define _ALL_SOURCE 1
#endif
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
 
main()
{
	struct hostent *hp1, *hp2;

	hp1 = gethostbyname("ftp.ncftp.com");
	if (hp1 == (struct hostent *) 0) {
		hp2 = gethostbyname("www.ibm.com");
		if (hp2 == (struct hostent *) 0)
			exit(1);
	}
	exit(0);
}
EOF
if { (eval echo configure:5545: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext} && (./conftest; exit) 2>/dev/null
then
  
	# action if true
	guess=""
	wi_cv_look_for_resolv=no

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -fr conftest*
  
	# action if false
	guess=""
	wi_cv_look_for_resolv=yes

fi
rm -fr conftest*
fi

fi

echo "$ac_t""$guess$wi_cv_look_for_resolv" 1>&6
guess=""


if test "$wi_cv_look_for_resolv" = yes ; then
echo $ac_n "checking for main in -lresolv""... $ac_c" 1>&6
echo "configure:5573: checking for main in -lresolv" >&5
ac_lib_var=`echo resolv'_'main | sed 'y%./+-%__p_%'`
if eval "test \"`echo '$''{'ac_cv_lib_$ac_lib_var'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  ac_save_LIBS="$LIBS"
LIBS="-lresolv  $LIBS"
cat > conftest.$ac_ext <<EOF
#line 5581 "configure"
#include "confdefs.h"

int main() {
main()
; return 0; }
EOF
if { (eval echo configure:5588: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=yes"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=no"
fi
rm -rf conftest*
LIBS="$ac_save_LIBS"

fi
if eval "test \"`echo '$ac_cv_lib_'$ac_lib_var`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_lib=HAVE_LIB`echo resolv | sed -e 's/[^a-zA-Z0-9_]/_/g' \
    -e 'y/abcdefghijklmnopqrstuvwxyz/ABCDEFGHIJKLMNOPQRSTUVWXYZ/'`
  cat >> confdefs.h <<EOF
#define $ac_tr_lib 1
EOF

  LIBS="-lresolv $LIBS"

else
  echo "$ac_t""no" 1>&6
fi

else
	ac_cv_lib_resolv=no
fi


if test "$SYS" = dynixptx ; then
	LIBS="$LIBS -lsocket -lnsl"
fi



	if test "$wi_want_socks5" != yes ; then
		ac_cv_lib_socks5_SOCKSinit=no
	else
		# Look for the "SOCKS" library for use with Firewalls/Gateways.
		SOCKS_LIBS=''

		# First check for extra libraries that may be needed to
		# link against socks.  If we already checked for one or
		# more of these libraries, we don't want to count them
		# in the socks-only list.
		#
		if test "x$ac_cv_lib_db_main" = "x" ; then
			echo $ac_n "checking for main in -ldb""... $ac_c" 1>&6
echo "configure:5639: checking for main in -ldb" >&5
ac_lib_var=`echo db'_'main | sed 'y%./+-%__p_%'`
if eval "test \"`echo '$''{'ac_cv_lib_$ac_lib_var'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  ac_save_LIBS="$LIBS"
LIBS="-ldb  $LIBS"
cat > conftest.$ac_ext <<EOF
#line 5647 "configure"
#include "confdefs.h"

int main() {
main()
; return 0; }
EOF
if { (eval echo configure:5654: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=yes"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=no"
fi
rm -rf conftest*
LIBS="$ac_save_LIBS"

fi
if eval "test \"`echo '$ac_cv_lib_'$ac_lib_var`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  SOCKS_LIBS="$SOCKS_LIBS -ldb"
else
  echo "$ac_t""no" 1>&6
fi

		fi
		if test "x$ac_cv_lib_isode_main" = "x" ; then
			echo $ac_n "checking for main in -lisode""... $ac_c" 1>&6
echo "configure:5677: checking for main in -lisode" >&5
ac_lib_var=`echo isode'_'main | sed 'y%./+-%__p_%'`
if eval "test \"`echo '$''{'ac_cv_lib_$ac_lib_var'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  ac_save_LIBS="$LIBS"
LIBS="-lisode  $LIBS"
cat > conftest.$ac_ext <<EOF
#line 5685 "configure"
#include "confdefs.h"

int main() {
main()
; return 0; }
EOF
if { (eval echo configure:5692: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=yes"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=no"
fi
rm -rf conftest*
LIBS="$ac_save_LIBS"

fi
if eval "test \"`echo '$ac_cv_lib_'$ac_lib_var`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  SOCKS_LIBS="$SOCKS_LIBS -lisode"
else
  echo "$ac_t""no" 1>&6
fi

		fi
		if test "x$ac_cv_lib_com_err_main" = "x" ; then
			echo $ac_n "checking for main in -lcom_err""... $ac_c" 1>&6
echo "configure:5715: checking for main in -lcom_err" >&5
ac_lib_var=`echo com_err'_'main | sed 'y%./+-%__p_%'`
if eval "test \"`echo '$''{'ac_cv_lib_$ac_lib_var'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  ac_save_LIBS="$LIBS"
LIBS="-lcom_err  $LIBS"
cat > conftest.$ac_ext <<EOF
#line 5723 "configure"
#include "confdefs.h"

int main() {
main()
; return 0; }
EOF
if { (eval echo configure:5730: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=yes"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=no"
fi
rm -rf conftest*
LIBS="$ac_save_LIBS"

fi
if eval "test \"`echo '$ac_cv_lib_'$ac_lib_var`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  SOCKS_LIBS="$SOCKS_LIBS -lcom_err"
else
  echo "$ac_t""no" 1>&6
fi

		fi
		if test "x$ac_cv_lib_crypto_main" = "x" ; then
			echo $ac_n "checking for main in -lcrypto""... $ac_c" 1>&6
echo "configure:5753: checking for main in -lcrypto" >&5
ac_lib_var=`echo crypto'_'main | sed 'y%./+-%__p_%'`
if eval "test \"`echo '$''{'ac_cv_lib_$ac_lib_var'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  ac_save_LIBS="$LIBS"
LIBS="-lcrypto  $LIBS"
cat > conftest.$ac_ext <<EOF
#line 5761 "configure"
#include "confdefs.h"

int main() {
main()
; return 0; }
EOF
if { (eval echo configure:5768: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=yes"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=no"
fi
rm -rf conftest*
LIBS="$ac_save_LIBS"

fi
if eval "test \"`echo '$ac_cv_lib_'$ac_lib_var`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  SOCKS_LIBS="$SOCKS_LIBS -lcrypto"
else
  echo "$ac_t""no" 1>&6
fi

		fi
		if test "x$ac_cv_lib_krb5_main" = "x" ; then
			echo $ac_n "checking for main in -lkrb5""... $ac_c" 1>&6
echo "configure:5791: checking for main in -lkrb5" >&5
ac_lib_var=`echo krb5'_'main | sed 'y%./+-%__p_%'`
if eval "test \"`echo '$''{'ac_cv_lib_$ac_lib_var'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  ac_save_LIBS="$LIBS"
LIBS="-lkrb5  $LIBS"
cat > conftest.$ac_ext <<EOF
#line 5799 "configure"
#include "confdefs.h"

int main() {
main()
; return 0; }
EOF
if { (eval echo configure:5806: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=yes"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=no"
fi
rm -rf conftest*
LIBS="$ac_save_LIBS"

fi
if eval "test \"`echo '$ac_cv_lib_'$ac_lib_var`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  SOCKS_LIBS="$SOCKS_LIBS -lkrb5"
else
  echo "$ac_t""no" 1>&6
fi

		fi
		if test "x$ac_cv_lib_gssapi_krb5_main" = "x" ; then
			echo $ac_n "checking for main in -lgssapi_krb5""... $ac_c" 1>&6
echo "configure:5829: checking for main in -lgssapi_krb5" >&5
ac_lib_var=`echo gssapi_krb5'_'main | sed 'y%./+-%__p_%'`
if eval "test \"`echo '$''{'ac_cv_lib_$ac_lib_var'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  ac_save_LIBS="$LIBS"
LIBS="-lgssapi_krb5  $LIBS"
cat > conftest.$ac_ext <<EOF
#line 5837 "configure"
#include "confdefs.h"

int main() {
main()
; return 0; }
EOF
if { (eval echo configure:5844: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=yes"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=no"
fi
rm -rf conftest*
LIBS="$ac_save_LIBS"

fi
if eval "test \"`echo '$ac_cv_lib_'$ac_lib_var`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  SOCKS_LIBS="$SOCKS_LIBS -lgssapi_krb5"
else
  echo "$ac_t""no" 1>&6
fi

		fi

		echo $ac_n "checking for SOCKSinit in -lsocks5""... $ac_c" 1>&6
echo "configure:5867: checking for SOCKSinit in -lsocks5" >&5
ac_lib_var=`echo socks5'_'SOCKSinit | sed 'y%./+-%__p_%'`
if eval "test \"`echo '$''{'ac_cv_lib_$ac_lib_var'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  ac_save_LIBS="$LIBS"
LIBS="-lsocks5  $LIBS"
cat > conftest.$ac_ext <<EOF
#line 5875 "configure"
#include "confdefs.h"
/* Override any gcc2 internal prototype to avoid an error.  */
/* We use char because int might match the return type of a gcc2
    builtin and then its argument prototype would still apply.  */
char SOCKSinit();

int main() {
SOCKSinit()
; return 0; }
EOF
if { (eval echo configure:5886: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=yes"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=no"
fi
rm -rf conftest*
LIBS="$ac_save_LIBS"

fi
if eval "test \"`echo '$ac_cv_lib_'$ac_lib_var`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  SOCKS_LIBS="$SOCKS_LIBS -lsocks5"
else
  echo "$ac_t""no" 1>&6
fi

		for ac_hdr in socks.h socks5p.h
do
ac_safe=`echo "$ac_hdr" | sed 'y%./+-%__p_%'`
echo $ac_n "checking for $ac_hdr""... $ac_c" 1>&6
echo "configure:5910: checking for $ac_hdr" >&5
if eval "test \"`echo '$''{'ac_cv_header_$ac_safe'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 5915 "configure"
#include "confdefs.h"
#include <$ac_hdr>
EOF
ac_try="$ac_cpp conftest.$ac_ext >/dev/null 2>conftest.out"
{ (eval echo configure:5920: \"$ac_try\") 1>&5; (eval $ac_try) 2>&5; }
ac_err=`grep -v '^ *+' conftest.out | grep -v "^conftest.${ac_ext}\$"`
if test -z "$ac_err"; then
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=yes"
else
  echo "$ac_err" >&5
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=no"
fi
rm -rf conftest*
fi
if eval "test \"`echo '$ac_cv_header_'$ac_safe`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_hdr=HAVE_`echo $ac_hdr | sed 'y%abcdefghijklmnopqrstuvwxyz./-%ABCDEFGHIJKLMNOPQRSTUVWXYZ___%'`
  cat >> confdefs.h <<EOF
#define $ac_tr_hdr 1
EOF
 
else
  echo "$ac_t""no" 1>&6
fi
done


		if test "$ac_cv_lib_socks5_SOCKSinit" != yes ; then
			ac_cv_lib_socks5_SOCKSinit=no
			unset SOCKS_LIBS
		else
			
			cat >> confdefs.h <<\EOF
#define SOCKS 5
EOF

		fi
	fi
	echo $ac_n "checking if SOCKS5 will be used""... $ac_c" 1>&6
echo "configure:5959: checking if SOCKS5 will be used" >&5
	echo "$ac_t""$ac_cv_lib_socks5_SOCKSinit" 1>&6

case "$OS" in
	solaris8-*)
		saved_LIBS="$LIBS"
		echo $ac_n "checking for sendfilev in -lsendfile""... $ac_c" 1>&6
echo "configure:5966: checking for sendfilev in -lsendfile" >&5
ac_lib_var=`echo sendfile'_'sendfilev | sed 'y%./+-%__p_%'`
if eval "test \"`echo '$''{'ac_cv_lib_$ac_lib_var'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  ac_save_LIBS="$LIBS"
LIBS="-lsendfile  $LIBS"
cat > conftest.$ac_ext <<EOF
#line 5974 "configure"
#include "confdefs.h"
/* Override any gcc2 internal prototype to avoid an error.  */
/* We use char because int might match the return type of a gcc2
    builtin and then its argument prototype would still apply.  */
char sendfilev();

int main() {
sendfilev()
; return 0; }
EOF
if { (eval echo configure:5985: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=yes"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=no"
fi
rm -rf conftest*
LIBS="$ac_save_LIBS"

fi
if eval "test \"`echo '$ac_cv_lib_'$ac_lib_var`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_lib=HAVE_LIB`echo sendfile | sed -e 's/[^a-zA-Z0-9_]/_/g' \
    -e 'y/abcdefghijklmnopqrstuvwxyz/ABCDEFGHIJKLMNOPQRSTUVWXYZ/'`
  cat >> confdefs.h <<EOF
#define $ac_tr_lib 1
EOF

  LIBS="-lsendfile $LIBS"

else
  echo "$ac_t""no" 1>&6
fi

		for ac_func in sendfilev sendfilev64
do
echo $ac_n "checking for $ac_func""... $ac_c" 1>&6
echo "configure:6015: checking for $ac_func" >&5
if eval "test \"`echo '$''{'ac_cv_func_$ac_func'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 6020 "configure"
#include "confdefs.h"
/* System header to define __stub macros and hopefully few prototypes,
    which can conflict with char $ac_func(); below.  */
#include <assert.h>
/* Override any gcc2 internal prototype to avoid an error.  */
/* We use char because int might match the return type of a gcc2
    builtin and then its argument prototype would still apply.  */
char $ac_func();

int main() {

/* The GNU C library defines this for functions which it implements
    to always fail with ENOSYS.  Some functions are actually named
    something starting with __ and the normal name is an alias.  */
#if defined (__stub_$ac_func) || defined (__stub___$ac_func)
choke me
#else
$ac_func();
#endif

; return 0; }
EOF
if { (eval echo configure:6043: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  eval "ac_cv_func_$ac_func=yes"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_func_$ac_func=no"
fi
rm -rf conftest*
fi

if eval "test \"`echo '$ac_cv_func_'$ac_func`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_func=HAVE_`echo $ac_func | tr 'abcdefghijklmnopqrstuvwxyz' 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'`
  cat >> confdefs.h <<EOF
#define $ac_tr_func 1
EOF
 
else
  echo "$ac_t""no" 1>&6
fi
done

		LIBS="$saved_LIBS"
		echo $ac_n "checking for dlopen in -ldl""... $ac_c" 1>&6
echo "configure:6069: checking for dlopen in -ldl" >&5
ac_lib_var=`echo dl'_'dlopen | sed 'y%./+-%__p_%'`
if eval "test \"`echo '$''{'ac_cv_lib_$ac_lib_var'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  ac_save_LIBS="$LIBS"
LIBS="-ldl  $LIBS"
cat > conftest.$ac_ext <<EOF
#line 6077 "configure"
#include "confdefs.h"
/* Override any gcc2 internal prototype to avoid an error.  */
/* We use char because int might match the return type of a gcc2
    builtin and then its argument prototype would still apply.  */
char dlopen();

int main() {
dlopen()
; return 0; }
EOF
if { (eval echo configure:6088: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=yes"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=no"
fi
rm -rf conftest*
LIBS="$ac_save_LIBS"

fi
if eval "test \"`echo '$ac_cv_lib_'$ac_lib_var`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_lib=HAVE_LIB`echo dl | sed -e 's/[^a-zA-Z0-9_]/_/g' \
    -e 'y/abcdefghijklmnopqrstuvwxyz/ABCDEFGHIJKLMNOPQRSTUVWXYZ/'`
  cat >> confdefs.h <<EOF
#define $ac_tr_lib 1
EOF

  LIBS="-ldl $LIBS"

else
  echo "$ac_t""no" 1>&6
fi

		;;
	solaris9-*|solaris1[0-9]-*)
		echo $ac_n "checking for sendfilev in -lsendfile""... $ac_c" 1>&6
echo "configure:6118: checking for sendfilev in -lsendfile" >&5
ac_lib_var=`echo sendfile'_'sendfilev | sed 'y%./+-%__p_%'`
if eval "test \"`echo '$''{'ac_cv_lib_$ac_lib_var'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  ac_save_LIBS="$LIBS"
LIBS="-lsendfile  $LIBS"
cat > conftest.$ac_ext <<EOF
#line 6126 "configure"
#include "confdefs.h"
/* Override any gcc2 internal prototype to avoid an error.  */
/* We use char because int might match the return type of a gcc2
    builtin and then its argument prototype would still apply.  */
char sendfilev();

int main() {
sendfilev()
; return 0; }
EOF
if { (eval echo configure:6137: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=yes"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=no"
fi
rm -rf conftest*
LIBS="$ac_save_LIBS"

fi
if eval "test \"`echo '$ac_cv_lib_'$ac_lib_var`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_lib=HAVE_LIB`echo sendfile | sed -e 's/[^a-zA-Z0-9_]/_/g' \
    -e 'y/abcdefghijklmnopqrstuvwxyz/ABCDEFGHIJKLMNOPQRSTUVWXYZ/'`
  cat >> confdefs.h <<EOF
#define $ac_tr_lib 1
EOF

  LIBS="-lsendfile $LIBS"

else
  echo "$ac_t""no" 1>&6
fi

		for ac_func in sendfilev sendfilev64
do
echo $ac_n "checking for $ac_func""... $ac_c" 1>&6
echo "configure:6167: checking for $ac_func" >&5
if eval "test \"`echo '$''{'ac_cv_func_$ac_func'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 6172 "configure"
#include "confdefs.h"
/* System header to define __stub macros and hopefully few prototypes,
    which can conflict with char $ac_func(); below.  */
#include <assert.h>
/* Override any gcc2 internal prototype to avoid an error.  */
/* We use char because int might match the return type of a gcc2
    builtin and then its argument prototype would still apply.  */
char $ac_func();

int main() {

/* The GNU C library defines this for functions which it implements
    to always fail with ENOSYS.  Some functions are actually named
    something starting with __ and the normal name is an alias.  */
#if defined (__stub_$ac_func) || defined (__stub___$ac_func)
choke me
#else
$ac_func();
#endif

; return 0; }
EOF
if { (eval echo configure:6195: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  eval "ac_cv_func_$ac_func=yes"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_func_$ac_func=no"
fi
rm -rf conftest*
fi

if eval "test \"`echo '$ac_cv_func_'$ac_func`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_func=HAVE_`echo $ac_func | tr 'abcdefghijklmnopqrstuvwxyz' 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'`
  cat >> confdefs.h <<EOF
#define $ac_tr_func 1
EOF
 
else
  echo "$ac_t""no" 1>&6
fi
done

		;;
esac

LIBCURSES=''
if test "$nc_cv_curses" = yes ; then
	

echo $ac_n "checking for curses library headers""... $ac_c" 1>&6
echo "configure:6227: checking for curses library headers" >&5
if test "$wi_cv_ncurses" != "no" ; then
	for ac_hdr in ncurses.h curses.h termios.h termio.h sgtty.h sys/ioctl.h
do
ac_safe=`echo "$ac_hdr" | sed 'y%./+-%__p_%'`
echo $ac_n "checking for $ac_hdr""... $ac_c" 1>&6
echo "configure:6233: checking for $ac_hdr" >&5
if eval "test \"`echo '$''{'ac_cv_header_$ac_safe'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 6238 "configure"
#include "confdefs.h"
#include <$ac_hdr>
EOF
ac_try="$ac_cpp conftest.$ac_ext >/dev/null 2>conftest.out"
{ (eval echo configure:6243: \"$ac_try\") 1>&5; (eval $ac_try) 2>&5; }
ac_err=`grep -v '^ *+' conftest.out | grep -v "^conftest.${ac_ext}\$"`
if test -z "$ac_err"; then
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=yes"
else
  echo "$ac_err" >&5
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=no"
fi
rm -rf conftest*
fi
if eval "test \"`echo '$ac_cv_header_'$ac_safe`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_hdr=HAVE_`echo $ac_hdr | sed 'y%abcdefghijklmnopqrstuvwxyz./-%ABCDEFGHIJKLMNOPQRSTUVWXYZ___%'`
  cat >> confdefs.h <<EOF
#define $ac_tr_hdr 1
EOF
 
else
  echo "$ac_t""no" 1>&6
fi
done

else
	for ac_hdr in curses.h termios.h termio.h sgtty.h sys/ioctl.h
do
ac_safe=`echo "$ac_hdr" | sed 'y%./+-%__p_%'`
echo $ac_n "checking for $ac_hdr""... $ac_c" 1>&6
echo "configure:6274: checking for $ac_hdr" >&5
if eval "test \"`echo '$''{'ac_cv_header_$ac_safe'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 6279 "configure"
#include "confdefs.h"
#include <$ac_hdr>
EOF
ac_try="$ac_cpp conftest.$ac_ext >/dev/null 2>conftest.out"
{ (eval echo configure:6284: \"$ac_try\") 1>&5; (eval $ac_try) 2>&5; }
ac_err=`grep -v '^ *+' conftest.out | grep -v "^conftest.${ac_ext}\$"`
if test -z "$ac_err"; then
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=yes"
else
  echo "$ac_err" >&5
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=no"
fi
rm -rf conftest*
fi
if eval "test \"`echo '$ac_cv_header_'$ac_safe`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_hdr=HAVE_`echo $ac_hdr | sed 'y%abcdefghijklmnopqrstuvwxyz./-%ABCDEFGHIJKLMNOPQRSTUVWXYZ___%'`
  cat >> confdefs.h <<EOF
#define $ac_tr_hdr 1
EOF
 
else
  echo "$ac_t""no" 1>&6
fi
done

fi
if test "$ac_cv_header_curses_h" = no ; then
	if test -f /usr/include/curses.h ; then
		cat >> confdefs.h <<\EOF
#define HAVE_CURSES_H 1
EOF

		ac_cv_header_curses_h=yes
	fi
fi

echo $ac_n "checking for curses library""... $ac_c" 1>&6
echo "configure:6322: checking for curses library" >&5

wi_cv_lib_curses=no
wi_cv_lib_curses_result=no
ac_save_LIBS="$LIBS"
for LIBCURSES in "-lncurses" "-lcurses" "-lcurses -ltermcap" "-ltermcap -lcurses"
do
	if test "x$LIBCURSES-$wi_cv_ncurses" = "x-lncurses-no" ; then
		# This should never work
		LIBCURSES="-lkdfjkdjfs"
	fi
	LIBS="$ac_save_LIBS $LIBCURSES"
	cat > conftest.$ac_ext <<EOF
#line 6335 "configure"
#include "confdefs.h"

		/* includes */
#include <stdio.h>
#include <stdlib.h>

#ifdef HAVE_NCURSES_H
#	define NCURSES_OPAQUE 0
#	include <ncurses.h>
#else
#	include <curses.h>
#endif
	
int main() {

		/* function body */
		if (strcmp("jimmy", "floyd") == 0)
			initscr();
		exit(0);
	
; return 0; }
EOF
if { (eval echo configure:6358: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  
		linked_with_LIBCURSES=yes
	
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  
		linked_with_LIBCURSES=no
	
fi
rm -rf conftest*
	if test "x$linked_with_LIBCURSES" != "xyes" ; then continue ; fi
	if test "$cross_compiling" = yes; then
  
	# action if cross compiling
	wi_cv_lib_curses=yes
	wi_cv_lib_curses_result="yes"
	guess="(guessing) "

else
  cat > conftest.$ac_ext <<EOF
#line 6382 "configure"
#include "confdefs.h"

	/* program */
#include <stdio.h>
#include <stdlib.h>

#ifdef HAVE_NCURSES_H
#	define NCURSES_OPAQUE 0
#	include <ncurses.h>
#else
#	include <curses.h>
#endif

 
main(int argc, char **argv)
{
	/* Note:  don't actually call curses, since it may block;
	 * We just want to see if it (dynamic) linked in okay.
	 */
	if (argc == 0)
		initscr();
	exit(0);
}

EOF
if { (eval echo configure:6408: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext} && (./conftest; exit) 2>/dev/null
then
  
	# action if true
	wi_cv_lib_curses=yes
	guess=""
	wi_cv_lib_curses_result="yes"

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -fr conftest*
  
	# action if false
	wi_cv_lib_curses=no
	guess=""

fi
rm -fr conftest*
fi


	if test "$wi_cv_lib_curses" = yes ; then break ; fi
done

# restore LIBS
LIBS="$ac_save_LIBS"

if test "$wi_cv_lib_curses_result" != "no" ; then
	case "$LIBCURSES" in
		"-lncurses")
			cat >> confdefs.h <<\EOF
#define HAVE_LIBNCURSES 1
EOF

			;;
		"-lcurses")
			cat >> confdefs.h <<\EOF
#define HAVE_LIBCURSES 1
EOF

			;;
		"-lcurses -ltermcap")
			cat >> confdefs.h <<\EOF
#define HAVE_LIBCURSES 1
EOF

			;;
		"-ltermcap -lcurses")
			cat >> confdefs.h <<\EOF
#define HAVE_LIBCURSES 1
EOF

			;;
	esac
else
	LIBCURSES=''
fi


echo "$ac_t""$wi_cv_lib_curses_result" 1>&6

fi

# Check whether user wants DNSSEC local validation support
# Check whether --with-dnssec-local-validation or --without-dnssec-local-validation was given.
if test "${with_dnssec_local_validation+set}" = set; then
  withval="$with_dnssec_local_validation"
  want_dnssec=$withval
else
  want_dnssec=no
fi

if ! test "x-$want_dnssec" = "x-no" ; then
    for ac_hdr in validator/validator.h
do
ac_safe=`echo "$ac_hdr" | sed 'y%./+-%__p_%'`
echo $ac_n "checking for $ac_hdr""... $ac_c" 1>&6
echo "configure:6486: checking for $ac_hdr" >&5
if eval "test \"`echo '$''{'ac_cv_header_$ac_safe'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 6491 "configure"
#include "confdefs.h"
#include <$ac_hdr>
EOF
ac_try="$ac_cpp conftest.$ac_ext >/dev/null 2>conftest.out"
{ (eval echo configure:6496: \"$ac_try\") 1>&5; (eval $ac_try) 2>&5; }
ac_err=`grep -v '^ *+' conftest.out | grep -v "^conftest.${ac_ext}\$"`
if test -z "$ac_err"; then
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=yes"
else
  echo "$ac_err" >&5
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=no"
fi
rm -rf conftest*
fi
if eval "test \"`echo '$ac_cv_header_'$ac_safe`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_hdr=HAVE_`echo $ac_hdr | sed 'y%abcdefghijklmnopqrstuvwxyz./-%ABCDEFGHIJKLMNOPQRSTUVWXYZ___%'`
  cat >> confdefs.h <<EOF
#define $ac_tr_hdr 1
EOF
 
else
  echo "$ac_t""no" 1>&6
fi
done

    if test "$ac_cv_header_validator_validator_h" != yes; then
        { echo "configure: error: Can't find validator.h" 1>&2; exit 1; }
    fi
    echo $ac_n "checking for SHA1_Init in -lssl""... $ac_c" 1>&6
echo "configure:6526: checking for SHA1_Init in -lssl" >&5
ac_lib_var=`echo ssl'_'SHA1_Init | sed 'y%./+-%__p_%'`
if eval "test \"`echo '$''{'ac_cv_lib_$ac_lib_var'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  ac_save_LIBS="$LIBS"
LIBS="-lssl  $LIBS"
cat > conftest.$ac_ext <<EOF
#line 6534 "configure"
#include "confdefs.h"
/* Override any gcc2 internal prototype to avoid an error.  */
/* We use char because int might match the return type of a gcc2
    builtin and then its argument prototype would still apply.  */
char SHA1_Init();

int main() {
SHA1_Init()
; return 0; }
EOF
if { (eval echo configure:6545: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=yes"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=no"
fi
rm -rf conftest*
LIBS="$ac_save_LIBS"

fi
if eval "test \"`echo '$ac_cv_lib_'$ac_lib_var`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_lib=HAVE_LIB`echo ssl | sed -e 's/[^a-zA-Z0-9_]/_/g' \
    -e 'y/abcdefghijklmnopqrstuvwxyz/ABCDEFGHIJKLMNOPQRSTUVWXYZ/'`
  cat >> confdefs.h <<EOF
#define $ac_tr_lib 1
EOF

  LIBS="-lssl $LIBS"

else
  echo "$ac_t""no" 1>&6
{ echo "configure: error: Can't find SSL library" 1>&2; exit 1; }
fi

    echo $ac_n "checking for query_send in -lsres""... $ac_c" 1>&6
echo "configure:6574: checking for query_send in -lsres" >&5
ac_lib_var=`echo sres'_'query_send | sed 'y%./+-%__p_%'`
if eval "test \"`echo '$''{'ac_cv_lib_$ac_lib_var'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  ac_save_LIBS="$LIBS"
LIBS="-lsres  $LIBS"
cat > conftest.$ac_ext <<EOF
#line 6582 "configure"
#include "confdefs.h"
/* Override any gcc2 internal prototype to avoid an error.  */
/* We use char because int might match the return type of a gcc2
    builtin and then its argument prototype would still apply.  */
char query_send();

int main() {
query_send()
; return 0; }
EOF
if { (eval echo configure:6593: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=yes"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=no"
fi
rm -rf conftest*
LIBS="$ac_save_LIBS"

fi
if eval "test \"`echo '$ac_cv_lib_'$ac_lib_var`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_lib=HAVE_LIB`echo sres | sed -e 's/[^a-zA-Z0-9_]/_/g' \
    -e 'y/abcdefghijklmnopqrstuvwxyz/ABCDEFGHIJKLMNOPQRSTUVWXYZ/'`
  cat >> confdefs.h <<EOF
#define $ac_tr_lib 1
EOF

  LIBS="-lsres $LIBS"

else
  echo "$ac_t""no" 1>&6
{ echo "configure: error: Can't find libsres" 1>&2; exit 1; }
fi

    echo $ac_n "checking for p_val_status in -lval""... $ac_c" 1>&6
echo "configure:6622: checking for p_val_status in -lval" >&5
ac_lib_var=`echo val'_'p_val_status | sed 'y%./+-%__p_%'`
if eval "test \"`echo '$''{'ac_cv_lib_$ac_lib_var'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  ac_save_LIBS="$LIBS"
LIBS="-lval  $LIBS"
cat > conftest.$ac_ext <<EOF
#line 6630 "configure"
#include "confdefs.h"
/* Override any gcc2 internal prototype to avoid an error.  */
/* We use char because int might match the return type of a gcc2
    builtin and then its argument prototype would still apply.  */
char p_val_status();

int main() {
p_val_status()
; return 0; }
EOF
if { (eval echo configure:6641: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=yes"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=no"
fi
rm -rf conftest*
LIBS="$ac_save_LIBS"

fi
if eval "test \"`echo '$ac_cv_lib_'$ac_lib_var`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  LIBS="$LIBS -lval"
                 have_val_res_query=yes
else
  echo "$ac_t""no" 1>&6
 echo $ac_n "checking for pthread_rwlock_init in -lpthread""... $ac_c" 1>&6
echo "configure:6661: checking for pthread_rwlock_init in -lpthread" >&5
ac_lib_var=`echo pthread'_'pthread_rwlock_init | sed 'y%./+-%__p_%'`
if eval "test \"`echo '$''{'ac_cv_lib_$ac_lib_var'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  ac_save_LIBS="$LIBS"
LIBS="-lpthread  $LIBS"
cat > conftest.$ac_ext <<EOF
#line 6669 "configure"
#include "confdefs.h"
/* Override any gcc2 internal prototype to avoid an error.  */
/* We use char because int might match the return type of a gcc2
    builtin and then its argument prototype would still apply.  */
char pthread_rwlock_init();

int main() {
pthread_rwlock_init()
; return 0; }
EOF
if { (eval echo configure:6680: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=yes"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=no"
fi
rm -rf conftest*
LIBS="$ac_save_LIBS"

fi
if eval "test \"`echo '$ac_cv_lib_'$ac_lib_var`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_lib=HAVE_LIB`echo pthread | sed -e 's/[^a-zA-Z0-9_]/_/g' \
    -e 'y/abcdefghijklmnopqrstuvwxyz/ABCDEFGHIJKLMNOPQRSTUVWXYZ/'`
  cat >> confdefs.h <<EOF
#define $ac_tr_lib 1
EOF

  LIBS="-lpthread $LIBS"

else
  echo "$ac_t""no" 1>&6
fi

		   echo $ac_n "checking for p_val_status in -lval-threads""... $ac_c" 1>&6
echo "configure:6708: checking for p_val_status in -lval-threads" >&5
ac_lib_var=`echo val-threads'_'p_val_status | sed 'y%./+-%__p_%'`
if eval "test \"`echo '$''{'ac_cv_lib_$ac_lib_var'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  ac_save_LIBS="$LIBS"
LIBS="-lval-threads  $LIBS"
cat > conftest.$ac_ext <<EOF
#line 6716 "configure"
#include "confdefs.h"
/* Override any gcc2 internal prototype to avoid an error.  */
/* We use char because int might match the return type of a gcc2
    builtin and then its argument prototype would still apply.  */
char p_val_status();

int main() {
p_val_status()
; return 0; }
EOF
if { (eval echo configure:6727: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=yes"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=no"
fi
rm -rf conftest*
LIBS="$ac_save_LIBS"

fi
if eval "test \"`echo '$ac_cv_lib_'$ac_lib_var`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  have_val_res_query=yes
                   LIBS="-lval-threads $LIBS"
                   LIBVAL_SUFFIX="-threads"
else
  echo "$ac_t""no" 1>&6
{ echo "configure: error: Can't find libval or libval-threads" 1>&2; exit 1; }
fi

                 
fi

    cat >> confdefs.h <<\EOF
#define DNSSEC_LOCAL_VALIDATION 1
EOF

fi



echo $ac_n "checking for working const""... $ac_c" 1>&6
echo "configure:6762: checking for working const" >&5
if eval "test \"`echo '$''{'ac_cv_c_const'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 6767 "configure"
#include "confdefs.h"

int main() {

/* Ultrix mips cc rejects this.  */
typedef int charset[2]; const charset x;
/* SunOS 4.1.1 cc rejects this.  */
char const *const *ccp;
char **p;
/* NEC SVR4.0.2 mips cc rejects this.  */
struct point {int x, y;};
static struct point const zero = {0,0};
/* AIX XL C 1.02.0.0 rejects this.
   It does not let you subtract one const X* pointer from another in an arm
   of an if-expression whose if-part is not a constant expression */
const char *g = "string";
ccp = &g + (g ? g-g : 0);
/* HPUX 7.0 cc rejects these. */
++ccp;
p = (char**) ccp;
ccp = (char const *const *) p;
{ /* SCO 3.2v4 cc rejects this.  */
  char *t;
  char const *s = 0 ? (char *) 0 : (char const *) 0;

  *t++ = 0;
}
{ /* Someone thinks the Sun supposedly-ANSI compiler will reject this.  */
  int x[] = {25, 17};
  const int *foo = &x[0];
  ++foo;
}
{ /* Sun SC1.0 ANSI compiler rejects this -- but not the above. */
  typedef const int *iptr;
  iptr p = 0;
  ++p;
}
{ /* AIX XL C 1.02.0.0 rejects this saying
     "k.c", line 2.27: 1506-025 (S) Operand must be a modifiable lvalue. */
  struct s { int j; const int *ap[3]; };
  struct s *b; b->j = 5;
}
{ /* ULTRIX-32 V3.1 (Rev 9) vcc rejects this */
  const int foo = 10;
}

; return 0; }
EOF
if { (eval echo configure:6816: \"$ac_compile\") 1>&5; (eval $ac_compile) 2>&5; }; then
  rm -rf conftest*
  ac_cv_c_const=yes
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  ac_cv_c_const=no
fi
rm -rf conftest*
fi

echo "$ac_t""$ac_cv_c_const" 1>&6
if test $ac_cv_c_const = no; then
  cat >> confdefs.h <<\EOF
#define const 
EOF

fi

echo $ac_n "checking for size_t""... $ac_c" 1>&6
echo "configure:6837: checking for size_t" >&5
if eval "test \"`echo '$''{'ac_cv_type_size_t'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 6842 "configure"
#include "confdefs.h"
#include <sys/types.h>
#if STDC_HEADERS
#include <stdlib.h>
#include <stddef.h>
#endif
EOF
if (eval "$ac_cpp conftest.$ac_ext") 2>&5 |
  egrep "(^|[^a-zA-Z_0-9])size_t[^a-zA-Z_0-9]" >/dev/null 2>&1; then
  rm -rf conftest*
  ac_cv_type_size_t=yes
else
  rm -rf conftest*
  ac_cv_type_size_t=no
fi
rm -rf conftest*

fi
echo "$ac_t""$ac_cv_type_size_t" 1>&6
if test $ac_cv_type_size_t = no; then
  cat >> confdefs.h <<\EOF
#define size_t unsigned
EOF

fi

echo $ac_n "checking for off_t""... $ac_c" 1>&6
echo "configure:6870: checking for off_t" >&5
if eval "test \"`echo '$''{'ac_cv_type_off_t'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 6875 "configure"
#include "confdefs.h"
#include <sys/types.h>
#if STDC_HEADERS
#include <stdlib.h>
#include <stddef.h>
#endif
EOF
if (eval "$ac_cpp conftest.$ac_ext") 2>&5 |
  egrep "(^|[^a-zA-Z_0-9])off_t[^a-zA-Z_0-9]" >/dev/null 2>&1; then
  rm -rf conftest*
  ac_cv_type_off_t=yes
else
  rm -rf conftest*
  ac_cv_type_off_t=no
fi
rm -rf conftest*

fi
echo "$ac_t""$ac_cv_type_off_t" 1>&6
if test $ac_cv_type_off_t = no; then
  cat >> confdefs.h <<\EOF
#define off_t long
EOF

fi

echo $ac_n "checking for mode_t""... $ac_c" 1>&6
echo "configure:6903: checking for mode_t" >&5
if eval "test \"`echo '$''{'ac_cv_type_mode_t'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 6908 "configure"
#include "confdefs.h"
#include <sys/types.h>
#if STDC_HEADERS
#include <stdlib.h>
#include <stddef.h>
#endif
EOF
if (eval "$ac_cpp conftest.$ac_ext") 2>&5 |
  egrep "(^|[^a-zA-Z_0-9])mode_t[^a-zA-Z_0-9]" >/dev/null 2>&1; then
  rm -rf conftest*
  ac_cv_type_mode_t=yes
else
  rm -rf conftest*
  ac_cv_type_mode_t=no
fi
rm -rf conftest*

fi
echo "$ac_t""$ac_cv_type_mode_t" 1>&6
if test $ac_cv_type_mode_t = no; then
  cat >> confdefs.h <<\EOF
#define mode_t int
EOF

fi

echo $ac_n "checking for pid_t""... $ac_c" 1>&6
echo "configure:6936: checking for pid_t" >&5
if eval "test \"`echo '$''{'ac_cv_type_pid_t'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 6941 "configure"
#include "confdefs.h"
#include <sys/types.h>
#if STDC_HEADERS
#include <stdlib.h>
#include <stddef.h>
#endif
EOF
if (eval "$ac_cpp conftest.$ac_ext") 2>&5 |
  egrep "(^|[^a-zA-Z_0-9])pid_t[^a-zA-Z_0-9]" >/dev/null 2>&1; then
  rm -rf conftest*
  ac_cv_type_pid_t=yes
else
  rm -rf conftest*
  ac_cv_type_pid_t=no
fi
rm -rf conftest*

fi
echo "$ac_t""$ac_cv_type_pid_t" 1>&6
if test $ac_cv_type_pid_t = no; then
  cat >> confdefs.h <<\EOF
#define pid_t int
EOF

fi

echo $ac_n "checking for uid_t in sys/types.h""... $ac_c" 1>&6
echo "configure:6969: checking for uid_t in sys/types.h" >&5
if eval "test \"`echo '$''{'ac_cv_type_uid_t'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 6974 "configure"
#include "confdefs.h"
#include <sys/types.h>
EOF
if (eval "$ac_cpp conftest.$ac_ext") 2>&5 |
  egrep "uid_t" >/dev/null 2>&1; then
  rm -rf conftest*
  ac_cv_type_uid_t=yes
else
  rm -rf conftest*
  ac_cv_type_uid_t=no
fi
rm -rf conftest*

fi

echo "$ac_t""$ac_cv_type_uid_t" 1>&6
if test $ac_cv_type_uid_t = no; then
  cat >> confdefs.h <<\EOF
#define uid_t int
EOF

  cat >> confdefs.h <<\EOF
#define gid_t int
EOF

fi


echo $ac_n "checking what type main() should return""... $ac_c" 1>&6
echo "configure:7004: checking what type main() should return" >&5
if eval "test \"`echo '$''{'wi_cv_main_void_return_t'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  
wi_cv_main_void_return_t="int"
case "${GCC}_${SYS}" in
	no_irix*|no_hpux)
		wi_cv_main_void_return_t="void"
		;;
esac

fi

echo "$ac_t""$wi_cv_main_void_return_t" 1>&6
cat >> confdefs.h <<EOF
#define main_void_return_t $wi_cv_main_void_return_t
EOF




	if test "x$ac_cv_header_unistd_h" = x ; then
		{ echo "configure: error: Script needs to check for <unistd.h> before calling wi_USE_LONG_LONG." 1>&2; exit 1; }
	fi

echo $ac_n "checking for 64-bit integral type: long long""... $ac_c" 1>&6
echo "configure:7031: checking for 64-bit integral type: long long" >&5
LONGEST_INT="long"
if test "$cross_compiling" = yes; then
  
	# action if cross compiling
	guess="(guessing) "
	wi_cv_type_long_long=yes
	LONGEST_INT="long long"

else
  cat > conftest.$ac_ext <<EOF
#line 7042 "configure"
#include "confdefs.h"

	/* program */
#if defined(AIX) || defined(_AIX) || defined(__HOS_AIX__)
#	define _ALL_SOURCE 1
#endif
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <sys/types.h>
#include <stdio.h>

long long hugeNumvar = 1;

main()
{
	long long hugeNumtoo = 2;

	if (hugeNumtoo > hugeNumvar)
		hugeNumvar++;
	if (sizeof(hugeNumvar) < 8)
		exit(1);
	exit(0);
}


EOF
if { (eval echo configure:7070: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext} && (./conftest; exit) 2>/dev/null
then
  
	# action if true
	guess=""
	wi_cv_type_long_long=yes
	LONGEST_INT="long long"

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -fr conftest*
  
	# action if false
	guess=""
  	wi_cv_type_long_long=no

fi
rm -fr conftest*
fi

echo "$ac_t""$guess$wi_cv_type_long_long" 1>&6

if test "$wi_cv_type_long_long" = yes ; then
	
echo $ac_n "checking how to print a 64-bit integral type""... $ac_c" 1>&6
echo "configure:7096: checking how to print a 64-bit integral type" >&5
wi_cv_printf_long_long=fail

if test "$cross_compiling" = yes; then
  
	# action if cross compiling
	guess="(guessing) "
	wi_cv_printf_long_long="%lld"

else
  cat > conftest.$ac_ext <<EOF
#line 7107 "configure"
#include "confdefs.h"

	/* program */
#if defined(AIX) || defined(_AIX) || defined(__HOS_AIX__)
#	define _ALL_SOURCE 1
#endif
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

main()
{
	char s[80];
	long long hugeNum;

	hugeNum = (long long) 1000000000;
	hugeNum = hugeNum * (long long) 99;
	hugeNum = hugeNum + (long long) 1;

	(void) sprintf(s, "%lld", hugeNum);
	exit((strcmp(s, "99000000001") == 0) ? 0 : 1);
}

EOF
if { (eval echo configure:7136: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext} && (./conftest; exit) 2>/dev/null
then
  
	# action if true
	guess=""
	wi_cv_printf_long_long="%lld"

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -fr conftest*
  
	# action if false
	guess=""

fi
rm -fr conftest*
fi



if test "$wi_cv_printf_long_long" = fail ; then

if test "$cross_compiling" = yes; then
  
	# action if cross compiling
	:

else
  cat > conftest.$ac_ext <<EOF
#line 7166 "configure"
#include "confdefs.h"

	/* program */
#if defined(AIX) || defined(_AIX) || defined(__HOS_AIX__)
#	define _ALL_SOURCE 1
#endif
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

main()
{
	char s[80];
	long long hugeNum;

	hugeNum = (long long) 1000000000;
	hugeNum = hugeNum * (long long) 99;
	hugeNum = hugeNum + (long long) 1;

	(void) sprintf(s, "%qd", hugeNum);
	exit((strcmp(s, "99000000001") == 0) ? 0 : 1);
}

EOF
if { (eval echo configure:7195: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext} && (./conftest; exit) 2>/dev/null
then
  
	# action if true
	wi_cv_printf_long_long="%qd"

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -fr conftest*
  
	# action if false
	:

fi
rm -fr conftest*
fi

fi

if test "$wi_cv_printf_long_long" = fail ; then
	wi_cv_printf_long_long_msg_result='cannot print'
else
	wi_cv_printf_long_long_msg_result="$wi_cv_printf_long_long"
fi

echo "$ac_t""$guess$wi_cv_printf_long_long_msg_result" 1>&6

	
echo $ac_n "checking how to scan a 64-bit integral type""... $ac_c" 1>&6
echo "configure:7225: checking how to scan a 64-bit integral type" >&5
wi_cv_scanf_long_long=fail

if test "$cross_compiling" = yes; then
  
	# action if cross compiling
	guess="(guessing) "
	wi_cv_scanf_long_long="%lld"

else
  cat > conftest.$ac_ext <<EOF
#line 7236 "configure"
#include "confdefs.h"

	/* program */
#if defined(AIX) || defined(_AIX) || defined(__HOS_AIX__)
#	define _ALL_SOURCE 1
#endif
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

main()
{
	long long hugeNum, justAsHugeNum;

	hugeNum = (long long) 1000000000;
	hugeNum = hugeNum * (long long) 99;
	hugeNum = hugeNum + (long long) 1;

	justAsHugeNum = (long long) 0;
	--justAsHugeNum;
	sscanf("99000000001", "%lld", &justAsHugeNum);
	if (memcmp(&hugeNum, &justAsHugeNum, sizeof(hugeNum)) == 0)
		exit(0);
	exit(1);
}

EOF
if { (eval echo configure:7268: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext} && (./conftest; exit) 2>/dev/null
then
  
	# action if true
	guess=""
	wi_cv_scanf_long_long="%lld"

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -fr conftest*
  
	# action if false
	guess=""

fi
rm -fr conftest*
fi



if test "$wi_cv_scanf_long_long" = fail ; then

if test "$cross_compiling" = yes; then
  
	# action if cross compiling
	:

else
  cat > conftest.$ac_ext <<EOF
#line 7298 "configure"
#include "confdefs.h"

	/* program */
#if defined(AIX) || defined(_AIX) || defined(__HOS_AIX__)
#	define _ALL_SOURCE 1
#endif
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

main()
{
	long long hugeNum, justAsHugeNum;

	hugeNum = (long long) 1000000000;
	hugeNum = hugeNum * (long long) 99;
	hugeNum = hugeNum + (long long) 1;

	justAsHugeNum = (long long) 0;
	--justAsHugeNum;
	sscanf("99000000001", "%qd", &justAsHugeNum);
	if (memcmp(&hugeNum, &justAsHugeNum, sizeof(hugeNum)) == 0)
		exit(0);
	exit(1);
}

EOF
if { (eval echo configure:7330: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext} && (./conftest; exit) 2>/dev/null
then
  
	# action if true
	wi_cv_scanf_long_long="%qd"

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -fr conftest*
  
	# action if false
	:

fi
rm -fr conftest*
fi

fi

if test "$wi_cv_scanf_long_long" = fail ; then
	wi_cv_scanf_long_long_msg_result='cannot scan'
else
	wi_cv_scanf_long_long_msg_result="$wi_cv_scanf_long_long"
fi

echo "$ac_t""$guess$wi_cv_scanf_long_long_msg_result" 1>&6

fi

echo $ac_n "checking if everything was available to use the 64-bit integral type""... $ac_c" 1>&6
echo "configure:7361: checking if everything was available to use the 64-bit integral type" >&5

if test "$wi_cv_type_long_long" = no ; then
	wi_cv_use_long_long_msg_result="no (long long type not available)"
	wi_cv_use_long_long="no"
	wi_cv_scanf_long_long="fail"
	wi_cv_prihtf_long_long="fail"
	LONGEST_INT="long"
elif test "$wi_cv_printf_long_long" = fail ; then
	wi_cv_use_long_long_msg_result="no (libc printf() does not support them)"
	wi_cv_use_long_long="no"
	wi_cv_scanf_long_long="fail"
	wi_cv_prihtf_long_long="fail"
	LONGEST_INT="long"
elif test "$wi_cv_scanf_long_long" = fail ; then
	wi_cv_use_long_long_msg_result="no (libc scanf() does not support them)"
	wi_cv_use_long_long="no"
	wi_cv_scanf_long_long="fail"
	wi_cv_prihtf_long_long="fail"
	LONGEST_INT="long"
else
	cat >> confdefs.h <<\EOF
#define HAVE_LONG_LONG 1
EOF

	if test "$wi_cv_printf_long_long$wi_cv_scanf_long_long" = "%lld%qd" ; then
		# FreeBSD 3.2 has %lld and %qd, but we want to
		# run on 3.1 and 3.0.
		#
		wi_cv_printf_long_long="%qd"
	fi
	wi_cv_printf_ulong_long=`echo "$wi_cv_printf_long_long" | sed 's/d$/u/;'`
	wi_cv_scanf_ulong_long=`echo "$wi_cv_scanf_long_long" | sed 's/d$/u/;'`
	cat >> confdefs.h <<EOF
#define PRINTF_LONG_LONG "$wi_cv_printf_long_long"
EOF

	cat >> confdefs.h <<EOF
#define SCANF_LONG_LONG  "$wi_cv_scanf_long_long"
EOF

	cat >> confdefs.h <<EOF
#define PRINTF_ULONG_LONG "$wi_cv_printf_ulong_long"
EOF

	cat >> confdefs.h <<EOF
#define SCANF_ULONG_LONG  "$wi_cv_scanf_ulong_long"
EOF

	if test "$wi_cv_printf_long_long" = "%qd" ; then
		cat >> confdefs.h <<\EOF
#define PRINTF_LONG_LONG_QD 1
EOF

	else
		cat >> confdefs.h <<\EOF
#define PRINTF_LONG_LONG_LLD 1
EOF

	fi
	if test "$wi_cv_scanf_long_long" = "%qd" ; then
		cat >> confdefs.h <<\EOF
#define SCANF_LONG_LONG_QD 1
EOF

	else
		cat >> confdefs.h <<\EOF
#define SCANF_LONG_LONG_LLD 1
EOF

	fi
	wi_cv_use_long_long="yes"
	wi_cv_use_long_long_msg_result="yes"
fi
echo "$ac_t""$wi_cv_use_long_long_msg_result" 1>&6


wi_struct_timeval_field_checks="cached"
echo $ac_n "checking what type the tv_sec field of struct timeval is""... $ac_c" 1>&6
echo "configure:7440: checking what type the tv_sec field of struct timeval is" >&5
if eval "test \"`echo '$''{'wi_cv_struct_timeval_tv_sec'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  
wi_struct_timeval_field_checks="uncached"

	if test "x$ac_cv_header_unistd_h" = x ; then
		{ echo "configure: error: Script needs to check for <unistd.h> before calling wi_STRUCT_TIMEVAL_FIELD_TYPES." 1>&2; exit 1; }
	fi

if test "$cross_compiling" = yes; then
  
	# action if cross compiling
	guess="(guessing) "
	guess2="$guess"
	wi_cv_struct_timeval_tv_sec="long"
	wi_cv_struct_timeval_tv_usec="long"

else
  cat > conftest.$ac_ext <<EOF
#line 7461 "configure"
#include "confdefs.h"

	/* program */
#if defined(AIX) || defined(_AIX) || defined(__HOS_AIX__)
#	define _ALL_SOURCE 1
#endif
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/time.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

static void
neg(void *dst0, size_t siz)
{
	unsigned char *dst = (unsigned char *) dst0;
	unsigned char *dlim;

	dlim = dst + siz;
	while (dst < dlim)
		*dst++ = (unsigned char) 0xEE;
}

int
main(int argc, char **argv)
{
	FILE *fp;
	const char *typ;
	struct timeval tv;
#define x tv.tv_sec

	memset(&tv, 0, sizeof(tv));
	fp = stdout;
	if (argc == 1) {
		fp = fopen("conftest.out", "w");
		if (fp == NULL) {
			perror("could not write to ./conftest.out");
			exit(1);
		}
	}

	neg(&x, sizeof(x));
#ifdef HAVE_LONG_LONG
	if (sizeof(x) == sizeof(long long)) {
		typ = "long long";
	} else
#endif
	if (sizeof(x) == sizeof(long)) {
		typ = "long";
	} else {
		typ = "int";
	}
	(void) fprintf(fp, "%s%s\n", (x > 0) ? "unsigned " : "", typ);
#undef x

#define x tv.tv_usec
	neg(&x, sizeof(x));
#ifdef HAVE_LONG_LONG
	if (sizeof(x) == sizeof(long long)) {
		typ = "long long";
	} else
#endif
	if (sizeof(x) == sizeof(long)) {
		typ = "long";
	} else {
		typ = "int";
	}
	(void) fprintf(fp, "%s%s\n", (x > 0) ? "unsigned " : "", typ);
#undef x

	if (fp != stdout)
		(void) fclose(fp);
	exit(0);
}

EOF
if { (eval echo configure:7541: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext} && (./conftest; exit) 2>/dev/null
then
  
	# action if true
	guess=""
	if test -f conftest.out ; then
		wi_cv_struct_timeval_tv_sec="`sed -n '1,1p' conftest.out`"
		wi_cv_struct_timeval_tv_usec="`sed -n '2,2p' conftest.out`"
	fi

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -fr conftest*
  
	# action if false
	guess=""
	wi_cv_struct_timeval_tv_sec="long"
	wi_cv_struct_timeval_tv_usec="long"

fi
rm -fr conftest*
fi

	rm -f conftest.out

fi

echo "$ac_t""$guess$wi_cv_struct_timeval_tv_sec" 1>&6
guess=""

if test "$wi_struct_timeval_field_checks" = "uncached" ; then
	guess="$guess2"
	echo $ac_n "checking what type the tv_usec field of struct timeval is""... $ac_c" 1>&6
echo "configure:7575: checking what type the tv_usec field of struct timeval is" >&5
	echo "$ac_t""$guess$wi_cv_struct_timeval_tv_usec" 1>&6
else
	guess="$guess2"
	echo $ac_n "checking what type the tv_usec field of struct timeval is""... $ac_c" 1>&6
echo "configure:7580: checking what type the tv_usec field of struct timeval is" >&5
if eval "test \"`echo '$''{'wi_cv_struct_timeval_tv_usec'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  :
fi

echo "$ac_t""$guess$wi_cv_struct_timeval_tv_usec" 1>&6
guess=""

fi
cat >> confdefs.h <<EOF
#define tv_sec_t $wi_cv_struct_timeval_tv_sec
EOF

cat >> confdefs.h <<EOF
#define tv_usec_t $wi_cv_struct_timeval_tv_usec
EOF



# Extract the first word of ""perl"", so it can be a program name with args.
set dummy "perl"; ac_word=$2
echo $ac_n "checking for $ac_word""... $ac_c" 1>&6
echo "configure:7604: checking for $ac_word" >&5
if eval "test \"`echo '$''{'ac_cv_path_PERL'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  case "$PERL" in
  /*)
  ac_cv_path_PERL="$PERL" # Let the user override the test with a path.
  ;;
  ?:/*)			 
  ac_cv_path_PERL="$PERL" # Let the user override the test with a dos path.
  ;;
  *)
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS=":"
  ac_dummy="$PATH"
  for ac_dir in $ac_dummy; do 
    test -z "$ac_dir" && ac_dir=.
    if test -f $ac_dir/$ac_word; then
      ac_cv_path_PERL="$ac_dir/$ac_word"
      break
    fi
  done
  IFS="$ac_save_ifs"
  test -z "$ac_cv_path_PERL" && ac_cv_path_PERL=""perl""
  ;;
esac
fi
PERL="$ac_cv_path_PERL"
if test -n "$PERL"; then
  echo "$ac_t""$PERL" 1>&6
else
  echo "$ac_t""no" 1>&6
fi



# Extract the first word of ""mktemp"", so it can be a program name with args.
set dummy "mktemp"; ac_word=$2
echo $ac_n "checking for $ac_word""... $ac_c" 1>&6
echo "configure:7642: checking for $ac_word" >&5
if eval "test \"`echo '$''{'ac_cv_path_MKTEMP'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  case "$MKTEMP" in
  /*)
  ac_cv_path_MKTEMP="$MKTEMP" # Let the user override the test with a path.
  ;;
  ?:/*)			 
  ac_cv_path_MKTEMP="$MKTEMP" # Let the user override the test with a dos path.
  ;;
  *)
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS=":"
  ac_dummy="$PATH"
  for ac_dir in $ac_dummy; do 
    test -z "$ac_dir" && ac_dir=.
    if test -f $ac_dir/$ac_word; then
      ac_cv_path_MKTEMP="$ac_dir/$ac_word"
      break
    fi
  done
  IFS="$ac_save_ifs"
  test -z "$ac_cv_path_MKTEMP" && ac_cv_path_MKTEMP=""""
  ;;
esac
fi
MKTEMP="$ac_cv_path_MKTEMP"
if test -n "$MKTEMP"; then
  echo "$ac_t""$MKTEMP" 1>&6
else
  echo "$ac_t""no" 1>&6
fi








	if test "x$ac_cv_header_unistd_h" = x ; then
		{ echo "configure: error: Script needs to check for <unistd.h> before calling wi_UNISTD_FUNC_PARAM_TYPES." 1>&2; exit 1; }
	fi

echo $ac_n "checking for return type from write""... $ac_c" 1>&6
echo "configure:7687: checking for return type from write" >&5
if eval "test \"`echo '$''{'wi_cv_write_return_t'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  
used_cache_for_wi_unistd_fpt="no"


wi_tmpdir=""
if [ "x$MKTEMP" != "x" ] ; then
	# Ignore error from mktemp, since some old versions of Linux
	# print an error about not supporting -d.
	#
	wi_tmpdir=`"$MKTEMP" -d /tmp/configure.XXXXXXXXXX 2>/dev/null`
	if [ $? -ne 0 ] ; then
		wi_tmpdir=""
	fi
fi
if [ "x$wi_tmpdir" = "x" ] ; then
	for wi_tmpdir in . $TMPDIR $TEMPDIR /tmp ABORT
	do
		if [ "$wi_tmpdir" = ABORT ] ; then
			echo "Cannot create temporary directory."
			exit 1
		fi
		wi_tmpdir="$wi_tmpdir/config_tmp.$$"
		if [ -d "$wi_tmpdir" ] || [ -f "$wi_tmpdir" ] ; then
			echo "Will not create temporary directory."
			exit 1
		fi
		mkdir "$wi_tmpdir"
		if [ $? -eq 0 ] && [ -d "$wi_tmpdir" ] ; then break ;  fi
	done
fi

# Use the temporary directory here...


cat << 'EOF' > "$wi_tmpdir/prpp.pl"
#!/usr/bin/perl -w
#
# prpp.pl
#
# Feed the output of your CPP to this to print a list of function prototypes.
# 
#use strict;

my ($c) = "";
my ($unputc) = "";
my ($line) = "";
my ($lines) = "";
my ($cline) = "";
my ($skipping) = 0;
my ($numclines) = 0;

MAINLOOP: while (1) {
	if ($unputc ne "") {
		$c = $unputc;
		$unputc = "";
	} else {
		last unless (read(STDIN, $c, 1) == 1);
	}
	if ($c eq "{") {
		$skipping++;
	} elsif ($c eq "}") {
		--$skipping;
		$unputc = ";";
	} elsif ($skipping) {
		next MAINLOOP;
	} elsif ($c eq ";") {
		if ($line =~ m/^\s*(\S.*\S)\s*$/s) {
			$lines .= $1;
			$line = "";
		}
		if ($lines =~ m/^\s*(extern\s*)?(\S.*\S)\s*$/s) {
			$cline = $2;
			$cline =~ s/\s+/\ /g;
			if ($cline =~ /^typedef/) {
				$cline = "";
			} elsif ($cline =~ /\(.*\)$/) {
				# found a proto
				print $cline, ";\n";
				$numclines++;
			} else {
				$cline = "";
			}
		}
		$lines = "";
		$line = "";
	} elsif ($c eq "\n") {
		if ($line =~ m/^\s*(\S.*\S)\s*$/s) {
			$lines .= $1 . " ";
			$line = "";
		}
	} elsif (($c eq "#") && ($line eq "")) {
		# Looks like a preprocessor line, kill it
		{
			last MAINLOOP if (read(STDIN, $c, 1) != 1);
			last if ($c eq "\n");
			redo;
		}
	} elsif ($c =~ /^\s$/) {
		$line .= " " if ($line ne "");
	} elsif (! $skipping) {
		$line .= $c;
	}
}
exit(($numclines == 0) ? 1 : 0);
EOF
chmod 755 "$wi_tmpdir/prpp.pl"


cat << 'EOF' > "$wi_tmpdir/unistd.c"
#include <confdefs.h>

#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

main()
{
	exit(0);
}
EOF

cat << 'EOF' > "$wi_tmpdir/sed.sh"
#!/bin/sh

if [ $# -eq 0 ] ; then exit 1 ; fi
x="$1"

sed -n 's/extern//;s/static//;
		/[\ \*]'"$x"'\ *(/{
			s/^.*'"$x"'\ *(/(/
			s/)\ *[;,].*$/)/
			/ssize_t/{
				c\
ssize_t
			}
			/size_t/{
				c\
size_t
			}
			/socklen_t/{
				c\
socklen_t
			}
			/unsigned int/{
				c\
unsigned int
			}
			/unsigned long/{
				c\
unsigned long
			}
			/long/{
				c\
long
			}
			q
}' | sed 's/int int/int/g'
EOF
chmod 755 "$wi_tmpdir/sed.sh"


cat << 'EOF' > "$wi_tmpdir/sed2.sh"
#!/bin/sh

if [ $# -eq 0 ] ; then exit 1 ; fi
x="$1"

sed -n 's/extern//;s/static//;
		/[\ \*]'"$x"'\ *(/{
			s/^.*'"$x"'\ *(/(/
			s/)\ *[;,].*$/)/
			/const char/{
				c\
const char *
			}
			/char/{
				c\
char *
			}
			/const/{
				c\
const void
			}
			q
}'
EOF
chmod 755 "$wi_tmpdir/sed2.sh"

$CPP "-I${srcdir-.}" "$wi_tmpdir/unistd.c" > "$wi_tmpdir/unistd.i"
if [ -s "$wi_tmpdir/unistd.i" ] ; then
	"$PERL" "$wi_tmpdir/prpp.pl" < "$wi_tmpdir/unistd.i" > "$wi_tmpdir/protos.h"
fi
if [ -f "$wi_tmpdir/protos.h" ] ; then
	#
	# Check the return type of write()
	#
	x="write"
	wi_cv_write_return_t=`sed -n 's/extern//;s/static//;
		s/__attribute__((__cdecl__))//;
		/[\ \*]'"$x"'\ *(/{
			s/'"$x"'\ *(.*//
			s/^\ *//
			s/\ *$//
			p;q
		}' "$wi_tmpdir/protos.h"`
	#
	# Check what type write() expects for the size parameter
	#
	x="write"
	wi_cv_write_size_t=`/bin/sh "$wi_tmpdir/sed.sh" "$x" < "$wi_tmpdir/protos.h"`
	#
	# Check the return type of send()
	#
	x="send"
	wi_cv_send_return_t=`sed -n 's/extern//;s/static//;
		s/__attribute__((__cdecl__))//;
		/[\ \*]'"$x"'\ *(/{
			s/'"$x"'\ *(.*//
			s/^\ *//
			s/\ *$//
			p;q
		}' "$wi_tmpdir/protos.h"`
	#
	# Check what type send() expects for the size parameter
	# Tru64 is one example where send() differs from write()  :-(
	#
	x="send"
	wi_cv_send_size_t=`/bin/sh "$wi_tmpdir/sed.sh" "$x" < "$wi_tmpdir/protos.h"`
	#
	# Check what type connect() expects for the size parameter
	#
	x="connect"
	wi_cv_sockaddr_size_t=`/bin/sh "$wi_tmpdir/sed.sh" "$x" < "$wi_tmpdir/protos.h"`
	#
	# Check what type setsockopt() expects for the size parameter
	#
	x="setsockopt"
	wi_cv_sockopt_size_t=`/bin/sh "$wi_tmpdir/sed.sh" "$x" < "$wi_tmpdir/protos.h"`
	#
	# Check what type listen() expects for the backlog parameter
	#
	x="listen"
	wi_cv_listen_backlog_t=`/bin/sh "$wi_tmpdir/sed.sh" "$x" < "$wi_tmpdir/protos.h"`
	#
	# Check what type alarm() expects for the seconds parameter
	#
	x="alarm"
	wi_cv_alarm_time_t=`/bin/sh "$wi_tmpdir/sed.sh" "$x" < "$wi_tmpdir/protos.h"`
	#
	# Check what type gethostbyaddr() expects for the addr parameter
	#
	x="gethostbyaddr"
	wi_cv_gethost_addrptr_t=`/bin/sh "$wi_tmpdir/sed2.sh" "$x" < "$wi_tmpdir/protos.h"`
	#
	# Check what type gethostname() expects for the size parameter
	#
	x="gethostname"
	wi_cv_gethostname_size_t=`/bin/sh "$wi_tmpdir/sed.sh" "$x" < "$wi_tmpdir/protos.h"`
fi
if [ "x$wi_cv_write_return_t" = "x" ] ; then
	wi_cv_write_return_t="int"
fi
if [ "x$wi_cv_write_size_t" = "x" ] ; then
	wi_cv_write_size_t="int"
fi
if [ "x$wi_cv_send_return_t" = "x" ] ; then
	wi_cv_send_return_t="int"
fi
if [ "x$wi_cv_send_size_t" = "x" ] ; then
	wi_cv_send_size_t="int"
fi
if [ "x$wi_cv_sockaddr_size_t" = "x" ] ; then
	wi_cv_sockaddr_size_t="int"
fi
if [ "x$wi_cv_sockopt_size_t" = "x" ] ; then
	wi_cv_sockopt_size_t="int"
fi
if [ "x$wi_cv_listen_backlog_t" = "x" ] ; then
	wi_cv_listen_backlog_t="int"
fi
if [ "x$wi_cv_alarm_time_t" = "x" ] ; then
	wi_cv_alarm_time_t="int"
fi
if [ "x$wi_cv_gethost_addrptr_t" = "x" ] ; then
	wi_cv_gethost_addrptr_t="struct in_addr *"
fi
if [ "$wi_cv_gethost_addrptr_t" = "const void" ] ; then
	wi_cv_gethost_addrptr_t="const struct in_addr *"
fi
if [ "x$wi_cv_gethostname_size_t" = "x" ] ; then
	wi_cv_gethostname_size_t="int"
fi

# Done using the temporary directory here.

rm -r "$wi_tmpdir"
unset wi_tmpdir


fi

echo "$ac_t""$wi_cv_write_return_t" 1>&6
if test "x$used_cache_for_wi_unistd_fpt" = "xno" ; then
	echo $ac_n "checking for size parameter to write""... $ac_c" 1>&6
echo "configure:7998: checking for size parameter to write" >&5
	echo "$ac_t""$wi_cv_write_size_t" 1>&6
	echo $ac_n "checking for return type from send""... $ac_c" 1>&6
echo "configure:8001: checking for return type from send" >&5
	echo "$ac_t""$wi_cv_send_return_t" 1>&6
	echo $ac_n "checking for size parameter to send""... $ac_c" 1>&6
echo "configure:8004: checking for size parameter to send" >&5
	echo "$ac_t""$wi_cv_send_size_t" 1>&6
	echo $ac_n "checking for size parameter to connect""... $ac_c" 1>&6
echo "configure:8007: checking for size parameter to connect" >&5
	echo "$ac_t""$wi_cv_sockaddr_size_t" 1>&6
	echo $ac_n "checking for size parameter to setsockopt""... $ac_c" 1>&6
echo "configure:8010: checking for size parameter to setsockopt" >&5
	echo "$ac_t""$wi_cv_sockopt_size_t" 1>&6
	echo $ac_n "checking for backlog parameter to listen""... $ac_c" 1>&6
echo "configure:8013: checking for backlog parameter to listen" >&5
	echo "$ac_t""$wi_cv_listen_backlog_t" 1>&6
	echo $ac_n "checking for seconds parameter to alarm""... $ac_c" 1>&6
echo "configure:8016: checking for seconds parameter to alarm" >&5
	echo "$ac_t""$wi_cv_alarm_time_t" 1>&6
	echo $ac_n "checking for address parameter to gethostbyaddr""... $ac_c" 1>&6
echo "configure:8019: checking for address parameter to gethostbyaddr" >&5
	echo "$ac_t""$wi_cv_gethost_addrptr_t" 1>&6
	echo $ac_n "checking for size parameter to gethostname""... $ac_c" 1>&6
echo "configure:8022: checking for size parameter to gethostname" >&5
	echo "$ac_t""$wi_cv_gethostname_size_t" 1>&6
else
	echo $ac_n "checking for size parameter to write""... $ac_c" 1>&6
echo "configure:8026: checking for size parameter to write" >&5
if eval "test \"`echo '$''{'wi_cv_write_size_t'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  :
fi

echo "$ac_t""$wi_cv_write_size_t" 1>&6
	echo $ac_n "checking for return type from send""... $ac_c" 1>&6
echo "configure:8035: checking for return type from send" >&5
if eval "test \"`echo '$''{'wi_cv_send_return_t'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  :
fi

echo "$ac_t""$wi_cv_send_return_t" 1>&6
	echo $ac_n "checking for size parameter to send""... $ac_c" 1>&6
echo "configure:8044: checking for size parameter to send" >&5
if eval "test \"`echo '$''{'wi_cv_send_size_t'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  :
fi

echo "$ac_t""$wi_cv_send_size_t" 1>&6
	echo $ac_n "checking for size parameter to connect""... $ac_c" 1>&6
echo "configure:8053: checking for size parameter to connect" >&5
if eval "test \"`echo '$''{'wi_cv_sockaddr_size_t'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  :
fi

echo "$ac_t""$wi_cv_sockaddr_size_t" 1>&6
	echo $ac_n "checking for size parameter to setsockopt""... $ac_c" 1>&6
echo "configure:8062: checking for size parameter to setsockopt" >&5
if eval "test \"`echo '$''{'wi_cv_sockopt_size_t'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  :
fi

echo "$ac_t""$wi_cv_sockopt_size_t" 1>&6
	echo $ac_n "checking for backlog parameter to listen""... $ac_c" 1>&6
echo "configure:8071: checking for backlog parameter to listen" >&5
if eval "test \"`echo '$''{'wi_cv_listen_backlog_t'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  :
fi

echo "$ac_t""$wi_cv_listen_backlog_t" 1>&6
	echo $ac_n "checking for seconds parameter to alarm""... $ac_c" 1>&6
echo "configure:8080: checking for seconds parameter to alarm" >&5
if eval "test \"`echo '$''{'wi_cv_alarm_time_t'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  :
fi

echo "$ac_t""$wi_cv_alarm_time_t" 1>&6
	echo $ac_n "checking for address parameter to gethostbyaddr""... $ac_c" 1>&6
echo "configure:8089: checking for address parameter to gethostbyaddr" >&5
if eval "test \"`echo '$''{'wi_cv_gethost_addrptr_t'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  :
fi

echo "$ac_t""$wi_cv_gethost_addrptr_t" 1>&6
	echo $ac_n "checking for size parameter to gethostname""... $ac_c" 1>&6
echo "configure:8098: checking for size parameter to gethostname" >&5
if eval "test \"`echo '$''{'wi_cv_gethostname_size_t'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  :
fi

echo "$ac_t""$wi_cv_gethostname_size_t" 1>&6
fi
unset used_cache_for_wi_unistd_fpt
cat >> confdefs.h <<EOF
#define write_return_t $wi_cv_write_return_t
EOF

cat >> confdefs.h <<EOF
#define write_size_t $wi_cv_write_size_t
EOF

cat >> confdefs.h <<EOF
#define read_return_t $wi_cv_write_return_t
EOF

cat >> confdefs.h <<EOF
#define read_size_t $wi_cv_write_size_t
EOF

cat >> confdefs.h <<EOF
#define send_return_t $wi_cv_send_return_t
EOF

cat >> confdefs.h <<EOF
#define send_size_t $wi_cv_send_size_t
EOF

cat >> confdefs.h <<EOF
#define recv_return_t $wi_cv_send_return_t
EOF

cat >> confdefs.h <<EOF
#define recv_size_t $wi_cv_send_size_t
EOF

cat >> confdefs.h <<EOF
#define sockaddr_size_t $wi_cv_sockaddr_size_t
EOF

cat >> confdefs.h <<EOF
#define sockopt_size_t $wi_cv_sockopt_size_t
EOF

cat >> confdefs.h <<EOF
#define listen_backlog_t $wi_cv_listen_backlog_t
EOF

cat >> confdefs.h <<EOF
#define alarm_time_t $wi_cv_alarm_time_t
EOF

cat >> confdefs.h <<EOF
#define gethost_addrptr_t $wi_cv_gethost_addrptr_t
EOF

cat >> confdefs.h <<EOF
#define gethostname_size_t $wi_cv_gethostname_size_t
EOF


echo $ac_n "checking for negative_control_t""... $ac_c" 1>&6
echo "configure:8166: checking for negative_control_t" >&5
if eval "test \"`echo '$''{'ac_cv_type_negative_control_t'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 8171 "configure"
#include "confdefs.h"

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#if STDC_HEADERS
#include <stdlib.h>
#include <stddef.h>
#endif

EOF
if (eval "$ac_cpp conftest.$ac_ext") 2>&5 |
  egrep "(^|[^a-zA-Z_0-9])negative_control_t[^a-zA-Z_0-9]" >/dev/null 2>&1; then
  rm -rf conftest*
  ac_cv_type_negative_control_t=yes
else
  rm -rf conftest*
  ac_cv_type_negative_control_t=no
fi
rm -rf conftest*

fi
echo "$ac_t""$ac_cv_type_negative_control_t" 1>&6
if test $ac_cv_type_negative_control_t = no; then
  cat >> confdefs.h <<\EOF
#define negative_control_t long
EOF

fi

echo $ac_n "checking for ssize_t""... $ac_c" 1>&6
echo "configure:8204: checking for ssize_t" >&5
if eval "test \"`echo '$''{'ac_cv_type_ssize_t'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 8209 "configure"
#include "confdefs.h"

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#if STDC_HEADERS
#include <stdlib.h>
#include <stddef.h>
#endif

EOF
if (eval "$ac_cpp conftest.$ac_ext") 2>&5 |
  egrep "(^|[^a-zA-Z_0-9])ssize_t[^a-zA-Z_0-9]" >/dev/null 2>&1; then
  rm -rf conftest*
  ac_cv_type_ssize_t=yes
else
  rm -rf conftest*
  ac_cv_type_ssize_t=no
fi
rm -rf conftest*

fi
echo "$ac_t""$ac_cv_type_ssize_t" 1>&6
if test $ac_cv_type_ssize_t = no; then
  cat >> confdefs.h <<\EOF
#define ssize_t long
EOF

fi

echo $ac_n "checking for sa_family_t""... $ac_c" 1>&6
echo "configure:8242: checking for sa_family_t" >&5
if eval "test \"`echo '$''{'ac_cv_type_sa_family_t'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 8247 "configure"
#include "confdefs.h"

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#if STDC_HEADERS
#include <stdlib.h>
#include <stddef.h>
#endif
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

EOF
if (eval "$ac_cpp conftest.$ac_ext") 2>&5 |
  egrep "(^|[^a-zA-Z_0-9])sa_family_t[^a-zA-Z_0-9]" >/dev/null 2>&1; then
  rm -rf conftest*
  ac_cv_type_sa_family_t=yes
else
  rm -rf conftest*
  ac_cv_type_sa_family_t=no
fi
rm -rf conftest*

fi
echo "$ac_t""$ac_cv_type_sa_family_t" 1>&6
if test $ac_cv_type_sa_family_t = no; then
  cat >> confdefs.h <<\EOF
#define sa_family_t unsigned short
EOF

fi



	if test "x$ac_cv_header_unistd_h" = x ; then
		{ echo "configure: error: Script needs to check for <unistd.h> before calling wi_FUNC_SELECT_ARGTYPES." 1>&2; exit 1; }
	fi

echo $ac_n "checking types of arguments for select()""... $ac_c" 1>&6
echo "configure:8290: checking types of arguments for select()" >&5
 if eval "test \"`echo '$''{'ac_cv_func_select_arg234'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
   if eval "test \"`echo '$''{'ac_cv_func_select_arg1'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
    if eval "test \"`echo '$''{'ac_cv_func_select_arg5'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
     for ac_cv_func_select_arg234 in 'fd_set *' 'int *' 'void *'; do
     for ac_cv_func_select_arg1 in 'int' 'size_t' 'unsigned long' 'unsigned'; do
      for ac_cv_func_select_arg5 in 'struct timeval *' 'const struct timeval *'; do
       cat > conftest.$ac_ext <<EOF
#line 8304 "configure"
#include "confdefs.h"
#if defined(AIX) || defined(_AIX) || defined(__HOS_AIX__)	/* MG */
#	define _ALL_SOURCE 1	/* MG */
#endif
#ifdef HAVE_UNISTD_H	/* MG */
#include <unistd.h>
#endif			/* MG */
#include <sys/types.h>	/* MG: always incl */
#include <sys/time.h>	/* MG: always incl */
#ifdef HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif
#include <sys/socket.h>	/* MG: always incl */
extern select ($ac_cv_func_select_arg1,$ac_cv_func_select_arg234,$ac_cv_func_select_arg234,$ac_cv_func_select_arg234,$ac_cv_func_select_arg5);
int main() {

; return 0; }
EOF
if { (eval echo configure:8323: \"$ac_compile\") 1>&5; (eval $ac_compile) 2>&5; }; then
  rm -rf conftest*
          ac_not_found=no ; break 3
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  ac_not_found=yes
fi
rm -rf conftest*
      done
     done
    done
   
fi
  
fi
 
fi
 if test "$ac_not_found" = yes; then
  ac_cv_func_select_arg1=int 
  ac_cv_func_select_arg234='int *' 
  ac_cv_func_select_arg5='struct timeval *'
 fi
 echo "$ac_t""$ac_cv_func_select_arg1,$ac_cv_func_select_arg234,$ac_cv_func_select_arg5" 1>&6
 cat >> confdefs.h <<EOF
#define SELECT_TYPE_ARG1 $ac_cv_func_select_arg1
EOF

 cat >> confdefs.h <<EOF
#define SELECT_TYPE_ARG234 ($ac_cv_func_select_arg234)
EOF

 cat >> confdefs.h <<EOF
#define SELECT_TYPE_ARG5 ($ac_cv_func_select_arg5)
EOF



if test "$wi_cv_lfs64" != "yes" ; then
	echo $ac_n "checking for struct stat64""... $ac_c" 1>&6
echo "configure:8364: checking for struct stat64" >&5
	echo "$ac_t""not needed" 1>&6
	wi_cv_struct_stat64=no
else
echo $ac_n "checking for struct stat64""... $ac_c" 1>&6
echo "configure:8369: checking for struct stat64" >&5
cat > conftest.$ac_ext <<EOF
#line 8371 "configure"
#include "confdefs.h"

	/* includes */
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

int main() {

struct stat64 st;

st.st_size = 0;
exit(((int) &st.st_size) & 0xff);	/* bogus code, of course. */

; return 0; }
EOF
if { (eval echo configure:8388: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  
	wi_cv_struct_stat64=yes
	cat >> confdefs.h <<\EOF
#define HAVE_STRUCT_STAT64 1
EOF


else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  
	wi_cv_struct_stat64=no

fi
rm -rf conftest*
echo "$ac_t""$wi_cv_struct_stat64" 1>&6
fi



	if test "x$ac_cv_header_unistd_h" = x ; then
		{ echo "configure: error: Script needs to check for <unistd.h> before calling wi_TYPE_SIG_ATOMIC_T." 1>&2; exit 1; }
	fi

echo $ac_n "checking for sig_atomic_t""... $ac_c" 1>&6
echo "configure:8416: checking for sig_atomic_t" >&5
cat > conftest.$ac_ext <<EOF
#line 8418 "configure"
#include "confdefs.h"

	/* includes */
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/signal.h>
#include <signal.h>	/* MG: for IRIX */
#if STDC_HEADERS
#include <stdlib.h>
#include <stddef.h>
#endif

int main() {

	/* function-body */
	sig_atomic_t sample;

	sample = (sig_atomic_t) getpid();	/* bogus code, of course */
	exit((sample > 0) ? 0 : 1);

; return 0; }
EOF
if { (eval echo configure:8443: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  
	ac_cv_type_sig_atomic_t=yes

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  
	ac_cv_type_sig_atomic_t=no

fi
rm -rf conftest*
echo "$ac_t""$ac_cv_type_sig_atomic_t" 1>&6
if test $ac_cv_type_sig_atomic_t = no ; then
	cat >> confdefs.h <<\EOF
#define sig_atomic_t int
EOF

fi


echo $ac_n "checking how to access getopt() global variables""... $ac_c" 1>&6
echo "configure:8467: checking how to access getopt() global variables" >&5
if eval "test \"`echo '$''{'wi_cv_getopt_decl'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  

	if test "x$ac_cv_header_unistd_h" = x ; then
		{ echo "configure: error: Script needs to check for <unistd.h> before calling wi_GETOPT." 1>&2; exit 1; }
	fi

cat > conftest.$ac_ext <<EOF
#line 8478 "configure"
#include "confdefs.h"

/* includes */
#if defined(AIX) || defined(_AIX) || defined(__HOS_AIX__)
#	define _ALL_SOURCE 1
#endif
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <stdio.h>
#include <stdlib.h>

int main() {

	optind = (optarg == 0) ? 66 : 99;

; return 0; }
EOF
if { (eval echo configure:8497: \"$ac_compile\") 1>&5; (eval $ac_compile) 2>&5; }; then
  rm -rf conftest*
  wi_cv_getopt_decl="automatic"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  wi_cv_getopt_decl="unknown"
fi
rm -rf conftest*



if test "$wi_cv_getopt_decl" = unknown ; then
cat > conftest.$ac_ext <<EOF
#line 8512 "configure"
#include "confdefs.h"

/* includes */
#if defined(AIX) || defined(_AIX) || defined(__HOS_AIX__)
#	define _ALL_SOURCE 1
#endif
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <getopt.h>

int main() {

	optind = (optarg == 0) ? 66 : 99;

; return 0; }
EOF
if { (eval echo configure:8532: \"$ac_compile\") 1>&5; (eval $ac_compile) 2>&5; }; then
  rm -rf conftest*
  
#
# Looks like <getopt.h> declares the variables as extern.
#
wi_cv_getopt_decl="getopt.h"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  
#
# You'll need to declare them yourself.
#
wi_cv_getopt_decl="manual"

fi
rm -rf conftest*
fi

fi

echo "$ac_t""$wi_cv_getopt_decl" 1>&6
if test "$wi_cv_getopt_decl" = "getopt.h" ; then
	cat >> confdefs.h <<\EOF
#define NEED_GETOPT_H 1
EOF

elif test "$wi_cv_getopt_decl" = "manual" ; then
	cat >> confdefs.h <<\EOF
#define NEED_GETOPT_EXTERN_DECLS 1
EOF

fi


echo $ac_n "checking for useable _res global variable""... $ac_c" 1>&6
echo "configure:8570: checking for useable _res global variable" >&5
cat > conftest.$ac_ext <<EOF
#line 8572 "configure"
#include "confdefs.h"

	/* includes */
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#ifdef HAVE_ARPA_NAMESER_H
#	include <arpa/nameser.h>
#endif
#ifdef HAVE_RESOLV_H
#	include <resolv.h>
#endif

int main() {

	/* function-body */
	int len;

	res_init();
	len = (int) strlen(_res.defdname);

; return 0; }
EOF
if { (eval echo configure:8599: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  
	wi_cv__res_defdname=yes
	cat >> confdefs.h <<\EOF
#define HAVE__RES_DEFDNAME 1
EOF


else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  
	wi_cv__res_defdname=no

fi
rm -rf conftest*
echo "$ac_t""$wi_cv__res_defdname" 1>&6
	
echo $ac_n "checking for struct cmsghdr""... $ac_c" 1>&6
echo "configure:8620: checking for struct cmsghdr" >&5
if eval "test \"`echo '$''{'wi_cv_struct_cmsghdr'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  
cat > conftest.$ac_ext <<EOF
#line 8626 "configure"
#include "confdefs.h"

	/* includes */
#include <unistd.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <sys/socket.h>
#include <sys/un.h>

int main() {

struct cmsghdr cm;

cm.cmsg_len = 0;
cm.cmsg_level = 0;
cm.cmsg_type = 0;
exit(((int) &cm.cmsg_type) & 0xff);	/* bogus code, of course. */

; return 0; }
EOF
if { (eval echo configure:8647: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  
	wi_cv_struct_cmsghdr=yes

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  
	wi_cv_struct_cmsghdr=no

fi
rm -rf conftest*

fi

echo "$ac_t""$wi_cv_struct_cmsghdr" 1>&6
if test "$wi_cv_struct_cmsghdr" = yes ; then
	cat >> confdefs.h <<\EOF
#define HAVE_STRUCT_CMSGDHR 1
EOF

fi
	
echo $ac_n "checking for msg_control field in struct msghdr""... $ac_c" 1>&6
echo "configure:8673: checking for msg_control field in struct msghdr" >&5
if eval "test \"`echo '$''{'wi_cv_msghdr_control'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  
cat > conftest.$ac_ext <<EOF
#line 8679 "configure"
#include "confdefs.h"

	/* includes */
#include <unistd.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <sys/socket.h>
#include <sys/un.h>

int main() {

struct msghdr m;

m.msg_control = &m;
m.msg_controllen = sizeof(m);
exit(((int) &m.msg_control) & 0xff);	/* bogus code, of course. */

; return 0; }
EOF
if { (eval echo configure:8699: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  
	wi_cv_msghdr_control=yes

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  
	wi_cv_msghdr_control=no

fi
rm -rf conftest*

fi

echo "$ac_t""$wi_cv_msghdr_control" 1>&6
if test "$wi_cv_msghdr_control" = yes ; then
	cat >> confdefs.h <<\EOF
#define HAVE_MSGHDR_CONTROL 1
EOF

fi
	
echo $ac_n "checking for msg_accrights field in struct msghdr""... $ac_c" 1>&6
echo "configure:8725: checking for msg_accrights field in struct msghdr" >&5
if eval "test \"`echo '$''{'wi_cv_msghdr_accrights'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  
cat > conftest.$ac_ext <<EOF
#line 8731 "configure"
#include "confdefs.h"

	/* includes */
#include <unistd.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <sys/socket.h>
#include <sys/un.h>

int main() {

struct msghdr m;

m.msg_accrights = &m;
m.msg_accrightslen = sizeof(m);
exit(((int) &m.msg_accrights) & 0xff);	/* bogus code, of course. */

; return 0; }
EOF
if { (eval echo configure:8751: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  
	wi_cv_msghdr_accrights=yes

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  
	wi_cv_msghdr_accrights=no

fi
rm -rf conftest*

fi

echo "$ac_t""$wi_cv_msghdr_accrights" 1>&6
if test "$wi_cv_msghdr_accrights" = yes ; then
	cat >> confdefs.h <<\EOF
#define HAVE_MSGHDR_ACCRIGHTS 1
EOF

fi
	

	if test "x$ac_cv_header_unistd_h" = x ; then
		{ echo "configure: error: Script needs to check for <unistd.h> before calling wi_HEADER_SYS_SELECT_H." 1>&2; exit 1; }
	fi

# See if <sys/select.h> is includable after <sys/time.h>
if test "$ac_cv_header_sys_time_h" = no ; then
	wi_chk_headers="sys/time.h sys/select.h"
else
	wi_chk_headers="sys/time.h"
fi
for ac_hdr in $wi_chk_headers
do
ac_safe=`echo "$ac_hdr" | sed 'y%./+-%__p_%'`
echo $ac_n "checking for $ac_hdr""... $ac_c" 1>&6
echo "configure:8791: checking for $ac_hdr" >&5
if eval "test \"`echo '$''{'ac_cv_header_$ac_safe'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 8796 "configure"
#include "confdefs.h"
#include <$ac_hdr>
EOF
ac_try="$ac_cpp conftest.$ac_ext >/dev/null 2>conftest.out"
{ (eval echo configure:8801: \"$ac_try\") 1>&5; (eval $ac_try) 2>&5; }
ac_err=`grep -v '^ *+' conftest.out | grep -v "^conftest.${ac_ext}\$"`
if test -z "$ac_err"; then
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=yes"
else
  echo "$ac_err" >&5
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=no"
fi
rm -rf conftest*
fi
if eval "test \"`echo '$ac_cv_header_'$ac_safe`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_hdr=HAVE_`echo $ac_hdr | sed 'y%abcdefghijklmnopqrstuvwxyz./-%ABCDEFGHIJKLMNOPQRSTUVWXYZ___%'`
  cat >> confdefs.h <<EOF
#define $ac_tr_hdr 1
EOF
 
else
  echo "$ac_t""no" 1>&6
fi
done

if test "$ac_cv_header_sys_select_h" = yes ; then
	echo $ac_n "checking if <sys/select.h> is compatible with <sys/time.h>""... $ac_c" 1>&6
echo "configure:8829: checking if <sys/select.h> is compatible with <sys/time.h>" >&5
	selecth=yes
	if test "$ac_cv_header_sys_time_h" = yes ; then
		cat > conftest.$ac_ext <<EOF
#line 8833 "configure"
#include "confdefs.h"

#if defined(AIX) || defined(_AIX) || defined(__HOS_AIX__)
#	define _ALL_SOURCE 1
#endif
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/time.h>
#include <sys/select.h>
int main() {

		fd_set a;
		struct timeval tmval;

		tmval.tv_sec = 0;
; return 0; }
EOF
if { (eval echo configure:8853: \"$ac_compile\") 1>&5; (eval $ac_compile) 2>&5; }; then
  rm -rf conftest*
  selecth=yes
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  selecth=no
fi
rm -rf conftest*
	fi
	if test "$selecth" = yes ; then
		cat >> confdefs.h <<\EOF
#define CAN_USE_SYS_SELECT_H 1
EOF

	fi
	echo "$ac_t""$selecth" 1>&6
fi
	



if test "${SYS}" = sunos ; then
	# Use getwd on SunOS -- getcwd does a "popen("/bin/pwd")" -- aaaccck.
	#
	for ac_func in getwd
do
echo $ac_n "checking for $ac_func""... $ac_c" 1>&6
echo "configure:8882: checking for $ac_func" >&5
if eval "test \"`echo '$''{'ac_cv_func_$ac_func'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 8887 "configure"
#include "confdefs.h"
/* System header to define __stub macros and hopefully few prototypes,
    which can conflict with char $ac_func(); below.  */
#include <assert.h>
/* Override any gcc2 internal prototype to avoid an error.  */
/* We use char because int might match the return type of a gcc2
    builtin and then its argument prototype would still apply.  */
char $ac_func();

int main() {

/* The GNU C library defines this for functions which it implements
    to always fail with ENOSYS.  Some functions are actually named
    something starting with __ and the normal name is an alias.  */
#if defined (__stub_$ac_func) || defined (__stub___$ac_func)
choke me
#else
$ac_func();
#endif

; return 0; }
EOF
if { (eval echo configure:8910: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  eval "ac_cv_func_$ac_func=yes"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_func_$ac_func=no"
fi
rm -rf conftest*
fi

if eval "test \"`echo '$ac_cv_func_'$ac_func`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_func=HAVE_`echo $ac_func | tr 'abcdefghijklmnopqrstuvwxyz' 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'`
  cat >> confdefs.h <<EOF
#define $ac_tr_func 1
EOF
 
else
  echo "$ac_t""no" 1>&6
fi
done

else
	for ac_func in getcwd getwd
do
echo $ac_n "checking for $ac_func""... $ac_c" 1>&6
echo "configure:8938: checking for $ac_func" >&5
if eval "test \"`echo '$''{'ac_cv_func_$ac_func'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 8943 "configure"
#include "confdefs.h"
/* System header to define __stub macros and hopefully few prototypes,
    which can conflict with char $ac_func(); below.  */
#include <assert.h>
/* Override any gcc2 internal prototype to avoid an error.  */
/* We use char because int might match the return type of a gcc2
    builtin and then its argument prototype would still apply.  */
char $ac_func();

int main() {

/* The GNU C library defines this for functions which it implements
    to always fail with ENOSYS.  Some functions are actually named
    something starting with __ and the normal name is an alias.  */
#if defined (__stub_$ac_func) || defined (__stub___$ac_func)
choke me
#else
$ac_func();
#endif

; return 0; }
EOF
if { (eval echo configure:8966: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  eval "ac_cv_func_$ac_func=yes"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_func_$ac_func=no"
fi
rm -rf conftest*
fi

if eval "test \"`echo '$ac_cv_func_'$ac_func`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_func=HAVE_`echo $ac_func | tr 'abcdefghijklmnopqrstuvwxyz' 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'`
  cat >> confdefs.h <<EOF
#define $ac_tr_func 1
EOF
 
else
  echo "$ac_t""no" 1>&6
fi
done

fi
if test "$ac_cv_func_getcwd" = no && test "$ac_cv_func_getwd" = no ; then
echo "configure: warning: This system does not have either getwd or getcwd?" 1>&2
echo "configure: warning: I find that a little hard to believe." 1>&2
echo "configure: warning: You may want to try -DHAVE_GETWD anyway." 1>&2
echo "configure: warning: 
This could also mean that your compiler isn't working" 1>&2
echo "configure: warning: with this configure script.  Check the ./config.log" 1>&2
echo "configure: warning: and look for anomalies." 1>&2
fi

for ac_func in fstat64 getdomainname gethostname getpass getpassphrase gnu_get_libc_release gnu_get_libc_version inet_aton inet_ntop llseek lseek64 lstat64 memmove mktime open64 pathconf readlink recvfile res_init sendfile setlocale setpgid setpgrp setsid setvbuf sigaction sigsetjmp stat64 strcasecmp strcoll strdup strerror strncoll strstr strtoq symlink sysconf sysctl sysinfo syslog tcgetattr uname waitpid
do
echo $ac_n "checking for $ac_func""... $ac_c" 1>&6
echo "configure:9004: checking for $ac_func" >&5
if eval "test \"`echo '$''{'ac_cv_func_$ac_func'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 9009 "configure"
#include "confdefs.h"
/* System header to define __stub macros and hopefully few prototypes,
    which can conflict with char $ac_func(); below.  */
#include <assert.h>
/* Override any gcc2 internal prototype to avoid an error.  */
/* We use char because int might match the return type of a gcc2
    builtin and then its argument prototype would still apply.  */
char $ac_func();

int main() {

/* The GNU C library defines this for functions which it implements
    to always fail with ENOSYS.  Some functions are actually named
    something starting with __ and the normal name is an alias.  */
#if defined (__stub_$ac_func) || defined (__stub___$ac_func)
choke me
#else
$ac_func();
#endif

; return 0; }
EOF
if { (eval echo configure:9032: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  eval "ac_cv_func_$ac_func=yes"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_func_$ac_func=no"
fi
rm -rf conftest*
fi

if eval "test \"`echo '$ac_cv_func_'$ac_func`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_func=HAVE_`echo $ac_func | tr 'abcdefghijklmnopqrstuvwxyz' 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'`
  cat >> confdefs.h <<EOF
#define $ac_tr_func 1
EOF
 
else
  echo "$ac_t""no" 1>&6
fi
done

for ac_func in gethostbyaddr_r gethostbyname_r gethostbyname2_r getlogin_r getpwnam_r _posix_getpwnam_r getpwuid_r _posix_getpwuid_r getservbyname_r getservbyport_r gmtime_r localtime_r readdir_r
do
echo $ac_n "checking for $ac_func""... $ac_c" 1>&6
echo "configure:9059: checking for $ac_func" >&5
if eval "test \"`echo '$''{'ac_cv_func_$ac_func'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 9064 "configure"
#include "confdefs.h"
/* System header to define __stub macros and hopefully few prototypes,
    which can conflict with char $ac_func(); below.  */
#include <assert.h>
/* Override any gcc2 internal prototype to avoid an error.  */
/* We use char because int might match the return type of a gcc2
    builtin and then its argument prototype would still apply.  */
char $ac_func();

int main() {

/* The GNU C library defines this for functions which it implements
    to always fail with ENOSYS.  Some functions are actually named
    something starting with __ and the normal name is an alias.  */
#if defined (__stub_$ac_func) || defined (__stub___$ac_func)
choke me
#else
$ac_func();
#endif

; return 0; }
EOF
if { (eval echo configure:9087: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  eval "ac_cv_func_$ac_func=yes"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_func_$ac_func=no"
fi
rm -rf conftest*
fi

if eval "test \"`echo '$ac_cv_func_'$ac_func`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_func=HAVE_`echo $ac_func | tr 'abcdefghijklmnopqrstuvwxyz' 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'`
  cat >> confdefs.h <<EOF
#define $ac_tr_func 1
EOF
 
else
  echo "$ac_t""no" 1>&6
fi
done


unset ac_cv_func_snprintf
unset ac_cv_func_vsnprintf

for ac_func in snprintf vsnprintf
do
echo $ac_n "checking for $ac_func""... $ac_c" 1>&6
echo "configure:9118: checking for $ac_func" >&5
if eval "test \"`echo '$''{'ac_cv_func_$ac_func'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 9123 "configure"
#include "confdefs.h"
/* System header to define __stub macros and hopefully few prototypes,
    which can conflict with char $ac_func(); below.  */
#include <assert.h>
/* Override any gcc2 internal prototype to avoid an error.  */
/* We use char because int might match the return type of a gcc2
    builtin and then its argument prototype would still apply.  */
char $ac_func();

int main() {

/* The GNU C library defines this for functions which it implements
    to always fail with ENOSYS.  Some functions are actually named
    something starting with __ and the normal name is an alias.  */
#if defined (__stub_$ac_func) || defined (__stub___$ac_func)
choke me
#else
$ac_func();
#endif

; return 0; }
EOF
if { (eval echo configure:9146: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  eval "ac_cv_func_$ac_func=yes"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_func_$ac_func=no"
fi
rm -rf conftest*
fi

if eval "test \"`echo '$ac_cv_func_'$ac_func`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_func=HAVE_`echo $ac_func | tr 'abcdefghijklmnopqrstuvwxyz' 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'`
  cat >> confdefs.h <<EOF
#define $ac_tr_func 1
EOF
 
else
  echo "$ac_t""no" 1>&6
fi
done

if test "$ac_cv_func_snprintf" = yes ; then
	
if test "$ac_cv_func_snprintf" != "no" ; then
echo $ac_n "checking if snprintf works correctly""... $ac_c" 1>&6
echo "configure:9174: checking if snprintf works correctly" >&5

	if test "x$ac_cv_header_unistd_h" = x ; then
		{ echo "configure: error: Script needs to check for <unistd.h> before calling wi_SNPRINTF_TERMINATES." 1>&2; exit 1; }
	fi

if test "$cross_compiling" = yes; then
  
	# action if cross compiling
	wi_cv_snprintf_terminates=yes
	cat >> confdefs.h <<\EOF
#define SNPRINTF_TERMINATES 1
EOF

	guess="(guessing) "
	x="yes"

else
  cat > conftest.$ac_ext <<EOF
#line 9193 "configure"
#include "confdefs.h"

	/* program */
#if defined(AIX) || defined(_AIX) || defined(__HOS_AIX__)
#	define _ALL_SOURCE 1
#endif
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <stdio.h>
#include <string.h>
#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif
#include <stdlib.h>
#ifdef HAVE_SNPRINTF_H
#	include <snprintf.h>
#endif
 
main()
{
	char s[16];
	int i, result;

	for (i=0; i<(int)(sizeof(s)/sizeof(char)); i++)
		s[i] = 'x';
	result = (int) snprintf(s + 1, 10, "%s %s!", "hello", "world");
	if (s[10] != '\0')
		exit(1);	/* did not force termination! */
	if (s[11] != 'x')
		exit(2);	/* overflow! */
	if (s[0] != 'x')
		exit(3);	/* underflow! */
	exit(0);
}

EOF
if { (eval echo configure:9231: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext} && (./conftest; exit) 2>/dev/null
then
  
	# action if true
	wi_cv_snprintf_terminates=yes
	cat >> confdefs.h <<\EOF
#define SNPRINTF_TERMINATES 1
EOF

	guess=""
	x="yes"

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -fr conftest*
  
	# action if false
  	wi_cv_snprintf_terminates=no
	guess=""
	x="no"

fi
rm -fr conftest*
fi

echo "$ac_t""$guess$x" 1>&6
fi

	
echo $ac_n "checking what snprintf() returns""... $ac_c" 1>&6
echo "configure:9262: checking what snprintf() returns" >&5
if test "$cross_compiling" = yes; then
  
	# action if cross compiling
	wi_cv_snprintf_returns_ptr=no
	guess="(guessing) "
	x="length of data written"

else
  cat > conftest.$ac_ext <<EOF
#line 9272 "configure"
#include "confdefs.h"

	/* program */
#if defined(AIX) || defined(_AIX) || defined(__HOS_AIX__)
#	define _ALL_SOURCE 1
#endif
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <stdio.h>
#include <string.h>
#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif
#include <stdlib.h>
#ifdef HAVE_SNPRINTF_H
#	include <snprintf.h>
#endif
 
main()
{
	int result;
	char s[8];

	result = (int) snprintf(s, sizeof(s) - 1, "%d", 22);
	if (result == 2)
		exit(0);
	exit(1);

}

EOF
if { (eval echo configure:9305: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext} && (./conftest; exit) 2>/dev/null
then
  
	# action if true
	wi_cv_snprintf_returns_ptr=no
	guess=""
	x="length of data written"

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -fr conftest*
  
	# action if false
  	wi_cv_snprintf_returns_ptr=yes
	cat >> confdefs.h <<\EOF
#define SNPRINTF_RETURNS_PTR 1
EOF

	guess=""
	x="pointer to data"

fi
rm -fr conftest*
fi

echo "$ac_t""$guess$x" 1>&6

	
if [ "$ac_cv_func_snprintf" = "no" ] || [ "$wi_cv_snprintf_terminates" = "no" ] || [ "$wi_cv_snprintf_returns_ptr" = "yes" ] ; then
	echo $ac_n "checking for snprintf in -lsnprintf""... $ac_c" 1>&6
echo "configure:9336: checking for snprintf in -lsnprintf" >&5
ac_lib_var=`echo snprintf'_'snprintf | sed 'y%./+-%__p_%'`
if eval "test \"`echo '$''{'ac_cv_lib_$ac_lib_var'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  ac_save_LIBS="$LIBS"
LIBS="-lsnprintf  $LIBS"
cat > conftest.$ac_ext <<EOF
#line 9344 "configure"
#include "confdefs.h"
/* Override any gcc2 internal prototype to avoid an error.  */
/* We use char because int might match the return type of a gcc2
    builtin and then its argument prototype would still apply.  */
char snprintf();

int main() {
snprintf()
; return 0; }
EOF
if { (eval echo configure:9355: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=yes"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=no"
fi
rm -rf conftest*
LIBS="$ac_save_LIBS"

fi
if eval "test \"`echo '$ac_cv_lib_'$ac_lib_var`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_lib=HAVE_LIB`echo snprintf | sed -e 's/[^a-zA-Z0-9_]/_/g' \
    -e 'y/abcdefghijklmnopqrstuvwxyz/ABCDEFGHIJKLMNOPQRSTUVWXYZ/'`
  cat >> confdefs.h <<EOF
#define $ac_tr_lib 1
EOF

  LIBS="-lsnprintf $LIBS"

else
  echo "$ac_t""no" 1>&6
fi

	if test "$ac_cv_lib_snprintf_snprintf" = yes ; then
		unset ac_cv_func_snprintf ac_cv_func_vsnprintf
		for ac_hdr in snprintf.h
do
ac_safe=`echo "$ac_hdr" | sed 'y%./+-%__p_%'`
echo $ac_n "checking for $ac_hdr""... $ac_c" 1>&6
echo "configure:9388: checking for $ac_hdr" >&5
if eval "test \"`echo '$''{'ac_cv_header_$ac_safe'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 9393 "configure"
#include "confdefs.h"
#include <$ac_hdr>
EOF
ac_try="$ac_cpp conftest.$ac_ext >/dev/null 2>conftest.out"
{ (eval echo configure:9398: \"$ac_try\") 1>&5; (eval $ac_try) 2>&5; }
ac_err=`grep -v '^ *+' conftest.out | grep -v "^conftest.${ac_ext}\$"`
if test -z "$ac_err"; then
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=yes"
else
  echo "$ac_err" >&5
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=no"
fi
rm -rf conftest*
fi
if eval "test \"`echo '$ac_cv_header_'$ac_safe`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_hdr=HAVE_`echo $ac_hdr | sed 'y%abcdefghijklmnopqrstuvwxyz./-%ABCDEFGHIJKLMNOPQRSTUVWXYZ___%'`
  cat >> confdefs.h <<EOF
#define $ac_tr_hdr 1
EOF
 
else
  echo "$ac_t""no" 1>&6
fi
done

		for ac_func in snprintf vsnprintf
do
echo $ac_n "checking for $ac_func""... $ac_c" 1>&6
echo "configure:9427: checking for $ac_func" >&5
if eval "test \"`echo '$''{'ac_cv_func_$ac_func'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 9432 "configure"
#include "confdefs.h"
/* System header to define __stub macros and hopefully few prototypes,
    which can conflict with char $ac_func(); below.  */
#include <assert.h>
/* Override any gcc2 internal prototype to avoid an error.  */
/* We use char because int might match the return type of a gcc2
    builtin and then its argument prototype would still apply.  */
char $ac_func();

int main() {

/* The GNU C library defines this for functions which it implements
    to always fail with ENOSYS.  Some functions are actually named
    something starting with __ and the normal name is an alias.  */
#if defined (__stub_$ac_func) || defined (__stub___$ac_func)
choke me
#else
$ac_func();
#endif

; return 0; }
EOF
if { (eval echo configure:9455: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  eval "ac_cv_func_$ac_func=yes"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_func_$ac_func=no"
fi
rm -rf conftest*
fi

if eval "test \"`echo '$ac_cv_func_'$ac_func`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_func=HAVE_`echo $ac_func | tr 'abcdefghijklmnopqrstuvwxyz' 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'`
  cat >> confdefs.h <<EOF
#define $ac_tr_func 1
EOF
 
else
  echo "$ac_t""no" 1>&6
fi
done

	fi
fi

else
	
if [ "$ac_cv_func_snprintf" = "no" ] || [ "$wi_cv_snprintf_terminates" = "no" ] || [ "$wi_cv_snprintf_returns_ptr" = "yes" ] ; then
	echo $ac_n "checking for snprintf in -lsnprintf""... $ac_c" 1>&6
echo "configure:9486: checking for snprintf in -lsnprintf" >&5
ac_lib_var=`echo snprintf'_'snprintf | sed 'y%./+-%__p_%'`
if eval "test \"`echo '$''{'ac_cv_lib_$ac_lib_var'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  ac_save_LIBS="$LIBS"
LIBS="-lsnprintf  $LIBS"
cat > conftest.$ac_ext <<EOF
#line 9494 "configure"
#include "confdefs.h"
/* Override any gcc2 internal prototype to avoid an error.  */
/* We use char because int might match the return type of a gcc2
    builtin and then its argument prototype would still apply.  */
char snprintf();

int main() {
snprintf()
; return 0; }
EOF
if { (eval echo configure:9505: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=yes"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_lib_$ac_lib_var=no"
fi
rm -rf conftest*
LIBS="$ac_save_LIBS"

fi
if eval "test \"`echo '$ac_cv_lib_'$ac_lib_var`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_lib=HAVE_LIB`echo snprintf | sed -e 's/[^a-zA-Z0-9_]/_/g' \
    -e 'y/abcdefghijklmnopqrstuvwxyz/ABCDEFGHIJKLMNOPQRSTUVWXYZ/'`
  cat >> confdefs.h <<EOF
#define $ac_tr_lib 1
EOF

  LIBS="-lsnprintf $LIBS"

else
  echo "$ac_t""no" 1>&6
fi

	if test "$ac_cv_lib_snprintf_snprintf" = yes ; then
		unset ac_cv_func_snprintf ac_cv_func_vsnprintf
		for ac_hdr in snprintf.h
do
ac_safe=`echo "$ac_hdr" | sed 'y%./+-%__p_%'`
echo $ac_n "checking for $ac_hdr""... $ac_c" 1>&6
echo "configure:9538: checking for $ac_hdr" >&5
if eval "test \"`echo '$''{'ac_cv_header_$ac_safe'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 9543 "configure"
#include "confdefs.h"
#include <$ac_hdr>
EOF
ac_try="$ac_cpp conftest.$ac_ext >/dev/null 2>conftest.out"
{ (eval echo configure:9548: \"$ac_try\") 1>&5; (eval $ac_try) 2>&5; }
ac_err=`grep -v '^ *+' conftest.out | grep -v "^conftest.${ac_ext}\$"`
if test -z "$ac_err"; then
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=yes"
else
  echo "$ac_err" >&5
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_header_$ac_safe=no"
fi
rm -rf conftest*
fi
if eval "test \"`echo '$ac_cv_header_'$ac_safe`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_hdr=HAVE_`echo $ac_hdr | sed 'y%abcdefghijklmnopqrstuvwxyz./-%ABCDEFGHIJKLMNOPQRSTUVWXYZ___%'`
  cat >> confdefs.h <<EOF
#define $ac_tr_hdr 1
EOF
 
else
  echo "$ac_t""no" 1>&6
fi
done

		for ac_func in snprintf vsnprintf
do
echo $ac_n "checking for $ac_func""... $ac_c" 1>&6
echo "configure:9577: checking for $ac_func" >&5
if eval "test \"`echo '$''{'ac_cv_func_$ac_func'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 9582 "configure"
#include "confdefs.h"
/* System header to define __stub macros and hopefully few prototypes,
    which can conflict with char $ac_func(); below.  */
#include <assert.h>
/* Override any gcc2 internal prototype to avoid an error.  */
/* We use char because int might match the return type of a gcc2
    builtin and then its argument prototype would still apply.  */
char $ac_func();

int main() {

/* The GNU C library defines this for functions which it implements
    to always fail with ENOSYS.  Some functions are actually named
    something starting with __ and the normal name is an alias.  */
#if defined (__stub_$ac_func) || defined (__stub___$ac_func)
choke me
#else
$ac_func();
#endif

; return 0; }
EOF
if { (eval echo configure:9605: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  eval "ac_cv_func_$ac_func=yes"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_func_$ac_func=no"
fi
rm -rf conftest*
fi

if eval "test \"`echo '$ac_cv_func_'$ac_func`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_func=HAVE_`echo $ac_func | tr 'abcdefghijklmnopqrstuvwxyz' 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'`
  cat >> confdefs.h <<EOF
#define $ac_tr_func 1
EOF
 
else
  echo "$ac_t""no" 1>&6
fi
done

	fi
fi

	
if test "$ac_cv_func_snprintf" != "no" ; then
echo $ac_n "checking if snprintf works correctly""... $ac_c" 1>&6
echo "configure:9635: checking if snprintf works correctly" >&5

	if test "x$ac_cv_header_unistd_h" = x ; then
		{ echo "configure: error: Script needs to check for <unistd.h> before calling wi_SNPRINTF_TERMINATES." 1>&2; exit 1; }
	fi

if test "$cross_compiling" = yes; then
  
	# action if cross compiling
	wi_cv_snprintf_terminates=yes
	cat >> confdefs.h <<\EOF
#define SNPRINTF_TERMINATES 1
EOF

	guess="(guessing) "
	x="yes"

else
  cat > conftest.$ac_ext <<EOF
#line 9654 "configure"
#include "confdefs.h"

	/* program */
#if defined(AIX) || defined(_AIX) || defined(__HOS_AIX__)
#	define _ALL_SOURCE 1
#endif
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <stdio.h>
#include <string.h>
#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif
#include <stdlib.h>
#ifdef HAVE_SNPRINTF_H
#	include <snprintf.h>
#endif
 
main()
{
	char s[16];
	int i, result;

	for (i=0; i<(int)(sizeof(s)/sizeof(char)); i++)
		s[i] = 'x';
	result = (int) snprintf(s + 1, 10, "%s %s!", "hello", "world");
	if (s[10] != '\0')
		exit(1);	/* did not force termination! */
	if (s[11] != 'x')
		exit(2);	/* overflow! */
	if (s[0] != 'x')
		exit(3);	/* underflow! */
	exit(0);
}

EOF
if { (eval echo configure:9692: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext} && (./conftest; exit) 2>/dev/null
then
  
	# action if true
	wi_cv_snprintf_terminates=yes
	cat >> confdefs.h <<\EOF
#define SNPRINTF_TERMINATES 1
EOF

	guess=""
	x="yes"

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -fr conftest*
  
	# action if false
  	wi_cv_snprintf_terminates=no
	guess=""
	x="no"

fi
rm -fr conftest*
fi

echo "$ac_t""$guess$x" 1>&6
fi

	
echo $ac_n "checking what snprintf() returns""... $ac_c" 1>&6
echo "configure:9723: checking what snprintf() returns" >&5
if test "$cross_compiling" = yes; then
  
	# action if cross compiling
	wi_cv_snprintf_returns_ptr=no
	guess="(guessing) "
	x="length of data written"

else
  cat > conftest.$ac_ext <<EOF
#line 9733 "configure"
#include "confdefs.h"

	/* program */
#if defined(AIX) || defined(_AIX) || defined(__HOS_AIX__)
#	define _ALL_SOURCE 1
#endif
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <stdio.h>
#include <string.h>
#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif
#include <stdlib.h>
#ifdef HAVE_SNPRINTF_H
#	include <snprintf.h>
#endif
 
main()
{
	int result;
	char s[8];

	result = (int) snprintf(s, sizeof(s) - 1, "%d", 22);
	if (result == 2)
		exit(0);
	exit(1);

}

EOF
if { (eval echo configure:9766: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext} && (./conftest; exit) 2>/dev/null
then
  
	# action if true
	wi_cv_snprintf_returns_ptr=no
	guess=""
	x="length of data written"

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -fr conftest*
  
	# action if false
  	wi_cv_snprintf_returns_ptr=yes
	cat >> confdefs.h <<\EOF
#define SNPRINTF_RETURNS_PTR 1
EOF

	guess=""
	x="pointer to data"

fi
rm -fr conftest*
fi

echo "$ac_t""$guess$x" 1>&6

fi



	if test "x$ac_cv_header_unistd_h" = x ; then
		{ echo "configure: error: Script needs to check for <unistd.h> before calling wi_FUNC_SIGSETJMP." 1>&2; exit 1; }
	fi

echo $ac_n "checking for sigsetjmp and siglongjmp""... $ac_c" 1>&6
echo "configure:9803: checking for sigsetjmp and siglongjmp" >&5
if eval "test \"`echo '$''{'wi_cv_func_sigsetjmp'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  

cat > conftest.$ac_ext <<EOF
#line 9810 "configure"
#include "confdefs.h"

	/* includes */
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <sys/types.h>
#include <stdio.h>
#include <signal.h>
#include <setjmp.h>

int main() {

	/* function-body */
	sigjmp_buf sjb;

	if (sigsetjmp(sjb, 1) != 0)
		siglongjmp(sjb, 1);	/* bogus code, of course. */
	exit(0);

; return 0; }
EOF
if { (eval echo configure:9833: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  
	wi_cv_func_sigsetjmp=yes

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  
	wi_cv_func_sigsetjmp=no

fi
rm -rf conftest*

fi

echo "$ac_t""$wi_cv_func_sigsetjmp" 1>&6
if test "$wi_cv_func_sigsetjmp" = yes ; then
	cat >> confdefs.h <<\EOF
#define HAVE_SIGSETJMP 1
EOF

fi


if test "x$ac_cv_func_setpgid" = "x" ; then
	for ac_func in setpgid setpgrp
do
echo $ac_n "checking for $ac_func""... $ac_c" 1>&6
echo "configure:9863: checking for $ac_func" >&5
if eval "test \"`echo '$''{'ac_cv_func_$ac_func'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 9868 "configure"
#include "confdefs.h"
/* System header to define __stub macros and hopefully few prototypes,
    which can conflict with char $ac_func(); below.  */
#include <assert.h>
/* Override any gcc2 internal prototype to avoid an error.  */
/* We use char because int might match the return type of a gcc2
    builtin and then its argument prototype would still apply.  */
char $ac_func();

int main() {

/* The GNU C library defines this for functions which it implements
    to always fail with ENOSYS.  Some functions are actually named
    something starting with __ and the normal name is an alias.  */
#if defined (__stub_$ac_func) || defined (__stub___$ac_func)
choke me
#else
$ac_func();
#endif

; return 0; }
EOF
if { (eval echo configure:9891: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  eval "ac_cv_func_$ac_func=yes"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_func_$ac_func=no"
fi
rm -rf conftest*
fi

if eval "test \"`echo '$ac_cv_func_'$ac_func`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_func=HAVE_`echo $ac_func | tr 'abcdefghijklmnopqrstuvwxyz' 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'`
  cat >> confdefs.h <<EOF
#define $ac_tr_func 1
EOF
 
else
  echo "$ac_t""no" 1>&6
fi
done

fi
echo $ac_n "checking if setpgrp behavior needs to be checked""... $ac_c" 1>&6
echo "configure:9917: checking if setpgrp behavior needs to be checked" >&5
if test "x$ac_cv_func_setpgid" = "xyes" ; then
	# OK, we will be using setpgid instead of setpgrp then...
	echo "$ac_t""no" 1>&6
	ac_cv_func_setpgrp_void=dontcare
elif test "x$cross_compiling" = "xyes" ; then
	echo "$ac_t""yes" 1>&6
	echo $ac_n "checking whether setpgrp takes no argument""... $ac_c" 1>&6
echo "configure:9925: checking whether setpgrp takes no argument" >&5
	case "`uname -a`" in
		*BSD*|*bsd*)
			ac_cv_func_setpgrp_void="no"
			;;
		*)
			ac_cv_func_setpgrp_void="yes"
			cat >> confdefs.h <<\EOF
#define SETPGRP_VOID 1
EOF

			;;
	esac
	echo "$ac_t"""${ac_cv_func_setpgrp_void}?"" 1>&6
else
	# We're not cross compiling, so we can try this check
	echo "$ac_t""yes" 1>&6
	echo $ac_n "checking whether setpgrp takes no argument""... $ac_c" 1>&6
echo "configure:9943: checking whether setpgrp takes no argument" >&5
if eval "test \"`echo '$''{'ac_cv_func_setpgrp_void'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  if test "$cross_compiling" = yes; then
  { echo "configure: error: cannot check setpgrp if cross compiling" 1>&2; exit 1; }
else
  cat > conftest.$ac_ext <<EOF
#line 9951 "configure"
#include "confdefs.h"

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

/*
 * If this system has a BSD-style setpgrp, which takes arguments, exit
 * successfully.
 */
main()
{
    if (setpgrp(1,1) == -1)
	exit(0);
    else
	exit(1);
}

EOF
if { (eval echo configure:9971: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext} && (./conftest; exit) 2>/dev/null
then
  ac_cv_func_setpgrp_void=no
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -fr conftest*
  ac_cv_func_setpgrp_void=yes
fi
rm -fr conftest*
fi


fi

echo "$ac_t""$ac_cv_func_setpgrp_void" 1>&6
if test $ac_cv_func_setpgrp_void = yes; then
  cat >> confdefs.h <<\EOF
#define SETPGRP_VOID 1
EOF

fi

fi


echo $ac_n "checking whether setvbuf behavior can be checked""... $ac_c" 1>&6
echo "configure:9998: checking whether setvbuf behavior can be checked" >&5
if test "x$cross_compiling" = "xyes" ; then
	echo "$ac_t""no" 1>&6
else
	echo "$ac_t""yes" 1>&6
		echo $ac_n "checking whether setvbuf arguments are reversed""... $ac_c" 1>&6
echo "configure:10004: checking whether setvbuf arguments are reversed" >&5
if eval "test \"`echo '$''{'ac_cv_func_setvbuf_reversed'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  if test "$cross_compiling" = yes; then
  ac_cv_func_setvbuf_reversed=no
else
  cat > conftest.$ac_ext <<EOF
#line 10012 "configure"
#include "confdefs.h"
#include <stdio.h>
	/* If setvbuf has the reversed format, exit 0. */
	main () {
	  /* This call has the arguments reversed.
	     A reversed system may check and see that the address of main
	     is not _IOLBF, _IONBF, or _IOFBF, and return nonzero.  */
	  if (setvbuf(stdout, _IOLBF, (char *) main, BUFSIZ) != 0)
	    exit(1);
	  putc('\r', stdout);
	  exit(0);			/* Non-reversed systems segv here.  */
	}
EOF
if { (eval echo configure:10026: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext} && (./conftest; exit) 2>/dev/null
then
  ac_cv_func_setvbuf_reversed=yes
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -fr conftest*
  ac_cv_func_setvbuf_reversed=no
fi
rm -fr conftest*
fi

	rm -f core core.* *.core
fi

echo "$ac_t""$ac_cv_func_setvbuf_reversed" 1>&6
	if test $ac_cv_func_setvbuf_reversed = yes; then
	  cat >> confdefs.h <<\EOF
#define SETVBUF_REVERSED 1
EOF

	fi
fi

# The Ultrix 4.2 mips builtin alloca declared by alloca.h only works
# for constant arguments.  Useless!
echo $ac_n "checking for working alloca.h""... $ac_c" 1>&6
echo "configure:10053: checking for working alloca.h" >&5
if eval "test \"`echo '$''{'ac_cv_header_alloca_h'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 10058 "configure"
#include "confdefs.h"
#include <alloca.h>
int main() {
char *p = alloca(2 * sizeof(int));
; return 0; }
EOF
if { (eval echo configure:10065: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  ac_cv_header_alloca_h=yes
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  ac_cv_header_alloca_h=no
fi
rm -rf conftest*
fi

echo "$ac_t""$ac_cv_header_alloca_h" 1>&6
if test $ac_cv_header_alloca_h = yes; then
  cat >> confdefs.h <<\EOF
#define HAVE_ALLOCA_H 1
EOF

fi

echo $ac_n "checking for alloca""... $ac_c" 1>&6
echo "configure:10086: checking for alloca" >&5
if eval "test \"`echo '$''{'ac_cv_func_alloca_works'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 10091 "configure"
#include "confdefs.h"

#ifdef __GNUC__
# define alloca __builtin_alloca
#else
# ifdef _MSC_VER
#  include <malloc.h>
#  define alloca _alloca
# else
#  if HAVE_ALLOCA_H
#   include <alloca.h>
#  else
#   ifdef _AIX
 #pragma alloca
#   else
#    ifndef alloca /* predefined by HP cc +Olibcalls */
char *alloca ();
#    endif
#   endif
#  endif
# endif
#endif

int main() {
char *p = (char *) alloca(1);
; return 0; }
EOF
if { (eval echo configure:10119: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  ac_cv_func_alloca_works=yes
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  ac_cv_func_alloca_works=no
fi
rm -rf conftest*
fi

echo "$ac_t""$ac_cv_func_alloca_works" 1>&6
if test $ac_cv_func_alloca_works = yes; then
  cat >> confdefs.h <<\EOF
#define HAVE_ALLOCA 1
EOF

fi

if test $ac_cv_func_alloca_works = no; then
  # The SVR3 libPW and SVR4 libucb both contain incompatible functions
  # that cause trouble.  Some versions do not even contain alloca or
  # contain a buggy version.  If you still want to use their alloca,
  # use ar to extract alloca.o from them instead of compiling alloca.c.
  ALLOCA=alloca.${ac_objext}
  cat >> confdefs.h <<\EOF
#define C_ALLOCA 1
EOF


echo $ac_n "checking whether alloca needs Cray hooks""... $ac_c" 1>&6
echo "configure:10151: checking whether alloca needs Cray hooks" >&5
if eval "test \"`echo '$''{'ac_cv_os_cray'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 10156 "configure"
#include "confdefs.h"
#if defined(CRAY) && ! defined(CRAY2)
webecray
#else
wenotbecray
#endif

EOF
if (eval "$ac_cpp conftest.$ac_ext") 2>&5 |
  egrep "webecray" >/dev/null 2>&1; then
  rm -rf conftest*
  ac_cv_os_cray=yes
else
  rm -rf conftest*
  ac_cv_os_cray=no
fi
rm -rf conftest*

fi

echo "$ac_t""$ac_cv_os_cray" 1>&6
if test $ac_cv_os_cray = yes; then
for ac_func in _getb67 GETB67 getb67; do
  echo $ac_n "checking for $ac_func""... $ac_c" 1>&6
echo "configure:10181: checking for $ac_func" >&5
if eval "test \"`echo '$''{'ac_cv_func_$ac_func'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 10186 "configure"
#include "confdefs.h"
/* System header to define __stub macros and hopefully few prototypes,
    which can conflict with char $ac_func(); below.  */
#include <assert.h>
/* Override any gcc2 internal prototype to avoid an error.  */
/* We use char because int might match the return type of a gcc2
    builtin and then its argument prototype would still apply.  */
char $ac_func();

int main() {

/* The GNU C library defines this for functions which it implements
    to always fail with ENOSYS.  Some functions are actually named
    something starting with __ and the normal name is an alias.  */
#if defined (__stub_$ac_func) || defined (__stub___$ac_func)
choke me
#else
$ac_func();
#endif

; return 0; }
EOF
if { (eval echo configure:10209: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  eval "ac_cv_func_$ac_func=yes"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_func_$ac_func=no"
fi
rm -rf conftest*
fi

if eval "test \"`echo '$ac_cv_func_'$ac_func`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  cat >> confdefs.h <<EOF
#define CRAY_STACKSEG_END $ac_func
EOF

  break
else
  echo "$ac_t""no" 1>&6
fi

done
fi

echo $ac_n "checking stack direction for C alloca""... $ac_c" 1>&6
echo "configure:10236: checking stack direction for C alloca" >&5
if eval "test \"`echo '$''{'ac_cv_c_stack_direction'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  if test "$cross_compiling" = yes; then
  ac_cv_c_stack_direction=0
else
  cat > conftest.$ac_ext <<EOF
#line 10244 "configure"
#include "confdefs.h"
find_stack_direction ()
{
  static char *addr = 0;
  auto char dummy;
  if (addr == 0)
    {
      addr = &dummy;
      return find_stack_direction ();
    }
  else
    return (&dummy > addr) ? 1 : -1;
}
main ()
{
  exit (find_stack_direction() < 0);
}
EOF
if { (eval echo configure:10263: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext} && (./conftest; exit) 2>/dev/null
then
  ac_cv_c_stack_direction=1
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -fr conftest*
  ac_cv_c_stack_direction=-1
fi
rm -fr conftest*
fi

fi

echo "$ac_t""$ac_cv_c_stack_direction" 1>&6
cat >> confdefs.h <<EOF
#define STACK_DIRECTION $ac_cv_c_stack_direction
EOF

fi
	
if test "$wi_cv_lib_curses" = "yes" ; then

	if test "x$ac_cv_header_unistd_h" = x ; then
		{ echo "configure: error: Script needs to check for <unistd.h> before calling wi_CURSES_FEATURES." 1>&2; exit 1; }
	fi

	# Then $LIBCURSES is a list of curses and support libraries.
	ac_save_LIBS="$LIBS";
	LIBS="$LIBS $LIBCURSES";






	if test "x$ac_cv_header_unistd_h" = x ; then
		{ echo "configure: error: Script needs to check for <unistd.h> before calling wi_CURSES_FUNC_PARAM_TYPES." 1>&2; exit 1; }
	fi

echo $ac_n "checking string parameter to waddstr""... $ac_c" 1>&6
echo "configure:10304: checking string parameter to waddstr" >&5
if eval "test \"`echo '$''{'wi_cv_waddstr_str_t'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  
used_cache_for_wi_curses_fpt="no"


wi_tmpdir=""
if [ "x$MKTEMP" != "x" ] ; then
	# Ignore error from mktemp, since some old versions of Linux
	# print an error about not supporting -d.
	#
	wi_tmpdir=`"$MKTEMP" -d /tmp/configure.XXXXXXXXXX 2>/dev/null`
	if [ $? -ne 0 ] ; then
		wi_tmpdir=""
	fi
fi
if [ "x$wi_tmpdir" = "x" ] ; then
	for wi_tmpdir in . $TMPDIR $TEMPDIR /tmp ABORT
	do
		if [ "$wi_tmpdir" = ABORT ] ; then
			echo "Cannot create temporary directory."
			exit 1
		fi
		wi_tmpdir="$wi_tmpdir/config_tmp.$$"
		if [ -d "$wi_tmpdir" ] || [ -f "$wi_tmpdir" ] ; then
			echo "Will not create temporary directory."
			exit 1
		fi
		mkdir "$wi_tmpdir"
		if [ $? -eq 0 ] && [ -d "$wi_tmpdir" ] ; then break ;  fi
	done
fi

# Use the temporary directory here...


cat << 'EOF' > "$wi_tmpdir/prpp.pl"
#!/usr/bin/perl -w
#
# prpp.pl
#
# Feed the output of your CPP to this to print a list of function prototypes.
# 
#use strict;

my ($c) = "";
my ($unputc) = "";
my ($line) = "";
my ($lines) = "";
my ($cline) = "";
my ($skipping) = 0;
my ($numclines) = 0;

MAINLOOP: while (1) {
	if ($unputc ne "") {
		$c = $unputc;
		$unputc = "";
	} else {
		last unless (read(STDIN, $c, 1) == 1);
	}
	if ($c eq "{") {
		$skipping++;
	} elsif ($c eq "}") {
		--$skipping;
		$unputc = ";";
	} elsif ($skipping) {
		next MAINLOOP;
	} elsif ($c eq ";") {
		if ($line =~ m/^\s*(\S.*\S)\s*$/s) {
			$lines .= $1;
			$line = "";
		}
		if ($lines =~ m/^\s*(extern\s*)?(\S.*\S)\s*$/s) {
			$cline = $2;
			$cline =~ s/\s+/\ /g;
			if ($cline =~ /^typedef/) {
				$cline = "";
			} elsif ($cline =~ /\(.*\)$/) {
				# found a proto
				print $cline, ";\n";
				$numclines++;
			} else {
				$cline = "";
			}
		}
		$lines = "";
		$line = "";
	} elsif ($c eq "\n") {
		if ($line =~ m/^\s*(\S.*\S)\s*$/s) {
			$lines .= $1 . " ";
			$line = "";
		}
	} elsif (($c eq "#") && ($line eq "")) {
		# Looks like a preprocessor line, kill it
		{
			last MAINLOOP if (read(STDIN, $c, 1) != 1);
			last if ($c eq "\n");
			redo;
		}
	} elsif ($c =~ /^\s$/) {
		$line .= " " if ($line ne "");
	} elsif (! $skipping) {
		$line .= $c;
	}
}
exit(($numclines == 0) ? 1 : 0);
EOF
chmod 755 "$wi_tmpdir/prpp.pl"


cat << 'EOF' > "$wi_tmpdir/curses.c"
#if defined(AIX) || defined(_AIX) || defined(__HOS_AIX__)
#	define _ALL_SOURCE 1
#endif
#include <confdefs.h>
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#ifdef HAVE_NCURSES_H
#	define NCURSES_OPAQUE 0
#	include <ncurses.h>
#else
#	include <curses.h>
#endif

main()
{
	exit(0);
}
EOF

cat << 'EOF' > "$wi_tmpdir/sed2.sh"
#!/bin/sh

if [ $# -eq 0 ] ; then exit 1 ; fi
x="$1"

sed -n 's/extern//;s/static//;
		/[\ \*]'"$x"'\ *(/{
			s/^.*'"$x"'\ *(/(/
			s/)\ *[;,].*$/)/
			/const char/{
				c\
const char *
			}
			/char/{
				c\
char *
			}
			/const/{
				c\
const void
			}
			q
}'
EOF
chmod 755 "$wi_tmpdir/sed2.sh"

$CPP "-I${srcdir-.}" "$wi_tmpdir/curses.c" > "$wi_tmpdir/curses.i"
if [ -s "$wi_tmpdir/curses.i" ] ; then
	"$PERL" "$wi_tmpdir/prpp.pl" < "$wi_tmpdir/curses.i" > "$wi_tmpdir/protos.h"
fi
if [ -f "$wi_tmpdir/protos.h" ] ; then
	#
	# Check what type waddstr() expects for the string parameter
	#
	x="waddstr"
	wi_cv_waddstr_str_t=`/bin/sh "$wi_tmpdir/sed2.sh" "$x" < "$wi_tmpdir/protos.h"`
fi
if [ "x$wi_cv_waddstr_str_t" = "x" ] ; then
	wi_cv_waddstr_str_t="const char *"
fi

# Done using the temporary directory here.

rm -r "$wi_tmpdir"
unset wi_tmpdir


fi

echo "$ac_t""$wi_cv_waddstr_str_t" 1>&6
unset used_cache_for_wi_curses_fpt
cat >> confdefs.h <<EOF
#define waddstr_str_t $wi_cv_waddstr_str_t
EOF

if test "$wi_cv_waddstr_str_t" = "const char *" ; then
	cat >> confdefs.h <<\EOF
#define WADDSTR_TYPE_ARG1_CONST 1
EOF

fi


	# maxx or _maxx
	echo $ac_n "checking whether curses structure has maxx or _maxx field""... $ac_c" 1>&6
echo "configure:10508: checking whether curses structure has maxx or _maxx field" >&5
	cat > conftest.$ac_ext <<EOF
#line 10510 "configure"
#include "confdefs.h"

	/* includes */
#if defined(AIX) || defined(_AIX) || defined(__HOS_AIX__)
#	define _ALL_SOURCE 1
#endif
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#ifdef HAVE_NCURSES_H
#	define NCURSES_OPAQUE 0
#	include <ncurses.h>
#else
#	include <curses.h>
#endif

int main() {

		WINDOW *w;
	
		w = newwin(10, 10, 1, 1);
		w->maxx = 0;

; return 0; }
EOF
if { (eval echo configure:10541: \"$ac_compile\") 1>&5; (eval $ac_compile) 2>&5; }; then
  rm -rf conftest*
  
echo "$ac_t""maxx" 1>&6

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  
cat >> confdefs.h <<\EOF
#define HAVE__MAXX 1
EOF

echo "$ac_t""_maxx" 1>&6

fi
rm -rf conftest*

	if test "${SYS-hpux}" = hpux ; then
	for ac_func in __getcurx __getcury __getmaxx __getmaxy __getbegx __getbegy
do
echo $ac_n "checking for $ac_func""... $ac_c" 1>&6
echo "configure:10564: checking for $ac_func" >&5
if eval "test \"`echo '$''{'ac_cv_func_$ac_func'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 10569 "configure"
#include "confdefs.h"
/* System header to define __stub macros and hopefully few prototypes,
    which can conflict with char $ac_func(); below.  */
#include <assert.h>
/* Override any gcc2 internal prototype to avoid an error.  */
/* We use char because int might match the return type of a gcc2
    builtin and then its argument prototype would still apply.  */
char $ac_func();

int main() {

/* The GNU C library defines this for functions which it implements
    to always fail with ENOSYS.  Some functions are actually named
    something starting with __ and the normal name is an alias.  */
#if defined (__stub_$ac_func) || defined (__stub___$ac_func)
choke me
#else
$ac_func();
#endif

; return 0; }
EOF
if { (eval echo configure:10592: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  eval "ac_cv_func_$ac_func=yes"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_func_$ac_func=no"
fi
rm -rf conftest*
fi

if eval "test \"`echo '$ac_cv_func_'$ac_func`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_func=HAVE_`echo $ac_func | tr 'abcdefghijklmnopqrstuvwxyz' 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'`
  cat >> confdefs.h <<EOF
#define $ac_tr_func 1
EOF
 
else
  echo "$ac_t""no" 1>&6
fi
done

	fi

	# getcurx
	echo $ac_n "checking for getcurx() functionality in curses library""... $ac_c" 1>&6
echo "configure:10620: checking for getcurx() functionality in curses library" >&5
	cat > conftest.$ac_ext <<EOF
#line 10622 "configure"
#include "confdefs.h"

	/* includes */
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#ifdef HAVE_NCURSES_H
#	define NCURSES_OPAQUE 0
#	include <ncurses.h>
#else
#	include <curses.h>
#endif


int main() {

	/* function-body */
	WINDOW *junk = 0;
	int mx = 0;

	mx = getcurx(junk);
	exit(0);

; return 0; }
EOF
if { (eval echo configure:10653: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  
	cat >> confdefs.h <<\EOF
#define HAVE_GETCURX 1
EOF

	echo "$ac_t""yes" 1>&6

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  
	echo "$ac_t""no" 1>&6

fi
rm -rf conftest*

	# getyx
	echo $ac_n "checking for getyx() functionality in curses library""... $ac_c" 1>&6
echo "configure:10674: checking for getyx() functionality in curses library" >&5
	cat > conftest.$ac_ext <<EOF
#line 10676 "configure"
#include "confdefs.h"

	/* includes */
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#ifdef HAVE_NCURSES_H
#	define NCURSES_OPAQUE 0
#	include <ncurses.h>
#else
#	include <curses.h>
#endif


int main() {

	/* function-body */
	WINDOW *junk = 0;
	int mx = 0, my = 0;

	getyx(junk, my, mx);
	exit(0);

; return 0; }
EOF
if { (eval echo configure:10707: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  
	cat >> confdefs.h <<\EOF
#define HAVE_GETYX 1
EOF

	echo "$ac_t""yes" 1>&6

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  
	echo "$ac_t""no" 1>&6

fi
rm -rf conftest*

	# getmaxx
	echo $ac_n "checking for getmaxx() functionality in curses library""... $ac_c" 1>&6
echo "configure:10728: checking for getmaxx() functionality in curses library" >&5
	cat > conftest.$ac_ext <<EOF
#line 10730 "configure"
#include "confdefs.h"

	/* includes */
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#ifdef HAVE_NCURSES_H
#	define NCURSES_OPAQUE 0
#	include <ncurses.h>
#else
#	include <curses.h>
#endif

int main() {

	/* function-body */
	WINDOW *junk = 0;
	int mx = 0;

	mx = getmaxx(junk);
	exit(0);

; return 0; }
EOF
if { (eval echo configure:10760: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  
	cat >> confdefs.h <<\EOF
#define HAVE_GETMAXX 1
EOF

	echo "$ac_t""yes" 1>&6

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  
	echo "$ac_t""no" 1>&6

fi
rm -rf conftest*

	# getmaxyx
	echo $ac_n "checking for getmaxyx() functionality in curses library""... $ac_c" 1>&6
echo "configure:10781: checking for getmaxyx() functionality in curses library" >&5
	cat > conftest.$ac_ext <<EOF
#line 10783 "configure"
#include "confdefs.h"

	/* includes */
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#ifdef HAVE_NCURSES_H
#	define NCURSES_OPAQUE 0
#	include <ncurses.h>
#else
#	include <curses.h>
#endif

int main() {

	/* function-body */
	WINDOW *junk = 0;
	int mx = 0, my = 0;

	getmaxyx(junk, my, mx);
	exit(my < 0 ? my : 0);

; return 0; }
EOF
if { (eval echo configure:10813: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  
	cat >> confdefs.h <<\EOF
#define HAVE_GETMAXYX 1
EOF

	echo "$ac_t""yes" 1>&6

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  
	echo "$ac_t""no" 1>&6

fi
rm -rf conftest*

	# getbegx
	echo $ac_n "checking for getbegx() functionality in curses library""... $ac_c" 1>&6
echo "configure:10834: checking for getbegx() functionality in curses library" >&5
	cat > conftest.$ac_ext <<EOF
#line 10836 "configure"
#include "confdefs.h"

	/* includes */
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#ifdef HAVE_NCURSES_H
#	define NCURSES_OPAQUE 0
#	include <ncurses.h>
#else
#	include <curses.h>
#endif


int main() {

	/* function-body */
	WINDOW *junk = 0;
	int mx = 0;

	mx = getbegx(junk);
	exit(0);

; return 0; }
EOF
if { (eval echo configure:10867: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  
	cat >> confdefs.h <<\EOF
#define HAVE_GETBEGX 1
EOF

	echo "$ac_t""yes" 1>&6

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  
	echo "$ac_t""no" 1>&6

fi
rm -rf conftest*

	# getbegyx
	echo $ac_n "checking for getbegyx() functionality in curses library""... $ac_c" 1>&6
echo "configure:10888: checking for getbegyx() functionality in curses library" >&5
	cat > conftest.$ac_ext <<EOF
#line 10890 "configure"
#include "confdefs.h"

	/* includes */
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#ifdef HAVE_NCURSES_H
#	define NCURSES_OPAQUE 0
#	include <ncurses.h>
#else
#	include <curses.h>
#endif

int main() {

	/* function-body */
	WINDOW *junk = 0;
	int mx = 0, my = 0;

	getbegyx(junk, my, mx);
	exit(my < 0 ? my : 0);

; return 0; }
EOF
if { (eval echo configure:10920: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  
	cat >> confdefs.h <<\EOF
#define HAVE_GETBEGYX 1
EOF

	echo "$ac_t""yes" 1>&6

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  
	echo "$ac_t""no" 1>&6

fi
rm -rf conftest*

	# touchwin
	echo $ac_n "checking for touchwin() functionality in curses library""... $ac_c" 1>&6
echo "configure:10941: checking for touchwin() functionality in curses library" >&5
	cat > conftest.$ac_ext <<EOF
#line 10943 "configure"
#include "confdefs.h"

	/* includes */
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#ifdef HAVE_NCURSES_H
#	define NCURSES_OPAQUE 0
#	include <ncurses.h>
#else
#	include <curses.h>
#endif

int main() {

	/* function-body */
	WINDOW *junk = 0;
	touchwin(junk);
	exit(0);

; return 0; }
EOF
if { (eval echo configure:10971: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  
	cat >> confdefs.h <<\EOF
#define HAVE_TOUCHWIN 1
EOF

	echo "$ac_t""yes" 1>&6

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  
	echo "$ac_t""no" 1>&6

fi
rm -rf conftest*

	# beep
	echo $ac_n "checking for beep() functionality in curses library""... $ac_c" 1>&6
echo "configure:10992: checking for beep() functionality in curses library" >&5
	cat > conftest.$ac_ext <<EOF
#line 10994 "configure"
#include "confdefs.h"

	/* includes */
#ifdef HAVE_UNISTD_H
#	include <unistd.h>
#endif
#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#ifdef HAVE_NCURSES_H
#	define NCURSES_OPAQUE 0
#	include <ncurses.h>
#else
#	include <curses.h>
#endif

int main() {

	/* function-body */
	beep();
	exit(getpid() & 1);

; return 0; }
EOF
if { (eval echo configure:11021: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  
	cat >> confdefs.h <<\EOF
#define HAVE_BEEP 1
EOF

	echo "$ac_t""yes" 1>&6

else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  
	echo "$ac_t""no" 1>&6

fi
rm -rf conftest*

	for ac_func in keypad nodelay curs_set doupdate wnoutrefresh
do
echo $ac_n "checking for $ac_func""... $ac_c" 1>&6
echo "configure:11043: checking for $ac_func" >&5
if eval "test \"`echo '$''{'ac_cv_func_$ac_func'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftest.$ac_ext <<EOF
#line 11048 "configure"
#include "confdefs.h"
/* System header to define __stub macros and hopefully few prototypes,
    which can conflict with char $ac_func(); below.  */
#include <assert.h>
/* Override any gcc2 internal prototype to avoid an error.  */
/* We use char because int might match the return type of a gcc2
    builtin and then its argument prototype would still apply.  */
char $ac_func();

int main() {

/* The GNU C library defines this for functions which it implements
    to always fail with ENOSYS.  Some functions are actually named
    something starting with __ and the normal name is an alias.  */
#if defined (__stub_$ac_func) || defined (__stub___$ac_func)
choke me
#else
$ac_func();
#endif

; return 0; }
EOF
if { (eval echo configure:11071: \"$ac_link\") 1>&5; (eval $ac_link) 2>&5; } && test -s conftest${ac_exeext}; then
  rm -rf conftest*
  eval "ac_cv_func_$ac_func=yes"
else
  echo "configure: failed program was:" >&5
  cat conftest.$ac_ext >&5
  rm -rf conftest*
  eval "ac_cv_func_$ac_func=no"
fi
rm -rf conftest*
fi

if eval "test \"`echo '$ac_cv_func_'$ac_func`\" = yes"; then
  echo "$ac_t""yes" 1>&6
    ac_tr_func=HAVE_`echo $ac_func | tr 'abcdefghijklmnopqrstuvwxyz' 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'`
  cat >> confdefs.h <<EOF
#define $ac_tr_func 1
EOF
 
else
  echo "$ac_t""no" 1>&6
fi
done


	LIBS="$ac_save_LIBS";
fi

if test "x$LIBCURSES" = "x" ; then
	VIS_DPROGS="# ../bin/ncftpbookmarks${EXEEXT}"
else
	VIS_DPROGS="../bin/ncftpbookmarks${EXEEXT}"
fi



echo $ac_n "checking for long file names""... $ac_c" 1>&6
echo "configure:11108: checking for long file names" >&5
if eval "test \"`echo '$''{'ac_cv_sys_long_file_names'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  ac_cv_sys_long_file_names=yes
# Test for long file names in all the places we know might matter:
#      .		the current directory, where building will happen
#      $prefix/lib	where we will be installing things
#      $exec_prefix/lib	likewise
# eval it to expand exec_prefix.
#      $TMPDIR		if set, where it might want to write temporary files
# if $TMPDIR is not set:
#      /tmp		where it might want to write temporary files
#      /var/tmp		likewise
#      /usr/tmp		likewise
if test -n "$TMPDIR" && test -d "$TMPDIR" && test -w "$TMPDIR"; then
  ac_tmpdirs="$TMPDIR"
else
  ac_tmpdirs='/tmp /var/tmp /usr/tmp'
fi
for ac_dir in  . $ac_tmpdirs `eval echo $prefix/lib $exec_prefix/lib` ; do
  test -d $ac_dir || continue
  test -w $ac_dir || continue # It is less confusing to not echo anything here.
  (echo 1 > $ac_dir/conftest9012345) 2>/dev/null
  (echo 2 > $ac_dir/conftest9012346) 2>/dev/null
  val=`cat $ac_dir/conftest9012345 2>/dev/null`
  if test ! -f $ac_dir/conftest9012345 || test "$val" != 1; then
    ac_cv_sys_long_file_names=no
    rm -f $ac_dir/conftest9012345 $ac_dir/conftest9012346 2>/dev/null
    break
  fi
  rm -f $ac_dir/conftest9012345 $ac_dir/conftest9012346 2>/dev/null
done
fi

echo "$ac_t""$ac_cv_sys_long_file_names" 1>&6
if test $ac_cv_sys_long_file_names = yes; then
  cat >> confdefs.h <<\EOF
#define HAVE_LONG_FILE_NAMES 1
EOF

fi

echo $ac_n "checking whether ${MAKE-make} sets \${MAKE}""... $ac_c" 1>&6
echo "configure:11152: checking whether ${MAKE-make} sets \${MAKE}" >&5
set dummy ${MAKE-make}; ac_make=`echo "$2" | sed 'y%./+-%__p_%'`
if eval "test \"`echo '$''{'ac_cv_prog_make_${ac_make}_set'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  cat > conftestmake <<\EOF
all:
	@echo 'ac_maketemp="${MAKE}"'
EOF
# GNU make sometimes prints "make[1]: Entering...", which would confuse us.
eval `${MAKE-make} -f conftestmake 2>/dev/null | grep temp=`
if test -n "$ac_maketemp"; then
  eval ac_cv_prog_make_${ac_make}_set=yes
else
  eval ac_cv_prog_make_${ac_make}_set=no
fi
rm -f conftestmake
fi
if eval "test \"`echo '$ac_cv_prog_make_'${ac_make}_set`\" = yes"; then
  echo "$ac_t""yes" 1>&6
  SET_MAKE=
else
  echo "$ac_t""no" 1>&6
  SET_MAKE="MAKE=${MAKE-make}"
fi


# Extract the first word of ""gtar"", so it can be a program name with args.
set dummy "gtar"; ac_word=$2
echo $ac_n "checking for $ac_word""... $ac_c" 1>&6
echo "configure:11182: checking for $ac_word" >&5
if eval "test \"`echo '$''{'ac_cv_path_TAR'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  case "$TAR" in
  /*)
  ac_cv_path_TAR="$TAR" # Let the user override the test with a path.
  ;;
  ?:/*)			 
  ac_cv_path_TAR="$TAR" # Let the user override the test with a dos path.
  ;;
  *)
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS=":"
  ac_dummy="$PATH"
  for ac_dir in $ac_dummy; do 
    test -z "$ac_dir" && ac_dir=.
    if test -f $ac_dir/$ac_word; then
      ac_cv_path_TAR="$ac_dir/$ac_word"
      break
    fi
  done
  IFS="$ac_save_ifs"
  test -z "$ac_cv_path_TAR" && ac_cv_path_TAR=""""
  ;;
esac
fi
TAR="$ac_cv_path_TAR"
if test -n "$TAR"; then
  echo "$ac_t""$TAR" 1>&6
else
  echo "$ac_t""no" 1>&6
fi

if test "x$TAR" = "x" ; then
	unset TAR
	unset ac_cv_path_TAR
	# Extract the first word of ""tar"", so it can be a program name with args.
set dummy "tar"; ac_word=$2
echo $ac_n "checking for $ac_word""... $ac_c" 1>&6
echo "configure:11221: checking for $ac_word" >&5
if eval "test \"`echo '$''{'ac_cv_path_TAR'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  case "$TAR" in
  /*)
  ac_cv_path_TAR="$TAR" # Let the user override the test with a path.
  ;;
  ?:/*)			 
  ac_cv_path_TAR="$TAR" # Let the user override the test with a dos path.
  ;;
  *)
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS=":"
  ac_dummy="$PATH"
  for ac_dir in $ac_dummy; do 
    test -z "$ac_dir" && ac_dir=.
    if test -f $ac_dir/$ac_word; then
      ac_cv_path_TAR="$ac_dir/$ac_word"
      break
    fi
  done
  IFS="$ac_save_ifs"
  test -z "$ac_cv_path_TAR" && ac_cv_path_TAR=""""
  ;;
esac
fi
TAR="$ac_cv_path_TAR"
if test -n "$TAR"; then
  echo "$ac_t""$TAR" 1>&6
else
  echo "$ac_t""no" 1>&6
fi

fi



if test "x$TAR" != "x" ; then
	cat >> confdefs.h <<EOF
#define TAR "$TAR"
EOF

fi




echo $ac_n "checking how to create TAR files""... $ac_c" 1>&6
echo "configure:11269: checking how to create TAR files" >&5
x=""
if [ -x /usr/bin/what ] ; then
	x=`/usr/bin/what "$TAR" 2>&1 | sed -n 's/.*pax.*/pax/g;/pax/p'`
elif [ -x /bin/what ] ; then
	x=`/bin/what "$TAR" 2>&1 | sed -n 's/.*pax.*/pax/g;/pax/p'`
fi
if [ "x$x" != "xpax" ] ; then
	# The junk above is because Mac OS X Server's tar freaks out
	# and does not exit if you do "tar --help".
	#
	x=`"$TAR" --help 2>&1 | sed -n 's/.*owner=NAME.*/owner=NAME/g;/owner=NAME/p'`
fi
TARFLAGS="cvf"
case "$x" in
	*owner=NAME*)
		case "$OS" in
			cygwin*)
				;;
			macosx*)
				TARFLAGS="-c --owner=root --group=wheel --verbose -f"
				;;
			*)
				if grep '^root:' /etc/group >/dev/null 2>&1 ; then
					TARFLAGS="-c --owner=root --group=root --verbose -f"
				elif grep '^wheel:' /etc/group >/dev/null 2>&1 ; then
					TARFLAGS="-c --owner=root --group=wheel --verbose -f"
				fi
				;;
		esac
		;;
esac

echo "$ac_t""$TAR $TARFLAGS" 1>&6


if test "x$cross_compiling" = "xyes" ; then
	# Help out if the cross ranlib isn't in your path,
	# for example, maybe you set CC=/path/to/cross-gcc
	# rather than put PATH=/path/to/crosstools:$PATH
	# and let cc be found in your PATH.
	#
	machine=`${CC-gcc} -dumpmachine 2>/dev/null`
	case "$CC" in
		*${machine}*)
			f=`echo "$CC" | sed 's|/[^/]*$||'`
			if [ -x "$f/${machine}-ranlib" ] ; then
				RANLIB="$f/${machine}-ranlib"
			elif [ -x "$f/ranlib" ] ; then
				RANLIB="$f/ranlib"
			fi
			;;
	esac
	unset machine f
fi
# Extract the first word of "ranlib", so it can be a program name with args.
set dummy ranlib; ac_word=$2
echo $ac_n "checking for $ac_word""... $ac_c" 1>&6
echo "configure:11327: checking for $ac_word" >&5
if eval "test \"`echo '$''{'ac_cv_prog_RANLIB'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  if test -n "$RANLIB"; then
  ac_cv_prog_RANLIB="$RANLIB" # Let the user override the test.
else
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS=":"
  ac_dummy="$PATH"
  for ac_dir in $ac_dummy; do
    test -z "$ac_dir" && ac_dir=.
    if test -f $ac_dir/$ac_word; then
      ac_cv_prog_RANLIB="ranlib"
      break
    fi
  done
  IFS="$ac_save_ifs"
  test -z "$ac_cv_prog_RANLIB" && ac_cv_prog_RANLIB=":"
fi
fi
RANLIB="$ac_cv_prog_RANLIB"
if test -n "$RANLIB"; then
  echo "$ac_t""$RANLIB" 1>&6
else
  echo "$ac_t""no" 1>&6
fi



echo $ac_n "checking for ar""... $ac_c" 1>&6
echo "configure:11357: checking for ar" >&5
AR="ar"
if [ "x$cross_compiling" = "xyes" ] ; then
	machine=`${CC-gcc} -dumpmachine 2>/dev/null`
	case "$CC" in
		*${machine}*)
			f=`echo "$CC" | sed 's|/[^/]*$||'`
			if [ -x "$f/${machine}-ar" ] ; then
				AR="$f/${machine}-ar"
			elif [ -x "$f/ar" ] ; then
				AR="$f/ar"
			fi
			;;
	esac
	unset machine f
fi
echo "$ac_t""$AR" 1>&6


# Find a good install program.  We prefer a C program (faster),
# so one script is as good as another.  But avoid the broken or
# incompatible versions:
# SysV /etc/install, /usr/sbin/install
# SunOS /usr/etc/install
# IRIX /sbin/install
# AIX /bin/install
# AIX 4 /usr/bin/installbsd, which doesn't work without a -g flag
# AFS /usr/afsws/bin/install, which mishandles nonexistent args
# SVR4 /usr/ucb/install, which tries to use the nonexistent group "staff"
# ./install, which can be erroneously created by make from ./install.sh.
echo $ac_n "checking for a BSD compatible install""... $ac_c" 1>&6
echo "configure:11388: checking for a BSD compatible install" >&5
if test -z "$INSTALL"; then
if eval "test \"`echo '$''{'ac_cv_path_install'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
    IFS="${IFS= 	}"; ac_save_IFS="$IFS"; IFS=":"
  for ac_dir in $PATH; do
    # Account for people who put trailing slashes in PATH elements.
    case "$ac_dir/" in
    /|./|.//|/etc/*|/usr/sbin/*|/usr/etc/*|/sbin/*|/usr/afsws/bin/*|/usr/ucb/*) ;;
    *)
      # OSF1 and SCO ODT 3.0 have their own names for install.
      # Don't use installbsd from OSF since it installs stuff as root
      # by default.
      for ac_prog in ginstall scoinst install; do
        if test -f $ac_dir/$ac_prog; then
	  if test $ac_prog = install &&
            grep dspmsg $ac_dir/$ac_prog >/dev/null 2>&1; then
	    # AIX install.  It has an incompatible calling convention.
	    :
	  else
	    ac_cv_path_install="$ac_dir/$ac_prog -c"
	    break 2
	  fi
	fi
      done
      ;;
    esac
  done
  IFS="$ac_save_IFS"

fi
  if test "${ac_cv_path_install+set}" = set; then
    INSTALL="$ac_cv_path_install"
  else
    # As a last resort, use the slow shell script.  We don't cache a
    # path for INSTALL within a source directory, because that will
    # break other packages using the cache if that directory is
    # removed, or if the path is relative.
    INSTALL="$ac_install_sh"
  fi
fi
echo "$ac_t""$INSTALL" 1>&6

# Use test -z because SunOS4 sh mishandles braces in ${var-val}.
# It thinks the first close brace ends the variable substitution.
test -z "$INSTALL_PROGRAM" && INSTALL_PROGRAM='${INSTALL}'

test -z "$INSTALL_SCRIPT" && INSTALL_SCRIPT='${INSTALL_PROGRAM}'

test -z "$INSTALL_DATA" && INSTALL_DATA='${INSTALL} -m 644'


# Extract the first word of ""pwd"", so it can be a program name with args.
set dummy "pwd"; ac_word=$2
echo $ac_n "checking for $ac_word""... $ac_c" 1>&6
echo "configure:11444: checking for $ac_word" >&5
if eval "test \"`echo '$''{'ac_cv_path_wi_PWD'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  case "$wi_PWD" in
  /*)
  ac_cv_path_wi_PWD="$wi_PWD" # Let the user override the test with a path.
  ;;
  ?:/*)			 
  ac_cv_path_wi_PWD="$wi_PWD" # Let the user override the test with a dos path.
  ;;
  *)
  IFS="${IFS= 	}"; ac_save_ifs="$IFS"; IFS=":"
  ac_dummy="$PATH"
  for ac_dir in $ac_dummy; do 
    test -z "$ac_dir" && ac_dir=.
    if test -f $ac_dir/$ac_word; then
      ac_cv_path_wi_PWD="$ac_dir/$ac_word"
      break
    fi
  done
  IFS="$ac_save_ifs"
  test -z "$ac_cv_path_wi_PWD" && ac_cv_path_wi_PWD=""pwd""
  ;;
esac
fi
wi_PWD="$ac_cv_path_wi_PWD"
if test -n "$wi_PWD"; then
  echo "$ac_t""$wi_PWD" 1>&6
else
  echo "$ac_t""no" 1>&6
fi



if test "x$use_ccdv" = "xno" ; then
	echo $ac_n "checking for ccdv""... $ac_c" 1>&6
echo "configure:11481: checking for ccdv" >&5
	echo "$ac_t""(disabled)" 1>&6
else
unset wi_cv_path_ccdv	# can't use cache if it was a temp prog last time
wi_used_cache_path_ccdv="yes"
echo $ac_n "checking for ccdv""... $ac_c" 1>&6
echo "configure:11487: checking for ccdv" >&5
if eval "test \"`echo '$''{'wi_cv_path_ccdv'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  
wi_used_cache_path_ccdv="no"
for CCDV in /usr/bin/ccdv /usr/local/bin/ccdv /usr/ccs/bin/ccdv NONE
do
	if test "$CCDV" = NONE ; then CCDV="" ; break ; fi
	$CCDV >/dev/null 2>&1
	if test $? -eq 96 ; then
		break
	fi
done
if test "x$CCDV" = "x" ; then
		cat > ccdv.c << 'EOF'
/* ccdv.c
 *
 * Copyright (C) 2002-2003, by Mike Gleason, NcFTP Software.
 * All Rights Reserved.
 *
 * Licensed under the GNU Public License.
 */
#include <unistd.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>

#define SETCOLOR_SUCCESS	(gANSIEscapes ? "\033\1331;32m" : "")
#define SETCOLOR_FAILURE	(gANSIEscapes ? "\033\1331;31m" : "")
#define SETCOLOR_WARNING	(gANSIEscapes ? "\033\1331;33m" : "")
#define SETCOLOR_NORMAL		(gANSIEscapes ? "\033\1330;39m" : "")

#define TEXT_BLOCK_SIZE 8192
#define INDENT 2

#define TERMS "vt100:vt102:vt220:vt320:xterm:xterm-color:xterm-256color:ansi:linux:scoterm:scoansi:dtterm:cons25:cygwin:screen"

size_t gNBufUsed = 0, gNBufAllocated = 0;
char *gBuf = NULL;
int gCCPID;
char gAction[64] = "";
char gTarget[64] = "";
char gAr[32] = "";
char gArLibraryTarget[64] = "";
int gDumpCmdArgs = 0;
char gArgsStr[800];
int gColumns = 80;
int gANSIEscapes = 0;
int gExitStatus = 95;

static void
DumpFormattedOutput(void)
{
	char *cp;
	char spaces[8 + 1] = "        ";
	char *saved;
	int curcol;
	int i;

	curcol = 0;
	saved = NULL;
	for (cp = gBuf + ((gDumpCmdArgs == 0) ? strlen(gArgsStr) : 0); ; cp++) {
		if (*cp == '\0') {
			if (saved != NULL) {
				cp = saved;
				saved = NULL;
			} else break;
		}
		if (*cp == '\r')
			continue;
		if (*cp == '\t') {
			saved = cp + 1;
			cp = spaces + 8 - (8 - ((curcol - INDENT - 1) % 8));
		}
		if (curcol == 0) {
			for (i = INDENT; --i >= 0; )
				putchar(' ');
			curcol = INDENT;
		}
		putchar(*cp);
		if (++curcol == (gColumns - 1)) {
			putchar('\n');
			curcol = 0;
		} else if (*cp == '\n')
			curcol = 0;
	}
	free(gBuf);
}	/* DumpFormattedOutput */



/* Difftime(), only for timeval structures.  */
static void TimeValSubtract(struct timeval *tdiff, struct timeval *t1, struct timeval *t0)
{
	tdiff->tv_sec = t1->tv_sec - t0->tv_sec;
	tdiff->tv_usec = t1->tv_usec - t0->tv_usec;
	if (tdiff->tv_usec < 0) {
		tdiff->tv_sec--;
		tdiff->tv_usec += 1000000;
	}
}	/* TimeValSubtract */



static void
Wait(void)
{
	int pid2, status;

	do {
		status = 0;
		pid2 = (int) waitpid(gCCPID, &status, 0);
	} while (((pid2 >= 0) && (! WIFEXITED(status))) || ((pid2 < 0) && (errno == EINTR)));
	if (WIFEXITED(status))
		gExitStatus = WEXITSTATUS(status);
}	/* Wait */



static int
SlurpProgress(int fd)
{
	char s1[71];
	char *newbuf;
	int nready;
	size_t ntoread;
	ssize_t nread;
	struct timeval now, tnext, tleft;
	fd_set ss;
	fd_set ss2;
	const char *trail = "/-\\|", *trailcp;

	trailcp = trail;
	snprintf(s1, sizeof(s1), "%s%s%s... ", gAction, gTarget[0] ? " " : "", gTarget);
	printf("\r%-70s%-9s", s1, "");
	fflush(stdout);

	gettimeofday(&now, NULL);
	tnext = now;
	tnext.tv_sec++;
	tleft.tv_sec = 1;
	tleft.tv_usec = 0;
	FD_ZERO(&ss2);
	FD_SET(fd, &ss2);
	for(;;) {
		if (gNBufUsed == (gNBufAllocated - 1)) {
			if ((newbuf = (char *) realloc(gBuf, gNBufAllocated + TEXT_BLOCK_SIZE)) == NULL) {
				perror("ccdv: realloc");
				return (-1);
			}
			gNBufAllocated += TEXT_BLOCK_SIZE;
			gBuf = newbuf;
		}
		for (;;) {
			ss = ss2;
			nready = select(fd + 1, &ss, NULL, NULL, &tleft);
			if (nready == 1)
				break;
			if (nready < 0) {
				if (errno != EINTR) {
					perror("ccdv: select");
					return (-1);
				}
				continue;
			}
			gettimeofday(&now, NULL);
			if ((now.tv_sec > tnext.tv_sec) || ((now.tv_sec == tnext.tv_sec) && (now.tv_usec >= tnext.tv_usec))) {
				tnext = now;
				tnext.tv_sec++;
				tleft.tv_sec = 1;
				tleft.tv_usec = 0;
				printf("\r%-71s%c%-7s", s1, *trailcp, "");
				fflush(stdout);
				if (*++trailcp == '\0')
					trailcp = trail;
			} else {
				TimeValSubtract(&tleft, &tnext, &now);
			}
		}
		ntoread = (gNBufAllocated - gNBufUsed - 1);
		nread = read(fd, gBuf + gNBufUsed, ntoread);
		if (nread < 0) {
			if (errno == EINTR)
				continue;
			perror("ccdv: read");
			return (-1);
		} else if (nread == 0) {
			break;
		}
		gNBufUsed += nread;
		gBuf[gNBufUsed] = '\0';
	}
	snprintf(s1, sizeof(s1), "%s%s%s: ", gAction, gTarget[0] ? " " : "", gTarget);
	Wait();
	if (gExitStatus == 0) {
		printf("\r%-70s", s1);
		printf("[%s%s%s]", ((gNBufUsed - strlen(gArgsStr)) < 4) ? SETCOLOR_SUCCESS : SETCOLOR_WARNING, "OK", SETCOLOR_NORMAL);
		printf("%-5s\n", " ");
	} else {
		printf("\r%-70s", s1);
		printf("[%s%s%s]", SETCOLOR_FAILURE, "ERROR", SETCOLOR_NORMAL);
		printf("%-2s\n", " ");
		gDumpCmdArgs = 1;	/* print cmd when there are errors */
	}
	fflush(stdout);
	return (0);
}	/* SlurpProgress */



static int
SlurpAll(int fd)
{
	char *newbuf;
	size_t ntoread;
	ssize_t nread;

	printf("%s%s%s.\n", gAction, gTarget[0] ? " " : "", gTarget);
	fflush(stdout);

	for(;;) {
		if (gNBufUsed == (gNBufAllocated - 1)) {
			if ((newbuf = (char *) realloc(gBuf, gNBufAllocated + TEXT_BLOCK_SIZE)) == NULL) {
				perror("ccdv: realloc");
				return (-1);
			}
			gNBufAllocated += TEXT_BLOCK_SIZE;
			gBuf = newbuf;
		}
		ntoread = (gNBufAllocated - gNBufUsed - 1);
		nread = read(fd, gBuf + gNBufUsed, ntoread);
		if (nread < 0) {
			if (errno == EINTR)
				continue;
			perror("ccdv: read");
			return (-1);
		} else if (nread == 0) {
			break;
		}
		gNBufUsed += nread;
		gBuf[gNBufUsed] = '\0';
	}
	Wait();
	gDumpCmdArgs = (gExitStatus != 0);	/* print cmd when there are errors */
	return (0);
}	/* SlurpAll */



static const char *
Basename(const char *path)
{
	const char *cp;
	cp = strrchr(path, '/');
	if (cp == NULL)
		return (path);
	return (cp + 1);
}	/* Basename */



static const char *
Extension(const char *path)
{
	const char *cp = path;
	cp = strrchr(path, '.');
	if (cp == NULL)
		return ("");
	return (cp);
}	/* Extension */



static void
Usage(void)
{
	fprintf(stderr, "Usage: ccdv /path/to/cc CFLAGS...\n\n");
	fprintf(stderr, "I wrote this to reduce the deluge Make output to make finding actual problems\n");
	fprintf(stderr, "easier.  It is intended to be invoked from Makefiles, like this.  Instead of:\n\n");
	fprintf(stderr, "\t.c.o:\n");
	fprintf(stderr, "\t\t$(CC) $(CFLAGS) $(DEFS) $(CPPFLAGS) $< -c\n");
	fprintf(stderr, "\nRewrite your rule so it looks like:\n\n");
	fprintf(stderr, "\t.c.o:\n");
	fprintf(stderr, "\t\t@ccdv $(CC) $(CFLAGS) $(DEFS) $(CPPFLAGS) $< -c\n\n");
	fprintf(stderr, "ccdv 1.1.0 is Free under the GNU Public License.  Enjoy!\n");
	fprintf(stderr, "  -- Mike Gleason, NcFTP Software <http://www.ncftp.com>\n");
	exit(96);
}	/* Usage */



int
main(int argc, char **argv)
{
	int pipe1[2];
	int devnull;
	char emerg[256];
	int fd;
	int nread;
	int i;
	int cc = 0, pch = 0;
	const char *quote;

	if (argc < 2)
		Usage();

	snprintf(gAction, sizeof(gAction), "Running %s", Basename(argv[1]));
	memset(gArgsStr, 0, sizeof(gArgsStr));
	for (i = 1; i < argc; i++) {
		quote = (strchr(argv[i], ' ') != NULL) ? "\"" : "";
		snprintf(gArgsStr + strlen(gArgsStr), sizeof(gArgsStr) - strlen(gArgsStr), "%s%s%s%s%s", (i == 1) ? "" : " ", quote, argv[i], quote, (i == (argc - 1)) ? "\n" : "");
		if ((strcmp(argv[i], "-o") == 0) && ((i + 1) < argc)) {
			if (strcasecmp(Extension(argv[i + 1]), ".o") != 0) {
				strcpy(gAction, "Linking");
				snprintf(gTarget, sizeof(gTarget), "%s", Basename(argv[i + 1]));
			}
		} else if (strchr("-+/", (int) argv[i][0]) != NULL) {
			continue;
		} else if (strncasecmp(Extension(argv[i]), ".c", 2) == 0) {
			cc++;
			snprintf(gTarget, sizeof(gTarget), "%s", Basename(argv[i]));
		} else if ((strncasecmp(Extension(argv[i]), ".h", 2) == 0) && (cc == 0)) {
			pch++;
			snprintf(gTarget, sizeof(gTarget), "%s", Basename(argv[i]));
		} else if ((i == 1) && (strcmp(Basename(argv[i]), "ar") == 0)) {
			snprintf(gAr, sizeof(gAr), "%s", Basename(argv[i]));
		} else if ((gArLibraryTarget[0] == '\0') && (strcasecmp(Extension(argv[i]), ".a") == 0)) {
			snprintf(gArLibraryTarget, sizeof(gArLibraryTarget), "%s", Basename(argv[i]));
		}
	}
	if ((gAr[0] != '\0') && (gArLibraryTarget[0] != '\0')) {
		strcpy(gAction, "Creating library");
		snprintf(gTarget, sizeof(gTarget), "%s", gArLibraryTarget);
	} else if (pch > 0) {
		strcpy(gAction, "Precompiling");
	} else if (cc > 0) {
		strcpy(gAction, "Compiling");
	}

	if (pipe(pipe1) < 0) {
		perror("ccdv: pipe");
		exit(97);
	}

	(void) close(0);
	devnull = open("/dev/null", O_RDWR, 00666);
	if ((devnull != 0) && (dup2(devnull, 0) == 0))
		close(devnull);

	gCCPID = (int) fork();
	if (gCCPID < 0) {
		(void) close(pipe1[0]);
		(void) close(pipe1[1]);
		perror("ccdv: fork");
		exit(98);
	} else if (gCCPID == 0) {
		/* Child */
		(void) close(pipe1[0]);		/* close read end */
		if (pipe1[1] != 1) {		/* use write end on stdout */
			(void) dup2(pipe1[1], 1);
			(void) close(pipe1[1]);
		}
		(void) dup2(1, 2);		/* use write end on stderr */
		execvp(argv[1], argv + 1);
		perror(argv[1]);
		exit(99);
	}

	/* parent */
	(void) close(pipe1[1]);		/* close write end */
	fd = pipe1[0];			/* use read end */

	gColumns = (getenv("COLUMNS") != NULL) ? atoi(getenv("COLUMNS")) : 80;
	gANSIEscapes = (getenv("TERM") != NULL) && (strstr(TERMS, getenv("TERM")) != NULL);
	gBuf = (char *) malloc(TEXT_BLOCK_SIZE);
	if (gBuf == NULL) 
		goto panic;
	gNBufUsed = 0;
	gNBufAllocated = TEXT_BLOCK_SIZE;
	if (strlen(gArgsStr) < (gNBufAllocated - 1)) {
		strcpy(gBuf, gArgsStr);
		gNBufUsed = strlen(gArgsStr);
	}

	if (isatty(1)) {
		if (SlurpProgress(fd) < 0)
			goto panic;
	} else {
		if (SlurpAll(fd) < 0)
			goto panic;
	}
	DumpFormattedOutput();
	exit(gExitStatus);

panic:
	gDumpCmdArgs = 1;	/* print cmd when there are errors */
	DumpFormattedOutput();
	while ((nread = read(fd, emerg, (size_t) sizeof(emerg))) > 0)
		(void) write(2, emerg, (size_t) nread);
	Wait();
	exit(gExitStatus);
}	/* main */
/* eof ccdv.c */
EOF
		${CC-cc} $DEFS $CPPFLAGS $CFLAGS "ccdv.c" -o "ccdv" >/dev/null 2>&1
	rm -f ccdv.c ccdv.o ccdv.c.gz.uu ccdv.c.gz
	strip ./ccdv >/dev/null 2>&1
	./ccdv >/dev/null 2>&1
	if test $? -eq 96 ; then
		CCDV="./ccdv"
	else
		rm -f ccdv
	fi
fi
if test "x$CCDV" != x ; then
	

wi_path="$CCDV"
if test -d "$wi_path" ; then
	wi_resolved_path=`cd "$wi_path" ; $wi_PWD 2>/dev/null`
elif test ! -f "$wi_path" ; then
	wi_resolved_path="$wi_path"
else
	wi_parent_dir="$wi_path"
	wi_file_name="$wi_path"
	
wi_parent_dir=`echo "$wi_parent_dir" | sed -n '
s-//*-/-g
s-/*$--
/^\/\/*[^/]*$/{
	c\\
/
	p
	q
}
/^[^/]*$/{
	c\\
.
	p
	q
}
/./{
	s-/[^/]*$--
	p
	q
}'`
	
wi_file_name=`echo "$wi_file_name" | sed -n '
s-//*-/-g
s-/*$--
s-^/$--
s-^.*/--
p
q'`
	wi_resolved_path=`cd "$wi_parent_dir" ; $wi_PWD 2>/dev/null`
	if test "x$wi_resolved_path" != x ; then
		wi_resolved_path="$wi_resolved_path/$wi_file_name"
	fi
	unset wi_parent_dir wi_file_name
fi
if test "x$wi_resolved_path" = x ; then
	CCDV="$$CCDV"
else
	CCDV="$wi_resolved_path"
fi
unset wi_resolved_path wi_path

	wi_cv_path_ccdv="$CCDV"
	CCDV="@$CCDV "	# trailing space needed
else
	wi_cv_path_ccdv=""
fi

fi

echo "$ac_t""$wi_cv_path_ccdv" 1>&6
if test "$wi_used_cache_path_ccdv" = yes ; then
	CCDV="$wi_cv_path_ccdv"
	if test "x$CCDV" != x ; then
		CCDV="@$CCDV "	# trailing space needed
	fi
fi

fi


if test "x$mandir" = 'x${prefix}/man' ; then
	# Mandir is at default value -- try to see
	# if $prefix/share/man would be better.
	#

	# $prefix is probably set to NONE.
	#
	p=`cd / ; cd $prefix 2>/dev/null ; pwd`
	if test "x$p" = "x/" ; then
		p="/usr/local"
	fi
	if test -d "$p/share/man" ; then
		mandir="$p/share/man"
	fi
fi


echo $ac_n "checking if shell can test for symlinks""... $ac_c" 1>&6
echo "configure:11997: checking if shell can test for symlinks" >&5
if eval "test \"`echo '$''{'wi_cv_shell_test_symlinks'+set}'`\" = set"; then
  echo $ac_n "(cached) $ac_c" 1>&6
else
  
wi_cv_shell_test_symlinks="no"
wi_cv_test_L="false"
wi_cv_test_not_L=":"
rm -f config.lnk
if test ! -f "config.lnk" ; then
	ln -s /bin/sh${ac_exeext} config.lnk
	if test -f "config.lnk" ; then
		( if test -L config.lnk ; then rm -f config.lnk ; fi ) 2>/dev/null
		if test ! -f "config.lnk" ; then
			wi_cv_shell_test_symlinks="yes"
			wi_cv_test_L='test -L'
			wi_cv_test_not_L='test ! -L'
		else
			( if test -h config.lnk ; then rm -f config.lnk ; fi ) 2>/dev/null
			if test ! -f "config.lnk" ; then
				wi_cv_shell_test_symlinks="yes"
				wi_cv_test_L='test -h'
				wi_cv_test_not_L='test ! -h'
			fi
		fi
	fi
	rm -f config.lnk
fi

fi

echo "$ac_t""$wi_cv_shell_test_symlinks" 1>&6
test_L="$wi_cv_test_L"
test_not_L="$wi_cv_test_not_L"



h_file="libncftp/ncftp.h"
if test -f "$h_file" && $test_not_L "$h_file" ; then
	h_tmp=`echo "$h_file" | sed 's/\.h/.tmp/;'`
	longest_int_subst="${LONGEST_INT-long}"
	if sed 's!\ */\*\ set\ by\ configure\ at\ .*\*/!!' "$h_file" > "$h_tmp" ; then
		touch -r "$h_file" "$h_tmp"
		if cmp -s "$h_file" "$h_tmp" ; then
			:
		else
			/bin/mv "$h_tmp" "$h_file"
			chmod a+r "$h_file"
		fi
	fi
	if sed 's/^#define longest_int.*/#define longest_int '"$longest_int_subst"'/;s/^#define longest_uint.*/#define longest_uint unsigned '"$longest_int_subst"'/;' "$h_file" > "$h_tmp" ; then
		if cmp -s "$h_file" "$h_tmp" ; then
			datestr=`date '+%Y-%m-%d %H:%M:%S'`
			sed '/^#define longest_u?int/{s!$!    /* set by configure at '"${datestr}"' */!;}' "$h_tmp" > "$h_file"
			unset datestr
			/bin/rm -f "$h_tmp"
			chmod a+r "$h_file"
		fi
	fi
	/bin/rm -f "$h_tmp"
	unset h_tmp longest_int_subst
fi
unset h_file



h_file="libncftp/ncftp.h"
if test -f "$h_file" && $test_not_L "$h_file" ; then
	h_tmp=`echo "$h_file" | sed 's/\.h/.tmp/;'`
	if sed 's!\ */\*\ set\ by\ configure\ at\ .*\*/!!' "$h_file" > "$h_tmp" ; then
		touch -r "$h_file" "$h_tmp"
		if cmp -s "$h_file" "$h_tmp" ; then
			:
		else
			/bin/mv "$h_tmp" "$h_file"
			chmod a+r "$h_file"
		fi
	fi
	if test "x$wi_cv_struct_stat64" = xyes ; then
		if sed 's/^#define Stat .*/#define Stat stat64/;s/^#define Lstat .*/#define Lstat lstat64/;s/^#define Fstat .*/#define Fstat fstat64/;' "$h_file" > "$h_tmp" ; then
			if cmp -s "$h_file" "$h_tmp" ; then
				:
			else
				datestr=`date '+%Y-%m-%d %H:%M:%S'`
				sed '/^#define [SLFs]*tat /{s!$!    /* set by configure at '"${datestr}"' */!;}' "$h_tmp" > "$h_file"
				unset datestr
				/bin/rm -f "$h_tmp"
				chmod a+r "$h_file"
			fi
		fi
	else
		if sed 's/^#define Stat .*/#define Stat stat/;s/^#define Lstat .*/#define Lstat lstat/;s/^#define Fstat .*/#define Fstat fstat/;' "$h_file" > "$h_tmp" ; then
			if cmp -s "$h_file" "$h_tmp" ; then
				:
			else
				datestr=`date '+%Y-%m-%d %H:%M:%S'`
				sed '/^#define [SLFs]*tat /{s!$!    /* set by configure at '"${datestr}"' */!;}' "$h_tmp" > "$h_file"
				unset datestr
				/bin/rm -f "$h_tmp"
				chmod a+r "$h_file"
			fi
		fi
	fi
	/bin/rm -f "$h_tmp"
	unset h_tmp longest_int_subst
fi
unset h_file



h_file="libncftp/ncftp.h"
if test -f "$h_file" && $test_not_L "$h_file" ; then
	h_tmp=`echo "$h_file" | sed 's/\.h/.tmp/;'`

	remove_cpp_warning=yes
	if [ "$SYS" = linux ] ; then
		#
		# We need to retain #warning on Linux
		#
		remove_cpp_warning=no
	fi
	if [ "$GCC" = yes ] ; then
		#
		# GCC accepts #warning
		#
		remove_cpp_warning=no
	fi

	if [ "$remove_cpp_warning" = yes ] ; then
		#
		# Remove "#warning", since compiler will complain about it
		# not being recognized.
		#
		sed 's/^\([\ \	]*#[\ \	]*warning.*\)/\/* \1 *\//;' "$h_file" > "$h_tmp"
		cmp -s "$h_file" "$h_tmp"
		if test $? -ne 0 ; then 
			mv "$h_tmp" "$h_file"
			chmod a+r "$h_file"
		fi
		rm -f "$h_tmp"
		unset h_tmp longest_int_subst
	fi
fi
unset h_file remove_cpp_warning

LIBSET='$(LIB)'
Z30='#'
case "$HOME" in
	*lcompile*)
		;;
	*)
		if test -x /usr/local/bin/incrementor ; then
			Z30='	-@/usr/local/bin/incrementor -b -f version.c -f version.o'
		fi
		;;
esac


wi_path="$srcdir"
if test -d "$wi_path" ; then
	wi_resolved_path=`cd "$wi_path" ; $wi_PWD 2>/dev/null`
elif test ! -f "$wi_path" ; then
	wi_resolved_path="$wi_path"
else
	wi_parent_dir="$wi_path"
	wi_file_name="$wi_path"
	
wi_parent_dir=`echo "$wi_parent_dir" | sed -n '
s-//*-/-g
s-/*$--
/^\/\/*[^/]*$/{
	c\\
/
	p
	q
}
/^[^/]*$/{
	c\\
.
	p
	q
}
/./{
	s-/[^/]*$--
	p
	q
}'`
	
wi_file_name=`echo "$wi_file_name" | sed -n '
s-//*-/-g
s-/*$--
s-^/$--
s-^.*/--
p
q'`
	wi_resolved_path=`cd "$wi_parent_dir" ; $wi_PWD 2>/dev/null`
	if test "x$wi_resolved_path" != x ; then
		wi_resolved_path="$wi_resolved_path/$wi_file_name"
	fi
	unset wi_parent_dir wi_file_name
fi
if test "x$wi_resolved_path" = x ; then
	MAINDIR="$$srcdir"
else
	MAINDIR="$wi_resolved_path"
fi
unset wi_resolved_path wi_path



wi_path="$MAINDIR/libncftp/ncftp.h"
if test -d "$wi_path" ; then
	wi_resolved_path=`cd "$wi_path" ; $wi_PWD 2>/dev/null`
elif test ! -f "$wi_path" ; then
	wi_resolved_path="$wi_path"
else
	wi_parent_dir="$wi_path"
	wi_file_name="$wi_path"
	
wi_parent_dir=`echo "$wi_parent_dir" | sed -n '
s-//*-/-g
s-/*$--
/^\/\/*[^/]*$/{
	c\\
/
	p
	q
}
/^[^/]*$/{
	c\\
.
	p
	q
}
/./{
	s-/[^/]*$--
	p
	q
}'`
	
wi_file_name=`echo "$wi_file_name" | sed -n '
s-//*-/-g
s-/*$--
s-^/$--
s-^.*/--
p
q'`
	wi_resolved_path=`cd "$wi_parent_dir" ; $wi_PWD 2>/dev/null`
	if test "x$wi_resolved_path" != x ; then
		wi_resolved_path="$wi_resolved_path/$wi_file_name"
	fi
	unset wi_parent_dir wi_file_name
fi
if test "x$wi_resolved_path" = x ; then
	libncftp_h="$$MAINDIR/libncftp/ncftp.h"
else
	libncftp_h="$wi_resolved_path"
fi
unset wi_resolved_path wi_path


libncftp_h=`echo "$libncftp_h" | sed -n '
s-//*-/-g
s-/*$--
/^\/\/*[^/]*$/{
	c\\
/
	p
	q
}
/^[^/]*$/{
	c\\
.
	p
	q
}
/./{
	s-/[^/]*$--
	p
	q
}'`


wi_path="$MAINDIR/sio/sio.h"
if test -d "$wi_path" ; then
	wi_resolved_path=`cd "$wi_path" ; $wi_PWD 2>/dev/null`
elif test ! -f "$wi_path" ; then
	wi_resolved_path="$wi_path"
else
	wi_parent_dir="$wi_path"
	wi_file_name="$wi_path"
	
wi_parent_dir=`echo "$wi_parent_dir" | sed -n '
s-//*-/-g
s-/*$--
/^\/\/*[^/]*$/{
	c\\
/
	p
	q
}
/^[^/]*$/{
	c\\
.
	p
	q
}
/./{
	s-/[^/]*$--
	p
	q
}'`
	
wi_file_name=`echo "$wi_file_name" | sed -n '
s-//*-/-g
s-/*$--
s-^/$--
s-^.*/--
p
q'`
	wi_resolved_path=`cd "$wi_parent_dir" ; $wi_PWD 2>/dev/null`
	if test "x$wi_resolved_path" != x ; then
		wi_resolved_path="$wi_resolved_path/$wi_file_name"
	fi
	unset wi_parent_dir wi_file_name
fi
if test "x$wi_resolved_path" = x ; then
	sio_h="$$MAINDIR/sio/sio.h"
else
	sio_h="$wi_resolved_path"
fi
unset wi_resolved_path wi_path


sio_h=`echo "$sio_h" | sed -n '
s-//*-/-g
s-/*$--
/^\/\/*[^/]*$/{
	c\\
/
	p
	q
}
/^[^/]*$/{
	c\\
.
	p
	q
}
/./{
	s-/[^/]*$--
	p
	q
}'`


wi_path="$MAINDIR/Strn/Strn.h"
if test -d "$wi_path" ; then
	wi_resolved_path=`cd "$wi_path" ; $wi_PWD 2>/dev/null`
elif test ! -f "$wi_path" ; then
	wi_resolved_path="$wi_path"
else
	wi_parent_dir="$wi_path"
	wi_file_name="$wi_path"
	
wi_parent_dir=`echo "$wi_parent_dir" | sed -n '
s-//*-/-g
s-/*$--
/^\/\/*[^/]*$/{
	c\\
/
	p
	q
}
/^[^/]*$/{
	c\\
.
	p
	q
}
/./{
	s-/[^/]*$--
	p
	q
}'`
	
wi_file_name=`echo "$wi_file_name" | sed -n '
s-//*-/-g
s-/*$--
s-^/$--
s-^.*/--
p
q'`
	wi_resolved_path=`cd "$wi_parent_dir" ; $wi_PWD 2>/dev/null`
	if test "x$wi_resolved_path" != x ; then
		wi_resolved_path="$wi_resolved_path/$wi_file_name"
	fi
	unset wi_parent_dir wi_file_name
fi
if test "x$wi_resolved_path" = x ; then
	strn_h="$$MAINDIR/Strn/Strn.h"
else
	strn_h="$wi_resolved_path"
fi
unset wi_resolved_path wi_path


strn_h=`echo "$strn_h" | sed -n '
s-//*-/-g
s-/*$--
/^\/\/*[^/]*$/{
	c\\
/
	p
	q
}
/^[^/]*$/{
	c\\
.
	p
	q
}
/./{
	s-/[^/]*$--
	p
	q
}'`
CPPFLAGS="-I${MAINDIR} -I${libncftp_h} -I${sio_h} -I${strn_h} $CPPFLAGS"
LDFLAGS="-L${libncftp_h} -L${sio_h} -L${strn_h} $LDFLAGS"

LIBS=`echo "$LIBS" | sed 's/^ *//;s/ *$//;s/  */ /g'`
LDFLAGS=`echo "$LDFLAGS" | sed 's/^ *//;s/ *$//;s/  */ /g'`
CPPFLAGS=`echo "$CPPFLAGS" | sed 's/^ *//;s/ *$//;s/  */ /g'`
CFLAGS=`echo "$CFLAGS $wi_CFLAGS_TO_ADD_LATER" | sed 's/^ *//;s/ *$//;s/  */ /g'`
DEFS=`echo "$DEFS" | sed 's/^ *//;s/ *$//;s/  */ /g'`




LIBNCFTP_PRECOMP="libncftp/pch.mk.none"
SIO_PRECOMP="sio/pch.mk.none"
if test "${wi_cv_cc_precomp}_${wi_cv_cc_precomp_type}" = "yes_gcc_gch_files" ; then
	LIBNCFTP_PRECOMP="libncftp/pch.mk.gcc-gch"
	SIO_PRECOMP="sio/pch.mk.gcc-gch"
elif test "${wi_cv_cc_precomp}_${SYS}" = "yes_macosx" ; then
	LIBNCFTP_PRECOMP="libncftp/pch.mk.$SYS"
	SIO_PRECOMP="sio/pch.mk.$SYS"
fi





LIBNCFTP_VERSION=`sed -n '/kLibraryVersion/{
	s/^[^0-9]*//
	s/\ .*$//
	p
	q
}' libncftp/ncftp.h`

NCFTP_VERSION=`sed -n '/gVersion\[\]/{
	s/^[^0-9]*//
	s/\/.*$//
	p
	q
}' ncftp/version.c`

SIO_VERSION=`sed -n '/kSioVersion/{
	s/^[^0-9]*//
	s/\ .*$//
	p
	q
}' sio/sio.h`

STRN_VERSION=`sed -n '/gStrnLibVersion\[\]/{
	s/^[^0-9]*//
	s/\".*$//
	p
	q
}' Strn/Strncpy.c`


echo $ac_n "checking CC""... $ac_c" 1>&6
echo "configure:12480: checking CC" >&5
echo "$ac_t""$CC" 1>&6
echo $ac_n "checking CFLAGS""... $ac_c" 1>&6
echo "configure:12483: checking CFLAGS" >&5
echo "$ac_t""$CFLAGS" 1>&6
echo $ac_n "checking CPPFLAGS""... $ac_c" 1>&6
echo "configure:12486: checking CPPFLAGS" >&5
echo "$ac_t""$CPPFLAGS" 1>&6
echo $ac_n "checking DEFS""... $ac_c" 1>&6
echo "configure:12489: checking DEFS" >&5
echo "$ac_t""$DEFS" 1>&6
echo $ac_n "checking NDEFS""... $ac_c" 1>&6
echo "configure:12492: checking NDEFS" >&5
echo "$ac_t""$NDEFS" 1>&6
echo $ac_n "checking LDFLAGS""... $ac_c" 1>&6
echo "configure:12495: checking LDFLAGS" >&5
echo "$ac_t""$LDFLAGS" 1>&6
echo $ac_n "checking LIBS""... $ac_c" 1>&6
echo "configure:12498: checking LIBS" >&5
echo "$ac_t""$LIBS" 1>&6
#
# Also take the opportunity to do some post-configure clean-up
#
/bin/rm -rf "conftest.dSYM" "a.out"




















trap '' 1 2 15
cat > confcache <<\EOF
# This file is a shell script that caches the results of configure
# tests run on this system so they can be shared between configure
# scripts and configure runs.  It is not useful on other systems.
# If it contains results you don't want to keep, you may remove or edit it.
#
# By default, configure uses ./config.cache as the cache file,
# creating it if it does not exist already.  You can give configure
# the --cache-file=FILE option to use a different cache file; that is
# what configure does when it calls configure scripts in
# subdirectories, so they share the cache.
# Giving --cache-file=/dev/null disables caching, for debugging configure.
# config.status only pays attention to the cache file if you give it the
# --recheck option to rerun configure.
#
EOF
# The following way of writing the cache mishandles newlines in values,
# but we know of no workaround that is simple, portable, and efficient.
# So, don't put newlines in cache variables' values.
# Ultrix sh set writes to stderr and can't be redirected directly,
# and sets the high bit in the cache file unless we assign to the vars.
(set) 2>&1 |
  case `(ac_space=' '; set | grep ac_space) 2>&1` in
  *ac_space=\ *)
    # `set' does not quote correctly, so add quotes (double-quote substitution
    # turns \\\\ into \\, and sed turns \\ into \).
    sed -n \
      -e "s/'/'\\\\''/g" \
      -e "s/^\\([a-zA-Z0-9_]*_cv_[a-zA-Z0-9_]*\\)=\\(.*\\)/\\1=\${\\1='\\2'}/p"
    ;;
  *)
    # `set' quotes correctly as required by POSIX, so do not add quotes.
    sed -n -e 's/^\([a-zA-Z0-9_]*_cv_[a-zA-Z0-9_]*\)=\(.*\)/\1=${\1=\2}/p'
    ;;
  esac >> confcache
if cmp -s $cache_file confcache; then
  :
else
  if test -w $cache_file; then
    echo "updating cache $cache_file"
    cat confcache > $cache_file
  else
    echo "not updating unwritable cache $cache_file"
  fi
fi
rm -f confcache

trap 'rm -fr conftest* confdefs* core core.* *.core $ac_clean_files; exit 1' 1 2 15

test "x$prefix" = xNONE && prefix=$ac_default_prefix
# Let make expand exec_prefix.
test "x$exec_prefix" = xNONE && exec_prefix='${prefix}'

# Any assignment to VPATH causes Sun make to only execute
# the first set of double-colon rules, so remove it if not needed.
# If there is a colon in the path, we need to keep it.
if test "x$srcdir" = x.; then
  ac_vpsub='/^[ 	]*VPATH[ 	]*=[^:]*$/d'
fi

trap 'rm -f $CONFIG_STATUS conftest*; exit 1' 1 2 15

DEFS=-DHAVE_CONFIG_H

# Without the "./", some shells look in PATH for config.status.
: ${CONFIG_STATUS=./config.status}

echo creating $CONFIG_STATUS
rm -f $CONFIG_STATUS
cat > $CONFIG_STATUS <<EOF
#! /bin/sh
# Generated automatically by configure.
# Run this file to recreate the current configuration.
# This directory was configured as follows,
# on host `(hostname || uname -n) 2>/dev/null | sed 1q`:
#
# $0 $ac_configure_args
#
# Compiler output produced by configure, useful for debugging
# configure, is in ./config.log if it exists.

ac_cs_usage="Usage: $CONFIG_STATUS [--recheck] [--version] [--help]"
for ac_option
do
  case "\$ac_option" in
  -recheck | --recheck | --rechec | --reche | --rech | --rec | --re | --r)
    echo "running \${CONFIG_SHELL-/bin/sh} $0 $ac_configure_args --no-create --no-recursion"
    exec \${CONFIG_SHELL-/bin/sh} $0 $ac_configure_args --no-create --no-recursion ;;
  -version | --version | --versio | --versi | --vers | --ver | --ve | --v)
    echo "$CONFIG_STATUS generated by autoconf version 2.13"
    exit 0 ;;
  -help | --help | --hel | --he | --h)
    echo "\$ac_cs_usage"; exit 0 ;;
  *) echo "\$ac_cs_usage"; exit 1 ;;
  esac
done

ac_given_srcdir=$srcdir
ac_given_INSTALL="$INSTALL"

trap 'rm -fr `echo "Makefile Makefile.bin ncftp/Makefile libncftp/Makefile Strn/Makefile sio/Makefile sh_util/Makefile vis/Makefile config.h" | sed "s/:[^ ]*//g"` conftest*; exit 1' 1 2 15
EOF
cat >> $CONFIG_STATUS <<EOF

# Protect against being on the right side of a sed subst in config.status.
sed 's/%@/@@/; s/@%/@@/; s/%g\$/@g/; /@g\$/s/[\\\\&%]/\\\\&/g;
 s/@@/%@/; s/@@/@%/; s/@g\$/%g/' > conftest.subs <<\\CEOF
$ac_vpsub
$extrasub
s%@SHELL@%$SHELL%g
s%@CFLAGS@%$CFLAGS%g
s%@CPPFLAGS@%$CPPFLAGS%g
s%@CXXFLAGS@%$CXXFLAGS%g
s%@FFLAGS@%$FFLAGS%g
s%@DEFS@%$DEFS%g
s%@LDFLAGS@%$LDFLAGS%g
s%@LIBS@%$LIBS%g
s%@exec_prefix@%$exec_prefix%g
s%@prefix@%$prefix%g
s%@program_transform_name@%$program_transform_name%g
s%@bindir@%$bindir%g
s%@sbindir@%$sbindir%g
s%@libexecdir@%$libexecdir%g
s%@datadir@%$datadir%g
s%@sysconfdir@%$sysconfdir%g
s%@sharedstatedir@%$sharedstatedir%g
s%@localstatedir@%$localstatedir%g
s%@libdir@%$libdir%g
s%@includedir@%$includedir%g
s%@oldincludedir@%$oldincludedir%g
s%@infodir@%$infodir%g
s%@mandir@%$mandir%g
s%@NDEFS@%$NDEFS%g
s%@OS@%$OS%g
s%@host@%$host%g
s%@SYS@%$SYS%g
s%@HOME_OS@%$HOME_OS%g
s%@CC@%$CC%g
s%@CPP@%$CPP%g
s%@STRIP@%$STRIP%g
s%@OBJEXT@%$OBJEXT%g
s%@EXEEXT@%$EXEEXT%g
s%@SIO_OBJS_U@%$SIO_OBJS_U%g
s%@SIO_SOBJS_U@%$SIO_SOBJS_U%g
s%@SOCKS_LIBS@%$SOCKS_LIBS%g
s%@LIBCURSES@%$LIBCURSES%g
s%@PERL@%$PERL%g
s%@MKTEMP@%$MKTEMP%g
s%@ALLOCA@%$ALLOCA%g
s%@SET_MAKE@%$SET_MAKE%g
s%@TAR@%$TAR%g
s%@TARFLAGS@%$TARFLAGS%g
s%@RANLIB@%$RANLIB%g
s%@AR@%$AR%g
s%@INSTALL_PROGRAM@%$INSTALL_PROGRAM%g
s%@INSTALL_SCRIPT@%$INSTALL_SCRIPT%g
s%@INSTALL_DATA@%$INSTALL_DATA%g
s%@wi_PWD@%$wi_PWD%g
s%@CCDV@%$CCDV%g
/@LIBNCFTP_PRECOMP@/r $LIBNCFTP_PRECOMP
s%@LIBNCFTP_PRECOMP@%%g
/@SIO_PRECOMP@/r $SIO_PRECOMP
s%@SIO_PRECOMP@%%g
s%@SFLAG@%$SFLAG%g
s%@MAKE@%$MAKE%g
s%@Z30@%$Z30%g
s%@LIBSET@%$LIBSET%g
s%@MAINDIR@%$MAINDIR%g
s%@NCFTP_VERSION@%$NCFTP_VERSION%g
s%@LIBNCFTP_VERSION@%$LIBNCFTP_VERSION%g
s%@SIO_VERSION@%$SIO_VERSION%g
s%@STRN_VERSION@%$STRN_VERSION%g
s%@VIS_DPROGS@%$VIS_DPROGS%g
s%@SIZEOF_OFF_T@%$SIZEOF_OFF_T%g
s%@SIZEOF_ST_SIZE@%$SIZEOF_ST_SIZE%g

CEOF
EOF

cat >> $CONFIG_STATUS <<\EOF

# Split the substitutions into bite-sized pieces for seds with
# small command number limits, like on Digital OSF/1 and HP-UX.
ac_max_sed_cmds=90 # Maximum number of lines to put in a sed script.
ac_file=1 # Number of current file.
ac_beg=1 # First line for current file.
ac_end=$ac_max_sed_cmds # Line after last line for current file.
ac_more_lines=:
ac_sed_cmds=""
while $ac_more_lines; do
  if test $ac_beg -gt 1; then
    sed "1,${ac_beg}d; ${ac_end}q" conftest.subs > conftest.s$ac_file
  else
    sed "${ac_end}q" conftest.subs > conftest.s$ac_file
  fi
  if test ! -s conftest.s$ac_file; then
    ac_more_lines=false
    rm -f conftest.s$ac_file
  else
    if test -z "$ac_sed_cmds"; then
      ac_sed_cmds="sed -f conftest.s$ac_file"
    else
      ac_sed_cmds="$ac_sed_cmds | sed -f conftest.s$ac_file"
    fi
    ac_file=`expr $ac_file + 1`
    ac_beg=$ac_end
    ac_end=`expr $ac_end + $ac_max_sed_cmds`
  fi
done
if test -z "$ac_sed_cmds"; then
  ac_sed_cmds=cat
fi
EOF

cat >> $CONFIG_STATUS <<EOF

CONFIG_FILES=\${CONFIG_FILES-"Makefile Makefile.bin ncftp/Makefile libncftp/Makefile Strn/Makefile sio/Makefile sh_util/Makefile vis/Makefile"}
EOF
cat >> $CONFIG_STATUS <<\EOF
for ac_file in .. $CONFIG_FILES; do if test "x$ac_file" != x..; then
  # Support "outfile[:infile[:infile...]]", defaulting infile="outfile.in".
  case "$ac_file" in
  *:*) ac_file_in=`echo "$ac_file"|sed 's%[^:]*:%%'`
       ac_file=`echo "$ac_file"|sed 's%:.*%%'` ;;
  *) ac_file_in="${ac_file}.in" ;;
  esac

  # Adjust a relative srcdir, top_srcdir, and INSTALL for subdirectories.

  # Remove last slash and all that follows it.  Not all systems have dirname.
  ac_dir=`echo $ac_file|sed 's%/[^/][^/]*$%%'`
  if test "$ac_dir" != "$ac_file" && test "$ac_dir" != .; then
    # The file is in a subdirectory.
    test ! -d "$ac_dir" && mkdir "$ac_dir"
    ac_dir_suffix="/`echo $ac_dir|sed 's%^\./%%'`"
    # A "../" for each directory in $ac_dir_suffix.
    ac_dots=`echo $ac_dir_suffix|sed 's%/[^/]*%../%g'`
  else
    ac_dir_suffix= ac_dots=
  fi

  case "$ac_given_srcdir" in
  .)  srcdir=.
      if test -z "$ac_dots"; then top_srcdir=.
      else top_srcdir=`echo $ac_dots|sed 's%/$%%'`; fi ;;
  /*) srcdir="$ac_given_srcdir$ac_dir_suffix"; top_srcdir="$ac_given_srcdir" ;;
  *) # Relative path.
    srcdir="$ac_dots$ac_given_srcdir$ac_dir_suffix"
    top_srcdir="$ac_dots$ac_given_srcdir" ;;
  esac

  case "$ac_given_INSTALL" in
  [/$]*) INSTALL="$ac_given_INSTALL" ;;
  *) INSTALL="$ac_dots$ac_given_INSTALL" ;;
  esac

  echo creating "$ac_file"
  rm -f "$ac_file"
  configure_input="Generated automatically from `echo $ac_file_in|sed 's%.*/%%'` by configure."
  case "$ac_file" in
  *Makefile*) ac_comsub="1i\\
# $configure_input" ;;
  *) ac_comsub= ;;
  esac

  ac_file_inputs=`echo $ac_file_in|sed -e "s%^%$ac_given_srcdir/%" -e "s%:% $ac_given_srcdir/%g"`
  sed -e "$ac_comsub
s%@configure_input@%$configure_input%g
s%@srcdir@%$srcdir%g
s%@top_srcdir@%$top_srcdir%g
s%@INSTALL@%$INSTALL%g
" $ac_file_inputs | (eval "$ac_sed_cmds") > $ac_file
fi; done
rm -f conftest.s*

# These sed commands are passed to sed as "A NAME B NAME C VALUE D", where
# NAME is the cpp macro being defined and VALUE is the value it is being given.
#
# ac_d sets the value in "#define NAME VALUE" lines.
ac_dA='s%^\([ 	]*\)#\([ 	]*define[ 	][ 	]*\)'
ac_dB='\([ 	][ 	]*\)[^ 	]*%\1#\2'
ac_dC='\3'
ac_dD='%g'
# ac_u turns "#undef NAME" with trailing blanks into "#define NAME VALUE".
ac_uA='s%^\([ 	]*\)#\([ 	]*\)undef\([ 	][ 	]*\)'
ac_uB='\([ 	]\)%\1#\2define\3'
ac_uC=' '
ac_uD='\4%g'
# ac_e turns "#undef NAME" without trailing blanks into "#define NAME VALUE".
ac_eA='s%^\([ 	]*\)#\([ 	]*\)undef\([ 	][ 	]*\)'
ac_eB='$%\1#\2define\3'
ac_eC=' '
ac_eD='%g'

if test "${CONFIG_HEADERS+set}" != set; then
EOF
cat >> $CONFIG_STATUS <<EOF
  CONFIG_HEADERS="config.h"
EOF
cat >> $CONFIG_STATUS <<\EOF
fi
for ac_file in .. $CONFIG_HEADERS; do if test "x$ac_file" != x..; then
  # Support "outfile[:infile[:infile...]]", defaulting infile="outfile.in".
  case "$ac_file" in
  *:*) ac_file_in=`echo "$ac_file"|sed 's%[^:]*:%%'`
       ac_file=`echo "$ac_file"|sed 's%:.*%%'` ;;
  *) ac_file_in="${ac_file}.in" ;;
  esac

  echo creating $ac_file

  rm -f conftest.frag conftest.in conftest.out
  ac_file_inputs=`echo $ac_file_in|sed -e "s%^%$ac_given_srcdir/%" -e "s%:% $ac_given_srcdir/%g"`
  cat $ac_file_inputs > conftest.in

EOF

# Transform confdefs.h into a sed script conftest.vals that substitutes
# the proper values into config.h.in to produce config.h.  And first:
# Protect against being on the right side of a sed subst in config.status.
# Protect against being in an unquoted here document in config.status.
rm -f conftest.vals
cat > conftest.hdr <<\EOF
s/[\\&%]/\\&/g
s%[\\$`]%\\&%g
s%#define \([A-Za-z_][A-Za-z0-9_]*\) *\(.*\)%${ac_dA}\1${ac_dB}\1${ac_dC}\2${ac_dD}%gp
s%ac_d%ac_u%gp
s%ac_u%ac_e%gp
EOF
sed -n -f conftest.hdr confdefs.h > conftest.vals
rm -f conftest.hdr

# This sed command replaces #undef with comments.  This is necessary, for
# example, in the case of _POSIX_SOURCE, which is predefined and required
# on some systems where configure will not decide to define it.
cat >> conftest.vals <<\EOF
s%^[ 	]*#[ 	]*undef[ 	][ 	]*[a-zA-Z_][a-zA-Z_0-9]*%/* & */%
EOF

# Break up conftest.vals because some shells have a limit on
# the size of here documents, and old seds have small limits too.

rm -f conftest.tail
while :
do
  ac_lines=`grep -c . conftest.vals`
  # grep -c gives empty output for an empty file on some AIX systems.
  if test -z "$ac_lines" || test "$ac_lines" -eq 0; then break; fi
  # Write a limited-size here document to conftest.frag.
  echo '  cat > conftest.frag <<CEOF' >> $CONFIG_STATUS
  sed ${ac_max_here_lines}q conftest.vals >> $CONFIG_STATUS
  echo 'CEOF
  sed -f conftest.frag conftest.in > conftest.out
  rm -f conftest.in
  mv conftest.out conftest.in
' >> $CONFIG_STATUS
  sed 1,${ac_max_here_lines}d conftest.vals > conftest.tail
  rm -f conftest.vals
  mv conftest.tail conftest.vals
done
rm -f conftest.vals

cat >> $CONFIG_STATUS <<\EOF
  rm -f conftest.frag conftest.h
  echo "/* $ac_file.  Generated automatically by configure.  */" > conftest.h
  cat conftest.in >> conftest.h
  rm -f conftest.in
  if cmp -s $ac_file conftest.h 2>/dev/null; then
    echo "$ac_file is unchanged"
    rm -f conftest.h
  else
    # Remove last slash and all that follows it.  Not all systems have dirname.
      ac_dir=`echo $ac_file|sed 's%/[^/][^/]*$%%'`
      if test "$ac_dir" != "$ac_file" && test "$ac_dir" != .; then
      # The file is in a subdirectory.
      test ! -d "$ac_dir" && mkdir "$ac_dir"
    fi
    rm -f $ac_file
    mv conftest.h $ac_file
  fi
fi; done

EOF
cat >> $CONFIG_STATUS <<EOF


EOF
cat >> $CONFIG_STATUS <<\EOF
/bin/rm -f ./ncftp/readln.o

exit 0
EOF
chmod +x $CONFIG_STATUS
rm -fr confdefs* $ac_clean_files
test "$no_create" = yes || ${CONFIG_SHELL-/bin/sh} $CONFIG_STATUS || exit 1

