# Customize Vaultwarden CSS

> [!IMPORTANT]
> **This functionality is only available in v1.33.0 and later releases.**

Since version v1.33.0 you can modify the CSS which Vaultwarden previously embedded in the web-vault.<br>
This way it makes it more easier for users to tweak the style and layout or even hide items.

To modify the CSS you need to add a `templates` directory in your `data` directory, or provide the correct path via the `TEMPLATES_FOLDER` environment variable.<br>
Within this directory you need to create another directory called `scss` which will hold the file(s) for modifying the stylesheet Vaultwarden will serve.


There are two files you can place here:
- **`user.vaultwarden.scss.hbs`**<br>
  This file is the file you want to edit and add your custom styles to.

- **`vaultwarden.scss.hbs`**<br>
  This file should not exist, since it will overwrite the built-in defaults.<br>
  _**Only override this if you really know what you are doing!**_

```tree
.
├── templates
│   └── scss
│       ├── user.vaultwarden.scss.hbs
│       └── vaultwarden.scss.hbs
```



**Some examples which you can place inside `user.vaultwarden.scss.hbs`:**
```css
/* Hide `Authenticator app` 2FA */
.providers-2fa-0 {
  @extend %vw-hide;
}

/* Hide `YubiKey OTP security key` 2FA */
/* Note: This will also be hidden automatically if the Yubikey config is net set */
.providers-2fa-3 {
  @extend %vw-hide;
}

/* Hide `Duo` 2FA */
.providers-2fa-2 {
  @extend %vw-hide;
}

/* Hide `FIDO2 WebAuthn` 2FA */
.providers-2fa-7 {
  @extend %vw-hide;
}

/* Hide `Email` 2FA */
/* Note: This will also be hidden automatically if email is not enabled */
.providers-2fa-1 {
  @extend %vw-hide;
}

/* Use a custom login logo */
app-root img.new-logo-themed {
	content: url(../images/my-custom-login.logo.png) !important;
}

/* Use a custom top left logo on login and locked screen page */
auth-anon-layout > main > a > bit-icon > svg {
  display: none !important;
}
auth-anon-layout > main > a > bit-icon::before {
  display: block;
  content: "" !important;
  width: 175px !important;
  height: 36px !important;
  background-image: url(../images/my-custom-global-logo.png) !important;
  background-repeat: no-repeat !important;
  background-size: contain;
}

/* Use a custom top left logo different per vault/admin */
app-user-layout bit-nav-logo bit-icon > svg,
app-organization-layout bit-nav-logo bit-icon > svg {
  display: none !important;
}
app-user-layout bit-nav-logo bit-icon::before,
app-organization-layout bit-nav-logo bit-icon::before {
  display: block;
  content: "" !important;
  width: 200px !important;
  height: 50px !important;
  background-repeat: no-repeat !important;
  background-size: contain;
}
app-user-layout bit-nav-logo bit-icon::before {
  background-image: url(../images/my-custom-password-manager-logo.png) !important;
}
app-organization-layout bit-nav-logo bit-icon::before {
  background-image: url(../images/my-custom-admin-console-logo.png) !important;
}
```

**Non scrolling search filter: (tested with 'Stylus' browser extension)**
```css
/*
Make the "Filter" box fixed, so only the list of entries is scrolling.
Allow to always see what you filtered for and quickly access the search filter without scrolling back to the top.
*/
#main-content > app-vault > .tw-flex .tw-basis-1\/4
{
    position: fixed;
    width: calc(25% - 55px);
}

#main-content > app-vault > .tw-flex .tw-basis-3\/4
{
    position: relative;
    left: calc(25% + 10px);
}
```