package yundun_ds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDepartCounts invokes the yundun_ds.DescribeDepartCounts API synchronously
// api document: https://help.aliyun.com/api/yundun-ds/describedepartcounts.html
func (client *Client) DescribeDepartCounts(request *DescribeDepartCountsRequest) (response *DescribeDepartCountsResponse, err error) {
	response = CreateDescribeDepartCountsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDepartCountsWithChan invokes the yundun_ds.DescribeDepartCounts API asynchronously
// api document: https://help.aliyun.com/api/yundun-ds/describedepartcounts.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDepartCountsWithChan(request *DescribeDepartCountsRequest) (<-chan *DescribeDepartCountsResponse, <-chan error) {
	responseChan := make(chan *DescribeDepartCountsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDepartCounts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDepartCountsWithCallback invokes the yundun_ds.DescribeDepartCounts API asynchronously
// api document: https://help.aliyun.com/api/yundun-ds/describedepartcounts.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeDepartCountsWithCallback(request *DescribeDepartCountsRequest, callback func(response *DescribeDepartCountsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDepartCountsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDepartCounts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDepartCountsRequest is the request struct for api DescribeDepartCounts
type DescribeDepartCountsRequest struct {
	*requests.RpcRequest
	TypeCode    string           `position:"Query" name:"TypeCode"`
	DepartName  string           `position:"Query" name:"DepartName"`
	SourceIp    string           `position:"Query" name:"SourceIp"`
	FeatureType requests.Integer `position:"Query" name:"FeatureType"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	Lang        string           `position:"Query" name:"Lang"`
}

// DescribeDepartCountsResponse is the response struct for api DescribeDepartCounts
type DescribeDepartCountsResponse struct {
	*responses.BaseResponse
	RequestId   string        `json:"RequestId" xml:"RequestId"`
	PageSize    int           `json:"PageSize" xml:"PageSize"`
	CurrentPage int           `json:"CurrentPage" xml:"CurrentPage"`
	TotalCount  int           `json:"TotalCount" xml:"TotalCount"`
	Items       []DepartCount `json:"Items" xml:"Items"`
}

// CreateDescribeDepartCountsRequest creates a request to invoke DescribeDepartCounts API
func CreateDescribeDepartCountsRequest() (request *DescribeDepartCountsRequest) {
	request = &DescribeDepartCountsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Yundun-ds", "2019-01-03", "DescribeDepartCounts", "sddp", "openAPI")
	return
}

// CreateDescribeDepartCountsResponse creates a response to parse from DescribeDepartCounts response
func CreateDescribeDepartCountsResponse() (response *DescribeDepartCountsResponse) {
	response = &DescribeDepartCountsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
