package rtc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteAutoLiveStreamRule invokes the rtc.DeleteAutoLiveStreamRule API synchronously
func (client *Client) DeleteAutoLiveStreamRule(request *DeleteAutoLiveStreamRuleRequest) (response *DeleteAutoLiveStreamRuleResponse, err error) {
	response = CreateDeleteAutoLiveStreamRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteAutoLiveStreamRuleWithChan invokes the rtc.DeleteAutoLiveStreamRule API asynchronously
func (client *Client) DeleteAutoLiveStreamRuleWithChan(request *DeleteAutoLiveStreamRuleRequest) (<-chan *DeleteAutoLiveStreamRuleResponse, <-chan error) {
	responseChan := make(chan *DeleteAutoLiveStreamRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteAutoLiveStreamRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteAutoLiveStreamRuleWithCallback invokes the rtc.DeleteAutoLiveStreamRule API asynchronously
func (client *Client) DeleteAutoLiveStreamRuleWithCallback(request *DeleteAutoLiveStreamRuleRequest, callback func(response *DeleteAutoLiveStreamRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteAutoLiveStreamRuleResponse
		var err error
		defer close(result)
		response, err = client.DeleteAutoLiveStreamRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteAutoLiveStreamRuleRequest is the request struct for api DeleteAutoLiveStreamRule
type DeleteAutoLiveStreamRuleRequest struct {
	*requests.RpcRequest
	ShowLog string           `position:"Query" name:"ShowLog"`
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
	AppId   string           `position:"Query" name:"AppId"`
	RuleId  requests.Integer `position:"Query" name:"RuleId"`
}

// DeleteAutoLiveStreamRuleResponse is the response struct for api DeleteAutoLiveStreamRule
type DeleteAutoLiveStreamRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteAutoLiveStreamRuleRequest creates a request to invoke DeleteAutoLiveStreamRule API
func CreateDeleteAutoLiveStreamRuleRequest() (request *DeleteAutoLiveStreamRuleRequest) {
	request = &DeleteAutoLiveStreamRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "DeleteAutoLiveStreamRule", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteAutoLiveStreamRuleResponse creates a response to parse from DeleteAutoLiveStreamRule response
func CreateDeleteAutoLiveStreamRuleResponse() (response *DeleteAutoLiveStreamRuleResponse) {
	response = &DeleteAutoLiveStreamRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
