package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetNodeTupleOrder invokes the linkwan.GetNodeTupleOrder API synchronously
func (client *Client) GetNodeTupleOrder(request *GetNodeTupleOrderRequest) (response *GetNodeTupleOrderResponse, err error) {
	response = CreateGetNodeTupleOrderResponse()
	err = client.DoAction(request, response)
	return
}

// GetNodeTupleOrderWithChan invokes the linkwan.GetNodeTupleOrder API asynchronously
func (client *Client) GetNodeTupleOrderWithChan(request *GetNodeTupleOrderRequest) (<-chan *GetNodeTupleOrderResponse, <-chan error) {
	responseChan := make(chan *GetNodeTupleOrderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetNodeTupleOrder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetNodeTupleOrderWithCallback invokes the linkwan.GetNodeTupleOrder API asynchronously
func (client *Client) GetNodeTupleOrderWithCallback(request *GetNodeTupleOrderRequest, callback func(response *GetNodeTupleOrderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetNodeTupleOrderResponse
		var err error
		defer close(result)
		response, err = client.GetNodeTupleOrder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetNodeTupleOrderRequest is the request struct for api GetNodeTupleOrder
type GetNodeTupleOrderRequest struct {
	*requests.RpcRequest
	OrderId     string `position:"Query" name:"OrderId"`
	ApiProduct  string `position:"Body" name:"ApiProduct"`
	ApiRevision string `position:"Body" name:"ApiRevision"`
}

// GetNodeTupleOrderResponse is the response struct for api GetNodeTupleOrder
type GetNodeTupleOrderResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetNodeTupleOrderRequest creates a request to invoke GetNodeTupleOrder API
func CreateGetNodeTupleOrderRequest() (request *GetNodeTupleOrderRequest) {
	request = &GetNodeTupleOrderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "GetNodeTupleOrder", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetNodeTupleOrderResponse creates a response to parse from GetNodeTupleOrder response
func CreateGetNodeTupleOrderResponse() (response *GetNodeTupleOrderResponse) {
	response = &GetNodeTupleOrderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
