package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PublishThingModel invokes the iot.PublishThingModel API synchronously
func (client *Client) PublishThingModel(request *PublishThingModelRequest) (response *PublishThingModelResponse, err error) {
	response = CreatePublishThingModelResponse()
	err = client.DoAction(request, response)
	return
}

// PublishThingModelWithChan invokes the iot.PublishThingModel API asynchronously
func (client *Client) PublishThingModelWithChan(request *PublishThingModelRequest) (<-chan *PublishThingModelResponse, <-chan error) {
	responseChan := make(chan *PublishThingModelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PublishThingModel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PublishThingModelWithCallback invokes the iot.PublishThingModel API asynchronously
func (client *Client) PublishThingModelWithCallback(request *PublishThingModelRequest, callback func(response *PublishThingModelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PublishThingModelResponse
		var err error
		defer close(result)
		response, err = client.PublishThingModel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PublishThingModelRequest is the request struct for api PublishThingModel
type PublishThingModelRequest struct {
	*requests.RpcRequest
	RealTenantId      string `position:"Query" name:"RealTenantId"`
	Description       string `position:"Query" name:"Description"`
	RealTripartiteKey string `position:"Query" name:"RealTripartiteKey"`
	ResourceGroupId   string `position:"Query" name:"ResourceGroupId"`
	IotInstanceId     string `position:"Query" name:"IotInstanceId"`
	ProductKey        string `position:"Query" name:"ProductKey"`
	ApiProduct        string `position:"Body" name:"ApiProduct"`
	ApiRevision       string `position:"Body" name:"ApiRevision"`
	ModelVersion      string `position:"Query" name:"ModelVersion"`
}

// PublishThingModelResponse is the response struct for api PublishThingModel
type PublishThingModelResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreatePublishThingModelRequest creates a request to invoke PublishThingModel API
func CreatePublishThingModelRequest() (request *PublishThingModelRequest) {
	request = &PublishThingModelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "PublishThingModel", "", "")
	request.Method = requests.POST
	return
}

// CreatePublishThingModelResponse creates a response to parse from PublishThingModel response
func CreatePublishThingModelResponse() (response *PublishThingModelResponse) {
	response = &PublishThingModelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
