package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEnsNetLevel invokes the ens.DescribeEnsNetLevel API synchronously
func (client *Client) DescribeEnsNetLevel(request *DescribeEnsNetLevelRequest) (response *DescribeEnsNetLevelResponse, err error) {
	response = CreateDescribeEnsNetLevelResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEnsNetLevelWithChan invokes the ens.DescribeEnsNetLevel API asynchronously
func (client *Client) DescribeEnsNetLevelWithChan(request *DescribeEnsNetLevelRequest) (<-chan *DescribeEnsNetLevelResponse, <-chan error) {
	responseChan := make(chan *DescribeEnsNetLevelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEnsNetLevel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEnsNetLevelWithCallback invokes the ens.DescribeEnsNetLevel API asynchronously
func (client *Client) DescribeEnsNetLevelWithCallback(request *DescribeEnsNetLevelRequest, callback func(response *DescribeEnsNetLevelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEnsNetLevelResponse
		var err error
		defer close(result)
		response, err = client.DescribeEnsNetLevel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEnsNetLevelRequest is the request struct for api DescribeEnsNetLevel
type DescribeEnsNetLevelRequest struct {
	*requests.RpcRequest
}

// DescribeEnsNetLevelResponse is the response struct for api DescribeEnsNetLevel
type DescribeEnsNetLevelResponse struct {
	*responses.BaseResponse
	Code         int          `json:"Code" xml:"Code"`
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	EnsNetLevels EnsNetLevels `json:"EnsNetLevels" xml:"EnsNetLevels"`
}

// CreateDescribeEnsNetLevelRequest creates a request to invoke DescribeEnsNetLevel API
func CreateDescribeEnsNetLevelRequest() (request *DescribeEnsNetLevelRequest) {
	request = &DescribeEnsNetLevelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DescribeEnsNetLevel", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeEnsNetLevelResponse creates a response to parse from DescribeEnsNetLevel response
func CreateDescribeEnsNetLevelResponse() (response *DescribeEnsNetLevelResponse) {
	response = &DescribeEnsNetLevelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
