//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/network/armnetwork/v4"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// VirtualNetworkGatewaysServer is a fake server for instances of the armnetwork.VirtualNetworkGatewaysClient type.
type VirtualNetworkGatewaysServer struct {
	// BeginCreateOrUpdate is the fake for method VirtualNetworkGatewaysClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, virtualNetworkGatewayName string, parameters armnetwork.VirtualNetworkGateway, options *armnetwork.VirtualNetworkGatewaysClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method VirtualNetworkGatewaysClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, virtualNetworkGatewayName string, options *armnetwork.VirtualNetworkGatewaysClientBeginDeleteOptions) (resp azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientDeleteResponse], errResp azfake.ErrorResponder)

	// BeginDisconnectVirtualNetworkGatewayVPNConnections is the fake for method VirtualNetworkGatewaysClient.BeginDisconnectVirtualNetworkGatewayVPNConnections
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginDisconnectVirtualNetworkGatewayVPNConnections func(ctx context.Context, resourceGroupName string, virtualNetworkGatewayName string, request armnetwork.P2SVPNConnectionRequest, options *armnetwork.VirtualNetworkGatewaysClientBeginDisconnectVirtualNetworkGatewayVPNConnectionsOptions) (resp azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientDisconnectVirtualNetworkGatewayVPNConnectionsResponse], errResp azfake.ErrorResponder)

	// BeginGenerateVPNProfile is the fake for method VirtualNetworkGatewaysClient.BeginGenerateVPNProfile
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginGenerateVPNProfile func(ctx context.Context, resourceGroupName string, virtualNetworkGatewayName string, parameters armnetwork.VPNClientParameters, options *armnetwork.VirtualNetworkGatewaysClientBeginGenerateVPNProfileOptions) (resp azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientGenerateVPNProfileResponse], errResp azfake.ErrorResponder)

	// BeginGeneratevpnclientpackage is the fake for method VirtualNetworkGatewaysClient.BeginGeneratevpnclientpackage
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginGeneratevpnclientpackage func(ctx context.Context, resourceGroupName string, virtualNetworkGatewayName string, parameters armnetwork.VPNClientParameters, options *armnetwork.VirtualNetworkGatewaysClientBeginGeneratevpnclientpackageOptions) (resp azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientGeneratevpnclientpackageResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method VirtualNetworkGatewaysClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, virtualNetworkGatewayName string, options *armnetwork.VirtualNetworkGatewaysClientGetOptions) (resp azfake.Responder[armnetwork.VirtualNetworkGatewaysClientGetResponse], errResp azfake.ErrorResponder)

	// BeginGetAdvertisedRoutes is the fake for method VirtualNetworkGatewaysClient.BeginGetAdvertisedRoutes
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginGetAdvertisedRoutes func(ctx context.Context, resourceGroupName string, virtualNetworkGatewayName string, peer string, options *armnetwork.VirtualNetworkGatewaysClientBeginGetAdvertisedRoutesOptions) (resp azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientGetAdvertisedRoutesResponse], errResp azfake.ErrorResponder)

	// BeginGetBgpPeerStatus is the fake for method VirtualNetworkGatewaysClient.BeginGetBgpPeerStatus
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginGetBgpPeerStatus func(ctx context.Context, resourceGroupName string, virtualNetworkGatewayName string, options *armnetwork.VirtualNetworkGatewaysClientBeginGetBgpPeerStatusOptions) (resp azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientGetBgpPeerStatusResponse], errResp azfake.ErrorResponder)

	// BeginGetLearnedRoutes is the fake for method VirtualNetworkGatewaysClient.BeginGetLearnedRoutes
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginGetLearnedRoutes func(ctx context.Context, resourceGroupName string, virtualNetworkGatewayName string, options *armnetwork.VirtualNetworkGatewaysClientBeginGetLearnedRoutesOptions) (resp azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientGetLearnedRoutesResponse], errResp azfake.ErrorResponder)

	// BeginGetVPNProfilePackageURL is the fake for method VirtualNetworkGatewaysClient.BeginGetVPNProfilePackageURL
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginGetVPNProfilePackageURL func(ctx context.Context, resourceGroupName string, virtualNetworkGatewayName string, options *armnetwork.VirtualNetworkGatewaysClientBeginGetVPNProfilePackageURLOptions) (resp azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientGetVPNProfilePackageURLResponse], errResp azfake.ErrorResponder)

	// BeginGetVpnclientConnectionHealth is the fake for method VirtualNetworkGatewaysClient.BeginGetVpnclientConnectionHealth
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginGetVpnclientConnectionHealth func(ctx context.Context, resourceGroupName string, virtualNetworkGatewayName string, options *armnetwork.VirtualNetworkGatewaysClientBeginGetVpnclientConnectionHealthOptions) (resp azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientGetVpnclientConnectionHealthResponse], errResp azfake.ErrorResponder)

	// BeginGetVpnclientIPSecParameters is the fake for method VirtualNetworkGatewaysClient.BeginGetVpnclientIPSecParameters
	// HTTP status codes to indicate success: http.StatusOK
	BeginGetVpnclientIPSecParameters func(ctx context.Context, resourceGroupName string, virtualNetworkGatewayName string, options *armnetwork.VirtualNetworkGatewaysClientBeginGetVpnclientIPSecParametersOptions) (resp azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientGetVpnclientIPSecParametersResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method VirtualNetworkGatewaysClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, options *armnetwork.VirtualNetworkGatewaysClientListOptions) (resp azfake.PagerResponder[armnetwork.VirtualNetworkGatewaysClientListResponse])

	// NewListConnectionsPager is the fake for method VirtualNetworkGatewaysClient.NewListConnectionsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListConnectionsPager func(resourceGroupName string, virtualNetworkGatewayName string, options *armnetwork.VirtualNetworkGatewaysClientListConnectionsOptions) (resp azfake.PagerResponder[armnetwork.VirtualNetworkGatewaysClientListConnectionsResponse])

	// BeginReset is the fake for method VirtualNetworkGatewaysClient.BeginReset
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginReset func(ctx context.Context, resourceGroupName string, virtualNetworkGatewayName string, options *armnetwork.VirtualNetworkGatewaysClientBeginResetOptions) (resp azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientResetResponse], errResp azfake.ErrorResponder)

	// BeginResetVPNClientSharedKey is the fake for method VirtualNetworkGatewaysClient.BeginResetVPNClientSharedKey
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginResetVPNClientSharedKey func(ctx context.Context, resourceGroupName string, virtualNetworkGatewayName string, options *armnetwork.VirtualNetworkGatewaysClientBeginResetVPNClientSharedKeyOptions) (resp azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientResetVPNClientSharedKeyResponse], errResp azfake.ErrorResponder)

	// BeginSetVpnclientIPSecParameters is the fake for method VirtualNetworkGatewaysClient.BeginSetVpnclientIPSecParameters
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginSetVpnclientIPSecParameters func(ctx context.Context, resourceGroupName string, virtualNetworkGatewayName string, vpnclientIPSecParams armnetwork.VPNClientIPsecParameters, options *armnetwork.VirtualNetworkGatewaysClientBeginSetVpnclientIPSecParametersOptions) (resp azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientSetVpnclientIPSecParametersResponse], errResp azfake.ErrorResponder)

	// BeginStartPacketCapture is the fake for method VirtualNetworkGatewaysClient.BeginStartPacketCapture
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginStartPacketCapture func(ctx context.Context, resourceGroupName string, virtualNetworkGatewayName string, options *armnetwork.VirtualNetworkGatewaysClientBeginStartPacketCaptureOptions) (resp azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientStartPacketCaptureResponse], errResp azfake.ErrorResponder)

	// BeginStopPacketCapture is the fake for method VirtualNetworkGatewaysClient.BeginStopPacketCapture
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginStopPacketCapture func(ctx context.Context, resourceGroupName string, virtualNetworkGatewayName string, parameters armnetwork.VPNPacketCaptureStopParameters, options *armnetwork.VirtualNetworkGatewaysClientBeginStopPacketCaptureOptions) (resp azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientStopPacketCaptureResponse], errResp azfake.ErrorResponder)

	// SupportedVPNDevices is the fake for method VirtualNetworkGatewaysClient.SupportedVPNDevices
	// HTTP status codes to indicate success: http.StatusOK
	SupportedVPNDevices func(ctx context.Context, resourceGroupName string, virtualNetworkGatewayName string, options *armnetwork.VirtualNetworkGatewaysClientSupportedVPNDevicesOptions) (resp azfake.Responder[armnetwork.VirtualNetworkGatewaysClientSupportedVPNDevicesResponse], errResp azfake.ErrorResponder)

	// BeginUpdateTags is the fake for method VirtualNetworkGatewaysClient.BeginUpdateTags
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdateTags func(ctx context.Context, resourceGroupName string, virtualNetworkGatewayName string, parameters armnetwork.TagsObject, options *armnetwork.VirtualNetworkGatewaysClientBeginUpdateTagsOptions) (resp azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientUpdateTagsResponse], errResp azfake.ErrorResponder)

	// VPNDeviceConfigurationScript is the fake for method VirtualNetworkGatewaysClient.VPNDeviceConfigurationScript
	// HTTP status codes to indicate success: http.StatusOK
	VPNDeviceConfigurationScript func(ctx context.Context, resourceGroupName string, virtualNetworkGatewayConnectionName string, parameters armnetwork.VPNDeviceScriptParameters, options *armnetwork.VirtualNetworkGatewaysClientVPNDeviceConfigurationScriptOptions) (resp azfake.Responder[armnetwork.VirtualNetworkGatewaysClientVPNDeviceConfigurationScriptResponse], errResp azfake.ErrorResponder)
}

// NewVirtualNetworkGatewaysServerTransport creates a new instance of VirtualNetworkGatewaysServerTransport with the provided implementation.
// The returned VirtualNetworkGatewaysServerTransport instance is connected to an instance of armnetwork.VirtualNetworkGatewaysClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewVirtualNetworkGatewaysServerTransport(srv *VirtualNetworkGatewaysServer) *VirtualNetworkGatewaysServerTransport {
	return &VirtualNetworkGatewaysServerTransport{
		srv:                 srv,
		beginCreateOrUpdate: newTracker[azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientCreateOrUpdateResponse]](),
		beginDelete:         newTracker[azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientDeleteResponse]](),
		beginDisconnectVirtualNetworkGatewayVPNConnections: newTracker[azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientDisconnectVirtualNetworkGatewayVPNConnectionsResponse]](),
		beginGenerateVPNProfile:                            newTracker[azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientGenerateVPNProfileResponse]](),
		beginGeneratevpnclientpackage:                      newTracker[azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientGeneratevpnclientpackageResponse]](),
		beginGetAdvertisedRoutes:                           newTracker[azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientGetAdvertisedRoutesResponse]](),
		beginGetBgpPeerStatus:                              newTracker[azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientGetBgpPeerStatusResponse]](),
		beginGetLearnedRoutes:                              newTracker[azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientGetLearnedRoutesResponse]](),
		beginGetVPNProfilePackageURL:                       newTracker[azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientGetVPNProfilePackageURLResponse]](),
		beginGetVpnclientConnectionHealth:                  newTracker[azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientGetVpnclientConnectionHealthResponse]](),
		beginGetVpnclientIPSecParameters:                   newTracker[azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientGetVpnclientIPSecParametersResponse]](),
		newListPager:                                       newTracker[azfake.PagerResponder[armnetwork.VirtualNetworkGatewaysClientListResponse]](),
		newListConnectionsPager:                            newTracker[azfake.PagerResponder[armnetwork.VirtualNetworkGatewaysClientListConnectionsResponse]](),
		beginReset:                                         newTracker[azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientResetResponse]](),
		beginResetVPNClientSharedKey:                       newTracker[azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientResetVPNClientSharedKeyResponse]](),
		beginSetVpnclientIPSecParameters:                   newTracker[azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientSetVpnclientIPSecParametersResponse]](),
		beginStartPacketCapture:                            newTracker[azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientStartPacketCaptureResponse]](),
		beginStopPacketCapture:                             newTracker[azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientStopPacketCaptureResponse]](),
		beginUpdateTags:                                    newTracker[azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientUpdateTagsResponse]](),
	}
}

// VirtualNetworkGatewaysServerTransport connects instances of armnetwork.VirtualNetworkGatewaysClient to instances of VirtualNetworkGatewaysServer.
// Don't use this type directly, use NewVirtualNetworkGatewaysServerTransport instead.
type VirtualNetworkGatewaysServerTransport struct {
	srv                                                *VirtualNetworkGatewaysServer
	beginCreateOrUpdate                                *tracker[azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientCreateOrUpdateResponse]]
	beginDelete                                        *tracker[azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientDeleteResponse]]
	beginDisconnectVirtualNetworkGatewayVPNConnections *tracker[azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientDisconnectVirtualNetworkGatewayVPNConnectionsResponse]]
	beginGenerateVPNProfile                            *tracker[azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientGenerateVPNProfileResponse]]
	beginGeneratevpnclientpackage                      *tracker[azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientGeneratevpnclientpackageResponse]]
	beginGetAdvertisedRoutes                           *tracker[azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientGetAdvertisedRoutesResponse]]
	beginGetBgpPeerStatus                              *tracker[azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientGetBgpPeerStatusResponse]]
	beginGetLearnedRoutes                              *tracker[azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientGetLearnedRoutesResponse]]
	beginGetVPNProfilePackageURL                       *tracker[azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientGetVPNProfilePackageURLResponse]]
	beginGetVpnclientConnectionHealth                  *tracker[azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientGetVpnclientConnectionHealthResponse]]
	beginGetVpnclientIPSecParameters                   *tracker[azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientGetVpnclientIPSecParametersResponse]]
	newListPager                                       *tracker[azfake.PagerResponder[armnetwork.VirtualNetworkGatewaysClientListResponse]]
	newListConnectionsPager                            *tracker[azfake.PagerResponder[armnetwork.VirtualNetworkGatewaysClientListConnectionsResponse]]
	beginReset                                         *tracker[azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientResetResponse]]
	beginResetVPNClientSharedKey                       *tracker[azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientResetVPNClientSharedKeyResponse]]
	beginSetVpnclientIPSecParameters                   *tracker[azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientSetVpnclientIPSecParametersResponse]]
	beginStartPacketCapture                            *tracker[azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientStartPacketCaptureResponse]]
	beginStopPacketCapture                             *tracker[azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientStopPacketCaptureResponse]]
	beginUpdateTags                                    *tracker[azfake.PollerResponder[armnetwork.VirtualNetworkGatewaysClientUpdateTagsResponse]]
}

// Do implements the policy.Transporter interface for VirtualNetworkGatewaysServerTransport.
func (v *VirtualNetworkGatewaysServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "VirtualNetworkGatewaysClient.BeginCreateOrUpdate":
		resp, err = v.dispatchBeginCreateOrUpdate(req)
	case "VirtualNetworkGatewaysClient.BeginDelete":
		resp, err = v.dispatchBeginDelete(req)
	case "VirtualNetworkGatewaysClient.BeginDisconnectVirtualNetworkGatewayVPNConnections":
		resp, err = v.dispatchBeginDisconnectVirtualNetworkGatewayVPNConnections(req)
	case "VirtualNetworkGatewaysClient.BeginGenerateVPNProfile":
		resp, err = v.dispatchBeginGenerateVPNProfile(req)
	case "VirtualNetworkGatewaysClient.BeginGeneratevpnclientpackage":
		resp, err = v.dispatchBeginGeneratevpnclientpackage(req)
	case "VirtualNetworkGatewaysClient.Get":
		resp, err = v.dispatchGet(req)
	case "VirtualNetworkGatewaysClient.BeginGetAdvertisedRoutes":
		resp, err = v.dispatchBeginGetAdvertisedRoutes(req)
	case "VirtualNetworkGatewaysClient.BeginGetBgpPeerStatus":
		resp, err = v.dispatchBeginGetBgpPeerStatus(req)
	case "VirtualNetworkGatewaysClient.BeginGetLearnedRoutes":
		resp, err = v.dispatchBeginGetLearnedRoutes(req)
	case "VirtualNetworkGatewaysClient.BeginGetVPNProfilePackageURL":
		resp, err = v.dispatchBeginGetVPNProfilePackageURL(req)
	case "VirtualNetworkGatewaysClient.BeginGetVpnclientConnectionHealth":
		resp, err = v.dispatchBeginGetVpnclientConnectionHealth(req)
	case "VirtualNetworkGatewaysClient.BeginGetVpnclientIPSecParameters":
		resp, err = v.dispatchBeginGetVpnclientIPSecParameters(req)
	case "VirtualNetworkGatewaysClient.NewListPager":
		resp, err = v.dispatchNewListPager(req)
	case "VirtualNetworkGatewaysClient.NewListConnectionsPager":
		resp, err = v.dispatchNewListConnectionsPager(req)
	case "VirtualNetworkGatewaysClient.BeginReset":
		resp, err = v.dispatchBeginReset(req)
	case "VirtualNetworkGatewaysClient.BeginResetVPNClientSharedKey":
		resp, err = v.dispatchBeginResetVPNClientSharedKey(req)
	case "VirtualNetworkGatewaysClient.BeginSetVpnclientIPSecParameters":
		resp, err = v.dispatchBeginSetVpnclientIPSecParameters(req)
	case "VirtualNetworkGatewaysClient.BeginStartPacketCapture":
		resp, err = v.dispatchBeginStartPacketCapture(req)
	case "VirtualNetworkGatewaysClient.BeginStopPacketCapture":
		resp, err = v.dispatchBeginStopPacketCapture(req)
	case "VirtualNetworkGatewaysClient.SupportedVPNDevices":
		resp, err = v.dispatchSupportedVPNDevices(req)
	case "VirtualNetworkGatewaysClient.BeginUpdateTags":
		resp, err = v.dispatchBeginUpdateTags(req)
	case "VirtualNetworkGatewaysClient.VPNDeviceConfigurationScript":
		resp, err = v.dispatchVPNDeviceConfigurationScript(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (v *VirtualNetworkGatewaysServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if v.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := v.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/virtualNetworkGateways/(?P<virtualNetworkGatewayName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetwork.VirtualNetworkGateway](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		virtualNetworkGatewayNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualNetworkGatewayName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, virtualNetworkGatewayNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		v.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		v.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		v.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (v *VirtualNetworkGatewaysServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if v.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := v.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/virtualNetworkGateways/(?P<virtualNetworkGatewayName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		virtualNetworkGatewayNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualNetworkGatewayName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginDelete(req.Context(), resourceGroupNameParam, virtualNetworkGatewayNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		v.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		v.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		v.beginDelete.remove(req)
	}

	return resp, nil
}

func (v *VirtualNetworkGatewaysServerTransport) dispatchBeginDisconnectVirtualNetworkGatewayVPNConnections(req *http.Request) (*http.Response, error) {
	if v.srv.BeginDisconnectVirtualNetworkGatewayVPNConnections == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDisconnectVirtualNetworkGatewayVPNConnections not implemented")}
	}
	beginDisconnectVirtualNetworkGatewayVPNConnections := v.beginDisconnectVirtualNetworkGatewayVPNConnections.get(req)
	if beginDisconnectVirtualNetworkGatewayVPNConnections == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/virtualNetworkGateways/(?P<virtualNetworkGatewayName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/disconnectVirtualNetworkGatewayVpnConnections`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetwork.P2SVPNConnectionRequest](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		virtualNetworkGatewayNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualNetworkGatewayName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginDisconnectVirtualNetworkGatewayVPNConnections(req.Context(), resourceGroupNameParam, virtualNetworkGatewayNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDisconnectVirtualNetworkGatewayVPNConnections = &respr
		v.beginDisconnectVirtualNetworkGatewayVPNConnections.add(req, beginDisconnectVirtualNetworkGatewayVPNConnections)
	}

	resp, err := server.PollerResponderNext(beginDisconnectVirtualNetworkGatewayVPNConnections, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginDisconnectVirtualNetworkGatewayVPNConnections.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDisconnectVirtualNetworkGatewayVPNConnections) {
		v.beginDisconnectVirtualNetworkGatewayVPNConnections.remove(req)
	}

	return resp, nil
}

func (v *VirtualNetworkGatewaysServerTransport) dispatchBeginGenerateVPNProfile(req *http.Request) (*http.Response, error) {
	if v.srv.BeginGenerateVPNProfile == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginGenerateVPNProfile not implemented")}
	}
	beginGenerateVPNProfile := v.beginGenerateVPNProfile.get(req)
	if beginGenerateVPNProfile == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/virtualNetworkGateways/(?P<virtualNetworkGatewayName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/generatevpnprofile`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetwork.VPNClientParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		virtualNetworkGatewayNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualNetworkGatewayName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginGenerateVPNProfile(req.Context(), resourceGroupNameParam, virtualNetworkGatewayNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginGenerateVPNProfile = &respr
		v.beginGenerateVPNProfile.add(req, beginGenerateVPNProfile)
	}

	resp, err := server.PollerResponderNext(beginGenerateVPNProfile, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginGenerateVPNProfile.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginGenerateVPNProfile) {
		v.beginGenerateVPNProfile.remove(req)
	}

	return resp, nil
}

func (v *VirtualNetworkGatewaysServerTransport) dispatchBeginGeneratevpnclientpackage(req *http.Request) (*http.Response, error) {
	if v.srv.BeginGeneratevpnclientpackage == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginGeneratevpnclientpackage not implemented")}
	}
	beginGeneratevpnclientpackage := v.beginGeneratevpnclientpackage.get(req)
	if beginGeneratevpnclientpackage == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/virtualNetworkGateways/(?P<virtualNetworkGatewayName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/generatevpnclientpackage`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetwork.VPNClientParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		virtualNetworkGatewayNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualNetworkGatewayName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginGeneratevpnclientpackage(req.Context(), resourceGroupNameParam, virtualNetworkGatewayNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginGeneratevpnclientpackage = &respr
		v.beginGeneratevpnclientpackage.add(req, beginGeneratevpnclientpackage)
	}

	resp, err := server.PollerResponderNext(beginGeneratevpnclientpackage, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginGeneratevpnclientpackage.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginGeneratevpnclientpackage) {
		v.beginGeneratevpnclientpackage.remove(req)
	}

	return resp, nil
}

func (v *VirtualNetworkGatewaysServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if v.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/virtualNetworkGateways/(?P<virtualNetworkGatewayName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	virtualNetworkGatewayNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualNetworkGatewayName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.Get(req.Context(), resourceGroupNameParam, virtualNetworkGatewayNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VirtualNetworkGateway, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (v *VirtualNetworkGatewaysServerTransport) dispatchBeginGetAdvertisedRoutes(req *http.Request) (*http.Response, error) {
	if v.srv.BeginGetAdvertisedRoutes == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginGetAdvertisedRoutes not implemented")}
	}
	beginGetAdvertisedRoutes := v.beginGetAdvertisedRoutes.get(req)
	if beginGetAdvertisedRoutes == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/virtualNetworkGateways/(?P<virtualNetworkGatewayName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getAdvertisedRoutes`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		virtualNetworkGatewayNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualNetworkGatewayName")])
		if err != nil {
			return nil, err
		}
		peerParam, err := url.QueryUnescape(qp.Get("peer"))
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginGetAdvertisedRoutes(req.Context(), resourceGroupNameParam, virtualNetworkGatewayNameParam, peerParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginGetAdvertisedRoutes = &respr
		v.beginGetAdvertisedRoutes.add(req, beginGetAdvertisedRoutes)
	}

	resp, err := server.PollerResponderNext(beginGetAdvertisedRoutes, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginGetAdvertisedRoutes.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginGetAdvertisedRoutes) {
		v.beginGetAdvertisedRoutes.remove(req)
	}

	return resp, nil
}

func (v *VirtualNetworkGatewaysServerTransport) dispatchBeginGetBgpPeerStatus(req *http.Request) (*http.Response, error) {
	if v.srv.BeginGetBgpPeerStatus == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginGetBgpPeerStatus not implemented")}
	}
	beginGetBgpPeerStatus := v.beginGetBgpPeerStatus.get(req)
	if beginGetBgpPeerStatus == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/virtualNetworkGateways/(?P<virtualNetworkGatewayName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getBgpPeerStatus`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		virtualNetworkGatewayNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualNetworkGatewayName")])
		if err != nil {
			return nil, err
		}
		peerUnescaped, err := url.QueryUnescape(qp.Get("peer"))
		if err != nil {
			return nil, err
		}
		peerParam := getOptional(peerUnescaped)
		var options *armnetwork.VirtualNetworkGatewaysClientBeginGetBgpPeerStatusOptions
		if peerParam != nil {
			options = &armnetwork.VirtualNetworkGatewaysClientBeginGetBgpPeerStatusOptions{
				Peer: peerParam,
			}
		}
		respr, errRespr := v.srv.BeginGetBgpPeerStatus(req.Context(), resourceGroupNameParam, virtualNetworkGatewayNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginGetBgpPeerStatus = &respr
		v.beginGetBgpPeerStatus.add(req, beginGetBgpPeerStatus)
	}

	resp, err := server.PollerResponderNext(beginGetBgpPeerStatus, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginGetBgpPeerStatus.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginGetBgpPeerStatus) {
		v.beginGetBgpPeerStatus.remove(req)
	}

	return resp, nil
}

func (v *VirtualNetworkGatewaysServerTransport) dispatchBeginGetLearnedRoutes(req *http.Request) (*http.Response, error) {
	if v.srv.BeginGetLearnedRoutes == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginGetLearnedRoutes not implemented")}
	}
	beginGetLearnedRoutes := v.beginGetLearnedRoutes.get(req)
	if beginGetLearnedRoutes == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/virtualNetworkGateways/(?P<virtualNetworkGatewayName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getLearnedRoutes`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		virtualNetworkGatewayNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualNetworkGatewayName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginGetLearnedRoutes(req.Context(), resourceGroupNameParam, virtualNetworkGatewayNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginGetLearnedRoutes = &respr
		v.beginGetLearnedRoutes.add(req, beginGetLearnedRoutes)
	}

	resp, err := server.PollerResponderNext(beginGetLearnedRoutes, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginGetLearnedRoutes.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginGetLearnedRoutes) {
		v.beginGetLearnedRoutes.remove(req)
	}

	return resp, nil
}

func (v *VirtualNetworkGatewaysServerTransport) dispatchBeginGetVPNProfilePackageURL(req *http.Request) (*http.Response, error) {
	if v.srv.BeginGetVPNProfilePackageURL == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginGetVPNProfilePackageURL not implemented")}
	}
	beginGetVPNProfilePackageURL := v.beginGetVPNProfilePackageURL.get(req)
	if beginGetVPNProfilePackageURL == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/virtualNetworkGateways/(?P<virtualNetworkGatewayName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getvpnprofilepackageurl`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		virtualNetworkGatewayNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualNetworkGatewayName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginGetVPNProfilePackageURL(req.Context(), resourceGroupNameParam, virtualNetworkGatewayNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginGetVPNProfilePackageURL = &respr
		v.beginGetVPNProfilePackageURL.add(req, beginGetVPNProfilePackageURL)
	}

	resp, err := server.PollerResponderNext(beginGetVPNProfilePackageURL, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginGetVPNProfilePackageURL.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginGetVPNProfilePackageURL) {
		v.beginGetVPNProfilePackageURL.remove(req)
	}

	return resp, nil
}

func (v *VirtualNetworkGatewaysServerTransport) dispatchBeginGetVpnclientConnectionHealth(req *http.Request) (*http.Response, error) {
	if v.srv.BeginGetVpnclientConnectionHealth == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginGetVpnclientConnectionHealth not implemented")}
	}
	beginGetVpnclientConnectionHealth := v.beginGetVpnclientConnectionHealth.get(req)
	if beginGetVpnclientConnectionHealth == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/virtualNetworkGateways/(?P<virtualNetworkGatewayName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getVpnClientConnectionHealth`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		virtualNetworkGatewayNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualNetworkGatewayName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginGetVpnclientConnectionHealth(req.Context(), resourceGroupNameParam, virtualNetworkGatewayNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginGetVpnclientConnectionHealth = &respr
		v.beginGetVpnclientConnectionHealth.add(req, beginGetVpnclientConnectionHealth)
	}

	resp, err := server.PollerResponderNext(beginGetVpnclientConnectionHealth, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginGetVpnclientConnectionHealth.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginGetVpnclientConnectionHealth) {
		v.beginGetVpnclientConnectionHealth.remove(req)
	}

	return resp, nil
}

func (v *VirtualNetworkGatewaysServerTransport) dispatchBeginGetVpnclientIPSecParameters(req *http.Request) (*http.Response, error) {
	if v.srv.BeginGetVpnclientIPSecParameters == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginGetVpnclientIPSecParameters not implemented")}
	}
	beginGetVpnclientIPSecParameters := v.beginGetVpnclientIPSecParameters.get(req)
	if beginGetVpnclientIPSecParameters == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/virtualNetworkGateways/(?P<virtualNetworkGatewayName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getvpnclientipsecparameters`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		virtualNetworkGatewayNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualNetworkGatewayName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginGetVpnclientIPSecParameters(req.Context(), resourceGroupNameParam, virtualNetworkGatewayNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginGetVpnclientIPSecParameters = &respr
		v.beginGetVpnclientIPSecParameters.add(req, beginGetVpnclientIPSecParameters)
	}

	resp, err := server.PollerResponderNext(beginGetVpnclientIPSecParameters, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		v.beginGetVpnclientIPSecParameters.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginGetVpnclientIPSecParameters) {
		v.beginGetVpnclientIPSecParameters.remove(req)
	}

	return resp, nil
}

func (v *VirtualNetworkGatewaysServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if v.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := v.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/virtualNetworkGateways`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := v.srv.NewListPager(resourceGroupNameParam, nil)
		newListPager = &resp
		v.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armnetwork.VirtualNetworkGatewaysClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		v.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		v.newListPager.remove(req)
	}
	return resp, nil
}

func (v *VirtualNetworkGatewaysServerTransport) dispatchNewListConnectionsPager(req *http.Request) (*http.Response, error) {
	if v.srv.NewListConnectionsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListConnectionsPager not implemented")}
	}
	newListConnectionsPager := v.newListConnectionsPager.get(req)
	if newListConnectionsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/virtualNetworkGateways/(?P<virtualNetworkGatewayName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/connections`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		virtualNetworkGatewayNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualNetworkGatewayName")])
		if err != nil {
			return nil, err
		}
		resp := v.srv.NewListConnectionsPager(resourceGroupNameParam, virtualNetworkGatewayNameParam, nil)
		newListConnectionsPager = &resp
		v.newListConnectionsPager.add(req, newListConnectionsPager)
		server.PagerResponderInjectNextLinks(newListConnectionsPager, req, func(page *armnetwork.VirtualNetworkGatewaysClientListConnectionsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListConnectionsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		v.newListConnectionsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListConnectionsPager) {
		v.newListConnectionsPager.remove(req)
	}
	return resp, nil
}

func (v *VirtualNetworkGatewaysServerTransport) dispatchBeginReset(req *http.Request) (*http.Response, error) {
	if v.srv.BeginReset == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginReset not implemented")}
	}
	beginReset := v.beginReset.get(req)
	if beginReset == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/virtualNetworkGateways/(?P<virtualNetworkGatewayName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/reset`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		virtualNetworkGatewayNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualNetworkGatewayName")])
		if err != nil {
			return nil, err
		}
		gatewayVipUnescaped, err := url.QueryUnescape(qp.Get("gatewayVip"))
		if err != nil {
			return nil, err
		}
		gatewayVipParam := getOptional(gatewayVipUnescaped)
		var options *armnetwork.VirtualNetworkGatewaysClientBeginResetOptions
		if gatewayVipParam != nil {
			options = &armnetwork.VirtualNetworkGatewaysClientBeginResetOptions{
				GatewayVip: gatewayVipParam,
			}
		}
		respr, errRespr := v.srv.BeginReset(req.Context(), resourceGroupNameParam, virtualNetworkGatewayNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginReset = &respr
		v.beginReset.add(req, beginReset)
	}

	resp, err := server.PollerResponderNext(beginReset, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginReset.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginReset) {
		v.beginReset.remove(req)
	}

	return resp, nil
}

func (v *VirtualNetworkGatewaysServerTransport) dispatchBeginResetVPNClientSharedKey(req *http.Request) (*http.Response, error) {
	if v.srv.BeginResetVPNClientSharedKey == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginResetVPNClientSharedKey not implemented")}
	}
	beginResetVPNClientSharedKey := v.beginResetVPNClientSharedKey.get(req)
	if beginResetVPNClientSharedKey == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/virtualNetworkGateways/(?P<virtualNetworkGatewayName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resetvpnclientsharedkey`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		virtualNetworkGatewayNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualNetworkGatewayName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginResetVPNClientSharedKey(req.Context(), resourceGroupNameParam, virtualNetworkGatewayNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginResetVPNClientSharedKey = &respr
		v.beginResetVPNClientSharedKey.add(req, beginResetVPNClientSharedKey)
	}

	resp, err := server.PollerResponderNext(beginResetVPNClientSharedKey, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginResetVPNClientSharedKey.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginResetVPNClientSharedKey) {
		v.beginResetVPNClientSharedKey.remove(req)
	}

	return resp, nil
}

func (v *VirtualNetworkGatewaysServerTransport) dispatchBeginSetVpnclientIPSecParameters(req *http.Request) (*http.Response, error) {
	if v.srv.BeginSetVpnclientIPSecParameters == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginSetVpnclientIPSecParameters not implemented")}
	}
	beginSetVpnclientIPSecParameters := v.beginSetVpnclientIPSecParameters.get(req)
	if beginSetVpnclientIPSecParameters == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/virtualNetworkGateways/(?P<virtualNetworkGatewayName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/setvpnclientipsecparameters`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetwork.VPNClientIPsecParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		virtualNetworkGatewayNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualNetworkGatewayName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginSetVpnclientIPSecParameters(req.Context(), resourceGroupNameParam, virtualNetworkGatewayNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginSetVpnclientIPSecParameters = &respr
		v.beginSetVpnclientIPSecParameters.add(req, beginSetVpnclientIPSecParameters)
	}

	resp, err := server.PollerResponderNext(beginSetVpnclientIPSecParameters, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginSetVpnclientIPSecParameters.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginSetVpnclientIPSecParameters) {
		v.beginSetVpnclientIPSecParameters.remove(req)
	}

	return resp, nil
}

func (v *VirtualNetworkGatewaysServerTransport) dispatchBeginStartPacketCapture(req *http.Request) (*http.Response, error) {
	if v.srv.BeginStartPacketCapture == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginStartPacketCapture not implemented")}
	}
	beginStartPacketCapture := v.beginStartPacketCapture.get(req)
	if beginStartPacketCapture == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/virtualNetworkGateways/(?P<virtualNetworkGatewayName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/startPacketCapture`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetwork.VPNPacketCaptureStartParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		virtualNetworkGatewayNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualNetworkGatewayName")])
		if err != nil {
			return nil, err
		}
		var options *armnetwork.VirtualNetworkGatewaysClientBeginStartPacketCaptureOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armnetwork.VirtualNetworkGatewaysClientBeginStartPacketCaptureOptions{
				Parameters: &body,
			}
		}
		respr, errRespr := v.srv.BeginStartPacketCapture(req.Context(), resourceGroupNameParam, virtualNetworkGatewayNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginStartPacketCapture = &respr
		v.beginStartPacketCapture.add(req, beginStartPacketCapture)
	}

	resp, err := server.PollerResponderNext(beginStartPacketCapture, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginStartPacketCapture.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginStartPacketCapture) {
		v.beginStartPacketCapture.remove(req)
	}

	return resp, nil
}

func (v *VirtualNetworkGatewaysServerTransport) dispatchBeginStopPacketCapture(req *http.Request) (*http.Response, error) {
	if v.srv.BeginStopPacketCapture == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginStopPacketCapture not implemented")}
	}
	beginStopPacketCapture := v.beginStopPacketCapture.get(req)
	if beginStopPacketCapture == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/virtualNetworkGateways/(?P<virtualNetworkGatewayName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/stopPacketCapture`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetwork.VPNPacketCaptureStopParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		virtualNetworkGatewayNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualNetworkGatewayName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginStopPacketCapture(req.Context(), resourceGroupNameParam, virtualNetworkGatewayNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginStopPacketCapture = &respr
		v.beginStopPacketCapture.add(req, beginStopPacketCapture)
	}

	resp, err := server.PollerResponderNext(beginStopPacketCapture, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginStopPacketCapture.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginStopPacketCapture) {
		v.beginStopPacketCapture.remove(req)
	}

	return resp, nil
}

func (v *VirtualNetworkGatewaysServerTransport) dispatchSupportedVPNDevices(req *http.Request) (*http.Response, error) {
	if v.srv.SupportedVPNDevices == nil {
		return nil, &nonRetriableError{errors.New("fake for method SupportedVPNDevices not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/virtualNetworkGateways/(?P<virtualNetworkGatewayName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/supportedvpndevices`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	virtualNetworkGatewayNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualNetworkGatewayName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.SupportedVPNDevices(req.Context(), resourceGroupNameParam, virtualNetworkGatewayNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Value, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (v *VirtualNetworkGatewaysServerTransport) dispatchBeginUpdateTags(req *http.Request) (*http.Response, error) {
	if v.srv.BeginUpdateTags == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdateTags not implemented")}
	}
	beginUpdateTags := v.beginUpdateTags.get(req)
	if beginUpdateTags == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/virtualNetworkGateways/(?P<virtualNetworkGatewayName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetwork.TagsObject](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		virtualNetworkGatewayNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualNetworkGatewayName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := v.srv.BeginUpdateTags(req.Context(), resourceGroupNameParam, virtualNetworkGatewayNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdateTags = &respr
		v.beginUpdateTags.add(req, beginUpdateTags)
	}

	resp, err := server.PollerResponderNext(beginUpdateTags, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		v.beginUpdateTags.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdateTags) {
		v.beginUpdateTags.remove(req)
	}

	return resp, nil
}

func (v *VirtualNetworkGatewaysServerTransport) dispatchVPNDeviceConfigurationScript(req *http.Request) (*http.Response, error) {
	if v.srv.VPNDeviceConfigurationScript == nil {
		return nil, &nonRetriableError{errors.New("fake for method VPNDeviceConfigurationScript not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/connections/(?P<virtualNetworkGatewayConnectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/vpndeviceconfigurationscript`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armnetwork.VPNDeviceScriptParameters](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	virtualNetworkGatewayConnectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("virtualNetworkGatewayConnectionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := v.srv.VPNDeviceConfigurationScript(req.Context(), resourceGroupNameParam, virtualNetworkGatewayConnectionNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Value, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
