package waf_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDomainList invokes the waf_openapi.DescribeDomainList API synchronously
func (client *Client) DescribeDomainList(request *DescribeDomainListRequest) (response *DescribeDomainListResponse, err error) {
	response = CreateDescribeDomainListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDomainListWithChan invokes the waf_openapi.DescribeDomainList API asynchronously
func (client *Client) DescribeDomainListWithChan(request *DescribeDomainListRequest) (<-chan *DescribeDomainListResponse, <-chan error) {
	responseChan := make(chan *DescribeDomainListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDomainList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDomainListWithCallback invokes the waf_openapi.DescribeDomainList API asynchronously
func (client *Client) DescribeDomainListWithCallback(request *DescribeDomainListRequest, callback func(response *DescribeDomainListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDomainListResponse
		var err error
		defer close(result)
		response, err = client.DescribeDomainList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDomainListRequest is the request struct for api DescribeDomainList
type DescribeDomainListRequest struct {
	*requests.RpcRequest
	DomainNames     *[]string        `position:"Query" name:"DomainNames"  type:"Repeated"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	DomainName      string           `position:"Query" name:"DomainName"`
	IsSub           requests.Integer `position:"Query" name:"IsSub"`
	InstanceId      string           `position:"Query" name:"InstanceId"`
}

// DescribeDomainListResponse is the response struct for api DescribeDomainList
type DescribeDomainListResponse struct {
	*responses.BaseResponse
	TotalCount  int      `json:"TotalCount" xml:"TotalCount"`
	RequestId   string   `json:"RequestId" xml:"RequestId"`
	DomainNames []string `json:"DomainNames" xml:"DomainNames"`
}

// CreateDescribeDomainListRequest creates a request to invoke DescribeDomainList API
func CreateDescribeDomainListRequest() (request *DescribeDomainListRequest) {
	request = &DescribeDomainListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("waf-openapi", "2019-09-10", "DescribeDomainList", "waf", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDomainListResponse creates a response to parse from DescribeDomainList response
func CreateDescribeDomainListResponse() (response *DescribeDomainListResponse) {
	response = &DescribeDomainListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
