package teambition_aliyun

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddProjectMembers invokes the teambition_aliyun.AddProjectMembers API synchronously
// api document: https://help.aliyun.com/api/teambition-aliyun/addprojectmembers.html
func (client *Client) AddProjectMembers(request *AddProjectMembersRequest) (response *AddProjectMembersResponse, err error) {
	response = CreateAddProjectMembersResponse()
	err = client.DoAction(request, response)
	return
}

// AddProjectMembersWithChan invokes the teambition_aliyun.AddProjectMembers API asynchronously
// api document: https://help.aliyun.com/api/teambition-aliyun/addprojectmembers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddProjectMembersWithChan(request *AddProjectMembersRequest) (<-chan *AddProjectMembersResponse, <-chan error) {
	responseChan := make(chan *AddProjectMembersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddProjectMembers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddProjectMembersWithCallback invokes the teambition_aliyun.AddProjectMembers API asynchronously
// api document: https://help.aliyun.com/api/teambition-aliyun/addprojectmembers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddProjectMembersWithCallback(request *AddProjectMembersRequest, callback func(response *AddProjectMembersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddProjectMembersResponse
		var err error
		defer close(result)
		response, err = client.AddProjectMembers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddProjectMembersRequest is the request struct for api AddProjectMembers
type AddProjectMembersRequest struct {
	*requests.RpcRequest
	Members   string `position:"Body" name:"Members"`
	ProjectId string `position:"Body" name:"ProjectId"`
	OrgId     string `position:"Body" name:"OrgId"`
}

// AddProjectMembersResponse is the response struct for api AddProjectMembers
type AddProjectMembersResponse struct {
	*responses.BaseResponse
	Successful bool   `json:"Successful" xml:"Successful"`
	ErrorCode  string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg   string `json:"ErrorMsg" xml:"ErrorMsg"`
	Object     bool   `json:"Object" xml:"Object"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
}

// CreateAddProjectMembersRequest creates a request to invoke AddProjectMembers API
func CreateAddProjectMembersRequest() (request *AddProjectMembersRequest) {
	request = &AddProjectMembersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("teambition-aliyun", "2020-02-26", "AddProjectMembers", "", "")
	request.Method = requests.POST
	return
}

// CreateAddProjectMembersResponse creates a response to parse from AddProjectMembers response
func CreateAddProjectMembersResponse() (response *AddProjectMembersResponse) {
	response = &AddProjectMembersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
