package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetFreqBandPlanGroup invokes the linkwan.GetFreqBandPlanGroup API synchronously
func (client *Client) GetFreqBandPlanGroup(request *GetFreqBandPlanGroupRequest) (response *GetFreqBandPlanGroupResponse, err error) {
	response = CreateGetFreqBandPlanGroupResponse()
	err = client.DoAction(request, response)
	return
}

// GetFreqBandPlanGroupWithChan invokes the linkwan.GetFreqBandPlanGroup API asynchronously
func (client *Client) GetFreqBandPlanGroupWithChan(request *GetFreqBandPlanGroupRequest) (<-chan *GetFreqBandPlanGroupResponse, <-chan error) {
	responseChan := make(chan *GetFreqBandPlanGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetFreqBandPlanGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetFreqBandPlanGroupWithCallback invokes the linkwan.GetFreqBandPlanGroup API asynchronously
func (client *Client) GetFreqBandPlanGroupWithCallback(request *GetFreqBandPlanGroupRequest, callback func(response *GetFreqBandPlanGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetFreqBandPlanGroupResponse
		var err error
		defer close(result)
		response, err = client.GetFreqBandPlanGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetFreqBandPlanGroupRequest is the request struct for api GetFreqBandPlanGroup
type GetFreqBandPlanGroupRequest struct {
	*requests.RpcRequest
	GroupId     requests.Integer `position:"Query" name:"GroupId"`
	ApiProduct  string           `position:"Body" name:"ApiProduct"`
	ApiRevision string           `position:"Body" name:"ApiRevision"`
}

// GetFreqBandPlanGroupResponse is the response struct for api GetFreqBandPlanGroup
type GetFreqBandPlanGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetFreqBandPlanGroupRequest creates a request to invoke GetFreqBandPlanGroup API
func CreateGetFreqBandPlanGroupRequest() (request *GetFreqBandPlanGroupRequest) {
	request = &GetFreqBandPlanGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "GetFreqBandPlanGroup", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetFreqBandPlanGroupResponse creates a response to parse from GetFreqBandPlanGroup response
func CreateGetFreqBandPlanGroupResponse() (response *GetFreqBandPlanGroupResponse) {
	response = &GetFreqBandPlanGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
