package jarvis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeResetRecordList invokes the jarvis.DescribeResetRecordList API synchronously
// api document: https://help.aliyun.com/api/jarvis/describeresetrecordlist.html
func (client *Client) DescribeResetRecordList(request *DescribeResetRecordListRequest) (response *DescribeResetRecordListResponse, err error) {
	response = CreateDescribeResetRecordListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeResetRecordListWithChan invokes the jarvis.DescribeResetRecordList API asynchronously
// api document: https://help.aliyun.com/api/jarvis/describeresetrecordlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeResetRecordListWithChan(request *DescribeResetRecordListRequest) (<-chan *DescribeResetRecordListResponse, <-chan error) {
	responseChan := make(chan *DescribeResetRecordListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeResetRecordList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeResetRecordListWithCallback invokes the jarvis.DescribeResetRecordList API asynchronously
// api document: https://help.aliyun.com/api/jarvis/describeresetrecordlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeResetRecordListWithCallback(request *DescribeResetRecordListRequest, callback func(response *DescribeResetRecordListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeResetRecordListResponse
		var err error
		defer close(result)
		response, err = client.DescribeResetRecordList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeResetRecordListRequest is the request struct for api DescribeResetRecordList
type DescribeResetRecordListRequest struct {
	*requests.RpcRequest
	SrcIP       string           `position:"Query" name:"SrcIP"`
	Period      string           `position:"Query" name:"Period"`
	SourceIp    string           `position:"Query" name:"SourceIp"`
	PageSize    requests.Integer `position:"Query" name:"pageSize"`
	CurrentPage requests.Integer `position:"Query" name:"currentPage"`
	DstIP       string           `position:"Query" name:"DstIP"`
	Region      string           `position:"Query" name:"Region"`
	Lang        string           `position:"Query" name:"Lang"`
	SourceCode  string           `position:"Query" name:"SourceCode"`
}

// DescribeResetRecordListResponse is the response struct for api DescribeResetRecordList
type DescribeResetRecordListResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Module    string   `json:"Module" xml:"Module"`
	PageInfo  PageInfo `json:"PageInfo" xml:"PageInfo"`
	DataList  []Data   `json:"DataList" xml:"DataList"`
}

// CreateDescribeResetRecordListRequest creates a request to invoke DescribeResetRecordList API
func CreateDescribeResetRecordListRequest() (request *DescribeResetRecordListRequest) {
	request = &DescribeResetRecordListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("jarvis", "2018-02-06", "DescribeResetRecordList", "jarvis", "openAPI")
	return
}

// CreateDescribeResetRecordListResponse creates a response to parse from DescribeResetRecordList response
func CreateDescribeResetRecordListResponse() (response *DescribeResetRecordListResponse) {
	response = &DescribeResetRecordListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
