package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDcdnIpaDomain invokes the dcdn.DeleteDcdnIpaDomain API synchronously
func (client *Client) DeleteDcdnIpaDomain(request *DeleteDcdnIpaDomainRequest) (response *DeleteDcdnIpaDomainResponse, err error) {
	response = CreateDeleteDcdnIpaDomainResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDcdnIpaDomainWithChan invokes the dcdn.DeleteDcdnIpaDomain API asynchronously
func (client *Client) DeleteDcdnIpaDomainWithChan(request *DeleteDcdnIpaDomainRequest) (<-chan *DeleteDcdnIpaDomainResponse, <-chan error) {
	responseChan := make(chan *DeleteDcdnIpaDomainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDcdnIpaDomain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDcdnIpaDomainWithCallback invokes the dcdn.DeleteDcdnIpaDomain API asynchronously
func (client *Client) DeleteDcdnIpaDomainWithCallback(request *DeleteDcdnIpaDomainRequest, callback func(response *DeleteDcdnIpaDomainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDcdnIpaDomainResponse
		var err error
		defer close(result)
		response, err = client.DeleteDcdnIpaDomain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDcdnIpaDomainRequest is the request struct for api DeleteDcdnIpaDomain
type DeleteDcdnIpaDomainRequest struct {
	*requests.RpcRequest
	OwnerAccount  string           `position:"Query" name:"OwnerAccount"`
	DomainName    string           `position:"Query" name:"DomainName"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
}

// DeleteDcdnIpaDomainResponse is the response struct for api DeleteDcdnIpaDomain
type DeleteDcdnIpaDomainResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteDcdnIpaDomainRequest creates a request to invoke DeleteDcdnIpaDomain API
func CreateDeleteDcdnIpaDomainRequest() (request *DeleteDcdnIpaDomainRequest) {
	request = &DeleteDcdnIpaDomainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DeleteDcdnIpaDomain", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteDcdnIpaDomainResponse creates a response to parse from DeleteDcdnIpaDomain response
func CreateDeleteDcdnIpaDomainResponse() (response *DeleteDcdnIpaDomainResponse) {
	response = &DeleteDcdnIpaDomainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
