/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.diff;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.text.diff.CommandVisitor;
import org.apache.commons.text.diff.StringsComparator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class StringsComparatorTest {
    private List<String> before;
    private List<String> after;
    private int[] length;
    private int[] lcs;

    @BeforeEach
    public void setUp() {
        this.before = Arrays.asList("bottle", "nematode knowledge", "", "aa", "prefixed string", "ABCABBA", "glop glop", "coq", "spider-man");
        this.after = Arrays.asList("noodle", "empty bottle", "", "C", "prefix", "CBABAC", "pas glop pas glop", "ane", "klingon");
        this.length = new int[]{6, 16, 0, 3, 9, 5, 8, 6, 13};
        this.lcs = new int[]{3, 7, 0, 0, 6, 4, 9, 0, 2};
    }

    @AfterEach
    public void tearDown() {
        this.before = null;
        this.after = null;
        this.length = null;
    }

    @Test
    public void testExecution() {
        for (int i = 0; i < this.before.size(); ++i) {
            ExecutionVisitor ev = new ExecutionVisitor();
            new StringsComparator(this.before.get(i), this.after.get(i)).getScript().visit(ev);
            Assertions.assertThat((String)ev.getString()).isEqualTo(this.after.get(i));
        }
    }

    @Test
    public void testLength() {
        for (int i = 0; i < this.before.size(); ++i) {
            StringsComparator comparator = new StringsComparator(this.before.get(i), this.after.get(i));
            Assertions.assertThat((int)comparator.getScript().getModifications()).isEqualTo(this.length[i]);
        }
    }

    @Test
    public void testLongestCommonSubsequence() {
        for (int i = 0; i < this.before.size(); ++i) {
            StringsComparator comparator = new StringsComparator(this.before.get(i), this.after.get(i));
            Assertions.assertThat((int)comparator.getScript().getLCSLength()).isEqualTo(this.lcs[i]);
        }
    }

    private static final class ExecutionVisitor<T>
    implements CommandVisitor<T> {
        private final StringBuilder v = new StringBuilder();

        ExecutionVisitor() {
        }

        public String getString() {
            return this.v.toString();
        }

        public void visitDeleteCommand(T object) {
        }

        public void visitInsertCommand(T object) {
            this.v.append(object);
        }

        public void visitKeepCommand(T object) {
            this.v.append(object);
        }
    }
}

