// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/gkebackup/logging/v1/logged_backup_plan.proto

package logging

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// BackupPlan as stored in Platform log. It's used to log the details of
// a createBackupPlan/updateBackupPlan request, so only fields that can be taken
// from user input are included here.
type LoggedBackupPlan struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// User specified descriptive string for this BackupPlan.
	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	// GCP resource name of the source cluster for this BackupPlan.
	Cluster string `protobuf:"bytes,2,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// RetentionPolicy governs lifecycle of Backups created under this plan.
	RetentionPolicy *LoggedBackupPlan_RetentionPolicy `protobuf:"bytes,3,opt,name=retention_policy,json=retentionPolicy,proto3" json:"retention_policy,omitempty"`
	// A set of custom labels supplied by user.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Defines scheduled Backup creation under this BackupPlan.
	BackupSchedule *LoggedBackupPlan_Schedule `protobuf:"bytes,5,opt,name=backup_schedule,json=backupSchedule,proto3" json:"backup_schedule,omitempty"`
	// A flag indicates whether the plan has been deactivated.
	Deactivated bool `protobuf:"varint,6,opt,name=deactivated,proto3" json:"deactivated,omitempty"`
	// Defines backup configuration of this BackupPlan.
	BackupConfig *LoggedBackupPlan_BackupConfig `protobuf:"bytes,7,opt,name=backup_config,json=backupConfig,proto3" json:"backup_config,omitempty"`
}

func (x *LoggedBackupPlan) Reset() {
	*x = LoggedBackupPlan{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoggedBackupPlan) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoggedBackupPlan) ProtoMessage() {}

func (x *LoggedBackupPlan) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoggedBackupPlan.ProtoReflect.Descriptor instead.
func (*LoggedBackupPlan) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto_rawDescGZIP(), []int{0}
}

func (x *LoggedBackupPlan) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *LoggedBackupPlan) GetCluster() string {
	if x != nil {
		return x.Cluster
	}
	return ""
}

func (x *LoggedBackupPlan) GetRetentionPolicy() *LoggedBackupPlan_RetentionPolicy {
	if x != nil {
		return x.RetentionPolicy
	}
	return nil
}

func (x *LoggedBackupPlan) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *LoggedBackupPlan) GetBackupSchedule() *LoggedBackupPlan_Schedule {
	if x != nil {
		return x.BackupSchedule
	}
	return nil
}

func (x *LoggedBackupPlan) GetDeactivated() bool {
	if x != nil {
		return x.Deactivated
	}
	return false
}

func (x *LoggedBackupPlan) GetBackupConfig() *LoggedBackupPlan_BackupConfig {
	if x != nil {
		return x.BackupConfig
	}
	return nil
}

// RentionPolicy is an inner message type to define:
// 1. When to automatically delete Backups created under this BackupPlan
// 2. A plan level minimum Backup retain days which blocks deletion
// 3. Lock to disallow any policy updates
type LoggedBackupPlan_RetentionPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number of days during which deletion of a Backup created under this
	// BackupPlan will be blocked.
	BackupDeleteLockDays int32 `protobuf:"varint,1,opt,name=backup_delete_lock_days,json=backupDeleteLockDays,proto3" json:"backup_delete_lock_days,omitempty"`
	// Number of days after which the service will delete a Backup.
	// If specified, a Backup created under this BackupPlan will be
	// automatically deleted after its age reaches create_time +
	// backup_retain_days.
	BackupRetainDays int32 `protobuf:"varint,2,opt,name=backup_retain_days,json=backupRetainDays,proto3" json:"backup_retain_days,omitempty"`
	// A flag denotes that the retention policy of this BackupPlan is locked.
	// If set to True, no further update is allowed on this policy, including
	// the 'locked' field itself.
	// Default to False.
	Locked bool `protobuf:"varint,3,opt,name=locked,proto3" json:"locked,omitempty"`
}

func (x *LoggedBackupPlan_RetentionPolicy) Reset() {
	*x = LoggedBackupPlan_RetentionPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoggedBackupPlan_RetentionPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoggedBackupPlan_RetentionPolicy) ProtoMessage() {}

func (x *LoggedBackupPlan_RetentionPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoggedBackupPlan_RetentionPolicy.ProtoReflect.Descriptor instead.
func (*LoggedBackupPlan_RetentionPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto_rawDescGZIP(), []int{0, 0}
}

func (x *LoggedBackupPlan_RetentionPolicy) GetBackupDeleteLockDays() int32 {
	if x != nil {
		return x.BackupDeleteLockDays
	}
	return 0
}

func (x *LoggedBackupPlan_RetentionPolicy) GetBackupRetainDays() int32 {
	if x != nil {
		return x.BackupRetainDays
	}
	return 0
}

func (x *LoggedBackupPlan_RetentionPolicy) GetLocked() bool {
	if x != nil {
		return x.Locked
	}
	return false
}

// Schedule, an inner message type defines a cron schedule.
type LoggedBackupPlan_Schedule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A cron style string schedule on which an operation will be executed.
	CronSchedule string `protobuf:"bytes,1,opt,name=cron_schedule,json=cronSchedule,proto3" json:"cron_schedule,omitempty"`
	// A flag to toggle scheduled operation.
	Paused bool `protobuf:"varint,2,opt,name=paused,proto3" json:"paused,omitempty"`
}

func (x *LoggedBackupPlan_Schedule) Reset() {
	*x = LoggedBackupPlan_Schedule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoggedBackupPlan_Schedule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoggedBackupPlan_Schedule) ProtoMessage() {}

func (x *LoggedBackupPlan_Schedule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoggedBackupPlan_Schedule.ProtoReflect.Descriptor instead.
func (*LoggedBackupPlan_Schedule) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto_rawDescGZIP(), []int{0, 1}
}

func (x *LoggedBackupPlan_Schedule) GetCronSchedule() string {
	if x != nil {
		return x.CronSchedule
	}
	return ""
}

func (x *LoggedBackupPlan_Schedule) GetPaused() bool {
	if x != nil {
		return x.Paused
	}
	return false
}

// BackupConfig, an inner message type defines the configuration of creating
// a backup from this BackupPlan
type LoggedBackupPlan_BackupConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to BackupScope:
	//	*LoggedBackupPlan_BackupConfig_AllNamespaces
	//	*LoggedBackupPlan_BackupConfig_SelectedNamespaces
	//	*LoggedBackupPlan_BackupConfig_SelectedApplications
	BackupScope isLoggedBackupPlan_BackupConfig_BackupScope `protobuf_oneof:"backup_scope"`
	// A boolean flag specifies whether volume data should be backed up
	IncludeVolumeData bool `protobuf:"varint,4,opt,name=include_volume_data,json=includeVolumeData,proto3" json:"include_volume_data,omitempty"`
	// A boolean flag specifies whether secrets should be backed up
	IncludeSecrets bool `protobuf:"varint,5,opt,name=include_secrets,json=includeSecrets,proto3" json:"include_secrets,omitempty"`
	// Custom encryption key. For preview, support GCP KMS only.
	// This only contains the key metadata, and no key material.
	EncryptionKey *EncryptionKey `protobuf:"bytes,6,opt,name=encryption_key,json=encryptionKey,proto3" json:"encryption_key,omitempty"`
}

func (x *LoggedBackupPlan_BackupConfig) Reset() {
	*x = LoggedBackupPlan_BackupConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LoggedBackupPlan_BackupConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoggedBackupPlan_BackupConfig) ProtoMessage() {}

func (x *LoggedBackupPlan_BackupConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoggedBackupPlan_BackupConfig.ProtoReflect.Descriptor instead.
func (*LoggedBackupPlan_BackupConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto_rawDescGZIP(), []int{0, 2}
}

func (m *LoggedBackupPlan_BackupConfig) GetBackupScope() isLoggedBackupPlan_BackupConfig_BackupScope {
	if m != nil {
		return m.BackupScope
	}
	return nil
}

func (x *LoggedBackupPlan_BackupConfig) GetAllNamespaces() bool {
	if x, ok := x.GetBackupScope().(*LoggedBackupPlan_BackupConfig_AllNamespaces); ok {
		return x.AllNamespaces
	}
	return false
}

func (x *LoggedBackupPlan_BackupConfig) GetSelectedNamespaces() *Namespaces {
	if x, ok := x.GetBackupScope().(*LoggedBackupPlan_BackupConfig_SelectedNamespaces); ok {
		return x.SelectedNamespaces
	}
	return nil
}

func (x *LoggedBackupPlan_BackupConfig) GetSelectedApplications() *NamespacedNames {
	if x, ok := x.GetBackupScope().(*LoggedBackupPlan_BackupConfig_SelectedApplications); ok {
		return x.SelectedApplications
	}
	return nil
}

func (x *LoggedBackupPlan_BackupConfig) GetIncludeVolumeData() bool {
	if x != nil {
		return x.IncludeVolumeData
	}
	return false
}

func (x *LoggedBackupPlan_BackupConfig) GetIncludeSecrets() bool {
	if x != nil {
		return x.IncludeSecrets
	}
	return false
}

func (x *LoggedBackupPlan_BackupConfig) GetEncryptionKey() *EncryptionKey {
	if x != nil {
		return x.EncryptionKey
	}
	return nil
}

type isLoggedBackupPlan_BackupConfig_BackupScope interface {
	isLoggedBackupPlan_BackupConfig_BackupScope()
}

type LoggedBackupPlan_BackupConfig_AllNamespaces struct {
	// If set to true, backup whole cluster
	AllNamespaces bool `protobuf:"varint,1,opt,name=all_namespaces,json=allNamespaces,proto3,oneof"`
}

type LoggedBackupPlan_BackupConfig_SelectedNamespaces struct {
	// If set, backup the list of namespaces
	SelectedNamespaces *Namespaces `protobuf:"bytes,2,opt,name=selected_namespaces,json=selectedNamespaces,proto3,oneof"`
}

type LoggedBackupPlan_BackupConfig_SelectedApplications struct {
	// If set, backup the list of applications
	SelectedApplications *NamespacedNames `protobuf:"bytes,3,opt,name=selected_applications,json=selectedApplications,proto3,oneof"`
}

func (*LoggedBackupPlan_BackupConfig_AllNamespaces) isLoggedBackupPlan_BackupConfig_BackupScope() {}

func (*LoggedBackupPlan_BackupConfig_SelectedNamespaces) isLoggedBackupPlan_BackupConfig_BackupScope() {
}

func (*LoggedBackupPlan_BackupConfig_SelectedApplications) isLoggedBackupPlan_BackupConfig_BackupScope() {
}

var File_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto protoreflect.FileDescriptor

var file_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto_rawDesc = []byte{
	0x0a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67,
	0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67,
	0x2f, 0x76, 0x31, 0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x65, 0x64, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x21, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x1a,
	0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6b,
	0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2f,
	0x76, 0x31, 0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xe5, 0x09, 0x0a, 0x10, 0x4c, 0x6f, 0x67, 0x67, 0x65,
	0x64, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a,
	0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x6e, 0x0a, 0x10, 0x72, 0x65, 0x74, 0x65, 0x6e,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69,
	0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x67, 0x65, 0x64, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x2e, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x0f, 0x72, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x57, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x67,
	0x65, 0x64, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x2e, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x12, 0x65, 0x0a, 0x0f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64,
	0x75, 0x6c, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f,
	0x67, 0x67, 0x65, 0x64, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x2e, 0x53,
	0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x52, 0x0e, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x53,
	0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x61, 0x63, 0x74,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x64, 0x65,
	0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x65, 0x64, 0x12, 0x65, 0x0a, 0x0d, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x67, 0x65, 0x64, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x50, 0x6c, 0x61, 0x6e, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x0c, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x1a, 0x8e, 0x01, 0x0a, 0x0f, 0x52, 0x65, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x12, 0x35, 0x0a, 0x17, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x64, 0x61, 0x79, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x14, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x4c, 0x6f, 0x63, 0x6b, 0x44, 0x61, 0x79, 0x73, 0x12, 0x2c, 0x0a, 0x12, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6e, 0x5f, 0x64, 0x61, 0x79,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52,
	0x65, 0x74, 0x61, 0x69, 0x6e, 0x44, 0x61, 0x79, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x6c, 0x6f, 0x63,
	0x6b, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x6c, 0x6f, 0x63, 0x6b, 0x65,
	0x64, 0x1a, 0x47, 0x0a, 0x08, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x12, 0x23, 0x0a,
	0x0d, 0x63, 0x72, 0x6f, 0x6e, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x72, 0x6f, 0x6e, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75,
	0x6c, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x75, 0x73, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x06, 0x70, 0x61, 0x75, 0x73, 0x65, 0x64, 0x1a, 0xc6, 0x03, 0x0a, 0x0c, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x27, 0x0a, 0x0e, 0x61,
	0x6c, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x0d, 0x61, 0x6c, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x73, 0x12, 0x60, 0x0a, 0x13, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69,
	0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73,
	0x48, 0x00, 0x52, 0x12, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4e, 0x61, 0x6d, 0x65,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x12, 0x69, 0x0a, 0x15, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74,
	0x65, 0x64, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x6c,
	0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x48, 0x00, 0x52, 0x14, 0x73, 0x65, 0x6c,
	0x65, 0x63, 0x74, 0x65, 0x64, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x2e, 0x0a, 0x13, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x76, 0x6f, 0x6c,
	0x75, 0x6d, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11,
	0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x44, 0x61, 0x74,
	0x61, 0x12, 0x27, 0x0a, 0x0f, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x73, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0e, 0x69, 0x6e, 0x63, 0x6c,
	0x75, 0x64, 0x65, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x12, 0x57, 0x0a, 0x0e, 0x65, 0x6e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x6c, 0x6f, 0x67, 0x67,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x4b, 0x65, 0x79, 0x52, 0x0d, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x4b, 0x65, 0x79, 0x42, 0x0e, 0x0a, 0x0c, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x73, 0x63,
	0x6f, 0x70, 0x65, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0xf6,
	0x01, 0x0a, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x31, 0x42, 0x15, 0x4c, 0x6f, 0x67, 0x67, 0x65, 0x64, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x50, 0x6c, 0x61, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x48, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67,
	0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67, 0x6b, 0x65, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x2f, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x3b,
	0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0xaa, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x47, 0x6b, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x2e, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x21, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x47, 0x6b, 0x65, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x5c, 0x4c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x5c, 0x56, 0x31, 0xea,
	0x02, 0x25, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a,
	0x3a, 0x47, 0x6b, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x3a, 0x3a, 0x4c, 0x6f, 0x67, 0x67,
	0x69, 0x6e, 0x67, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto_rawDescOnce sync.Once
	file_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto_rawDescData = file_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto_rawDesc
)

func file_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto_rawDescGZIP() []byte {
	file_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto_rawDescOnce.Do(func() {
		file_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto_rawDescData)
	})
	return file_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto_rawDescData
}

var file_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto_goTypes = []interface{}{
	(*LoggedBackupPlan)(nil),                 // 0: google.cloud.gkebackup.logging.v1.LoggedBackupPlan
	(*LoggedBackupPlan_RetentionPolicy)(nil), // 1: google.cloud.gkebackup.logging.v1.LoggedBackupPlan.RetentionPolicy
	(*LoggedBackupPlan_Schedule)(nil),        // 2: google.cloud.gkebackup.logging.v1.LoggedBackupPlan.Schedule
	(*LoggedBackupPlan_BackupConfig)(nil),    // 3: google.cloud.gkebackup.logging.v1.LoggedBackupPlan.BackupConfig
	nil,                                      // 4: google.cloud.gkebackup.logging.v1.LoggedBackupPlan.LabelsEntry
	(*Namespaces)(nil),                       // 5: google.cloud.gkebackup.logging.v1.Namespaces
	(*NamespacedNames)(nil),                  // 6: google.cloud.gkebackup.logging.v1.NamespacedNames
	(*EncryptionKey)(nil),                    // 7: google.cloud.gkebackup.logging.v1.EncryptionKey
}
var file_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto_depIdxs = []int32{
	1, // 0: google.cloud.gkebackup.logging.v1.LoggedBackupPlan.retention_policy:type_name -> google.cloud.gkebackup.logging.v1.LoggedBackupPlan.RetentionPolicy
	4, // 1: google.cloud.gkebackup.logging.v1.LoggedBackupPlan.labels:type_name -> google.cloud.gkebackup.logging.v1.LoggedBackupPlan.LabelsEntry
	2, // 2: google.cloud.gkebackup.logging.v1.LoggedBackupPlan.backup_schedule:type_name -> google.cloud.gkebackup.logging.v1.LoggedBackupPlan.Schedule
	3, // 3: google.cloud.gkebackup.logging.v1.LoggedBackupPlan.backup_config:type_name -> google.cloud.gkebackup.logging.v1.LoggedBackupPlan.BackupConfig
	5, // 4: google.cloud.gkebackup.logging.v1.LoggedBackupPlan.BackupConfig.selected_namespaces:type_name -> google.cloud.gkebackup.logging.v1.Namespaces
	6, // 5: google.cloud.gkebackup.logging.v1.LoggedBackupPlan.BackupConfig.selected_applications:type_name -> google.cloud.gkebackup.logging.v1.NamespacedNames
	7, // 6: google.cloud.gkebackup.logging.v1.LoggedBackupPlan.BackupConfig.encryption_key:type_name -> google.cloud.gkebackup.logging.v1.EncryptionKey
	7, // [7:7] is the sub-list for method output_type
	7, // [7:7] is the sub-list for method input_type
	7, // [7:7] is the sub-list for extension type_name
	7, // [7:7] is the sub-list for extension extendee
	0, // [0:7] is the sub-list for field type_name
}

func init() { file_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto_init() }
func file_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto_init() {
	if File_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto != nil {
		return
	}
	file_google_cloud_gkebackup_logging_v1_logged_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoggedBackupPlan); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoggedBackupPlan_RetentionPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoggedBackupPlan_Schedule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LoggedBackupPlan_BackupConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*LoggedBackupPlan_BackupConfig_AllNamespaces)(nil),
		(*LoggedBackupPlan_BackupConfig_SelectedNamespaces)(nil),
		(*LoggedBackupPlan_BackupConfig_SelectedApplications)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto_goTypes,
		DependencyIndexes: file_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto_depIdxs,
		MessageInfos:      file_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto_msgTypes,
	}.Build()
	File_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto = out.File
	file_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto_rawDesc = nil
	file_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto_goTypes = nil
	file_google_cloud_gkebackup_logging_v1_logged_backup_plan_proto_depIdxs = nil
}
