/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.effects;

import com.jeta.forms.gui.effects.Painter;
import com.jeta.forms.store.properties.effects.RadialGradientProperty;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.apache.batik.ext.awt.RadialGradientPaint;

public class RadialGradientPainter
implements Painter {
    private RadialGradientProperty m_gradient_prop;
    private Paint m_cached_paint;
    private Rectangle m_last_rect = new Rectangle();
    private LookAndFeel m_look_and_feel;
    private int m_radius_type = 0;
    public static final int SQUARE_BASED = 0;
    public static final int WIDTH_BASED = 1;
    public static final int HEIGHT_BASED = 2;

    public RadialGradientPainter() {
    }

    public RadialGradientPainter(RadialGradientProperty radialGradientProperty) {
        this.m_gradient_prop = radialGradientProperty;
    }

    private double calculateRadius(double d, double d2, int n) {
        if (this.m_radius_type == 1) {
            return d * (double)n / 100.0;
        }
        if (this.m_radius_type == 2) {
            return d2 * (double)n / 100.0;
        }
        return Math.sqrt(Math.pow(d, 2.0) + Math.pow(d2, 2.0)) * (double)n / 100.0;
    }

    private Paint createPaint(Rectangle rectangle, RadialGradientProperty radialGradientProperty) {
        double d = rectangle.getWidth() / 2.0;
        double d2 = rectangle.getHeight() / 2.0;
        double d3 = rectangle.getX() + d;
        double d4 = rectangle.getY() + d2;
        double d5 = (double)radialGradientProperty.getMagnitude() * rectangle.getWidth() / 400.0;
        if (radialGradientProperty.getPosition() == 0) {
            d3 = rectangle.getX();
            d4 = rectangle.getY();
            d5 = this.calculateRadius(d, d2, radialGradientProperty.getMagnitude());
        } else if (radialGradientProperty.getPosition() == 1) {
            d3 = d;
            d4 = rectangle.getY();
            d5 = d * (double)radialGradientProperty.getMagnitude() / 100.0;
        } else if (radialGradientProperty.getPosition() == 2) {
            d3 = rectangle.getX() + rectangle.getWidth();
            d4 = rectangle.getY();
            d5 = this.calculateRadius(d, d2, radialGradientProperty.getMagnitude());
        } else if (radialGradientProperty.getPosition() == 4) {
            d3 = rectangle.getX();
            d4 = rectangle.getY() + rectangle.getHeight();
            d5 = this.calculateRadius(d, d2, radialGradientProperty.getMagnitude());
        } else if (radialGradientProperty.getPosition() == 5) {
            d3 = d;
            d4 = rectangle.getY() + rectangle.getHeight();
            d5 = d * (double)radialGradientProperty.getMagnitude() / 100.0;
        } else if (radialGradientProperty.getPosition() == 6) {
            d3 = rectangle.getX() + rectangle.getWidth();
            d4 = rectangle.getY() + rectangle.getHeight();
            d5 = this.calculateRadius(d, d2, radialGradientProperty.getMagnitude());
        } else if (radialGradientProperty.getPosition() == 7) {
            d3 = rectangle.getX();
            d4 = rectangle.getY() + d2;
            d5 = d2 * (double)radialGradientProperty.getMagnitude() / 100.0;
        } else if (radialGradientProperty.getPosition() == 8) {
            d3 = rectangle.getX() + rectangle.getWidth();
            d4 = rectangle.getY() + d2;
            d5 = d2 * (double)radialGradientProperty.getMagnitude() / 100.0;
        }
        float[] fArray = new float[]{0.0f, 1.0f};
        Color[] colorArray = new Color[]{radialGradientProperty.getStartColor().getColor(), radialGradientProperty.getEndColor().getColor()};
        RadialGradientPaint radialGradientPaint = new RadialGradientPaint((float)d3, (float)d4, (float)d5, fArray, colorArray);
        return radialGradientPaint;
    }

    public void paint(Component component, Graphics graphics, Rectangle rectangle) {
        if (rectangle == null || this.m_gradient_prop == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (this.m_look_and_feel != lookAndFeel) {
            this.m_cached_paint = null;
            this.m_look_and_feel = lookAndFeel;
        }
        if (this.m_cached_paint == null || !rectangle.equals(this.m_last_rect)) {
            this.m_last_rect.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.m_cached_paint = this.createPaint(rectangle, this.m_gradient_prop);
        }
        graphics2D.setPaint(this.m_cached_paint);
        Rectangle rectangle2 = graphics.getClipBounds();
        if (rectangle.intersects(rectangle2)) {
            Rectangle rectangle3 = rectangle.intersection(rectangle2);
            graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            graphics2D.setPaint(paint);
        }
        graphics2D.setPaint(paint);
    }

    public void setGradientProperty(RadialGradientProperty radialGradientProperty) {
        this.m_cached_paint = null;
        this.m_gradient_prop = radialGradientProperty;
    }

    public void setRadiusType(int n) {
        this.m_radius_type = n;
    }
}

