## RabbitMQ 3.8.19

RabbitMQ `3.8.19` is a maintenance release.

### Obtaining Packages

RabbitMQ releases are distributed via [GitHub](https://github.com/rabbitmq/rabbitmq-server/releases), [Cloudsmith](https://cloudsmith.io/~rabbitmq/repos/),
and [PackageCloud](https://packagecloud.io/rabbitmq).

### Erlang/OTP Compatibility Notes

This release [requires Erlang 23.2](https://www.rabbitmq.com/which-erlang.html) and [supports Erlang 24](https://blog.rabbitmq.com/posts/2021/03/erlang-24-support-roadmap/).

[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains
what package repositories and tools can be used to provision modern Erlang versions.


## Upgrade and Compatibility Notes

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades and
[RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.

If upgrading from a`3.7.x` release, see [3.8.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.8.0)
upgrade and compatibility notes first.

If upgrading from a `3.6.x` or older [release series](https://www.rabbitmq.com/versions.html), first upgrade
to [`3.7.27`](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.7.27) and then to this version.


## Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the [RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users)
and [RabbitMQ community Slack](https://rabbitmq-slack.herokuapp.com/).


## Changes Worth Mentioning

### Core Server

#### Enhancements

 * Binding recovery on node startup is now more efficient. This means in clusters with a lot of
   queues and/or bindings, nodes start quicker.

   GitHub issue: [#3137](https://github.com/rabbitmq/rabbitmq-server/pull/3137)

 * Plugin directory paths are now deduplicated, so if a single directory is specified
   more than ones, the node won't complain about duplicate plugins.

   GitHub issue: [#3155](https://github.com/rabbitmq/rabbitmq-server/issues/3155)

 * Startup banner and log entries now use path separators more consistently on Windows.

   Thanks to Linda @LindaLawton Lawton for pointing out the inconsistency.

   GitHub issue: [#3149](https://github.com/rabbitmq/rabbitmq-server/issues/3149)



### Shovel Plugin

#### Bug Fixes

  * When dynamic Shovels are started the plugin now acquires a distributed lock.
    This is generally not necessary but helps avoid duplicate Shovels being started
    via import of a definition file on every cluster node during cluster formation.

    GitHub issue: [#3167](https://github.com/rabbitmq/rabbitmq-server/pull/3167)


## Dependency Upgrades

No dependency changes in this release.


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.8.19.tar.xz`
instead of the source tarball produced by GitHub.
