RabbitMQ `3.11.1` is a maintenance release in the `3.11.x` [release series](https://www.rabbitmq.com/versions.html).

Please refer to the upgrade section from [v3.11.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.11.0)
if upgrading from a version prior to 3.11.0.

This release requires Erlang 25.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

As of 3.11.0, RabbitMQ requires Erlang 25. Nodes **will fail to start** on older Erlang releases.

Erlang 25 as our new baseline means much improved performance on ARM64 architectures, [profiling with flame graphs](https://blog.rabbitmq.com/posts/2022/05/flame-graphs/)
across all architectures, and the most recent TLS 1.3 implementation available to all RabbitMQ 3.11 users.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.11.x/release-notes).


### Core Server

#### Bug Fixes

  * A rolling upgrade on Kubernetes could hang.

    GitHub issue: [#6034](https://github.com/rabbitmq/rabbitmq-server/issues/6034)

  * In mixed 3.11/3.10 clusters, channels that performed operations on classic queues could
    run into an exception.

    GitHub issue: [#5931](https://github.com/rabbitmq/rabbitmq-server/issues/5931)

  * A quorum queue consumer was cancelled and immediately re-registered while some
    deliveries were in flight could result in a channel exception.

    GitHub issue: [#5927](https://github.com/rabbitmq/rabbitmq-server/issues/5927)

  * More strings from external sources are converted to Unicode-aware representation
    internally, in log messages, CLI tools output and UI, and so on.

    GitHub issues: [#5551](https://github.com/rabbitmq/rabbitmq-server/pull/5551)

  * During plugin activation on a running node, plugins with dependencies were added to runtime code path
    in an order that could break if a plugin had hard transitive dependencies (that must be loaded first).

    Contributed by @gomoripeti.

    GitHub issue: [#6019](https://github.com/rabbitmq/rabbitmq-server/pull/6019)

#### Enhancements

 * Support for paths with non-ASCII (Unicode) characters in paths.

 * `rabbitmq-diagnostics observer` now includes a new tab that provides access to internal classic queue
   metrics.

   GitHub issue: [#6074](https://github.com/rabbitmq/rabbitmq-server/pull/6074)


### Stream Plugin

#### Bug Fixes

 * Replicas of a stream that had a Single Active Consumer on it could run into an exception.

   GitHub issue: [#5889](https://github.com/rabbitmq/rabbitmq-server/issues/5889)

 * Stream protocol implementation used incorrect keys in `RouteResponse` and `PartitionResponse` frames.

   GitHub issue: [#5956](https://github.com/rabbitmq/rabbitmq-server/issues/5956)

#### Enhancements

 * When a superstream (partitioned stream) is added using CLI tools, its primary replica will now
   be placed according to the `balanced` leader placement strategy. Previously it was using "node local"
   which resulted in much less even superstream leader replica distribution across cluster nodes.

   GitHub issue: [#5966](https://github.com/rabbitmq/rabbitmq-server/pull/5966)


### AMQP 1.0 Plugin

#### Bug Fixes

 * `rabbitmqctl list_amqp10_connections` were not listing connections correctly.

   GitHub issue: [#4238](https://github.com/rabbitmq/rabbitmq-server/issues/4238)


### Shovel Management Plugin

#### Bug Fixes

 * Shovel management HTTP API endpoint could run into an exception.

   Contributed by @gomoripeti.

   GitHub issue: [#5892](https://github.com/rabbitmq/rabbitmq-server/pull/5892)



## Dependency Upgrades

 * `cuttlefish` upgraded to [`3.1.0`](https://github.com/Kyorai/cuttlefish/releases)


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.11.1.tar.xz`
instead of the source tarball produced by GitHub.
