# This flake was initially generated by fh, the CLI for FlakeHub (version 0.1.9)
{

  # Flake inputs
  inputs = {
    pre-commit-hooks.url = "github:cachix/pre-commit-hooks.nix";

    flake-schemas.url = "https://flakehub.com/f/DeterminateSystems/flake-schemas/*.tar.gz";

    nixpkgs.url = "https://flakehub.com/f/NixOS/nixpkgs/*";
  };

  # Flake outputs that other flakes can use
  outputs =
    {
      self,
      flake-schemas,
      nixpkgs,
      pre-commit-hooks,
    }:
    let
      # Helpers for producing system-specific outputs
      supportedSystems = [
        "x86_64-linux"
        "aarch64-darwin"
        "x86_64-darwin"
        "aarch64-linux"
      ];
      forEachSupportedSystem =
        f:
        nixpkgs.lib.genAttrs supportedSystems (
          system:
          f {
            pkgs = import nixpkgs { inherit system; };
          }
        );
    in
    {
      # Schemas tell Nix about the structure of your flake's outputs
      schemas = flake-schemas.schemas;

      checks = forEachSupportedSystem (
        { pkgs }:
        {
          pre-commit-check = pre-commit-hooks.lib.${pkgs.system}.run {
            src = builtins.path {
              path = ./.;
              name = "source";
            };
            hooks = {
              nil.enable = true;

              shellcheck.enable = true;

              golangci-lint.enable = false;
              golines.enable = true;
              gotest.enable = true;
              gofmt.enable = true; # TODO: switch to `gofumpt`
            };
          };
        }
      );

      packages = forEachSupportedSystem (
        { pkgs }:
        {
          default = pkgs.buildGoModule {
            pname = "goimapnotify";
            version = "2.5.3";

            src = builtins.path {
              path = ./.;
              name = "source";
            };

            modSha256 = "sha256-5cZzaCoOR1R7iST0q3GaJbYIbKKEigeWqhp87maOL04=";
            vendorHash = "sha256-5cZzaCoOR1R7iST0q3GaJbYIbKKEigeWqhp87maOL04=";

            postPatch = ''
              for f in command.go command_test.go; do
                substituteInPlace $f --replace '"sh"' '"${pkgs.bash}/bin/sh"'
              done
            '';

            meta = with pkgs.lib; {
              description = "Execute scripts on IMAP mailbox changes (new/deleted/updated messages) using IDLE, golang version";
              license = licenses.gpl3;
              homepage = "https://gitlab.com/shackra/goimapnotify";
              changelog = "https://gitlab.com/shackra/goimapnotify/-/blob/master/CHANGELOG.md?ref_type=heads";
              mainProgram = "goimapnotify";
              maintainers = with maintainers; [ shackra ];
              platforms = platforms.all;
            };
          };
        }
      );
      # Development environments
      devShells = forEachSupportedSystem (
        { pkgs }:
        {
          default = pkgs.mkShell {
            # Environment variables
            env = {
              CGO_CFLAGS = "-O2 -g -Wno-error";
              GOTOOLCHAIN = "local";
              GOTRACEBACK = "all";
            };
            # Pinned packages available in the environment
            packages = with pkgs; [
              nil

              go
              gopls
              gotools
              golines
              golangci-lint
              golangci-lint-langserver
              gomodifytags
              delve
              gdlv
              panicparse

              nodePackages_latest.bash-language-server

              git-chglog
            ];
            inherit (self.checks.${pkgs.system}.pre-commit-check) shellHook;
          };
        }
      );
    };
}
