// VirKeyboard.h
// generated by Fast Light User Interface Designer (fluid) version 1.0404

#ifndef VirKeyboardUI_h
#define VirKeyboardUI_h
#include <FL/Fl.H>

// Original ZynAddSubFX author Nasca Octavian Paul
// Copyright (C) 2002-2005 Nasca Octavian Paul
// Copyright 2009-2010, Alan Calvert
// Copyright 2014-2024, Will Godfrey

// This file is part of yoshimi, which is free software: you can redistribute
// it and/or modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either version 2 of
// the License, or (at your option) any later version.

// yoshimi is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.   See the GNU General Public License (version 2 or
// later) for more details.

// You should have received a copy of the GNU General Public License along with
// yoshimi; if not, write to the Free Software Foundation, Inc., 51 Franklin
// Street, Fifth Floor, Boston, MA  02110-1301, USA.

// This file is a derivative of original ZynAddSubFX code


#include <stdlib.h>
#include <FL/fl_draw.H>
#include <FL/Fl_Box.H>
#include "Misc/Config.h"
#include "Misc/SynthEngine.h"
#include "UI/WidgetPDial.h"
#include "UI/WidgetSpinner.h"
#include "UI/WidgetMWSlider.h"
#include "UI/ScaleTrackedWindow.h"
#define WHITE_KEY_COLOUR 0xFAF0E600
#define WHITE_KEY_PRESSED 0xBEB4AA00
#define BLACK_KEY_COLOUR 0x01010100
#define BLACK_KEY_PRESSED 0x70807000

class VirKeys : public Fl_Box {
  static const int N_OCT = 6;
public:
  VirKeys(int x,int y, int w, int h, const char *label=0);
  void init(SynthEngine *_synth, float &scaledWhite, float &scaledBlack);
  void draw();
  void send_data(int action, int control, float value, int type, int kititem = UNUSED, int engine = UNUSED);
  int handle(int event);
  void presskey(int nk,int exclusive,int type);
  void releasekey(int nk,int type);
  void relaseallkeys(int type);
private:
  int pressed[N_OCT * 12 + 1];
public:
  int pitchWh;
  unsigned char midich;
  unsigned char midivel;
  char midioct, keyoct1, keyoct2;
  unsigned char rndvelocity;
private:
  SynthEngine *synth;
  float *keyWhite;
  float *keyBlack;
};
#include <FL/Fl_Counter.H>
#include <FL/Fl_Text_Display.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Choice.H>

class VirKeyboard {
public:
  ScaleTrackedWindow* make_window();
  ScaleTrackedWindow *virkeyboardwindow;
private:
  inline void cb_virkeyboardwindow_i(ScaleTrackedWindow*, void*);
  static void cb_virkeyboardwindow(ScaleTrackedWindow*, void*);
public:
  VirKeys *virkeys;
  Fl_Counter *key;
private:
  inline void cb_key_i(Fl_Counter*, void*);
  static void cb_key(Fl_Counter*, void*);
public:
  Fl_Text_Display *oct1;
  Fl_Counter *maps;
private:
  inline void cb_maps_i(Fl_Counter*, void*);
  static void cb_maps(Fl_Counter*, void*);
public:
  Fl_Text_Display *oct2;
  mwheel_slider_rev *velocity;
private:
  inline void cb_velocity_i(mwheel_slider_rev*, void*);
  static void cb_velocity(mwheel_slider_rev*, void*);
public:
  Fl_Counter *octave;
private:
  inline void cb_octave_i(Fl_Counter*, void*);
  static void cb_octave(Fl_Counter*, void*);
public:
  Fl_Button *virtClose;
private:
  inline void cb_virtClose_i(Fl_Button*, void*);
  static void cb_virtClose(Fl_Button*, void*);
public:
  mwheel_slider *controlslider;
private:
  inline void cb_controlslider_i(mwheel_slider*, void*);
  static void cb_controlslider(mwheel_slider*, void*);
public:
  Fl_Choice *controller;
private:
  inline void cb_controller_i(Fl_Choice*, void*);
  static void cb_controller(Fl_Choice*, void*);
public:
  WidgetPDial *random;
private:
  inline void cb_random_i(WidgetPDial*, void*);
  static void cb_random(WidgetPDial*, void*);
public:
  WidgetSpinner *midichannel;
private:
  inline void cb_midichannel_i(WidgetSpinner*, void*);
  static void cb_midichannel(WidgetSpinner*, void*);
public:
  mwheel_slider *pitchwheel;
private:
  inline void cb_pitchwheel_i(mwheel_slider*, void*);
  static void cb_pitchwheel(mwheel_slider*, void*);
public:
  void setpoint2midictl(int setpoint);
  int findcontroller(int setpoint);
  VirKeyboard(SynthEngine *_synth);
  ~VirKeyboard();
  void send_data(int action, int control, float value, int type, int kititem = UNUSED, int engine = UNUSED);
  void ShowKbd();
  void Hide();
  void relaseallkeys();
  void virtRtext();
private:
  int midictl;
  int oldcontrol;
  SynthEngine *synth;
  std::string keyboardlabel;
  int virtDW;
  int virtDH;
public:
  int lastvirtW;
private:
  bool virtSeen;
  float scaledWhite;
  float scaledBlack;
};
#endif
