/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUQuerySet.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSGPUQueryType.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsGPUQuerySetPrototypeFunction_destroy);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsGPUQuerySetConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUQuerySet_type);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUQuerySet_count);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUQuerySet_label);
static JSC_DECLARE_CUSTOM_SETTER(setJSGPUQuerySet_label);

class JSGPUQuerySetPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSGPUQuerySetPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGPUQuerySetPrototype* ptr = new (NotNull, JSC::allocateCell<JSGPUQuerySetPrototype>(vm)) JSGPUQuerySetPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUQuerySetPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGPUQuerySetPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUQuerySetPrototype, JSGPUQuerySetPrototype::Base);

using JSGPUQuerySetDOMConstructor = JSDOMConstructorNotConstructable<JSGPUQuerySet>;

template<> const ClassInfo JSGPUQuerySetDOMConstructor::s_info = { "GPUQuerySet"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUQuerySetDOMConstructor) };

template<> JSValue JSGPUQuerySetDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSGPUQuerySetDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "GPUQuerySet"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSGPUQuerySet::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 5> JSGPUQuerySetPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUQuerySetConstructor, 0 } },
    HashTableValue { "type"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUQuerySet_type, 0 } },
    HashTableValue { "count"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUQuerySet_count, 0 } },
    HashTableValue { "label"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUQuerySet_label, setJSGPUQuerySet_label } },
    HashTableValue { "destroy"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUQuerySetPrototypeFunction_destroy, 0 } },
};

const ClassInfo JSGPUQuerySetPrototype::s_info = { "GPUQuerySet"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUQuerySetPrototype) };

void JSGPUQuerySetPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGPUQuerySet::info(), JSGPUQuerySetPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().webGPUEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "label"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSGPUQuerySet::s_info = { "GPUQuerySet"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUQuerySet) };

JSGPUQuerySet::JSGPUQuerySet(Structure* structure, JSDOMGlobalObject& globalObject, Ref<GPUQuerySet>&& impl)
    : JSDOMWrapper<GPUQuerySet>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, GPUQuerySet>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSGPUQuerySet::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSGPUQuerySetPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSGPUQuerySetPrototype::create(vm, &globalObject, structure);
}

JSObject* JSGPUQuerySet::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSGPUQuerySet>(vm, globalObject);
}

JSValue JSGPUQuerySet::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSGPUQuerySetDOMConstructor, DOMConstructorID::GPUQuerySet>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSGPUQuerySet::destroy(JSC::JSCell* cell)
{
    JSGPUQuerySet* thisObject = static_cast<JSGPUQuerySet*>(cell);
    thisObject->JSGPUQuerySet::~JSGPUQuerySet();
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUQuerySetConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGPUQuerySetPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSGPUQuerySet::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsGPUQuerySet_typeGetter(JSGlobalObject& lexicalGlobalObject, JSGPUQuerySet& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<GPUQueryType>>(lexicalGlobalObject, throwScope, impl.type())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUQuerySet_type, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUQuerySet>::get<jsGPUQuerySet_typeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUQuerySet_countGetter(JSGlobalObject& lexicalGlobalObject, JSGPUQuerySet& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.count())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUQuerySet_count, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUQuerySet>::get<jsGPUQuerySet_countGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUQuerySet_labelGetter(JSGlobalObject& lexicalGlobalObject, JSGPUQuerySet& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.label())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUQuerySet_label, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUQuerySet>::get<jsGPUQuerySet_labelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSGPUQuerySet_labelSetter(JSGlobalObject& lexicalGlobalObject, JSGPUQuerySet& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUSVString>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setLabel(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSGPUQuerySet_label, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUQuerySet>::set<setJSGPUQuerySet_labelSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsGPUQuerySetPrototypeFunction_destroyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUQuerySet>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.destroy(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUQuerySetPrototypeFunction_destroy, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSGPUQuerySet>::call<jsGPUQuerySetPrototypeFunction_destroyBody>(*lexicalGlobalObject, *callFrame, "destroy");
}

JSC::GCClient::IsoSubspace* JSGPUQuerySet::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSGPUQuerySet, UseCustomHeapCellType::No>(vm, "JSGPUQuerySet"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForGPUQuerySet.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForGPUQuerySet = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForGPUQuerySet.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForGPUQuerySet = std::forward<decltype(space)>(space); }
    );
}

void JSGPUQuerySet::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSGPUQuerySet*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSGPUQuerySetOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSGPUQuerySetOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGPUQuerySet = static_cast<JSGPUQuerySet*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsGPUQuerySet->protectedWrapped().ptr(), jsGPUQuerySet);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7GPUQuerySet@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore11GPUQuerySetE[]; }
#endif
template<std::same_as<GPUQuerySet> T>
static inline void verifyVTable(GPUQuerySet* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7GPUQuerySet@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore11GPUQuerySetE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // GPUQuerySet has subclasses. If GPUQuerySet has subclasses that get passed
        // to toJS() we currently require GPUQuerySet you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<GPUQuerySet>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<GPUQuerySet>(impl.ptr());
#endif
    return createWrapper<GPUQuerySet>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, GPUQuerySet& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

GPUQuerySet* JSGPUQuerySet::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGPUQuerySet*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
