/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO)

#include "JSMediaError.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsMediaErrorConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaError_code);
static JSC_DECLARE_CUSTOM_GETTER(jsMediaError_message);

class JSMediaErrorPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSMediaErrorPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMediaErrorPrototype* ptr = new (NotNull, JSC::allocateCell<JSMediaErrorPrototype>(vm)) JSMediaErrorPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMediaErrorPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMediaErrorPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMediaErrorPrototype, JSMediaErrorPrototype::Base);

using JSMediaErrorDOMConstructor = JSDOMConstructorNotConstructable<JSMediaError>;

/* Hash table for constructor */

static const std::array<HashTableValue, 5> JSMediaErrorConstructorTableValues {
    HashTableValue { "MEDIA_ERR_ABORTED"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    HashTableValue { "MEDIA_ERR_NETWORK"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
    HashTableValue { "MEDIA_ERR_DECODE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 3 } },
    HashTableValue { "MEDIA_ERR_SRC_NOT_SUPPORTED"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 4 } },
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
    HashTableValue { "MEDIA_ERR_ENCRYPTED"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 5 } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
};

static_assert(MediaError::MEDIA_ERR_ABORTED == 1, "MEDIA_ERR_ABORTED in MediaError does not match value from IDL");
static_assert(MediaError::MEDIA_ERR_NETWORK == 2, "MEDIA_ERR_NETWORK in MediaError does not match value from IDL");
static_assert(MediaError::MEDIA_ERR_DECODE == 3, "MEDIA_ERR_DECODE in MediaError does not match value from IDL");
static_assert(MediaError::MEDIA_ERR_SRC_NOT_SUPPORTED == 4, "MEDIA_ERR_SRC_NOT_SUPPORTED in MediaError does not match value from IDL");
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
static_assert(MediaError::MEDIA_ERR_ENCRYPTED == 5, "MEDIA_ERR_ENCRYPTED in MediaError does not match value from IDL");
#endif

template<> const ClassInfo JSMediaErrorDOMConstructor::s_info = { "MediaError"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaErrorDOMConstructor) };

template<> JSValue JSMediaErrorDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSMediaErrorDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "MediaError"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSMediaError::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSMediaError::info(), JSMediaErrorConstructorTableValues, *this);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 8> JSMediaErrorPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaErrorConstructor, 0 } },
    HashTableValue { "code"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaError_code, 0 } },
    HashTableValue { "message"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMediaError_message, 0 } },
    HashTableValue { "MEDIA_ERR_ABORTED"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    HashTableValue { "MEDIA_ERR_NETWORK"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
    HashTableValue { "MEDIA_ERR_DECODE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 3 } },
    HashTableValue { "MEDIA_ERR_SRC_NOT_SUPPORTED"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 4 } },
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
    HashTableValue { "MEDIA_ERR_ENCRYPTED"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 5 } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
};

const ClassInfo JSMediaErrorPrototype::s_info = { "MediaError"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaErrorPrototype) };

void JSMediaErrorPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMediaError::info(), JSMediaErrorPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSMediaError::s_info = { "MediaError"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaError) };

JSMediaError::JSMediaError(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MediaError>&& impl)
    : JSDOMWrapper<MediaError>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, MediaError>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSMediaError::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSMediaErrorPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSMediaErrorPrototype::create(vm, &globalObject, structure);
}

JSObject* JSMediaError::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSMediaError>(vm, globalObject);
}

JSValue JSMediaError::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMediaErrorDOMConstructor, DOMConstructorID::MediaError>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSMediaError::destroy(JSC::JSCell* cell)
{
    JSMediaError* thisObject = static_cast<JSMediaError*>(cell);
    thisObject->JSMediaError::~JSMediaError();
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaErrorConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMediaErrorPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSMediaError::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsMediaError_codeGetter(JSGlobalObject& lexicalGlobalObject, JSMediaError& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.code())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaError_code, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaError>::get<jsMediaError_codeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMediaError_messageGetter(JSGlobalObject& lexicalGlobalObject, JSMediaError& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.message())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMediaError_message, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMediaError>::get<jsMediaError_messageGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSMediaError::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSMediaError, UseCustomHeapCellType::No>(vm, "JSMediaError"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForMediaError.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForMediaError = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForMediaError.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForMediaError = std::forward<decltype(space)>(space); }
    );
}

void JSMediaError::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSMediaError*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSMediaErrorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSMediaErrorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsMediaError = static_cast<JSMediaError*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsMediaError->protectedWrapped().ptr(), jsMediaError);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7MediaError@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore10MediaErrorE[]; }
#endif
template<std::same_as<MediaError> T>
static inline void verifyVTable(MediaError* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7MediaError@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore10MediaErrorE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // MediaError has subclasses. If MediaError has subclasses that get passed
        // to toJS() we currently require MediaError you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<MediaError>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<MediaError>(impl.ptr());
#endif
    return createWrapper<MediaError>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, MediaError& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

MediaError* JSMediaError::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSMediaError*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(VIDEO)
