/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSAudioWorklet.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsAudioWorkletConstructor);

class JSAudioWorkletPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSAudioWorkletPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSAudioWorkletPrototype* ptr = new (NotNull, JSC::allocateCell<JSAudioWorkletPrototype>(vm)) JSAudioWorkletPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAudioWorkletPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSAudioWorkletPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAudioWorkletPrototype, JSAudioWorkletPrototype::Base);

using JSAudioWorkletDOMConstructor = JSDOMConstructorNotConstructable<JSAudioWorklet>;

template<> const ClassInfo JSAudioWorkletDOMConstructor::s_info = { "AudioWorklet"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioWorkletDOMConstructor) };

template<> JSValue JSAudioWorkletDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSWorklet::getConstructor(vm, &globalObject);
}

template<> void JSAudioWorkletDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "AudioWorklet"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSAudioWorklet::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 1> JSAudioWorkletPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioWorkletConstructor, 0 } },
};

const ClassInfo JSAudioWorkletPrototype::s_info = { "AudioWorklet"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioWorkletPrototype) };

void JSAudioWorkletPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSAudioWorklet::info(), JSAudioWorkletPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSAudioWorklet::s_info = { "AudioWorklet"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioWorklet) };

JSAudioWorklet::JSAudioWorklet(Structure* structure, JSDOMGlobalObject& globalObject, Ref<AudioWorklet>&& impl)
    : JSWorklet(structure, globalObject, WTFMove(impl))
{
}

Ref<AudioWorklet> JSAudioWorklet::protectedWrapped() const
{
    return wrapped();
}

static_assert(std::is_base_of<ActiveDOMObject, AudioWorklet>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSAudioWorklet::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSAudioWorkletPrototype::createStructure(vm, &globalObject, JSWorklet::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSAudioWorkletPrototype::create(vm, &globalObject, structure);
}

JSObject* JSAudioWorklet::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSAudioWorklet>(vm, globalObject);
}

JSValue JSAudioWorklet::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAudioWorkletDOMConstructor, DOMConstructorID::AudioWorklet>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioWorkletConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAudioWorkletPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSAudioWorklet::getConstructor(vm, prototype->globalObject()));
}

JSC::GCClient::IsoSubspace* JSAudioWorklet::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSAudioWorklet, UseCustomHeapCellType::No>(vm, "JSAudioWorklet"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForAudioWorklet.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForAudioWorklet = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForAudioWorklet.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForAudioWorklet = std::forward<decltype(space)>(space); }
    );
}

void JSAudioWorklet::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSAudioWorklet*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSAudioWorkletOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsAudioWorklet = jsCast<JSAudioWorklet*>(handle.slot()->asCell());
    SUPPRESS_UNCOUNTED_LOCAL auto& wrapped = jsAudioWorklet->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (reason) [[unlikely]]
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSAudioWorkletOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsAudioWorklet = static_cast<JSAudioWorklet*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsAudioWorklet->protectedWrapped().ptr(), jsAudioWorklet);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7AudioWorklet@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12AudioWorkletE[]; }
#endif
template<std::same_as<AudioWorklet> T>
static inline void verifyVTable(AudioWorklet* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7AudioWorklet@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore12AudioWorkletE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // AudioWorklet has subclasses. If AudioWorklet has subclasses that get passed
        // to toJS() we currently require AudioWorklet you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<AudioWorklet>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<AudioWorklet>(impl.ptr());
#endif
    return createWrapper<AudioWorklet>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, AudioWorklet& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}

#endif // ENABLE(WEB_AUDIO)
