/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFileSystemFileEntry.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSErrorCallback.h"
#include "JSFileCallback.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsFileSystemFileEntryPrototypeFunction_file);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsFileSystemFileEntryConstructor);

class JSFileSystemFileEntryPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSFileSystemFileEntryPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSFileSystemFileEntryPrototype* ptr = new (NotNull, JSC::allocateCell<JSFileSystemFileEntryPrototype>(vm)) JSFileSystemFileEntryPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFileSystemFileEntryPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSFileSystemFileEntryPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFileSystemFileEntryPrototype, JSFileSystemFileEntryPrototype::Base);

using JSFileSystemFileEntryDOMConstructor = JSDOMConstructorNotConstructable<JSFileSystemFileEntry>;

template<> const ClassInfo JSFileSystemFileEntryDOMConstructor::s_info = { "FileSystemFileEntry"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFileSystemFileEntryDOMConstructor) };

template<> JSValue JSFileSystemFileEntryDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSFileSystemEntry::getConstructor(vm, &globalObject);
}

template<> void JSFileSystemFileEntryDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "FileSystemFileEntry"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSFileSystemFileEntry::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 2> JSFileSystemFileEntryPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsFileSystemFileEntryConstructor, 0 } },
    HashTableValue { "file"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFileSystemFileEntryPrototypeFunction_file, 1 } },
};

const ClassInfo JSFileSystemFileEntryPrototype::s_info = { "FileSystemFileEntry"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFileSystemFileEntryPrototype) };

void JSFileSystemFileEntryPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSFileSystemFileEntry::info(), JSFileSystemFileEntryPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSFileSystemFileEntry::s_info = { "FileSystemFileEntry"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFileSystemFileEntry) };

JSFileSystemFileEntry::JSFileSystemFileEntry(Structure* structure, JSDOMGlobalObject& globalObject, Ref<FileSystemFileEntry>&& impl)
    : JSFileSystemEntry(structure, globalObject, WTFMove(impl))
{
}

Ref<FileSystemFileEntry> JSFileSystemFileEntry::protectedWrapped() const
{
    return wrapped();
}

static_assert(std::is_base_of<ActiveDOMObject, FileSystemFileEntry>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSFileSystemFileEntry::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSFileSystemFileEntryPrototype::createStructure(vm, &globalObject, JSFileSystemEntry::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSFileSystemFileEntryPrototype::create(vm, &globalObject, structure);
}

JSObject* JSFileSystemFileEntry::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSFileSystemFileEntry>(vm, globalObject);
}

JSValue JSFileSystemFileEntry::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFileSystemFileEntryDOMConstructor, DOMConstructorID::FileSystemFileEntry>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsFileSystemFileEntryConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSFileSystemFileEntryPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSFileSystemFileEntry::getConstructor(vm, prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsFileSystemFileEntryPrototypeFunction_fileBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSFileSystemFileEntry>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (!context) [[unlikely]]
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto successCallbackConversionResult = convert<IDLCallbackFunction<JSFileCallback>>(*lexicalGlobalObject, argument0.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 0, "successCallback"_s, "FileSystemFileEntry"_s, "file"_s); });
    if (successCallbackConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto errorCallbackConversionResult = convert<IDLNullable<IDLCallbackFunction<JSErrorCallback>>>(*lexicalGlobalObject, argument1.value(), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 1, "errorCallback"_s, "FileSystemFileEntry"_s, "file"_s); });
    if (errorCallbackConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.file(*context, successCallbackConversionResult.releaseReturnValue(), errorCallbackConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsFileSystemFileEntryPrototypeFunction_file, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSFileSystemFileEntry>::call<jsFileSystemFileEntryPrototypeFunction_fileBody>(*lexicalGlobalObject, *callFrame, "file");
}

JSC::GCClient::IsoSubspace* JSFileSystemFileEntry::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSFileSystemFileEntry, UseCustomHeapCellType::No>(vm, "JSFileSystemFileEntry"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForFileSystemFileEntry.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForFileSystemFileEntry = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForFileSystemFileEntry.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForFileSystemFileEntry = std::forward<decltype(space)>(space); }
    );
}

void JSFileSystemFileEntry::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSFileSystemFileEntry*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSFileSystemFileEntryOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsFileSystemFileEntry = jsCast<JSFileSystemFileEntry*>(handle.slot()->asCell());
    SUPPRESS_UNCOUNTED_LOCAL auto& wrapped = jsFileSystemFileEntry->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (reason) [[unlikely]]
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSFileSystemFileEntryOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsFileSystemFileEntry = static_cast<JSFileSystemFileEntry*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsFileSystemFileEntry->protectedWrapped().ptr(), jsFileSystemFileEntry);
}


}
