#pragma once
/*
 * This file is generated by uxsdcxx 0.1.0.
 * https://github.com/duck2/uxsdcxx
 * Modify only if your build process doesn't involve regenerating this file.
 *
 * Cmdline: uxsdcxx/uxsdcap.py /home/mohagh18/vtr-verilog-to-routing/libs/librrgraph/src/io/rr_graph.xsd
 * Input file: /home/mohagh18/vtr-verilog-to-routing/libs/librrgraph/src/io/rr_graph.xsd

 * md5sum of input file: 65eddcc840064bbb91d7f4cf0b8bf821
 */

#include <functional>

#include <stdexcept>
#include <tuple>
#include <vector>
#include <sstream>
#include <limits>
#include "capnp/serialize.h"
#include "rr_graph_uxsdcxx.capnp.h"
#include "rr_graph_uxsdcxx_interface.h"

/* All uxsdcxx functions and structs live in this namespace. */
namespace uxsd {
/* Declarations for internal load functions for the complex types. */
template <class T, typename Context>
void load_channel_capnp_type(const ucap::Channel::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack);
template <class T, typename Context>
void load_x_list_capnp_type(const ucap::XList::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack);
template <class T, typename Context>
void load_y_list_capnp_type(const ucap::YList::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack);
template <class T, typename Context>
void load_channels_capnp_type(const ucap::Channels::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack);
template <class T, typename Context>
void load_timing_capnp_type(const ucap::Timing::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack);
template <class T, typename Context>
void load_sizing_capnp_type(const ucap::Sizing::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack);
template <class T, typename Context>
void load_switch_capnp_type(const ucap::Switch::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack);
template <class T, typename Context>
void load_switches_capnp_type(const ucap::Switches::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack);
template <class T, typename Context>
void load_segment_timing_capnp_type(const ucap::SegmentTiming::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack);
template <class T, typename Context>
void load_segment_capnp_type(const ucap::Segment::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack);
template <class T, typename Context>
void load_segments_capnp_type(const ucap::Segments::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack);
template <class T, typename Context>
void load_pin_capnp_type(const ucap::Pin::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack);
template <class T, typename Context>
void load_pin_class_capnp_type(const ucap::PinClass::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack);
template <class T, typename Context>
void load_block_type_capnp_type(const ucap::BlockType::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack);
template <class T, typename Context>
void load_block_types_capnp_type(const ucap::BlockTypes::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack);
template <class T, typename Context>
void load_grid_loc_capnp_type(const ucap::GridLoc::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack);
template <class T, typename Context>
void load_grid_locs_capnp_type(const ucap::GridLocs::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack);
template <class T, typename Context>
void load_node_loc_capnp_type(const ucap::NodeLoc::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack);
template <class T, typename Context>
void load_node_timing_capnp_type(const ucap::NodeTiming::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack);
template <class T, typename Context>
void load_node_segment_capnp_type(const ucap::NodeSegment::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack);
template <class T, typename Context>
void load_meta_capnp_type(const ucap::Meta::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack);
template <class T, typename Context>
void load_metadata_capnp_type(const ucap::Metadata::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack);
template <class T, typename Context>
void load_node_capnp_type(const ucap::Node::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack);
template <class T, typename Context>
void load_rr_nodes_capnp_type(const ucap::RrNodes::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack);
template <class T, typename Context>
void load_edge_capnp_type(const ucap::Edge::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack);
template <class T, typename Context>
void load_rr_edges_capnp_type(const ucap::RrEdges::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack);
template <class T, typename Context>
void load_rr_graph_capnp_type(const ucap::RrGraph::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack);

/* Declarations for internal write functions for the complex types. */
template <class T, typename Context>
inline void write_channels_capnp_type(T &in, ucap::Channels::Builder &root, Context &context);
template <class T, typename Context>
inline void write_switch_capnp_type(T &in, ucap::Switch::Builder &root, Context &context);
template <class T, typename Context>
inline void write_switches_capnp_type(T &in, ucap::Switches::Builder &root, Context &context);
template <class T, typename Context>
inline void write_segment_capnp_type(T &in, ucap::Segment::Builder &root, Context &context);
template <class T, typename Context>
inline void write_segments_capnp_type(T &in, ucap::Segments::Builder &root, Context &context);
template <class T, typename Context>
inline void write_pin_capnp_type(T &in, ucap::Pin::Builder &root, Context &context);
template <class T, typename Context>
inline void write_pin_class_capnp_type(T &in, ucap::PinClass::Builder &root, Context &context);
template <class T, typename Context>
inline void write_block_type_capnp_type(T &in, ucap::BlockType::Builder &root, Context &context);
template <class T, typename Context>
inline void write_block_types_capnp_type(T &in, ucap::BlockTypes::Builder &root, Context &context);
template <class T, typename Context>
inline void write_grid_locs_capnp_type(T &in, ucap::GridLocs::Builder &root, Context &context);
template <class T, typename Context>
inline void write_meta_capnp_type(T &in, ucap::Meta::Builder &root, Context &context);
template <class T, typename Context>
inline void write_metadata_capnp_type(T &in, ucap::Metadata::Builder &root, Context &context);
template <class T, typename Context>
inline void write_node_capnp_type(T &in, ucap::Node::Builder &root, Context &context);
template <class T, typename Context>
inline void write_rr_nodes_capnp_type(T &in, ucap::RrNodes::Builder &root, Context &context);
template <class T, typename Context>
inline void write_edge_capnp_type(T &in, ucap::Edge::Builder &root, Context &context);
template <class T, typename Context>
inline void write_rr_edges_capnp_type(T &in, ucap::RrEdges::Builder &root, Context &context);
template <class T, typename Context>
inline void write_rr_graph_capnp_type(T &in, ucap::RrGraph::Builder &root, Context &context);

/* Enum conversions from uxsd to ucap */
inline enum_switch_type conv_enum_switch_type(ucap::SwitchType e, const std::function<void(const char *)> * report_error) {
	switch(e) {
	case ucap::SwitchType::UXSD_INVALID:
		return enum_switch_type::UXSD_INVALID;
	case ucap::SwitchType::MUX:
		return enum_switch_type::MUX;
	case ucap::SwitchType::TRISTATE:
		return enum_switch_type::TRISTATE;
	case ucap::SwitchType::PASS_GATE:
		return enum_switch_type::PASS_GATE;
	case ucap::SwitchType::SHORT:
		return enum_switch_type::SHORT;
	case ucap::SwitchType::BUFFER:
		return enum_switch_type::BUFFER;
	default:
		(*report_error)("Unknown enum_switch_type");
		throw std::runtime_error("Unreachable!");
	}
}

inline ucap::SwitchType conv_to_enum_switch_type(enum_switch_type e) {
	switch(e) {
	case enum_switch_type::UXSD_INVALID:
		return ucap::SwitchType::UXSD_INVALID;
	case enum_switch_type::MUX:
		return ucap::SwitchType::MUX;
	case enum_switch_type::TRISTATE:
		return ucap::SwitchType::TRISTATE;
	case enum_switch_type::PASS_GATE:
		return ucap::SwitchType::PASS_GATE;
	case enum_switch_type::SHORT:
		return ucap::SwitchType::SHORT;
	case enum_switch_type::BUFFER:
		return ucap::SwitchType::BUFFER;
	default:
		throw std::runtime_error("Unknown enum_switch_type");
	}
}

inline enum_segment_res_type conv_enum_segment_res_type(ucap::SegmentResType e, const std::function<void(const char *)> * report_error) {
	switch(e) {
	case ucap::SegmentResType::UXSD_INVALID:
		return enum_segment_res_type::UXSD_INVALID;
	case ucap::SegmentResType::GENERAL:
		return enum_segment_res_type::GENERAL;
	case ucap::SegmentResType::GCLK:
		return enum_segment_res_type::GCLK;
	default:
		(*report_error)("Unknown enum_segment_res_type");
		throw std::runtime_error("Unreachable!");
	}
}

inline ucap::SegmentResType conv_to_enum_segment_res_type(enum_segment_res_type e) {
	switch(e) {
	case enum_segment_res_type::UXSD_INVALID:
		return ucap::SegmentResType::UXSD_INVALID;
	case enum_segment_res_type::GENERAL:
		return ucap::SegmentResType::GENERAL;
	case enum_segment_res_type::GCLK:
		return ucap::SegmentResType::GCLK;
	default:
		throw std::runtime_error("Unknown enum_segment_res_type");
	}
}

inline enum_pin_type conv_enum_pin_type(ucap::PinType e, const std::function<void(const char *)> * report_error) {
	switch(e) {
	case ucap::PinType::UXSD_INVALID:
		return enum_pin_type::UXSD_INVALID;
	case ucap::PinType::OPEN:
		return enum_pin_type::OPEN;
	case ucap::PinType::OUTPUT:
		return enum_pin_type::OUTPUT;
	case ucap::PinType::INPUT:
		return enum_pin_type::INPUT;
	default:
		(*report_error)("Unknown enum_pin_type");
		throw std::runtime_error("Unreachable!");
	}
}

inline ucap::PinType conv_to_enum_pin_type(enum_pin_type e) {
	switch(e) {
	case enum_pin_type::UXSD_INVALID:
		return ucap::PinType::UXSD_INVALID;
	case enum_pin_type::OPEN:
		return ucap::PinType::OPEN;
	case enum_pin_type::OUTPUT:
		return ucap::PinType::OUTPUT;
	case enum_pin_type::INPUT:
		return ucap::PinType::INPUT;
	default:
		throw std::runtime_error("Unknown enum_pin_type");
	}
}

inline enum_node_type conv_enum_node_type(ucap::NodeType e, const std::function<void(const char *)> * report_error) {
	switch(e) {
	case ucap::NodeType::UXSD_INVALID:
		return enum_node_type::UXSD_INVALID;
	case ucap::NodeType::CHANX:
		return enum_node_type::CHANX;
	case ucap::NodeType::CHANY:
		return enum_node_type::CHANY;
	case ucap::NodeType::SOURCE:
		return enum_node_type::SOURCE;
	case ucap::NodeType::SINK:
		return enum_node_type::SINK;
	case ucap::NodeType::OPIN:
		return enum_node_type::OPIN;
	case ucap::NodeType::IPIN:
		return enum_node_type::IPIN;
	default:
		(*report_error)("Unknown enum_node_type");
		throw std::runtime_error("Unreachable!");
	}
}

inline ucap::NodeType conv_to_enum_node_type(enum_node_type e) {
	switch(e) {
	case enum_node_type::UXSD_INVALID:
		return ucap::NodeType::UXSD_INVALID;
	case enum_node_type::CHANX:
		return ucap::NodeType::CHANX;
	case enum_node_type::CHANY:
		return ucap::NodeType::CHANY;
	case enum_node_type::SOURCE:
		return ucap::NodeType::SOURCE;
	case enum_node_type::SINK:
		return ucap::NodeType::SINK;
	case enum_node_type::OPIN:
		return ucap::NodeType::OPIN;
	case enum_node_type::IPIN:
		return ucap::NodeType::IPIN;
	default:
		throw std::runtime_error("Unknown enum_node_type");
	}
}

inline enum_node_direction conv_enum_node_direction(ucap::NodeDirection e, const std::function<void(const char *)> * report_error) {
	switch(e) {
	case ucap::NodeDirection::UXSD_INVALID:
		return enum_node_direction::UXSD_INVALID;
	case ucap::NodeDirection::INC_DIR:
		return enum_node_direction::INC_DIR;
	case ucap::NodeDirection::DEC_DIR:
		return enum_node_direction::DEC_DIR;
	case ucap::NodeDirection::BI_DIR:
		return enum_node_direction::BI_DIR;
	case ucap::NodeDirection::NONE:
		return enum_node_direction::NONE;
	default:
		(*report_error)("Unknown enum_node_direction");
		throw std::runtime_error("Unreachable!");
	}
}

inline ucap::NodeDirection conv_to_enum_node_direction(enum_node_direction e) {
	switch(e) {
	case enum_node_direction::UXSD_INVALID:
		return ucap::NodeDirection::UXSD_INVALID;
	case enum_node_direction::INC_DIR:
		return ucap::NodeDirection::INC_DIR;
	case enum_node_direction::DEC_DIR:
		return ucap::NodeDirection::DEC_DIR;
	case enum_node_direction::BI_DIR:
		return ucap::NodeDirection::BI_DIR;
	case enum_node_direction::NONE:
		return ucap::NodeDirection::NONE;
	default:
		throw std::runtime_error("Unknown enum_node_direction");
	}
}

inline enum_node_clk_res_type conv_enum_node_clk_res_type(ucap::NodeClkResType e, const std::function<void(const char *)> * report_error) {
	switch(e) {
	case ucap::NodeClkResType::UXSD_INVALID:
		return enum_node_clk_res_type::UXSD_INVALID;
	case ucap::NodeClkResType::VIRTUAL_SINK:
		return enum_node_clk_res_type::VIRTUAL_SINK;
	default:
		(*report_error)("Unknown enum_node_clk_res_type");
		throw std::runtime_error("Unreachable!");
	}
}

inline ucap::NodeClkResType conv_to_enum_node_clk_res_type(enum_node_clk_res_type e) {
	switch(e) {
	case enum_node_clk_res_type::UXSD_INVALID:
		return ucap::NodeClkResType::UXSD_INVALID;
	case enum_node_clk_res_type::VIRTUAL_SINK:
		return ucap::NodeClkResType::VIRTUAL_SINK;
	default:
		throw std::runtime_error("Unknown enum_node_clk_res_type");
	}
}

inline enum_loc_side conv_enum_loc_side(ucap::LocSide e, const std::function<void(const char *)> * report_error) {
	switch(e) {
	case ucap::LocSide::UXSD_INVALID:
		return enum_loc_side::UXSD_INVALID;
	case ucap::LocSide::LEFT:
		return enum_loc_side::LEFT;
	case ucap::LocSide::RIGHT:
		return enum_loc_side::RIGHT;
	case ucap::LocSide::TOP:
		return enum_loc_side::TOP;
	case ucap::LocSide::BOTTOM:
		return enum_loc_side::BOTTOM;
	case ucap::LocSide::RIGHT_LEFT:
		return enum_loc_side::RIGHT_LEFT;
	case ucap::LocSide::RIGHT_BOTTOM:
		return enum_loc_side::RIGHT_BOTTOM;
	case ucap::LocSide::RIGHT_BOTTOM_LEFT:
		return enum_loc_side::RIGHT_BOTTOM_LEFT;
	case ucap::LocSide::TOP_RIGHT:
		return enum_loc_side::TOP_RIGHT;
	case ucap::LocSide::TOP_BOTTOM:
		return enum_loc_side::TOP_BOTTOM;
	case ucap::LocSide::TOP_LEFT:
		return enum_loc_side::TOP_LEFT;
	case ucap::LocSide::TOP_RIGHT_BOTTOM:
		return enum_loc_side::TOP_RIGHT_BOTTOM;
	case ucap::LocSide::TOP_RIGHT_LEFT:
		return enum_loc_side::TOP_RIGHT_LEFT;
	case ucap::LocSide::TOP_BOTTOM_LEFT:
		return enum_loc_side::TOP_BOTTOM_LEFT;
	case ucap::LocSide::TOP_RIGHT_BOTTOM_LEFT:
		return enum_loc_side::TOP_RIGHT_BOTTOM_LEFT;
	case ucap::LocSide::BOTTOM_LEFT:
		return enum_loc_side::BOTTOM_LEFT;
	default:
		(*report_error)("Unknown enum_loc_side");
		throw std::runtime_error("Unreachable!");
	}
}

inline ucap::LocSide conv_to_enum_loc_side(enum_loc_side e) {
	switch(e) {
	case enum_loc_side::UXSD_INVALID:
		return ucap::LocSide::UXSD_INVALID;
	case enum_loc_side::LEFT:
		return ucap::LocSide::LEFT;
	case enum_loc_side::RIGHT:
		return ucap::LocSide::RIGHT;
	case enum_loc_side::TOP:
		return ucap::LocSide::TOP;
	case enum_loc_side::BOTTOM:
		return ucap::LocSide::BOTTOM;
	case enum_loc_side::RIGHT_LEFT:
		return ucap::LocSide::RIGHT_LEFT;
	case enum_loc_side::RIGHT_BOTTOM:
		return ucap::LocSide::RIGHT_BOTTOM;
	case enum_loc_side::RIGHT_BOTTOM_LEFT:
		return ucap::LocSide::RIGHT_BOTTOM_LEFT;
	case enum_loc_side::TOP_RIGHT:
		return ucap::LocSide::TOP_RIGHT;
	case enum_loc_side::TOP_BOTTOM:
		return ucap::LocSide::TOP_BOTTOM;
	case enum_loc_side::TOP_LEFT:
		return ucap::LocSide::TOP_LEFT;
	case enum_loc_side::TOP_RIGHT_BOTTOM:
		return ucap::LocSide::TOP_RIGHT_BOTTOM;
	case enum_loc_side::TOP_RIGHT_LEFT:
		return ucap::LocSide::TOP_RIGHT_LEFT;
	case enum_loc_side::TOP_BOTTOM_LEFT:
		return ucap::LocSide::TOP_BOTTOM_LEFT;
	case enum_loc_side::TOP_RIGHT_BOTTOM_LEFT:
		return ucap::LocSide::TOP_RIGHT_BOTTOM_LEFT;
	case enum_loc_side::BOTTOM_LEFT:
		return ucap::LocSide::BOTTOM_LEFT;
	default:
		throw std::runtime_error("Unknown enum_loc_side");
	}
}


/* Load function for the root element. */
template <class T, typename Context>
inline void load_rr_graph_capnp(T &out, kj::ArrayPtr<const ::capnp::word> data, Context &context, const char * filename){
	/* Remove traversal limits. */
	::capnp::ReaderOptions opts = ::capnp::ReaderOptions();
	opts.traversalLimitInWords = std::numeric_limits<uint64_t>::max();
	::capnp::FlatArrayMessageReader reader(data, opts);
	auto root = reader.getRoot<ucap::RrGraph>();
	std::vector<std::pair<const char*, size_t>> stack;
	stack.reserve(20);
	stack.push_back(std::make_pair("root", 0));

	std::function<void(const char *)> report_error = [filename, &out, &stack](const char *message){
		std::stringstream msg;
		msg << message << std::endl;
		msg << "Error occured at ";
		for(size_t i = 0; i < stack.size(); ++i) {
			msg << stack[i].first << "[" << stack[i].second << "]";
			if(i+1 < stack.size()) {
				msg << " . ";
			}
		}
		out.error_encountered(filename, -1, msg.str().c_str());
	};
	out.start_load(&report_error);
	load_rr_graph_capnp_type(root, out, context, &report_error, &stack);
	out.finish_load();
}

/* Write function for the root element. */
template <class T, typename Context>
inline void write_rr_graph_capnp(T &in, Context &context, ucap::RrGraph::Builder &root) {
	in.start_write();
	if((bool)in.get_rr_graph_tool_comment(context))
		root.setToolComment(in.get_rr_graph_tool_comment(context));
	if((bool)in.get_rr_graph_tool_name(context))
		root.setToolName(in.get_rr_graph_tool_name(context));
	if((bool)in.get_rr_graph_tool_version(context))
		root.setToolVersion(in.get_rr_graph_tool_version(context));
	write_rr_graph_capnp_type(in, root, context);
	in.finish_write();
}


/* Internal loading functions, which validate and load a PugiXML DOM tree into memory. */
template<class T, typename Context>
inline void load_channel_capnp_type(const ucap::Channel::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	(void)stack;

}

template<class T, typename Context>
inline void load_x_list_capnp_type(const ucap::XList::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	(void)stack;

}

template<class T, typename Context>
inline void load_y_list_capnp_type(const ucap::YList::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	(void)stack;

}

template<class T, typename Context>
inline void load_channels_capnp_type(const ucap::Channels::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	(void)stack;

	stack->push_back(std::make_pair("getChannel", 0));
	if (root.hasChannel()) {
		auto child_el = root.getChannel();
		auto child_context = out.init_channels_channel(context, child_el.getChanWidthMax(), child_el.getXMax(), child_el.getXMin(), child_el.getYMax(), child_el.getYMin());
		load_channel_capnp_type(child_el, out, child_context, report_error, stack);
		out.finish_channels_channel(child_context);
	}
	stack->pop_back();
	stack->push_back(std::make_pair("getXList", 0));
	{
		auto data = root.getXLists();
		out.preallocate_channels_x_list(context, data.size());
		for(const auto & el : data) {
			auto child_context = out.add_channels_x_list(context, el.getIndex(), el.getInfo());
			load_x_list_capnp_type(el, out, child_context, report_error, stack);
			out.finish_channels_x_list(child_context);
			stack->back().second += 1;
		}
	}
	stack->pop_back();
	stack->push_back(std::make_pair("getYList", 0));
	{
		auto data = root.getYLists();
		out.preallocate_channels_y_list(context, data.size());
		for(const auto & el : data) {
			auto child_context = out.add_channels_y_list(context, el.getIndex(), el.getInfo());
			load_y_list_capnp_type(el, out, child_context, report_error, stack);
			out.finish_channels_y_list(child_context);
			stack->back().second += 1;
		}
	}
	stack->pop_back();
}

template<class T, typename Context>
inline void load_timing_capnp_type(const ucap::Timing::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	(void)stack;

	out.set_timing_Cin(root.getCin(), context);
	out.set_timing_Cinternal(root.getCinternal(), context);
	out.set_timing_Cout(root.getCout(), context);
	out.set_timing_R(root.getR(), context);
	out.set_timing_Tdel(root.getTdel(), context);
}

template<class T, typename Context>
inline void load_sizing_capnp_type(const ucap::Sizing::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	(void)stack;

}

template<class T, typename Context>
inline void load_switch_capnp_type(const ucap::Switch::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	(void)stack;

	out.set_switch_name(root.getName().cStr(), context);
	out.set_switch_type(conv_enum_switch_type(root.getType(), report_error), context);
	stack->push_back(std::make_pair("getTiming", 0));
	if (root.hasTiming()) {
		auto child_el = root.getTiming();
		auto child_context = out.init_switch_timing(context);
		load_timing_capnp_type(child_el, out, child_context, report_error, stack);
		out.finish_switch_timing(child_context);
	}
	stack->pop_back();
	stack->push_back(std::make_pair("getSizing", 0));
	if (root.hasSizing()) {
		auto child_el = root.getSizing();
		auto child_context = out.init_switch_sizing(context, child_el.getBufSize(), child_el.getMuxTransSize());
		load_sizing_capnp_type(child_el, out, child_context, report_error, stack);
		out.finish_switch_sizing(child_context);
	}
	stack->pop_back();
}

template<class T, typename Context>
inline void load_switches_capnp_type(const ucap::Switches::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	(void)stack;

	stack->push_back(std::make_pair("getSwitch", 0));
	{
		auto data = root.getSwitches();
		out.preallocate_switches_switch(context, data.size());
		for(const auto & el : data) {
			auto child_context = out.add_switches_switch(context, el.getId());
			load_switch_capnp_type(el, out, child_context, report_error, stack);
			out.finish_switches_switch(child_context);
			stack->back().second += 1;
		}
	}
	stack->pop_back();
}

template<class T, typename Context>
inline void load_segment_timing_capnp_type(const ucap::SegmentTiming::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	(void)stack;

	out.set_segment_timing_C_per_meter(root.getCPerMeter(), context);
	out.set_segment_timing_R_per_meter(root.getRPerMeter(), context);
}

template<class T, typename Context>
inline void load_segment_capnp_type(const ucap::Segment::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	(void)stack;

	out.set_segment_length(root.getLength(), context);
	out.set_segment_name(root.getName().cStr(), context);
	out.set_segment_res_type(conv_enum_segment_res_type(root.getResType(), report_error), context);
	stack->push_back(std::make_pair("getTiming", 0));
	if (root.hasTiming()) {
		auto child_el = root.getTiming();
		auto child_context = out.init_segment_timing(context);
		load_segment_timing_capnp_type(child_el, out, child_context, report_error, stack);
		out.finish_segment_timing(child_context);
	}
	stack->pop_back();
}

template<class T, typename Context>
inline void load_segments_capnp_type(const ucap::Segments::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	(void)stack;

	stack->push_back(std::make_pair("getSegment", 0));
	{
		auto data = root.getSegments();
		out.preallocate_segments_segment(context, data.size());
		for(const auto & el : data) {
			auto child_context = out.add_segments_segment(context, el.getId());
			load_segment_capnp_type(el, out, child_context, report_error, stack);
			out.finish_segments_segment(child_context);
			stack->back().second += 1;
		}
	}
	stack->pop_back();
}

template<class T, typename Context>
inline void load_pin_capnp_type(const ucap::Pin::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	(void)stack;

	stack->push_back(std::make_pair("getValue", 0));
	out.set_pin_value(root.getValue().cStr(), context);
	stack->pop_back();
}

template<class T, typename Context>
inline void load_pin_class_capnp_type(const ucap::PinClass::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	(void)stack;

	stack->push_back(std::make_pair("getPin", 0));
	{
		auto data = root.getPins();
		out.preallocate_pin_class_pin(context, data.size());
		for(const auto & el : data) {
			auto child_context = out.add_pin_class_pin(context, el.getPtc());
			load_pin_capnp_type(el, out, child_context, report_error, stack);
			out.finish_pin_class_pin(child_context);
			stack->back().second += 1;
		}
	}
	stack->pop_back();
}

template<class T, typename Context>
inline void load_block_type_capnp_type(const ucap::BlockType::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	(void)stack;

	out.set_block_type_name(root.getName().cStr(), context);
	stack->push_back(std::make_pair("getPinClass", 0));
	{
		auto data = root.getPinClasses();
		out.preallocate_block_type_pin_class(context, data.size());
		for(const auto & el : data) {
			auto child_context = out.add_block_type_pin_class(context, conv_enum_pin_type(el.getType(), report_error));
			load_pin_class_capnp_type(el, out, child_context, report_error, stack);
			out.finish_block_type_pin_class(child_context);
			stack->back().second += 1;
		}
	}
	stack->pop_back();
}

template<class T, typename Context>
inline void load_block_types_capnp_type(const ucap::BlockTypes::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	(void)stack;

	stack->push_back(std::make_pair("getBlockType", 0));
	{
		auto data = root.getBlockTypes();
		out.preallocate_block_types_block_type(context, data.size());
		for(const auto & el : data) {
			auto child_context = out.add_block_types_block_type(context, el.getHeight(), el.getId(), el.getWidth());
			load_block_type_capnp_type(el, out, child_context, report_error, stack);
			out.finish_block_types_block_type(child_context);
			stack->back().second += 1;
		}
	}
	stack->pop_back();
}

template<class T, typename Context>
inline void load_grid_loc_capnp_type(const ucap::GridLoc::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	(void)stack;

	out.set_grid_loc_layer(root.getLayer(), context);
}

template<class T, typename Context>
inline void load_grid_locs_capnp_type(const ucap::GridLocs::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	(void)stack;

	stack->push_back(std::make_pair("getGridLoc", 0));
	{
		auto data = root.getGridLocs();
		out.preallocate_grid_locs_grid_loc(context, data.size());
		for(const auto & el : data) {
			auto child_context = out.add_grid_locs_grid_loc(context, el.getBlockTypeId(), el.getHeightOffset(), el.getWidthOffset(), el.getX(), el.getY());
			load_grid_loc_capnp_type(el, out, child_context, report_error, stack);
			out.finish_grid_locs_grid_loc(child_context);
			stack->back().second += 1;
		}
	}
	stack->pop_back();
}

template<class T, typename Context>
inline void load_node_loc_capnp_type(const ucap::NodeLoc::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	(void)stack;

	out.set_node_loc_layer(root.getLayer(), context);
	out.set_node_loc_side(conv_enum_loc_side(root.getSide(), report_error), context);
	out.set_node_loc_twist(root.getTwist(), context);
}

template<class T, typename Context>
inline void load_node_timing_capnp_type(const ucap::NodeTiming::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	(void)stack;

}

template<class T, typename Context>
inline void load_node_segment_capnp_type(const ucap::NodeSegment::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	(void)stack;

}

template<class T, typename Context>
inline void load_meta_capnp_type(const ucap::Meta::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	(void)stack;

	out.set_meta_name(root.getName().cStr(), context);
	stack->push_back(std::make_pair("getValue", 0));
	out.set_meta_value(root.getValue().cStr(), context);
	stack->pop_back();
}

template<class T, typename Context>
inline void load_metadata_capnp_type(const ucap::Metadata::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	(void)stack;

	stack->push_back(std::make_pair("getMeta", 0));
	{
		auto data = root.getMetas();
		out.preallocate_metadata_meta(context, data.size());
		for(const auto & el : data) {
			auto child_context = out.add_metadata_meta(context);
			load_meta_capnp_type(el, out, child_context, report_error, stack);
			out.finish_metadata_meta(child_context);
			stack->back().second += 1;
		}
	}
	stack->pop_back();
}

template<class T, typename Context>
inline void load_node_capnp_type(const ucap::Node::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	(void)stack;

	out.set_node_clk_res_type(conv_enum_node_clk_res_type(root.getClkResType(), report_error), context);
	out.set_node_direction(conv_enum_node_direction(root.getDirection(), report_error), context);
	out.set_node_name(root.getName().cStr(), context);
	stack->push_back(std::make_pair("getLoc", 0));
	if (root.hasLoc()) {
		auto child_el = root.getLoc();
		auto child_context = out.init_node_loc(context, child_el.getPtc(), child_el.getXhigh(), child_el.getXlow(), child_el.getYhigh(), child_el.getYlow());
		load_node_loc_capnp_type(child_el, out, child_context, report_error, stack);
		out.finish_node_loc(child_context);
	}
	stack->pop_back();
	stack->push_back(std::make_pair("getTiming", 0));
	if (root.hasTiming()) {
		auto child_el = root.getTiming();
		auto child_context = out.init_node_timing(context, child_el.getC(), child_el.getR());
		load_node_timing_capnp_type(child_el, out, child_context, report_error, stack);
		out.finish_node_timing(child_context);
	}
	stack->pop_back();
	stack->push_back(std::make_pair("getSegment", 0));
	if (root.hasSegment()) {
		auto child_el = root.getSegment();
		auto child_context = out.init_node_segment(context, child_el.getSegmentId());
		load_node_segment_capnp_type(child_el, out, child_context, report_error, stack);
		out.finish_node_segment(child_context);
	}
	stack->pop_back();
	stack->push_back(std::make_pair("getMetadata", 0));
	if (root.hasMetadata()) {
		auto child_el = root.getMetadata();
		auto child_context = out.init_node_metadata(context);
		load_metadata_capnp_type(child_el, out, child_context, report_error, stack);
		out.finish_node_metadata(child_context);
	}
	stack->pop_back();
}

template<class T, typename Context>
inline void load_rr_nodes_capnp_type(const ucap::RrNodes::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	(void)stack;

	stack->push_back(std::make_pair("getNode", 0));
	{
		auto data = root.getNodes();
		out.preallocate_rr_nodes_node(context, data.size());
		for(const auto & el : data) {
			auto child_context = out.add_rr_nodes_node(context, el.getCapacity(), el.getId(), conv_enum_node_type(el.getType(), report_error));
			load_node_capnp_type(el, out, child_context, report_error, stack);
			out.finish_rr_nodes_node(child_context);
			stack->back().second += 1;
		}
	}
	stack->pop_back();
}

template<class T, typename Context>
inline void load_edge_capnp_type(const ucap::Edge::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	(void)stack;

	stack->push_back(std::make_pair("getMetadata", 0));
	if (root.hasMetadata()) {
		auto child_el = root.getMetadata();
		auto child_context = out.init_edge_metadata(context);
		load_metadata_capnp_type(child_el, out, child_context, report_error, stack);
		out.finish_edge_metadata(child_context);
	}
	stack->pop_back();
}

template<class T, typename Context>
inline void load_rr_edges_capnp_type(const ucap::RrEdges::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	(void)stack;

	stack->push_back(std::make_pair("getEdge", 0));
	{
		auto data = root.getEdges();
		out.preallocate_rr_edges_edge(context, data.size());
		for(const auto & el : data) {
			auto child_context = out.add_rr_edges_edge(context, el.getSinkNode(), el.getSrcNode(), el.getSwitchId());
			load_edge_capnp_type(el, out, child_context, report_error, stack);
			out.finish_rr_edges_edge(child_context);
			stack->back().second += 1;
		}
	}
	stack->pop_back();
}

template<class T, typename Context>
inline void load_rr_graph_capnp_type(const ucap::RrGraph::Reader &root, T &out, Context &context, const std::function<void(const char*)> * report_error, std::vector<std::pair<const char *, size_t>> * stack){
	(void)root;
	(void)out;
	(void)context;
	(void)report_error;
	(void)stack;

	out.set_rr_graph_tool_comment(root.getToolComment().cStr(), context);
	out.set_rr_graph_tool_name(root.getToolName().cStr(), context);
	out.set_rr_graph_tool_version(root.getToolVersion().cStr(), context);
	stack->push_back(std::make_pair("getChannels", 0));
	if (root.hasChannels()) {
		auto child_el = root.getChannels();
		auto child_context = out.init_rr_graph_channels(context);
		load_channels_capnp_type(child_el, out, child_context, report_error, stack);
		out.finish_rr_graph_channels(child_context);
	}
	stack->pop_back();
	stack->push_back(std::make_pair("getSwitches", 0));
	if (root.hasSwitches()) {
		auto child_el = root.getSwitches();
		auto child_context = out.init_rr_graph_switches(context);
		load_switches_capnp_type(child_el, out, child_context, report_error, stack);
		out.finish_rr_graph_switches(child_context);
	}
	stack->pop_back();
	stack->push_back(std::make_pair("getSegments", 0));
	if (root.hasSegments()) {
		auto child_el = root.getSegments();
		auto child_context = out.init_rr_graph_segments(context);
		load_segments_capnp_type(child_el, out, child_context, report_error, stack);
		out.finish_rr_graph_segments(child_context);
	}
	stack->pop_back();
	stack->push_back(std::make_pair("getBlockTypes", 0));
	if (root.hasBlockTypes()) {
		auto child_el = root.getBlockTypes();
		auto child_context = out.init_rr_graph_block_types(context);
		load_block_types_capnp_type(child_el, out, child_context, report_error, stack);
		out.finish_rr_graph_block_types(child_context);
	}
	stack->pop_back();
	stack->push_back(std::make_pair("getGrid", 0));
	if (root.hasGrid()) {
		auto child_el = root.getGrid();
		auto child_context = out.init_rr_graph_grid(context);
		load_grid_locs_capnp_type(child_el, out, child_context, report_error, stack);
		out.finish_rr_graph_grid(child_context);
	}
	stack->pop_back();
	stack->push_back(std::make_pair("getRrNodes", 0));
	if (root.hasRrNodes()) {
		auto child_el = root.getRrNodes();
		auto child_context = out.init_rr_graph_rr_nodes(context);
		load_rr_nodes_capnp_type(child_el, out, child_context, report_error, stack);
		out.finish_rr_graph_rr_nodes(child_context);
	}
	stack->pop_back();
	stack->push_back(std::make_pair("getRrEdges", 0));
	if (root.hasRrEdges()) {
		auto child_el = root.getRrEdges();
		auto child_context = out.init_rr_graph_rr_edges(context);
		load_rr_edges_capnp_type(child_el, out, child_context, report_error, stack);
		out.finish_rr_graph_rr_edges(child_context);
	}
	stack->pop_back();
}


/* Internal writing functions, which uxsdcxx uses to write out a class. */
template<class T, typename Context>
inline void write_channels_capnp_type(T &in, ucap::Channels::Builder &root, Context &context) {
	(void)in;
	(void)root;

	{
		auto child_context = in.get_channels_channel(context);
		auto channels_channel = root.initChannel();
		channels_channel.setChanWidthMax(in.get_channel_chan_width_max(child_context));
		channels_channel.setXMax(in.get_channel_x_max(child_context));
		channels_channel.setXMin(in.get_channel_x_min(child_context));
		channels_channel.setYMax(in.get_channel_y_max(child_context));
		channels_channel.setYMin(in.get_channel_y_min(child_context));
	}

	size_t num_channels_x_lists = in.num_channels_x_list(context);
	auto channels_x_lists = root.initXLists(num_channels_x_lists);
	for(size_t i = 0; i < num_channels_x_lists; i++) {
		auto channels_x_list = channels_x_lists[i];
		auto child_context = in.get_channels_x_list(i, context);
		channels_x_list.setIndex(in.get_x_list_index(child_context));
		channels_x_list.setInfo(in.get_x_list_info(child_context));
	}

	size_t num_channels_y_lists = in.num_channels_y_list(context);
	auto channels_y_lists = root.initYLists(num_channels_y_lists);
	for(size_t i = 0; i < num_channels_y_lists; i++) {
		auto channels_y_list = channels_y_lists[i];
		auto child_context = in.get_channels_y_list(i, context);
		channels_y_list.setIndex(in.get_y_list_index(child_context));
		channels_y_list.setInfo(in.get_y_list_info(child_context));
	}
}

template<class T, typename Context>
inline void write_switch_capnp_type(T &in, ucap::Switch::Builder &root, Context &context) {
	(void)in;
	(void)root;

	if(in.has_switch_timing(context)){
		auto switch_timing = root.initTiming();
		auto child_context = in.get_switch_timing(context);
		if((bool)in.get_timing_Cin(child_context))
			switch_timing.setCin(in.get_timing_Cin(child_context));
		if((bool)in.get_timing_Cinternal(child_context))
			switch_timing.setCinternal(in.get_timing_Cinternal(child_context));
		if((bool)in.get_timing_Cout(child_context))
			switch_timing.setCout(in.get_timing_Cout(child_context));
		if((bool)in.get_timing_R(child_context))
			switch_timing.setR(in.get_timing_R(child_context));
		if((bool)in.get_timing_Tdel(child_context))
			switch_timing.setTdel(in.get_timing_Tdel(child_context));
	}

	{
		auto child_context = in.get_switch_sizing(context);
		auto switch_sizing = root.initSizing();
		switch_sizing.setBufSize(in.get_sizing_buf_size(child_context));
		switch_sizing.setMuxTransSize(in.get_sizing_mux_trans_size(child_context));
	}
}

template<class T, typename Context>
inline void write_switches_capnp_type(T &in, ucap::Switches::Builder &root, Context &context) {
	(void)in;
	(void)root;

	size_t num_switches_switches = in.num_switches_switch(context);
	auto switches_switches = root.initSwitches(num_switches_switches);
	for(size_t i = 0; i < num_switches_switches; i++) {
		auto switches_switch = switches_switches[i];
		auto child_context = in.get_switches_switch(i, context);
		switches_switch.setId(in.get_switch_id(child_context));
		switches_switch.setName(in.get_switch_name(child_context));
		if((bool)in.get_switch_type(child_context))
			switches_switch.setType(conv_to_enum_switch_type(in.get_switch_type(child_context)));
		write_switch_capnp_type(in, switches_switch, child_context);
	}
}

template<class T, typename Context>
inline void write_segment_capnp_type(T &in, ucap::Segment::Builder &root, Context &context) {
	(void)in;
	(void)root;

	if(in.has_segment_timing(context)){
		auto segment_timing = root.initTiming();
		auto child_context = in.get_segment_timing(context);
		if((bool)in.get_segment_timing_C_per_meter(child_context))
			segment_timing.setCPerMeter(in.get_segment_timing_C_per_meter(child_context));
		if((bool)in.get_segment_timing_R_per_meter(child_context))
			segment_timing.setRPerMeter(in.get_segment_timing_R_per_meter(child_context));
	}
}

template<class T, typename Context>
inline void write_segments_capnp_type(T &in, ucap::Segments::Builder &root, Context &context) {
	(void)in;
	(void)root;

	size_t num_segments_segments = in.num_segments_segment(context);
	auto segments_segments = root.initSegments(num_segments_segments);
	for(size_t i = 0; i < num_segments_segments; i++) {
		auto segments_segment = segments_segments[i];
		auto child_context = in.get_segments_segment(i, context);
		segments_segment.setId(in.get_segment_id(child_context));
		if((bool)in.get_segment_length(child_context))
			segments_segment.setLength(in.get_segment_length(child_context));
		segments_segment.setName(in.get_segment_name(child_context));
		if((bool)in.get_segment_res_type(child_context))
			segments_segment.setResType(conv_to_enum_segment_res_type(in.get_segment_res_type(child_context)));
		write_segment_capnp_type(in, segments_segment, child_context);
	}
}

template<class T, typename Context>
inline void write_pin_capnp_type(T &in, ucap::Pin::Builder &root, Context &context) {
	(void)in;
	(void)root;
	root.setValue(in.get_pin_value(context));
}

template<class T, typename Context>
inline void write_pin_class_capnp_type(T &in, ucap::PinClass::Builder &root, Context &context) {
	(void)in;
	(void)root;

	size_t num_pin_class_pins = in.num_pin_class_pin(context);
	auto pin_class_pins = root.initPins(num_pin_class_pins);
	for(size_t i = 0; i < num_pin_class_pins; i++) {
		auto pin_class_pin = pin_class_pins[i];
		auto child_context = in.get_pin_class_pin(i, context);
		pin_class_pin.setPtc(in.get_pin_ptc(child_context));
		write_pin_capnp_type(in, pin_class_pin, child_context);
	}
}

template<class T, typename Context>
inline void write_block_type_capnp_type(T &in, ucap::BlockType::Builder &root, Context &context) {
	(void)in;
	(void)root;

	size_t num_block_type_pin_classes = in.num_block_type_pin_class(context);
	auto block_type_pin_classes = root.initPinClasses(num_block_type_pin_classes);
	for(size_t i = 0; i < num_block_type_pin_classes; i++) {
		auto block_type_pin_class = block_type_pin_classes[i];
		auto child_context = in.get_block_type_pin_class(i, context);
		block_type_pin_class.setType(conv_to_enum_pin_type(in.get_pin_class_type(child_context)));
		write_pin_class_capnp_type(in, block_type_pin_class, child_context);
	}
}

template<class T, typename Context>
inline void write_block_types_capnp_type(T &in, ucap::BlockTypes::Builder &root, Context &context) {
	(void)in;
	(void)root;

	size_t num_block_types_block_types = in.num_block_types_block_type(context);
	auto block_types_block_types = root.initBlockTypes(num_block_types_block_types);
	for(size_t i = 0; i < num_block_types_block_types; i++) {
		auto block_types_block_type = block_types_block_types[i];
		auto child_context = in.get_block_types_block_type(i, context);
		block_types_block_type.setHeight(in.get_block_type_height(child_context));
		block_types_block_type.setId(in.get_block_type_id(child_context));
		block_types_block_type.setName(in.get_block_type_name(child_context));
		block_types_block_type.setWidth(in.get_block_type_width(child_context));
		write_block_type_capnp_type(in, block_types_block_type, child_context);
	}
}

template<class T, typename Context>
inline void write_grid_locs_capnp_type(T &in, ucap::GridLocs::Builder &root, Context &context) {
	(void)in;
	(void)root;

	size_t num_grid_locs_grid_locs = in.num_grid_locs_grid_loc(context);
	auto grid_locs_grid_locs = root.initGridLocs(num_grid_locs_grid_locs);
	for(size_t i = 0; i < num_grid_locs_grid_locs; i++) {
		auto grid_locs_grid_loc = grid_locs_grid_locs[i];
		auto child_context = in.get_grid_locs_grid_loc(i, context);
		grid_locs_grid_loc.setBlockTypeId(in.get_grid_loc_block_type_id(child_context));
		grid_locs_grid_loc.setHeightOffset(in.get_grid_loc_height_offset(child_context));
		grid_locs_grid_loc.setLayer(in.get_grid_loc_layer(child_context));
		grid_locs_grid_loc.setWidthOffset(in.get_grid_loc_width_offset(child_context));
		grid_locs_grid_loc.setX(in.get_grid_loc_x(child_context));
		grid_locs_grid_loc.setY(in.get_grid_loc_y(child_context));
	}
}

template<class T, typename Context>
inline void write_meta_capnp_type(T &in, ucap::Meta::Builder &root, Context &context) {
	(void)in;
	(void)root;
	root.setValue(in.get_meta_value(context));
}

template<class T, typename Context>
inline void write_metadata_capnp_type(T &in, ucap::Metadata::Builder &root, Context &context) {
	(void)in;
	(void)root;

	size_t num_metadata_metas = in.num_metadata_meta(context);
	auto metadata_metas = root.initMetas(num_metadata_metas);
	for(size_t i = 0; i < num_metadata_metas; i++) {
		auto metadata_meta = metadata_metas[i];
		auto child_context = in.get_metadata_meta(i, context);
		metadata_meta.setName(in.get_meta_name(child_context));
		write_meta_capnp_type(in, metadata_meta, child_context);
	}
}

template<class T, typename Context>
inline void write_node_capnp_type(T &in, ucap::Node::Builder &root, Context &context) {
	(void)in;
	(void)root;

	{
		auto child_context = in.get_node_loc(context);
		auto node_loc = root.initLoc();
		node_loc.setLayer(in.get_node_loc_layer(child_context));
		node_loc.setPtc(in.get_node_loc_ptc(child_context));
		if((bool)in.get_node_loc_side(child_context))
			node_loc.setSide(conv_to_enum_loc_side(in.get_node_loc_side(child_context)));
		if((bool)in.get_node_loc_twist(child_context))
			node_loc.setTwist(in.get_node_loc_twist(child_context));
		node_loc.setXhigh(in.get_node_loc_xhigh(child_context));
		node_loc.setXlow(in.get_node_loc_xlow(child_context));
		node_loc.setYhigh(in.get_node_loc_yhigh(child_context));
		node_loc.setYlow(in.get_node_loc_ylow(child_context));
	}

	if(in.has_node_timing(context)){
		auto node_timing = root.initTiming();
		auto child_context = in.get_node_timing(context);
		node_timing.setC(in.get_node_timing_C(child_context));
		node_timing.setR(in.get_node_timing_R(child_context));
	}

	if(in.has_node_segment(context)){
		auto node_segment = root.initSegment();
		auto child_context = in.get_node_segment(context);
		node_segment.setSegmentId(in.get_node_segment_segment_id(child_context));
	}

	if(in.has_node_metadata(context)){
		auto node_metadata = root.initMetadata();
		auto child_context = in.get_node_metadata(context);
		write_metadata_capnp_type(in, node_metadata, child_context);
	}
}

template<class T, typename Context>
inline void write_rr_nodes_capnp_type(T &in, ucap::RrNodes::Builder &root, Context &context) {
	(void)in;
	(void)root;

	size_t num_rr_nodes_nodes = in.num_rr_nodes_node(context);
	auto rr_nodes_nodes = root.initNodes(num_rr_nodes_nodes);
	for(size_t i = 0; i < num_rr_nodes_nodes; i++) {
		auto rr_nodes_node = rr_nodes_nodes[i];
		auto child_context = in.get_rr_nodes_node(i, context);
		rr_nodes_node.setCapacity(in.get_node_capacity(child_context));
		if((bool)in.get_node_clk_res_type(child_context))
			rr_nodes_node.setClkResType(conv_to_enum_node_clk_res_type(in.get_node_clk_res_type(child_context)));
		if((bool)in.get_node_direction(child_context))
			rr_nodes_node.setDirection(conv_to_enum_node_direction(in.get_node_direction(child_context)));
		rr_nodes_node.setId(in.get_node_id(child_context));
		if((bool)in.get_node_name(child_context))
			rr_nodes_node.setName(in.get_node_name(child_context));
		rr_nodes_node.setType(conv_to_enum_node_type(in.get_node_type(child_context)));
		write_node_capnp_type(in, rr_nodes_node, child_context);
	}
}

template<class T, typename Context>
inline void write_edge_capnp_type(T &in, ucap::Edge::Builder &root, Context &context) {
	(void)in;
	(void)root;

	if(in.has_edge_metadata(context)){
		auto edge_metadata = root.initMetadata();
		auto child_context = in.get_edge_metadata(context);
		write_metadata_capnp_type(in, edge_metadata, child_context);
	}
}

template<class T, typename Context>
inline void write_rr_edges_capnp_type(T &in, ucap::RrEdges::Builder &root, Context &context) {
	(void)in;
	(void)root;

	size_t num_rr_edges_edges = in.num_rr_edges_edge(context);
	auto rr_edges_edges = root.initEdges(num_rr_edges_edges);
	for(size_t i = 0; i < num_rr_edges_edges; i++) {
		auto rr_edges_edge = rr_edges_edges[i];
		auto child_context = in.get_rr_edges_edge(i, context);
		rr_edges_edge.setSinkNode(in.get_edge_sink_node(child_context));
		rr_edges_edge.setSrcNode(in.get_edge_src_node(child_context));
		rr_edges_edge.setSwitchId(in.get_edge_switch_id(child_context));
		write_edge_capnp_type(in, rr_edges_edge, child_context);
	}
}

template<class T, typename Context>
inline void write_rr_graph_capnp_type(T &in, ucap::RrGraph::Builder &root, Context &context) {
	(void)in;
	(void)root;

	{
		auto child_context = in.get_rr_graph_channels(context);
		auto rr_graph_channels = root.initChannels();
		write_channels_capnp_type(in, rr_graph_channels, child_context);
	}

	{
		auto child_context = in.get_rr_graph_switches(context);
		auto rr_graph_switches = root.initSwitches();
		write_switches_capnp_type(in, rr_graph_switches, child_context);
	}

	{
		auto child_context = in.get_rr_graph_segments(context);
		auto rr_graph_segments = root.initSegments();
		write_segments_capnp_type(in, rr_graph_segments, child_context);
	}

	{
		auto child_context = in.get_rr_graph_block_types(context);
		auto rr_graph_block_types = root.initBlockTypes();
		write_block_types_capnp_type(in, rr_graph_block_types, child_context);
	}

	{
		auto child_context = in.get_rr_graph_grid(context);
		auto rr_graph_grid = root.initGrid();
		write_grid_locs_capnp_type(in, rr_graph_grid, child_context);
	}

	{
		auto child_context = in.get_rr_graph_rr_nodes(context);
		auto rr_graph_rr_nodes = root.initRrNodes();
		write_rr_nodes_capnp_type(in, rr_graph_rr_nodes, child_context);
	}

	{
		auto child_context = in.get_rr_graph_rr_edges(context);
		auto rr_graph_rr_edges = root.initRrEdges();
		write_rr_edges_capnp_type(in, rr_graph_rr_edges, child_context);
	}
}


} /* namespace uxsd */
