// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from qml_group.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include "OffsetPropertyGroup.h"

#include <QQmlEngine>

#include "QuickStyle.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

OffsetPropertyGroup::OffsetPropertyGroup(QuickStyle *style)
    : QObject()
    , m_style(style)
{
}

void OffsetPropertyGroup::update(const std::optional<OffsetProperty> &newState)
{
    m_state = newState;

    if (!newState) {
    } else {
    }

    Q_EMIT horizontalChanged();
    Q_EMIT verticalChanged();
    Q_EMIT updated();
}

QJSValue OffsetPropertyGroup::horizontal() const
{
    if (!m_state) {
        return QJSValue(QJSValue::UndefinedValue);
    }

    auto value = m_state.value().horizontal();
    if (value) {
        return m_style->engine()->toScriptValue(value.value());
    }

    return QJSValue(QJSValue::UndefinedValue);
}

QJSValue OffsetPropertyGroup::vertical() const
{
    if (!m_state) {
        return QJSValue(QJSValue::UndefinedValue);
    }

    auto value = m_state.value().vertical();
    if (value) {
        return m_style->engine()->toScriptValue(value.value());
    }

    return QJSValue(QJSValue::UndefinedValue);
}

#include "moc_OffsetPropertyGroup.cpp"