/* Generated by wayland-scanner 1.24.0 */

#ifndef TREELAND_DDE_SHELL_V1_SERVER_PROTOCOL_H
#define TREELAND_DDE_SHELL_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_treeland_dde_shell_v1 The treeland_dde_shell_v1 protocol
 * @section page_ifaces_treeland_dde_shell_v1 Interfaces
 * - @subpage page_iface_treeland_dde_shell_manager_v1 - dde shell manager
 * - @subpage page_iface_treeland_window_overlap_checker - An opened toplevel
 * - @subpage page_iface_treeland_dde_shell_surface_v1 - metadata interface
 * - @subpage page_iface_treeland_dde_active_v1 - metadata interface
 * - @subpage page_iface_treeland_multitaskview_v1 - multitaskview context interface
 * - @subpage page_iface_treeland_window_picker_v1 - window picker interface
 * - @subpage page_iface_treeland_lockscreen_v1 - lockscreen interface
 * @section page_copyright_treeland_dde_shell_v1 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
 * SPDX-License-Identifier: MIT
 * </pre>
 */
struct treeland_dde_active_v1;
struct treeland_dde_shell_manager_v1;
struct treeland_dde_shell_surface_v1;
struct treeland_lockscreen_v1;
struct treeland_multitaskview_v1;
struct treeland_window_overlap_checker;
struct treeland_window_picker_v1;
struct wl_callback;
struct wl_output;
struct wl_seat;
struct wl_surface;

#ifndef TREELAND_DDE_SHELL_MANAGER_V1_INTERFACE
#define TREELAND_DDE_SHELL_MANAGER_V1_INTERFACE
/**
 * @page page_iface_treeland_dde_shell_manager_v1 treeland_dde_shell_manager_v1
 * @section page_iface_treeland_dde_shell_manager_v1_desc Description
 *
 * This interface allows DDE change some treeland function.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 * @section page_iface_treeland_dde_shell_manager_v1_api API
 * See @ref iface_treeland_dde_shell_manager_v1.
 */
/**
 * @defgroup iface_treeland_dde_shell_manager_v1 The treeland_dde_shell_manager_v1 interface
 *
 * This interface allows DDE change some treeland function.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 */
extern const struct wl_interface treeland_dde_shell_manager_v1_interface;
#endif
#ifndef TREELAND_WINDOW_OVERLAP_CHECKER_INTERFACE
#define TREELAND_WINDOW_OVERLAP_CHECKER_INTERFACE
/**
 * @page page_iface_treeland_window_overlap_checker treeland_window_overlap_checker
 * @section page_iface_treeland_window_overlap_checker_desc Description
 *
 * A treeland_dde_shell_handle_v1 object represents an opened toplevel window. Each
 * app may have multiple opened toplevels.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 * @section page_iface_treeland_window_overlap_checker_api API
 * See @ref iface_treeland_window_overlap_checker.
 */
/**
 * @defgroup iface_treeland_window_overlap_checker The treeland_window_overlap_checker interface
 *
 * A treeland_dde_shell_handle_v1 object represents an opened toplevel window. Each
 * app may have multiple opened toplevels.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 */
extern const struct wl_interface treeland_window_overlap_checker_interface;
#endif
#ifndef TREELAND_DDE_SHELL_SURFACE_V1_INTERFACE
#define TREELAND_DDE_SHELL_SURFACE_V1_INTERFACE
/**
 * @page page_iface_treeland_dde_shell_surface_v1 treeland_dde_shell_surface_v1
 * @section page_iface_treeland_dde_shell_surface_v1_desc Description
 *
 * An interface that may be implemented by a wl_surface, for
 * implementations that provide the shell user interface.
 *
 * It provides requests to set surface role, set skip, set the position
 * set auto placement in output coordinates.
 *
 * On the server side the object is automatically destroyed when
 * the related wl_surface is destroyed.  On client side,
 * treeland_dde_shell_surface_v1.destroy() must be called before
 * destroying the wl_surface object.
 * @section page_iface_treeland_dde_shell_surface_v1_api API
 * See @ref iface_treeland_dde_shell_surface_v1.
 */
/**
 * @defgroup iface_treeland_dde_shell_surface_v1 The treeland_dde_shell_surface_v1 interface
 *
 * An interface that may be implemented by a wl_surface, for
 * implementations that provide the shell user interface.
 *
 * It provides requests to set surface role, set skip, set the position
 * set auto placement in output coordinates.
 *
 * On the server side the object is automatically destroyed when
 * the related wl_surface is destroyed.  On client side,
 * treeland_dde_shell_surface_v1.destroy() must be called before
 * destroying the wl_surface object.
 */
extern const struct wl_interface treeland_dde_shell_surface_v1_interface;
#endif
#ifndef TREELAND_DDE_ACTIVE_V1_INTERFACE
#define TREELAND_DDE_ACTIVE_V1_INTERFACE
/**
 * @page page_iface_treeland_dde_active_v1 treeland_dde_active_v1
 * @section page_iface_treeland_dde_active_v1_desc Description
 *
 * An interface used to monitor special events.
 * @section page_iface_treeland_dde_active_v1_api API
 * See @ref iface_treeland_dde_active_v1.
 */
/**
 * @defgroup iface_treeland_dde_active_v1 The treeland_dde_active_v1 interface
 *
 * An interface used to monitor special events.
 */
extern const struct wl_interface treeland_dde_active_v1_interface;
#endif
#ifndef TREELAND_MULTITASKVIEW_V1_INTERFACE
#define TREELAND_MULTITASKVIEW_V1_INTERFACE
/**
 * @page page_iface_treeland_multitaskview_v1 treeland_multitaskview_v1
 * @section page_iface_treeland_multitaskview_v1_desc Description
 *
 * An interface used to control multitaskview.
 * @section page_iface_treeland_multitaskview_v1_api API
 * See @ref iface_treeland_multitaskview_v1.
 */
/**
 * @defgroup iface_treeland_multitaskview_v1 The treeland_multitaskview_v1 interface
 *
 * An interface used to control multitaskview.
 */
extern const struct wl_interface treeland_multitaskview_v1_interface;
#endif
#ifndef TREELAND_WINDOW_PICKER_V1_INTERFACE
#define TREELAND_WINDOW_PICKER_V1_INTERFACE
/**
 * @page page_iface_treeland_window_picker_v1 treeland_window_picker_v1
 * @section page_iface_treeland_window_picker_v1_desc Description
 *
 * An interface used to pick window and return credentials.
 * @section page_iface_treeland_window_picker_v1_api API
 * See @ref iface_treeland_window_picker_v1.
 */
/**
 * @defgroup iface_treeland_window_picker_v1 The treeland_window_picker_v1 interface
 *
 * An interface used to pick window and return credentials.
 */
extern const struct wl_interface treeland_window_picker_v1_interface;
#endif
#ifndef TREELAND_LOCKSCREEN_V1_INTERFACE
#define TREELAND_LOCKSCREEN_V1_INTERFACE
/**
 * @page page_iface_treeland_lockscreen_v1 treeland_lockscreen_v1
 * @section page_iface_treeland_lockscreen_v1_desc Description
 *
 * An interface used to operate lockscreen.
 * @section page_iface_treeland_lockscreen_v1_api API
 * See @ref iface_treeland_lockscreen_v1.
 */
/**
 * @defgroup iface_treeland_lockscreen_v1 The treeland_lockscreen_v1 interface
 *
 * An interface used to operate lockscreen.
 */
extern const struct wl_interface treeland_lockscreen_v1_interface;
#endif

/**
 * @ingroup iface_treeland_dde_shell_manager_v1
 * @struct treeland_dde_shell_manager_v1_interface
 */
struct treeland_dde_shell_manager_v1_interface {
	/**
	 */
	void (*get_window_overlap_checker)(struct wl_client *client,
					   struct wl_resource *resource,
					   uint32_t id);
	/**
	 * create a shell surface from a surface
	 *
	 * Create a shell surface for an existing wl_surface.
	 *
	 * Only one shell surface can be associated with a given surface.
	 *
	 * Recommended for use with xdg_surface.
	 */
	void (*get_shell_surface)(struct wl_client *client,
				  struct wl_resource *resource,
				  uint32_t id,
				  struct wl_resource *surface);
	/**
	 * create a new dde active
	 *
	 * Create a new dde active for a given seat.
	 * @param seat seat associated with the dde_active
	 */
	void (*get_treeland_dde_active)(struct wl_client *client,
					struct wl_resource *resource,
					uint32_t id,
					struct wl_resource *seat);
	/**
	 * create a new multitaskview context
	 *
	 * Create a new multitaskview context for toggle.
	 */
	void (*get_treeland_multitaskview)(struct wl_client *client,
					   struct wl_resource *resource,
					   uint32_t id);
	/**
	 * create a new window picker
	 *
	 * Create a new window picker to pick window.
	 */
	void (*get_treeland_window_picker)(struct wl_client *client,
					   struct wl_resource *resource,
					   uint32_t id);
	/**
	 * create a new lockscreen context
	 *
	 * Create a new lockscreen context for toggle.
	 */
	void (*get_treeland_lockscreen)(struct wl_client *client,
					struct wl_resource *resource,
					uint32_t id);
	/**
	 * Move a XWayland surface to a position relative to a wl_surface
	 *
	 * Move the top-left point of a XWayland surface specified with
	 * Window ID, to a position that has (dx, dy) offset from the
	 * top-left point of a wl_surface
	 *
	 * Once the server finished process it send "done" to the callback.
	 * The callback data 0 means no error occured, 1 means something
	 * went wrong and the move cannot be done.
	 */
	void (*set_xwindow_position_relative)(struct wl_client *client,
					      struct wl_resource *resource,
					      uint32_t callback,
					      uint32_t wid,
					      struct wl_resource *anchor,
					      wl_fixed_t dx,
					      wl_fixed_t dy);
};


/**
 * @ingroup iface_treeland_dde_shell_manager_v1
 */
#define TREELAND_DDE_SHELL_MANAGER_V1_GET_WINDOW_OVERLAP_CHECKER_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_dde_shell_manager_v1
 */
#define TREELAND_DDE_SHELL_MANAGER_V1_GET_SHELL_SURFACE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_dde_shell_manager_v1
 */
#define TREELAND_DDE_SHELL_MANAGER_V1_GET_TREELAND_DDE_ACTIVE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_dde_shell_manager_v1
 */
#define TREELAND_DDE_SHELL_MANAGER_V1_GET_TREELAND_MULTITASKVIEW_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_dde_shell_manager_v1
 */
#define TREELAND_DDE_SHELL_MANAGER_V1_GET_TREELAND_WINDOW_PICKER_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_dde_shell_manager_v1
 */
#define TREELAND_DDE_SHELL_MANAGER_V1_GET_TREELAND_LOCKSCREEN_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_dde_shell_manager_v1
 */
#define TREELAND_DDE_SHELL_MANAGER_V1_SET_XWINDOW_POSITION_RELATIVE_SINCE_VERSION 1

#ifndef TREELAND_WINDOW_OVERLAP_CHECKER_ANCHOR_ENUM
#define TREELAND_WINDOW_OVERLAP_CHECKER_ANCHOR_ENUM
/**
 * @ingroup iface_treeland_window_overlap_checker
 * same layershell
 *
 * same layershell
 */
enum treeland_window_overlap_checker_anchor {
	/**
	 * the top edge of the anchor rectangle
	 */
	TREELAND_WINDOW_OVERLAP_CHECKER_ANCHOR_TOP = 1,
	/**
	 * the bottom edge of the anchor rectangle
	 */
	TREELAND_WINDOW_OVERLAP_CHECKER_ANCHOR_BOTTOM = 2,
	/**
	 * the left edge of the anchor rectangle
	 */
	TREELAND_WINDOW_OVERLAP_CHECKER_ANCHOR_LEFT = 4,
	/**
	 * the right edge of the anchor rectangle
	 */
	TREELAND_WINDOW_OVERLAP_CHECKER_ANCHOR_RIGHT = 8,
};
#endif /* TREELAND_WINDOW_OVERLAP_CHECKER_ANCHOR_ENUM */

#ifndef TREELAND_WINDOW_OVERLAP_CHECKER_ANCHOR_ENUM_IS_VALID
#define TREELAND_WINDOW_OVERLAP_CHECKER_ANCHOR_ENUM_IS_VALID
/**
 * @ingroup iface_treeland_window_overlap_checker
 * Validate a treeland_window_overlap_checker anchor value.
 *
 * @return true on success, false on error.
 * @ref treeland_window_overlap_checker_anchor
 */
static inline bool
treeland_window_overlap_checker_anchor_is_valid(uint32_t value, uint32_t version) {
	uint32_t valid = 0;
	if (version >= 1)
		valid |= TREELAND_WINDOW_OVERLAP_CHECKER_ANCHOR_TOP;
	if (version >= 1)
		valid |= TREELAND_WINDOW_OVERLAP_CHECKER_ANCHOR_BOTTOM;
	if (version >= 1)
		valid |= TREELAND_WINDOW_OVERLAP_CHECKER_ANCHOR_LEFT;
	if (version >= 1)
		valid |= TREELAND_WINDOW_OVERLAP_CHECKER_ANCHOR_RIGHT;
	return (value & ~valid) == 0;
}
#endif /* TREELAND_WINDOW_OVERLAP_CHECKER_ANCHOR_ENUM_IS_VALID */

/**
 * @ingroup iface_treeland_window_overlap_checker
 * @struct treeland_window_overlap_checker_interface
 */
struct treeland_window_overlap_checker_interface {
	/**
	 * Register the detected surface
	 *
	 * This interface is used to receive the detected surface. When
	 * the xdgshell window in the workspace overlaps with the detected
	 * window, an event will be sent to notify the client to process
	 * it. The window position will only be recorded when this
	 * interface is called. If the window moves, this interface needs
	 * to be called again.
	 */
	void (*update)(struct wl_client *client,
		       struct wl_resource *resource,
		       int32_t width,
		       int32_t height,
		       uint32_t anchor,
		       struct wl_resource *output);
	/**
	 * destroy the treeland_window_overlap_checker object
	 *
	 * Destroys the treeland_window_overlap_checker object.
	 *
	 * This request should be called either when the client does not
	 * want to use the toplevel anymore or after the closed event to
	 * finalize the destruction of the object.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define TREELAND_WINDOW_OVERLAP_CHECKER_ENTER 0
#define TREELAND_WINDOW_OVERLAP_CHECKER_LEAVE 1

/**
 * @ingroup iface_treeland_window_overlap_checker
 */
#define TREELAND_WINDOW_OVERLAP_CHECKER_ENTER_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_window_overlap_checker
 */
#define TREELAND_WINDOW_OVERLAP_CHECKER_LEAVE_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_window_overlap_checker
 */
#define TREELAND_WINDOW_OVERLAP_CHECKER_UPDATE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_window_overlap_checker
 */
#define TREELAND_WINDOW_OVERLAP_CHECKER_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_window_overlap_checker
 * Sends an enter event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
treeland_window_overlap_checker_send_enter(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, TREELAND_WINDOW_OVERLAP_CHECKER_ENTER);
}

/**
 * @ingroup iface_treeland_window_overlap_checker
 * Sends an leave event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
treeland_window_overlap_checker_send_leave(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, TREELAND_WINDOW_OVERLAP_CHECKER_LEAVE);
}

#ifndef TREELAND_DDE_SHELL_SURFACE_V1_ROLE_ENUM
#define TREELAND_DDE_SHELL_SURFACE_V1_ROLE_ENUM
/**
 * @ingroup iface_treeland_dde_shell_surface_v1
 * available roles for surfaces
 *
 * These values indicate which roles a surface can be rendered in, They
 * are ordered by z depth.
 *
 * Displayed below wlr-layer-shell, at the overlay level of the workspace.
 *
 * Multiple surfaces can share a single role, and ordering within a single
 * role is undefined.
 */
enum treeland_dde_shell_surface_v1_role {
	TREELAND_DDE_SHELL_SURFACE_V1_ROLE_OVERLAY = 1,
};
#endif /* TREELAND_DDE_SHELL_SURFACE_V1_ROLE_ENUM */

#ifndef TREELAND_DDE_SHELL_SURFACE_V1_ROLE_ENUM_IS_VALID
#define TREELAND_DDE_SHELL_SURFACE_V1_ROLE_ENUM_IS_VALID
/**
 * @ingroup iface_treeland_dde_shell_surface_v1
 * Validate a treeland_dde_shell_surface_v1 role value.
 *
 * @return true on success, false on error.
 * @ref treeland_dde_shell_surface_v1_role
 */
static inline bool
treeland_dde_shell_surface_v1_role_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case TREELAND_DDE_SHELL_SURFACE_V1_ROLE_OVERLAY:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* TREELAND_DDE_SHELL_SURFACE_V1_ROLE_ENUM_IS_VALID */

/**
 * @ingroup iface_treeland_dde_shell_surface_v1
 * @struct treeland_dde_shell_surface_v1_interface
 */
struct treeland_dde_shell_surface_v1_interface {
	/**
	 * destroy the treeland_dde_shell_surface_v1 object
	 *
	 * The treeland_dde_shell_surface_v1 interface is removed from
	 * the wl_surface object that was turned into a shell surface with
	 * the treeland_shell_v1.get_treeland_dde_shell_surface request.
	 *
	 * The shell surface role is lost and wl_surface is unmapped.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * change the shell surface position
	 *
	 * Move the surface to new coordinates.
	 *
	 * Coordinates are global, for example 50,50 for a 1920,0+1920x1080
	 * output is 1970,50 in global coordinates space.
	 * @param x x coordinate in global space
	 * @param y y coordinate in global space
	 */
	void (*set_surface_position)(struct wl_client *client,
				     struct wl_resource *resource,
				     int32_t x,
				     int32_t y);
	/**
	 * assign a role to this surface
	 *
	 * Assign a role to a shell surface.
	 */
	void (*set_role)(struct wl_client *client,
			 struct wl_resource *resource,
			 uint32_t role);
	/**
	 * Place the surface at the bottom of the cursor area
	 *
	 * Set the vertical alignment of the surface within the cursor
	 * width.
	 *
	 * Do not use it together with set_surface_position to avoid
	 * exceptions.
	 *
	 * The position of the surface will be controlled by the compositor
	 * after the request, including preventing it from being displayed
	 * beyond the edge of the output.
	 * @param y_offset y position is relative to the cursor bottom
	 */
	void (*set_auto_placement)(struct wl_client *client,
				   struct wl_resource *resource,
				   uint32_t y_offset);
	/**
	 * make the window not appear in a switcher
	 *
	 * Setting this bit will indicate that the window prefers not to
	 * be listed in a switcher.
	 * @param skip Boolean value that sets whether to skip the window switcher.
	 */
	void (*set_skip_switcher)(struct wl_client *client,
				  struct wl_resource *resource,
				  uint32_t skip);
	/**
	 * make the window not appear in a dock preview
	 *
	 * Setting this bit will indicate that the window prefers not to
	 * be listed in a dock preview.
	 * @param skip Boolean value that sets whether to skip the dock preview.
	 */
	void (*set_skip_dock_preview)(struct wl_client *client,
				      struct wl_resource *resource,
				      uint32_t skip);
	/**
	 * make the window not appear in a mutitask view
	 *
	 * Setting this bit will indicate that the window prefers not to
	 * be listed in a mutitask view.
	 * @param skip Boolean value that sets whether to skip the mutitask view.
	 */
	void (*set_skip_muti_task_view)(struct wl_client *client,
					struct wl_resource *resource,
					uint32_t skip);
	/**
	 * control whether the surface accepts keyboard focus
	 *
	 * Setting this will determine whether the surface can receive
	 * keyboard focus. When set to 0, the surface will not receive
	 * keyboard focus even when clicked or activated. When set to 1
	 * (default), the surface will receive keyboard focus normally.
	 * @param accept Boolean value that sets whether to accept keyboard focus
	 */
	void (*set_accept_keyboard_focus)(struct wl_client *client,
					  struct wl_resource *resource,
					  uint32_t accept);
};


/**
 * @ingroup iface_treeland_dde_shell_surface_v1
 */
#define TREELAND_DDE_SHELL_SURFACE_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_dde_shell_surface_v1
 */
#define TREELAND_DDE_SHELL_SURFACE_V1_SET_SURFACE_POSITION_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_dde_shell_surface_v1
 */
#define TREELAND_DDE_SHELL_SURFACE_V1_SET_ROLE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_dde_shell_surface_v1
 */
#define TREELAND_DDE_SHELL_SURFACE_V1_SET_AUTO_PLACEMENT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_dde_shell_surface_v1
 */
#define TREELAND_DDE_SHELL_SURFACE_V1_SET_SKIP_SWITCHER_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_dde_shell_surface_v1
 */
#define TREELAND_DDE_SHELL_SURFACE_V1_SET_SKIP_DOCK_PREVIEW_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_dde_shell_surface_v1
 */
#define TREELAND_DDE_SHELL_SURFACE_V1_SET_SKIP_MUTI_TASK_VIEW_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_dde_shell_surface_v1
 */
#define TREELAND_DDE_SHELL_SURFACE_V1_SET_ACCEPT_KEYBOARD_FOCUS_SINCE_VERSION 1

#ifndef TREELAND_DDE_ACTIVE_V1_REASON_ENUM
#define TREELAND_DDE_ACTIVE_V1_REASON_ENUM
/**
 * @ingroup iface_treeland_dde_active_v1
 * event reason
 */
enum treeland_dde_active_v1_reason {
	TREELAND_DDE_ACTIVE_V1_REASON_MOUSE = 0,
	TREELAND_DDE_ACTIVE_V1_REASON_WHEEL = 1,
};
#endif /* TREELAND_DDE_ACTIVE_V1_REASON_ENUM */

#ifndef TREELAND_DDE_ACTIVE_V1_REASON_ENUM_IS_VALID
#define TREELAND_DDE_ACTIVE_V1_REASON_ENUM_IS_VALID
/**
 * @ingroup iface_treeland_dde_active_v1
 * Validate a treeland_dde_active_v1 reason value.
 *
 * @return true on success, false on error.
 * @ref treeland_dde_active_v1_reason
 */
static inline bool
treeland_dde_active_v1_reason_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case TREELAND_DDE_ACTIVE_V1_REASON_MOUSE:
		return version >= 1;
	case TREELAND_DDE_ACTIVE_V1_REASON_WHEEL:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* TREELAND_DDE_ACTIVE_V1_REASON_ENUM_IS_VALID */

/**
 * @ingroup iface_treeland_dde_active_v1
 * @struct treeland_dde_active_v1_interface
 */
struct treeland_dde_active_v1_interface {
	/**
	 * destroy the treeland_dde_active_v1 object
	 *
	 * 
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define TREELAND_DDE_ACTIVE_V1_ACTIVE_IN 0
#define TREELAND_DDE_ACTIVE_V1_ACTIVE_OUT 1
#define TREELAND_DDE_ACTIVE_V1_START_DRAG 2
#define TREELAND_DDE_ACTIVE_V1_DROP 3

/**
 * @ingroup iface_treeland_dde_active_v1
 */
#define TREELAND_DDE_ACTIVE_V1_ACTIVE_IN_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_dde_active_v1
 */
#define TREELAND_DDE_ACTIVE_V1_ACTIVE_OUT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_dde_active_v1
 */
#define TREELAND_DDE_ACTIVE_V1_START_DRAG_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_dde_active_v1
 */
#define TREELAND_DDE_ACTIVE_V1_DROP_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_dde_active_v1
 */
#define TREELAND_DDE_ACTIVE_V1_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_dde_active_v1
 * Sends an active_in event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
treeland_dde_active_v1_send_active_in(struct wl_resource *resource_, uint32_t reason)
{
	wl_resource_post_event(resource_, TREELAND_DDE_ACTIVE_V1_ACTIVE_IN, reason);
}

/**
 * @ingroup iface_treeland_dde_active_v1
 * Sends an active_out event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
treeland_dde_active_v1_send_active_out(struct wl_resource *resource_, uint32_t reason)
{
	wl_resource_post_event(resource_, TREELAND_DDE_ACTIVE_V1_ACTIVE_OUT, reason);
}

/**
 * @ingroup iface_treeland_dde_active_v1
 * Sends an start_drag event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
treeland_dde_active_v1_send_start_drag(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, TREELAND_DDE_ACTIVE_V1_START_DRAG);
}

/**
 * @ingroup iface_treeland_dde_active_v1
 * Sends an drop event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
treeland_dde_active_v1_send_drop(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, TREELAND_DDE_ACTIVE_V1_DROP);
}

/**
 * @ingroup iface_treeland_multitaskview_v1
 * @struct treeland_multitaskview_v1_interface
 */
struct treeland_multitaskview_v1_interface {
	/**
	 * destroy the treeland_multitaskview_v1 object
	 *
	 * 
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * toggle multitaskview
	 *
	 * Show or hide the multitaskview.
	 */
	void (*toggle)(struct wl_client *client,
		       struct wl_resource *resource);
};


/**
 * @ingroup iface_treeland_multitaskview_v1
 */
#define TREELAND_MULTITASKVIEW_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_multitaskview_v1
 */
#define TREELAND_MULTITASKVIEW_V1_TOGGLE_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_window_picker_v1
 * @struct treeland_window_picker_v1_interface
 */
struct treeland_window_picker_v1_interface {
	/**
	 * destroy the treeland_window_picker_v1 object
	 *
	 * 
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * pick a window
	 *
	 * Pick a window to get information.
	 * @param hint Hint of pick process
	 */
	void (*pick)(struct wl_client *client,
		     struct wl_resource *resource,
		     const char *hint);
};

#define TREELAND_WINDOW_PICKER_V1_WINDOW 0

/**
 * @ingroup iface_treeland_window_picker_v1
 */
#define TREELAND_WINDOW_PICKER_V1_WINDOW_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_window_picker_v1
 */
#define TREELAND_WINDOW_PICKER_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_window_picker_v1
 */
#define TREELAND_WINDOW_PICKER_V1_PICK_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_window_picker_v1
 * Sends an window event to the client owning the resource.
 * @param resource_ The client's resource
 * @param pid Pid of picked window
 */
static inline void
treeland_window_picker_v1_send_window(struct wl_resource *resource_, int32_t pid)
{
	wl_resource_post_event(resource_, TREELAND_WINDOW_PICKER_V1_WINDOW, pid);
}

/**
 * @ingroup iface_treeland_lockscreen_v1
 * @struct treeland_lockscreen_v1_interface
 */
struct treeland_lockscreen_v1_interface {
	/**
	 * destroy the treeland_lockscreen_v1 object
	 *
	 * 
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * lock screen
	 *
	 * Lock the screen.
	 */
	void (*lock)(struct wl_client *client,
		     struct wl_resource *resource);
	/**
	 * show shutdown
	 *
	 * Show shutdown.
	 */
	void (*shutdown)(struct wl_client *client,
			 struct wl_resource *resource);
	/**
	 * switch user
	 *
	 * Switch user.
	 */
	void (*switch_user)(struct wl_client *client,
			    struct wl_resource *resource);
};


/**
 * @ingroup iface_treeland_lockscreen_v1
 */
#define TREELAND_LOCKSCREEN_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_lockscreen_v1
 */
#define TREELAND_LOCKSCREEN_V1_LOCK_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_lockscreen_v1
 */
#define TREELAND_LOCKSCREEN_V1_SHUTDOWN_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_lockscreen_v1
 */
#define TREELAND_LOCKSCREEN_V1_SWITCH_USER_SINCE_VERSION 1

#ifdef  __cplusplus
}
#endif

#endif
