/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	apisv1 "sigs.k8s.io/gateway-api/apis/v1"
)

// HTTPExternalAuthFilterApplyConfiguration represents a declarative configuration of the HTTPExternalAuthFilter type for use
// with apply.
type HTTPExternalAuthFilterApplyConfiguration struct {
	ExternalAuthProtocol *apisv1.HTTPRouteExternalAuthProtocol     `json:"protocol,omitempty"`
	BackendRef           *BackendObjectReferenceApplyConfiguration `json:"backendRef,omitempty"`
	GRPCAuthConfig       *GRPCAuthConfigApplyConfiguration         `json:"grpc,omitempty"`
	HTTPAuthConfig       *HTTPAuthConfigApplyConfiguration         `json:"http,omitempty"`
	ForwardBody          *ForwardBodyConfigApplyConfiguration      `json:"forwardBody,omitempty"`
}

// HTTPExternalAuthFilterApplyConfiguration constructs a declarative configuration of the HTTPExternalAuthFilter type for use with
// apply.
func HTTPExternalAuthFilter() *HTTPExternalAuthFilterApplyConfiguration {
	return &HTTPExternalAuthFilterApplyConfiguration{}
}

// WithExternalAuthProtocol sets the ExternalAuthProtocol field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ExternalAuthProtocol field is set to the value of the last call.
func (b *HTTPExternalAuthFilterApplyConfiguration) WithExternalAuthProtocol(value apisv1.HTTPRouteExternalAuthProtocol) *HTTPExternalAuthFilterApplyConfiguration {
	b.ExternalAuthProtocol = &value
	return b
}

// WithBackendRef sets the BackendRef field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the BackendRef field is set to the value of the last call.
func (b *HTTPExternalAuthFilterApplyConfiguration) WithBackendRef(value *BackendObjectReferenceApplyConfiguration) *HTTPExternalAuthFilterApplyConfiguration {
	b.BackendRef = value
	return b
}

// WithGRPCAuthConfig sets the GRPCAuthConfig field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the GRPCAuthConfig field is set to the value of the last call.
func (b *HTTPExternalAuthFilterApplyConfiguration) WithGRPCAuthConfig(value *GRPCAuthConfigApplyConfiguration) *HTTPExternalAuthFilterApplyConfiguration {
	b.GRPCAuthConfig = value
	return b
}

// WithHTTPAuthConfig sets the HTTPAuthConfig field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the HTTPAuthConfig field is set to the value of the last call.
func (b *HTTPExternalAuthFilterApplyConfiguration) WithHTTPAuthConfig(value *HTTPAuthConfigApplyConfiguration) *HTTPExternalAuthFilterApplyConfiguration {
	b.HTTPAuthConfig = value
	return b
}

// WithForwardBody sets the ForwardBody field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ForwardBody field is set to the value of the last call.
func (b *HTTPExternalAuthFilterApplyConfiguration) WithForwardBody(value *ForwardBodyConfigApplyConfiguration) *HTTPExternalAuthFilterApplyConfiguration {
	b.ForwardBody = value
	return b
}
