const char metrics_tarantool_slab_lua[] =
"local utils = require('metrics.utils')\n"
"\n"
"local collectors_list = {}\n"
"\n"
"local function update_slab_metrics()\n"
"    if not utils.box_is_configured() then\n"
"        return\n"
"    end\n"
"\n"
"    local slab_info = box.slab.info()\n"
"\n"
"    for k, v in pairs(slab_info) do\n"
"        local metric_name = 'slab_' .. k\n"
"        if not k:match('_ratio$') then\n"
"            collectors_list[metric_name] = utils.set_gauge(metric_name, 'Slab ' .. k .. ' info', v,\n"
"                nil, nil, {default = true})\n"
"        else\n"
"            collectors_list[metric_name] =\n"
"                utils.set_gauge(metric_name, 'Slab ' .. k .. ' info', tonumber(v:match('^([0-9%.]+)%%\?$')),\n"
"                nil, nil, {default = true})\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"return {\n"
"    update = update_slab_metrics,\n"
"    list = collectors_list,\n"
"}\n"
""
;
