/* DisplaysView.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DisplaysView.vala, do not modify */

/*
 * SPDX-License-Identifier: LGPL-2.0-or-later
 * SPDX-FileCopyrightText: 2014-2023 elementary, Inc. (https://elementary.io)
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 *              Oleksandr Lynok <oleksandr.lynok@gmail.com>
 */

#include "display.h"
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <granite-7.h>
#include <glib/gi18n-lib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>
#include <float.h>
#include <math.h>

#define DISPLAY_DISPLAYS_VIEW_TOUCHSCREEN_SETTINGS_PATH "org.gnome.settings-daemon.peripherals.touchscreen"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	DISPLAY_DISPLAYS_VIEW_0_PROPERTY,
	DISPLAY_DISPLAYS_VIEW_NUM_PROPERTIES
};
static GParamSpec* display_displays_view_properties[DISPLAY_DISPLAYS_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
#define _g_settings_schema_source_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_source_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _DisplayDisplaysViewPrivate {
	GtkComboBoxText* dpi_combo;
	GtkBox* rotation_lock_box;
};

struct _Block3Data {
	int _ref_count_;
	DisplayDisplaysView* self;
	GtkSwitch* mirror_switch;
	GtkBox* mirror_box;
	GtkButton* apply_button;
	DisplayMonitorManager* monitor_manager;
};

static gint DisplayDisplaysView_private_offset;
static gpointer display_displays_view_parent_class = NULL;

static void display_displays_view_show_error_dialog (DisplayDisplaysView* self,
                                              const gchar* details);
static void _gtk_window_destroy_gtk_dialog_response (GtkDialog* _sender,
                                              gint response_id,
                                              gpointer self);
static GObject * display_displays_view_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void _display_displays_view___lambda22_ (Block3Data* _data3_,
                                         gboolean changed);
static void __display_displays_view___lambda22__display_displays_overlay_configuration_changed (DisplayDisplaysOverlay* _sender,
                                                                                         gboolean changed,
                                                                                         gpointer self);
static void _display_displays_view___lambda23_ (Block3Data* _data3_);
static void __display_displays_view___lambda23__g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self);
static void _display_displays_view___lambda24_ (DisplayDisplaysView* self);
static void __display_displays_view___lambda24__gtk_button_clicked (GtkButton* _sender,
                                                             gpointer self);
static void _display_displays_view___lambda25_ (Block3Data* _data3_);
static void __display_displays_view___lambda25__gtk_button_clicked (GtkButton* _sender,
                                                             gpointer self);
static void _display_displays_view___lambda26_ (Block3Data* _data3_);
static void __display_displays_view___lambda26__gtk_combo_box_changed (GtkComboBox* _sender,
                                                                gpointer self);
static void _display_displays_view___lambda27_ (Block3Data* _data3_);
static void __display_displays_view___lambda27__g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self);
static void display_displays_view_finalize (GObject * obj);
static GType display_displays_view_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
display_displays_view_get_instance_private (DisplayDisplaysView* self)
{
	return G_STRUCT_MEMBER_P (self, DisplayDisplaysView_private_offset);
}

static void
_gtk_window_destroy_gtk_dialog_response (GtkDialog* _sender,
                                         gint response_id,
                                         gpointer self)
{
	gtk_window_destroy ((GtkWindow*) self);
}

static void
display_displays_view_show_error_dialog (DisplayDisplaysView* self,
                                         const gchar* details)
{
	GraniteMessageDialog* error_dialog = NULL;
	GraniteMessageDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (details != NULL);
	_tmp0_ = granite_message_dialog_new_with_image_from_icon_name (_ ("Failed to apply display settings"), _ ("This can be caused by an invalid configuration."), "dialog-error", GTK_BUTTONS_CLOSE);
	g_object_ref_sink (_tmp0_);
	error_dialog = _tmp0_;
	granite_message_dialog_show_error_details (error_dialog, details);
	g_signal_connect_object ((GtkDialog*) error_dialog, "response", (GCallback) _gtk_window_destroy_gtk_dialog_response, (GtkWindow*) error_dialog, 0);
	gtk_window_present ((GtkWindow*) error_dialog);
	_g_object_unref0 (error_dialog);
}

DisplayDisplaysView*
display_displays_view_construct (GType object_type)
{
	DisplayDisplaysView * self = NULL;
	self = (DisplayDisplaysView*) g_object_new (object_type, NULL);
	return self;
}

DisplayDisplaysView*
display_displays_view_new (void)
{
	return display_displays_view_construct (DISPLAY_TYPE_DISPLAYS_VIEW);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		DisplayDisplaysView* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->apply_button);
		_g_object_unref0 (_data3_->mirror_box);
		_g_object_unref0 (_data3_->mirror_switch);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static gpointer
_g_settings_schema_source_ref0 (gpointer self)
{
	return self ? g_settings_schema_source_ref (self) : NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_display_displays_view___lambda22_ (Block3Data* _data3_,
                                    gboolean changed)
{
	DisplayDisplaysView* self;
	GtkButton* _tmp0_;
	self = _data3_->self;
	_tmp0_ = _data3_->apply_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, changed);
}

static void
__display_displays_view___lambda22__display_displays_overlay_configuration_changed (DisplayDisplaysOverlay* _sender,
                                                                                    gboolean changed,
                                                                                    gpointer self)
{
	_display_displays_view___lambda22_ (self, changed);
}

static void
_display_displays_view___lambda23_ (Block3Data* _data3_)
{
	DisplayDisplaysView* self;
	GtkBox* _tmp0_;
	DisplayMonitorManager* _tmp1_;
	GeeLinkedList* _tmp2_;
	GeeLinkedList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	self = _data3_->self;
	_tmp0_ = _data3_->mirror_box;
	_tmp1_ = _data3_->monitor_manager;
	_tmp2_ = display_monitor_manager_get_monitors (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp5_ > 1);
}

static void
__display_displays_view___lambda23__g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self)
{
	_display_displays_view___lambda23_ (self);
}

static void
_display_displays_view___lambda24_ (DisplayDisplaysView* self)
{
	DisplayDisplaysOverlay* _tmp0_;
	_tmp0_ = self->displays_overlay;
	display_displays_overlay_rescan_displays (_tmp0_);
}

static void
__display_displays_view___lambda24__gtk_button_clicked (GtkButton* _sender,
                                                        gpointer self)
{
	_display_displays_view___lambda24_ ((DisplayDisplaysView*) self);
}

static void
_display_displays_view___lambda25_ (Block3Data* _data3_)
{
	DisplayDisplaysView* self;
	GtkButton* _tmp3_;
	GError* _inner_error0_ = NULL;
	self = _data3_->self;
	{
		DisplayMonitorManager* _tmp0_;
		_tmp0_ = _data3_->monitor_manager;
		display_monitor_manager_set_monitor_config (_tmp0_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		display_displays_view_show_error_dialog (self, _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp3_ = _data3_->apply_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, FALSE);
}

static void
__display_displays_view___lambda25__gtk_button_clicked (GtkButton* _sender,
                                                        gpointer self)
{
	_display_displays_view___lambda25_ (self);
}

static void
_display_displays_view___lambda26_ (Block3Data* _data3_)
{
	DisplayDisplaysView* self;
	GError* _inner_error0_ = NULL;
	self = _data3_->self;
	{
		DisplayMonitorManager* _tmp0_;
		GtkComboBoxText* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp0_ = _data3_->monitor_manager;
		_tmp1_ = self->priv->dpi_combo;
		_tmp2_ = gtk_combo_box_get_active ((GtkComboBox*) _tmp1_);
		_tmp3_ = _tmp2_;
		display_monitor_manager_set_scale_on_all_monitors (_tmp0_, (gdouble) (_tmp3_ + 1), &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		display_displays_view_show_error_dialog (self, _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
__display_displays_view___lambda26__gtk_combo_box_changed (GtkComboBox* _sender,
                                                           gpointer self)
{
	_display_displays_view___lambda26_ (self);
}

static void
_display_displays_view___lambda27_ (Block3Data* _data3_)
{
	DisplayDisplaysView* self;
	GtkSwitch* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GtkButton* _tmp5_;
	self = _data3_->self;
	_tmp0_ = _data3_->mirror_switch;
	_tmp1_ = gtk_switch_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		DisplayMonitorManager* _tmp3_;
		_tmp3_ = _data3_->monitor_manager;
		display_monitor_manager_enable_clone_mode (_tmp3_);
	} else {
		DisplayMonitorManager* _tmp4_;
		_tmp4_ = _data3_->monitor_manager;
		display_monitor_manager_disable_clone_mode (_tmp4_);
	}
	_tmp5_ = _data3_->apply_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, TRUE);
}

static void
__display_displays_view___lambda27__g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self)
{
	_display_displays_view___lambda27_ (self);
}

static GObject *
display_displays_view_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	DisplayDisplaysView * self;
	Block3Data* _data3_;
	DisplayDisplaysOverlay* _tmp0_ = NULL;
	GtkLabel* mirror_label = NULL;
	GtkLabel* _tmp1_;
	GtkSwitch* _tmp2_;
	GtkBox* _tmp3_ = NULL;
	GtkBox* _tmp4_;
	GtkLabel* _tmp5_;
	GtkBox* _tmp6_;
	GtkSwitch* _tmp7_;
	GtkLabel* dpi_label = NULL;
	GtkLabel* _tmp8_;
	GtkComboBoxText* _tmp9_;
	GtkComboBoxText* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GtkComboBoxText* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GtkComboBoxText* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GtkBox* dpi_box = NULL;
	GtkBox* _tmp19_ = NULL;
	GtkBox* _tmp20_;
	GtkLabel* _tmp21_;
	GtkBox* _tmp22_;
	GtkComboBoxText* _tmp23_;
	GtkButton* detect_button = NULL;
	GtkButton* _tmp24_;
	GtkButton* _tmp25_;
	GtkButton* _tmp26_;
	GtkButton* _tmp27_;
	GtkBox* button_box = NULL;
	GtkBox* _tmp28_ = NULL;
	GtkBox* _tmp29_;
	GtkButton* _tmp30_;
	GtkBox* _tmp31_;
	GtkButton* _tmp32_;
	GtkActionBar* action_bar = NULL;
	GtkActionBar* _tmp33_;
	GtkActionBar* _tmp34_;
	DisplayMonitorManager* _tmp35_;
	DisplayMonitorManager* _tmp36_;
	gboolean _tmp37_;
	gboolean _tmp38_;
	GtkActionBar* _tmp41_;
	GtkBox* _tmp42_;
	DisplaySensorManager* _tmp43_;
	gboolean _tmp44_;
	gboolean _tmp45_;
	GtkActionBar* _tmp65_;
	GtkBox* _tmp66_;
	GtkSeparator* _tmp67_;
	GtkSeparator* _tmp68_;
	DisplayDisplaysOverlay* _tmp69_;
	GtkActionBar* _tmp70_;
	DisplayDisplaysOverlay* _tmp71_;
	GtkBox* _tmp72_;
	DisplayMonitorManager* _tmp73_;
	GeeLinkedList* _tmp74_;
	GeeLinkedList* _tmp75_;
	gint _tmp76_;
	gint _tmp77_;
	DisplayMonitorManager* _tmp78_;
	GtkButton* _tmp79_;
	GtkButton* _tmp80_;
	GtkComboBoxText* _tmp81_;
	DisplayMonitorManager* _tmp82_;
	GeeLinkedList* _tmp83_;
	GeeLinkedList* _tmp84_;
	gpointer _tmp85_;
	DisplayVirtualMonitor* _tmp86_;
	gdouble _tmp87_;
	gdouble _tmp88_;
	GtkComboBoxText* _tmp89_;
	GtkSwitch* _tmp90_;
	DisplayMonitorManager* _tmp91_;
	gboolean _tmp92_;
	gboolean _tmp93_;
	GtkSwitch* _tmp94_;
	parent_class = G_OBJECT_CLASS (display_displays_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DISPLAY_TYPE_DISPLAYS_VIEW, DisplayDisplaysView);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = display_displays_overlay_new ();
	gtk_widget_set_vexpand ((GtkWidget*) _tmp0_, TRUE);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->displays_overlay);
	self->displays_overlay = _tmp0_;
	_tmp1_ = (GtkLabel*) gtk_label_new (_ ("Mirror Display:"));
	g_object_ref_sink (_tmp1_);
	mirror_label = _tmp1_;
	_tmp2_ = (GtkSwitch*) gtk_switch_new ();
	g_object_ref_sink (_tmp2_);
	_data3_->mirror_switch = _tmp2_;
	_tmp3_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp3_, 6);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp3_, 6);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp3_, 6);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp3_, 6);
	gtk_widget_set_valign ((GtkWidget*) _tmp3_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp3_);
	_data3_->mirror_box = _tmp3_;
	_tmp4_ = _data3_->mirror_box;
	_tmp5_ = mirror_label;
	gtk_box_append (_tmp4_, (GtkWidget*) _tmp5_);
	_tmp6_ = _data3_->mirror_box;
	_tmp7_ = _data3_->mirror_switch;
	gtk_box_append (_tmp6_, (GtkWidget*) _tmp7_);
	_tmp8_ = (GtkLabel*) gtk_label_new (_ ("Scaling factor:"));
	g_object_ref_sink (_tmp8_);
	dpi_label = _tmp8_;
	_tmp9_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->dpi_combo);
	self->priv->dpi_combo = _tmp9_;
	_tmp10_ = self->priv->dpi_combo;
	_tmp11_ = g_strconcat (_ ("LoDPI"), " (1×)", NULL);
	_tmp12_ = _tmp11_;
	gtk_combo_box_text_append_text (_tmp10_, _tmp12_);
	_g_free0 (_tmp12_);
	_tmp13_ = self->priv->dpi_combo;
	_tmp14_ = g_strconcat (_ ("HiDPI"), " (2×)", NULL);
	_tmp15_ = _tmp14_;
	gtk_combo_box_text_append_text (_tmp13_, _tmp15_);
	_g_free0 (_tmp15_);
	_tmp16_ = self->priv->dpi_combo;
	_tmp17_ = g_strconcat (_ ("HiDPI"), " (3×)", NULL);
	_tmp18_ = _tmp17_;
	gtk_combo_box_text_append_text (_tmp16_, _tmp18_);
	_g_free0 (_tmp18_);
	_tmp19_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp19_, 6);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp19_, 6);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp19_, 6);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp19_, 6);
	g_object_ref_sink (_tmp19_);
	dpi_box = _tmp19_;
	_tmp20_ = dpi_box;
	_tmp21_ = dpi_label;
	gtk_box_append (_tmp20_, (GtkWidget*) _tmp21_);
	_tmp22_ = dpi_box;
	_tmp23_ = self->priv->dpi_combo;
	gtk_box_append (_tmp22_, (GtkWidget*) _tmp23_);
	_tmp24_ = (GtkButton*) gtk_button_new_with_label (_ ("Detect Displays"));
	g_object_ref_sink (_tmp24_);
	detect_button = _tmp24_;
	_tmp25_ = (GtkButton*) gtk_button_new_with_label (_ ("Apply"));
	g_object_ref_sink (_tmp25_);
	_data3_->apply_button = _tmp25_;
	_tmp26_ = _data3_->apply_button;
	gtk_widget_add_css_class ((GtkWidget*) _tmp26_, GRANITE_STYLE_CLASS_SUGGESTED_ACTION);
	_tmp27_ = _data3_->apply_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp27_, FALSE);
	_tmp28_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	gtk_box_set_homogeneous (_tmp28_, TRUE);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp28_, 6);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp28_, 6);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp28_, 6);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp28_, 6);
	gtk_widget_set_valign ((GtkWidget*) _tmp28_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp28_);
	button_box = _tmp28_;
	_tmp29_ = button_box;
	_tmp30_ = detect_button;
	gtk_box_append (_tmp29_, (GtkWidget*) _tmp30_);
	_tmp31_ = button_box;
	_tmp32_ = _data3_->apply_button;
	gtk_box_append (_tmp31_, (GtkWidget*) _tmp32_);
	_tmp33_ = (GtkActionBar*) gtk_action_bar_new ();
	g_object_ref_sink (_tmp33_);
	action_bar = _tmp33_;
	_tmp34_ = action_bar;
	gtk_widget_add_css_class ((GtkWidget*) _tmp34_, GRANITE_STYLE_CLASS_FLAT);
	_tmp35_ = display_monitor_manager_get_default ();
	_data3_->monitor_manager = _tmp35_;
	_tmp36_ = _data3_->monitor_manager;
	_tmp37_ = display_monitor_manager_get_global_scale_required (_tmp36_);
	_tmp38_ = _tmp37_;
	if (_tmp38_) {
		GtkActionBar* _tmp39_;
		GtkBox* _tmp40_;
		_tmp39_ = action_bar;
		_tmp40_ = dpi_box;
		gtk_action_bar_pack_start (_tmp39_, (GtkWidget*) _tmp40_);
	}
	_tmp41_ = action_bar;
	_tmp42_ = _data3_->mirror_box;
	gtk_action_bar_pack_start (_tmp41_, (GtkWidget*) _tmp42_);
	_tmp43_ = display_sensor_manager_get_default ();
	_tmp44_ = display_sensor_manager_get_has_accelerometer (_tmp43_);
	_tmp45_ = _tmp44_;
	if (_tmp45_) {
		GSettingsSchemaSource* schema_source = NULL;
		GSettingsSchemaSource* _tmp46_;
		GSettingsSchemaSource* _tmp47_;
		GSettingsSchema* rotation_lock_schema = NULL;
		GSettingsSchemaSource* _tmp48_;
		GSettingsSchema* _tmp49_;
		GSettingsSchema* _tmp50_;
		_tmp46_ = g_settings_schema_source_get_default ();
		_tmp47_ = _g_settings_schema_source_ref0 (_tmp46_);
		schema_source = _tmp47_;
		_tmp48_ = schema_source;
		_tmp49_ = g_settings_schema_source_lookup (_tmp48_, DISPLAY_DISPLAYS_VIEW_TOUCHSCREEN_SETTINGS_PATH, TRUE);
		rotation_lock_schema = _tmp49_;
		_tmp50_ = rotation_lock_schema;
		if (_tmp50_ != NULL) {
			GtkSwitch* rotation_lock_switch = NULL;
			GtkSwitch* _tmp51_;
			GtkLabel* rotation_lock_label = NULL;
			GtkSwitch* _tmp52_;
			GtkWidget* _tmp53_;
			GtkLabel* _tmp54_ = NULL;
			GtkBox* _tmp55_ = NULL;
			GtkBox* _tmp56_;
			GtkLabel* _tmp57_;
			GtkBox* _tmp58_;
			GtkSwitch* _tmp59_;
			GtkActionBar* _tmp60_;
			GtkBox* _tmp61_;
			GSettings* touchscreen_settings = NULL;
			GSettings* _tmp62_;
			GSettings* _tmp63_;
			GtkSwitch* _tmp64_;
			_tmp51_ = (GtkSwitch*) gtk_switch_new ();
			g_object_ref_sink (_tmp51_);
			rotation_lock_switch = _tmp51_;
			_tmp52_ = rotation_lock_switch;
			_tmp53_ = _g_object_ref0 ((GtkWidget*) _tmp52_);
			_tmp54_ = (GtkLabel*) gtk_label_new (_ ("Rotation Lock:"));
			gtk_label_set_mnemonic_widget (_tmp54_, _tmp53_);
			_g_object_unref0 (_tmp53_);
			g_object_ref_sink (_tmp54_);
			rotation_lock_label = _tmp54_;
			_tmp55_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
			gtk_widget_set_margin_top ((GtkWidget*) _tmp55_, 6);
			gtk_widget_set_margin_end ((GtkWidget*) _tmp55_, 6);
			gtk_widget_set_margin_bottom ((GtkWidget*) _tmp55_, 6);
			gtk_widget_set_margin_start ((GtkWidget*) _tmp55_, 6);
			gtk_widget_set_valign ((GtkWidget*) _tmp55_, GTK_ALIGN_CENTER);
			g_object_ref_sink (_tmp55_);
			_g_object_unref0 (self->priv->rotation_lock_box);
			self->priv->rotation_lock_box = _tmp55_;
			_tmp56_ = self->priv->rotation_lock_box;
			_tmp57_ = rotation_lock_label;
			gtk_box_append (_tmp56_, (GtkWidget*) _tmp57_);
			_tmp58_ = self->priv->rotation_lock_box;
			_tmp59_ = rotation_lock_switch;
			gtk_box_append (_tmp58_, (GtkWidget*) _tmp59_);
			_tmp60_ = action_bar;
			_tmp61_ = self->priv->rotation_lock_box;
			gtk_action_bar_pack_start (_tmp60_, (GtkWidget*) _tmp61_);
			_tmp62_ = g_settings_new (DISPLAY_DISPLAYS_VIEW_TOUCHSCREEN_SETTINGS_PATH);
			touchscreen_settings = _tmp62_;
			_tmp63_ = touchscreen_settings;
			_tmp64_ = rotation_lock_switch;
			g_settings_bind (_tmp63_, "orientation-lock", (GObject*) _tmp64_, "active", G_SETTINGS_BIND_DEFAULT);
			_g_object_unref0 (touchscreen_settings);
			_g_object_unref0 (rotation_lock_label);
			_g_object_unref0 (rotation_lock_switch);
		} else {
			g_info ("DisplaysView.vala:103: Schema \"org.gnome.settings-daemon.peripherals." \
"touchscreen\" is not installed on your system.");
		}
		_g_settings_schema_unref0 (rotation_lock_schema);
		_g_settings_schema_source_unref0 (schema_source);
	}
	_tmp65_ = action_bar;
	_tmp66_ = button_box;
	gtk_action_bar_pack_end (_tmp65_, (GtkWidget*) _tmp66_);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	_tmp67_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp67_);
	_tmp68_ = _tmp67_;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp68_);
	_g_object_unref0 (_tmp68_);
	_tmp69_ = self->displays_overlay;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp69_);
	_tmp70_ = action_bar;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp70_);
	_tmp71_ = self->displays_overlay;
	g_signal_connect_data (_tmp71_, "configuration-changed", (GCallback) __display_displays_view___lambda22__display_displays_overlay_configuration_changed, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp72_ = _data3_->mirror_box;
	_tmp73_ = _data3_->monitor_manager;
	_tmp74_ = display_monitor_manager_get_monitors (_tmp73_);
	_tmp75_ = _tmp74_;
	_tmp76_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp75_);
	_tmp77_ = _tmp76_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp72_, _tmp77_ > 1);
	_tmp78_ = _data3_->monitor_manager;
	g_signal_connect_data ((GObject*) _tmp78_, "notify::monitor-number", (GCallback) __display_displays_view___lambda23__g_object_notify, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp79_ = detect_button;
	g_signal_connect_object (_tmp79_, "clicked", (GCallback) __display_displays_view___lambda24__gtk_button_clicked, self, 0);
	_tmp80_ = _data3_->apply_button;
	g_signal_connect_data (_tmp80_, "clicked", (GCallback) __display_displays_view___lambda25__gtk_button_clicked, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp81_ = self->priv->dpi_combo;
	_tmp82_ = _data3_->monitor_manager;
	_tmp83_ = display_monitor_manager_get_virtual_monitors (_tmp82_);
	_tmp84_ = _tmp83_;
	_tmp85_ = gee_abstract_list_get ((GeeAbstractList*) _tmp84_, 0);
	_tmp86_ = (DisplayVirtualMonitor*) _tmp85_;
	_tmp87_ = display_virtual_monitor_get_scale (_tmp86_);
	_tmp88_ = _tmp87_;
	gtk_combo_box_set_active ((GtkComboBox*) _tmp81_, ((gint) _tmp88_) - 1);
	_g_object_unref0 (_tmp86_);
	_tmp89_ = self->priv->dpi_combo;
	g_signal_connect_data ((GtkComboBox*) _tmp89_, "changed", (GCallback) __display_displays_view___lambda26__gtk_combo_box_changed, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_tmp90_ = _data3_->mirror_switch;
	_tmp91_ = _data3_->monitor_manager;
	_tmp92_ = display_monitor_manager_get_is_mirrored (_tmp91_);
	_tmp93_ = _tmp92_;
	gtk_switch_set_active (_tmp90_, _tmp93_);
	_tmp94_ = _data3_->mirror_switch;
	g_signal_connect_data ((GObject*) _tmp94_, "notify::active", (GCallback) __display_displays_view___lambda27__g_object_notify, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	_g_object_unref0 (action_bar);
	_g_object_unref0 (button_box);
	_g_object_unref0 (detect_button);
	_g_object_unref0 (dpi_box);
	_g_object_unref0 (dpi_label);
	_g_object_unref0 (mirror_label);
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return obj;
}

static void
display_displays_view_class_init (DisplayDisplaysViewClass * klass,
                                  gpointer klass_data)
{
	display_displays_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DisplayDisplaysView_private_offset);
	G_OBJECT_CLASS (klass)->constructor = display_displays_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = display_displays_view_finalize;
}

static void
display_displays_view_instance_init (DisplayDisplaysView * self,
                                     gpointer klass)
{
	self->priv = display_displays_view_get_instance_private (self);
}

static void
display_displays_view_finalize (GObject * obj)
{
	DisplayDisplaysView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DISPLAY_TYPE_DISPLAYS_VIEW, DisplayDisplaysView);
	_g_object_unref0 (self->displays_overlay);
	_g_object_unref0 (self->priv->dpi_combo);
	_g_object_unref0 (self->priv->rotation_lock_box);
	G_OBJECT_CLASS (display_displays_view_parent_class)->finalize (obj);
}

static GType
display_displays_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DisplayDisplaysViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) display_displays_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DisplayDisplaysView), 0, (GInstanceInitFunc) display_displays_view_instance_init, NULL };
	GType display_displays_view_type_id;
	display_displays_view_type_id = g_type_register_static (gtk_box_get_type (), "DisplayDisplaysView", &g_define_type_info, 0);
	DisplayDisplaysView_private_offset = g_type_add_instance_private (display_displays_view_type_id, sizeof (DisplayDisplaysViewPrivate));
	return display_displays_view_type_id;
}

GType
display_displays_view_get_type (void)
{
	static volatile gsize display_displays_view_type_id__once = 0;
	if (g_once_init_enter (&display_displays_view_type_id__once)) {
		GType display_displays_view_type_id;
		display_displays_view_type_id = display_displays_view_get_type_once ();
		g_once_init_leave (&display_displays_view_type_id__once, display_displays_view_type_id);
	}
	return display_displays_view_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

