/* rygel-http-item-uri.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from rygel-http-item-uri.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Authors: Jens Georg <mail@jensge.org>
 *          Zeeshan Ali (Khattak) <zeeshan.ali@nokia.com>
 *                                <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-server.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include "rygel-core.h"
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <libgupnp/gupnp.h>
#include <libgssdp/gssdp.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	RYGEL_HTTP_ITEM_URI_0_PROPERTY,
	RYGEL_HTTP_ITEM_URI_ITEM_ID_PROPERTY,
	RYGEL_HTTP_ITEM_URI_THUMBNAIL_INDEX_PROPERTY,
	RYGEL_HTTP_ITEM_URI_SUBTITLE_INDEX_PROPERTY,
	RYGEL_HTTP_ITEM_URI_RESOURCE_NAME_PROPERTY,
	RYGEL_HTTP_ITEM_URI_HTTP_SERVER_PROPERTY,
	RYGEL_HTTP_ITEM_URI_EXTENSION_PROPERTY,
	RYGEL_HTTP_ITEM_URI_NUM_PROPERTIES
};
static GParamSpec* rygel_http_item_uri_properties[RYGEL_HTTP_ITEM_URI_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))
#define _rygel_subtitle_unref0(var) ((var == NULL) ? NULL : (var = (rygel_subtitle_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _RygelHTTPItemURIPrivate {
	gchar* _item_id;
	gint _thumbnail_index;
	gint _subtitle_index;
	gchar* _resource_name;
	RygelHTTPServer* _http_server;
	gchar* real_extension;
};

static gint RygelHTTPItemURI_private_offset;
static gpointer rygel_http_item_uri_parent_class = NULL;
GeeHashMap* rygel_http_item_uri_mime_to_ext = NULL;

static gchar* rygel_http_item_uri_ext_from_mime_type (RygelHTTPItemURI* self,
                                               const gchar* mime_type);
static gchar* rygel_http_item_uri_base64_urlencode (RygelHTTPItemURI* self,
                                             const gchar* data);
static guchar* rygel_http_item_uri_base64_urldecode (RygelHTTPItemURI* self,
                                              const gchar* data,
                                              gint* result_length1);
static gchar* rygel_http_item_uri_create_uri_for_path (RygelHTTPItemURI* self,
                                                const gchar* path);
static void rygel_http_item_uri_finalize (GObject * obj);
static GType rygel_http_item_uri_get_type_once (void);
static void _vala_rygel_http_item_uri_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_rygel_http_item_uri_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
rygel_http_item_uri_get_instance_private (RygelHTTPItemURI* self)
{
	return G_STRUCT_MEMBER_P (self, RygelHTTPItemURI_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_rygel_icon_info_ref0 (gpointer self)
{
	return self ? rygel_icon_info_ref (self) : NULL;
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

RygelHTTPItemURI*
rygel_http_item_uri_construct (GType object_type,
                               RygelMediaObject* object,
                               RygelHTTPServer* http_server,
                               gint thumbnail_index,
                               gint subtitle_index,
                               const gchar* resource_name)
{
	RygelHTTPItemURI * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	RygelMediaFileItem* item = NULL;
	RygelMediaFileItem* _tmp9_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gboolean _tmp45_;
	g_return_val_if_fail (object != NULL, NULL);
	g_return_val_if_fail (http_server != NULL, NULL);
	self = (RygelHTTPItemURI*) g_object_new (object_type, NULL);
	_tmp0_ = rygel_media_object_get_id (object);
	_tmp1_ = _tmp0_;
	rygel_http_item_uri_set_item_id (self, _tmp1_);
	rygel_http_item_uri_set_thumbnail_index (self, thumbnail_index);
	rygel_http_item_uri_set_subtitle_index (self, subtitle_index);
	rygel_http_item_uri_set_http_server (self, http_server);
	rygel_http_item_uri_set_resource_name (self, resource_name);
	rygel_http_item_uri_set_extension (self, "");
	_tmp2_ = self->priv->_resource_name;
	if (_tmp2_ != NULL) {
		RygelMediaResource* resource = NULL;
		const gchar* _tmp3_;
		RygelMediaResource* _tmp4_;
		RygelMediaResource* _tmp5_;
		_tmp3_ = self->priv->_resource_name;
		_tmp4_ = rygel_media_object_get_resource_by_name (object, _tmp3_);
		resource = _tmp4_;
		_tmp5_ = resource;
		if (_tmp5_ != NULL) {
			RygelMediaResource* _tmp6_;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			_tmp6_ = resource;
			_tmp7_ = rygel_media_resource_get_extension (_tmp6_);
			_tmp8_ = _tmp7_;
			rygel_http_item_uri_set_extension (self, _tmp8_);
		}
		_g_object_unref0 (resource);
		return self;
	} else {
		if (!RYGEL_IS_MEDIA_FILE_ITEM (object)) {
			return self;
		}
	}
	_tmp9_ = _g_object_ref0 (RYGEL_IS_MEDIA_FILE_ITEM (object) ? ((RygelMediaFileItem*) object) : NULL);
	item = _tmp9_;
	if (thumbnail_index > -1) {
		RygelMediaFileItem* _tmp10_;
		_tmp10_ = item;
		if (RYGEL_IS_VISUAL_ITEM (_tmp10_)) {
			GeeArrayList* thumbnails = NULL;
			RygelMediaFileItem* _tmp11_;
			GeeArrayList* _tmp12_;
			GeeArrayList* _tmp13_;
			GeeArrayList* _tmp14_;
			GeeArrayList* _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			_tmp11_ = item;
			_tmp12_ = rygel_visual_item_get_thumbnails (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, RYGEL_TYPE_VISUAL_ITEM, RygelVisualItem));
			_tmp13_ = _tmp12_;
			_tmp14_ = _g_object_ref0 (_tmp13_);
			thumbnails = _tmp14_;
			_tmp15_ = thumbnails;
			_tmp16_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp15_);
			_tmp17_ = _tmp16_;
			if (_tmp17_ > thumbnail_index) {
				GeeArrayList* _tmp18_;
				gpointer _tmp19_;
				RygelThumbnail* _tmp20_;
				const gchar* _tmp21_;
				_tmp18_ = thumbnails;
				_tmp19_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, thumbnail_index);
				_tmp20_ = (RygelThumbnail*) _tmp19_;
				_tmp21_ = ((RygelIconInfo*) _tmp20_)->file_extension;
				rygel_http_item_uri_set_extension (self, _tmp21_);
				_rygel_icon_info_unref0 (_tmp20_);
			}
			_g_object_unref0 (thumbnails);
		} else {
			RygelMediaFileItem* _tmp22_;
			_tmp22_ = item;
			if (RYGEL_IS_MUSIC_ITEM (_tmp22_)) {
				RygelThumbnail* album_art = NULL;
				RygelMediaFileItem* _tmp23_;
				RygelThumbnail* _tmp24_;
				RygelThumbnail* _tmp25_;
				RygelThumbnail* _tmp26_;
				RygelThumbnail* _tmp27_;
				_tmp23_ = item;
				_tmp24_ = rygel_music_item_get_album_art (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem));
				_tmp25_ = _tmp24_;
				_tmp26_ = _rygel_icon_info_ref0 (_tmp25_);
				album_art = _tmp26_;
				_tmp27_ = album_art;
				if (_tmp27_ != NULL) {
					RygelThumbnail* _tmp28_;
					const gchar* _tmp29_;
					_tmp28_ = album_art;
					_tmp29_ = ((RygelIconInfo*) _tmp28_)->file_extension;
					rygel_http_item_uri_set_extension (self, _tmp29_);
				}
				_rygel_icon_info_unref0 (album_art);
			}
		}
	} else {
		if (subtitle_index > -1) {
			RygelMediaFileItem* _tmp30_;
			_tmp30_ = item;
			if (RYGEL_IS_VIDEO_ITEM (_tmp30_)) {
				GeeArrayList* subtitles = NULL;
				RygelMediaFileItem* _tmp31_;
				GeeArrayList* _tmp32_;
				GeeArrayList* _tmp33_;
				GeeArrayList* _tmp34_;
				GeeArrayList* _tmp35_;
				gint _tmp36_;
				gint _tmp37_;
				_tmp31_ = item;
				_tmp32_ = rygel_video_item_get_subtitles (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, RYGEL_TYPE_VIDEO_ITEM, RygelVideoItem));
				_tmp33_ = _tmp32_;
				_tmp34_ = _g_object_ref0 (_tmp33_);
				subtitles = _tmp34_;
				_tmp35_ = subtitles;
				_tmp36_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp35_);
				_tmp37_ = _tmp36_;
				if (_tmp37_ > subtitle_index) {
					GeeArrayList* _tmp38_;
					gpointer _tmp39_;
					RygelSubtitle* _tmp40_;
					const gchar* _tmp41_;
					_tmp38_ = subtitles;
					_tmp39_ = gee_abstract_list_get ((GeeAbstractList*) _tmp38_, subtitle_index);
					_tmp40_ = (RygelSubtitle*) _tmp39_;
					_tmp41_ = _tmp40_->caption_type;
					rygel_http_item_uri_set_extension (self, _tmp41_);
					_rygel_subtitle_unref0 (_tmp40_);
				}
				_g_object_unref0 (subtitles);
			}
		}
	}
	_tmp42_ = rygel_http_item_uri_get_extension (self);
	_tmp43_ = _tmp42_;
	_tmp44_ = _tmp43_;
	_tmp45_ = g_strcmp0 (_tmp44_, "") == 0;
	_g_free0 (_tmp44_);
	if (_tmp45_) {
		gchar* uri_extension = NULL;
		gchar* _tmp46_;
		const gchar* _tmp61_;
		_tmp46_ = g_strdup ("");
		uri_extension = _tmp46_;
		{
			GeeList* _uri_string_list = NULL;
			RygelMediaFileItem* _tmp47_;
			GeeList* _tmp48_;
			gint _uri_string_size = 0;
			GeeList* _tmp49_;
			gint _tmp50_;
			gint _tmp51_;
			gint _uri_string_index = 0;
			_tmp47_ = item;
			_tmp48_ = rygel_media_object_get_uris ((RygelMediaObject*) _tmp47_);
			_uri_string_list = _tmp48_;
			_tmp49_ = _uri_string_list;
			_tmp50_ = gee_collection_get_size ((GeeCollection*) _tmp49_);
			_tmp51_ = _tmp50_;
			_uri_string_size = _tmp51_;
			_uri_string_index = -1;
			while (TRUE) {
				gint _tmp52_;
				gint _tmp53_;
				gchar* uri_string = NULL;
				GeeList* _tmp54_;
				gpointer _tmp55_;
				gchar* basename = NULL;
				const gchar* _tmp56_;
				gchar* _tmp57_;
				gint dot_index = 0;
				const gchar* _tmp58_;
				_uri_string_index = _uri_string_index + 1;
				_tmp52_ = _uri_string_index;
				_tmp53_ = _uri_string_size;
				if (!(_tmp52_ < _tmp53_)) {
					break;
				}
				_tmp54_ = _uri_string_list;
				_tmp55_ = gee_list_get (_tmp54_, _uri_string_index);
				uri_string = (gchar*) _tmp55_;
				_tmp56_ = uri_string;
				_tmp57_ = g_path_get_basename (_tmp56_);
				basename = _tmp57_;
				_tmp58_ = basename;
				dot_index = string_last_index_of (_tmp58_, ".", 0);
				if (dot_index > -1) {
					const gchar* _tmp59_;
					gchar* _tmp60_;
					_tmp59_ = basename;
					_tmp60_ = string_substring (_tmp59_, (glong) (dot_index + 1), (glong) -1);
					_g_free0 (uri_extension);
					uri_extension = _tmp60_;
					_g_free0 (basename);
					_g_free0 (uri_string);
					break;
				}
				_g_free0 (basename);
				_g_free0 (uri_string);
			}
			_g_object_unref0 (_uri_string_list);
		}
		_tmp61_ = uri_extension;
		if (g_strcmp0 (_tmp61_, "") == 0) {
			RygelMediaFileItem* _tmp62_;
			const gchar* _tmp63_;
			const gchar* _tmp64_;
			gchar* _tmp65_;
			gchar* _tmp66_;
			_tmp62_ = item;
			_tmp63_ = rygel_media_file_item_get_mime_type (_tmp62_);
			_tmp64_ = _tmp63_;
			_tmp65_ = rygel_http_item_uri_ext_from_mime_type (self, _tmp64_);
			_tmp66_ = _tmp65_;
			rygel_http_item_uri_set_extension (self, _tmp66_);
			_g_free0 (_tmp66_);
		} else {
			const gchar* _tmp67_;
			_tmp67_ = uri_extension;
			rygel_http_item_uri_set_extension (self, _tmp67_);
		}
		_g_free0 (uri_extension);
	}
	_g_object_unref0 (item);
	return self;
}

RygelHTTPItemURI*
rygel_http_item_uri_new (RygelMediaObject* object,
                         RygelHTTPServer* http_server,
                         gint thumbnail_index,
                         gint subtitle_index,
                         const gchar* resource_name)
{
	return rygel_http_item_uri_construct (RYGEL_TYPE_HTTP_ITEM_URI, object, http_server, thumbnail_index, subtitle_index, resource_name);
}

static gchar*
string_to_utf8 (const gchar* self,
                gint* result_length1)
{
	gint string_length = 0;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _result_ = NULL;
	gchar* _tmp2_;
	gint _result__length1;
	gint __result__size_;
	gint _tmp3_;
	gchar* _tmp4_;
	gint _tmp4__length1;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = _tmp1_;
	_tmp2_ = g_new0 (gchar, string_length + 1);
	_result_ = _tmp2_;
	_result__length1 = string_length + 1;
	__result__size_ = _result__length1;
	_tmp3_ = _result__length1;
	_result__length1 = _tmp3_ - 1;
	memcpy (_result_, self, (gsize) string_length);
	_tmp4_ = _result_;
	_tmp4__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
rygel_http_item_uri_base64_urlencode (RygelHTTPItemURI* self,
                                      const gchar* data)
{
	gchar* enc64 = NULL;
	gint _tmp0_ = 0;
	gchar* _tmp1_;
	guchar* _tmp2_;
	gint _tmp2__length1;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	_tmp1_ = string_to_utf8 (data, &_tmp0_);
	_tmp2_ = (guchar*) _tmp1_;
	_tmp2__length1 = (_tmp0_ * sizeof (gchar)) / sizeof (guchar);
	_tmp3_ = g_base64_encode (_tmp2_, (gint) ((_tmp0_ * sizeof (gchar)) / sizeof (guchar)));
	_tmp4_ = _tmp3_;
	_tmp2_ = (g_free (_tmp2_), NULL);
	enc64 = _tmp4_;
	_tmp5_ = enc64;
	_tmp6_ = string_replace (_tmp5_, "/", "_");
	_g_free0 (enc64);
	enc64 = _tmp6_;
	_tmp7_ = enc64;
	_tmp8_ = string_replace (_tmp7_, "+", "-");
	result = _tmp8_;
	_g_free0 (enc64);
	return result;
}

static guchar*
rygel_http_item_uri_base64_urldecode (RygelHTTPItemURI* self,
                                      const gchar* data,
                                      gint* result_length1)
{
	gchar* dec64 = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gsize _tmp4_ = 0;
	guchar* _tmp5_;
	guchar* _tmp6_;
	gint _tmp6__length1;
	guchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = string_replace (data, "_", "/");
	dec64 = _tmp0_;
	_tmp1_ = dec64;
	_tmp2_ = string_replace (_tmp1_, "-", "+");
	_g_free0 (dec64);
	dec64 = _tmp2_;
	_tmp3_ = dec64;
	_tmp5_ = g_base64_decode (_tmp3_, &_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp4_;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	_g_free0 (dec64);
	return result;
}

RygelHTTPItemURI*
rygel_http_item_uri_construct_from_string (GType object_type,
                                           const gchar* uri,
                                           RygelHTTPServer* http_server,
                                           GError** error)
{
	RygelHTTPItemURI * self = NULL;
	gchar* request_uri = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** parts = NULL;
	const gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint parts_length1;
	gint _parts_size_;
	gboolean _tmp6_ = FALSE;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar* last_part = NULL;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar** _tmp12_;
	gint _tmp12__length1;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gint dot_index = 0;
	const gchar* _tmp15_;
	const gchar* _tmp50_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (http_server != NULL, NULL);
	self = (RygelHTTPItemURI*) g_object_new (object_type, NULL);
	rygel_http_item_uri_set_thumbnail_index (self, -1);
	rygel_http_item_uri_set_subtitle_index (self, -1);
	rygel_http_item_uri_set_http_server (self, http_server);
	rygel_http_item_uri_set_extension (self, "");
	_tmp0_ = rygel_http_server_get_path_root (http_server);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_replace (uri, _tmp1_, "");
	request_uri = _tmp2_;
	_tmp3_ = request_uri;
	_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, "/", 0);
	parts = _tmp5_;
	parts_length1 = _vala_array_length (_tmp4_);
	_parts_size_ = parts_length1;
	_tmp7_ = parts;
	_tmp7__length1 = parts_length1;
	if (_tmp7__length1 < 2) {
		_tmp6_ = TRUE;
	} else {
		gchar** _tmp8_;
		gint _tmp8__length1;
		_tmp8_ = parts;
		_tmp8__length1 = parts_length1;
		_tmp6_ = (_tmp8__length1 % 2) == 0;
	}
	if (_tmp6_) {
		const gchar* _tmp9_;
		GError* _tmp10_;
		_tmp9_ = request_uri;
		_tmp10_ = g_error_new (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST, _ ("Invalid URI “%s”"), _tmp9_);
		_inner_error0_ = _tmp10_;
		if (_inner_error0_->domain == RYGEL_HTTP_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error0_);
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (request_uri);
			_g_object_unref0 (self);
			return NULL;
		} else {
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (request_uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp11_ = parts;
	_tmp11__length1 = parts_length1;
	_tmp12_ = parts;
	_tmp12__length1 = parts_length1;
	_tmp13_ = _tmp11_[_tmp12__length1 - 1];
	_tmp14_ = g_strdup (_tmp13_);
	last_part = _tmp14_;
	_tmp15_ = last_part;
	dot_index = string_last_index_of (_tmp15_, ".", 0);
	if (dot_index > -1) {
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar** _tmp19_;
		gint _tmp19__length1;
		gchar** _tmp20_;
		gint _tmp20__length1;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp16_ = last_part;
		_tmp17_ = string_substring (_tmp16_, (glong) (dot_index + 1), (glong) -1);
		_tmp18_ = _tmp17_;
		rygel_http_item_uri_set_extension (self, _tmp18_);
		_g_free0 (_tmp18_);
		_tmp19_ = parts;
		_tmp19__length1 = parts_length1;
		_tmp20_ = parts;
		_tmp20__length1 = parts_length1;
		_tmp21_ = last_part;
		_tmp22_ = string_substring (_tmp21_, (glong) 0, (glong) dot_index);
		_g_free0 (_tmp19_[_tmp20__length1 - 1]);
		_tmp19_[_tmp20__length1 - 1] = _tmp22_;
	}
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp23_ = FALSE;
			_tmp23_ = TRUE;
			while (TRUE) {
				gchar** _tmp24_;
				gint _tmp24__length1;
				gchar** _tmp25_;
				gint _tmp25__length1;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				GQuark _tmp29_ = 0U;
				static GQuark _tmp28_label0 = 0;
				static GQuark _tmp28_label1 = 0;
				static GQuark _tmp28_label2 = 0;
				static GQuark _tmp28_label3 = 0;
				if (!_tmp23_) {
					i += 2;
				}
				_tmp23_ = FALSE;
				_tmp24_ = parts;
				_tmp24__length1 = parts_length1;
				if (!(i < (_tmp24__length1 - 1))) {
					break;
				}
				_tmp25_ = parts;
				_tmp25__length1 = parts_length1;
				_tmp26_ = _tmp25_[i];
				_tmp27_ = _tmp26_;
				_tmp29_ = (NULL == _tmp27_) ? 0 : g_quark_from_string (_tmp27_);
				if (_tmp29_ == ((0 != _tmp28_label0) ? _tmp28_label0 : (_tmp28_label0 = g_quark_from_static_string ("i")))) {
					switch (0) {
						default:
						{
							guchar* data = NULL;
							gchar** _tmp30_;
							gint _tmp30__length1;
							const gchar* _tmp31_;
							gchar* _tmp32_;
							gchar* _tmp33_;
							gint _tmp34_ = 0;
							guchar* _tmp35_;
							guchar* _tmp36_;
							gint _tmp36__length1;
							gint data_length1;
							gint _data_size_;
							GString* builder = NULL;
							GString* _tmp37_;
							GString* _tmp38_;
							guchar* _tmp39_;
							gint _tmp39__length1;
							GString* _tmp40_;
							const gchar* _tmp41_;
							_tmp30_ = parts;
							_tmp30__length1 = parts_length1;
							_tmp31_ = _tmp30_[i + 1];
							_tmp32_ = g_uri_unescape_string (_tmp31_, NULL);
							_tmp33_ = _tmp32_;
							_tmp35_ = rygel_http_item_uri_base64_urldecode (self, _tmp33_, &_tmp34_);
							_tmp36_ = _tmp35_;
							_tmp36__length1 = _tmp34_;
							_g_free0 (_tmp33_);
							data = _tmp36_;
							data_length1 = _tmp36__length1;
							_data_size_ = data_length1;
							_tmp37_ = g_string_new ("");
							builder = _tmp37_;
							_tmp38_ = builder;
							_tmp39_ = data;
							_tmp39__length1 = data_length1;
							g_string_append (_tmp38_, (const gchar*) _tmp39_);
							_tmp40_ = builder;
							_tmp41_ = _tmp40_->str;
							rygel_http_item_uri_set_item_id (self, _tmp41_);
							_g_string_free0 (builder);
							data = (g_free (data), NULL);
							break;
						}
					}
				} else if (_tmp29_ == ((0 != _tmp28_label1) ? _tmp28_label1 : (_tmp28_label1 = g_quark_from_static_string ("th")))) {
					switch (0) {
						default:
						{
							gchar** _tmp42_;
							gint _tmp42__length1;
							const gchar* _tmp43_;
							_tmp42_ = parts;
							_tmp42__length1 = parts_length1;
							_tmp43_ = _tmp42_[i + 1];
							rygel_http_item_uri_set_thumbnail_index (self, atoi (_tmp43_));
							break;
						}
					}
				} else if (_tmp29_ == ((0 != _tmp28_label2) ? _tmp28_label2 : (_tmp28_label2 = g_quark_from_static_string ("sub")))) {
					switch (0) {
						default:
						{
							gchar** _tmp44_;
							gint _tmp44__length1;
							const gchar* _tmp45_;
							_tmp44_ = parts;
							_tmp44__length1 = parts_length1;
							_tmp45_ = _tmp44_[i + 1];
							rygel_http_item_uri_set_subtitle_index (self, atoi (_tmp45_));
							break;
						}
					}
				} else if (_tmp29_ == ((0 != _tmp28_label3) ? _tmp28_label3 : (_tmp28_label3 = g_quark_from_static_string ("res")))) {
					switch (0) {
						default:
						{
							gchar** _tmp46_;
							gint _tmp46__length1;
							const gchar* _tmp47_;
							gchar* _tmp48_;
							gchar* _tmp49_;
							_tmp46_ = parts;
							_tmp46__length1 = parts_length1;
							_tmp47_ = _tmp46_[i + 1];
							_tmp48_ = g_uri_unescape_string (_tmp47_, NULL);
							_tmp49_ = _tmp48_;
							rygel_http_item_uri_set_resource_name (self, _tmp49_);
							_g_free0 (_tmp49_);
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							break;
						}
					}
				}
			}
		}
	}
	_tmp50_ = self->priv->_item_id;
	if (_tmp50_ == NULL) {
		GError* _tmp51_;
		_tmp51_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, _ ("Not found"));
		_inner_error0_ = _tmp51_;
		if (_inner_error0_->domain == RYGEL_HTTP_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (last_part);
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (request_uri);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (last_part);
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (request_uri);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_g_free0 (last_part);
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (request_uri);
	return self;
}

RygelHTTPItemURI*
rygel_http_item_uri_new_from_string (const gchar* uri,
                                     RygelHTTPServer* http_server,
                                     GError** error)
{
	return rygel_http_item_uri_construct_from_string (RYGEL_TYPE_HTTP_ITEM_URI, uri, http_server, error);
}

gchar*
rygel_http_item_uri_to_string (RygelHTTPItemURI* self)
{
	gchar* data = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* escaped = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* path = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gint _tmp6_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_item_id;
	_tmp1_ = rygel_http_item_uri_base64_urlencode (self, _tmp0_);
	data = _tmp1_;
	_tmp2_ = data;
	_tmp3_ = g_uri_escape_string (_tmp2_, "", TRUE);
	escaped = _tmp3_;
	_tmp4_ = escaped;
	_tmp5_ = g_strconcat ("/i/", _tmp4_, NULL);
	path = _tmp5_;
	_tmp6_ = self->priv->_thumbnail_index;
	if (_tmp6_ >= 0) {
		const gchar* _tmp7_;
		gint _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp7_ = path;
		_tmp8_ = self->priv->_thumbnail_index;
		_tmp9_ = g_strdup_printf ("%i", _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat ("/th/", _tmp10_, NULL);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strconcat (_tmp7_, _tmp12_, NULL);
		_g_free0 (path);
		path = _tmp13_;
		_g_free0 (_tmp12_);
		_g_free0 (_tmp10_);
	} else {
		gint _tmp14_;
		_tmp14_ = self->priv->_subtitle_index;
		if (_tmp14_ >= 0) {
			const gchar* _tmp15_;
			gint _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			_tmp15_ = path;
			_tmp16_ = self->priv->_subtitle_index;
			_tmp17_ = g_strdup_printf ("%i", _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strconcat ("/sub/", _tmp18_, NULL);
			_tmp20_ = _tmp19_;
			_tmp21_ = g_strconcat (_tmp15_, _tmp20_, NULL);
			_g_free0 (path);
			path = _tmp21_;
			_g_free0 (_tmp20_);
			_g_free0 (_tmp18_);
		} else {
			const gchar* _tmp22_;
			_tmp22_ = self->priv->_resource_name;
			if (_tmp22_ != NULL) {
				const gchar* _tmp23_;
				const gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				_tmp23_ = path;
				_tmp24_ = self->priv->_resource_name;
				_tmp25_ = g_uri_escape_string (_tmp24_, "", TRUE);
				_tmp26_ = _tmp25_;
				_tmp27_ = g_strconcat ("/res/", _tmp26_, NULL);
				_tmp28_ = _tmp27_;
				_tmp29_ = g_strconcat (_tmp23_, _tmp28_, NULL);
				_g_free0 (path);
				path = _tmp29_;
				_g_free0 (_tmp28_);
				_g_free0 (_tmp26_);
			}
		}
	}
	_tmp30_ = path;
	_tmp31_ = rygel_http_item_uri_get_extension (self);
	_tmp32_ = _tmp31_;
	_tmp33_ = _tmp32_;
	_tmp34_ = g_strconcat (_tmp30_, _tmp33_, NULL);
	_g_free0 (path);
	path = _tmp34_;
	_g_free0 (_tmp33_);
	_tmp35_ = path;
	_tmp36_ = rygel_http_item_uri_create_uri_for_path (self, _tmp35_);
	result = _tmp36_;
	_g_free0 (path);
	_g_free0 (escaped);
	_g_free0 (data);
	return result;
}

static gchar*
rygel_http_item_uri_create_uri_for_path (RygelHTTPItemURI* self,
                                         const gchar* path)
{
	GInetAddress* addr = NULL;
	RygelHTTPServer* _tmp0_;
	GUPnPContext* _tmp1_;
	GInetAddress* _tmp2_;
	GInetAddress* _tmp3_;
	GSocketFamily _tmp4_;
	GSocketFamily _tmp5_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = self->priv->_http_server;
	_tmp1_ = _tmp0_->context;
	_tmp2_ = gssdp_client_get_address ((GSSDPClient*) _tmp1_);
	addr = _tmp2_;
	_tmp3_ = addr;
	_tmp4_ = g_inet_address_get_family (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == G_SOCKET_FAMILY_IPV6) {
		GInetAddress* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		RygelHTTPServer* _tmp9_;
		GUPnPContext* _tmp10_;
		guint _tmp11_;
		guint _tmp12_;
		RygelHTTPServer* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp6_ = addr;
		_tmp7_ = g_inet_address_to_string (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = self->priv->_http_server;
		_tmp10_ = _tmp9_->context;
		_tmp11_ = gssdp_client_get_port ((GSSDPClient*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = self->priv->_http_server;
		_tmp14_ = rygel_http_server_get_path_root (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strdup_printf ("http://[%s]:%u%s%s", _tmp8_, _tmp12_, _tmp15_, path);
		_tmp17_ = _tmp16_;
		_g_free0 (_tmp8_);
		result = _tmp17_;
		_g_object_unref0 (addr);
		return result;
	} else {
		GInetAddress* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		RygelHTTPServer* _tmp21_;
		GUPnPContext* _tmp22_;
		guint _tmp23_;
		guint _tmp24_;
		RygelHTTPServer* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		_tmp18_ = addr;
		_tmp19_ = g_inet_address_to_string (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = self->priv->_http_server;
		_tmp22_ = _tmp21_->context;
		_tmp23_ = gssdp_client_get_port ((GSSDPClient*) _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = self->priv->_http_server;
		_tmp26_ = rygel_http_server_get_path_root (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strdup_printf ("http://%s:%u%s%s", _tmp20_, _tmp24_, _tmp27_, path);
		_tmp29_ = _tmp28_;
		_g_free0 (_tmp20_);
		result = _tmp29_;
		_g_object_unref0 (addr);
		return result;
	}
}

static gchar*
rygel_http_item_uri_ext_from_mime_type (RygelHTTPItemURI* self,
                                        const gchar* mime_type)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp29_;
	gchar* _tmp32_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (mime_type != NULL, NULL);
	_tmp0_ = rygel_http_item_uri_mime_to_ext;
	if (_tmp0_ == NULL) {
		GeeHashMap* _tmp1_;
		gchar** videos = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar** _tmp5_;
		gint videos_length1;
		gint _videos_size_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		GeeHashMap* _tmp13_;
		GeeHashMap* _tmp14_;
		GeeHashMap* _tmp15_;
		gchar** images = NULL;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar** _tmp18_;
		gint images_length1;
		gint _images_size_;
		gchar** _tmp19_;
		gint _tmp19__length1;
		GeeHashMap* _tmp26_;
		GeeHashMap* _tmp27_;
		GeeHashMap* _tmp28_;
		_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (rygel_http_item_uri_mime_to_ext);
		rygel_http_item_uri_mime_to_ext = _tmp1_;
		_tmp2_ = g_strdup ("mpeg");
		_tmp3_ = g_strdup ("webm");
		_tmp4_ = g_strdup ("ogg");
		_tmp5_ = g_new0 (gchar*, 3 + 1);
		_tmp5_[0] = _tmp2_;
		_tmp5_[1] = _tmp3_;
		_tmp5_[2] = _tmp4_;
		videos = _tmp5_;
		videos_length1 = 3;
		_videos_size_ = videos_length1;
		_tmp6_ = videos;
		_tmp6__length1 = videos_length1;
		{
			gchar** video_collection = NULL;
			gint video_collection_length1 = 0;
			gint _video_collection_size_ = 0;
			gint video_it = 0;
			video_collection = _tmp6_;
			video_collection_length1 = _tmp6__length1;
			for (video_it = 0; video_it < video_collection_length1; video_it = video_it + 1) {
				gchar* _tmp7_;
				gchar* video = NULL;
				_tmp7_ = g_strdup (video_collection[video_it]);
				video = _tmp7_;
				{
					GeeHashMap* _tmp8_;
					const gchar* _tmp9_;
					gchar* _tmp10_;
					gchar* _tmp11_;
					const gchar* _tmp12_;
					_tmp8_ = rygel_http_item_uri_mime_to_ext;
					_tmp9_ = video;
					_tmp10_ = g_strconcat ("video/", _tmp9_, NULL);
					_tmp11_ = _tmp10_;
					_tmp12_ = video;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp8_, _tmp11_, _tmp12_);
					_g_free0 (_tmp11_);
					_g_free0 (video);
				}
			}
		}
		_tmp13_ = rygel_http_item_uri_mime_to_ext;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp13_, "video/x-matroska", "mkv");
		_tmp14_ = rygel_http_item_uri_mime_to_ext;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp14_, "audio/x-wav", "wav");
		_tmp15_ = rygel_http_item_uri_mime_to_ext;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, "audio/x-matroska", "mka");
		_tmp16_ = g_strdup ("jpeg");
		_tmp17_ = g_strdup ("png");
		_tmp18_ = g_new0 (gchar*, 2 + 1);
		_tmp18_[0] = _tmp16_;
		_tmp18_[1] = _tmp17_;
		images = _tmp18_;
		images_length1 = 2;
		_images_size_ = images_length1;
		_tmp19_ = images;
		_tmp19__length1 = images_length1;
		{
			gchar** image_collection = NULL;
			gint image_collection_length1 = 0;
			gint _image_collection_size_ = 0;
			gint image_it = 0;
			image_collection = _tmp19_;
			image_collection_length1 = _tmp19__length1;
			for (image_it = 0; image_it < image_collection_length1; image_it = image_it + 1) {
				gchar* _tmp20_;
				gchar* image = NULL;
				_tmp20_ = g_strdup (image_collection[image_it]);
				image = _tmp20_;
				{
					GeeHashMap* _tmp21_;
					const gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					const gchar* _tmp25_;
					_tmp21_ = rygel_http_item_uri_mime_to_ext;
					_tmp22_ = image;
					_tmp23_ = g_strconcat ("image/", _tmp22_, NULL);
					_tmp24_ = _tmp23_;
					_tmp25_ = image;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp21_, _tmp24_, _tmp25_);
					_g_free0 (_tmp24_);
					_g_free0 (image);
				}
			}
		}
		_tmp26_ = rygel_http_item_uri_mime_to_ext;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp26_, "text/srt", "srt");
		_tmp27_ = rygel_http_item_uri_mime_to_ext;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp27_, "text/xml", "xml");
		_tmp28_ = rygel_http_item_uri_mime_to_ext;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp28_, "application/ogg", "ogg");
		images = (_vala_array_free (images, images_length1, (GDestroyNotify) g_free), NULL);
		videos = (_vala_array_free (videos, videos_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp29_ = rygel_http_item_uri_mime_to_ext;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp29_, mime_type)) {
		GeeHashMap* _tmp30_;
		gpointer _tmp31_;
		_tmp30_ = rygel_http_item_uri_mime_to_ext;
		_tmp31_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp30_, mime_type);
		result = (gchar*) _tmp31_;
		return result;
	}
	_tmp32_ = g_strdup ("");
	result = _tmp32_;
	return result;
}

const gchar*
rygel_http_item_uri_get_item_id (RygelHTTPItemURI* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_item_id;
	result = _tmp0_;
	return result;
}

void
rygel_http_item_uri_set_item_id (RygelHTTPItemURI* self,
                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_http_item_uri_get_item_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_item_id);
		self->priv->_item_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_http_item_uri_properties[RYGEL_HTTP_ITEM_URI_ITEM_ID_PROPERTY]);
	}
}

gint
rygel_http_item_uri_get_thumbnail_index (RygelHTTPItemURI* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_thumbnail_index;
	return result;
}

void
rygel_http_item_uri_set_thumbnail_index (RygelHTTPItemURI* self,
                                         gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_http_item_uri_get_thumbnail_index (self);
	if (old_value != value) {
		self->priv->_thumbnail_index = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_http_item_uri_properties[RYGEL_HTTP_ITEM_URI_THUMBNAIL_INDEX_PROPERTY]);
	}
}

gint
rygel_http_item_uri_get_subtitle_index (RygelHTTPItemURI* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_subtitle_index;
	return result;
}

void
rygel_http_item_uri_set_subtitle_index (RygelHTTPItemURI* self,
                                        gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_http_item_uri_get_subtitle_index (self);
	if (old_value != value) {
		self->priv->_subtitle_index = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_http_item_uri_properties[RYGEL_HTTP_ITEM_URI_SUBTITLE_INDEX_PROPERTY]);
	}
}

const gchar*
rygel_http_item_uri_get_resource_name (RygelHTTPItemURI* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_resource_name;
	result = _tmp0_;
	return result;
}

void
rygel_http_item_uri_set_resource_name (RygelHTTPItemURI* self,
                                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_http_item_uri_get_resource_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_resource_name);
		self->priv->_resource_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_http_item_uri_properties[RYGEL_HTTP_ITEM_URI_RESOURCE_NAME_PROPERTY]);
	}
}

RygelHTTPServer*
rygel_http_item_uri_get_http_server (RygelHTTPItemURI* self)
{
	RygelHTTPServer* result;
	RygelHTTPServer* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_http_server;
	result = _tmp0_;
	return result;
}

void
rygel_http_item_uri_set_http_server (RygelHTTPItemURI* self,
                                     RygelHTTPServer* value)
{
	RygelHTTPServer* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_http_item_uri_get_http_server (self);
	if (old_value != value) {
		self->priv->_http_server = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_http_item_uri_properties[RYGEL_HTTP_ITEM_URI_HTTP_SERVER_PROPERTY]);
	}
}

gchar*
rygel_http_item_uri_get_extension (RygelHTTPItemURI* self)
{
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->real_extension;
	if (g_strcmp0 (_tmp0_, "") != 0) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->priv->real_extension;
		_tmp2_ = g_strconcat (".", _tmp1_, NULL);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = g_strdup ("");
	result = _tmp3_;
	return result;
}

void
rygel_http_item_uri_set_extension (RygelHTTPItemURI* self,
                                   const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->real_extension);
	self->priv->real_extension = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, rygel_http_item_uri_properties[RYGEL_HTTP_ITEM_URI_EXTENSION_PROPERTY]);
}

static void
rygel_http_item_uri_class_init (RygelHTTPItemURIClass * klass,
                                gpointer klass_data)
{
	rygel_http_item_uri_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelHTTPItemURI_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_item_uri_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_item_uri_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_item_uri_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_ITEM_URI_ITEM_ID_PROPERTY, rygel_http_item_uri_properties[RYGEL_HTTP_ITEM_URI_ITEM_ID_PROPERTY] = g_param_spec_string ("item-id", "item-id", "item-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_ITEM_URI_THUMBNAIL_INDEX_PROPERTY, rygel_http_item_uri_properties[RYGEL_HTTP_ITEM_URI_THUMBNAIL_INDEX_PROPERTY] = g_param_spec_int ("thumbnail-index", "thumbnail-index", "thumbnail-index", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_ITEM_URI_SUBTITLE_INDEX_PROPERTY, rygel_http_item_uri_properties[RYGEL_HTTP_ITEM_URI_SUBTITLE_INDEX_PROPERTY] = g_param_spec_int ("subtitle-index", "subtitle-index", "subtitle-index", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_ITEM_URI_RESOURCE_NAME_PROPERTY, rygel_http_item_uri_properties[RYGEL_HTTP_ITEM_URI_RESOURCE_NAME_PROPERTY] = g_param_spec_string ("resource-name", "resource-name", "resource-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_ITEM_URI_HTTP_SERVER_PROPERTY, rygel_http_item_uri_properties[RYGEL_HTTP_ITEM_URI_HTTP_SERVER_PROPERTY] = g_param_spec_object ("http-server", "http-server", "http-server", RYGEL_TYPE_HTTP_SERVER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_ITEM_URI_EXTENSION_PROPERTY, rygel_http_item_uri_properties[RYGEL_HTTP_ITEM_URI_EXTENSION_PROPERTY] = g_param_spec_string ("extension", "extension", "extension", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
rygel_http_item_uri_instance_init (RygelHTTPItemURI * self,
                                   gpointer klass)
{
	self->priv = rygel_http_item_uri_get_instance_private (self);
	self->priv->_thumbnail_index = -1;
	self->priv->_subtitle_index = -1;
	self->priv->_resource_name = NULL;
}

static void
rygel_http_item_uri_finalize (GObject * obj)
{
	RygelHTTPItemURI * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI);
	_g_free0 (self->priv->_item_id);
	_g_free0 (self->priv->_resource_name);
	_g_free0 (self->priv->real_extension);
	G_OBJECT_CLASS (rygel_http_item_uri_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
rygel_http_item_uri_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPItemURIClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_item_uri_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPItemURI), 0, (GInstanceInitFunc) rygel_http_item_uri_instance_init, NULL };
	GType rygel_http_item_uri_type_id;
	rygel_http_item_uri_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPItemURI", &g_define_type_info, 0);
	RygelHTTPItemURI_private_offset = g_type_add_instance_private (rygel_http_item_uri_type_id, sizeof (RygelHTTPItemURIPrivate));
	return rygel_http_item_uri_type_id;
}

GType
rygel_http_item_uri_get_type (void)
{
	static volatile gsize rygel_http_item_uri_type_id__once = 0;
	if (g_once_init_enter (&rygel_http_item_uri_type_id__once)) {
		GType rygel_http_item_uri_type_id;
		rygel_http_item_uri_type_id = rygel_http_item_uri_get_type_once ();
		g_once_init_leave (&rygel_http_item_uri_type_id__once, rygel_http_item_uri_type_id);
	}
	return rygel_http_item_uri_type_id__once;
}

static void
_vala_rygel_http_item_uri_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	RygelHTTPItemURI * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI);
	switch (property_id) {
		case RYGEL_HTTP_ITEM_URI_ITEM_ID_PROPERTY:
		g_value_set_string (value, rygel_http_item_uri_get_item_id (self));
		break;
		case RYGEL_HTTP_ITEM_URI_THUMBNAIL_INDEX_PROPERTY:
		g_value_set_int (value, rygel_http_item_uri_get_thumbnail_index (self));
		break;
		case RYGEL_HTTP_ITEM_URI_SUBTITLE_INDEX_PROPERTY:
		g_value_set_int (value, rygel_http_item_uri_get_subtitle_index (self));
		break;
		case RYGEL_HTTP_ITEM_URI_RESOURCE_NAME_PROPERTY:
		g_value_set_string (value, rygel_http_item_uri_get_resource_name (self));
		break;
		case RYGEL_HTTP_ITEM_URI_HTTP_SERVER_PROPERTY:
		g_value_set_object (value, rygel_http_item_uri_get_http_server (self));
		break;
		case RYGEL_HTTP_ITEM_URI_EXTENSION_PROPERTY:
		g_value_take_string (value, rygel_http_item_uri_get_extension (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_http_item_uri_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	RygelHTTPItemURI * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI);
	switch (property_id) {
		case RYGEL_HTTP_ITEM_URI_ITEM_ID_PROPERTY:
		rygel_http_item_uri_set_item_id (self, g_value_get_string (value));
		break;
		case RYGEL_HTTP_ITEM_URI_THUMBNAIL_INDEX_PROPERTY:
		rygel_http_item_uri_set_thumbnail_index (self, g_value_get_int (value));
		break;
		case RYGEL_HTTP_ITEM_URI_SUBTITLE_INDEX_PROPERTY:
		rygel_http_item_uri_set_subtitle_index (self, g_value_get_int (value));
		break;
		case RYGEL_HTTP_ITEM_URI_RESOURCE_NAME_PROPERTY:
		rygel_http_item_uri_set_resource_name (self, g_value_get_string (value));
		break;
		case RYGEL_HTTP_ITEM_URI_HTTP_SERVER_PROPERTY:
		rygel_http_item_uri_set_http_server (self, g_value_get_object (value));
		break;
		case RYGEL_HTTP_ITEM_URI_EXTENSION_PROPERTY:
		rygel_http_item_uri_set_extension (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

