// python wrapper for vtkPolarAxesRepresentation
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPolarAxesRepresentation.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPolarAxesRepresentation(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPolarAxesRepresentation_ClassNew(); }

#ifndef DECLARED_PyvtkPVDataRepresentation_ClassNew
extern "C" { PyObject *PyvtkPVDataRepresentation_ClassNew(); }
#define DECLARED_PyvtkPVDataRepresentation_ClassNew
#endif

static PyObject *
PyvtkPolarAxesRepresentation_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPolarAxesRepresentation::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPolarAxesRepresentation::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPolarAxesRepresentation *tempr = vtkPolarAxesRepresentation::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPolarAxesRepresentation *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPolarAxesRepresentation::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPolarAxesRepresentation::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPolarAxesRepresentation::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetPosition_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPosition");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetPosition(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetPosition(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPolarAxesRepresentation_SetPosition_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPosition");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  const size_t size0 = 3;
  double temp0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetPosition(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetPosition(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPolarAxesRepresentation_SetPosition(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkPolarAxesRepresentation_SetPosition_s1(self, args);
    case 1:
      return PyvtkPolarAxesRepresentation_SetPosition_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetPosition");
  return nullptr;
}


static PyObject *
PyvtkPolarAxesRepresentation_GetPosition(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPosition");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  size_t sizer = 3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetPosition() :
      op->vtkPolarAxesRepresentation::GetPosition());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetOrientation_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOrientation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetOrientation(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetOrientation(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPolarAxesRepresentation_SetOrientation_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOrientation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  const size_t size0 = 3;
  double temp0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetOrientation(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetOrientation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPolarAxesRepresentation_SetOrientation(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkPolarAxesRepresentation_SetOrientation_s1(self, args);
    case 1:
      return PyvtkPolarAxesRepresentation_SetOrientation_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetOrientation");
  return nullptr;
}


static PyObject *
PyvtkPolarAxesRepresentation_GetOrientation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOrientation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  size_t sizer = 3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetOrientation() :
      op->vtkPolarAxesRepresentation::GetOrientation());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetScale_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetScale");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetScale(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetScale(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPolarAxesRepresentation_SetScale_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetScale");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  const size_t size0 = 3;
  double temp0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetScale(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetScale(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPolarAxesRepresentation_SetScale(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkPolarAxesRepresentation_SetScale_s1(self, args);
    case 1:
      return PyvtkPolarAxesRepresentation_SetScale_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetScale");
  return nullptr;
}


static PyObject *
PyvtkPolarAxesRepresentation_GetScale(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetScale");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  size_t sizer = 3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetScale() :
      op->vtkPolarAxesRepresentation::GetScale());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_GetDataBounds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDataBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  size_t sizer = 6;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetDataBounds() :
      op->vtkPolarAxesRepresentation::GetDataBounds());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetCustomBounds_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCustomBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  double temp3;
  double temp4;
  double temp5;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(6) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4) &&
      ap.GetValue(temp5))
  {
    if (ap.IsBound())
    {
      op->SetCustomBounds(temp0, temp1, temp2, temp3, temp4, temp5);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetCustomBounds(temp0, temp1, temp2, temp3, temp4, temp5);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPolarAxesRepresentation_SetCustomBounds_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCustomBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  const size_t size0 = 6;
  double temp0[6];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetCustomBounds(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetCustomBounds(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPolarAxesRepresentation_SetCustomBounds(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 6:
      return PyvtkPolarAxesRepresentation_SetCustomBounds_s1(self, args);
    case 1:
      return PyvtkPolarAxesRepresentation_SetCustomBounds_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetCustomBounds");
  return nullptr;
}


static PyObject *
PyvtkPolarAxesRepresentation_GetCustomBounds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCustomBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  size_t sizer = 6;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetCustomBounds() :
      op->vtkPolarAxesRepresentation::GetCustomBounds());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetEnableCustomBounds_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEnableCustomBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  int temp0;
  int temp1;
  int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetEnableCustomBounds(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetEnableCustomBounds(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPolarAxesRepresentation_SetEnableCustomBounds_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEnableCustomBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  const size_t size0 = 3;
  int temp0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetEnableCustomBounds(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetEnableCustomBounds(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPolarAxesRepresentation_SetEnableCustomBounds(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkPolarAxesRepresentation_SetEnableCustomBounds_s1(self, args);
    case 1:
      return PyvtkPolarAxesRepresentation_SetEnableCustomBounds_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetEnableCustomBounds");
  return nullptr;
}


static PyObject *
PyvtkPolarAxesRepresentation_GetEnableCustomBounds(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEnableCustomBounds");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  size_t sizer = 3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int *tempr = (ap.IsBound() ?
      op->GetEnableCustomBounds() :
      op->vtkPolarAxesRepresentation::GetEnableCustomBounds());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetEnableCustomRange(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEnableCustomRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEnableCustomRange(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetEnableCustomRange(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_GetEnableCustomRange(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEnableCustomRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetEnableCustomRange() :
      op->vtkPolarAxesRepresentation::GetEnableCustomRange());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetCustomRange_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCustomRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  double temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetCustomRange(temp0, temp1);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetCustomRange(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPolarAxesRepresentation_SetCustomRange_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCustomRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  const size_t size0 = 2;
  double temp0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetCustomRange(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetCustomRange(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkPolarAxesRepresentation_SetCustomRange(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkPolarAxesRepresentation_SetCustomRange_s1(self, args);
    case 1:
      return PyvtkPolarAxesRepresentation_SetCustomRange_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetCustomRange");
  return nullptr;
}


static PyObject *
PyvtkPolarAxesRepresentation_GetCustomRange(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCustomRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetCustomRange() :
      op->vtkPolarAxesRepresentation::GetCustomRange());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetEnableAutoPole(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEnableAutoPole");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEnableAutoPole(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetEnableAutoPole(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_GetEnableAutoPole(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEnableAutoPole");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetEnableAutoPole() :
      op->vtkPolarAxesRepresentation::GetEnableAutoPole());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetEnableCustomAngle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEnableCustomAngle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEnableCustomAngle(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetEnableCustomAngle(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_GetEnableCustomAngle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEnableCustomAngle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetEnableCustomAngle() :
      op->vtkPolarAxesRepresentation::GetEnableCustomAngle());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetMinAngle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMinAngle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMinAngle(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetMinAngle(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_GetMinAngle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMinAngle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetMinAngle() :
      op->vtkPolarAxesRepresentation::GetMinAngle());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetMaxAngle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMaxAngle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMaxAngle(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetMaxAngle(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_GetMaxAngle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMaxAngle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetMaxAngle() :
      op->vtkPolarAxesRepresentation::GetMaxAngle());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetEnableCustomRadius(PyObject *self, PyObject *args)
{
  PyErr_WarnEx(PyExc_DeprecationWarning,
    "Call to deprecated method SetEnableCustomRadius."
    " (" "Use EnableCustomMinRadius instead" ")"
    " -- Deprecated since version " "5.13.0" ".", 1);

  vtkPythonArgs ap(self, args, "SetEnableCustomRadius");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEnableCustomRadius(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetEnableCustomRadius(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_GetEnableCustomRadius(PyObject *self, PyObject *args)
{
  PyErr_WarnEx(PyExc_DeprecationWarning,
    "Call to deprecated method GetEnableCustomRadius."
    " (" "Use EnableCustomMinRadius instead" ")"
    " -- Deprecated since version " "5.13.0" ".", 1);

  vtkPythonArgs ap(self, args, "GetEnableCustomRadius");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetEnableCustomRadius() :
      op->vtkPolarAxesRepresentation::GetEnableCustomRadius());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetEnableCustomMinRadius(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEnableCustomMinRadius");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEnableCustomMinRadius(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetEnableCustomMinRadius(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_GetEnableCustomMinRadius(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEnableCustomMinRadius");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetEnableCustomMinRadius() :
      op->vtkPolarAxesRepresentation::GetEnableCustomMinRadius());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetMinRadius(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMinRadius");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMinRadius(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetMinRadius(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_GetMinRadius(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMinRadius");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetMinRadius() :
      op->vtkPolarAxesRepresentation::GetMinRadius());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetEnableCustomMaxRadius(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEnableCustomMaxRadius");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEnableCustomMaxRadius(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetEnableCustomMaxRadius(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_GetEnableCustomMaxRadius(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEnableCustomMaxRadius");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetEnableCustomMaxRadius() :
      op->vtkPolarAxesRepresentation::GetEnableCustomMaxRadius());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetMaxRadius(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMaxRadius");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMaxRadius(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetMaxRadius(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_GetMaxRadius(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMaxRadius");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetMaxRadius() :
      op->vtkPolarAxesRepresentation::GetMaxRadius());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_GetEnableOverallColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEnableOverallColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetEnableOverallColor() :
      op->vtkPolarAxesRepresentation::GetEnableOverallColor());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetEnableOverallColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEnableOverallColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEnableOverallColor(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetEnableOverallColor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetOverallColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOverallColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetOverallColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetOverallColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetPolarAxisColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPolarAxisColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetPolarAxisColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetPolarAxisColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetPolarArcsColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPolarArcsColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetPolarArcsColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetPolarArcsColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetSecondaryPolarArcsColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSecondaryPolarArcsColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetSecondaryPolarArcsColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetSecondaryPolarArcsColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetSecondaryRadialAxesColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSecondaryRadialAxesColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetSecondaryRadialAxesColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetSecondaryRadialAxesColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetLastRadialAxisColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLastRadialAxisColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetLastRadialAxisColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetLastRadialAxisColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetPolarAxisTitleTextProperty(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPolarAxisTitleTextProperty");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  vtkTextProperty *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkTextProperty"))
  {
    if (ap.IsBound())
    {
      op->SetPolarAxisTitleTextProperty(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetPolarAxisTitleTextProperty(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetPolarAxisLabelTextProperty(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPolarAxisLabelTextProperty");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  vtkTextProperty *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkTextProperty"))
  {
    if (ap.IsBound())
    {
      op->SetPolarAxisLabelTextProperty(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetPolarAxisLabelTextProperty(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetLastRadialAxisTextProperty(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLastRadialAxisTextProperty");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  vtkTextProperty *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkTextProperty"))
  {
    if (ap.IsBound())
    {
      op->SetLastRadialAxisTextProperty(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetLastRadialAxisTextProperty(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetSecondaryRadialAxesTextProperty(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSecondaryRadialAxesTextProperty");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  vtkTextProperty *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkTextProperty"))
  {
    if (ap.IsBound())
    {
      op->SetSecondaryRadialAxesTextProperty(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetSecondaryRadialAxesTextProperty(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_MarkModified(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MarkModified");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->MarkModified();
    }
    else
    {
      op->vtkPolarAxesRepresentation::MarkModified();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_ProcessViewRequest(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ProcessViewRequest");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  vtkInformationRequestKey *temp0 = nullptr;
  vtkInformation *temp1 = nullptr;
  vtkInformation *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkInformationRequestKey") &&
      ap.GetVTKObject(temp1, "vtkInformation") &&
      ap.GetVTKObject(temp2, "vtkInformation"))
  {
    int tempr = (ap.IsBound() ?
      op->ProcessViewRequest(temp0, temp1, temp2) :
      op->vtkPolarAxesRepresentation::ProcessViewRequest(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetVisibility(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetParentVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetParentVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetParentVisibility(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetParentVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetLog(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLog");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLog(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetLog(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetNumberOfRadialAxes(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfRadialAxes");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfRadialAxes(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetNumberOfRadialAxes(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetNumberOfPolarAxes(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfPolarAxes");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  long long temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfPolarAxes(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetNumberOfPolarAxes(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetDeltaAngleRadialAxes(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDeltaAngleRadialAxes");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDeltaAngleRadialAxes(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetDeltaAngleRadialAxes(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetDeltaRangePolarAxes(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDeltaRangePolarAxes");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDeltaRangePolarAxes(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetDeltaRangePolarAxes(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetSmallestVisiblePolarAngle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSmallestVisiblePolarAngle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSmallestVisiblePolarAngle(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetSmallestVisiblePolarAngle(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetTickLocation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTickLocation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTickLocation(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetTickLocation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetRadialUnits(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRadialUnits");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRadialUnits(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetRadialUnits(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetScreenSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetScreenSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetScreenSize(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetScreenSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetPolarAxisTitle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPolarAxisTitle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPolarAxisTitle(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetPolarAxisTitle(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetPolarLabelFormat(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPolarLabelFormat");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPolarLabelFormat(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetPolarLabelFormat(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetExponentLocation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetExponentLocation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetExponentLocation(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetExponentLocation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetRadialAngleFormat(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRadialAngleFormat");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRadialAngleFormat(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetRadialAngleFormat(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetEnableDistanceLOD(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEnableDistanceLOD");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEnableDistanceLOD(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetEnableDistanceLOD(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetDistanceLODThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDistanceLODThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDistanceLODThreshold(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetDistanceLODThreshold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetEnableViewAngleLOD(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEnableViewAngleLOD");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEnableViewAngleLOD(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetEnableViewAngleLOD(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetViewAngleLODThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetViewAngleLODThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetViewAngleLODThreshold(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetViewAngleLODThreshold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetPolarAxisVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPolarAxisVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPolarAxisVisibility(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetPolarAxisVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetDrawRadialGridlines(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDrawRadialGridlines");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDrawRadialGridlines(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetDrawRadialGridlines(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetDrawPolarArcsGridlines(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDrawPolarArcsGridlines");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDrawPolarArcsGridlines(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetDrawPolarArcsGridlines(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetPolarTitleVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPolarTitleVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPolarTitleVisibility(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetPolarTitleVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetRadialAxisTitleLocation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRadialAxisTitleLocation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRadialAxisTitleLocation(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetRadialAxisTitleLocation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetPolarAxisTitleLocation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPolarAxisTitleLocation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPolarAxisTitleLocation(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetPolarAxisTitleLocation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetRadialTitleOffset(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRadialTitleOffset");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  double temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetRadialTitleOffset(temp0, temp1);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetRadialTitleOffset(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetPolarTitleOffset(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPolarTitleOffset");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  double temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetPolarTitleOffset(temp0, temp1);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetPolarTitleOffset(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetPolarLabelOffset(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPolarLabelOffset");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPolarLabelOffset(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetPolarLabelOffset(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetPolarExponentOffset(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPolarExponentOffset");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPolarExponentOffset(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetPolarExponentOffset(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetPolarLabelVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPolarLabelVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPolarLabelVisibility(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetPolarLabelVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetArcTicksOriginToPolarAxis(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetArcTicksOriginToPolarAxis");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetArcTicksOriginToPolarAxis(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetArcTicksOriginToPolarAxis(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetRadialAxesOriginToPolarAxis(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRadialAxesOriginToPolarAxis");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRadialAxesOriginToPolarAxis(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetRadialAxesOriginToPolarAxis(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetPolarTickVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPolarTickVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPolarTickVisibility(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetPolarTickVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetAxisTickVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAxisTickVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAxisTickVisibility(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetAxisTickVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetAxisMinorTickVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAxisMinorTickVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAxisMinorTickVisibility(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetAxisMinorTickVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetAxisTickMatchesPolarAxes(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAxisTickMatchesPolarAxes");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAxisTickMatchesPolarAxes(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetAxisTickMatchesPolarAxes(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetArcTickVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetArcTickVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetArcTickVisibility(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetArcTickVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetArcMinorTickVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetArcMinorTickVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetArcMinorTickVisibility(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetArcMinorTickVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetArcTickMatchesRadialAxes(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetArcTickMatchesRadialAxes");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetArcTickMatchesRadialAxes(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetArcTickMatchesRadialAxes(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetTickRatioRadiusSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTickRatioRadiusSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTickRatioRadiusSize(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetTickRatioRadiusSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetArcMajorTickSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetArcMajorTickSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetArcMajorTickSize(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetArcMajorTickSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetPolarAxisMajorTickSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPolarAxisMajorTickSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPolarAxisMajorTickSize(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetPolarAxisMajorTickSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetLastRadialAxisMajorTickSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLastRadialAxisMajorTickSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLastRadialAxisMajorTickSize(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetLastRadialAxisMajorTickSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetPolarAxisTickRatioSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPolarAxisTickRatioSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPolarAxisTickRatioSize(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetPolarAxisTickRatioSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetLastAxisTickRatioSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLastAxisTickRatioSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLastAxisTickRatioSize(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetLastAxisTickRatioSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetArcTickRatioSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetArcTickRatioSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetArcTickRatioSize(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetArcTickRatioSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetPolarAxisMajorTickThickness(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPolarAxisMajorTickThickness");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPolarAxisMajorTickThickness(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetPolarAxisMajorTickThickness(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetLastRadialAxisMajorTickThickness(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLastRadialAxisMajorTickThickness");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLastRadialAxisMajorTickThickness(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetLastRadialAxisMajorTickThickness(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetArcMajorTickThickness(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetArcMajorTickThickness");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetArcMajorTickThickness(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetArcMajorTickThickness(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetPolarAxisTickRatioThickness(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPolarAxisTickRatioThickness");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPolarAxisTickRatioThickness(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetPolarAxisTickRatioThickness(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetLastAxisTickRatioThickness(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLastAxisTickRatioThickness");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLastAxisTickRatioThickness(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetLastAxisTickRatioThickness(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetArcTickRatioThickness(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetArcTickRatioThickness");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetArcTickRatioThickness(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetArcTickRatioThickness(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetDeltaAngleMajor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDeltaAngleMajor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDeltaAngleMajor(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetDeltaAngleMajor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetDeltaAngleMinor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDeltaAngleMinor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDeltaAngleMinor(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetDeltaAngleMinor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetRadialAxesVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRadialAxesVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRadialAxesVisibility(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetRadialAxesVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetRadialTitleVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRadialTitleVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRadialTitleVisibility(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetRadialTitleVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetPolarArcsVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPolarArcsVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPolarArcsVisibility(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetPolarArcsVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetUse2DMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUse2DMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUse2DMode(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetUse2DMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetRatio(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRatio");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRatio(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetRatio(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetPolarArcResolutionPerDegree(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPolarArcResolutionPerDegree");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPolarArcResolutionPerDegree(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetPolarArcResolutionPerDegree(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetDeltaRangeMinor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDeltaRangeMinor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDeltaRangeMinor(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetDeltaRangeMinor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetDeltaRangeMajor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDeltaRangeMajor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetDeltaRangeMajor(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetDeltaRangeMajor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_SetRendererType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRendererType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRendererType(temp0);
    }
    else
    {
      op->vtkPolarAxesRepresentation::SetRendererType(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPolarAxesRepresentation_GetRendererType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRendererType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPolarAxesRepresentation *op = static_cast<vtkPolarAxesRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetRendererType() :
      op->vtkPolarAxesRepresentation::GetRendererType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPolarAxesRepresentation_Methods[] = {
  {"IsTypeOf", PyvtkPolarAxesRepresentation_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPolarAxesRepresentation_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPolarAxesRepresentation_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPolarAxesRepresentation\nC++: static vtkPolarAxesRepresentation *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPolarAxesRepresentation_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPolarAxesRepresentation\nC++: vtkPolarAxesRepresentation *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPolarAxesRepresentation_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPolarAxesRepresentation_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetPosition", PyvtkPolarAxesRepresentation_SetPosition, METH_VARARGS,
   "SetPosition(self, _arg1:float, _arg2:float, _arg3:float) -> None\nC++: virtual void SetPosition(double _arg1, double _arg2,\n    double _arg3)\nSetPosition(self, _arg:(float, float, float)) -> None\nC++: virtual void SetPosition(const double _arg[3])\n\nGet/Set the Position to transform the data bounds.\n"},
  {"GetPosition", PyvtkPolarAxesRepresentation_GetPosition, METH_VARARGS,
   "GetPosition(self) -> (float, float, float)\nC++: virtual double *GetPosition()\n\n"},
  {"SetOrientation", PyvtkPolarAxesRepresentation_SetOrientation, METH_VARARGS,
   "SetOrientation(self, _arg1:float, _arg2:float, _arg3:float)\n    -> None\nC++: virtual void SetOrientation(double _arg1, double _arg2,\n    double _arg3)\nSetOrientation(self, _arg:(float, float, float)) -> None\nC++: virtual void SetOrientation(const double _arg[3])\n\nGet/Set the Orientation to transform the data bounds.\n"},
  {"GetOrientation", PyvtkPolarAxesRepresentation_GetOrientation, METH_VARARGS,
   "GetOrientation(self) -> (float, float, float)\nC++: virtual double *GetOrientation()\n\n"},
  {"SetScale", PyvtkPolarAxesRepresentation_SetScale, METH_VARARGS,
   "SetScale(self, _arg1:float, _arg2:float, _arg3:float) -> None\nC++: virtual void SetScale(double _arg1, double _arg2,\n    double _arg3)\nSetScale(self, _arg:(float, float, float)) -> None\nC++: virtual void SetScale(const double _arg[3])\n\nGet/Set the Scale to transform the data bounds.\n"},
  {"GetScale", PyvtkPolarAxesRepresentation_GetScale, METH_VARARGS,
   "GetScale(self) -> (float, float, float)\nC++: virtual double *GetScale()\n\n"},
  {"GetDataBounds", PyvtkPolarAxesRepresentation_GetDataBounds, METH_VARARGS,
   "GetDataBounds(self) -> (float, float, float, float, float, float)\nC++: virtual double *GetDataBounds()\n\nGet the bounds of the data.\n"},
  {"SetCustomBounds", PyvtkPolarAxesRepresentation_SetCustomBounds, METH_VARARGS,
   "SetCustomBounds(self, _arg1:float, _arg2:float, _arg3:float,\n    _arg4:float, _arg5:float, _arg6:float) -> None\nC++: virtual void SetCustomBounds(double _arg1, double _arg2,\n    double _arg3, double _arg4, double _arg5, double _arg6)\nSetCustomBounds(self, _arg:(float, float, float, float, float,\n    float)) -> None\nC++: virtual void SetCustomBounds(const double _arg[6])\n\nGet/Set custom bounds to use. When corresponding\nCustomBoundsActive is true, the data bounds will be ignored for\nthat direction and CustomBounds will be used instead.\n"},
  {"GetCustomBounds", PyvtkPolarAxesRepresentation_GetCustomBounds, METH_VARARGS,
   "GetCustomBounds(self) -> (float, float, float, float, float,\n    float)\nC++: virtual double *GetCustomBounds()\n\n"},
  {"SetEnableCustomBounds", PyvtkPolarAxesRepresentation_SetEnableCustomBounds, METH_VARARGS,
   "SetEnableCustomBounds(self, _arg1:int, _arg2:int, _arg3:int)\n    -> None\nC++: virtual void SetEnableCustomBounds(int _arg1, int _arg2,\n    int _arg3)\nSetEnableCustomBounds(self, _arg:(int, int, int)) -> None\nC++: virtual void SetEnableCustomBounds(const int _arg[3])\n\nGet/Set whether to use custom bounds for a particular dimension.\n"},
  {"GetEnableCustomBounds", PyvtkPolarAxesRepresentation_GetEnableCustomBounds, METH_VARARGS,
   "GetEnableCustomBounds(self) -> (int, int, int)\nC++: virtual int *GetEnableCustomBounds()\n\n"},
  {"SetEnableCustomRange", PyvtkPolarAxesRepresentation_SetEnableCustomRange, METH_VARARGS,
   "SetEnableCustomRange(self, _arg:bool) -> None\nC++: virtual void SetEnableCustomRange(bool _arg)\n\nGet/Set the use of a custom range.\n"},
  {"GetEnableCustomRange", PyvtkPolarAxesRepresentation_GetEnableCustomRange, METH_VARARGS,
   "GetEnableCustomRange(self) -> bool\nC++: virtual bool GetEnableCustomRange()\n\n"},
  {"SetCustomRange", PyvtkPolarAxesRepresentation_SetCustomRange, METH_VARARGS,
   "SetCustomRange(self, _arg1:float, _arg2:float) -> None\nC++: virtual void SetCustomRange(double _arg1, double _arg2)\nSetCustomRange(self, _arg:(float, float)) -> None\nC++: void SetCustomRange(const double _arg[2])\n\nGet/Set custom range to use. The data bounds will be ignored for\nthat direction and CustomRange will be used instead.\n"},
  {"GetCustomRange", PyvtkPolarAxesRepresentation_GetCustomRange, METH_VARARGS,
   "GetCustomRange(self) -> (float, float)\nC++: virtual double *GetCustomRange()\n\n"},
  {"SetEnableAutoPole", PyvtkPolarAxesRepresentation_SetEnableAutoPole, METH_VARARGS,
   "SetEnableAutoPole(self, _arg:bool) -> None\nC++: virtual void SetEnableAutoPole(bool _arg)\n\nGet/Set the use of automatically placed pole (origin of the\naxes). If on, pole is placed at the center of the bounding box.\n"},
  {"GetEnableAutoPole", PyvtkPolarAxesRepresentation_GetEnableAutoPole, METH_VARARGS,
   "GetEnableAutoPole(self) -> bool\nC++: virtual bool GetEnableAutoPole()\n\n"},
  {"SetEnableCustomAngle", PyvtkPolarAxesRepresentation_SetEnableCustomAngle, METH_VARARGS,
   "SetEnableCustomAngle(self, _arg:bool) -> None\nC++: virtual void SetEnableCustomAngle(bool _arg)\n\nGet/Set the use of custom min/max angles. If off, min/max angles\nare computed relatively to pole position.\n"},
  {"GetEnableCustomAngle", PyvtkPolarAxesRepresentation_GetEnableCustomAngle, METH_VARARGS,
   "GetEnableCustomAngle(self) -> bool\nC++: virtual bool GetEnableCustomAngle()\n\n"},
  {"SetMinAngle", PyvtkPolarAxesRepresentation_SetMinAngle, METH_VARARGS,
   "SetMinAngle(self, _arg:float) -> None\nC++: virtual void SetMinAngle(double _arg)\n\nGet/Set the custom min/max angles when EnableCustomAngle is On.\n"},
  {"GetMinAngle", PyvtkPolarAxesRepresentation_GetMinAngle, METH_VARARGS,
   "GetMinAngle(self) -> float\nC++: virtual double GetMinAngle()\n\n"},
  {"SetMaxAngle", PyvtkPolarAxesRepresentation_SetMaxAngle, METH_VARARGS,
   "SetMaxAngle(self, _arg:float) -> None\nC++: virtual void SetMaxAngle(double _arg)\n\n"},
  {"GetMaxAngle", PyvtkPolarAxesRepresentation_GetMaxAngle, METH_VARARGS,
   "GetMaxAngle(self) -> float\nC++: virtual double GetMaxAngle()\n\n"},
  {"SetEnableCustomRadius", PyvtkPolarAxesRepresentation_SetEnableCustomRadius, METH_VARARGS,
   "SetEnableCustomRadius(self, enabled:bool) -> None\nC++: virtual void SetEnableCustomRadius(bool enabled)\n\nGet/Set the use of custom min radius. If off, min radius is\ncomputed relatively to pole position.\n"},
  {"GetEnableCustomRadius", PyvtkPolarAxesRepresentation_GetEnableCustomRadius, METH_VARARGS,
   "GetEnableCustomRadius(self) -> bool\nC++: virtual bool GetEnableCustomRadius()\n\n"},
  {"SetEnableCustomMinRadius", PyvtkPolarAxesRepresentation_SetEnableCustomMinRadius, METH_VARARGS,
   "SetEnableCustomMinRadius(self, enabled:bool) -> None\nC++: void SetEnableCustomMinRadius(bool enabled)\n\n"},
  {"GetEnableCustomMinRadius", PyvtkPolarAxesRepresentation_GetEnableCustomMinRadius, METH_VARARGS,
   "GetEnableCustomMinRadius(self) -> float\nC++: virtual double GetEnableCustomMinRadius()\n\n"},
  {"SetMinRadius", PyvtkPolarAxesRepresentation_SetMinRadius, METH_VARARGS,
   "SetMinRadius(self, _arg:float) -> None\nC++: virtual void SetMinRadius(double _arg)\n\nGet/Set the custom min radius when EnableCustomMinRadius is On.\nDefault to 0.\n"},
  {"GetMinRadius", PyvtkPolarAxesRepresentation_GetMinRadius, METH_VARARGS,
   "GetMinRadius(self) -> float\nC++: virtual double GetMinRadius()\n\n"},
  {"SetEnableCustomMaxRadius", PyvtkPolarAxesRepresentation_SetEnableCustomMaxRadius, METH_VARARGS,
   "SetEnableCustomMaxRadius(self, _arg:bool) -> None\nC++: virtual void SetEnableCustomMaxRadius(bool _arg)\n\nGet/Set the use of custom min radius. If off, max radius is\ncomputed relatively to pole position.\n"},
  {"GetEnableCustomMaxRadius", PyvtkPolarAxesRepresentation_GetEnableCustomMaxRadius, METH_VARARGS,
   "GetEnableCustomMaxRadius(self) -> bool\nC++: virtual bool GetEnableCustomMaxRadius()\n\n"},
  {"SetMaxRadius", PyvtkPolarAxesRepresentation_SetMaxRadius, METH_VARARGS,
   "SetMaxRadius(self, _arg:float) -> None\nC++: virtual void SetMaxRadius(double _arg)\n\nGet/Set the custom min radius when EnableCustomMaxRadius is On.\nDefault to 1.\n"},
  {"GetMaxRadius", PyvtkPolarAxesRepresentation_GetMaxRadius, METH_VARARGS,
   "GetMaxRadius(self) -> float\nC++: virtual double GetMaxRadius()\n\n"},
  {"GetEnableOverallColor", PyvtkPolarAxesRepresentation_GetEnableOverallColor, METH_VARARGS,
   "GetEnableOverallColor(self) -> bool\nC++: virtual bool GetEnableOverallColor()\n\nSet the actor color.\n"},
  {"SetEnableOverallColor", PyvtkPolarAxesRepresentation_SetEnableOverallColor, METH_VARARGS,
   "SetEnableOverallColor(self, enable:bool) -> None\nC++: virtual void SetEnableOverallColor(bool enable)\n\n"},
  {"SetOverallColor", PyvtkPolarAxesRepresentation_SetOverallColor, METH_VARARGS,
   "SetOverallColor(self, r:float, g:float, b:float) -> None\nC++: virtual void SetOverallColor(double r, double g, double b)\n\n"},
  {"SetPolarAxisColor", PyvtkPolarAxesRepresentation_SetPolarAxisColor, METH_VARARGS,
   "SetPolarAxisColor(self, r:float, g:float, b:float) -> None\nC++: virtual void SetPolarAxisColor(double r, double g, double b)\n\n"},
  {"SetPolarArcsColor", PyvtkPolarAxesRepresentation_SetPolarArcsColor, METH_VARARGS,
   "SetPolarArcsColor(self, r:float, g:float, b:float) -> None\nC++: virtual void SetPolarArcsColor(double r, double g, double b)\n\n"},
  {"SetSecondaryPolarArcsColor", PyvtkPolarAxesRepresentation_SetSecondaryPolarArcsColor, METH_VARARGS,
   "SetSecondaryPolarArcsColor(self, r:float, g:float, b:float)\n    -> None\nC++: virtual void SetSecondaryPolarArcsColor(double r, double g,\n    double b)\n\n"},
  {"SetSecondaryRadialAxesColor", PyvtkPolarAxesRepresentation_SetSecondaryRadialAxesColor, METH_VARARGS,
   "SetSecondaryRadialAxesColor(self, r:float, g:float, b:float)\n    -> None\nC++: virtual void SetSecondaryRadialAxesColor(double r, double g,\n    double b)\n\n"},
  {"SetLastRadialAxisColor", PyvtkPolarAxesRepresentation_SetLastRadialAxisColor, METH_VARARGS,
   "SetLastRadialAxisColor(self, r:float, g:float, b:float) -> None\nC++: virtual void SetLastRadialAxisColor(double r, double g,\n    double b)\n\n"},
  {"SetPolarAxisTitleTextProperty", PyvtkPolarAxesRepresentation_SetPolarAxisTitleTextProperty, METH_VARARGS,
   "SetPolarAxisTitleTextProperty(self, prop:vtkTextProperty) -> None\nC++: virtual void SetPolarAxisTitleTextProperty(\n    vtkTextProperty *prop)\n\n"},
  {"SetPolarAxisLabelTextProperty", PyvtkPolarAxesRepresentation_SetPolarAxisLabelTextProperty, METH_VARARGS,
   "SetPolarAxisLabelTextProperty(self, prop:vtkTextProperty) -> None\nC++: virtual void SetPolarAxisLabelTextProperty(\n    vtkTextProperty *prop)\n\n"},
  {"SetLastRadialAxisTextProperty", PyvtkPolarAxesRepresentation_SetLastRadialAxisTextProperty, METH_VARARGS,
   "SetLastRadialAxisTextProperty(self, prop:vtkTextProperty) -> None\nC++: virtual void SetLastRadialAxisTextProperty(\n    vtkTextProperty *prop)\n\n"},
  {"SetSecondaryRadialAxesTextProperty", PyvtkPolarAxesRepresentation_SetSecondaryRadialAxesTextProperty, METH_VARARGS,
   "SetSecondaryRadialAxesTextProperty(self, prop:vtkTextProperty)\n    -> None\nC++: virtual void SetSecondaryRadialAxesTextProperty(\n    vtkTextProperty *prop)\n\n"},
  {"MarkModified", PyvtkPolarAxesRepresentation_MarkModified, METH_VARARGS,
   "MarkModified(self) -> None\nC++: void MarkModified() override;\n\nThis needs to be called on all instances of\nvtkPolarAxesRepresentation when the input is modified.\n"},
  {"ProcessViewRequest", PyvtkPolarAxesRepresentation_ProcessViewRequest, METH_VARARGS,
   "ProcessViewRequest(self, request_type:vtkInformationRequestKey,\n    inInfo:vtkInformation, outInfo:vtkInformation) -> int\nC++: int ProcessViewRequest(\n    vtkInformationRequestKey *request_type,\n    vtkInformation *inInfo, vtkInformation *outInfo) override;\n\nvtkAlgorithm::ProcessRequest() equivalent for rendering passes.\nThis is typically called by the vtkView to request meta-data from\nthe representations or ask them to perform certain tasks e.g.\nPrepareForRendering\n"},
  {"SetVisibility", PyvtkPolarAxesRepresentation_SetVisibility, METH_VARARGS,
   "SetVisibility(self, visible:bool) -> None\nC++: void SetVisibility(bool visible) override;\n\nSet visibility of the representation.\n"},
  {"SetParentVisibility", PyvtkPolarAxesRepresentation_SetParentVisibility, METH_VARARGS,
   "SetParentVisibility(self, visible:bool) -> None\nC++: virtual void SetParentVisibility(bool visible)\n\nSet (forward) visibility of the parent (composite)\nrepresentation.\n"},
  {"SetLog", PyvtkPolarAxesRepresentation_SetLog, METH_VARARGS,
   "SetLog(self, active:bool) -> None\nC++: virtual void SetLog(bool active)\n\nForwarded to internal vtkPolarAxesActor\n"},
  {"SetNumberOfRadialAxes", PyvtkPolarAxesRepresentation_SetNumberOfRadialAxes, METH_VARARGS,
   "SetNumberOfRadialAxes(self, val:int) -> None\nC++: virtual void SetNumberOfRadialAxes(vtkIdType val)\n\n"},
  {"SetNumberOfPolarAxes", PyvtkPolarAxesRepresentation_SetNumberOfPolarAxes, METH_VARARGS,
   "SetNumberOfPolarAxes(self, val:int) -> None\nC++: virtual void SetNumberOfPolarAxes(vtkIdType val)\n\n"},
  {"SetDeltaAngleRadialAxes", PyvtkPolarAxesRepresentation_SetDeltaAngleRadialAxes, METH_VARARGS,
   "SetDeltaAngleRadialAxes(self, angle:float) -> None\nC++: virtual void SetDeltaAngleRadialAxes(double angle)\n\n"},
  {"SetDeltaRangePolarAxes", PyvtkPolarAxesRepresentation_SetDeltaRangePolarAxes, METH_VARARGS,
   "SetDeltaRangePolarAxes(self, range:float) -> None\nC++: virtual void SetDeltaRangePolarAxes(double range)\n\n"},
  {"SetSmallestVisiblePolarAngle", PyvtkPolarAxesRepresentation_SetSmallestVisiblePolarAngle, METH_VARARGS,
   "SetSmallestVisiblePolarAngle(self, angle:float) -> None\nC++: virtual void SetSmallestVisiblePolarAngle(double angle)\n\n"},
  {"SetTickLocation", PyvtkPolarAxesRepresentation_SetTickLocation, METH_VARARGS,
   "SetTickLocation(self, location:int) -> None\nC++: virtual void SetTickLocation(int location)\n\n"},
  {"SetRadialUnits", PyvtkPolarAxesRepresentation_SetRadialUnits, METH_VARARGS,
   "SetRadialUnits(self, use:bool) -> None\nC++: virtual void SetRadialUnits(bool use)\n\n"},
  {"SetScreenSize", PyvtkPolarAxesRepresentation_SetScreenSize, METH_VARARGS,
   "SetScreenSize(self, size:float) -> None\nC++: virtual void SetScreenSize(double size)\n\n"},
  {"SetPolarAxisTitle", PyvtkPolarAxesRepresentation_SetPolarAxisTitle, METH_VARARGS,
   "SetPolarAxisTitle(self, title:str) -> None\nC++: virtual void SetPolarAxisTitle(const char *title)\n\n"},
  {"SetPolarLabelFormat", PyvtkPolarAxesRepresentation_SetPolarLabelFormat, METH_VARARGS,
   "SetPolarLabelFormat(self, format:str) -> None\nC++: virtual void SetPolarLabelFormat(const char *format)\n\n"},
  {"SetExponentLocation", PyvtkPolarAxesRepresentation_SetExponentLocation, METH_VARARGS,
   "SetExponentLocation(self, location:int) -> None\nC++: virtual void SetExponentLocation(int location)\n\n"},
  {"SetRadialAngleFormat", PyvtkPolarAxesRepresentation_SetRadialAngleFormat, METH_VARARGS,
   "SetRadialAngleFormat(self, format:str) -> None\nC++: virtual void SetRadialAngleFormat(const char *format)\n\n"},
  {"SetEnableDistanceLOD", PyvtkPolarAxesRepresentation_SetEnableDistanceLOD, METH_VARARGS,
   "SetEnableDistanceLOD(self, enable:int) -> None\nC++: virtual void SetEnableDistanceLOD(int enable)\n\n"},
  {"SetDistanceLODThreshold", PyvtkPolarAxesRepresentation_SetDistanceLODThreshold, METH_VARARGS,
   "SetDistanceLODThreshold(self, val:float) -> None\nC++: virtual void SetDistanceLODThreshold(double val)\n\n"},
  {"SetEnableViewAngleLOD", PyvtkPolarAxesRepresentation_SetEnableViewAngleLOD, METH_VARARGS,
   "SetEnableViewAngleLOD(self, enable:int) -> None\nC++: virtual void SetEnableViewAngleLOD(int enable)\n\n"},
  {"SetViewAngleLODThreshold", PyvtkPolarAxesRepresentation_SetViewAngleLODThreshold, METH_VARARGS,
   "SetViewAngleLODThreshold(self, val:float) -> None\nC++: virtual void SetViewAngleLODThreshold(double val)\n\n"},
  {"SetPolarAxisVisibility", PyvtkPolarAxesRepresentation_SetPolarAxisVisibility, METH_VARARGS,
   "SetPolarAxisVisibility(self, visible:int) -> None\nC++: virtual void SetPolarAxisVisibility(int visible)\n\n"},
  {"SetDrawRadialGridlines", PyvtkPolarAxesRepresentation_SetDrawRadialGridlines, METH_VARARGS,
   "SetDrawRadialGridlines(self, draw:int) -> None\nC++: virtual void SetDrawRadialGridlines(int draw)\n\n"},
  {"SetDrawPolarArcsGridlines", PyvtkPolarAxesRepresentation_SetDrawPolarArcsGridlines, METH_VARARGS,
   "SetDrawPolarArcsGridlines(self, draw:int) -> None\nC++: virtual void SetDrawPolarArcsGridlines(int draw)\n\n"},
  {"SetPolarTitleVisibility", PyvtkPolarAxesRepresentation_SetPolarTitleVisibility, METH_VARARGS,
   "SetPolarTitleVisibility(self, visible:int) -> None\nC++: virtual void SetPolarTitleVisibility(int visible)\n\n"},
  {"SetRadialAxisTitleLocation", PyvtkPolarAxesRepresentation_SetRadialAxisTitleLocation, METH_VARARGS,
   "SetRadialAxisTitleLocation(self, location:int) -> None\nC++: virtual void SetRadialAxisTitleLocation(int location)\n\n"},
  {"SetPolarAxisTitleLocation", PyvtkPolarAxesRepresentation_SetPolarAxisTitleLocation, METH_VARARGS,
   "SetPolarAxisTitleLocation(self, location:int) -> None\nC++: virtual void SetPolarAxisTitleLocation(int location)\n\n"},
  {"SetRadialTitleOffset", PyvtkPolarAxesRepresentation_SetRadialTitleOffset, METH_VARARGS,
   "SetRadialTitleOffset(self, offsetX:float, offsetY:float) -> None\nC++: virtual void SetRadialTitleOffset(double offsetX,\n    double offsetY)\n\n"},
  {"SetPolarTitleOffset", PyvtkPolarAxesRepresentation_SetPolarTitleOffset, METH_VARARGS,
   "SetPolarTitleOffset(self, offsetX:float, offsetY:float) -> None\nC++: virtual void SetPolarTitleOffset(double offsetX,\n    double offsetY)\n\n"},
  {"SetPolarLabelOffset", PyvtkPolarAxesRepresentation_SetPolarLabelOffset, METH_VARARGS,
   "SetPolarLabelOffset(self, offsetY:float) -> None\nC++: virtual void SetPolarLabelOffset(double offsetY)\n\n"},
  {"SetPolarExponentOffset", PyvtkPolarAxesRepresentation_SetPolarExponentOffset, METH_VARARGS,
   "SetPolarExponentOffset(self, offsetY:float) -> None\nC++: virtual void SetPolarExponentOffset(double offsetY)\n\n"},
  {"SetPolarLabelVisibility", PyvtkPolarAxesRepresentation_SetPolarLabelVisibility, METH_VARARGS,
   "SetPolarLabelVisibility(self, visible:int) -> None\nC++: virtual void SetPolarLabelVisibility(int visible)\n\n"},
  {"SetArcTicksOriginToPolarAxis", PyvtkPolarAxesRepresentation_SetArcTicksOriginToPolarAxis, METH_VARARGS,
   "SetArcTicksOriginToPolarAxis(self, use:int) -> None\nC++: virtual void SetArcTicksOriginToPolarAxis(int use)\n\n"},
  {"SetRadialAxesOriginToPolarAxis", PyvtkPolarAxesRepresentation_SetRadialAxesOriginToPolarAxis, METH_VARARGS,
   "SetRadialAxesOriginToPolarAxis(self, use:int) -> None\nC++: virtual void SetRadialAxesOriginToPolarAxis(int use)\n\n"},
  {"SetPolarTickVisibility", PyvtkPolarAxesRepresentation_SetPolarTickVisibility, METH_VARARGS,
   "SetPolarTickVisibility(self, visible:int) -> None\nC++: virtual void SetPolarTickVisibility(int visible)\n\n"},
  {"SetAxisTickVisibility", PyvtkPolarAxesRepresentation_SetAxisTickVisibility, METH_VARARGS,
   "SetAxisTickVisibility(self, visible:int) -> None\nC++: virtual void SetAxisTickVisibility(int visible)\n\n"},
  {"SetAxisMinorTickVisibility", PyvtkPolarAxesRepresentation_SetAxisMinorTickVisibility, METH_VARARGS,
   "SetAxisMinorTickVisibility(self, visible:int) -> None\nC++: virtual void SetAxisMinorTickVisibility(int visible)\n\n"},
  {"SetAxisTickMatchesPolarAxes", PyvtkPolarAxesRepresentation_SetAxisTickMatchesPolarAxes, METH_VARARGS,
   "SetAxisTickMatchesPolarAxes(self, enable:int) -> None\nC++: virtual void SetAxisTickMatchesPolarAxes(int enable)\n\n"},
  {"SetArcTickVisibility", PyvtkPolarAxesRepresentation_SetArcTickVisibility, METH_VARARGS,
   "SetArcTickVisibility(self, visible:int) -> None\nC++: virtual void SetArcTickVisibility(int visible)\n\n"},
  {"SetArcMinorTickVisibility", PyvtkPolarAxesRepresentation_SetArcMinorTickVisibility, METH_VARARGS,
   "SetArcMinorTickVisibility(self, visible:int) -> None\nC++: virtual void SetArcMinorTickVisibility(int visible)\n\n"},
  {"SetArcTickMatchesRadialAxes", PyvtkPolarAxesRepresentation_SetArcTickMatchesRadialAxes, METH_VARARGS,
   "SetArcTickMatchesRadialAxes(self, enable:int) -> None\nC++: virtual void SetArcTickMatchesRadialAxes(int enable)\n\n"},
  {"SetTickRatioRadiusSize", PyvtkPolarAxesRepresentation_SetTickRatioRadiusSize, METH_VARARGS,
   "SetTickRatioRadiusSize(self, ratio:float) -> None\nC++: virtual void SetTickRatioRadiusSize(double ratio)\n\n"},
  {"SetArcMajorTickSize", PyvtkPolarAxesRepresentation_SetArcMajorTickSize, METH_VARARGS,
   "SetArcMajorTickSize(self, size:float) -> None\nC++: virtual void SetArcMajorTickSize(double size)\n\n"},
  {"SetPolarAxisMajorTickSize", PyvtkPolarAxesRepresentation_SetPolarAxisMajorTickSize, METH_VARARGS,
   "SetPolarAxisMajorTickSize(self, size:float) -> None\nC++: virtual void SetPolarAxisMajorTickSize(double size)\n\n"},
  {"SetLastRadialAxisMajorTickSize", PyvtkPolarAxesRepresentation_SetLastRadialAxisMajorTickSize, METH_VARARGS,
   "SetLastRadialAxisMajorTickSize(self, size:float) -> None\nC++: virtual void SetLastRadialAxisMajorTickSize(double size)\n\n"},
  {"SetPolarAxisTickRatioSize", PyvtkPolarAxesRepresentation_SetPolarAxisTickRatioSize, METH_VARARGS,
   "SetPolarAxisTickRatioSize(self, size:float) -> None\nC++: virtual void SetPolarAxisTickRatioSize(double size)\n\n"},
  {"SetLastAxisTickRatioSize", PyvtkPolarAxesRepresentation_SetLastAxisTickRatioSize, METH_VARARGS,
   "SetLastAxisTickRatioSize(self, size:float) -> None\nC++: virtual void SetLastAxisTickRatioSize(double size)\n\n"},
  {"SetArcTickRatioSize", PyvtkPolarAxesRepresentation_SetArcTickRatioSize, METH_VARARGS,
   "SetArcTickRatioSize(self, size:float) -> None\nC++: virtual void SetArcTickRatioSize(double size)\n\n"},
  {"SetPolarAxisMajorTickThickness", PyvtkPolarAxesRepresentation_SetPolarAxisMajorTickThickness, METH_VARARGS,
   "SetPolarAxisMajorTickThickness(self, thickness:float) -> None\nC++: virtual void SetPolarAxisMajorTickThickness(double thickness)\n\n"},
  {"SetLastRadialAxisMajorTickThickness", PyvtkPolarAxesRepresentation_SetLastRadialAxisMajorTickThickness, METH_VARARGS,
   "SetLastRadialAxisMajorTickThickness(self, thickness:float) -> None\nC++: virtual void SetLastRadialAxisMajorTickThickness(\n    double thickness)\n\n"},
  {"SetArcMajorTickThickness", PyvtkPolarAxesRepresentation_SetArcMajorTickThickness, METH_VARARGS,
   "SetArcMajorTickThickness(self, thickness:float) -> None\nC++: virtual void SetArcMajorTickThickness(double thickness)\n\n"},
  {"SetPolarAxisTickRatioThickness", PyvtkPolarAxesRepresentation_SetPolarAxisTickRatioThickness, METH_VARARGS,
   "SetPolarAxisTickRatioThickness(self, thickness:float) -> None\nC++: virtual void SetPolarAxisTickRatioThickness(double thickness)\n\n"},
  {"SetLastAxisTickRatioThickness", PyvtkPolarAxesRepresentation_SetLastAxisTickRatioThickness, METH_VARARGS,
   "SetLastAxisTickRatioThickness(self, thickness:float) -> None\nC++: virtual void SetLastAxisTickRatioThickness(double thickness)\n\n"},
  {"SetArcTickRatioThickness", PyvtkPolarAxesRepresentation_SetArcTickRatioThickness, METH_VARARGS,
   "SetArcTickRatioThickness(self, thickness:float) -> None\nC++: virtual void SetArcTickRatioThickness(double thickness)\n\n"},
  {"SetDeltaAngleMajor", PyvtkPolarAxesRepresentation_SetDeltaAngleMajor, METH_VARARGS,
   "SetDeltaAngleMajor(self, delta:float) -> None\nC++: virtual void SetDeltaAngleMajor(double delta)\n\n"},
  {"SetDeltaAngleMinor", PyvtkPolarAxesRepresentation_SetDeltaAngleMinor, METH_VARARGS,
   "SetDeltaAngleMinor(self, delta:float) -> None\nC++: virtual void SetDeltaAngleMinor(double delta)\n\n"},
  {"SetRadialAxesVisibility", PyvtkPolarAxesRepresentation_SetRadialAxesVisibility, METH_VARARGS,
   "SetRadialAxesVisibility(self, visible:int) -> None\nC++: virtual void SetRadialAxesVisibility(int visible)\n\n"},
  {"SetRadialTitleVisibility", PyvtkPolarAxesRepresentation_SetRadialTitleVisibility, METH_VARARGS,
   "SetRadialTitleVisibility(self, visible:int) -> None\nC++: virtual void SetRadialTitleVisibility(int visible)\n\n"},
  {"SetPolarArcsVisibility", PyvtkPolarAxesRepresentation_SetPolarArcsVisibility, METH_VARARGS,
   "SetPolarArcsVisibility(self, visible:int) -> None\nC++: virtual void SetPolarArcsVisibility(int visible)\n\n"},
  {"SetUse2DMode", PyvtkPolarAxesRepresentation_SetUse2DMode, METH_VARARGS,
   "SetUse2DMode(self, use:int) -> None\nC++: virtual void SetUse2DMode(int use)\n\n"},
  {"SetRatio", PyvtkPolarAxesRepresentation_SetRatio, METH_VARARGS,
   "SetRatio(self, ratio:float) -> None\nC++: virtual void SetRatio(double ratio)\n\n"},
  {"SetPolarArcResolutionPerDegree", PyvtkPolarAxesRepresentation_SetPolarArcResolutionPerDegree, METH_VARARGS,
   "SetPolarArcResolutionPerDegree(self, resolution:float) -> None\nC++: virtual void SetPolarArcResolutionPerDegree(\n    double resolution)\n\n"},
  {"SetDeltaRangeMinor", PyvtkPolarAxesRepresentation_SetDeltaRangeMinor, METH_VARARGS,
   "SetDeltaRangeMinor(self, delta:float) -> None\nC++: virtual void SetDeltaRangeMinor(double delta)\n\n"},
  {"SetDeltaRangeMajor", PyvtkPolarAxesRepresentation_SetDeltaRangeMajor, METH_VARARGS,
   "SetDeltaRangeMajor(self, delta:float) -> None\nC++: virtual void SetDeltaRangeMajor(double delta)\n\n"},
  {"SetRendererType", PyvtkPolarAxesRepresentation_SetRendererType, METH_VARARGS,
   "SetRendererType(self, _arg:int) -> None\nC++: virtual void SetRendererType(int _arg)\n\nSet the renderer to use. Default is to use the\nvtkPVRenderView::DEFAULT_RENDERER.\n"},
  {"GetRendererType", PyvtkPolarAxesRepresentation_GetRendererType, METH_VARARGS,
   "GetRendererType(self) -> int\nC++: virtual int GetRendererType()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPolarAxesRepresentation_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("position"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPolarAxesRepresentation_GetPosition(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetPosition(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetPosition(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPosition/SetPosition\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("orientation"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPolarAxesRepresentation_GetOrientation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetOrientation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetOrientation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOrientation/SetOrientation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("scale"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPolarAxesRepresentation_GetScale(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetScale(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetScale(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetScale/SetScale\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("custom_bounds"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPolarAxesRepresentation_GetCustomBounds(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetCustomBounds(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetCustomBounds(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetCustomBounds/SetCustomBounds\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("enable_custom_bounds"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPolarAxesRepresentation_GetEnableCustomBounds(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetEnableCustomBounds(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetEnableCustomBounds(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEnableCustomBounds/SetEnableCustomBounds\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("enable_custom_range"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPolarAxesRepresentation_GetEnableCustomRange(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetEnableCustomRange(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetEnableCustomRange(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEnableCustomRange/SetEnableCustomRange\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("custom_range"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPolarAxesRepresentation_GetCustomRange(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetCustomRange(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetCustomRange(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetCustomRange/SetCustomRange\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("enable_auto_pole"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPolarAxesRepresentation_GetEnableAutoPole(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetEnableAutoPole(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetEnableAutoPole(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEnableAutoPole/SetEnableAutoPole\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("enable_custom_angle"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPolarAxesRepresentation_GetEnableCustomAngle(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetEnableCustomAngle(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetEnableCustomAngle(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEnableCustomAngle/SetEnableCustomAngle\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("min_angle"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPolarAxesRepresentation_GetMinAngle(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetMinAngle(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetMinAngle(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMinAngle/SetMinAngle\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("max_angle"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPolarAxesRepresentation_GetMaxAngle(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetMaxAngle(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetMaxAngle(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMaxAngle/SetMaxAngle\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("enable_custom_radius"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPolarAxesRepresentation_GetEnableCustomRadius(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetEnableCustomRadius(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetEnableCustomRadius(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEnableCustomRadius/SetEnableCustomRadius\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("enable_custom_min_radius"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetEnableCustomMinRadius(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetEnableCustomMinRadius(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetEnableCustomMinRadius\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("min_radius"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPolarAxesRepresentation_GetMinRadius(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetMinRadius(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetMinRadius(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMinRadius/SetMinRadius\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("enable_custom_max_radius"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPolarAxesRepresentation_GetEnableCustomMaxRadius(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetEnableCustomMaxRadius(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetEnableCustomMaxRadius(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEnableCustomMaxRadius/SetEnableCustomMaxRadius\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("max_radius"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPolarAxesRepresentation_GetMaxRadius(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetMaxRadius(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetMaxRadius(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMaxRadius/SetMaxRadius\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("enable_overall_color"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPolarAxesRepresentation_GetEnableOverallColor(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetEnableOverallColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetEnableOverallColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEnableOverallColor/SetEnableOverallColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("overall_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetOverallColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetOverallColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetOverallColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("polar_axis_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetPolarAxisColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetPolarAxisColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPolarAxisColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("polar_arcs_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetPolarArcsColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetPolarArcsColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPolarArcsColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("secondary_polar_arcs_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetSecondaryPolarArcsColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetSecondaryPolarArcsColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSecondaryPolarArcsColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("secondary_radial_axes_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetSecondaryRadialAxesColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetSecondaryRadialAxesColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSecondaryRadialAxesColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("last_radial_axis_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetLastRadialAxisColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetLastRadialAxisColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLastRadialAxisColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("polar_axis_title_text_property"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetPolarAxisTitleTextProperty(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetPolarAxisTitleTextProperty(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPolarAxisTitleTextProperty\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("polar_axis_label_text_property"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetPolarAxisLabelTextProperty(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetPolarAxisLabelTextProperty(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPolarAxisLabelTextProperty\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("last_radial_axis_text_property"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetLastRadialAxisTextProperty(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetLastRadialAxisTextProperty(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLastRadialAxisTextProperty\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("secondary_radial_axes_text_property"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetSecondaryRadialAxesTextProperty(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetSecondaryRadialAxesTextProperty(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSecondaryRadialAxesTextProperty\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("parent_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetParentVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetParentVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetParentVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("log"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetLog(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetLog(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLog\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("delta_angle_radial_axes"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetDeltaAngleRadialAxes(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetDeltaAngleRadialAxes(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetDeltaAngleRadialAxes\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("delta_range_polar_axes"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetDeltaRangePolarAxes(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetDeltaRangePolarAxes(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetDeltaRangePolarAxes\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("smallest_visible_polar_angle"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetSmallestVisiblePolarAngle(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetSmallestVisiblePolarAngle(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSmallestVisiblePolarAngle\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("tick_location"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetTickLocation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetTickLocation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTickLocation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("radial_units"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetRadialUnits(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetRadialUnits(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRadialUnits\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("screen_size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetScreenSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetScreenSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetScreenSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("polar_axis_title"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetPolarAxisTitle(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetPolarAxisTitle(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPolarAxisTitle\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("polar_label_format"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetPolarLabelFormat(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetPolarLabelFormat(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPolarLabelFormat\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("exponent_location"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetExponentLocation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetExponentLocation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetExponentLocation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("radial_angle_format"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetRadialAngleFormat(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetRadialAngleFormat(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRadialAngleFormat\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("enable_distance_lod"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetEnableDistanceLOD(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetEnableDistanceLOD(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetEnableDistanceLOD\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("distance_lod_threshold"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetDistanceLODThreshold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetDistanceLODThreshold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetDistanceLODThreshold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("enable_view_angle_lod"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetEnableViewAngleLOD(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetEnableViewAngleLOD(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetEnableViewAngleLOD\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("view_angle_lod_threshold"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetViewAngleLODThreshold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetViewAngleLODThreshold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetViewAngleLODThreshold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("polar_axis_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetPolarAxisVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetPolarAxisVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPolarAxisVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("draw_radial_gridlines"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetDrawRadialGridlines(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetDrawRadialGridlines(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetDrawRadialGridlines\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("draw_polar_arcs_gridlines"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetDrawPolarArcsGridlines(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetDrawPolarArcsGridlines(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetDrawPolarArcsGridlines\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("polar_title_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetPolarTitleVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetPolarTitleVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPolarTitleVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("radial_axis_title_location"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetRadialAxisTitleLocation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetRadialAxisTitleLocation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRadialAxisTitleLocation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("polar_axis_title_location"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetPolarAxisTitleLocation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetPolarAxisTitleLocation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPolarAxisTitleLocation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("radial_title_offset"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetRadialTitleOffset(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetRadialTitleOffset(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRadialTitleOffset\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("polar_title_offset"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetPolarTitleOffset(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetPolarTitleOffset(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPolarTitleOffset\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("polar_label_offset"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetPolarLabelOffset(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetPolarLabelOffset(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPolarLabelOffset\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("polar_exponent_offset"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetPolarExponentOffset(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetPolarExponentOffset(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPolarExponentOffset\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("polar_label_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetPolarLabelVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetPolarLabelVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPolarLabelVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("arc_ticks_origin_to_polar_axis"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetArcTicksOriginToPolarAxis(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetArcTicksOriginToPolarAxis(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetArcTicksOriginToPolarAxis\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("radial_axes_origin_to_polar_axis"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetRadialAxesOriginToPolarAxis(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetRadialAxesOriginToPolarAxis(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRadialAxesOriginToPolarAxis\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("polar_tick_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetPolarTickVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetPolarTickVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPolarTickVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("axis_tick_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetAxisTickVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetAxisTickVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetAxisTickVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("axis_minor_tick_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetAxisMinorTickVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetAxisMinorTickVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetAxisMinorTickVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("axis_tick_matches_polar_axes"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetAxisTickMatchesPolarAxes(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetAxisTickMatchesPolarAxes(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetAxisTickMatchesPolarAxes\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("arc_tick_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetArcTickVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetArcTickVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetArcTickVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("arc_minor_tick_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetArcMinorTickVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetArcMinorTickVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetArcMinorTickVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("arc_tick_matches_radial_axes"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetArcTickMatchesRadialAxes(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetArcTickMatchesRadialAxes(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetArcTickMatchesRadialAxes\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("tick_ratio_radius_size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetTickRatioRadiusSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetTickRatioRadiusSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTickRatioRadiusSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("arc_major_tick_size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetArcMajorTickSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetArcMajorTickSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetArcMajorTickSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("polar_axis_major_tick_size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetPolarAxisMajorTickSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetPolarAxisMajorTickSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPolarAxisMajorTickSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("last_radial_axis_major_tick_size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetLastRadialAxisMajorTickSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetLastRadialAxisMajorTickSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLastRadialAxisMajorTickSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("polar_axis_tick_ratio_size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetPolarAxisTickRatioSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetPolarAxisTickRatioSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPolarAxisTickRatioSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("last_axis_tick_ratio_size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetLastAxisTickRatioSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetLastAxisTickRatioSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLastAxisTickRatioSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("arc_tick_ratio_size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetArcTickRatioSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetArcTickRatioSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetArcTickRatioSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("polar_axis_major_tick_thickness"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetPolarAxisMajorTickThickness(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetPolarAxisMajorTickThickness(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPolarAxisMajorTickThickness\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("last_radial_axis_major_tick_thickness"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetLastRadialAxisMajorTickThickness(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetLastRadialAxisMajorTickThickness(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLastRadialAxisMajorTickThickness\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("arc_major_tick_thickness"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetArcMajorTickThickness(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetArcMajorTickThickness(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetArcMajorTickThickness\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("polar_axis_tick_ratio_thickness"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetPolarAxisTickRatioThickness(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetPolarAxisTickRatioThickness(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPolarAxisTickRatioThickness\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("last_axis_tick_ratio_thickness"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetLastAxisTickRatioThickness(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetLastAxisTickRatioThickness(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLastAxisTickRatioThickness\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("arc_tick_ratio_thickness"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetArcTickRatioThickness(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetArcTickRatioThickness(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetArcTickRatioThickness\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("delta_angle_major"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetDeltaAngleMajor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetDeltaAngleMajor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetDeltaAngleMajor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("delta_angle_minor"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetDeltaAngleMinor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetDeltaAngleMinor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetDeltaAngleMinor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("radial_axes_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetRadialAxesVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetRadialAxesVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRadialAxesVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("radial_title_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetRadialTitleVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetRadialTitleVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRadialTitleVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("polar_arcs_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetPolarArcsVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetPolarArcsVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPolarArcsVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use2d_mode"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetUse2DMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetUse2DMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetUse2DMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("ratio"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetRatio(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetRatio(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRatio\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("polar_arc_resolution_per_degree"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetPolarArcResolutionPerDegree(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetPolarArcResolutionPerDegree(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPolarArcResolutionPerDegree\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("delta_range_minor"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetDeltaRangeMinor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetDeltaRangeMinor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetDeltaRangeMinor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("delta_range_major"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetDeltaRangeMajor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetDeltaRangeMajor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetDeltaRangeMajor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("renderer_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPolarAxesRepresentation_GetRendererType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetRendererType(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetRendererType(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRendererType/SetRendererType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("data_bounds"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPolarAxesRepresentation_GetDataBounds(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDataBounds\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("enable_custom_min_radius"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPolarAxesRepresentation_GetEnableCustomMinRadius(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetEnableCustomMinRadius\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_radial_axes"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetNumberOfRadialAxes(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetNumberOfRadialAxes(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetNumberOfRadialAxes\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_polar_axes"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPolarAxesRepresentation_SetNumberOfPolarAxes(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPolarAxesRepresentation_SetNumberOfPolarAxes(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetNumberOfPolarAxes\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPolarAxesRepresentation_Doc =
  "vtkPolarAxesRepresentation - representation for a polar-axes.\n\n"
  "Superclass: vtkPVDataRepresentation\n\n"
  "vtkPolarAxesRepresentation is a representation for the Polar-Axes\n"
  "that shows a bounding box with labels around any input dataset.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPolarAxesRepresentation_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkPolarAxesRepresentation", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPolarAxesRepresentation_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPolarAxesRepresentation_StaticNew()
{
  return vtkPolarAxesRepresentation::New();
}

PyObject *PyvtkPolarAxesRepresentation_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPolarAxesRepresentation_Type, PyvtkPolarAxesRepresentation_Methods,
    "vtkPolarAxesRepresentation",
 &PyvtkPolarAxesRepresentation_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkPVDataRepresentation_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPolarAxesRepresentation_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPolarAxesRepresentation(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPolarAxesRepresentation_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPolarAxesRepresentation", o) != 0)
  {
    Py_DECREF(o);
  }

}

