// python wrapper for vtkPVRenderingCapabilitiesInformation
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSmartPointer.h"
#include "vtkPVRenderingCapabilitiesInformation.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVRenderingCapabilitiesInformation(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVRenderingCapabilitiesInformation_ClassNew(); }

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVRenderingCapabilitiesInformation_CapabilitiesMask_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkPVRenderingCapabilitiesInformation.CapabilitiesMask", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkPVRenderingCapabilitiesInformation_CapabilitiesMask_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkPVRenderingCapabilitiesInformation_CapabilitiesMask_Type, static_cast<int>(val));
}


static PyObject *
PyvtkPVRenderingCapabilitiesInformation_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVRenderingCapabilitiesInformation::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderingCapabilitiesInformation_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderingCapabilitiesInformation *op = static_cast<vtkPVRenderingCapabilitiesInformation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVRenderingCapabilitiesInformation::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderingCapabilitiesInformation_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVRenderingCapabilitiesInformation *tempr = vtkPVRenderingCapabilitiesInformation::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderingCapabilitiesInformation_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderingCapabilitiesInformation *op = static_cast<vtkPVRenderingCapabilitiesInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVRenderingCapabilitiesInformation *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVRenderingCapabilitiesInformation::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderingCapabilitiesInformation_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVRenderingCapabilitiesInformation::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderingCapabilitiesInformation_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderingCapabilitiesInformation *op = static_cast<vtkPVRenderingCapabilitiesInformation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVRenderingCapabilitiesInformation::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderingCapabilitiesInformation_GetCapabilities(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCapabilities");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderingCapabilitiesInformation *op = static_cast<vtkPVRenderingCapabilitiesInformation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned int tempr = (ap.IsBound() ?
      op->GetCapabilities() :
      op->vtkPVRenderingCapabilitiesInformation::GetCapabilities());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderingCapabilitiesInformation_Supports_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Supports");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderingCapabilitiesInformation *op = static_cast<vtkPVRenderingCapabilitiesInformation *>(vp);

  unsigned int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->Supports(temp0) :
      op->vtkPVRenderingCapabilitiesInformation::Supports(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkPVRenderingCapabilitiesInformation_Supports_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "Supports");

  unsigned int temp0;
  unsigned int temp1;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    bool tempr = vtkPVRenderingCapabilitiesInformation::Supports(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkPVRenderingCapabilitiesInformation_Supports(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 1:
      return PyvtkPVRenderingCapabilitiesInformation_Supports_s1(self, args);
    case 2:
      return PyvtkPVRenderingCapabilitiesInformation_Supports_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "Supports");
  return nullptr;
}


static PyObject *
PyvtkPVRenderingCapabilitiesInformation_GetLocalCapabilities(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetLocalCapabilities");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    unsigned int tempr = vtkPVRenderingCapabilitiesInformation::GetLocalCapabilities();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderingCapabilitiesInformation_NewOffscreenRenderWindow(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "NewOffscreenRenderWindow");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkSmartPointer<vtkRenderWindow> tempr = vtkPVRenderingCapabilitiesInformation::NewOffscreenRenderWindow();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderingCapabilitiesInformation_CopyFromObject(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CopyFromObject");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderingCapabilitiesInformation *op = static_cast<vtkPVRenderingCapabilitiesInformation *>(vp);

  vtkObject *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObject"))
  {
    if (ap.IsBound())
    {
      op->CopyFromObject(temp0);
    }
    else
    {
      op->vtkPVRenderingCapabilitiesInformation::CopyFromObject(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVRenderingCapabilitiesInformation_AddInformation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddInformation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVRenderingCapabilitiesInformation *op = static_cast<vtkPVRenderingCapabilitiesInformation *>(vp);

  vtkPVInformation *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVInformation"))
  {
    if (ap.IsBound())
    {
      op->AddInformation(temp0);
    }
    else
    {
      op->vtkPVRenderingCapabilitiesInformation::AddInformation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkPVRenderingCapabilitiesInformation_Methods[] = {
  {"IsTypeOf", PyvtkPVRenderingCapabilitiesInformation_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVRenderingCapabilitiesInformation_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVRenderingCapabilitiesInformation_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase)\n    -> vtkPVRenderingCapabilitiesInformation\nC++: static vtkPVRenderingCapabilitiesInformation *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVRenderingCapabilitiesInformation_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVRenderingCapabilitiesInformation\nC++: vtkPVRenderingCapabilitiesInformation *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVRenderingCapabilitiesInformation_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVRenderingCapabilitiesInformation_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetCapabilities", PyvtkPVRenderingCapabilitiesInformation_GetCapabilities, METH_VARARGS,
   "GetCapabilities(self) -> int\nC++: virtual vtkTypeUInt32 GetCapabilities()\n\nReturns a 32-bit unsigned integer which represents the\ncapabilities. Use CapabilitiesMask to determine which\ncapabilities are supported by all the processes from which the\ninformation was gathered.\n"},
  {"Supports", PyvtkPVRenderingCapabilitiesInformation_Supports, METH_VARARGS,
   "Supports(self, capability:int) -> bool\nC++: bool Supports(vtkTypeUInt32 capability)\nSupports(capabilities:int, mask:int) -> bool\nC++: static bool Supports(vtkTypeUInt32 capabilities,\n    vtkTypeUInt32 mask)\n\nConvenience method to check is any of the requested capabilities\nare supported.\n"},
  {"GetLocalCapabilities", PyvtkPVRenderingCapabilitiesInformation_GetLocalCapabilities, METH_VARARGS,
   "GetLocalCapabilities() -> int\nC++: static vtkTypeUInt32 GetLocalCapabilities()\n\nReturn local process' capabilities.\n"},
  {"NewOffscreenRenderWindow", PyvtkPVRenderingCapabilitiesInformation_NewOffscreenRenderWindow, METH_VARARGS,
   "NewOffscreenRenderWindow() -> vtkRenderWindow\nC++: static vtkSmartPointer<vtkRenderWindow> NewOffscreenRenderWindow(\n    )\n\nThis creates an off-screen render window based on capabilities of\nthe local process. This is useful to query additional OpenGL\ninformation, for example.\n\nThis may create a non-mapped onscreen render window, if ParaView\nwas built with onscreen GL support) or headless off-screen render\nwindow, if ParaView was built with headless GL support (e.g. EGL\nor OSMesa). Headless is preferred, if available.\n\nNote the returned window hasn't been created yet, i.e. one may\nneed to call vtkRenderWindow::Render() on it before querying\nOpenGL information, for example.\n"},
  {"CopyFromObject", PyvtkPVRenderingCapabilitiesInformation_CopyFromObject, METH_VARARGS,
   "CopyFromObject(self, __a:vtkObject) -> None\nC++: void CopyFromObject(vtkObject *) override;\n\nTransfer information about a single object into this object.\n"},
  {"AddInformation", PyvtkPVRenderingCapabilitiesInformation_AddInformation, METH_VARARGS,
   "AddInformation(self, __a:vtkPVInformation) -> None\nC++: void AddInformation(vtkPVInformation *) override;\n\nMerge another information object.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVRenderingCapabilitiesInformation_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("capabilities"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderingCapabilitiesInformation_GetCapabilities(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetCapabilities\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("local_capabilities"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVRenderingCapabilitiesInformation_GetLocalCapabilities(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetLocalCapabilities\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVRenderingCapabilitiesInformation_Doc =
  "vtkPVRenderingCapabilitiesInformation - provides information about\nrendering capabilities.\n\n"
  "Superclass: vtkPVInformation\n\n"
;

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVRenderingCapabilitiesInformation_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkPVRenderingCapabilitiesInformation", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVRenderingCapabilitiesInformation_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVRenderingCapabilitiesInformation_StaticNew()
{
  return vtkPVRenderingCapabilitiesInformation::New();
}

PyObject *PyvtkPVRenderingCapabilitiesInformation_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVRenderingCapabilitiesInformation_Type, PyvtkPVRenderingCapabilitiesInformation_Methods,
    "vtkPVRenderingCapabilitiesInformation",
 &PyvtkPVRenderingCapabilitiesInformation_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkPVInformation");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyvtkPVRenderingCapabilitiesInformation_CapabilitiesMask_Type);
  PyVTKEnum_Add(&PyvtkPVRenderingCapabilitiesInformation_CapabilitiesMask_Type, "vtkPVRenderingCapabilitiesInformation.CapabilitiesMask");

  o = (PyObject *)&PyvtkPVRenderingCapabilitiesInformation_CapabilitiesMask_Type;
  if (PyDict_SetItemString(d, "CapabilitiesMask", o) != 0)
  {
    Py_DECREF(o);
  }

  for (int c = 0; c < 7; c++)
  {
    typedef vtkPVRenderingCapabilitiesInformation::CapabilitiesMask cxx_enum_type;

    static const struct { const char *name; cxx_enum_type value; }
      constants[7] = {
        { "NONE", vtkPVRenderingCapabilitiesInformation::NONE },
        { "ONSCREEN_RENDERING", vtkPVRenderingCapabilitiesInformation::ONSCREEN_RENDERING },
        { "HEADLESS_RENDERING_USES_OSMESA", vtkPVRenderingCapabilitiesInformation::HEADLESS_RENDERING_USES_OSMESA },
        { "HEADLESS_RENDERING_USES_EGL", vtkPVRenderingCapabilitiesInformation::HEADLESS_RENDERING_USES_EGL },
        { "HEADLESS_RENDERING", vtkPVRenderingCapabilitiesInformation::HEADLESS_RENDERING },
        { "RENDERING", vtkPVRenderingCapabilitiesInformation::RENDERING },
        { "OPENGL", vtkPVRenderingCapabilitiesInformation::OPENGL },
      };

    o = PyvtkPVRenderingCapabilitiesInformation_CapabilitiesMask_FromEnum(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVRenderingCapabilitiesInformation_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVRenderingCapabilitiesInformation(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVRenderingCapabilitiesInformation_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVRenderingCapabilitiesInformation", o) != 0)
  {
    Py_DECREF(o);
  }

}

