#include "nv_push_cl91c0.h"

#include <stdio.h>





const char *P_PARSE_NV90C0_MTHD(uint16_t idx) ATTRIBUTE_COLD;
void P_DUMP_NV90C0_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                                   const char *prefix) ATTRIBUTE_COLD;

const char*
P_PARSE_NV91C0_MTHD(uint16_t idx)
{
    switch (idx) {

  
    default:

    return P_PARSE_NV90C0_MTHD(idx);

                                                                                                                        case NV91C0_SET_CTA_RASTER_SIZE_B:
        return "NV91C0_SET_CTA_RASTER_SIZE_B";
                                            case NV91C0_SET_TEX_HEADER_EXTENDED_DIMENSIONS:
        return "NV91C0_SET_TEX_HEADER_EXTENDED_DIMENSIONS";
    case NV91C0_SET_L1_CONFIGURATION:
        return "NV91C0_SET_L1_CONFIGURATION";
        case NV91C0_WAIT_REF_COUNT:
        return "NV91C0_WAIT_REF_COUNT";
    case NV91C0_SET_LAUNCH_ID:
        return "NV91C0_SET_LAUNCH_ID";
                                                                                                                                                                                                                                                                                                                                                                    case NV91C0_SET_SHADER_CONTROL:
        return "NV91C0_SET_SHADER_CONTROL";
                                                                                                                                
    }
}

void
P_DUMP_NV91C0_MTHD_DATA(FILE *fp, uint16_t idx, uint32_t data,
                         const char *prefix)
{
    UNUSED uint32_t parsed;
    switch (idx) {

  
    default:

    P_DUMP_NV90C0_MTHD_DATA(fp, idx, data, prefix);
    break;

                                                                                                                      
    case NV91C0_SET_CTA_RASTER_SIZE_B:

    
        parsed = (data >> 0) & ((1u << 16) - 1);
        fprintf(fp, "%s.DEPTH = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 16) & ((1u << 16) - 1);
        fprintf(fp, "%s.WIDTH_UPPER = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                                          
    case NV91C0_SET_TEX_HEADER_EXTENDED_DIMENSIONS:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.ENABLE = ", prefix);
        switch (parsed) {
        case NV91C0_SET_TEX_HEADER_EXTENDED_DIMENSIONS_ENABLE_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NV91C0_SET_TEX_HEADER_EXTENDED_DIMENSIONS_ENABLE_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
  
    case NV91C0_SET_L1_CONFIGURATION:

    
        parsed = (data >> 0) & ((1u << 3) - 1);
        fprintf(fp, "%s.DIRECTLY_ADDRESSABLE_MEMORY = ", prefix);
        switch (parsed) {
        case NV91C0_SET_L1_CONFIGURATION_DIRECTLY_ADDRESSABLE_MEMORY_SIZE_16KB:
            fprintf(fp, "SIZE_16KB\n");
            break;
        case NV91C0_SET_L1_CONFIGURATION_DIRECTLY_ADDRESSABLE_MEMORY_SIZE_32KB:
            fprintf(fp, "SIZE_32KB\n");
            break;
        case NV91C0_SET_L1_CONFIGURATION_DIRECTLY_ADDRESSABLE_MEMORY_SIZE_48KB:
            fprintf(fp, "SIZE_48KB\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
      
    case NV91C0_WAIT_REF_COUNT:

    
        parsed = (data >> 8) & ((1u << 4) - 1);
        fprintf(fp, "%s.REF_CNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.FLUSH_SYS_MEM = ", prefix);
        switch (parsed) {
        case NV91C0_WAIT_REF_COUNT_FLUSH_SYS_MEM_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NV91C0_WAIT_REF_COUNT_FLUSH_SYS_MEM_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
  
    case NV91C0_SET_LAUNCH_ID:

    
        parsed = (data >> 0) & ((1u << 4) - 1);
        fprintf(fp, "%s.REF_CNT = ", prefix);
        fprintf(fp, "(0x%x)\n", parsed);
        break;
                                                                                                                                                                                                                                                                                                                                                                  
    case NV91C0_SET_SHADER_CONTROL:

    
        parsed = (data >> 0) & ((1u << 1) - 1);
        fprintf(fp, "%s.DEFAULT_PARTIAL = ", prefix);
        switch (parsed) {
        case NV91C0_SET_SHADER_CONTROL_DEFAULT_PARTIAL_ZERO:
            fprintf(fp, "ZERO\n");
            break;
        case NV91C0_SET_SHADER_CONTROL_DEFAULT_PARTIAL_INFINITY:
            fprintf(fp, "INFINITY\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 16) & ((1u << 1) - 1);
        fprintf(fp, "%s.ZERO_TIMES_ANYTHING_IS_ZERO = ", prefix);
        switch (parsed) {
        case NV91C0_SET_SHADER_CONTROL_ZERO_TIMES_ANYTHING_IS_ZERO_FALSE:
            fprintf(fp, "FALSE\n");
            break;
        case NV91C0_SET_SHADER_CONTROL_ZERO_TIMES_ANYTHING_IS_ZERO_TRUE:
            fprintf(fp, "TRUE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 1) & ((1u << 1) - 1);
        fprintf(fp, "%s.FP32_NAN_BEHAVIOR = ", prefix);
        switch (parsed) {
        case NV91C0_SET_SHADER_CONTROL_FP32_NAN_BEHAVIOR_LEGACY:
            fprintf(fp, "LEGACY\n");
            break;
        case NV91C0_SET_SHADER_CONTROL_FP32_NAN_BEHAVIOR_FP64_COMPATIBLE:
            fprintf(fp, "FP64_COMPATIBLE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
    
        parsed = (data >> 2) & ((1u << 1) - 1);
        fprintf(fp, "%s.FP32_F2I_NAN_BEHAVIOR = ", prefix);
        switch (parsed) {
        case NV91C0_SET_SHADER_CONTROL_FP32_F2I_NAN_BEHAVIOR_PASS_ZERO:
            fprintf(fp, "PASS_ZERO\n");
            break;
        case NV91C0_SET_SHADER_CONTROL_FP32_F2I_NAN_BEHAVIOR_PASS_INDEFINITE:
            fprintf(fp, "PASS_INDEFINITE\n");
            break;
        default:
            fprintf(fp, "0x%x\n", parsed);
            break;
        }
        break;
                                                                                                                                    }
}
