/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 2

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 11 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"

#include <cstring>
#include <cctype>
#include <cstdlib>
#include <clocale>
#include <cmath>
#include <vector>
#include <memory>
#include <sstream>
#include <iostream>
#include <charconv>
#ifdef HAVE_XLOCALE
#include <xlocale.h>
#endif
#include "Parser.h"
#include "ParserDeclarations.h"
#include "parser_private.h"
#include "constants.h"
#include "functions.h"
#if defined(_WIN32)
#define locale_t _locale_t
#define strtod_l _strtod_l
#define freelocale _free_locale
#endif

#include <gsl/gsl_sf_gamma.h>
#define YYERROR_VERBOSE 1

#line 100 "/build/labplot/src/build/lib/gsl_parser.cpp"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "gsl_parser.hpp"
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_NUM = 3,                        /* NUM  */
  YYSYMBOL_VAR = 4,                        /* VAR  */
  YYSYMBOL_FNCT = 5,                       /* FNCT  */
  YYSYMBOL_SPECFNCT = 6,                   /* SPECFNCT  */
  YYSYMBOL_OR = 7,                         /* "||"  */
  YYSYMBOL_AND = 8,                        /* "&&"  */
  YYSYMBOL_LE = 9,                         /* "<="  */
  YYSYMBOL_GE = 10,                        /* ">="  */
  YYSYMBOL_11_ = 11,                       /* '='  */
  YYSYMBOL_12_ = 12,                       /* '-'  */
  YYSYMBOL_13_ = 13,                       /* '+'  */
  YYSYMBOL_14_ = 14,                       /* '<'  */
  YYSYMBOL_15_ = 15,                       /* '>'  */
  YYSYMBOL_16_ = 16,                       /* '*'  */
  YYSYMBOL_17_ = 17,                       /* '/'  */
  YYSYMBOL_18_ = 18,                       /* '%'  */
  YYSYMBOL_NEG = 19,                       /* NEG  */
  YYSYMBOL_20_ = 20,                       /* '^'  */
  YYSYMBOL_21_ = 21,                       /* '!'  */
  YYSYMBOL_22_ = 22,                       /* '('  */
  YYSYMBOL_23_ = 23,                       /* ')'  */
  YYSYMBOL_24_ = 24,                       /* ';'  */
  YYSYMBOL_25_ = 25,                       /* ','  */
  YYSYMBOL_26_ = 26,                       /* '|'  */
  YYSYMBOL_YYACCEPT = 27,                  /* $accept  */
  YYSYMBOL_input = 28,                     /* input  */
  YYSYMBOL_line = 29,                      /* line  */
  YYSYMBOL_expr = 30                       /* expr  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;


/* Second part of user prologue.  */
#line 45 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"


namespace Parsing {
	struct param;
        int yylex(YYSTYPE* yyval, param *p);
} // Parser

namespace {
        static int wrongArgumentNumberMessage(Parsing::param* p, const std::string_view& function_name, int provided, int expected) {
                std::stringstream ss;
                ss << "Internal parsing Error: Wrong argument count for '" << function_name << "'. Provided: " << provided << ", Expected: " << expected;
                p->errorCount++;
                p->parser->setLastErrorMessage(ss.str());
                return 1;
	}

        static int wrongArgumentInternalErrorMessage(Parsing::param* p, const std::string_view& function_name, int expected) {
                std::stringstream ss;
                ss << "Internal parsing Error: Wrong argument count for '" << function_name << "'. Expected: " << expected << ", but function does not have this number of arguments";
                p->errorCount++;
                p->parser->setLastErrorMessage(ss.str());
                return 1;
        }

        static int notImplementedError(Parsing::param* p, const std::string_view& function_name) {
                std::stringstream ss;
                ss << "Parsing Error: '" << function_name << "' not implemented.";
                p->errorCount++;
                p->parser->setLastErrorMessage(ss.str());
                return 2;
	}

        static int yyerrorFunction(Parsing::param* p, const std::string_view& function_name, const char* msg) {
                std::stringstream ss;
                ss << "Parsing Error: In function '" << function_name << "': " << msg;
                p->errorCount++;
                p->parser->setLastErrorMessage(ss.str());
                return 1;
	}

        int yyerror(Parsing::param* p, const char* msg) {
                std::stringstream ss;
                ss << "Parsing Error: " << msg;
                p->errorCount++;
                p->parser->setLastErrorMessage(ss.str());
                return 0; // must be zero, because it indicates EOF
	}

    template<typename FunctionType, typename Symbol, typename OutType, typename ...Args>
    int evaluateFunctionPayload(Parsing::param* p, int numArguments, Symbol* s, OutType& out, Args... args) {
        const auto& special_function = std::get<Parsing::special_function_def>(s->value);
        if (!special_function.payload.expired() && !special_function.payload.lock()->constant)
                p->variablesCounter++;
        const int argc = special_function.funsptr->argc;
        if (argc != numArguments) {
                return wrongArgumentNumberMessage(p, s->name, argc, numArguments);
        }
        try {
                const auto function = std::get<FunctionType>(special_function.funsptr->fnct);
                if (!p->parser->skipSpecialFunctionEvaluation()) {
                        if (function == nullptr) {
                                return notImplementedError(p, s->name);
                        }
                        out = function(args..., special_function.payload);
                } else
                        out = std::nan("0");
        } catch (const std::bad_variant_access& ex) {
                return wrongArgumentInternalErrorMessage(p, s->name, numArguments);
        }
        return 0;
    }

    template<typename FunctionType, typename Symbol, typename OutType, typename ...Args>
    int evaluateFunction(Parsing::param* p, int numArguments, Symbol* s, OutType& out, Args... args) {
        const auto* function = std::get<Parsing::funs*>(s->value);
        const int argc = function->argc;
        if (argc != numArguments) {
                return wrongArgumentNumberMessage(p, s->name, argc, numArguments);
        } else {
                try {
                        const auto fnct_ptr = std::get<FunctionType>(function->fnct);
                        out = fnct_ptr(args...);
                } catch (const std::bad_variant_access& ex) {
                        return wrongArgumentInternalErrorMessage(p, s->name, numArguments);
                }
        }
        return 0;
    }
} // anonymous namespace


#line 256 "/build/labplot/src/build/lib/gsl_parser.cpp"


#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int8 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if !defined yyoverflow

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* !defined yyoverflow */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  2
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   451

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  27
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  4
/* YYNRULES -- Number of rules.  */
#define YYNRULES  45
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  97

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   266


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    21,     2,     2,     2,    18,     2,     2,
      22,    23,    16,    13,    25,    12,     2,    17,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,    24,
      14,    11,    15,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,    20,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,    26,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    19
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   160,   160,   161,   164,   165,   166,   169,   170,   171,
     172,   178,   184,   190,   196,   202,   207,   212,   213,   215,
     221,   227,   233,   238,   244,   250,   255,   260,   265,   266,
     267,   268,   269,   270,   271,   272,   273,   274,   275,   276,
     277,   278,   279,   280,   281,   282
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if YYDEBUG || 0
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "NUM", "VAR", "FNCT",
  "SPECFNCT", "\"||\"", "\"&&\"", "\"<=\"", "\">=\"", "'='", "'-'", "'+'",
  "'<'", "'>'", "'*'", "'/'", "'%'", "NEG", "'^'", "'!'", "'('", "')'",
  "';'", "','", "'|'", "$accept", "input", "line", "expr", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-17)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-1)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
     -17,    27,   -17,     6,   -17,    -1,   -11,   -10,   112,   112,
     112,   112,   -17,   167,   -17,   112,    64,    76,   -16,   -16,
     362,   182,   -17,   112,   112,   112,   112,   112,   112,   112,
     112,    88,   112,   112,   112,   -17,   430,   -17,   197,    18,
     -17,   254,   -17,   -17,    39,   -16,    39,    39,    39,    39,
      39,    39,   112,   -16,   -16,   -16,   -16,   -17,   112,   112,
     -17,   -17,   123,   -16,   272,   216,    23,   290,   -17,   112,
     -17,   112,   -17,   -17,   136,   308,   235,    29,   326,   -17,
     112,   -17,   112,   -17,   -17,   147,   344,   379,    73,   396,
     -17,   112,   -17,   -17,   -17,   413,   -17
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int8 yydefact[] =
{
       2,     0,     4,     0,     7,     8,     0,     0,     0,     0,
       0,     0,     3,     0,     6,     0,     0,     0,    40,    35,
       0,     0,     5,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    45,     9,    19,     0,     8,
      10,     0,    43,    44,    30,    34,    37,    36,    29,    28,
      39,    38,     0,    31,    32,    33,    41,    20,     0,     0,
      11,    12,     0,    42,     0,     0,     8,     0,    24,     0,
      21,     0,    14,    13,     0,     0,     0,     8,     0,    25,
       0,    22,     0,    15,    17,     0,     0,     0,     8,     0,
      26,     0,    23,    16,    18,     0,    27
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int8 yypgoto[] =
{
     -17,   -17,   -17,    -8
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int8 yydefgoto[] =
{
       0,     1,    12,    13
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int8 yytable[] =
{
      18,    19,    20,    21,    34,    35,    14,    36,    38,    41,
      15,    16,    17,     0,     0,    44,    45,    46,    47,    48,
      49,    50,    51,    53,    54,    55,    56,     2,     3,    15,
       4,     5,     6,     7,    15,     0,     0,     0,     0,     8,
      15,    60,     0,     0,    63,     0,    72,    24,     9,    10,
      64,    65,    83,    11,    67,    31,    32,    33,     0,    34,
      35,    75,     0,    76,     0,     0,    78,     4,     5,     6,
       7,     0,    86,     0,    87,     0,     8,    89,     0,     4,
      39,     6,     7,    95,    15,     9,    10,    37,     8,     0,
      11,     4,     5,     6,     7,     0,    93,     9,    10,    40,
       8,     0,    11,     0,    52,     0,     0,     0,     0,     9,
      10,     0,     0,     0,    11,     4,     5,     6,     7,     0,
       0,     0,     0,     0,     8,     0,     4,    66,     6,     7,
       0,     0,     0,     9,    10,     8,     0,     0,    11,     4,
      77,     6,     7,     0,     9,    10,     0,     0,     8,    11,
       4,    88,     6,     7,     0,     0,     0,     9,    10,     8,
       0,     0,    11,     0,     0,     0,     0,    22,     9,    10,
       0,     0,     0,    11,    23,    24,    25,    26,     0,    27,
      28,    29,    30,    31,    32,    33,     0,    34,    35,    23,
      24,    25,    26,     0,    27,    28,    29,    30,    31,    32,
      33,     0,    34,    35,    23,    24,    25,    26,    43,    27,
      28,    29,    30,    31,    32,    33,     0,    34,    35,     0,
      57,    58,    59,    23,    24,    25,    26,     0,    27,    28,
      29,    30,    31,    32,    33,     0,    34,    35,     0,    70,
       0,    71,    23,    24,    25,    26,     0,    27,    28,    29,
      30,    31,    32,    33,     0,    34,    35,     0,    81,     0,
      82,    23,    24,    25,    26,     0,    27,    28,    29,    30,
      31,    32,    33,     0,    34,    35,     0,    61,    62,    23,
      24,    25,    26,     0,    27,    28,    29,    30,    31,    32,
      33,     0,    34,    35,     0,    68,    69,    23,    24,    25,
      26,     0,    27,    28,    29,    30,    31,    32,    33,     0,
      34,    35,     0,    73,    74,    23,    24,    25,    26,     0,
      27,    28,    29,    30,    31,    32,    33,     0,    34,    35,
       0,    79,    80,    23,    24,    25,    26,     0,    27,    28,
      29,    30,    31,    32,    33,     0,    34,    35,     0,    84,
      85,    23,    24,    25,    26,     0,    27,    28,    29,    30,
      31,    32,    33,     0,    34,    35,     0,    90,    91,    23,
      24,    25,    26,     0,    27,    28,    29,    30,    31,    32,
      33,     0,    34,    35,     0,    42,    23,    24,    25,    26,
       0,    27,    28,    29,    30,    31,    32,    33,     0,    34,
      35,     0,    92,    23,    24,    25,    26,     0,    27,    28,
      29,    30,    31,    32,    33,     0,    34,    35,     0,    94,
      23,    24,    25,    26,     0,    27,    28,    29,    30,    31,
      32,    33,     0,    34,    35,     0,    96,    23,    24,    25,
      26,     0,    27,    28,    29,    30,    31,    32,    33,     0,
      34,    35
};

static const yytype_int8 yycheck[] =
{
       8,     9,    10,    11,    20,    21,     0,    15,    16,    17,
      11,    22,    22,    -1,    -1,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,     0,     1,    11,
       3,     4,     5,     6,    11,    -1,    -1,    -1,    -1,    12,
      11,    23,    -1,    -1,    52,    -1,    23,     8,    21,    22,
      58,    59,    23,    26,    62,    16,    17,    18,    -1,    20,
      21,    69,    -1,    71,    -1,    -1,    74,     3,     4,     5,
       6,    -1,    80,    -1,    82,    -1,    12,    85,    -1,     3,
       4,     5,     6,    91,    11,    21,    22,    23,    12,    -1,
      26,     3,     4,     5,     6,    -1,    23,    21,    22,    23,
      12,    -1,    26,    -1,    16,    -1,    -1,    -1,    -1,    21,
      22,    -1,    -1,    -1,    26,     3,     4,     5,     6,    -1,
      -1,    -1,    -1,    -1,    12,    -1,     3,     4,     5,     6,
      -1,    -1,    -1,    21,    22,    12,    -1,    -1,    26,     3,
       4,     5,     6,    -1,    21,    22,    -1,    -1,    12,    26,
       3,     4,     5,     6,    -1,    -1,    -1,    21,    22,    12,
      -1,    -1,    26,    -1,    -1,    -1,    -1,     0,    21,    22,
      -1,    -1,    -1,    26,     7,     8,     9,    10,    -1,    12,
      13,    14,    15,    16,    17,    18,    -1,    20,    21,     7,
       8,     9,    10,    -1,    12,    13,    14,    15,    16,    17,
      18,    -1,    20,    21,     7,     8,     9,    10,    26,    12,
      13,    14,    15,    16,    17,    18,    -1,    20,    21,    -1,
      23,    24,    25,     7,     8,     9,    10,    -1,    12,    13,
      14,    15,    16,    17,    18,    -1,    20,    21,    -1,    23,
      -1,    25,     7,     8,     9,    10,    -1,    12,    13,    14,
      15,    16,    17,    18,    -1,    20,    21,    -1,    23,    -1,
      25,     7,     8,     9,    10,    -1,    12,    13,    14,    15,
      16,    17,    18,    -1,    20,    21,    -1,    23,    24,     7,
       8,     9,    10,    -1,    12,    13,    14,    15,    16,    17,
      18,    -1,    20,    21,    -1,    23,    24,     7,     8,     9,
      10,    -1,    12,    13,    14,    15,    16,    17,    18,    -1,
      20,    21,    -1,    23,    24,     7,     8,     9,    10,    -1,
      12,    13,    14,    15,    16,    17,    18,    -1,    20,    21,
      -1,    23,    24,     7,     8,     9,    10,    -1,    12,    13,
      14,    15,    16,    17,    18,    -1,    20,    21,    -1,    23,
      24,     7,     8,     9,    10,    -1,    12,    13,    14,    15,
      16,    17,    18,    -1,    20,    21,    -1,    23,    24,     7,
       8,     9,    10,    -1,    12,    13,    14,    15,    16,    17,
      18,    -1,    20,    21,    -1,    23,     7,     8,     9,    10,
      -1,    12,    13,    14,    15,    16,    17,    18,    -1,    20,
      21,    -1,    23,     7,     8,     9,    10,    -1,    12,    13,
      14,    15,    16,    17,    18,    -1,    20,    21,    -1,    23,
       7,     8,     9,    10,    -1,    12,    13,    14,    15,    16,
      17,    18,    -1,    20,    21,    -1,    23,     7,     8,     9,
      10,    -1,    12,    13,    14,    15,    16,    17,    18,    -1,
      20,    21
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int8 yystos[] =
{
       0,    28,     0,     1,     3,     4,     5,     6,    12,    21,
      22,    26,    29,    30,     0,    11,    22,    22,    30,    30,
      30,    30,     0,     7,     8,     9,    10,    12,    13,    14,
      15,    16,    17,    18,    20,    21,    30,    23,    30,     4,
      23,    30,    23,    26,    30,    30,    30,    30,    30,    30,
      30,    30,    16,    30,    30,    30,    30,    23,    24,    25,
      23,    23,    24,    30,    30,    30,     4,    30,    23,    24,
      23,    25,    23,    23,    24,    30,    30,     4,    30,    23,
      24,    23,    25,    23,    23,    24,    30,    30,     4,    30,
      23,    24,    23,    23,    23,    30,    23
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr1[] =
{
       0,    27,    28,    28,    29,    29,    29,    30,    30,    30,
      30,    30,    30,    30,    30,    30,    30,    30,    30,    30,
      30,    30,    30,    30,    30,    30,    30,    30,    30,    30,
      30,    30,    30,    30,    30,    30,    30,    30,    30,    30,
      30,    30,    30,    30,    30,    30
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     0,     2,     1,     2,     2,     1,     1,     3,
       3,     4,     4,     6,     6,     8,    10,     8,    10,     3,
       4,     6,     8,    10,     6,     8,    10,    12,     3,     3,
       3,     3,     3,     3,     3,     2,     3,     3,     3,     3,
       2,     3,     4,     3,     3,     2
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (p, YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value, p); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, Parsing::param *p)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  YY_USE (p);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, Parsing::param *p)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep, p);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule, Parsing::param *p)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)], p);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule, p); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif






/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep, Parsing::param *p)
{
  YY_USE (yyvaluep);
  YY_USE (p);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}






/*----------.
| yyparse.  |
`----------*/

int
yyparse (Parsing::param *p)
{
/* Lookahead token kind.  */
int yychar;


/* The semantic value of the lookahead symbol.  */
/* Default value used for initialization, for pacifying older GCCs
   or non-GCC compilers.  */
YY_INITIAL_VALUE (static YYSTYPE yyval_default;)
YYSTYPE yylval YY_INITIAL_VALUE (= yyval_default);

    /* Number of syntax errors so far.  */
    int yynerrs = 0;

    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex (&yylval, p);
    }

  if (yychar <= T_EOF)
    {
      yychar = T_EOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 5: /* line: expr "end of file"  */
#line 165 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"
                       { p->result = (yyvsp[-1].dval); }
#line 1337 "/build/labplot/src/build/lib/gsl_parser.cpp"
    break;

  case 6: /* line: error "end of file"  */
#line 166 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"
                      { yyerrok; }
#line 1343 "/build/labplot/src/build/lib/gsl_parser.cpp"
    break;

  case 7: /* expr: NUM  */
#line 169 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"
                     { (yyval.dval) = (yyvsp[0].dval);                            }
#line 1349 "/build/labplot/src/build/lib/gsl_parser.cpp"
    break;

  case 8: /* expr: VAR  */
#line 170 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"
                     { (yyval.dval) = std::get<double>((yyvsp[0].tptr)->value); p->variablesCounter++;}
#line 1355 "/build/labplot/src/build/lib/gsl_parser.cpp"
    break;

  case 9: /* expr: VAR '=' expr  */
#line 171 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"
                     { (yyval.dval) = std::get<double>((yyvsp[-2].tptr)->value) = (yyvsp[0].dval); p->variablesCounter++;       }
#line 1361 "/build/labplot/src/build/lib/gsl_parser.cpp"
    break;

  case 10: /* expr: SPECFNCT '(' ')'  */
#line 172 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"
                         {
                                const auto res = evaluateFunctionPayload<Parsing::func_tPayload>(p, 0, (yyvsp[-2].tptr), (yyval.dval));
                                if (res != 0)
                                    return res;
                        }
#line 1371 "/build/labplot/src/build/lib/gsl_parser.cpp"
    break;

  case 11: /* expr: SPECFNCT '(' VAR ')'  */
#line 178 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"
                        {
                                const auto res = evaluateFunctionPayload<Parsing::func_tVariablePayload>(p, 1, (yyvsp[-3].tptr), (yyval.dval), (yyvsp[-1].tptr)->name);
                                if (res != 0)
                                    return res;
                        }
#line 1381 "/build/labplot/src/build/lib/gsl_parser.cpp"
    break;

  case 12: /* expr: SPECFNCT '(' expr ')'  */
#line 184 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"
                         {
                                const auto res = evaluateFunctionPayload<Parsing::func_tValuePayload>(p, 1, (yyvsp[-3].tptr), (yyval.dval), (yyvsp[-1].dval));
                                if (res != 0)
                                    return res;
                        }
#line 1391 "/build/labplot/src/build/lib/gsl_parser.cpp"
    break;

  case 13: /* expr: SPECFNCT '(' expr ';' expr ')'  */
#line 190 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"
                                  {
                                            const auto res = evaluateFunctionPayload<Parsing::func_t2ValuePayload>(p, 2, (yyvsp[-5].tptr), (yyval.dval), (yyvsp[-3].dval), (yyvsp[-1].dval));
                                            if (res != 0)
                                                return res;
                                    }
#line 1401 "/build/labplot/src/build/lib/gsl_parser.cpp"
    break;

  case 14: /* expr: SPECFNCT '(' expr ';' VAR ')'  */
#line 196 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"
                                 {
                                    const auto res = evaluateFunctionPayload<Parsing::func_tValueVariablePayload>(p, 2, (yyvsp[-5].tptr), (yyval.dval), (yyvsp[-3].dval), (yyvsp[-1].tptr)->name);
                                    if (res != 0)
                                        return res;
                                }
#line 1411 "/build/labplot/src/build/lib/gsl_parser.cpp"
    break;

  case 15: /* expr: SPECFNCT '(' expr ';' expr ';' VAR ')'  */
#line 202 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"
                                          {
                                                const auto res = evaluateFunctionPayload<Parsing::func_t2ValueVariablePayload>(p, 3, (yyvsp[-7].tptr), (yyval.dval), (yyvsp[-5].dval), (yyvsp[-3].dval), (yyvsp[-1].tptr)->name);
                                                if (res != 0)
                                                    return res;
                                          }
#line 1421 "/build/labplot/src/build/lib/gsl_parser.cpp"
    break;

  case 16: /* expr: SPECFNCT '(' expr ';' expr ';' expr ';' VAR ')'  */
#line 207 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"
                                                   {
                                                        const auto res = evaluateFunctionPayload<Parsing::func_t3ValueVariablePayload>(p, 4, (yyvsp[-9].tptr), (yyval.dval), (yyvsp[-7].dval), (yyvsp[-5].dval), (yyvsp[-3].dval), (yyvsp[-1].tptr)->name);
                                                        if (res != 0)
                                                            return res;
                                                    }
#line 1431 "/build/labplot/src/build/lib/gsl_parser.cpp"
    break;

  case 17: /* expr: SPECFNCT '(' expr ';' expr ';' expr ')'  */
#line 212 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"
                                           { yyerrorFunction(p, (yyvsp[-7].tptr)->name, "Last argument must be a variable not an expression");}
#line 1437 "/build/labplot/src/build/lib/gsl_parser.cpp"
    break;

  case 18: /* expr: SPECFNCT '(' expr ';' expr ';' expr ';' expr ')'  */
#line 213 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"
                                                    { yyerrorFunction(p, (yyvsp[-9].tptr)->name, "Last argument must be a variable not an expression");}
#line 1443 "/build/labplot/src/build/lib/gsl_parser.cpp"
    break;

  case 19: /* expr: FNCT '(' ')'  */
#line 215 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"
                    {
                        const auto res = evaluateFunction<Parsing::func_t>(p, 0, (yyvsp[-2].tptr), (yyval.dval));
                        if (res != 0)
                            return res;
                    }
#line 1453 "/build/labplot/src/build/lib/gsl_parser.cpp"
    break;

  case 20: /* expr: FNCT '(' expr ')'  */
#line 221 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"
                     {
                        const auto res = evaluateFunction<Parsing::func_t1>(p, 1, (yyvsp[-3].tptr), (yyval.dval), (yyvsp[-1].dval));
                        if (res != 0)
                            return res;
                    }
#line 1463 "/build/labplot/src/build/lib/gsl_parser.cpp"
    break;

  case 21: /* expr: FNCT '(' expr ',' expr ')'  */
#line 227 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"
                              {
                                const auto res = evaluateFunction<Parsing::func_t2>(p, 2, (yyvsp[-5].tptr), (yyval.dval), (yyvsp[-3].dval), (yyvsp[-1].dval));
                                if (res != 0)
                                    return res;
                            }
#line 1473 "/build/labplot/src/build/lib/gsl_parser.cpp"
    break;

  case 22: /* expr: FNCT '(' expr ',' expr ',' expr ')'  */
#line 233 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"
                                       {
                                            const auto res = evaluateFunction<Parsing::func_t3>(p, 3, (yyvsp[-7].tptr), (yyval.dval), (yyvsp[-5].dval), (yyvsp[-3].dval), (yyvsp[-1].dval));
                                            if (res != 0)
                                                return res;
                                        }
#line 1483 "/build/labplot/src/build/lib/gsl_parser.cpp"
    break;

  case 23: /* expr: FNCT '(' expr ',' expr ',' expr ',' expr ')'  */
#line 238 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"
                                                {
                                                const auto res = evaluateFunction<Parsing::func_t4>(p, 4, (yyvsp[-9].tptr), (yyval.dval), (yyvsp[-7].dval), (yyvsp[-5].dval), (yyvsp[-3].dval), (yyvsp[-1].dval));
                                                if (res != 0)
                                                    return res;
                                                }
#line 1493 "/build/labplot/src/build/lib/gsl_parser.cpp"
    break;

  case 24: /* expr: FNCT '(' expr ';' expr ')'  */
#line 244 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"
                              {
                                    const auto res = evaluateFunction<Parsing::func_t2>(p, 2, (yyvsp[-5].tptr), (yyval.dval), (yyvsp[-3].dval), (yyvsp[-1].dval));
                                    if (res != 0)
                                        return res;
                                }
#line 1503 "/build/labplot/src/build/lib/gsl_parser.cpp"
    break;

  case 25: /* expr: FNCT '(' expr ';' expr ';' expr ')'  */
#line 250 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"
                                       {
                                            const auto res = evaluateFunction<Parsing::func_t3>(p, 3, (yyvsp[-7].tptr), (yyval.dval), (yyvsp[-5].dval), (yyvsp[-3].dval), (yyvsp[-1].dval));
                                            if (res != 0)
                                                return res;
                                        }
#line 1513 "/build/labplot/src/build/lib/gsl_parser.cpp"
    break;

  case 26: /* expr: FNCT '(' expr ';' expr ';' expr ';' expr ')'  */
#line 255 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"
                                                {
                                                    const auto res = evaluateFunction<Parsing::func_t4>(p, 4, (yyvsp[-9].tptr), (yyval.dval), (yyvsp[-7].dval), (yyvsp[-5].dval), (yyvsp[-3].dval), (yyvsp[-1].dval));
                                                    if (res != 0)
                                                        return res;
                                                }
#line 1523 "/build/labplot/src/build/lib/gsl_parser.cpp"
    break;

  case 27: /* expr: FNCT '(' expr ';' expr ';' expr ';' expr ';' expr ')'  */
#line 260 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"
                                                         {
                                                            const auto res = evaluateFunction<Parsing::func_t5>(p, 5, (yyvsp[-11].tptr), (yyval.dval), (yyvsp[-9].dval), (yyvsp[-7].dval), (yyvsp[-5].dval), (yyvsp[-3].dval), (yyvsp[-1].dval));
                                                            if (res != 0)
                                                                return res;
                                                        }
#line 1533 "/build/labplot/src/build/lib/gsl_parser.cpp"
    break;

  case 28: /* expr: expr '+' expr  */
#line 265 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"
                     { (yyval.dval) = (yyvsp[-2].dval) + (yyvsp[0].dval);                          }
#line 1539 "/build/labplot/src/build/lib/gsl_parser.cpp"
    break;

  case 29: /* expr: expr '-' expr  */
#line 266 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"
                     { (yyval.dval) = (yyvsp[-2].dval) - (yyvsp[0].dval);                          }
#line 1545 "/build/labplot/src/build/lib/gsl_parser.cpp"
    break;

  case 30: /* expr: expr "||" expr  */
#line 267 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"
                     { (yyval.dval) = Parsing::orFunction((yyvsp[-2].dval), (yyvsp[0].dval));       }
#line 1551 "/build/labplot/src/build/lib/gsl_parser.cpp"
    break;

  case 31: /* expr: expr '*' expr  */
#line 268 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"
                     { (yyval.dval) = (yyvsp[-2].dval) * (yyvsp[0].dval);                          }
#line 1557 "/build/labplot/src/build/lib/gsl_parser.cpp"
    break;

  case 32: /* expr: expr '/' expr  */
#line 269 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"
                     { (yyval.dval) = (yyvsp[-2].dval) / (yyvsp[0].dval);                          }
#line 1563 "/build/labplot/src/build/lib/gsl_parser.cpp"
    break;

  case 33: /* expr: expr '%' expr  */
#line 270 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"
                     { (yyval.dval) = (int)((yyvsp[-2].dval)) % (int)((yyvsp[0].dval));            }
#line 1569 "/build/labplot/src/build/lib/gsl_parser.cpp"
    break;

  case 34: /* expr: expr "&&" expr  */
#line 271 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"
                     { (yyval.dval) = Parsing::andFunction((yyvsp[-2].dval), (yyvsp[0].dval));      }
#line 1575 "/build/labplot/src/build/lib/gsl_parser.cpp"
    break;

  case 35: /* expr: '!' expr  */
#line 272 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"
                     { (yyval.dval) = Parsing::notFunction((yyvsp[0].dval));          }
#line 1581 "/build/labplot/src/build/lib/gsl_parser.cpp"
    break;

  case 36: /* expr: expr ">=" expr  */
#line 273 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"
                     { (yyval.dval) = Parsing::greaterEqualThan((yyvsp[-2].dval), (yyvsp[0].dval)); }
#line 1587 "/build/labplot/src/build/lib/gsl_parser.cpp"
    break;

  case 37: /* expr: expr "<=" expr  */
#line 274 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"
                     { (yyval.dval) = Parsing::lessEqualThan((yyvsp[-2].dval), (yyvsp[0].dval));    }
#line 1593 "/build/labplot/src/build/lib/gsl_parser.cpp"
    break;

  case 38: /* expr: expr '>' expr  */
#line 275 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"
                     { (yyval.dval) = Parsing::greaterThan((yyvsp[-2].dval), (yyvsp[0].dval));      }
#line 1599 "/build/labplot/src/build/lib/gsl_parser.cpp"
    break;

  case 39: /* expr: expr '<' expr  */
#line 276 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"
                     { (yyval.dval) = Parsing::lessThan((yyvsp[-2].dval), (yyvsp[0].dval));         }
#line 1605 "/build/labplot/src/build/lib/gsl_parser.cpp"
    break;

  case 40: /* expr: '-' expr  */
#line 277 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"
                     { (yyval.dval) = -(yyvsp[0].dval);                              }
#line 1611 "/build/labplot/src/build/lib/gsl_parser.cpp"
    break;

  case 41: /* expr: expr '^' expr  */
#line 278 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"
                     { (yyval.dval) = std::pow((yyvsp[-2].dval), (yyvsp[0].dval));                 }
#line 1617 "/build/labplot/src/build/lib/gsl_parser.cpp"
    break;

  case 42: /* expr: expr '*' '*' expr  */
#line 279 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"
                     { (yyval.dval) = std::pow((yyvsp[-3].dval), (yyvsp[0].dval));                 }
#line 1623 "/build/labplot/src/build/lib/gsl_parser.cpp"
    break;

  case 43: /* expr: '(' expr ')'  */
#line 280 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"
                     { (yyval.dval) = (yyvsp[-1].dval);                               }
#line 1629 "/build/labplot/src/build/lib/gsl_parser.cpp"
    break;

  case 44: /* expr: '|' expr '|'  */
#line 281 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"
                     { (yyval.dval) = std::abs((yyvsp[-1].dval));                     }
#line 1635 "/build/labplot/src/build/lib/gsl_parser.cpp"
    break;

  case 45: /* expr: expr '!'  */
#line 282 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"
                     { (yyval.dval) = gsl_sf_fact((unsigned int)(yyvsp[-1].dval));    }
#line 1641 "/build/labplot/src/build/lib/gsl_parser.cpp"
    break;


#line 1645 "/build/labplot/src/build/lib/gsl_parser.cpp"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      yyerror (p, YY_("syntax error"));
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= T_EOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == T_EOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, p);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp, p);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (p, YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, p);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp, p);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif

  return yyresult;
}

#line 285 "/build/labplot/src/labplot-2.12.1/lib/../src/backend/gsl/parser.ypp"


namespace Parsing {
	/* Static symbols like the functions ans variables in functions.cpp and constants.cpp */
	std::vector<StaticSymbol*> static_symbols;
	/* Special functions and others */
        std::vector<Symbol*> variable_symbols;

        void init_static_symbols();

        /* add new symbol with value or just set value if symbol is a variable */
        BaseSymbol* Parser::assign_symbol(const char* symbol_name, double value) {
                DEBUG_PARSER("PARSER: assign_symbol() : symbol_name = '" << symbol_name << "', value = " << value);

                BaseSymbol* ptr = nullptr;
                if (mUsedSymbolsStateMachine == UsedSymbols::No || mUsedSymbolsStateMachine == UsedSymbols::Initialize) {
                        /* be sure that the symbol table has been initialized */
                        if (variable_symbols.empty() || static_symbols.empty()) {
                                init_table();
                        }

                        ptr = get_variable_symbol(symbol_name);
                        if (!ptr) {
                                DEBUG_PARSER("PARSER: calling putsymbol(): symbol_name = '" << symbol_name << "'");
                                ptr = put_symbol(symbol_name, VAR);
                        } else {
                                DEBUG_PARSER("PARSER: Symbol already assigned\n");
                        }
                } else {
                        ptr = get_used_symbol(symbol_name);
                        if (!ptr) {
                                // The symbol was not used in the initialize phase, so we don't need it now
                                return nullptr;
                        }
                }

                /* do not assign value if symbol already exits as function */
                if (ptr->type == VAR)
                        ptr->value = value;

                return ptr;
        }

        /* save symbol in symbol table (at start of linked list) */
        Symbol* put_symbol(const char *symbol_name, int symbol_type) {
                /*	DEBUG_PARSER("PARSER: put_symbol(): symbol_name = '%s'\n", symbol_name); */

                auto* ptr = new Symbol(symbol_name, std::strlen(symbol_name), symbol_type);
                assert(ptr);
                switch (symbol_type) {
                case VAR: ptr->value = 0.; break;
                case FNCT: ptr->value = nullptr; break;
                case SPECFNCT: {
                        special_function_def sfp;
                        ptr->value = sfp;
                        break;
                }
                }

                variable_symbols.push_back(ptr);

                /*	DEBUG_PARSER("PARSER: put_symbol() DONE\n"); */
                return ptr;
        }

        /* remove symbol of name symbol_name from symbol table
        removes only variables of value 0
        returns 0 on success */
        int remove_symbol_(const char *symbol_name) {

                           // Only possible on variable symbols
                for (auto it = variable_symbols.begin(); it < variable_symbols.end(); it++) {
                        auto* symbol = *it;
                        if (symbol->name == symbol_name) {
                                if (symbol->type == VAR && std::get<double>(symbol->value) == 0) {
                                        DEBUG_PARSER("PARSER: REMOVING symbol '" << symbol_name << "'");
                                        variable_symbols.erase(it);
                                        delete symbol;
                                        return 0;
                                } else
                                        return 1;
                        }
                }
                return 1;
        }

        /* initialize symbol table with all known functions and constants */
        void init_table(void) {
                DEBUG_PARSER("PARSER: init_table()\n");

                if (static_symbols.empty()) {
                        // Only once neccessary
                        init_static_symbols();
                }

                           // Must be done every time to reinit
                clear_variable_symbols();
                variable_symbols.reserve(_number_specialfunctions);

                /* add special functions */
                for (int i = 0; i < _number_specialfunctions; i++) {
                        special_function_def sfd;
                        sfd.funsptr = &_special_functions[i];
                        variable_symbols.push_back(new Symbol(_special_functions[i].name, std::strlen(_special_functions[i].name), SPECFNCT, sfd));
                }

                DEBUG_PARSER("PARSER: init_table() DONE");
        }

        void init_static_symbols() {
                clear_static_symbols();
                static_symbols.reserve(_number_functions + _number_constants);
                for (int i = 0; i < _number_functions; i++) {
                        static_symbols.push_back(new StaticSymbol(_functions[i].name, FNCT, &_functions[i]));
                }

                /* add constants */
                for (int i = 0; i < _number_constants; i++) {
                        static_symbols.push_back(new StaticSymbol(_constants[i].name, VAR, _constants[i].value));
                }
        }

        int getcharstr(param *p) {
                DEBUG_PARSER(" getcharstr() pos = " << (int)(p->pos));

                if (p->pos >= p->string.size()) {
                        p->pos++;
                        return T_EOF;
                }
                DEBUG_PARSER("PARSER: 	char is " << p->string[p->pos]);
                return p->string[(p->pos)++];
        }

        void ungetcstr(size_t *pos) {
                DEBUG_PARSER("PARSER: ungetcstr()");
                if (*pos > 0)
                        (*pos)--;
        }

        int yylex(YYSTYPE* yyval, param *p) {
                DEBUG_PARSER("PARSER: YYLEX()");

		/* get char and skip white space */
		int c;
		while ((c = getcharstr(p)) == ' ' || c == '\t');

		/* finish if reached EOF */
                if (c == T_EOF) {
                        DEBUG_PARSER("PARSER: FINISHED\n");
			return 0;
		}
		/* check for non-ASCII chars */
		if (!isascii(c)) {
                        DEBUG_PARSER(" non-ASCII character found. Giving up\n");
                        return yyerror(p, "non-ASCII character found");
                }
		if (c == '\n') {
                        DEBUG_PARSER("PARSER: Reached EOL\n");
			return c;
		}

		if (c == '&') {
			// Check if the next is also an &, because then it is the AND operator
			if (getcharstr(p) == '&') {
				return AND;
			}
			ungetcstr(&(p->pos));
		} else if (c == '|') {
			if (getcharstr(p) == '|') {
				return OR;
			}
			ungetcstr(&(p->pos));
		} else if (c == '>') {
			if (getcharstr(p) == '=') {	// >=
				return GE;
			}
			ungetcstr(&(p->pos));
		} else if (c == '<') {
			if (getcharstr(p) == '=') {	// <=
				return LE;
			}
			ungetcstr(&(p->pos));
		}

                DEBUG_PARSER("PARSER: PROCESSING character '" << (char)c << "'");

		/* process numbers */
		if (isdigit(c)) {
                        DEBUG_PARSER("PARSER: Found NUMBER (starts with digit)\n");
			ungetcstr(&(p->pos));
                        auto s = p->string.substr(p->pos);

			/* convert to double */
                        char *remain;
	#if defined(_WIN32)
			locale_t locale = _create_locale(LC_NUMERIC, p->locale);
			if (locale == NULL) {
                                //DEBUG_PARSER("PARSER ERROR in newlocale(%s): %s. Trying system locale.\n", p->locale, strerror(errno));
				locale = _create_locale(LC_NUMERIC, "");
			}
	#else
			locale_t locale = newlocale(LC_NUMERIC_MASK, p->locale, (locale_t)nullptr);
			if (locale == (locale_t)nullptr) {
                                //pdebug("PARSER ERROR in newlocale(%s): %s. Trying system locale.\n", p->locale, strerror(errno));
				locale = newlocale(LC_NUMERIC_MASK, "", (locale_t)nullptr);
                                DEBUG_PARSER("PARSER:		Reading: '" << s << "' with system locale");
			} else {
                                DEBUG_PARSER("PARSER:		Reading: '" << s << "' with locale " << p->locale);
			}
	#endif
			double result;
			if (locale != nullptr) {
        #if defined(__OpenBSD__) || defined(__HAIKU__)
			  result = strtod(s.data(), &remain);
	#else
			  result = strtod_l(s.data(), &remain, locale);
	#endif
				freelocale(locale);
                        } else { // use C locale
                            result = strtod(s.data(), &remain);
                        }

                        DEBUG_PARSER("PARSER:		Remain: '" << remain << "'");

			/* check conversion */
                        if(s.size() == strlen(remain))
				return 0;

                        DEBUG_PARSER("PARSER:		Result = " << result);
                        yyval->dval = result;

                        p->pos += s.size() - strlen(remain);

			return NUM;
		}

		/* process symbol */
		if (isalpha (c) || c == '.') {
                        DEBUG_PARSER("PARSER: Found SYMBOL (starts with alpha)");
			static char *symbol_name = nullptr;
			static int length = 0;
			int i = 0;

			/* Initially make the buffer long enough for a 10-character symbol name */
			if (length == 0) {
				length = 10;
				symbol_name = (char *) malloc(length + 1);
			}

			do {
                                DEBUG_PARSER("PARSER: Reading symbol .. ");
				/* If buffer is full, make it bigger */
				if (i == length) {
					length *= 2;
					symbol_name = (char *) realloc(symbol_name, length + 1);
				}
				symbol_name[i++] = c;
				c = getcharstr(p);
                                DEBUG_PARSER("PARSER:		got '" << (char)c << "'");
			}
                        while (c != T_EOF && (isalnum(c) || c == '_' || c == '.'));
                        DEBUG_PARSER("PARSER: Reading SYMBOL DONE");

                        if (c != T_EOF)
				ungetcstr(&(p->pos));
			symbol_name[i] = '\0';

			BaseSymbol* s = nullptr;
                        if (p->parser->usedSymbolsState() == UsedSymbols::Only) {
                                s = p->parser->get_used_symbol(symbol_name);
				if (s == nullptr) {
                                        //pdebug("PARSER ERROR: Used Symbol '" << symbol_name << "' UNKNOWN");
                                        return yyerror(p, "Symbol not found in used symbols");
                                }
			} else {
                                s = get_static_symbol(symbol_name);
				if(s == nullptr) {	/* symbol unknown */
                                        s = get_variable_symbol(symbol_name);
					if (s == nullptr) {
                                                // During parsing it should not happen that a symbol is not available
                                                DEBUG_PARSER("PARSER ERROR: Symbol '" << symbol_name << "' UNKNOWN");
                                                return yyerror(p, "Unknown symbol");
                                        }
				}

                                if (p->parser->usedSymbolsState() == UsedSymbols::Initialize) {
                                        if (!p->parser->get_used_symbol(symbol_name)) {
                                                p->parser->addUsedSymbol(s);
                                                DEBUG_PARSER("New symbol: " << s->name);
                                        }
				}
			}
			assert(s);

                        yyval->tptr = s;
			return s->type;
		}

		/* else: single operator */
                DEBUG_PARSER("PARSER: Found single operator '" << (char)c << "'");
		return c;
	}
} // namespace Parsing
