// Copyright 2017 Istio Authors
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        (unknown)
// source: networking/v1alpha3/gateway.proto

// $schema: istio.networking.v1alpha3.Gateway
// $title: Gateway
// $description: Configuration affecting edge load balancer.
// $location: https://istio.io/docs/reference/config/networking/gateway.html
// $aliases: [/docs/reference/config/networking/v1alpha3/gateway]

// `Gateway` describes a load balancer operating at the edge of the mesh
// receiving incoming or outgoing HTTP/TCP connections. The specification
// describes a set of ports that should be exposed, the type of protocol to
// use, SNI configuration for the load balancer, etc.
//
// For example, the following Gateway configuration sets up a proxy to act
// as a load balancer exposing port 80 and 9080 (http), 443 (https),
// 9443(https) and port 2379 (TCP) for ingress.  The gateway will be
// applied to the proxy running on a pod with labels `app:
// my-gateway-controller`. While Istio will configure the proxy to listen
// on these ports, it is the responsibility of the user to ensure that
// external traffic to these ports are allowed into the mesh.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: Gateway
// metadata:
//   name: my-gateway
//   namespace: some-config-namespace
// spec:
//   selector:
//     app: my-gateway-controller
//   servers:
//   - port:
//       number: 80
//       name: http
//       protocol: HTTP
//     hosts:
//     - uk.bookinfo.com
//     - eu.bookinfo.com
//     tls:
//       httpsRedirect: true # sends 301 redirect for http requests
//   - port:
//       number: 443
//       name: https-443
//       protocol: HTTPS
//     hosts:
//     - uk.bookinfo.com
//     - eu.bookinfo.com
//     tls:
//       mode: SIMPLE # enables HTTPS on this port
//       serverCertificate: /etc/certs/servercert.pem
//       privateKey: /etc/certs/privatekey.pem
//   - port:
//       number: 9443
//       name: https-9443
//       protocol: HTTPS
//     hosts:
//     - "bookinfo-namespace/*.bookinfo.com"
//     tls:
//       mode: SIMPLE # enables HTTPS on this port
//       credentialName: bookinfo-secret # fetches certs from Kubernetes secret
//   - port:
//       number: 9080
//       name: http-wildcard
//       protocol: HTTP
//     hosts:
//     - "*"
//   - port:
//       number: 2379 # to expose internal service via external port 2379
//       name: mongo
//       protocol: MONGO
//     hosts:
//     - "*"
// ```
//
// The Gateway specification above describes the L4-L6 properties of a load
// balancer. A `VirtualService` can then be bound to a gateway to control
// the forwarding of traffic arriving at a particular host or gateway port.
//
// For example, the following VirtualService splits traffic for
// `https://uk.bookinfo.com/reviews`, `https://eu.bookinfo.com/reviews`,
// `http://uk.bookinfo.com:9080/reviews`,
// `http://eu.bookinfo.com:9080/reviews` into two versions (prod and qa) of
// an internal reviews service on port 9080. In addition, requests
// containing the cookie "user: dev-123" will be sent to special port 7777
// in the qa version. The same rule is also applicable inside the mesh for
// requests to the "reviews.prod.svc.cluster.local" service. This rule is
// applicable across ports 443, 9080. Note that `http://uk.bookinfo.com`
// gets redirected to `https://uk.bookinfo.com` (i.e. 80 redirects to 443).
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: VirtualService
// metadata:
//   name: bookinfo-rule
//   namespace: bookinfo-namespace
// spec:
//   hosts:
//   - reviews.prod.svc.cluster.local
//   - uk.bookinfo.com
//   - eu.bookinfo.com
//   gateways:
//   - some-config-namespace/my-gateway
//   - mesh # applies to all the sidecars in the mesh
//   http:
//   - match:
//     - headers:
//         cookie:
//           exact: "user=dev-123"
//     route:
//     - destination:
//         port:
//           number: 7777
//         host: reviews.qa.svc.cluster.local
//   - match:
//     - uri:
//         prefix: /reviews/
//     route:
//     - destination:
//         port:
//           number: 9080 # can be omitted if it's the only port for reviews
//         host: reviews.prod.svc.cluster.local
//       weight: 80
//     - destination:
//         host: reviews.qa.svc.cluster.local
//       weight: 20
// ```
//
// The following VirtualService forwards traffic arriving at (external)
// port 27017 to internal Mongo server on port 5555. This rule is not
// applicable internally in the mesh as the gateway list omits the
// reserved name `mesh`.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: VirtualService
// metadata:
//   name: bookinfo-mongo
//   namespace: bookinfo-namespace
// spec:
//   hosts:
//   - mongosvr.prod.svc.cluster.local # name of internal Mongo service
//   gateways:
//   - some-config-namespace/my-gateway # can omit the namespace if gateway is in same namespace as virtual service.
//   tcp:
//   - match:
//     - port: 27017
//     route:
//     - destination:
//         host: mongo.prod.svc.cluster.local
//         port:
//           number: 5555
// ```
//
// It is possible to restrict the set of virtual services that can bind to
// a gateway server using the namespace/hostname syntax in the hosts field.
// For example, the following Gateway allows any virtual service in the ns1
// namespace to bind to it, while restricting only the virtual service with
// foo.bar.com host in the ns2 namespace to bind to it.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: Gateway
// metadata:
//   name: my-gateway
//   namespace: some-config-namespace
// spec:
//   selector:
//     app: my-gateway-controller
//   servers:
//   - port:
//       number: 80
//       name: http
//       protocol: HTTP
//     hosts:
//     - "ns1/*"
//     - "ns2/foo.bar.com"
// ```
//

package v1alpha3

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// TLS modes enforced by the proxy
type ServerTLSSettings_TLSmode int32

const (
	// The SNI string presented by the client will be used as the
	// match criterion in a VirtualService TLS route to determine
	// the destination service from the service registry.
	ServerTLSSettings_PASSTHROUGH ServerTLSSettings_TLSmode = 0
	// Secure connections with standard TLS semantics. In this mode
	// client certificate is not requested during handshake.
	ServerTLSSettings_SIMPLE ServerTLSSettings_TLSmode = 1
	// Secure connections to the downstream using mutual TLS by
	// presenting server certificates for authentication.
	// A client certificate will also be requested during the handshake and
	// at least one valid certificate is required to be sent by the client.
	ServerTLSSettings_MUTUAL ServerTLSSettings_TLSmode = 2
	// Similar to the passthrough mode, except servers with this TLS
	// mode do not require an associated VirtualService to map from
	// the SNI value to service in the registry. The destination
	// details such as the service/subset/port are encoded in the
	// SNI value. The proxy will forward to the upstream (Envoy)
	// cluster (a group of endpoints) specified by the SNI
	// value. This server is typically used to provide connectivity
	// between services in disparate L3 networks that otherwise do
	// not have direct connectivity between their respective
	// endpoints. Use of this mode assumes that both the source and
	// the destination are using Istio mTLS to secure traffic.
	ServerTLSSettings_AUTO_PASSTHROUGH ServerTLSSettings_TLSmode = 3
	// Secure connections from the downstream using mutual TLS by
	// presenting server certificates for authentication.  Compared
	// to Mutual mode, this mode uses certificates, representing
	// gateway workload identity, generated automatically by Istio
	// for mTLS authentication. When this mode is used, all other
	// fields in `TLSOptions` should be empty.
	ServerTLSSettings_ISTIO_MUTUAL ServerTLSSettings_TLSmode = 4
	// Similar to MUTUAL mode, except that the client certificate
	// is optional. Unlike SIMPLE mode, A client certificate will
	// still be explicitly requested during handshake, but the client
	// is not required to send a certificate. If a client certificate
	// is presented, it will be validated. ca_certificates should
	// be specified for validating client certificates.
	ServerTLSSettings_OPTIONAL_MUTUAL ServerTLSSettings_TLSmode = 5
)

// Enum value maps for ServerTLSSettings_TLSmode.
var (
	ServerTLSSettings_TLSmode_name = map[int32]string{
		0: "PASSTHROUGH",
		1: "SIMPLE",
		2: "MUTUAL",
		3: "AUTO_PASSTHROUGH",
		4: "ISTIO_MUTUAL",
		5: "OPTIONAL_MUTUAL",
	}
	ServerTLSSettings_TLSmode_value = map[string]int32{
		"PASSTHROUGH":      0,
		"SIMPLE":           1,
		"MUTUAL":           2,
		"AUTO_PASSTHROUGH": 3,
		"ISTIO_MUTUAL":     4,
		"OPTIONAL_MUTUAL":  5,
	}
)

func (x ServerTLSSettings_TLSmode) Enum() *ServerTLSSettings_TLSmode {
	p := new(ServerTLSSettings_TLSmode)
	*p = x
	return p
}

func (x ServerTLSSettings_TLSmode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ServerTLSSettings_TLSmode) Descriptor() protoreflect.EnumDescriptor {
	return file_networking_v1alpha3_gateway_proto_enumTypes[0].Descriptor()
}

func (ServerTLSSettings_TLSmode) Type() protoreflect.EnumType {
	return &file_networking_v1alpha3_gateway_proto_enumTypes[0]
}

func (x ServerTLSSettings_TLSmode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ServerTLSSettings_TLSmode.Descriptor instead.
func (ServerTLSSettings_TLSmode) EnumDescriptor() ([]byte, []int) {
	return file_networking_v1alpha3_gateway_proto_rawDescGZIP(), []int{3, 0}
}

// TLS protocol versions.
type ServerTLSSettings_TLSProtocol int32

const (
	// Automatically choose the optimal TLS version.
	ServerTLSSettings_TLS_AUTO ServerTLSSettings_TLSProtocol = 0
	// TLS version 1.0
	ServerTLSSettings_TLSV1_0 ServerTLSSettings_TLSProtocol = 1
	// TLS version 1.1
	ServerTLSSettings_TLSV1_1 ServerTLSSettings_TLSProtocol = 2
	// TLS version 1.2
	ServerTLSSettings_TLSV1_2 ServerTLSSettings_TLSProtocol = 3
	// TLS version 1.3
	ServerTLSSettings_TLSV1_3 ServerTLSSettings_TLSProtocol = 4
)

// Enum value maps for ServerTLSSettings_TLSProtocol.
var (
	ServerTLSSettings_TLSProtocol_name = map[int32]string{
		0: "TLS_AUTO",
		1: "TLSV1_0",
		2: "TLSV1_1",
		3: "TLSV1_2",
		4: "TLSV1_3",
	}
	ServerTLSSettings_TLSProtocol_value = map[string]int32{
		"TLS_AUTO": 0,
		"TLSV1_0":  1,
		"TLSV1_1":  2,
		"TLSV1_2":  3,
		"TLSV1_3":  4,
	}
)

func (x ServerTLSSettings_TLSProtocol) Enum() *ServerTLSSettings_TLSProtocol {
	p := new(ServerTLSSettings_TLSProtocol)
	*p = x
	return p
}

func (x ServerTLSSettings_TLSProtocol) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ServerTLSSettings_TLSProtocol) Descriptor() protoreflect.EnumDescriptor {
	return file_networking_v1alpha3_gateway_proto_enumTypes[1].Descriptor()
}

func (ServerTLSSettings_TLSProtocol) Type() protoreflect.EnumType {
	return &file_networking_v1alpha3_gateway_proto_enumTypes[1]
}

func (x ServerTLSSettings_TLSProtocol) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ServerTLSSettings_TLSProtocol.Descriptor instead.
func (ServerTLSSettings_TLSProtocol) EnumDescriptor() ([]byte, []int) {
	return file_networking_v1alpha3_gateway_proto_rawDescGZIP(), []int{3, 1}
}

// Gateway describes a load balancer operating at the edge of the mesh
// receiving incoming or outgoing HTTP/TCP connections.
//
// <!-- crd generation tags
// +cue-gen:Gateway:groupName:networking.istio.io
// +cue-gen:Gateway:versions:v1,v1beta1,v1alpha3
// +cue-gen:Gateway:annotations:helm.sh/resource-policy=keep
// +cue-gen:Gateway:labels:app=istio-pilot,chart=istio,heritage=Tiller,release=istio
// +cue-gen:Gateway:subresource:status
// +cue-gen:Gateway:scope:Namespaced
// +cue-gen:Gateway:resource:categories=istio-io,networking-istio-io,shortNames=gw
// +cue-gen:Gateway:preserveUnknownFields:false
// -->
//
// <!-- go code generation tags
// +kubetype-gen
// +kubetype-gen:groupVersion=networking.istio.io/v1alpha3
// +genclient
// +k8s:deepcopy-gen=true
// -->
type Gateway struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// A list of server specifications.
	Servers []*Server `protobuf:"bytes,1,rep,name=servers,proto3" json:"servers,omitempty"`
	// One or more labels that indicate a specific set of pods/VMs
	// on which this gateway configuration should be applied.
	// By default workloads are searched across all namespaces based on label selectors.
	// This implies that a gateway resource in the namespace "foo" can select pods in
	// the namespace "bar" based on labels.
	// This behavior can be controlled via the `PILOT_SCOPE_GATEWAY_TO_NAMESPACE`
	// environment variable in istiod. If this variable is set
	// to true, the scope of label search is restricted to the configuration
	// namespace in which the the resource is present. In other words, the Gateway
	// resource must reside in the same namespace as the gateway workload
	// instance.
	// If selector is nil, the Gateway will be applied to all workloads.
	Selector      map[string]string `protobuf:"bytes,2,rep,name=selector,proto3" json:"selector,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Gateway) Reset() {
	*x = Gateway{}
	mi := &file_networking_v1alpha3_gateway_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Gateway) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Gateway) ProtoMessage() {}

func (x *Gateway) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_gateway_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Gateway.ProtoReflect.Descriptor instead.
func (*Gateway) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_gateway_proto_rawDescGZIP(), []int{0}
}

func (x *Gateway) GetServers() []*Server {
	if x != nil {
		return x.Servers
	}
	return nil
}

func (x *Gateway) GetSelector() map[string]string {
	if x != nil {
		return x.Selector
	}
	return nil
}

// `Server` describes the properties of the proxy on a given load balancer
// port. For example,
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: Gateway
// metadata:
//
//	name: my-ingress
//
// spec:
//
//	selector:
//	  app: my-ingressgateway
//	servers:
//	- port:
//	    number: 80
//	    name: http2
//	    protocol: HTTP2
//	  hosts:
//	  - "*"
//
// ```
//
// # Another example
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: Gateway
// metadata:
//
//	name: my-tcp-ingress
//
// spec:
//
//	selector:
//	  app: my-tcp-ingressgateway
//	servers:
//	- port:
//	    number: 27018
//	    name: mongo
//	    protocol: MONGO
//	  hosts:
//	  - "*"
//
// ```
//
// # The following is an example of TLS configuration for port 443
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: Gateway
// metadata:
//
//	name: my-tls-ingress
//
// spec:
//
//	selector:
//	  app: my-tls-ingressgateway
//	servers:
//	- port:
//	    number: 443
//	    name: https
//	    protocol: HTTPS
//	  hosts:
//	  - "*"
//	  tls:
//	    mode: SIMPLE
//	    credentialName: tls-cert
//
// ```
type Server struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The Port on which the proxy should listen for incoming
	// connections.
	Port *Port `protobuf:"bytes,1,opt,name=port,proto3" json:"port,omitempty"`
	// The ip or the Unix domain socket to which the listener should be bound
	// to. Format: `x.x.x.x` or `unix:///path/to/uds` or `unix://@foobar`
	// (Linux abstract namespace). When using Unix domain sockets, the port
	// number should be 0.
	// This can be used to restrict the reachability of this server to be gateway internal only.
	// This is typically used when a gateway needs to communicate to another mesh service
	// e.g. publishing metrics. In such case, the server created with the
	// specified bind will not be available to external gateway clients.
	Bind string `protobuf:"bytes,4,opt,name=bind,proto3" json:"bind,omitempty"`
	// One or more hosts exposed by this gateway.
	// While typically applicable to
	// HTTP services, it can also be used for TCP services using TLS with SNI.
	// A host is specified as a `dnsName` with an optional `namespace/` prefix.
	// The `dnsName` should be specified using FQDN format, optionally including
	// a wildcard character in the left-most component (e.g., `prod/*.example.com`).
	// Set the `dnsName` to `*` to select all `VirtualService` hosts from the
	// specified namespace (e.g.,`prod/*`).
	//
	// The `namespace` can be set to `*` or `.`, representing any or the current
	// namespace, respectively. For example, `*/foo.example.com` selects the
	// service from any available namespace while `./foo.example.com` only selects
	// the service from the namespace of the sidecar. The default, if no `namespace/`
	// is specified, is `*/`, that is, select services from any namespace.
	// Any associated `DestinationRule` in the selected namespace will also be used.
	//
	// A `VirtualService` must be bound to the gateway and must have one or
	// more hosts that match the hosts specified in a server. The match
	// could be an exact match or a suffix match with the server's hosts. For
	// example, if the server's hosts specifies `*.example.com`, a
	// `VirtualService` with hosts `dev.example.com` or `prod.example.com` will
	// match. However, a `VirtualService` with host `example.com` or
	// `newexample.com` will not match.
	//
	// NOTE: Only virtual services exported to the gateway's namespace
	// (e.g., `exportTo` value of `*`) can be referenced.
	// Private configurations (e.g., `exportTo` set to `.`) will not be
	// available. Refer to the `exportTo` setting in `VirtualService`,
	// `DestinationRule`, and `ServiceEntry` configurations for details.
	Hosts []string `protobuf:"bytes,2,rep,name=hosts,proto3" json:"hosts,omitempty"`
	// Set of TLS related options that govern the server's behavior. Use
	// these options to control if all http requests should be redirected to
	// https, and the TLS modes to use.
	Tls *ServerTLSSettings `protobuf:"bytes,3,opt,name=tls,proto3" json:"tls,omitempty"`
	// The loopback IP endpoint or Unix domain socket to which traffic should
	// be forwarded to by default. Format should be `127.0.0.1:PORT` or
	// `unix:///path/to/socket` or `unix://@foobar` (Linux abstract namespace).
	// NOT IMPLEMENTED.
	// $hide_from_docs
	DefaultEndpoint string `protobuf:"bytes,5,opt,name=default_endpoint,json=defaultEndpoint,proto3" json:"default_endpoint,omitempty"`
	// An optional name of the server, when set must be unique across all servers.
	// This will be used for variety of purposes like prefixing stats generated with
	// this name etc.
	Name          string `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Server) Reset() {
	*x = Server{}
	mi := &file_networking_v1alpha3_gateway_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Server) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Server) ProtoMessage() {}

func (x *Server) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_gateway_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Server.ProtoReflect.Descriptor instead.
func (*Server) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_gateway_proto_rawDescGZIP(), []int{1}
}

func (x *Server) GetPort() *Port {
	if x != nil {
		return x.Port
	}
	return nil
}

func (x *Server) GetBind() string {
	if x != nil {
		return x.Bind
	}
	return ""
}

func (x *Server) GetHosts() []string {
	if x != nil {
		return x.Hosts
	}
	return nil
}

func (x *Server) GetTls() *ServerTLSSettings {
	if x != nil {
		return x.Tls
	}
	return nil
}

func (x *Server) GetDefaultEndpoint() string {
	if x != nil {
		return x.DefaultEndpoint
	}
	return ""
}

func (x *Server) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Port describes the properties of a specific port of a service.
type Port struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// A valid non-negative integer port number.
	Number uint32 `protobuf:"varint,1,opt,name=number,proto3" json:"number,omitempty"`
	// The protocol exposed on the port.
	// MUST be one of HTTP|HTTPS|GRPC|GRPC-WEB|HTTP2|MONGO|TCP|TLS.
	// TLS can be either used to terminate non-HTTP based connections on a specific port
	// or to route traffic based on SNI header to the destination without terminating the TLS connection.
	Protocol string `protobuf:"bytes,2,opt,name=protocol,proto3" json:"protocol,omitempty"`
	// Label assigned to the port.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// The port number on the endpoint where the traffic will be
	// received. Applicable only when used with ServiceEntries.
	// $hide_from_docs
	//
	// Deprecated: Marked as deprecated in networking/v1alpha3/gateway.proto.
	TargetPort    uint32 `protobuf:"varint,4,opt,name=target_port,json=targetPort,proto3" json:"target_port,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Port) Reset() {
	*x = Port{}
	mi := &file_networking_v1alpha3_gateway_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Port) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Port) ProtoMessage() {}

func (x *Port) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_gateway_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Port.ProtoReflect.Descriptor instead.
func (*Port) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_gateway_proto_rawDescGZIP(), []int{2}
}

func (x *Port) GetNumber() uint32 {
	if x != nil {
		return x.Number
	}
	return 0
}

func (x *Port) GetProtocol() string {
	if x != nil {
		return x.Protocol
	}
	return ""
}

func (x *Port) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Deprecated: Marked as deprecated in networking/v1alpha3/gateway.proto.
func (x *Port) GetTargetPort() uint32 {
	if x != nil {
		return x.TargetPort
	}
	return 0
}

// +kubebuilder:validation:XValidation:message="only one of credentialNames or tlsCertificates can be set",rule="oneof(self.tlsCertificates, self.credentialNames)"
// +kubebuilder:validation:XValidation:message="only one of credentialName or credentialNames can be set",rule="oneof(self.credentialName, self.credentialNames)"
// +kubebuilder:validation:XValidation:message="only one of credentialName or tlsCertificates can be set",rule="oneof(self.credentialNames, self.tlsCertificates)"
type ServerTLSSettings struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// If set to true, the load balancer will send a 301 redirect for
	// all http connections, asking the clients to use HTTPS.
	HttpsRedirect bool `protobuf:"varint,1,opt,name=https_redirect,json=httpsRedirect,proto3" json:"https_redirect,omitempty"`
	// Optional: Indicates whether connections to this port should be
	// secured using TLS. The value of this field determines how TLS is
	// enforced.
	Mode ServerTLSSettings_TLSmode `protobuf:"varint,2,opt,name=mode,proto3,enum=istio.networking.v1alpha3.ServerTLSSettings_TLSmode" json:"mode,omitempty"`
	// REQUIRED if mode is `SIMPLE` or `MUTUAL`. The path to the file
	// holding the server-side TLS certificate to use.
	ServerCertificate string `protobuf:"bytes,3,opt,name=server_certificate,json=serverCertificate,proto3" json:"server_certificate,omitempty"`
	// REQUIRED if mode is `SIMPLE` or `MUTUAL`. The path to the file
	// holding the server's private key.
	PrivateKey string `protobuf:"bytes,4,opt,name=private_key,json=privateKey,proto3" json:"private_key,omitempty"`
	// REQUIRED if mode is `MUTUAL` or `OPTIONAL_MUTUAL`. The path to a file
	// containing certificate authority certificates to use in verifying a presented
	// client side certificate.
	CaCertificates string `protobuf:"bytes,5,opt,name=ca_certificates,json=caCertificates,proto3" json:"ca_certificates,omitempty"`
	// OPTIONAL: The path to the file containing the certificate revocation list (CRL)
	// to use in verifying a presented client side certificate. `CRL` is a list of certificates
	// that have been revoked by the CA (Certificate Authority) before their scheduled expiration date.
	// If specified, the proxy will verify if the presented certificate is part of the revoked list of certificates.
	// If omitted, the proxy will not verify the certificate against the `crl`.
	CaCrl string `protobuf:"bytes,13,opt,name=ca_crl,json=caCrl,proto3" json:"ca_crl,omitempty"`
	// For gateways running on Kubernetes, the name of the secret that
	// holds the TLS certs including the CA certificates. Applicable
	// only on Kubernetes. An Opaque secret should contain the following
	// keys and values: `tls.key: <privateKey>` and `tls.crt: <serverCert>` or
	// `key: <privateKey>` and `cert: <serverCert>`.
	// For mutual TLS, `cacert: <CACertificate>` and `crl: <CertificateRevocationList>`
	// can be provided in the same secret or a separate secret named `<secret>-cacert`.
	// A TLS secret for server certificates with an additional `tls.ocsp-staple` key
	// for specifying OCSP staple information, `ca.crt` key for CA certificates
	// and `ca.crl` for certificate revocation list is also supported.
	// Only one of server certificates and CA certificate
	// or credentialName can be specified.
	CredentialName string `protobuf:"bytes,10,opt,name=credential_name,json=credentialName,proto3" json:"credential_name,omitempty"`
	// Same as CredentialName but for multiple certificates. Mainly used for specifying
	// RSA and ECDSA certificates for the same server.
	// +kubebuilder:validation:MaxItems=2
	// +kubebuilder:validation:MinItems=1
	CredentialNames []string `protobuf:"bytes,14,rep,name=credential_names,json=credentialNames,proto3" json:"credential_names,omitempty"`
	// Only one of `server_certificate`, `private_key` or `credential_name`
	// or `credential_names` or `tls_certificates` should be specified.
	// This is mainly used for specifying RSA and ECDSA certificates for the same server.
	// +kubebuilder:validation:MaxItems=2
	// +kubebuilder:validation:MinItems=1
	TlsCertificates []*ServerTLSSettings_TLSCertificate `protobuf:"bytes,15,rep,name=tls_certificates,json=tlsCertificates,proto3" json:"tls_certificates,omitempty"`
	// A list of alternate names to verify the subject identity in the
	// certificate presented by the client.
	// Requires TLS mode to be set to `MUTUAL`.
	// When multiple certificates are provided via `credential_names` or `tls_certificates`,
	// the subject alternate names are validated against the selected certificate.
	SubjectAltNames []string `protobuf:"bytes,6,rep,name=subject_alt_names,json=subjectAltNames,proto3" json:"subject_alt_names,omitempty"`
	// An optional list of base64-encoded SHA-256 hashes of the SPKIs of
	// authorized client certificates.
	// Note: When both verify_certificate_hash and verify_certificate_spki
	// are specified, a hash matching either value will result in the
	// certificate being accepted.
	VerifyCertificateSpki []string `protobuf:"bytes,11,rep,name=verify_certificate_spki,json=verifyCertificateSpki,proto3" json:"verify_certificate_spki,omitempty"`
	// An optional list of hex-encoded SHA-256 hashes of the
	// authorized client certificates. Both simple and colon separated
	// formats are acceptable.
	// Note: When both verify_certificate_hash and verify_certificate_spki
	// are specified, a hash matching either value will result in the
	// certificate being accepted.
	VerifyCertificateHash []string `protobuf:"bytes,12,rep,name=verify_certificate_hash,json=verifyCertificateHash,proto3" json:"verify_certificate_hash,omitempty"`
	// Optional: Minimum TLS protocol version. By default, it is `TLSV1_2`.
	// TLS protocol versions below TLSV1_2 require setting compatible ciphers with the
	// `cipherSuites` setting as they no longer include compatible ciphers.
	//
	// Note: Using TLS protocol versions below TLSV1_2 has serious security risks.
	MinProtocolVersion ServerTLSSettings_TLSProtocol `protobuf:"varint,7,opt,name=min_protocol_version,json=minProtocolVersion,proto3,enum=istio.networking.v1alpha3.ServerTLSSettings_TLSProtocol" json:"min_protocol_version,omitempty"`
	// Optional: Maximum TLS protocol version.
	MaxProtocolVersion ServerTLSSettings_TLSProtocol `protobuf:"varint,8,opt,name=max_protocol_version,json=maxProtocolVersion,proto3,enum=istio.networking.v1alpha3.ServerTLSSettings_TLSProtocol" json:"max_protocol_version,omitempty"`
	// Optional: If specified, only support the specified cipher list.
	// Otherwise default to the default cipher list supported by Envoy
	// as specified [here](https://www.envoyproxy.io/docs/envoy/latest/api-v3/extensions/transport_sockets/tls/v3/common.proto).
	// The supported list of ciphers are:
	// * `ECDHE-ECDSA-AES128-GCM-SHA256`
	// * `ECDHE-RSA-AES128-GCM-SHA256`
	// * `ECDHE-ECDSA-AES256-GCM-SHA384`
	// * `ECDHE-RSA-AES256-GCM-SHA384`
	// * `ECDHE-ECDSA-CHACHA20-POLY1305`
	// * `ECDHE-RSA-CHACHA20-POLY1305`
	// * `ECDHE-ECDSA-AES128-SHA`
	// * `ECDHE-RSA-AES128-SHA`
	// * `ECDHE-ECDSA-AES256-SHA`
	// * `ECDHE-RSA-AES256-SHA`
	// * `AES128-GCM-SHA256`
	// * `AES256-GCM-SHA384`
	// * `AES128-SHA`
	// * `AES256-SHA`
	// * `DES-CBC3-SHA`
	CipherSuites  []string `protobuf:"bytes,9,rep,name=cipher_suites,json=cipherSuites,proto3" json:"cipher_suites,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ServerTLSSettings) Reset() {
	*x = ServerTLSSettings{}
	mi := &file_networking_v1alpha3_gateway_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServerTLSSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServerTLSSettings) ProtoMessage() {}

func (x *ServerTLSSettings) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_gateway_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServerTLSSettings.ProtoReflect.Descriptor instead.
func (*ServerTLSSettings) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_gateway_proto_rawDescGZIP(), []int{3}
}

func (x *ServerTLSSettings) GetHttpsRedirect() bool {
	if x != nil {
		return x.HttpsRedirect
	}
	return false
}

func (x *ServerTLSSettings) GetMode() ServerTLSSettings_TLSmode {
	if x != nil {
		return x.Mode
	}
	return ServerTLSSettings_PASSTHROUGH
}

func (x *ServerTLSSettings) GetServerCertificate() string {
	if x != nil {
		return x.ServerCertificate
	}
	return ""
}

func (x *ServerTLSSettings) GetPrivateKey() string {
	if x != nil {
		return x.PrivateKey
	}
	return ""
}

func (x *ServerTLSSettings) GetCaCertificates() string {
	if x != nil {
		return x.CaCertificates
	}
	return ""
}

func (x *ServerTLSSettings) GetCaCrl() string {
	if x != nil {
		return x.CaCrl
	}
	return ""
}

func (x *ServerTLSSettings) GetCredentialName() string {
	if x != nil {
		return x.CredentialName
	}
	return ""
}

func (x *ServerTLSSettings) GetCredentialNames() []string {
	if x != nil {
		return x.CredentialNames
	}
	return nil
}

func (x *ServerTLSSettings) GetTlsCertificates() []*ServerTLSSettings_TLSCertificate {
	if x != nil {
		return x.TlsCertificates
	}
	return nil
}

func (x *ServerTLSSettings) GetSubjectAltNames() []string {
	if x != nil {
		return x.SubjectAltNames
	}
	return nil
}

func (x *ServerTLSSettings) GetVerifyCertificateSpki() []string {
	if x != nil {
		return x.VerifyCertificateSpki
	}
	return nil
}

func (x *ServerTLSSettings) GetVerifyCertificateHash() []string {
	if x != nil {
		return x.VerifyCertificateHash
	}
	return nil
}

func (x *ServerTLSSettings) GetMinProtocolVersion() ServerTLSSettings_TLSProtocol {
	if x != nil {
		return x.MinProtocolVersion
	}
	return ServerTLSSettings_TLS_AUTO
}

func (x *ServerTLSSettings) GetMaxProtocolVersion() ServerTLSSettings_TLSProtocol {
	if x != nil {
		return x.MaxProtocolVersion
	}
	return ServerTLSSettings_TLS_AUTO
}

func (x *ServerTLSSettings) GetCipherSuites() []string {
	if x != nil {
		return x.CipherSuites
	}
	return nil
}

// TLSCertificate describes the server's TLS certificate.
type ServerTLSSettings_TLSCertificate struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// REQUIRED if mode is `SIMPLE` or `MUTUAL`. The path to the file
	// holding the server-side TLS certificate to use.
	ServerCertificate string `protobuf:"bytes,1,opt,name=server_certificate,json=serverCertificate,proto3" json:"server_certificate,omitempty"`
	// REQUIRED if mode is `SIMPLE` or `MUTUAL`. The path to the file
	// holding the server's private key.
	PrivateKey string `protobuf:"bytes,2,opt,name=private_key,json=privateKey,proto3" json:"private_key,omitempty"`
	// $hide_from_docs
	// REQUIRED if mode is `MUTUAL` or `OPTIONAL_MUTUAL`. The path to a file
	// containing certificate authority certificates to use in verifying a presented
	// client side certificate.
	// $hide_from_docs
	CaCertificates string `protobuf:"bytes,3,opt,name=ca_certificates,json=caCertificates,proto3" json:"ca_certificates,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *ServerTLSSettings_TLSCertificate) Reset() {
	*x = ServerTLSSettings_TLSCertificate{}
	mi := &file_networking_v1alpha3_gateway_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServerTLSSettings_TLSCertificate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServerTLSSettings_TLSCertificate) ProtoMessage() {}

func (x *ServerTLSSettings_TLSCertificate) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_gateway_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServerTLSSettings_TLSCertificate.ProtoReflect.Descriptor instead.
func (*ServerTLSSettings_TLSCertificate) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_gateway_proto_rawDescGZIP(), []int{3, 0}
}

func (x *ServerTLSSettings_TLSCertificate) GetServerCertificate() string {
	if x != nil {
		return x.ServerCertificate
	}
	return ""
}

func (x *ServerTLSSettings_TLSCertificate) GetPrivateKey() string {
	if x != nil {
		return x.PrivateKey
	}
	return ""
}

func (x *ServerTLSSettings_TLSCertificate) GetCaCertificates() string {
	if x != nil {
		return x.CaCertificates
	}
	return ""
}

var File_networking_v1alpha3_gateway_proto protoreflect.FileDescriptor

const file_networking_v1alpha3_gateway_proto_rawDesc = "" +
	"\n" +
	"!networking/v1alpha3/gateway.proto\x12\x19istio.networking.v1alpha3\x1a\x1fgoogle/api/field_behavior.proto\"\xd1\x01\n" +
	"\aGateway\x12;\n" +
	"\aservers\x18\x01 \x03(\v2!.istio.networking.v1alpha3.ServerR\aservers\x12L\n" +
	"\bselector\x18\x02 \x03(\v20.istio.networking.v1alpha3.Gateway.SelectorEntryR\bselector\x1a;\n" +
	"\rSelectorEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"\xf2\x01\n" +
	"\x06Server\x129\n" +
	"\x04port\x18\x01 \x01(\v2\x1f.istio.networking.v1alpha3.PortB\x04\xe2A\x01\x02R\x04port\x12\x12\n" +
	"\x04bind\x18\x04 \x01(\tR\x04bind\x12\x1a\n" +
	"\x05hosts\x18\x02 \x03(\tB\x04\xe2A\x01\x02R\x05hosts\x12>\n" +
	"\x03tls\x18\x03 \x01(\v2,.istio.networking.v1alpha3.ServerTLSSettingsR\x03tls\x12)\n" +
	"\x10default_endpoint\x18\x05 \x01(\tR\x0fdefaultEndpoint\x12\x12\n" +
	"\x04name\x18\x06 \x01(\tR\x04name\"\x85\x01\n" +
	"\x04Port\x12\x1c\n" +
	"\x06number\x18\x01 \x01(\rB\x04\xe2A\x01\x02R\x06number\x12 \n" +
	"\bprotocol\x18\x02 \x01(\tB\x04\xe2A\x01\x02R\bprotocol\x12\x18\n" +
	"\x04name\x18\x03 \x01(\tB\x04\xe2A\x01\x02R\x04name\x12#\n" +
	"\vtarget_port\x18\x04 \x01(\rB\x02\x18\x01R\n" +
	"targetPort\"\xb7\t\n" +
	"\x11ServerTLSSettings\x12%\n" +
	"\x0ehttps_redirect\x18\x01 \x01(\bR\rhttpsRedirect\x12H\n" +
	"\x04mode\x18\x02 \x01(\x0e24.istio.networking.v1alpha3.ServerTLSSettings.TLSmodeR\x04mode\x12-\n" +
	"\x12server_certificate\x18\x03 \x01(\tR\x11serverCertificate\x12\x1f\n" +
	"\vprivate_key\x18\x04 \x01(\tR\n" +
	"privateKey\x12'\n" +
	"\x0fca_certificates\x18\x05 \x01(\tR\x0ecaCertificates\x12\x15\n" +
	"\x06ca_crl\x18\r \x01(\tR\x05caCrl\x12'\n" +
	"\x0fcredential_name\x18\n" +
	" \x01(\tR\x0ecredentialName\x12)\n" +
	"\x10credential_names\x18\x0e \x03(\tR\x0fcredentialNames\x12f\n" +
	"\x10tls_certificates\x18\x0f \x03(\v2;.istio.networking.v1alpha3.ServerTLSSettings.TLSCertificateR\x0ftlsCertificates\x12*\n" +
	"\x11subject_alt_names\x18\x06 \x03(\tR\x0fsubjectAltNames\x126\n" +
	"\x17verify_certificate_spki\x18\v \x03(\tR\x15verifyCertificateSpki\x126\n" +
	"\x17verify_certificate_hash\x18\f \x03(\tR\x15verifyCertificateHash\x12j\n" +
	"\x14min_protocol_version\x18\a \x01(\x0e28.istio.networking.v1alpha3.ServerTLSSettings.TLSProtocolR\x12minProtocolVersion\x12j\n" +
	"\x14max_protocol_version\x18\b \x01(\x0e28.istio.networking.v1alpha3.ServerTLSSettings.TLSProtocolR\x12maxProtocolVersion\x12#\n" +
	"\rcipher_suites\x18\t \x03(\tR\fcipherSuites\x1a\x89\x01\n" +
	"\x0eTLSCertificate\x12-\n" +
	"\x12server_certificate\x18\x01 \x01(\tR\x11serverCertificate\x12\x1f\n" +
	"\vprivate_key\x18\x02 \x01(\tR\n" +
	"privateKey\x12'\n" +
	"\x0fca_certificates\x18\x03 \x01(\tR\x0ecaCertificates\"o\n" +
	"\aTLSmode\x12\x0f\n" +
	"\vPASSTHROUGH\x10\x00\x12\n" +
	"\n" +
	"\x06SIMPLE\x10\x01\x12\n" +
	"\n" +
	"\x06MUTUAL\x10\x02\x12\x14\n" +
	"\x10AUTO_PASSTHROUGH\x10\x03\x12\x10\n" +
	"\fISTIO_MUTUAL\x10\x04\x12\x13\n" +
	"\x0fOPTIONAL_MUTUAL\x10\x05\"O\n" +
	"\vTLSProtocol\x12\f\n" +
	"\bTLS_AUTO\x10\x00\x12\v\n" +
	"\aTLSV1_0\x10\x01\x12\v\n" +
	"\aTLSV1_1\x10\x02\x12\v\n" +
	"\aTLSV1_2\x10\x03\x12\v\n" +
	"\aTLSV1_3\x10\x04B\"Z istio.io/api/networking/v1alpha3b\x06proto3"

var (
	file_networking_v1alpha3_gateway_proto_rawDescOnce sync.Once
	file_networking_v1alpha3_gateway_proto_rawDescData []byte
)

func file_networking_v1alpha3_gateway_proto_rawDescGZIP() []byte {
	file_networking_v1alpha3_gateway_proto_rawDescOnce.Do(func() {
		file_networking_v1alpha3_gateway_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_networking_v1alpha3_gateway_proto_rawDesc), len(file_networking_v1alpha3_gateway_proto_rawDesc)))
	})
	return file_networking_v1alpha3_gateway_proto_rawDescData
}

var file_networking_v1alpha3_gateway_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_networking_v1alpha3_gateway_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_networking_v1alpha3_gateway_proto_goTypes = []any{
	(ServerTLSSettings_TLSmode)(0),           // 0: istio.networking.v1alpha3.ServerTLSSettings.TLSmode
	(ServerTLSSettings_TLSProtocol)(0),       // 1: istio.networking.v1alpha3.ServerTLSSettings.TLSProtocol
	(*Gateway)(nil),                          // 2: istio.networking.v1alpha3.Gateway
	(*Server)(nil),                           // 3: istio.networking.v1alpha3.Server
	(*Port)(nil),                             // 4: istio.networking.v1alpha3.Port
	(*ServerTLSSettings)(nil),                // 5: istio.networking.v1alpha3.ServerTLSSettings
	nil,                                      // 6: istio.networking.v1alpha3.Gateway.SelectorEntry
	(*ServerTLSSettings_TLSCertificate)(nil), // 7: istio.networking.v1alpha3.ServerTLSSettings.TLSCertificate
}
var file_networking_v1alpha3_gateway_proto_depIdxs = []int32{
	3, // 0: istio.networking.v1alpha3.Gateway.servers:type_name -> istio.networking.v1alpha3.Server
	6, // 1: istio.networking.v1alpha3.Gateway.selector:type_name -> istio.networking.v1alpha3.Gateway.SelectorEntry
	4, // 2: istio.networking.v1alpha3.Server.port:type_name -> istio.networking.v1alpha3.Port
	5, // 3: istio.networking.v1alpha3.Server.tls:type_name -> istio.networking.v1alpha3.ServerTLSSettings
	0, // 4: istio.networking.v1alpha3.ServerTLSSettings.mode:type_name -> istio.networking.v1alpha3.ServerTLSSettings.TLSmode
	7, // 5: istio.networking.v1alpha3.ServerTLSSettings.tls_certificates:type_name -> istio.networking.v1alpha3.ServerTLSSettings.TLSCertificate
	1, // 6: istio.networking.v1alpha3.ServerTLSSettings.min_protocol_version:type_name -> istio.networking.v1alpha3.ServerTLSSettings.TLSProtocol
	1, // 7: istio.networking.v1alpha3.ServerTLSSettings.max_protocol_version:type_name -> istio.networking.v1alpha3.ServerTLSSettings.TLSProtocol
	8, // [8:8] is the sub-list for method output_type
	8, // [8:8] is the sub-list for method input_type
	8, // [8:8] is the sub-list for extension type_name
	8, // [8:8] is the sub-list for extension extendee
	0, // [0:8] is the sub-list for field type_name
}

func init() { file_networking_v1alpha3_gateway_proto_init() }
func file_networking_v1alpha3_gateway_proto_init() {
	if File_networking_v1alpha3_gateway_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_networking_v1alpha3_gateway_proto_rawDesc), len(file_networking_v1alpha3_gateway_proto_rawDesc)),
			NumEnums:      2,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_networking_v1alpha3_gateway_proto_goTypes,
		DependencyIndexes: file_networking_v1alpha3_gateway_proto_depIdxs,
		EnumInfos:         file_networking_v1alpha3_gateway_proto_enumTypes,
		MessageInfos:      file_networking_v1alpha3_gateway_proto_msgTypes,
	}.Build()
	File_networking_v1alpha3_gateway_proto = out.File
	file_networking_v1alpha3_gateway_proto_goTypes = nil
	file_networking_v1alpha3_gateway_proto_depIdxs = nil
}
