/* Autogenerated file, DO NOT EDIT manually! generated by perf-equations-codegen.py
 *
 * Copyright (c) 2018 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#include <stdlib.h>
#include <string.h>

#include <i915_drm.h>

#include "i915/perf.h"
#include "i915_perf_equations.h"

#define MIN(x, y) (((x) < (y)) ? (x) : (y))
#define MAX(a, b) (((a) > (b)) ? (a) : (b))

double
percentage_max_callback_float(const struct intel_perf *perf,
                              const struct intel_perf_metric_set *metric_set,
                              uint64_t *accumulator)
{
   return 100;
}

uint64_t
percentage_max_callback_uint64(const struct intel_perf *perf,
                               const struct intel_perf_metric_set *metric_set,
                               uint64_t *accumulator)
{
   return 100;
}


/* Render Metrics Basic set :: GPU Time Elapsed */
uint64_t
hsw__render_basic__gpu_time__read(const struct intel_perf *perf,
                                  const struct intel_perf_metric_set *metric_set,
                                  uint64_t *accumulator)
{
    /* RPN equation: GPU_TIME 0 READ 1000000000 UMUL $GpuTimestampFrequency UDIV */
    uint64_t tmp0 = accumulator[metric_set->gpu_time_offset + 0];
    uint64_t tmp1 = tmp0 * 1000000000;
    uint64_t tmp2 = tmp1;
    uint64_t tmp3 = perf->devinfo.timestamp_frequency;
    uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* Render Metrics Basic set :: GPU Core Clocks */
uint64_t
hsw__render_basic__gpu_core_clocks__read(const struct intel_perf *perf,
                                         const struct intel_perf_metric_set *metric_set,
                                         uint64_t *accumulator)
{
    /* RPN equation: C 2 READ */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 2];

    return tmp0;
}

/* Render Metrics Basic set :: AVG GPU Core Frequency */
uint64_t
hsw__render_basic__avg_gpu_core_frequency__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
    uint64_t tmp0 = hsw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator) * 1000000000;
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = hsw__render_basic__gpu_time__read(perf, metric_set, accumulator);
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

    return tmp3;
}

/* Render Metrics Basic set :: AVG GPU Core Frequency */
uint64_t
hsw__render_basic__avg_gpu_core_frequency__max(const struct intel_perf *perf,
                                               const struct intel_perf_metric_set *metric_set,
                                               uint64_t *accumulator)
{
    /* RPN equation: $GpuMaxFrequency */

    return perf->devinfo.gt_max_freq;
}

/* Render Metrics Basic set :: VS Threads Dispatched */
uint64_t
hsw__render_basic__vs_threads__read(const struct intel_perf *perf,
                                    const struct intel_perf_metric_set *metric_set,
                                    uint64_t *accumulator)
{
    /* RPN equation: A 5 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 5];

    return tmp0;
}

/* Render Metrics Basic set :: TCS Threads Dispatched */
uint64_t
hsw__render_basic__hs_threads__read(const struct intel_perf *perf,
                                    const struct intel_perf_metric_set *metric_set,
                                    uint64_t *accumulator)
{
    /* RPN equation: A 10 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 10];

    return tmp0;
}

/* Render Metrics Basic set :: TES Threads Dispatched */
uint64_t
hsw__render_basic__ds_threads__read(const struct intel_perf *perf,
                                    const struct intel_perf_metric_set *metric_set,
                                    uint64_t *accumulator)
{
    /* RPN equation: A 15 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 15];

    return tmp0;
}

/* Render Metrics Basic set :: GS Threads Dispatched */
uint64_t
hsw__render_basic__gs_threads__read(const struct intel_perf *perf,
                                    const struct intel_perf_metric_set *metric_set,
                                    uint64_t *accumulator)
{
    /* RPN equation: A 25 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 25];

    return tmp0;
}

/* Render Metrics Basic set :: FS Threads Dispatched */
uint64_t
hsw__render_basic__ps_threads__read(const struct intel_perf *perf,
                                    const struct intel_perf_metric_set *metric_set,
                                    uint64_t *accumulator)
{
    /* RPN equation: A 30 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 30];

    return tmp0;
}

/* Render Metrics Basic set :: CS Threads Dispatched */
uint64_t
hsw__render_basic__cs_threads__read(const struct intel_perf *perf,
                                    const struct intel_perf_metric_set *metric_set,
                                    uint64_t *accumulator)
{
    /* RPN equation: A 20 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 20];

    return tmp0;
}

/* Render Metrics Basic set :: GPU Busy */
double
hsw__render_basic__gpu_busy__read(const struct intel_perf *perf,
                                  const struct intel_perf_metric_set *metric_set,
                                  uint64_t *accumulator)
{
    /* RPN equation: A 41 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 41];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = hsw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* Render Metrics Basic set :: EU Active */
double
hsw__render_basic__eu_active__read(const struct intel_perf *perf,
                                   const struct intel_perf_metric_set *metric_set,
                                   uint64_t *accumulator)
{
    /* RPN equation: A 0 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 0];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Render Metrics Basic set :: EU Stall */
double
hsw__render_basic__eu_stall__read(const struct intel_perf *perf,
                                  const struct intel_perf_metric_set *metric_set,
                                  uint64_t *accumulator)
{
    /* RPN equation: A 1 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 1];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Render Metrics Basic set :: VS EU Active */
double
hsw__render_basic__vs_eu_active__read(const struct intel_perf *perf,
                                      const struct intel_perf_metric_set *metric_set,
                                      uint64_t *accumulator)
{
    /* RPN equation: A 2 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 2];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Render Metrics Basic set :: VS AVG Active per Thread */
uint64_t
hsw__render_basic__vs_eu_active_per_thread__read(const struct intel_perf *perf,
                                                 const struct intel_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: A 2 READ $VsThreads UDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 2];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = hsw__render_basic__vs_threads__read(perf, metric_set, accumulator);
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

    return tmp3;
}

/* Render Metrics Basic set :: VS AVG Stall per Thread */
uint64_t
hsw__render_basic__vs_eu_stall_per_thread__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: A 3 READ $VsThreads UDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 3];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = hsw__render_basic__vs_threads__read(perf, metric_set, accumulator);
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

    return tmp3;
}

/* Render Metrics Basic set :: VS EU Stall */
double
hsw__render_basic__vs_eu_stall__read(const struct intel_perf *perf,
                                     const struct intel_perf_metric_set *metric_set,
                                     uint64_t *accumulator)
{
    /* RPN equation: A 3 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 3];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Render Metrics Basic set :: TCS EU Active */
double
hsw__render_basic__hs_eu_active__read(const struct intel_perf *perf,
                                      const struct intel_perf_metric_set *metric_set,
                                      uint64_t *accumulator)
{
    /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 7];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Render Metrics Basic set :: TCS AVG Active per Thread */
uint64_t
hsw__render_basic__hs_eu_active_per_thread__read(const struct intel_perf *perf,
                                                 const struct intel_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: A 7 READ $HsThreads UDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 7];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = hsw__render_basic__hs_threads__read(perf, metric_set, accumulator);
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

    return tmp3;
}

/* Render Metrics Basic set :: TCS AVG Stall per Thread */
uint64_t
hsw__render_basic__hs_eu_stall_per_thread__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: A 8 READ $HsThreads UDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 8];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = hsw__render_basic__hs_threads__read(perf, metric_set, accumulator);
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

    return tmp3;
}

/* Render Metrics Basic set :: TCS EU Stall */
double
hsw__render_basic__hs_eu_stall__read(const struct intel_perf *perf,
                                     const struct intel_perf_metric_set *metric_set,
                                     uint64_t *accumulator)
{
    /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 8];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Render Metrics Basic set :: TES EU Active */
double
hsw__render_basic__ds_eu_active__read(const struct intel_perf *perf,
                                      const struct intel_perf_metric_set *metric_set,
                                      uint64_t *accumulator)
{
    /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 12];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Render Metrics Basic set :: TES AVG Active per Thread */
uint64_t
hsw__render_basic__ds_eu_active_per_thread__read(const struct intel_perf *perf,
                                                 const struct intel_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: A 12 READ $DsThreads UDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 12];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = hsw__render_basic__ds_threads__read(perf, metric_set, accumulator);
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

    return tmp3;
}

/* Render Metrics Basic set :: TES AVG Stall per Thread */
uint64_t
hsw__render_basic__ds_eu_stall_per_thread__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: A 13 READ $DsThreads UDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 13];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = hsw__render_basic__ds_threads__read(perf, metric_set, accumulator);
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

    return tmp3;
}

/* Render Metrics Basic set :: TES EU Stall */
double
hsw__render_basic__ds_eu_stall__read(const struct intel_perf *perf,
                                     const struct intel_perf_metric_set *metric_set,
                                     uint64_t *accumulator)
{
    /* RPN equation: A 13 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 13];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Render Metrics Basic set :: GS EU Active */
double
hsw__render_basic__gs_eu_active__read(const struct intel_perf *perf,
                                      const struct intel_perf_metric_set *metric_set,
                                      uint64_t *accumulator)
{
    /* RPN equation: A 22 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 22];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Render Metrics Basic set :: GS AVG Active per Thread */
uint64_t
hsw__render_basic__gs_eu_active_per_thread__read(const struct intel_perf *perf,
                                                 const struct intel_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: A 22 READ $GsThreads UDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 22];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = hsw__render_basic__gs_threads__read(perf, metric_set, accumulator);
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

    return tmp3;
}

/* Render Metrics Basic set :: GS AVG Stall per Thread */
uint64_t
hsw__render_basic__gs_eu_stall_per_thread__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: A 23 READ $GsThreads UDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 23];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = hsw__render_basic__gs_threads__read(perf, metric_set, accumulator);
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

    return tmp3;
}

/* Render Metrics Basic set :: GS EU Stall */
double
hsw__render_basic__gs_eu_stall__read(const struct intel_perf *perf,
                                     const struct intel_perf_metric_set *metric_set,
                                     uint64_t *accumulator)
{
    /* RPN equation: A 23 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 23];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Render Metrics Basic set :: CS EU Active */
double
hsw__render_basic__cs_eu_active__read(const struct intel_perf *perf,
                                      const struct intel_perf_metric_set *metric_set,
                                      uint64_t *accumulator)
{
    /* RPN equation: A 17 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 17];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Render Metrics Basic set :: CS AVG Active per Thread */
uint64_t
hsw__render_basic__cs_eu_active_per_thread__read(const struct intel_perf *perf,
                                                 const struct intel_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: A 17 READ $CsThreads UDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 17];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = hsw__render_basic__cs_threads__read(perf, metric_set, accumulator);
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

    return tmp3;
}

/* Render Metrics Basic set :: CS AVG Stall per Thread */
uint64_t
hsw__render_basic__cs_eu_stall_per_thread__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: A 18 READ $CsThreads UDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 18];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = hsw__render_basic__cs_threads__read(perf, metric_set, accumulator);
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

    return tmp3;
}

/* Render Metrics Basic set :: CS EU Stall */
double
hsw__render_basic__cs_eu_stall__read(const struct intel_perf *perf,
                                     const struct intel_perf_metric_set *metric_set,
                                     uint64_t *accumulator)
{
    /* RPN equation: A 18 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 18];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Render Metrics Basic set :: FS EU Active */
double
hsw__render_basic__ps_eu_active__read(const struct intel_perf *perf,
                                      const struct intel_perf_metric_set *metric_set,
                                      uint64_t *accumulator)
{
    /* RPN equation: A 27 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 27];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Render Metrics Basic set :: FS AVG Active per Thread */
uint64_t
hsw__render_basic__ps_eu_active_per_thread__read(const struct intel_perf *perf,
                                                 const struct intel_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: A 27 READ $PsThreads UDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 27];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = hsw__render_basic__ps_threads__read(perf, metric_set, accumulator);
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

    return tmp3;
}

/* Render Metrics Basic set :: FS AVG Stall per Thread */
uint64_t
hsw__render_basic__ps_eu_stall_per_thread__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: A 28 READ $PsThreads UDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 28];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = hsw__render_basic__ps_threads__read(perf, metric_set, accumulator);
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

    return tmp3;
}

/* Render Metrics Basic set :: FS EU Stall */
double
hsw__render_basic__ps_eu_stall__read(const struct intel_perf *perf,
                                     const struct intel_perf_metric_set *metric_set,
                                     uint64_t *accumulator)
{
    /* RPN equation: A 28 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 28];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Render Metrics Basic set :: Sampler 0 Busy */
double
hsw__render_basic__sampler0_busy__read(const struct intel_perf *perf,
                                       const struct intel_perf_metric_set *metric_set,
                                       uint64_t *accumulator)
{
    /* RPN equation: B 0 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = hsw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* Render Metrics Basic set :: Sampler 1 Busy */
double
hsw__render_basic__sampler1_busy__read(const struct intel_perf *perf,
                                       const struct intel_perf_metric_set *metric_set,
                                       uint64_t *accumulator)
{
    /* RPN equation: B 1 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = hsw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* Render Metrics Basic set :: Samplers Busy */
double
hsw__render_basic__samplers_busy__read(const struct intel_perf *perf,
                                       const struct intel_perf_metric_set *metric_set,
                                       uint64_t *accumulator)
{
    /* RPN equation: B 0 READ  B 1 READ UADD $GpuCoreClocks FDIV 2 FDIV 100 FMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp2 = tmp0 + tmp1;
    double tmp3 = tmp2;
    double tmp4 = hsw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp5 = tmp4 ? tmp3 / tmp4 : 0;
    double tmp6 = tmp5;
    double tmp7 = 2;
    double tmp8 = tmp7 ? tmp6 / tmp7 : 0;
    double tmp9 = tmp8 * 100;

    return tmp9;
}

/* Render Metrics Basic set :: Sampler 0 Bottleneck */
double
hsw__render_basic__sampler0_bottleneck__read(const struct intel_perf *perf,
                                             const struct intel_perf_metric_set *metric_set,
                                             uint64_t *accumulator)
{
    /* RPN equation: B 2 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = hsw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* Render Metrics Basic set :: Sampler 1 Bottleneck */
double
hsw__render_basic__sampler1_bottleneck__read(const struct intel_perf *perf,
                                             const struct intel_perf_metric_set *metric_set,
                                             uint64_t *accumulator)
{
    /* RPN equation: B 3 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = hsw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* Render Metrics Basic set :: Sampler 0 Texels LOD0 */
uint64_t
hsw__render_basic__sampler0_texels__read(const struct intel_perf *perf,
                                         const struct intel_perf_metric_set *metric_set,
                                         uint64_t *accumulator)
{
    /* RPN equation: B 4 READ 4 UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp1 = tmp0 * 4;

    return tmp1;
}

/* Render Metrics Basic set :: Sampler 1 Texels LOD0 */
uint64_t
hsw__render_basic__sampler1_texels__read(const struct intel_perf *perf,
                                         const struct intel_perf_metric_set *metric_set,
                                         uint64_t *accumulator)
{
    /* RPN equation: B 5 READ 4 UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp1 = tmp0 * 4;

    return tmp1;
}

/* Render Metrics Basic set :: Sampler Texels LOD0 */
uint64_t
hsw__render_basic__sampler_texels__read(const struct intel_perf *perf,
                                        const struct intel_perf_metric_set *metric_set,
                                        uint64_t *accumulator)
{
    /* RPN equation: $Sampler0Texels $Sampler1Texels UADD $EuSlicesTotalCount UMUL */
    uint64_t tmp0 = hsw__render_basic__sampler0_texels__read(perf, metric_set, accumulator) + hsw__render_basic__sampler1_texels__read(perf, metric_set, accumulator);
    uint64_t tmp1 = tmp0 * perf->devinfo.n_eu_slices;

    return tmp1;
}

/* Render Metrics Basic set :: L3 Sampler Throughput */
uint64_t
hsw__render_basic__l3_sampler_throughput__read(const struct intel_perf *perf,
                                               const struct intel_perf_metric_set *metric_set,
                                               uint64_t *accumulator)
{
    /* RPN equation: B 6 READ B 7 READ UADD 2 UMUL $EuSlicesTotalCount UMUL 64 UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = tmp2 * 2;
    uint64_t tmp4 = tmp3 * perf->devinfo.n_eu_slices;
    uint64_t tmp5 = tmp4 * 64;

    return tmp5;
}

/* Render Metrics Basic set :: L3 Sampler Throughput */
uint64_t
hsw__render_basic__l3_sampler_throughput__max(const struct intel_perf *perf,
                                              const struct intel_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: $GpuCoreClocks 64 UMUL $EuSlicesTotalCount UMUL */
    uint64_t tmp0 = hsw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator) * 64;
    uint64_t tmp1 = tmp0 * perf->devinfo.n_eu_slices;

    return tmp1;
}

/* Render Metrics Basic set :: Early Hi-Depth Test Fails */
uint64_t
hsw__render_basic__hi_depth_test_fails__read(const struct intel_perf *perf,
                                             const struct intel_perf_metric_set *metric_set,
                                             uint64_t *accumulator)
{
    /* RPN equation: A 33 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 33];

    return tmp0;
}

/* Render Metrics Basic set :: Early Depth Test Fails */
uint64_t
hsw__render_basic__early_depth_test_fails__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: A 35 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 35];

    return tmp0;
}

/* Render Metrics Basic set :: Samples Killed in FS */
uint64_t
hsw__render_basic__samples_killed_in_ps__read(const struct intel_perf *perf,
                                              const struct intel_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: A 36 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 36];

    return tmp0;
}

/* Render Metrics Basic set :: Alpha Test Fails */
uint64_t
hsw__render_basic__alpha_test_fails__read(const struct intel_perf *perf,
                                          const struct intel_perf_metric_set *metric_set,
                                          uint64_t *accumulator)
{
    /* RPN equation: A 37 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 37];

    return tmp0;
}

/* Render Metrics Basic set :: Late Stencil Test Fails */
uint64_t
hsw__render_basic__post_ps_stencil_test_fails__read(const struct intel_perf *perf,
                                                    const struct intel_perf_metric_set *metric_set,
                                                    uint64_t *accumulator)
{
    /* RPN equation: A 38 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 38];

    return tmp0;
}

/* Render Metrics Basic set :: Late Depth Test Fails */
uint64_t
hsw__render_basic__post_ps_depth_test_fails__read(const struct intel_perf *perf,
                                                  const struct intel_perf_metric_set *metric_set,
                                                  uint64_t *accumulator)
{
    /* RPN equation: A 39 READ $SamplesKilledInPs USUB */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 39];
    uint64_t tmp1 = tmp0 - hsw__render_basic__samples_killed_in_ps__read(perf, metric_set, accumulator);

    return tmp1;
}

/* Render Metrics Basic set :: Samples Written */
uint64_t
hsw__render_basic__samples_written__read(const struct intel_perf *perf,
                                         const struct intel_perf_metric_set *metric_set,
                                         uint64_t *accumulator)
{
    /* RPN equation: A 40 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 40];

    return tmp0;
}

/* Render Metrics Basic set :: Samples Blended */
uint64_t
hsw__render_basic__samples_blended__read(const struct intel_perf *perf,
                                         const struct intel_perf_metric_set *metric_set,
                                         uint64_t *accumulator)
{
    /* RPN equation: C 5 READ $EuSlicesTotalCount 4 UMUL UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp1 = perf->devinfo.n_eu_slices * 4;
    uint64_t tmp2 = tmp0 * tmp1;

    return tmp2;
}

/* Render Metrics Basic set :: GTI Fixed Pipe Throughput */
uint64_t
hsw__render_basic__gti_vf_throughput__read(const struct intel_perf *perf,
                                           const struct intel_perf_metric_set *metric_set,
                                           uint64_t *accumulator)
{
    /* RPN equation: C 1 READ 64 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp1 = tmp0 * 64;

    return tmp1;
}

/* Render Metrics Basic set :: GTI Fixed Pipe Throughput */
uint64_t
hsw__render_basic__gti_vf_throughput__max(const struct intel_perf *perf,
                                          const struct intel_perf_metric_set *metric_set,
                                          uint64_t *accumulator)
{
    /* RPN equation: $GpuCoreClocks 64 UMUL */
    uint64_t tmp0 = hsw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator) * 64;

    return tmp0;
}

/* Render Metrics Basic set :: GTI Depth Throughput */
uint64_t
hsw__render_basic__gti_depth_throughput__read(const struct intel_perf *perf,
                                              const struct intel_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: C 0 READ 64 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp1 = tmp0 * 64;

    return tmp1;
}

/* Render Metrics Basic set :: GTI RCC Throughput */
uint64_t
hsw__render_basic__gti_rcc_throughput__read(const struct intel_perf *perf,
                                            const struct intel_perf_metric_set *metric_set,
                                            uint64_t *accumulator)
{
    /* RPN equation: C 3 READ 64 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp1 = tmp0 * 64;

    return tmp1;
}

/* Render Metrics Basic set :: GTI L3 Throughput */
uint64_t
hsw__render_basic__gti_l3_throughput__read(const struct intel_perf *perf,
                                           const struct intel_perf_metric_set *metric_set,
                                           uint64_t *accumulator)
{
    /* RPN equation: C 4 READ 64 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp1 = tmp0 * 64;

    return tmp1;
}

/* Render Metrics Basic set :: GTI Read Throughput */
uint64_t
hsw__render_basic__gti_read_throughput__read(const struct intel_perf *perf,
                                             const struct intel_perf_metric_set *metric_set,
                                             uint64_t *accumulator)
{
    /* RPN equation: C 6 READ 128 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp1 = tmp0 * 128;

    return tmp1;
}

/* Render Metrics Basic set :: GTI Write Throughput */
uint64_t
hsw__render_basic__gti_write_throughput__read(const struct intel_perf *perf,
                                              const struct intel_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: C 7 READ 64 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp1 = tmp0 * 64;

    return tmp1;
}

/* Render Metrics Basic set :: GTI Write Throughput */
uint64_t
hsw__render_basic__gti_write_throughput__max(const struct intel_perf *perf,
                                             const struct intel_perf_metric_set *metric_set,
                                             uint64_t *accumulator)
{
    /* RPN equation: $GpuCoreClocks 32 UMUL */
    uint64_t tmp0 = hsw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator) * 32;

    return tmp0;
}

/* Render Metrics Basic set :: LLC GPU Accesses */
uint64_t
hsw__render_basic__llc_accesses__read(const struct intel_perf *perf,
                                      const struct intel_perf_metric_set *metric_set,
                                      uint64_t *accumulator)
{
    /* RPN equation: PERFCNT 0 READ */
    uint64_t tmp0 = accumulator[metric_set->perfcnt_offset + 0];

    return tmp0;
}

/* Render Metrics Basic set :: LLC GPU Hits */
uint64_t
hsw__render_basic__llc_hits__read(const struct intel_perf *perf,
                                  const struct intel_perf_metric_set *metric_set,
                                  uint64_t *accumulator)
{
    /* RPN equation: PERFCNT 1 READ */
    uint64_t tmp0 = accumulator[metric_set->perfcnt_offset + 1];

    return tmp0;
}

/* Render Metrics Basic set :: LLC GPU Throughput */
uint64_t
hsw__render_basic__llc_gpu_throughput__read(const struct intel_perf *perf,
                                            const struct intel_perf_metric_set *metric_set,
                                            uint64_t *accumulator)
{
    /* RPN equation: PERFCNT 0 READ C 7 READ USUB 64 UMUL */
    uint64_t tmp0 = accumulator[metric_set->perfcnt_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp2 = tmp0 - tmp1;
    uint64_t tmp3 = tmp2 * 64;

    return tmp3;
}

/* Render Metrics Basic set :: FS Duration */
uint64_t
hsw__render_basic__ps_duration__read(const struct intel_perf *perf,
                                     const struct intel_perf_metric_set *metric_set,
                                     uint64_t *accumulator)
{
    /* RPN equation: A 27 READ  A 0 READ UMUL  A 2 READ  A 7 READ UADD  A 12 READ UADD  A 17 READ UADD  A 22 READ UADD  A 27 READ UADD UDIV  A 28 READ  A 1 READ UMUL  A 3 READ  A 8 READ UADD  A 13 READ UADD  A 18 READ UADD  A 23 READ UADD  A 28 READ UADD UDIV UADD $GpuTime UMUL $GpuCoreClocks $EuCoresTotalCount UMUL 1000 UMUL UDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 27];
    uint64_t tmp1 = accumulator[metric_set->a_offset + 0];
    uint64_t tmp2 = tmp0 * tmp1;
    uint64_t tmp3 = accumulator[metric_set->a_offset + 2];
    uint64_t tmp4 = accumulator[metric_set->a_offset + 7];
    uint64_t tmp5 = tmp3 + tmp4;
    uint64_t tmp6 = accumulator[metric_set->a_offset + 12];
    uint64_t tmp7 = tmp5 + tmp6;
    uint64_t tmp8 = accumulator[metric_set->a_offset + 17];
    uint64_t tmp9 = tmp7 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->a_offset + 22];
    uint64_t tmp11 = tmp9 + tmp10;
    uint64_t tmp12 = accumulator[metric_set->a_offset + 27];
    uint64_t tmp13 = tmp11 + tmp12;
    uint64_t tmp14 = tmp2;
    uint64_t tmp15 = tmp13;
    uint64_t tmp16 = tmp15 ? tmp14 / tmp15 : 0;
    uint64_t tmp17 = accumulator[metric_set->a_offset + 28];
    uint64_t tmp18 = accumulator[metric_set->a_offset + 1];
    uint64_t tmp19 = tmp17 * tmp18;
    uint64_t tmp20 = accumulator[metric_set->a_offset + 3];
    uint64_t tmp21 = accumulator[metric_set->a_offset + 8];
    uint64_t tmp22 = tmp20 + tmp21;
    uint64_t tmp23 = accumulator[metric_set->a_offset + 13];
    uint64_t tmp24 = tmp22 + tmp23;
    uint64_t tmp25 = accumulator[metric_set->a_offset + 18];
    uint64_t tmp26 = tmp24 + tmp25;
    uint64_t tmp27 = accumulator[metric_set->a_offset + 23];
    uint64_t tmp28 = tmp26 + tmp27;
    uint64_t tmp29 = accumulator[metric_set->a_offset + 28];
    uint64_t tmp30 = tmp28 + tmp29;
    uint64_t tmp31 = tmp19;
    uint64_t tmp32 = tmp30;
    uint64_t tmp33 = tmp32 ? tmp31 / tmp32 : 0;
    uint64_t tmp34 = tmp16 + tmp33;
    uint64_t tmp35 = tmp34 * hsw__render_basic__gpu_time__read(perf, metric_set, accumulator);
    uint64_t tmp36 = hsw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator) * perf->devinfo.n_eus;
    uint64_t tmp37 = tmp36 * 1000;
    uint64_t tmp38 = tmp35;
    uint64_t tmp39 = tmp37;
    uint64_t tmp40 = tmp39 ? tmp38 / tmp39 : 0;

    return tmp40;
}

/* Render Metrics Basic set :: VS Duration */
uint64_t
hsw__render_basic__vs_duration__read(const struct intel_perf *perf,
                                     const struct intel_perf_metric_set *metric_set,
                                     uint64_t *accumulator)
{
    /* RPN equation: A 2 READ  A 0 READ UMUL  A 2 READ  A 7 READ UADD  A 12 READ UADD  A 17 READ UADD  A 22 READ UADD  A 27 READ UADD UDIV  A 3 READ  A 1 READ UMUL  A 3 READ  A 8 READ UADD  A 13 READ UADD  A 18 READ UADD  A 23 READ UADD  A 28 READ UADD UDIV UADD $GpuTime UMUL $GpuCoreClocks $EuCoresTotalCount UMUL 1000 UMUL UDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 2];
    uint64_t tmp1 = accumulator[metric_set->a_offset + 0];
    uint64_t tmp2 = tmp0 * tmp1;
    uint64_t tmp3 = accumulator[metric_set->a_offset + 2];
    uint64_t tmp4 = accumulator[metric_set->a_offset + 7];
    uint64_t tmp5 = tmp3 + tmp4;
    uint64_t tmp6 = accumulator[metric_set->a_offset + 12];
    uint64_t tmp7 = tmp5 + tmp6;
    uint64_t tmp8 = accumulator[metric_set->a_offset + 17];
    uint64_t tmp9 = tmp7 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->a_offset + 22];
    uint64_t tmp11 = tmp9 + tmp10;
    uint64_t tmp12 = accumulator[metric_set->a_offset + 27];
    uint64_t tmp13 = tmp11 + tmp12;
    uint64_t tmp14 = tmp2;
    uint64_t tmp15 = tmp13;
    uint64_t tmp16 = tmp15 ? tmp14 / tmp15 : 0;
    uint64_t tmp17 = accumulator[metric_set->a_offset + 3];
    uint64_t tmp18 = accumulator[metric_set->a_offset + 1];
    uint64_t tmp19 = tmp17 * tmp18;
    uint64_t tmp20 = accumulator[metric_set->a_offset + 3];
    uint64_t tmp21 = accumulator[metric_set->a_offset + 8];
    uint64_t tmp22 = tmp20 + tmp21;
    uint64_t tmp23 = accumulator[metric_set->a_offset + 13];
    uint64_t tmp24 = tmp22 + tmp23;
    uint64_t tmp25 = accumulator[metric_set->a_offset + 18];
    uint64_t tmp26 = tmp24 + tmp25;
    uint64_t tmp27 = accumulator[metric_set->a_offset + 23];
    uint64_t tmp28 = tmp26 + tmp27;
    uint64_t tmp29 = accumulator[metric_set->a_offset + 28];
    uint64_t tmp30 = tmp28 + tmp29;
    uint64_t tmp31 = tmp19;
    uint64_t tmp32 = tmp30;
    uint64_t tmp33 = tmp32 ? tmp31 / tmp32 : 0;
    uint64_t tmp34 = tmp16 + tmp33;
    uint64_t tmp35 = tmp34 * hsw__render_basic__gpu_time__read(perf, metric_set, accumulator);
    uint64_t tmp36 = hsw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator) * perf->devinfo.n_eus;
    uint64_t tmp37 = tmp36 * 1000;
    uint64_t tmp38 = tmp35;
    uint64_t tmp39 = tmp37;
    uint64_t tmp40 = tmp39 ? tmp38 / tmp39 : 0;

    return tmp40;
}

/* Render Metrics Basic set :: GS Duration */
uint64_t
hsw__render_basic__gs_duration__read(const struct intel_perf *perf,
                                     const struct intel_perf_metric_set *metric_set,
                                     uint64_t *accumulator)
{
    /* RPN equation: A 22 READ  A 0 READ UMUL  A 2 READ  A 7 READ UADD  A 12 READ UADD  A 17 READ UADD  A 22 READ UADD  A 27 READ UADD UDIV  A 23 READ  A 1 READ UMUL  A 3 READ  A 8 READ UADD  A 13 READ UADD  A 18 READ UADD  A 23 READ UADD  A 28 READ UADD UDIV UADD $GpuTime UMUL $GpuCoreClocks $EuCoresTotalCount UMUL 1000 UMUL UDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 22];
    uint64_t tmp1 = accumulator[metric_set->a_offset + 0];
    uint64_t tmp2 = tmp0 * tmp1;
    uint64_t tmp3 = accumulator[metric_set->a_offset + 2];
    uint64_t tmp4 = accumulator[metric_set->a_offset + 7];
    uint64_t tmp5 = tmp3 + tmp4;
    uint64_t tmp6 = accumulator[metric_set->a_offset + 12];
    uint64_t tmp7 = tmp5 + tmp6;
    uint64_t tmp8 = accumulator[metric_set->a_offset + 17];
    uint64_t tmp9 = tmp7 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->a_offset + 22];
    uint64_t tmp11 = tmp9 + tmp10;
    uint64_t tmp12 = accumulator[metric_set->a_offset + 27];
    uint64_t tmp13 = tmp11 + tmp12;
    uint64_t tmp14 = tmp2;
    uint64_t tmp15 = tmp13;
    uint64_t tmp16 = tmp15 ? tmp14 / tmp15 : 0;
    uint64_t tmp17 = accumulator[metric_set->a_offset + 23];
    uint64_t tmp18 = accumulator[metric_set->a_offset + 1];
    uint64_t tmp19 = tmp17 * tmp18;
    uint64_t tmp20 = accumulator[metric_set->a_offset + 3];
    uint64_t tmp21 = accumulator[metric_set->a_offset + 8];
    uint64_t tmp22 = tmp20 + tmp21;
    uint64_t tmp23 = accumulator[metric_set->a_offset + 13];
    uint64_t tmp24 = tmp22 + tmp23;
    uint64_t tmp25 = accumulator[metric_set->a_offset + 18];
    uint64_t tmp26 = tmp24 + tmp25;
    uint64_t tmp27 = accumulator[metric_set->a_offset + 23];
    uint64_t tmp28 = tmp26 + tmp27;
    uint64_t tmp29 = accumulator[metric_set->a_offset + 28];
    uint64_t tmp30 = tmp28 + tmp29;
    uint64_t tmp31 = tmp19;
    uint64_t tmp32 = tmp30;
    uint64_t tmp33 = tmp32 ? tmp31 / tmp32 : 0;
    uint64_t tmp34 = tmp16 + tmp33;
    uint64_t tmp35 = tmp34 * hsw__render_basic__gpu_time__read(perf, metric_set, accumulator);
    uint64_t tmp36 = hsw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator) * perf->devinfo.n_eus;
    uint64_t tmp37 = tmp36 * 1000;
    uint64_t tmp38 = tmp35;
    uint64_t tmp39 = tmp37;
    uint64_t tmp40 = tmp39 ? tmp38 / tmp39 : 0;

    return tmp40;
}

/* Render Metrics Basic set :: TES Duration */
uint64_t
hsw__render_basic__ds_duration__read(const struct intel_perf *perf,
                                     const struct intel_perf_metric_set *metric_set,
                                     uint64_t *accumulator)
{
    /* RPN equation: A 12 READ  A 0 READ UMUL  A 2 READ  A 7 READ UADD  A 12 READ UADD  A 17 READ UADD  A 22 READ UADD  A 27 READ UADD UDIV  A 13 READ  A 1 READ UMUL  A 3 READ  A 8 READ UADD  A 13 READ UADD  A 18 READ UADD  A 23 READ UADD  A 28 READ UADD UDIV UADD $GpuTime UMUL $GpuCoreClocks $EuCoresTotalCount UMUL 1000 UMUL UDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 12];
    uint64_t tmp1 = accumulator[metric_set->a_offset + 0];
    uint64_t tmp2 = tmp0 * tmp1;
    uint64_t tmp3 = accumulator[metric_set->a_offset + 2];
    uint64_t tmp4 = accumulator[metric_set->a_offset + 7];
    uint64_t tmp5 = tmp3 + tmp4;
    uint64_t tmp6 = accumulator[metric_set->a_offset + 12];
    uint64_t tmp7 = tmp5 + tmp6;
    uint64_t tmp8 = accumulator[metric_set->a_offset + 17];
    uint64_t tmp9 = tmp7 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->a_offset + 22];
    uint64_t tmp11 = tmp9 + tmp10;
    uint64_t tmp12 = accumulator[metric_set->a_offset + 27];
    uint64_t tmp13 = tmp11 + tmp12;
    uint64_t tmp14 = tmp2;
    uint64_t tmp15 = tmp13;
    uint64_t tmp16 = tmp15 ? tmp14 / tmp15 : 0;
    uint64_t tmp17 = accumulator[metric_set->a_offset + 13];
    uint64_t tmp18 = accumulator[metric_set->a_offset + 1];
    uint64_t tmp19 = tmp17 * tmp18;
    uint64_t tmp20 = accumulator[metric_set->a_offset + 3];
    uint64_t tmp21 = accumulator[metric_set->a_offset + 8];
    uint64_t tmp22 = tmp20 + tmp21;
    uint64_t tmp23 = accumulator[metric_set->a_offset + 13];
    uint64_t tmp24 = tmp22 + tmp23;
    uint64_t tmp25 = accumulator[metric_set->a_offset + 18];
    uint64_t tmp26 = tmp24 + tmp25;
    uint64_t tmp27 = accumulator[metric_set->a_offset + 23];
    uint64_t tmp28 = tmp26 + tmp27;
    uint64_t tmp29 = accumulator[metric_set->a_offset + 28];
    uint64_t tmp30 = tmp28 + tmp29;
    uint64_t tmp31 = tmp19;
    uint64_t tmp32 = tmp30;
    uint64_t tmp33 = tmp32 ? tmp31 / tmp32 : 0;
    uint64_t tmp34 = tmp16 + tmp33;
    uint64_t tmp35 = tmp34 * hsw__render_basic__gpu_time__read(perf, metric_set, accumulator);
    uint64_t tmp36 = hsw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator) * perf->devinfo.n_eus;
    uint64_t tmp37 = tmp36 * 1000;
    uint64_t tmp38 = tmp35;
    uint64_t tmp39 = tmp37;
    uint64_t tmp40 = tmp39 ? tmp38 / tmp39 : 0;

    return tmp40;
}

/* Render Metrics Basic set :: TCS Duration */
uint64_t
hsw__render_basic__hs_duration__read(const struct intel_perf *perf,
                                     const struct intel_perf_metric_set *metric_set,
                                     uint64_t *accumulator)
{
    /* RPN equation: A 7 READ  A 0 READ UMUL  A 2 READ  A 7 READ UADD  A 12 READ UADD  A 17 READ UADD  A 22 READ UADD  A 27 READ UADD UDIV  A 8 READ  A 1 READ UMUL  A 3 READ  A 8 READ UADD  A 13 READ UADD  A 18 READ UADD  A 23 READ UADD  A 28 READ UADD UDIV UADD $GpuTime UMUL $GpuCoreClocks $EuCoresTotalCount UMUL 1000 UMUL UDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->a_offset + 0];
    uint64_t tmp2 = tmp0 * tmp1;
    uint64_t tmp3 = accumulator[metric_set->a_offset + 2];
    uint64_t tmp4 = accumulator[metric_set->a_offset + 7];
    uint64_t tmp5 = tmp3 + tmp4;
    uint64_t tmp6 = accumulator[metric_set->a_offset + 12];
    uint64_t tmp7 = tmp5 + tmp6;
    uint64_t tmp8 = accumulator[metric_set->a_offset + 17];
    uint64_t tmp9 = tmp7 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->a_offset + 22];
    uint64_t tmp11 = tmp9 + tmp10;
    uint64_t tmp12 = accumulator[metric_set->a_offset + 27];
    uint64_t tmp13 = tmp11 + tmp12;
    uint64_t tmp14 = tmp2;
    uint64_t tmp15 = tmp13;
    uint64_t tmp16 = tmp15 ? tmp14 / tmp15 : 0;
    uint64_t tmp17 = accumulator[metric_set->a_offset + 8];
    uint64_t tmp18 = accumulator[metric_set->a_offset + 1];
    uint64_t tmp19 = tmp17 * tmp18;
    uint64_t tmp20 = accumulator[metric_set->a_offset + 3];
    uint64_t tmp21 = accumulator[metric_set->a_offset + 8];
    uint64_t tmp22 = tmp20 + tmp21;
    uint64_t tmp23 = accumulator[metric_set->a_offset + 13];
    uint64_t tmp24 = tmp22 + tmp23;
    uint64_t tmp25 = accumulator[metric_set->a_offset + 18];
    uint64_t tmp26 = tmp24 + tmp25;
    uint64_t tmp27 = accumulator[metric_set->a_offset + 23];
    uint64_t tmp28 = tmp26 + tmp27;
    uint64_t tmp29 = accumulator[metric_set->a_offset + 28];
    uint64_t tmp30 = tmp28 + tmp29;
    uint64_t tmp31 = tmp19;
    uint64_t tmp32 = tmp30;
    uint64_t tmp33 = tmp32 ? tmp31 / tmp32 : 0;
    uint64_t tmp34 = tmp16 + tmp33;
    uint64_t tmp35 = tmp34 * hsw__render_basic__gpu_time__read(perf, metric_set, accumulator);
    uint64_t tmp36 = hsw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator) * perf->devinfo.n_eus;
    uint64_t tmp37 = tmp36 * 1000;
    uint64_t tmp38 = tmp35;
    uint64_t tmp39 = tmp37;
    uint64_t tmp40 = tmp39 ? tmp38 / tmp39 : 0;

    return tmp40;
}

/* Render Metrics Basic set :: CS Duration */
uint64_t
hsw__render_basic__cs_duration__read(const struct intel_perf *perf,
                                     const struct intel_perf_metric_set *metric_set,
                                     uint64_t *accumulator)
{
    /* RPN equation: A 17 READ  A 0 READ UMUL  A 2 READ  A 7 READ UADD  A 12 READ UADD  A 17 READ UADD  A 22 READ UADD  A 27 READ UADD UDIV  A 18 READ  A 1 READ UMUL  A 3 READ  A 8 READ UADD  A 13 READ UADD  A 18 READ UADD  A 23 READ UADD  A 28 READ UADD UDIV UADD $GpuTime UMUL $GpuCoreClocks $EuCoresTotalCount UMUL 1000 UMUL UDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 17];
    uint64_t tmp1 = accumulator[metric_set->a_offset + 0];
    uint64_t tmp2 = tmp0 * tmp1;
    uint64_t tmp3 = accumulator[metric_set->a_offset + 2];
    uint64_t tmp4 = accumulator[metric_set->a_offset + 7];
    uint64_t tmp5 = tmp3 + tmp4;
    uint64_t tmp6 = accumulator[metric_set->a_offset + 12];
    uint64_t tmp7 = tmp5 + tmp6;
    uint64_t tmp8 = accumulator[metric_set->a_offset + 17];
    uint64_t tmp9 = tmp7 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->a_offset + 22];
    uint64_t tmp11 = tmp9 + tmp10;
    uint64_t tmp12 = accumulator[metric_set->a_offset + 27];
    uint64_t tmp13 = tmp11 + tmp12;
    uint64_t tmp14 = tmp2;
    uint64_t tmp15 = tmp13;
    uint64_t tmp16 = tmp15 ? tmp14 / tmp15 : 0;
    uint64_t tmp17 = accumulator[metric_set->a_offset + 18];
    uint64_t tmp18 = accumulator[metric_set->a_offset + 1];
    uint64_t tmp19 = tmp17 * tmp18;
    uint64_t tmp20 = accumulator[metric_set->a_offset + 3];
    uint64_t tmp21 = accumulator[metric_set->a_offset + 8];
    uint64_t tmp22 = tmp20 + tmp21;
    uint64_t tmp23 = accumulator[metric_set->a_offset + 13];
    uint64_t tmp24 = tmp22 + tmp23;
    uint64_t tmp25 = accumulator[metric_set->a_offset + 18];
    uint64_t tmp26 = tmp24 + tmp25;
    uint64_t tmp27 = accumulator[metric_set->a_offset + 23];
    uint64_t tmp28 = tmp26 + tmp27;
    uint64_t tmp29 = accumulator[metric_set->a_offset + 28];
    uint64_t tmp30 = tmp28 + tmp29;
    uint64_t tmp31 = tmp19;
    uint64_t tmp32 = tmp30;
    uint64_t tmp33 = tmp32 ? tmp31 / tmp32 : 0;
    uint64_t tmp34 = tmp16 + tmp33;
    uint64_t tmp35 = tmp34 * hsw__render_basic__gpu_time__read(perf, metric_set, accumulator);
    uint64_t tmp36 = hsw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator) * perf->devinfo.n_eus;
    uint64_t tmp37 = tmp36 * 1000;
    uint64_t tmp38 = tmp35;
    uint64_t tmp39 = tmp37;
    uint64_t tmp40 = tmp39 ? tmp38 / tmp39 : 0;

    return tmp40;
}

/* Render Metrics Basic set :: Sampler Bottleneck */
double
hsw__render_basic__sampler_bottleneck__read(const struct intel_perf *perf,
                                            const struct intel_perf_metric_set *metric_set,
                                            uint64_t *accumulator)
{
    /* RPN equation: $Sampler0Bottleneck $Sampler1Bottleneck FMAX */
    double tmp0 = hsw__render_basic__sampler0_bottleneck__read(perf, metric_set, accumulator);
    double tmp1 = hsw__render_basic__sampler1_bottleneck__read(perf, metric_set, accumulator);
    double tmp2 = MAX(tmp0, tmp1);

    return tmp2;
}

/* Render Metrics Basic set :: EU Idle */
double
hsw__render_basic__eu_idle__read(const struct intel_perf *perf,
                                 const struct intel_perf_metric_set *metric_set,
                                 uint64_t *accumulator)
{
    /* RPN equation: 100 $EuActive $EuStall FADD FSUB */
    double tmp0 = hsw__render_basic__eu_active__read(perf, metric_set, accumulator) + hsw__render_basic__eu_stall__read(perf, metric_set, accumulator);
    double tmp1 = 100 - tmp0;

    return tmp1;
}

/* Compute Metrics Basic set :: Typed Bytes Read */
uint64_t
hsw__compute_basic__typed_bytes_read__read(const struct intel_perf *perf,
                                           const struct intel_perf_metric_set *metric_set,
                                           uint64_t *accumulator)
{
    /* RPN equation: B 4 READ B 5 READ UADD $EuSlicesTotalCount 64 UMUL UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = perf->devinfo.n_eu_slices * 64;
    uint64_t tmp4 = tmp2 * tmp3;

    return tmp4;
}

/* Compute Metrics Basic set :: Typed Bytes Written */
uint64_t
hsw__compute_basic__typed_bytes_written__read(const struct intel_perf *perf,
                                              const struct intel_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: B 6 READ B 7 READ UADD $EuSlicesTotalCount 64 UMUL UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = perf->devinfo.n_eu_slices * 64;
    uint64_t tmp4 = tmp2 * tmp3;

    return tmp4;
}

/* Compute Metrics Basic set :: Typed Atomics */
uint64_t
hsw__compute_basic__typed_atomics__read(const struct intel_perf *perf,
                                        const struct intel_perf_metric_set *metric_set,
                                        uint64_t *accumulator)
{
    /* RPN equation: C 0 READ C 1 READ UADD $EuSlicesTotalCount UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = tmp2 * perf->devinfo.n_eu_slices;

    return tmp3;
}

/* Compute Metrics Basic set :: Untyped Bytes Read */
uint64_t
hsw__compute_basic__untyped_bytes_read__read(const struct intel_perf *perf,
                                             const struct intel_perf_metric_set *metric_set,
                                             uint64_t *accumulator)
{
    /* RPN equation: B 0 READ B 1 READ UADD $EuSlicesTotalCount 64 UMUL UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = perf->devinfo.n_eu_slices * 64;
    uint64_t tmp4 = tmp2 * tmp3;

    return tmp4;
}

/* Compute Metrics Basic set :: Untyped Writes */
uint64_t
hsw__compute_basic__untyped_bytes_written__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: B 2 READ B 3 READ UADD $EuSlicesTotalCount 64 UMUL UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = perf->devinfo.n_eu_slices * 64;
    uint64_t tmp4 = tmp2 * tmp3;

    return tmp4;
}

/* Compute Metrics Basic set :: SLM Bytes Read */
uint64_t
hsw__compute_basic__slm_bytes_read__read(const struct intel_perf *perf,
                                         const struct intel_perf_metric_set *metric_set,
                                         uint64_t *accumulator)
{
    /* RPN equation: C 6 READ C 7 READ UADD $EuSlicesTotalCount 64 UMUL UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = perf->devinfo.n_eu_slices * 64;
    uint64_t tmp4 = tmp2 * tmp3;

    return tmp4;
}

/* Compute Metrics Basic set :: SLM Bytes Written */
uint64_t
hsw__compute_basic__slm_bytes_written__read(const struct intel_perf *perf,
                                            const struct intel_perf_metric_set *metric_set,
                                            uint64_t *accumulator)
{
    /* RPN equation: C 4 READ C 5 READ UADD $EuSlicesTotalCount 64 UMUL UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = perf->devinfo.n_eu_slices * 64;
    uint64_t tmp4 = tmp2 * tmp3;

    return tmp4;
}

/* Compute Metrics Extended set :: GPU Core Clocks */
uint64_t
hsw__compute_extended__gpu_clocks__read(const struct intel_perf *perf,
                                        const struct intel_perf_metric_set *metric_set,
                                        uint64_t *accumulator)
{
    /* RPN equation: B 7 READ */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 7];

    return tmp0;
}

/* Compute Metrics Extended set :: EuUntypedReads0 */
uint64_t
hsw__compute_extended__eu_untyped_reads0__read(const struct intel_perf *perf,
                                               const struct intel_perf_metric_set *metric_set,
                                               uint64_t *accumulator)
{
    /* RPN equation: B 0 READ */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 0];

    return tmp0;
}

/* Compute Metrics Extended set :: EuTypedReads0 */
uint64_t
hsw__compute_extended__eu_typed_reads0__read(const struct intel_perf *perf,
                                             const struct intel_perf_metric_set *metric_set,
                                             uint64_t *accumulator)
{
    /* RPN equation: B 2 READ */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 2];

    return tmp0;
}

/* Compute Metrics Extended set :: EuUntypedWrites0 */
uint64_t
hsw__compute_extended__eu_untyped_writes0__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: B 1 READ */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 1];

    return tmp0;
}

/* Compute Metrics Extended set :: EuTypedWrites0 */
uint64_t
hsw__compute_extended__eu_typed_writes0__read(const struct intel_perf *perf,
                                              const struct intel_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: B 3 READ */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 3];

    return tmp0;
}

/* Compute Metrics Extended set :: EuUntypedAtomics0 */
uint64_t
hsw__compute_extended__eu_untyped_atomics0__read(const struct intel_perf *perf,
                                                 const struct intel_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: B 4 READ */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 4];

    return tmp0;
}

/* Compute Metrics Extended set :: EuTypedAtomics0 */
uint64_t
hsw__compute_extended__eu_typed_atomics0__read(const struct intel_perf *perf,
                                               const struct intel_perf_metric_set *metric_set,
                                               uint64_t *accumulator)
{
    /* RPN equation: B 5 READ */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 5];

    return tmp0;
}

/* Compute Metrics Extended set :: EuUrbAtomics0 */
uint64_t
hsw__compute_extended__eu_urb_atomics0__read(const struct intel_perf *perf,
                                             const struct intel_perf_metric_set *metric_set,
                                             uint64_t *accumulator)
{
    /* RPN equation: B 6 READ */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 6];

    return tmp0;
}

/* Compute Metrics Extended set :: Typed Writes 0 */
uint64_t
hsw__compute_extended__typed_writes0__read(const struct intel_perf *perf,
                                           const struct intel_perf_metric_set *metric_set,
                                           uint64_t *accumulator)
{
    /* RPN equation: C 0 READ */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 0];

    return tmp0;
}

/* Compute Metrics Extended set :: Untyped Reads 0 */
uint64_t
hsw__compute_extended__untyped_reads0__read(const struct intel_perf *perf,
                                            const struct intel_perf_metric_set *metric_set,
                                            uint64_t *accumulator)
{
    /* RPN equation: C 3 READ */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 3];

    return tmp0;
}

/* Compute Metrics Extended set :: Untyped Writes 0 */
uint64_t
hsw__compute_extended__untyped_writes0__read(const struct intel_perf *perf,
                                             const struct intel_perf_metric_set *metric_set,
                                             uint64_t *accumulator)
{
    /* RPN equation: C 1 READ */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 1];

    return tmp0;
}

/* Compute Metrics Extended set :: Typed Atomics 0 */
uint64_t
hsw__compute_extended__typed_atomics0__read(const struct intel_perf *perf,
                                            const struct intel_perf_metric_set *metric_set,
                                            uint64_t *accumulator)
{
    /* RPN equation: C 4 READ */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 4];

    return tmp0;
}

/* Compute Metrics Extended set :: TypedReadsPerCacheLine */
double
hsw__compute_extended__typed_reads_per_cache_line__read(const struct intel_perf *perf,
                                                        const struct intel_perf_metric_set *metric_set,
                                                        uint64_t *accumulator)
{
    /* RPN equation: $EuTypedReads0 $TypedReads0 FDIV */
    double tmp0 = hsw__compute_extended__eu_typed_reads0__read(perf, metric_set, accumulator);
    double tmp1 = hsw__compute_extended__typed_reads0__read(perf, metric_set, accumulator);
    double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

    return tmp2;
}

/* Compute Metrics Extended set :: TypedWritesPerCacheLine */
double
hsw__compute_extended__typed_writes_per_cache_line__read(const struct intel_perf *perf,
                                                         const struct intel_perf_metric_set *metric_set,
                                                         uint64_t *accumulator)
{
    /* RPN equation: $EuTypedWrites0 $TypedWrites0 FDIV */
    double tmp0 = hsw__compute_extended__eu_typed_writes0__read(perf, metric_set, accumulator);
    double tmp1 = hsw__compute_extended__typed_writes0__read(perf, metric_set, accumulator);
    double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

    return tmp2;
}

/* Compute Metrics Extended set :: UntypedReadsPerCacheLine */
double
hsw__compute_extended__untyped_reads_per_cache_line__read(const struct intel_perf *perf,
                                                          const struct intel_perf_metric_set *metric_set,
                                                          uint64_t *accumulator)
{
    /* RPN equation: $EuUntypedReads0 $UntypedReads0 FDIV */
    double tmp0 = hsw__compute_extended__eu_untyped_reads0__read(perf, metric_set, accumulator);
    double tmp1 = hsw__compute_extended__untyped_reads0__read(perf, metric_set, accumulator);
    double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

    return tmp2;
}

/* Compute Metrics Extended set :: UntypedWritesPerCacheLine */
double
hsw__compute_extended__untyped_writes_per_cache_line__read(const struct intel_perf *perf,
                                                           const struct intel_perf_metric_set *metric_set,
                                                           uint64_t *accumulator)
{
    /* RPN equation: $EuUntypedWrites0 $UntypedWrites0 FDIV */
    double tmp0 = hsw__compute_extended__eu_untyped_writes0__read(perf, metric_set, accumulator);
    double tmp1 = hsw__compute_extended__untyped_writes0__read(perf, metric_set, accumulator);
    double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

    return tmp2;
}

/* Compute Metrics Extended set :: TypedAtomicsPerCacheLine */
double
hsw__compute_extended__typed_atomics_per_cache_line__read(const struct intel_perf *perf,
                                                          const struct intel_perf_metric_set *metric_set,
                                                          uint64_t *accumulator)
{
    /* RPN equation: $EuTypedAtomics0 $TypedAtomics0 FDIV */
    double tmp0 = hsw__compute_extended__eu_typed_atomics0__read(perf, metric_set, accumulator);
    double tmp1 = hsw__compute_extended__typed_atomics0__read(perf, metric_set, accumulator);
    double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

    return tmp2;
}

/* Memory Reads Distribution set :: GPU Core Clocks */
uint64_t
hsw__memory_reads__gpu_core_clocks__read(const struct intel_perf *perf,
                                         const struct intel_perf_metric_set *metric_set,
                                         uint64_t *accumulator)
{
    /* RPN equation: C 7 READ */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 7];

    return tmp0;
}

/* Memory Reads Distribution set :: AVG GPU Core Frequency */
uint64_t
hsw__memory_reads__avg_gpu_core_frequency__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
    uint64_t tmp0 = hsw__memory_reads__gpu_core_clocks__read(perf, metric_set, accumulator) * 1000000000;
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = hsw__memory_reads__gpu_time__read(perf, metric_set, accumulator);
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

    return tmp3;
}

/* Memory Reads Distribution set :: GPU Busy */
double
hsw__memory_reads__gpu_busy__read(const struct intel_perf *perf,
                                  const struct intel_perf_metric_set *metric_set,
                                  uint64_t *accumulator)
{
    /* RPN equation: A 41 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 41];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = hsw__memory_reads__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* Memory Reads Distribution set :: EU Active */
double
hsw__memory_reads__eu_active__read(const struct intel_perf *perf,
                                   const struct intel_perf_metric_set *metric_set,
                                   uint64_t *accumulator)
{
    /* RPN equation: A 0 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 0];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__memory_reads__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Memory Reads Distribution set :: EU Stall */
double
hsw__memory_reads__eu_stall__read(const struct intel_perf *perf,
                                  const struct intel_perf_metric_set *metric_set,
                                  uint64_t *accumulator)
{
    /* RPN equation: A 1 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 1];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__memory_reads__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Memory Reads Distribution set :: VS EU Active */
double
hsw__memory_reads__vs_eu_active__read(const struct intel_perf *perf,
                                      const struct intel_perf_metric_set *metric_set,
                                      uint64_t *accumulator)
{
    /* RPN equation: A 2 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 2];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__memory_reads__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Memory Reads Distribution set :: VS EU Stall */
double
hsw__memory_reads__vs_eu_stall__read(const struct intel_perf *perf,
                                     const struct intel_perf_metric_set *metric_set,
                                     uint64_t *accumulator)
{
    /* RPN equation: A 3 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 3];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__memory_reads__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Memory Reads Distribution set :: TCS EU Active */
double
hsw__memory_reads__hs_eu_active__read(const struct intel_perf *perf,
                                      const struct intel_perf_metric_set *metric_set,
                                      uint64_t *accumulator)
{
    /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 7];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__memory_reads__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Memory Reads Distribution set :: TCS EU Stall */
double
hsw__memory_reads__hs_eu_stall__read(const struct intel_perf *perf,
                                     const struct intel_perf_metric_set *metric_set,
                                     uint64_t *accumulator)
{
    /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 8];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__memory_reads__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Memory Reads Distribution set :: TES EU Active */
double
hsw__memory_reads__ds_eu_active__read(const struct intel_perf *perf,
                                      const struct intel_perf_metric_set *metric_set,
                                      uint64_t *accumulator)
{
    /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 12];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__memory_reads__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Memory Reads Distribution set :: TES EU Stall */
double
hsw__memory_reads__ds_eu_stall__read(const struct intel_perf *perf,
                                     const struct intel_perf_metric_set *metric_set,
                                     uint64_t *accumulator)
{
    /* RPN equation: A 13 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 13];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__memory_reads__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Memory Reads Distribution set :: GS EU Active */
double
hsw__memory_reads__gs_eu_active__read(const struct intel_perf *perf,
                                      const struct intel_perf_metric_set *metric_set,
                                      uint64_t *accumulator)
{
    /* RPN equation: A 22 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 22];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__memory_reads__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Memory Reads Distribution set :: GS EU Stall */
double
hsw__memory_reads__gs_eu_stall__read(const struct intel_perf *perf,
                                     const struct intel_perf_metric_set *metric_set,
                                     uint64_t *accumulator)
{
    /* RPN equation: A 23 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 23];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__memory_reads__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Memory Reads Distribution set :: CS EU Active */
double
hsw__memory_reads__cs_eu_active__read(const struct intel_perf *perf,
                                      const struct intel_perf_metric_set *metric_set,
                                      uint64_t *accumulator)
{
    /* RPN equation: A 17 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 17];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__memory_reads__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Memory Reads Distribution set :: CS EU Stall */
double
hsw__memory_reads__cs_eu_stall__read(const struct intel_perf *perf,
                                     const struct intel_perf_metric_set *metric_set,
                                     uint64_t *accumulator)
{
    /* RPN equation: A 18 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 18];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__memory_reads__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Memory Reads Distribution set :: FS EU Active */
double
hsw__memory_reads__ps_eu_active__read(const struct intel_perf *perf,
                                      const struct intel_perf_metric_set *metric_set,
                                      uint64_t *accumulator)
{
    /* RPN equation: A 27 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 27];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__memory_reads__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Memory Reads Distribution set :: FS EU Stall */
double
hsw__memory_reads__ps_eu_stall__read(const struct intel_perf *perf,
                                     const struct intel_perf_metric_set *metric_set,
                                     uint64_t *accumulator)
{
    /* RPN equation: A 28 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 28];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__memory_reads__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Memory Reads Distribution set :: GtiMemoryReads */
uint64_t
hsw__memory_reads__gti_memory_reads__read(const struct intel_perf *perf,
                                          const struct intel_perf_metric_set *metric_set,
                                          uint64_t *accumulator)
{
    /* RPN equation: C 5 READ */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 5];

    return tmp0;
}

/* Memory Reads Distribution set :: LLC GPU Read Accesses */
uint64_t
hsw__memory_reads__llc_read_accesses__read(const struct intel_perf *perf,
                                           const struct intel_perf_metric_set *metric_set,
                                           uint64_t *accumulator)
{
    /* RPN equation: C 6 READ */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 6];

    return tmp0;
}

/* Memory Writes Distribution set :: LLC GPU Write Accesses */
uint64_t
hsw__memory_writes__llc_wr_accesses__read(const struct intel_perf *perf,
                                          const struct intel_perf_metric_set *metric_set,
                                          uint64_t *accumulator)
{
    /* RPN equation: C 6 READ 2 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp1 = tmp0 * 2;

    return tmp1;
}

/* Memory Writes Distribution set :: LLC GPU Throughput */
uint64_t
hsw__memory_writes__llc_gpu_throughput__read(const struct intel_perf *perf,
                                             const struct intel_perf_metric_set *metric_set,
                                             uint64_t *accumulator)
{
    /* RPN equation: PERFCNT 0 READ $LlcWrAccesses USUB 64 UMUL $LlcWrAccesses 32 UMUL UADD */
    uint64_t tmp0 = accumulator[metric_set->perfcnt_offset + 0];
    uint64_t tmp1 = tmp0 - hsw__memory_writes__llc_wr_accesses__read(perf, metric_set, accumulator);
    uint64_t tmp2 = tmp1 * 64;
    uint64_t tmp3 = hsw__memory_writes__llc_wr_accesses__read(perf, metric_set, accumulator) * 32;
    uint64_t tmp4 = tmp2 + tmp3;

    return tmp4;
}

/* Metric set SamplerBalance :: AVG GPU Core Frequency */
uint64_t
hsw__sampler_balance__avg_gpu_core_frequency__read(const struct intel_perf *perf,
                                                   const struct intel_perf_metric_set *metric_set,
                                                   uint64_t *accumulator)
{
    /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
    uint64_t tmp0 = hsw__sampler_balance__gpu_core_clocks__read(perf, metric_set, accumulator) * 1000000000;
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = hsw__sampler_balance__gpu_time__read(perf, metric_set, accumulator);
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

    return tmp3;
}

/* Metric set SamplerBalance :: GPU Busy */
double
hsw__sampler_balance__gpu_busy__read(const struct intel_perf *perf,
                                     const struct intel_perf_metric_set *metric_set,
                                     uint64_t *accumulator)
{
    /* RPN equation: A 41 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 41];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = hsw__sampler_balance__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* Metric set SamplerBalance :: EU Active */
double
hsw__sampler_balance__eu_active__read(const struct intel_perf *perf,
                                      const struct intel_perf_metric_set *metric_set,
                                      uint64_t *accumulator)
{
    /* RPN equation: A 0 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 0];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__sampler_balance__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Metric set SamplerBalance :: EU Stall */
double
hsw__sampler_balance__eu_stall__read(const struct intel_perf *perf,
                                     const struct intel_perf_metric_set *metric_set,
                                     uint64_t *accumulator)
{
    /* RPN equation: A 1 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 1];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__sampler_balance__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Metric set SamplerBalance :: VS EU Active */
double
hsw__sampler_balance__vs_eu_active__read(const struct intel_perf *perf,
                                         const struct intel_perf_metric_set *metric_set,
                                         uint64_t *accumulator)
{
    /* RPN equation: A 2 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 2];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__sampler_balance__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Metric set SamplerBalance :: VS EU Stall */
double
hsw__sampler_balance__vs_eu_stall__read(const struct intel_perf *perf,
                                        const struct intel_perf_metric_set *metric_set,
                                        uint64_t *accumulator)
{
    /* RPN equation: A 3 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 3];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__sampler_balance__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Metric set SamplerBalance :: TCS EU Active */
double
hsw__sampler_balance__hs_eu_active__read(const struct intel_perf *perf,
                                         const struct intel_perf_metric_set *metric_set,
                                         uint64_t *accumulator)
{
    /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 7];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__sampler_balance__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Metric set SamplerBalance :: TCS EU Stall */
double
hsw__sampler_balance__hs_eu_stall__read(const struct intel_perf *perf,
                                        const struct intel_perf_metric_set *metric_set,
                                        uint64_t *accumulator)
{
    /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 8];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__sampler_balance__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Metric set SamplerBalance :: TES EU Active */
double
hsw__sampler_balance__ds_eu_active__read(const struct intel_perf *perf,
                                         const struct intel_perf_metric_set *metric_set,
                                         uint64_t *accumulator)
{
    /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 12];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__sampler_balance__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Metric set SamplerBalance :: TES EU Stall */
double
hsw__sampler_balance__ds_eu_stall__read(const struct intel_perf *perf,
                                        const struct intel_perf_metric_set *metric_set,
                                        uint64_t *accumulator)
{
    /* RPN equation: A 13 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 13];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__sampler_balance__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Metric set SamplerBalance :: GS EU Active */
double
hsw__sampler_balance__gs_eu_active__read(const struct intel_perf *perf,
                                         const struct intel_perf_metric_set *metric_set,
                                         uint64_t *accumulator)
{
    /* RPN equation: A 22 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 22];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__sampler_balance__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Metric set SamplerBalance :: GS EU Stall */
double
hsw__sampler_balance__gs_eu_stall__read(const struct intel_perf *perf,
                                        const struct intel_perf_metric_set *metric_set,
                                        uint64_t *accumulator)
{
    /* RPN equation: A 23 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 23];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__sampler_balance__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Metric set SamplerBalance :: CS EU Active */
double
hsw__sampler_balance__cs_eu_active__read(const struct intel_perf *perf,
                                         const struct intel_perf_metric_set *metric_set,
                                         uint64_t *accumulator)
{
    /* RPN equation: A 17 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 17];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__sampler_balance__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Metric set SamplerBalance :: CS EU Stall */
double
hsw__sampler_balance__cs_eu_stall__read(const struct intel_perf *perf,
                                        const struct intel_perf_metric_set *metric_set,
                                        uint64_t *accumulator)
{
    /* RPN equation: A 18 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 18];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__sampler_balance__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Metric set SamplerBalance :: FS EU Active */
double
hsw__sampler_balance__ps_eu_active__read(const struct intel_perf *perf,
                                         const struct intel_perf_metric_set *metric_set,
                                         uint64_t *accumulator)
{
    /* RPN equation: A 27 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 27];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__sampler_balance__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Metric set SamplerBalance :: FS EU Stall */
double
hsw__sampler_balance__ps_eu_stall__read(const struct intel_perf *perf,
                                        const struct intel_perf_metric_set *metric_set,
                                        uint64_t *accumulator)
{
    /* RPN equation: A 28 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 28];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = hsw__sampler_balance__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Metric set SamplerBalance :: FS Duration */
uint64_t
hsw__sampler_balance__ps_duration__read(const struct intel_perf *perf,
                                        const struct intel_perf_metric_set *metric_set,
                                        uint64_t *accumulator)
{
    /* RPN equation: A 27 READ  A 0 READ UMUL  A 2 READ  A 7 READ UADD  A 12 READ UADD  A 17 READ UADD  A 22 READ UADD  A 27 READ UADD UDIV  A 28 READ  A 1 READ UMUL  A 3 READ  A 8 READ UADD  A 13 READ UADD  A 18 READ UADD  A 23 READ UADD  A 28 READ UADD UDIV UADD $GpuTime UMUL $GpuCoreClocks $EuCoresTotalCount UMUL 1000 UMUL UDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 27];
    uint64_t tmp1 = accumulator[metric_set->a_offset + 0];
    uint64_t tmp2 = tmp0 * tmp1;
    uint64_t tmp3 = accumulator[metric_set->a_offset + 2];
    uint64_t tmp4 = accumulator[metric_set->a_offset + 7];
    uint64_t tmp5 = tmp3 + tmp4;
    uint64_t tmp6 = accumulator[metric_set->a_offset + 12];
    uint64_t tmp7 = tmp5 + tmp6;
    uint64_t tmp8 = accumulator[metric_set->a_offset + 17];
    uint64_t tmp9 = tmp7 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->a_offset + 22];
    uint64_t tmp11 = tmp9 + tmp10;
    uint64_t tmp12 = accumulator[metric_set->a_offset + 27];
    uint64_t tmp13 = tmp11 + tmp12;
    uint64_t tmp14 = tmp2;
    uint64_t tmp15 = tmp13;
    uint64_t tmp16 = tmp15 ? tmp14 / tmp15 : 0;
    uint64_t tmp17 = accumulator[metric_set->a_offset + 28];
    uint64_t tmp18 = accumulator[metric_set->a_offset + 1];
    uint64_t tmp19 = tmp17 * tmp18;
    uint64_t tmp20 = accumulator[metric_set->a_offset + 3];
    uint64_t tmp21 = accumulator[metric_set->a_offset + 8];
    uint64_t tmp22 = tmp20 + tmp21;
    uint64_t tmp23 = accumulator[metric_set->a_offset + 13];
    uint64_t tmp24 = tmp22 + tmp23;
    uint64_t tmp25 = accumulator[metric_set->a_offset + 18];
    uint64_t tmp26 = tmp24 + tmp25;
    uint64_t tmp27 = accumulator[metric_set->a_offset + 23];
    uint64_t tmp28 = tmp26 + tmp27;
    uint64_t tmp29 = accumulator[metric_set->a_offset + 28];
    uint64_t tmp30 = tmp28 + tmp29;
    uint64_t tmp31 = tmp19;
    uint64_t tmp32 = tmp30;
    uint64_t tmp33 = tmp32 ? tmp31 / tmp32 : 0;
    uint64_t tmp34 = tmp16 + tmp33;
    uint64_t tmp35 = tmp34 * hsw__sampler_balance__gpu_time__read(perf, metric_set, accumulator);
    uint64_t tmp36 = hsw__sampler_balance__gpu_core_clocks__read(perf, metric_set, accumulator) * perf->devinfo.n_eus;
    uint64_t tmp37 = tmp36 * 1000;
    uint64_t tmp38 = tmp35;
    uint64_t tmp39 = tmp37;
    uint64_t tmp40 = tmp39 ? tmp38 / tmp39 : 0;

    return tmp40;
}

/* Metric set SamplerBalance :: VS Duration */
uint64_t
hsw__sampler_balance__vs_duration__read(const struct intel_perf *perf,
                                        const struct intel_perf_metric_set *metric_set,
                                        uint64_t *accumulator)
{
    /* RPN equation: A 2 READ  A 0 READ UMUL  A 2 READ  A 7 READ UADD  A 12 READ UADD  A 17 READ UADD  A 22 READ UADD  A 27 READ UADD UDIV  A 3 READ  A 1 READ UMUL  A 3 READ  A 8 READ UADD  A 13 READ UADD  A 18 READ UADD  A 23 READ UADD  A 28 READ UADD UDIV UADD $GpuTime UMUL $GpuCoreClocks $EuCoresTotalCount UMUL 1000 UMUL UDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 2];
    uint64_t tmp1 = accumulator[metric_set->a_offset + 0];
    uint64_t tmp2 = tmp0 * tmp1;
    uint64_t tmp3 = accumulator[metric_set->a_offset + 2];
    uint64_t tmp4 = accumulator[metric_set->a_offset + 7];
    uint64_t tmp5 = tmp3 + tmp4;
    uint64_t tmp6 = accumulator[metric_set->a_offset + 12];
    uint64_t tmp7 = tmp5 + tmp6;
    uint64_t tmp8 = accumulator[metric_set->a_offset + 17];
    uint64_t tmp9 = tmp7 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->a_offset + 22];
    uint64_t tmp11 = tmp9 + tmp10;
    uint64_t tmp12 = accumulator[metric_set->a_offset + 27];
    uint64_t tmp13 = tmp11 + tmp12;
    uint64_t tmp14 = tmp2;
    uint64_t tmp15 = tmp13;
    uint64_t tmp16 = tmp15 ? tmp14 / tmp15 : 0;
    uint64_t tmp17 = accumulator[metric_set->a_offset + 3];
    uint64_t tmp18 = accumulator[metric_set->a_offset + 1];
    uint64_t tmp19 = tmp17 * tmp18;
    uint64_t tmp20 = accumulator[metric_set->a_offset + 3];
    uint64_t tmp21 = accumulator[metric_set->a_offset + 8];
    uint64_t tmp22 = tmp20 + tmp21;
    uint64_t tmp23 = accumulator[metric_set->a_offset + 13];
    uint64_t tmp24 = tmp22 + tmp23;
    uint64_t tmp25 = accumulator[metric_set->a_offset + 18];
    uint64_t tmp26 = tmp24 + tmp25;
    uint64_t tmp27 = accumulator[metric_set->a_offset + 23];
    uint64_t tmp28 = tmp26 + tmp27;
    uint64_t tmp29 = accumulator[metric_set->a_offset + 28];
    uint64_t tmp30 = tmp28 + tmp29;
    uint64_t tmp31 = tmp19;
    uint64_t tmp32 = tmp30;
    uint64_t tmp33 = tmp32 ? tmp31 / tmp32 : 0;
    uint64_t tmp34 = tmp16 + tmp33;
    uint64_t tmp35 = tmp34 * hsw__sampler_balance__gpu_time__read(perf, metric_set, accumulator);
    uint64_t tmp36 = hsw__sampler_balance__gpu_core_clocks__read(perf, metric_set, accumulator) * perf->devinfo.n_eus;
    uint64_t tmp37 = tmp36 * 1000;
    uint64_t tmp38 = tmp35;
    uint64_t tmp39 = tmp37;
    uint64_t tmp40 = tmp39 ? tmp38 / tmp39 : 0;

    return tmp40;
}

/* Metric set SamplerBalance :: GS Duration */
uint64_t
hsw__sampler_balance__gs_duration__read(const struct intel_perf *perf,
                                        const struct intel_perf_metric_set *metric_set,
                                        uint64_t *accumulator)
{
    /* RPN equation: A 22 READ  A 0 READ UMUL  A 2 READ  A 7 READ UADD  A 12 READ UADD  A 17 READ UADD  A 22 READ UADD  A 27 READ UADD UDIV  A 23 READ  A 1 READ UMUL  A 3 READ  A 8 READ UADD  A 13 READ UADD  A 18 READ UADD  A 23 READ UADD  A 28 READ UADD UDIV UADD $GpuTime UMUL $GpuCoreClocks $EuCoresTotalCount UMUL 1000 UMUL UDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 22];
    uint64_t tmp1 = accumulator[metric_set->a_offset + 0];
    uint64_t tmp2 = tmp0 * tmp1;
    uint64_t tmp3 = accumulator[metric_set->a_offset + 2];
    uint64_t tmp4 = accumulator[metric_set->a_offset + 7];
    uint64_t tmp5 = tmp3 + tmp4;
    uint64_t tmp6 = accumulator[metric_set->a_offset + 12];
    uint64_t tmp7 = tmp5 + tmp6;
    uint64_t tmp8 = accumulator[metric_set->a_offset + 17];
    uint64_t tmp9 = tmp7 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->a_offset + 22];
    uint64_t tmp11 = tmp9 + tmp10;
    uint64_t tmp12 = accumulator[metric_set->a_offset + 27];
    uint64_t tmp13 = tmp11 + tmp12;
    uint64_t tmp14 = tmp2;
    uint64_t tmp15 = tmp13;
    uint64_t tmp16 = tmp15 ? tmp14 / tmp15 : 0;
    uint64_t tmp17 = accumulator[metric_set->a_offset + 23];
    uint64_t tmp18 = accumulator[metric_set->a_offset + 1];
    uint64_t tmp19 = tmp17 * tmp18;
    uint64_t tmp20 = accumulator[metric_set->a_offset + 3];
    uint64_t tmp21 = accumulator[metric_set->a_offset + 8];
    uint64_t tmp22 = tmp20 + tmp21;
    uint64_t tmp23 = accumulator[metric_set->a_offset + 13];
    uint64_t tmp24 = tmp22 + tmp23;
    uint64_t tmp25 = accumulator[metric_set->a_offset + 18];
    uint64_t tmp26 = tmp24 + tmp25;
    uint64_t tmp27 = accumulator[metric_set->a_offset + 23];
    uint64_t tmp28 = tmp26 + tmp27;
    uint64_t tmp29 = accumulator[metric_set->a_offset + 28];
    uint64_t tmp30 = tmp28 + tmp29;
    uint64_t tmp31 = tmp19;
    uint64_t tmp32 = tmp30;
    uint64_t tmp33 = tmp32 ? tmp31 / tmp32 : 0;
    uint64_t tmp34 = tmp16 + tmp33;
    uint64_t tmp35 = tmp34 * hsw__sampler_balance__gpu_time__read(perf, metric_set, accumulator);
    uint64_t tmp36 = hsw__sampler_balance__gpu_core_clocks__read(perf, metric_set, accumulator) * perf->devinfo.n_eus;
    uint64_t tmp37 = tmp36 * 1000;
    uint64_t tmp38 = tmp35;
    uint64_t tmp39 = tmp37;
    uint64_t tmp40 = tmp39 ? tmp38 / tmp39 : 0;

    return tmp40;
}

/* Metric set SamplerBalance :: TES Duration */
uint64_t
hsw__sampler_balance__ds_duration__read(const struct intel_perf *perf,
                                        const struct intel_perf_metric_set *metric_set,
                                        uint64_t *accumulator)
{
    /* RPN equation: A 12 READ  A 0 READ UMUL  A 2 READ  A 7 READ UADD  A 12 READ UADD  A 17 READ UADD  A 22 READ UADD  A 27 READ UADD UDIV  A 13 READ  A 1 READ UMUL  A 3 READ  A 8 READ UADD  A 13 READ UADD  A 18 READ UADD  A 23 READ UADD  A 28 READ UADD UDIV UADD $GpuTime UMUL $GpuCoreClocks $EuCoresTotalCount UMUL 1000 UMUL UDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 12];
    uint64_t tmp1 = accumulator[metric_set->a_offset + 0];
    uint64_t tmp2 = tmp0 * tmp1;
    uint64_t tmp3 = accumulator[metric_set->a_offset + 2];
    uint64_t tmp4 = accumulator[metric_set->a_offset + 7];
    uint64_t tmp5 = tmp3 + tmp4;
    uint64_t tmp6 = accumulator[metric_set->a_offset + 12];
    uint64_t tmp7 = tmp5 + tmp6;
    uint64_t tmp8 = accumulator[metric_set->a_offset + 17];
    uint64_t tmp9 = tmp7 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->a_offset + 22];
    uint64_t tmp11 = tmp9 + tmp10;
    uint64_t tmp12 = accumulator[metric_set->a_offset + 27];
    uint64_t tmp13 = tmp11 + tmp12;
    uint64_t tmp14 = tmp2;
    uint64_t tmp15 = tmp13;
    uint64_t tmp16 = tmp15 ? tmp14 / tmp15 : 0;
    uint64_t tmp17 = accumulator[metric_set->a_offset + 13];
    uint64_t tmp18 = accumulator[metric_set->a_offset + 1];
    uint64_t tmp19 = tmp17 * tmp18;
    uint64_t tmp20 = accumulator[metric_set->a_offset + 3];
    uint64_t tmp21 = accumulator[metric_set->a_offset + 8];
    uint64_t tmp22 = tmp20 + tmp21;
    uint64_t tmp23 = accumulator[metric_set->a_offset + 13];
    uint64_t tmp24 = tmp22 + tmp23;
    uint64_t tmp25 = accumulator[metric_set->a_offset + 18];
    uint64_t tmp26 = tmp24 + tmp25;
    uint64_t tmp27 = accumulator[metric_set->a_offset + 23];
    uint64_t tmp28 = tmp26 + tmp27;
    uint64_t tmp29 = accumulator[metric_set->a_offset + 28];
    uint64_t tmp30 = tmp28 + tmp29;
    uint64_t tmp31 = tmp19;
    uint64_t tmp32 = tmp30;
    uint64_t tmp33 = tmp32 ? tmp31 / tmp32 : 0;
    uint64_t tmp34 = tmp16 + tmp33;
    uint64_t tmp35 = tmp34 * hsw__sampler_balance__gpu_time__read(perf, metric_set, accumulator);
    uint64_t tmp36 = hsw__sampler_balance__gpu_core_clocks__read(perf, metric_set, accumulator) * perf->devinfo.n_eus;
    uint64_t tmp37 = tmp36 * 1000;
    uint64_t tmp38 = tmp35;
    uint64_t tmp39 = tmp37;
    uint64_t tmp40 = tmp39 ? tmp38 / tmp39 : 0;

    return tmp40;
}

/* Metric set SamplerBalance :: TCS Duration */
uint64_t
hsw__sampler_balance__hs_duration__read(const struct intel_perf *perf,
                                        const struct intel_perf_metric_set *metric_set,
                                        uint64_t *accumulator)
{
    /* RPN equation: A 7 READ  A 0 READ UMUL  A 2 READ  A 7 READ UADD  A 12 READ UADD  A 17 READ UADD  A 22 READ UADD  A 27 READ UADD UDIV  A 8 READ  A 1 READ UMUL  A 3 READ  A 8 READ UADD  A 13 READ UADD  A 18 READ UADD  A 23 READ UADD  A 28 READ UADD UDIV UADD $GpuTime UMUL $GpuCoreClocks $EuCoresTotalCount UMUL 1000 UMUL UDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->a_offset + 0];
    uint64_t tmp2 = tmp0 * tmp1;
    uint64_t tmp3 = accumulator[metric_set->a_offset + 2];
    uint64_t tmp4 = accumulator[metric_set->a_offset + 7];
    uint64_t tmp5 = tmp3 + tmp4;
    uint64_t tmp6 = accumulator[metric_set->a_offset + 12];
    uint64_t tmp7 = tmp5 + tmp6;
    uint64_t tmp8 = accumulator[metric_set->a_offset + 17];
    uint64_t tmp9 = tmp7 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->a_offset + 22];
    uint64_t tmp11 = tmp9 + tmp10;
    uint64_t tmp12 = accumulator[metric_set->a_offset + 27];
    uint64_t tmp13 = tmp11 + tmp12;
    uint64_t tmp14 = tmp2;
    uint64_t tmp15 = tmp13;
    uint64_t tmp16 = tmp15 ? tmp14 / tmp15 : 0;
    uint64_t tmp17 = accumulator[metric_set->a_offset + 8];
    uint64_t tmp18 = accumulator[metric_set->a_offset + 1];
    uint64_t tmp19 = tmp17 * tmp18;
    uint64_t tmp20 = accumulator[metric_set->a_offset + 3];
    uint64_t tmp21 = accumulator[metric_set->a_offset + 8];
    uint64_t tmp22 = tmp20 + tmp21;
    uint64_t tmp23 = accumulator[metric_set->a_offset + 13];
    uint64_t tmp24 = tmp22 + tmp23;
    uint64_t tmp25 = accumulator[metric_set->a_offset + 18];
    uint64_t tmp26 = tmp24 + tmp25;
    uint64_t tmp27 = accumulator[metric_set->a_offset + 23];
    uint64_t tmp28 = tmp26 + tmp27;
    uint64_t tmp29 = accumulator[metric_set->a_offset + 28];
    uint64_t tmp30 = tmp28 + tmp29;
    uint64_t tmp31 = tmp19;
    uint64_t tmp32 = tmp30;
    uint64_t tmp33 = tmp32 ? tmp31 / tmp32 : 0;
    uint64_t tmp34 = tmp16 + tmp33;
    uint64_t tmp35 = tmp34 * hsw__sampler_balance__gpu_time__read(perf, metric_set, accumulator);
    uint64_t tmp36 = hsw__sampler_balance__gpu_core_clocks__read(perf, metric_set, accumulator) * perf->devinfo.n_eus;
    uint64_t tmp37 = tmp36 * 1000;
    uint64_t tmp38 = tmp35;
    uint64_t tmp39 = tmp37;
    uint64_t tmp40 = tmp39 ? tmp38 / tmp39 : 0;

    return tmp40;
}

/* Metric set SamplerBalance :: CS Duration */
uint64_t
hsw__sampler_balance__cs_duration__read(const struct intel_perf *perf,
                                        const struct intel_perf_metric_set *metric_set,
                                        uint64_t *accumulator)
{
    /* RPN equation: A 17 READ  A 0 READ UMUL  A 2 READ  A 7 READ UADD  A 12 READ UADD  A 17 READ UADD  A 22 READ UADD  A 27 READ UADD UDIV  A 18 READ  A 1 READ UMUL  A 3 READ  A 8 READ UADD  A 13 READ UADD  A 18 READ UADD  A 23 READ UADD  A 28 READ UADD UDIV UADD $GpuTime UMUL $GpuCoreClocks $EuCoresTotalCount UMUL 1000 UMUL UDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 17];
    uint64_t tmp1 = accumulator[metric_set->a_offset + 0];
    uint64_t tmp2 = tmp0 * tmp1;
    uint64_t tmp3 = accumulator[metric_set->a_offset + 2];
    uint64_t tmp4 = accumulator[metric_set->a_offset + 7];
    uint64_t tmp5 = tmp3 + tmp4;
    uint64_t tmp6 = accumulator[metric_set->a_offset + 12];
    uint64_t tmp7 = tmp5 + tmp6;
    uint64_t tmp8 = accumulator[metric_set->a_offset + 17];
    uint64_t tmp9 = tmp7 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->a_offset + 22];
    uint64_t tmp11 = tmp9 + tmp10;
    uint64_t tmp12 = accumulator[metric_set->a_offset + 27];
    uint64_t tmp13 = tmp11 + tmp12;
    uint64_t tmp14 = tmp2;
    uint64_t tmp15 = tmp13;
    uint64_t tmp16 = tmp15 ? tmp14 / tmp15 : 0;
    uint64_t tmp17 = accumulator[metric_set->a_offset + 18];
    uint64_t tmp18 = accumulator[metric_set->a_offset + 1];
    uint64_t tmp19 = tmp17 * tmp18;
    uint64_t tmp20 = accumulator[metric_set->a_offset + 3];
    uint64_t tmp21 = accumulator[metric_set->a_offset + 8];
    uint64_t tmp22 = tmp20 + tmp21;
    uint64_t tmp23 = accumulator[metric_set->a_offset + 13];
    uint64_t tmp24 = tmp22 + tmp23;
    uint64_t tmp25 = accumulator[metric_set->a_offset + 18];
    uint64_t tmp26 = tmp24 + tmp25;
    uint64_t tmp27 = accumulator[metric_set->a_offset + 23];
    uint64_t tmp28 = tmp26 + tmp27;
    uint64_t tmp29 = accumulator[metric_set->a_offset + 28];
    uint64_t tmp30 = tmp28 + tmp29;
    uint64_t tmp31 = tmp19;
    uint64_t tmp32 = tmp30;
    uint64_t tmp33 = tmp32 ? tmp31 / tmp32 : 0;
    uint64_t tmp34 = tmp16 + tmp33;
    uint64_t tmp35 = tmp34 * hsw__sampler_balance__gpu_time__read(perf, metric_set, accumulator);
    uint64_t tmp36 = hsw__sampler_balance__gpu_core_clocks__read(perf, metric_set, accumulator) * perf->devinfo.n_eus;
    uint64_t tmp37 = tmp36 * 1000;
    uint64_t tmp38 = tmp35;
    uint64_t tmp39 = tmp37;
    uint64_t tmp40 = tmp39 ? tmp38 / tmp39 : 0;

    return tmp40;
}

/* Metric set SamplerBalance :: EU Idle */
double
hsw__sampler_balance__eu_idle__read(const struct intel_perf *perf,
                                    const struct intel_perf_metric_set *metric_set,
                                    uint64_t *accumulator)
{
    /* RPN equation: 100 $EuActive $EuStall FADD FSUB */
    double tmp0 = hsw__sampler_balance__eu_active__read(perf, metric_set, accumulator) + hsw__sampler_balance__eu_stall__read(perf, metric_set, accumulator);
    double tmp1 = 100 - tmp0;

    return tmp1;
}

/* Metric set SamplerBalance :: Sampler L2 cache misses */
uint64_t
hsw__sampler_balance__sampler_l2_cache_misses__read(const struct intel_perf *perf,
                                                    const struct intel_perf_metric_set *metric_set,
                                                    uint64_t *accumulator)
{
    /* RPN equation: C 7 READ C 6 READ UADD C 5 READ UADD C 4 READ UADD C 3 READ UADD C 2 READ UADD C 1 READ UADD C 0 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp6 = tmp4 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp8 = tmp6 + tmp7;
    uint64_t tmp9 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp10 = tmp8 + tmp9;
    uint64_t tmp11 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp12 = tmp10 + tmp11;
    uint64_t tmp13 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp14 = tmp12 + tmp13;

    return tmp14;
}

/* Metric set SamplerBalance :: Sampler L2 cache misses (ss0) */
uint64_t
hsw__sampler_balance__sampler0_l2_cache_misses__read(const struct intel_perf *perf,
                                                     const struct intel_perf_metric_set *metric_set,
                                                     uint64_t *accumulator)
{
    /* RPN equation: C 7 READ C 6 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp2 = tmp0 + tmp1;

    return tmp2;
}

/* Metric set SamplerBalance :: Sampler L2 cache misses (ss1) */
uint64_t
hsw__sampler_balance__sampler1_l2_cache_misses__read(const struct intel_perf *perf,
                                                     const struct intel_perf_metric_set *metric_set,
                                                     uint64_t *accumulator)
{
    /* RPN equation: C 5 READ C 4 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp2 = tmp0 + tmp1;

    return tmp2;
}

/* Metric set SamplerBalance :: Sampler L2 cache misses (ss2) */
uint64_t
hsw__sampler_balance__sampler2_l2_cache_misses__read(const struct intel_perf *perf,
                                                     const struct intel_perf_metric_set *metric_set,
                                                     uint64_t *accumulator)
{
    /* RPN equation: C 3 READ C 2 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp2 = tmp0 + tmp1;

    return tmp2;
}

/* Metric set SamplerBalance :: Sampler L2 cache misses (ss3) */
uint64_t
hsw__sampler_balance__sampler3_l2_cache_misses__read(const struct intel_perf *perf,
                                                     const struct intel_perf_metric_set *metric_set,
                                                     uint64_t *accumulator)
{
    /* RPN equation: C 1 READ C 0 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp2 = tmp0 + tmp1;

    return tmp2;
}

/* Render Metrics Basic set :: GPU Core Clocks */
uint64_t
bdw__render_basic__gpu_core_clocks__read(const struct intel_perf *perf,
                                         const struct intel_perf_metric_set *metric_set,
                                         uint64_t *accumulator)
{
    /* RPN equation: GPU_CLOCK 0 READ */
    uint64_t tmp0 = accumulator[metric_set->gpu_clock_offset + 0];

    return tmp0;
}

/* Render Metrics Basic set :: AVG GPU Core Frequency */
uint64_t
bdw__render_basic__avg_gpu_core_frequency__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: $GpuCoreClocks 1000000000 UMUL $GpuTime UDIV */
    uint64_t tmp0 = bdw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator) * 1000000000;
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = bdw__render_basic__gpu_time__read(perf, metric_set, accumulator);
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

    return tmp3;
}

/* Render Metrics Basic set :: VS Threads Dispatched */
uint64_t
bdw__render_basic__vs_threads__read(const struct intel_perf *perf,
                                    const struct intel_perf_metric_set *metric_set,
                                    uint64_t *accumulator)
{
    /* RPN equation: A 1 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 1];

    return tmp0;
}

/* Render Metrics Basic set :: HS Threads Dispatched */
uint64_t
bdw__render_basic__hs_threads__read(const struct intel_perf *perf,
                                    const struct intel_perf_metric_set *metric_set,
                                    uint64_t *accumulator)
{
    /* RPN equation: A 2 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 2];

    return tmp0;
}

/* Render Metrics Basic set :: DS Threads Dispatched */
uint64_t
bdw__render_basic__ds_threads__read(const struct intel_perf *perf,
                                    const struct intel_perf_metric_set *metric_set,
                                    uint64_t *accumulator)
{
    /* RPN equation: A 3 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 3];

    return tmp0;
}

/* Render Metrics Basic set :: FS Threads Dispatched */
uint64_t
bdw__render_basic__ps_threads__read(const struct intel_perf *perf,
                                    const struct intel_perf_metric_set *metric_set,
                                    uint64_t *accumulator)
{
    /* RPN equation: A 6 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 6];

    return tmp0;
}

/* Render Metrics Basic set :: CS Threads Dispatched */
uint64_t
bdw__render_basic__cs_threads__read(const struct intel_perf *perf,
                                    const struct intel_perf_metric_set *metric_set,
                                    uint64_t *accumulator)
{
    /* RPN equation: A 4 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 4];

    return tmp0;
}

/* Render Metrics Basic set :: GPU Busy */
double
bdw__render_basic__gpu_busy__read(const struct intel_perf *perf,
                                  const struct intel_perf_metric_set *metric_set,
                                  uint64_t *accumulator)
{
    /* RPN equation: A 0 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 0];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = bdw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* Render Metrics Basic set :: EU Active */
double
bdw__render_basic__eu_active__read(const struct intel_perf *perf,
                                   const struct intel_perf_metric_set *metric_set,
                                   uint64_t *accumulator)
{
    /* RPN equation: A 7 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 7];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = bdw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Render Metrics Basic set :: EU Stall */
double
bdw__render_basic__eu_stall__read(const struct intel_perf *perf,
                                  const struct intel_perf_metric_set *metric_set,
                                  uint64_t *accumulator)
{
    /* RPN equation: A 8 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 8];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = bdw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Render Metrics Basic set :: EU Both FPU Pipes Active */
double
bdw__render_basic__eu_fpu_both_active__read(const struct intel_perf *perf,
                                            const struct intel_perf_metric_set *metric_set,
                                            uint64_t *accumulator)
{
    /* RPN equation: A 9 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 9];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = bdw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Render Metrics Basic set :: VS FPU0 Pipe Active */
double
bdw__render_basic__vs_fpu0_active__read(const struct intel_perf *perf,
                                        const struct intel_perf_metric_set *metric_set,
                                        uint64_t *accumulator)
{
    /* RPN equation: A 10 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 10];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = bdw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Render Metrics Basic set :: VS FPU1 Pipe Active */
double
bdw__render_basic__vs_fpu1_active__read(const struct intel_perf *perf,
                                        const struct intel_perf_metric_set *metric_set,
                                        uint64_t *accumulator)
{
    /* RPN equation: A 11 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 11];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = bdw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Render Metrics Basic set :: VS Send Pipe Active */
double
bdw__render_basic__vs_send_active__read(const struct intel_perf *perf,
                                        const struct intel_perf_metric_set *metric_set,
                                        uint64_t *accumulator)
{
    /* RPN equation: A 12 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 12];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = bdw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Render Metrics Basic set :: PS FPU0 Pipe Active */
double
bdw__render_basic__ps_fpu0_active__read(const struct intel_perf *perf,
                                        const struct intel_perf_metric_set *metric_set,
                                        uint64_t *accumulator)
{
    /* RPN equation: A 15 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 15];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = bdw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Render Metrics Basic set :: PS FPU1 Pipe Active */
double
bdw__render_basic__ps_fpu1_active__read(const struct intel_perf *perf,
                                        const struct intel_perf_metric_set *metric_set,
                                        uint64_t *accumulator)
{
    /* RPN equation: A 16 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 16];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = bdw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Render Metrics Basic set :: PS Send Pipeline Active */
double
bdw__render_basic__ps_send_active__read(const struct intel_perf *perf,
                                        const struct intel_perf_metric_set *metric_set,
                                        uint64_t *accumulator)
{
    /* RPN equation: A 17 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 17];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = bdw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Render Metrics Basic set :: FS Both FPU Active */
double
bdw__render_basic__ps_eu_both_fpu_active__read(const struct intel_perf *perf,
                                               const struct intel_perf_metric_set *metric_set,
                                               uint64_t *accumulator)
{
    /* RPN equation: A 18 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 18];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = bdw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Render Metrics Basic set :: Sampler 0 Busy */
double
bdw__render_basic__sampler0_busy__read(const struct intel_perf *perf,
                                       const struct intel_perf_metric_set *metric_set,
                                       uint64_t *accumulator)
{
    /* RPN equation: B 0 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = bdw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* Render Metrics Basic set :: Sampler 1 Busy */
double
bdw__render_basic__sampler1_busy__read(const struct intel_perf *perf,
                                       const struct intel_perf_metric_set *metric_set,
                                       uint64_t *accumulator)
{
    /* RPN equation: B 1 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = bdw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* Render Metrics Basic set :: Samplers Busy */
double
bdw__render_basic__samplers_busy__read(const struct intel_perf *perf,
                                       const struct intel_perf_metric_set *metric_set,
                                       uint64_t *accumulator)
{
    /* RPN equation: $Sampler0Busy $Sampler1Busy FMAX */
    double tmp0 = bdw__render_basic__sampler0_busy__read(perf, metric_set, accumulator);
    double tmp1 = bdw__render_basic__sampler1_busy__read(perf, metric_set, accumulator);
    double tmp2 = MAX(tmp0, tmp1);

    return tmp2;
}

/* Render Metrics Basic set :: Sampler 0 Bottleneck */
double
bdw__render_basic__sampler0_bottleneck__read(const struct intel_perf *perf,
                                             const struct intel_perf_metric_set *metric_set,
                                             uint64_t *accumulator)
{
    /* RPN equation: B 2 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = bdw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* Render Metrics Basic set :: Sampler 1 Bottleneck */
double
bdw__render_basic__sampler1_bottleneck__read(const struct intel_perf *perf,
                                             const struct intel_perf_metric_set *metric_set,
                                             uint64_t *accumulator)
{
    /* RPN equation: B 3 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = bdw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* Render Metrics Basic set :: Samples Written */
uint64_t
bdw__render_basic__samples_written__read(const struct intel_perf *perf,
                                         const struct intel_perf_metric_set *metric_set,
                                         uint64_t *accumulator)
{
    /* RPN equation: A 26 READ 4 UMUL */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 26];
    uint64_t tmp1 = tmp0 * 4;

    return tmp1;
}

/* Render Metrics Basic set :: Samples Blended */
uint64_t
bdw__render_basic__samples_blended__read(const struct intel_perf *perf,
                                         const struct intel_perf_metric_set *metric_set,
                                         uint64_t *accumulator)
{
    /* RPN equation: A 27 READ 4 UMUL */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 27];
    uint64_t tmp1 = tmp0 * 4;

    return tmp1;
}

/* Render Metrics Basic set :: Sampler Texels */
uint64_t
bdw__render_basic__sampler_texels__read(const struct intel_perf *perf,
                                        const struct intel_perf_metric_set *metric_set,
                                        uint64_t *accumulator)
{
    /* RPN equation: A 28 READ 4 UMUL */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 28];
    uint64_t tmp1 = tmp0 * 4;

    return tmp1;
}

/* Render Metrics Basic set :: Sampler Texels Misses */
uint64_t
bdw__render_basic__sampler_texel_misses__read(const struct intel_perf *perf,
                                              const struct intel_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: A 29 READ 4 UMUL */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 29];
    uint64_t tmp1 = tmp0 * 4;

    return tmp1;
}

/* Render Metrics Basic set :: Sampler Cache Misses */
uint64_t
bdw__render_basic__sampler_l1_misses__read(const struct intel_perf *perf,
                                           const struct intel_perf_metric_set *metric_set,
                                           uint64_t *accumulator)
{
    /* RPN equation: B 4 READ B 5 READ UADD 8 UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = tmp2 * 8;

    return tmp3;
}

/* Render Metrics Basic set :: Rasterized Pixels */
uint64_t
bdw__render_basic__rasterized_pixels__read(const struct intel_perf *perf,
                                           const struct intel_perf_metric_set *metric_set,
                                           uint64_t *accumulator)
{
    /* RPN equation: A 21 READ 4 UMUL */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 21];
    uint64_t tmp1 = tmp0 * 4;

    return tmp1;
}

/* Render Metrics Basic set :: Early Hi-Depth Test Fails */
uint64_t
bdw__render_basic__hi_depth_test_fails__read(const struct intel_perf *perf,
                                             const struct intel_perf_metric_set *metric_set,
                                             uint64_t *accumulator)
{
    /* RPN equation: A 22 READ 4 UMUL */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 22];
    uint64_t tmp1 = tmp0 * 4;

    return tmp1;
}

/* Render Metrics Basic set :: Early Depth Test Fails */
uint64_t
bdw__render_basic__early_depth_test_fails__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: A 23 READ 4 UMUL */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 23];
    uint64_t tmp1 = tmp0 * 4;

    return tmp1;
}

/* Render Metrics Basic set :: Samples Killed in FS */
uint64_t
bdw__render_basic__samples_killed_in_ps__read(const struct intel_perf *perf,
                                              const struct intel_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: A 24 READ 4 UMUL */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 24];
    uint64_t tmp1 = tmp0 * 4;

    return tmp1;
}

/* Render Metrics Basic set :: Pixels Failing Tests */
uint64_t
bdw__render_basic__pixels_failing_post_ps_tests__read(const struct intel_perf *perf,
                                                      const struct intel_perf_metric_set *metric_set,
                                                      uint64_t *accumulator)
{
    /* RPN equation: A 25 READ 4 UMUL */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 25];
    uint64_t tmp1 = tmp0 * 4;

    return tmp1;
}

/* Render Metrics Basic set :: SLM Bytes Read */
uint64_t
bdw__render_basic__slm_bytes_read__read(const struct intel_perf *perf,
                                        const struct intel_perf_metric_set *metric_set,
                                        uint64_t *accumulator)
{
    /* RPN equation: A 30 READ 64 UMUL */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 30];
    uint64_t tmp1 = tmp0 * 64;

    return tmp1;
}

/* Render Metrics Basic set :: SLM Bytes Read */
uint64_t
bdw__render_basic__slm_bytes_read__max(const struct intel_perf *perf,
                                       const struct intel_perf_metric_set *metric_set,
                                       uint64_t *accumulator)
{
    /* RPN equation: $GpuCoreClocks 64 UMUL $EuSubslicesTotalCount UMUL */
    uint64_t tmp0 = bdw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator) * 64;
    uint64_t tmp1 = tmp0 * perf->devinfo.n_eu_sub_slices;

    return tmp1;
}

/* Render Metrics Basic set :: SLM Bytes Written */
uint64_t
bdw__render_basic__slm_bytes_written__read(const struct intel_perf *perf,
                                           const struct intel_perf_metric_set *metric_set,
                                           uint64_t *accumulator)
{
    /* RPN equation: A 31 READ 64 UMUL */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 31];
    uint64_t tmp1 = tmp0 * 64;

    return tmp1;
}

/* Render Metrics Basic set :: Shader Memory Accesses */
uint64_t
bdw__render_basic__shader_memory_accesses__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: A 32 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 32];

    return tmp0;
}

/* Render Metrics Basic set :: Shader Atomic Memory Accesses */
uint64_t
bdw__render_basic__shader_atomics__read(const struct intel_perf *perf,
                                        const struct intel_perf_metric_set *metric_set,
                                        uint64_t *accumulator)
{
    /* RPN equation: A 34 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 34];

    return tmp0;
}

/* Render Metrics Basic set :: L3 Lookup Accesses w/o IC */
uint64_t
bdw__render_basic__l3_lookups__read(const struct intel_perf *perf,
                                    const struct intel_perf_metric_set *metric_set,
                                    uint64_t *accumulator)
{
    /* RPN equation: $SamplerL1Misses $ShaderMemoryAccesses UADD */
    uint64_t tmp0 = bdw__render_basic__sampler_l1_misses__read(perf, metric_set, accumulator) + bdw__render_basic__shader_memory_accesses__read(perf, metric_set, accumulator);

    return tmp0;
}

/* Render Metrics Basic set :: L3 Sampler Throughput */
uint64_t
bdw__render_basic__l3_sampler_throughput__read(const struct intel_perf *perf,
                                               const struct intel_perf_metric_set *metric_set,
                                               uint64_t *accumulator)
{
    /* RPN equation: $SamplerL1Misses 64 UMUL */
    uint64_t tmp0 = bdw__render_basic__sampler_l1_misses__read(perf, metric_set, accumulator) * 64;

    return tmp0;
}

/* Render Metrics Basic set :: L3 Shader Throughput */
uint64_t
bdw__render_basic__l3_shader_throughput__read(const struct intel_perf *perf,
                                              const struct intel_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: A 30 READ  A 31 READ $ShaderMemoryAccesses UADD UADD 64 UMUL */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 30];
    uint64_t tmp1 = accumulator[metric_set->a_offset + 31];
    uint64_t tmp2 = tmp1 + bdw__render_basic__shader_memory_accesses__read(perf, metric_set, accumulator);
    uint64_t tmp3 = tmp0 + tmp2;
    uint64_t tmp4 = tmp3 * 64;

    return tmp4;
}

/* Render Metrics Basic set :: L3 Shader Throughput */
uint64_t
bdw__render_basic__l3_shader_throughput__max(const struct intel_perf *perf,
                                             const struct intel_perf_metric_set *metric_set,
                                             uint64_t *accumulator)
{
    /* RPN equation: $GpuCoreClocks 64 UMUL 2 UMUL $EuSubslicesTotalCount UMUL */
    uint64_t tmp0 = bdw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator) * 64;
    uint64_t tmp1 = tmp0 * 2;
    uint64_t tmp2 = tmp1 * perf->devinfo.n_eu_sub_slices;

    return tmp2;
}

/* Render Metrics Basic set :: GTI Fixed Pipe Throughput */
uint64_t
bdw__render_basic__gti_vf_throughput__read(const struct intel_perf *perf,
                                           const struct intel_perf_metric_set *metric_set,
                                           uint64_t *accumulator)
{
    /* RPN equation: B 6 READ B 7 READ UADD 64 UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = tmp2 * 64;

    return tmp3;
}

/* Render Metrics Basic set :: GTI Fixed Pipe Throughput */
uint64_t
bdw__render_basic__gti_vf_throughput__max(const struct intel_perf *perf,
                                          const struct intel_perf_metric_set *metric_set,
                                          uint64_t *accumulator)
{
    /* RPN equation: $GpuCoreClocks 64 UMUL */
    uint64_t tmp0 = bdw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator) * 64;

    return tmp0;
}

/* Render Metrics Basic set :: GTI Depth Throughput */
uint64_t
bdw__render_basic__gti_depth_throughput__read(const struct intel_perf *perf,
                                              const struct intel_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: C 0 READ C 1 READ UADD 64 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = tmp2 * 64;

    return tmp3;
}

/* Render Metrics Basic set :: GTI Depth Throughput */
uint64_t
bdw__render_basic__gti_depth_throughput__max(const struct intel_perf *perf,
                                             const struct intel_perf_metric_set *metric_set,
                                             uint64_t *accumulator)
{
    /* RPN equation: $GpuCoreClocks 64 UMUL $EuSlicesTotalCount UMUL */
    uint64_t tmp0 = bdw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator) * 64;
    uint64_t tmp1 = tmp0 * perf->devinfo.n_eu_slices;

    return tmp1;
}

/* Render Metrics Basic set :: GTI RCC Throughput */
uint64_t
bdw__render_basic__gti_rcc_throughput__read(const struct intel_perf *perf,
                                            const struct intel_perf_metric_set *metric_set,
                                            uint64_t *accumulator)
{
    /* RPN equation: C 2 READ C 3 READ UADD 64 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = tmp2 * 64;

    return tmp3;
}

/* Render Metrics Basic set :: GTI HDC TLB Lookup Throughput */
uint64_t
bdw__render_basic__gti_hdc_lookups_throughput__read(const struct intel_perf *perf,
                                                    const struct intel_perf_metric_set *metric_set,
                                                    uint64_t *accumulator)
{
    /* RPN equation: C 5 READ 64 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp1 = tmp0 * 64;

    return tmp1;
}

/* Render Metrics Basic set :: GTI Read Throughput */
uint64_t
bdw__render_basic__gti_read_throughput__read(const struct intel_perf *perf,
                                             const struct intel_perf_metric_set *metric_set,
                                             uint64_t *accumulator)
{
    /* RPN equation: C 6 READ 64 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp1 = tmp0 * 64;

    return tmp1;
}

/* Render Metrics Basic set :: GTI Write Throughput */
uint64_t
bdw__render_basic__gti_write_throughput__max(const struct intel_perf *perf,
                                             const struct intel_perf_metric_set *metric_set,
                                             uint64_t *accumulator)
{
    /* RPN equation: $GpuCoreClocks 32 UMUL */
    uint64_t tmp0 = bdw__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator) * 32;

    return tmp0;
}

/* Render Metrics Basic set :: Samplers Bottleneck */
double
bdw__render_basic__sampler_bottleneck__read(const struct intel_perf *perf,
                                            const struct intel_perf_metric_set *metric_set,
                                            uint64_t *accumulator)
{
    /* RPN equation: $Sampler0Bottleneck $Sampler1Bottleneck FMAX */
    double tmp0 = bdw__render_basic__sampler0_bottleneck__read(perf, metric_set, accumulator);
    double tmp1 = bdw__render_basic__sampler1_bottleneck__read(perf, metric_set, accumulator);
    double tmp2 = MAX(tmp0, tmp1);

    return tmp2;
}

/* Compute Metrics Basic set :: EU AVG IPC Rate */
double
bdw__compute_basic__eu_avg_ipc_rate__read(const struct intel_perf *perf,
                                          const struct intel_perf_metric_set *metric_set,
                                          uint64_t *accumulator)
{
    /* RPN equation: A 9 READ  A 10 READ  A 11 READ UADD  A 9 READ USUB FDIV 1 FADD */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 9];
    uint64_t tmp1 = accumulator[metric_set->a_offset + 10];
    uint64_t tmp2 = accumulator[metric_set->a_offset + 11];
    uint64_t tmp3 = tmp1 + tmp2;
    uint64_t tmp4 = accumulator[metric_set->a_offset + 9];
    uint64_t tmp5 = tmp3 - tmp4;
    double tmp6 = tmp0;
    double tmp7 = tmp5;
    double tmp8 = tmp7 ? tmp6 / tmp7 : 0;
    double tmp9 = tmp8 + 1;

    return tmp9;
}

/* Compute Metrics Basic set :: EU AVG IPC Rate */
double
bdw__compute_basic__eu_avg_ipc_rate__max(const struct intel_perf *perf,
                                         const struct intel_perf_metric_set *metric_set,
                                         uint64_t *accumulator)
{
    /* RPN equation: 2 */

    return 2;
}

/* Compute Metrics Basic set :: EU Thread Occupancy */
double
bdw__compute_basic__eu_thread_occupancy__read(const struct intel_perf *perf,
                                              const struct intel_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: A 13 READ 8 UMUL $EuCoresTotalCount UDIV $EuThreadsCount UDIV 100 UMUL  $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 13];
    uint64_t tmp1 = tmp0 * 8;
    uint64_t tmp2 = tmp1;
    uint64_t tmp3 = perf->devinfo.n_eus;
    uint64_t tmp4 = tmp3 ? tmp2 / tmp3 : 0;
    uint64_t tmp5 = tmp4;
    uint64_t tmp6 = perf->devinfo.eu_threads_count;
    uint64_t tmp7 = tmp6 ? tmp5 / tmp6 : 0;
    uint64_t tmp8 = tmp7 * 100;
    double tmp9 = tmp8;
    double tmp10 = bdw__compute_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp11 = tmp10 ? tmp9 / tmp10 : 0;

    return tmp11;
}

/* Compute Metrics Basic set :: Typed Bytes Read */
uint64_t
bdw__compute_basic__typed_bytes_read__read(const struct intel_perf *perf,
                                           const struct intel_perf_metric_set *metric_set,
                                           uint64_t *accumulator)
{
    /* RPN equation: B 0 READ B 1 READ B 2 READ UADD UADD $EuSlicesTotalCount 64 UMUL UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp2 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp3 = tmp1 + tmp2;
    uint64_t tmp4 = tmp0 + tmp3;
    uint64_t tmp5 = perf->devinfo.n_eu_slices * 64;
    uint64_t tmp6 = tmp4 * tmp5;

    return tmp6;
}

/* Compute Metrics Basic set :: Typed Bytes Written */
uint64_t
bdw__compute_basic__typed_bytes_written__read(const struct intel_perf *perf,
                                              const struct intel_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: B 3 READ B 4 READ B 5 READ UADD UADD $EuSlicesTotalCount 64 UMUL UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp2 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp3 = tmp1 + tmp2;
    uint64_t tmp4 = tmp0 + tmp3;
    uint64_t tmp5 = perf->devinfo.n_eu_slices * 64;
    uint64_t tmp6 = tmp4 * tmp5;

    return tmp6;
}

/* Compute Metrics Basic set :: Untyped Bytes Read */
uint64_t
bdw__compute_basic__untyped_bytes_read__read(const struct intel_perf *perf,
                                             const struct intel_perf_metric_set *metric_set,
                                             uint64_t *accumulator)
{
    /* RPN equation: B 6 READ B 7 READ C 0 READ UADD UADD $EuSlicesTotalCount 64 UMUL UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp2 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp3 = tmp1 + tmp2;
    uint64_t tmp4 = tmp0 + tmp3;
    uint64_t tmp5 = perf->devinfo.n_eu_slices * 64;
    uint64_t tmp6 = tmp4 * tmp5;

    return tmp6;
}

/* Compute Metrics Basic set :: Untyped Writes */
uint64_t
bdw__compute_basic__untyped_bytes_written__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: C 1 READ C 2 READ C 3 READ UADD UADD $EuSlicesTotalCount 64 UMUL UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp2 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp3 = tmp1 + tmp2;
    uint64_t tmp4 = tmp0 + tmp3;
    uint64_t tmp5 = perf->devinfo.n_eu_slices * 64;
    uint64_t tmp6 = tmp4 * tmp5;

    return tmp6;
}

/* Render Metrics for 3D Pipeline Profile :: Sampler Accesses */
uint64_t
bdw__render_pipe_profile__sampler_accesses__read(const struct intel_perf *perf,
                                                 const struct intel_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: A 28 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 28];

    return tmp0;
}

/* Render Metrics for 3D Pipeline Profile :: VF Bottleneck */
double
bdw__render_pipe_profile__vf_bottleneck__read(const struct intel_perf *perf,
                                              const struct intel_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: C 0 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = bdw__render_pipe_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* Render Metrics for 3D Pipeline Profile :: SO Bottleneck */
double
bdw__render_pipe_profile__so_bottleneck__read(const struct intel_perf *perf,
                                              const struct intel_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: B 4 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = bdw__render_pipe_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* Render Metrics for 3D Pipeline Profile :: Clipper Bottleneck */
double
bdw__render_pipe_profile__cl_bottleneck__read(const struct intel_perf *perf,
                                              const struct intel_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: B 5 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = bdw__render_pipe_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* Render Metrics for 3D Pipeline Profile :: Strip-Fans Bottleneck */
double
bdw__render_pipe_profile__sf_bottleneck__read(const struct intel_perf *perf,
                                              const struct intel_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: B 6 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = bdw__render_pipe_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* Render Metrics for 3D Pipeline Profile :: Hi-Depth Bottleneck */
double
bdw__render_pipe_profile__hi_depth_bottleneck__read(const struct intel_perf *perf,
                                                    const struct intel_perf_metric_set *metric_set,
                                                    uint64_t *accumulator)
{
    /* RPN equation: C 6 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = bdw__render_pipe_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* Render Metrics for 3D Pipeline Profile :: Early Depth Bottleneck */
double
bdw__render_pipe_profile__early_depth_bottleneck__read(const struct intel_perf *perf,
                                                       const struct intel_perf_metric_set *metric_set,
                                                       uint64_t *accumulator)
{
    /* RPN equation: B 7 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = bdw__render_pipe_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* Render Metrics for 3D Pipeline Profile :: BC Bottleneck */
double
bdw__render_pipe_profile__bc_bottleneck__read(const struct intel_perf *perf,
                                              const struct intel_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: C 7 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = bdw__render_pipe_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* Render Metrics for 3D Pipeline Profile :: HS Stall */
double
bdw__render_pipe_profile__hs_stall__read(const struct intel_perf *perf,
                                         const struct intel_perf_metric_set *metric_set,
                                         uint64_t *accumulator)
{
    /* RPN equation: C 1 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = bdw__render_pipe_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* Render Metrics for 3D Pipeline Profile :: DS Stall */
double
bdw__render_pipe_profile__ds_stall__read(const struct intel_perf *perf,
                                         const struct intel_perf_metric_set *metric_set,
                                         uint64_t *accumulator)
{
    /* RPN equation: C 2 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = bdw__render_pipe_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* Render Metrics for 3D Pipeline Profile :: SO Stall */
double
bdw__render_pipe_profile__so_stall__read(const struct intel_perf *perf,
                                         const struct intel_perf_metric_set *metric_set,
                                         uint64_t *accumulator)
{
    /* RPN equation: C 3 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = bdw__render_pipe_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* Render Metrics for 3D Pipeline Profile :: CL Stall */
double
bdw__render_pipe_profile__cl_stall__read(const struct intel_perf *perf,
                                         const struct intel_perf_metric_set *metric_set,
                                         uint64_t *accumulator)
{
    /* RPN equation: C 4 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = bdw__render_pipe_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* Render Metrics for 3D Pipeline Profile :: SF Stall */
double
bdw__render_pipe_profile__sf_stall__read(const struct intel_perf *perf,
                                         const struct intel_perf_metric_set *metric_set,
                                         uint64_t *accumulator)
{
    /* RPN equation: C 5 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = bdw__render_pipe_profile__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* Memory Reads Distribution metric set :: GtiL3Reads */
uint64_t
bdw__memory_reads__gti_l3_reads__read(const struct intel_perf *perf,
                                      const struct intel_perf_metric_set *metric_set,
                                      uint64_t *accumulator)
{
    /* RPN equation: $GtiL3Bank0Reads $GtiL3Bank1Reads $GtiL3Bank2Reads $GtiL3Bank3Reads UADD UADD UADD */
    uint64_t tmp0 = bdw__memory_reads__gti_l3_bank2_reads__read(perf, metric_set, accumulator) + bdw__memory_reads__gti_l3_bank3_reads__read(perf, metric_set, accumulator);
    uint64_t tmp1 = bdw__memory_reads__gti_l3_bank1_reads__read(perf, metric_set, accumulator) + tmp0;
    uint64_t tmp2 = bdw__memory_reads__gti_l3_bank0_reads__read(perf, metric_set, accumulator) + tmp1;

    return tmp2;
}

/* Memory Reads Distribution metric set :: GtiRingAccesses */
uint64_t
bdw__memory_reads__gti_ring_accesses__read(const struct intel_perf *perf,
                                           const struct intel_perf_metric_set *metric_set,
                                           uint64_t *accumulator)
{
    /* RPN equation: C 3 READ 2 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp1 = tmp0 * 2;

    return tmp1;
}

/* Compute Metrics Extended metric set :: UntypedReadsPerCacheLine */
double
bdw__compute_extended__untyped_reads_per_cache_line__read(const struct intel_perf *perf,
                                                          const struct intel_perf_metric_set *metric_set,
                                                          uint64_t *accumulator)
{
    /* RPN equation: $EuUntypedReads0 $EuA64UntypedReads0 UADD $UntypedReads0 FDIV */
    uint64_t tmp0 = bdw__compute_extended__eu_untyped_reads0__read(perf, metric_set, accumulator) + bdw__compute_extended__eu_a64_untyped_reads0__read(perf, metric_set, accumulator);
    double tmp1 = tmp0;
    double tmp2 = bdw__compute_extended__untyped_reads0__read(perf, metric_set, accumulator);
    double tmp3 = tmp2 ? tmp1 / tmp2 : 0;

    return tmp3;
}

/* Compute Metrics Extended metric set :: UntypedWritesPerCacheLine */
double
bdw__compute_extended__untyped_writes_per_cache_line__read(const struct intel_perf *perf,
                                                           const struct intel_perf_metric_set *metric_set,
                                                           uint64_t *accumulator)
{
    /* RPN equation: $EuUntypedWrites0 $EuA64UntypedWrites0 UADD $UntypedWrites0 FDIV */
    uint64_t tmp0 = bdw__compute_extended__eu_untyped_writes0__read(perf, metric_set, accumulator) + bdw__compute_extended__eu_a64_untyped_writes0__read(perf, metric_set, accumulator);
    double tmp1 = tmp0;
    double tmp2 = bdw__compute_extended__untyped_writes0__read(perf, metric_set, accumulator);
    double tmp3 = tmp2 ? tmp1 / tmp2 : 0;

    return tmp3;
}

/* Compute Metrics L3 Cache metric set :: EU FPU0 Hybrid Instruction */
double
bdw__compute_l3_cache__eu_hybrid_fpu0_instruction__read(const struct intel_perf *perf,
                                                        const struct intel_perf_metric_set *metric_set,
                                                        uint64_t *accumulator)
{
    /* RPN equation: A 13 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 13];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = bdw__compute_l3_cache__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Compute Metrics L3 Cache metric set :: EU FPU1 Hybrid Instruction */
double
bdw__compute_l3_cache__eu_hybrid_fpu1_instruction__read(const struct intel_perf *perf,
                                                        const struct intel_perf_metric_set *metric_set,
                                                        uint64_t *accumulator)
{
    /* RPN equation: A 14 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 14];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = bdw__compute_l3_cache__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Compute Metrics L3 Cache metric set :: EU FPU0 Move Instruction */
double
bdw__compute_l3_cache__eu_move_fpu0_instruction__read(const struct intel_perf *perf,
                                                      const struct intel_perf_metric_set *metric_set,
                                                      uint64_t *accumulator)
{
    /* RPN equation: A 19 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 19];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = bdw__compute_l3_cache__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Compute Metrics L3 Cache metric set :: EU FPU1 Move Instruction */
double
bdw__compute_l3_cache__eu_move_fpu1_instruction__read(const struct intel_perf *perf,
                                                      const struct intel_perf_metric_set *metric_set,
                                                      uint64_t *accumulator)
{
    /* RPN equation: A 20 READ $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 20];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = perf->devinfo.n_eus;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    uint64_t tmp4 = tmp3 * 100;
    double tmp5 = tmp4;
    double tmp6 = bdw__compute_l3_cache__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp7 = tmp6 ? tmp5 / tmp6 : 0;

    return tmp7;
}

/* Compute Metrics L3 Cache metric set :: L3 Accesses */
uint64_t
bdw__compute_l3_cache__l3_accesses__read(const struct intel_perf *perf,
                                         const struct intel_perf_metric_set *metric_set,
                                         uint64_t *accumulator)
{
    /* RPN equation: C 0 READ C 1 READ B 2 READ B 3 READ C 2 READ C 3 READ B 6 READ B 7 READ UADD UADD UADD UADD UADD UADD UADD 2 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp2 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp3 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp4 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp5 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp6 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp7 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp8 = tmp6 + tmp7;
    uint64_t tmp9 = tmp5 + tmp8;
    uint64_t tmp10 = tmp4 + tmp9;
    uint64_t tmp11 = tmp3 + tmp10;
    uint64_t tmp12 = tmp2 + tmp11;
    uint64_t tmp13 = tmp1 + tmp12;
    uint64_t tmp14 = tmp0 + tmp13;
    uint64_t tmp15 = tmp14 * 2;

    return tmp15;
}

/* Compute Metrics L3 Cache metric set :: L3 Misses */
uint64_t
bdw__compute_l3_cache__l3_misses__read(const struct intel_perf *perf,
                                       const struct intel_perf_metric_set *metric_set,
                                       uint64_t *accumulator)
{
    /* RPN equation: C 4 READ C 5 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp2 = tmp0 + tmp1;

    return tmp2;
}

/* Compute Metrics L3 Cache metric set :: L3 Total Throughput */
uint64_t
bdw__compute_l3_cache__l3_total_throughput__read(const struct intel_perf *perf,
                                                 const struct intel_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: $L3Accesses 64 UMUL */
    uint64_t tmp0 = bdw__compute_l3_cache__l3_accesses__read(perf, metric_set, accumulator) * 64;

    return tmp0;
}

/* Compute Metrics L3 Cache metric set :: L3 Bank 00 Accesses */
uint64_t
bdw__compute_l3_cache__l3_bank00_accesses__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: C 0 READ 2 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp1 = tmp0 * 2;

    return tmp1;
}

/* Compute Metrics L3 Cache metric set :: L3 Bank 01 Accesses */
uint64_t
bdw__compute_l3_cache__l3_bank01_accesses__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: C 1 READ 2 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp1 = tmp0 * 2;

    return tmp1;
}

/* Compute Metrics L3 Cache metric set :: L3 Bank 02 Accesses */
uint64_t
bdw__compute_l3_cache__l3_bank02_accesses__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: B 2 READ 2 UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp1 = tmp0 * 2;

    return tmp1;
}

/* Compute Metrics L3 Cache metric set :: L3 Bank 03 Accesses */
uint64_t
bdw__compute_l3_cache__l3_bank03_accesses__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: B 3 READ 2 UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp1 = tmp0 * 2;

    return tmp1;
}

/* Compute Metrics L3 Cache metric set :: L3 Bank 10 Accesses */
uint64_t
bdw__compute_l3_cache__l3_bank10_accesses__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: C 2 READ 2 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp1 = tmp0 * 2;

    return tmp1;
}

/* Compute Metrics L3 Cache metric set :: L3 Bank 12 Accesses */
uint64_t
bdw__compute_l3_cache__l3_bank12_accesses__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: B 6 READ 2 UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp1 = tmp0 * 2;

    return tmp1;
}

/* Compute Metrics L3 Cache metric set :: L3 Bank 13 Accesses */
uint64_t
bdw__compute_l3_cache__l3_bank13_accesses__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: B 7 READ 2 UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp1 = tmp0 * 2;

    return tmp1;
}

/* Compute Metrics L3 Cache metric set :: L3 Bank 00 IC Accesses */
uint64_t
bdw__compute_l3_cache__l3_bank00_ic_accesses__read(const struct intel_perf *perf,
                                                   const struct intel_perf_metric_set *metric_set,
                                                   uint64_t *accumulator)
{
    /* RPN equation: B 0 READ B 1 READ UADD 2 UMUL $L3Bank00Accesses UMIN */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = tmp2 * 2;
    uint64_t tmp4 = MIN(tmp3, bdw__compute_l3_cache__l3_bank00_accesses__read(perf, metric_set, accumulator));

    return tmp4;
}

/* Compute Metrics L3 Cache metric set :: L3 Bank 00 IC Hits */
uint64_t
bdw__compute_l3_cache__l3_bank00_ic_hits__read(const struct intel_perf *perf,
                                               const struct intel_perf_metric_set *metric_set,
                                               uint64_t *accumulator)
{
    /* RPN equation: B 1 READ 2 UMUL $L3Bank00IcAccesses UMIN */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp1 = tmp0 * 2;
    uint64_t tmp2 = MIN(tmp1, bdw__compute_l3_cache__l3_bank00_ic_accesses__read(perf, metric_set, accumulator));

    return tmp2;
}

/* Compute Metrics L3 Cache metric set :: L3 Bank 10 IC Accesses */
uint64_t
bdw__compute_l3_cache__l3_bank10_ic_accesses__read(const struct intel_perf *perf,
                                                   const struct intel_perf_metric_set *metric_set,
                                                   uint64_t *accumulator)
{
    /* RPN equation: B 4 READ B 5 READ UADD 2 UMUL $L3Bank10Accesses UMIN */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = tmp2 * 2;
    uint64_t tmp4 = MIN(tmp3, bdw__compute_l3_cache__l3_bank10_accesses__read(perf, metric_set, accumulator));

    return tmp4;
}

/* Compute Metrics L3 Cache metric set :: L3 Bank 10 IC Hits */
uint64_t
bdw__compute_l3_cache__l3_bank10_ic_hits__read(const struct intel_perf *perf,
                                               const struct intel_perf_metric_set *metric_set,
                                               uint64_t *accumulator)
{
    /* RPN equation: B 5 READ 2 UMUL $L3Bank10IcAccesses UMIN */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp1 = tmp0 * 2;
    uint64_t tmp2 = MIN(tmp1, bdw__compute_l3_cache__l3_bank10_ic_accesses__read(perf, metric_set, accumulator));

    return tmp2;
}

/* Compute Metrics L3 Cache metric set :: GTI L3 Throughput */
uint64_t
bdw__compute_l3_cache__gti_l3_throughput__read(const struct intel_perf *perf,
                                               const struct intel_perf_metric_set *metric_set,
                                               uint64_t *accumulator)
{
    /* RPN equation: C 4 READ C 5 READ UADD 64 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = tmp2 * 64;

    return tmp3;
}

/* Data Port Reads Coalescing metric set :: All Data Port 0 Reads from L3 */
uint64_t
bdw__data_port_reads_coalescing__hdc0_l3_reads__read(const struct intel_perf *perf,
                                                     const struct intel_perf_metric_set *metric_set,
                                                     uint64_t *accumulator)
{
    /* RPN equation: C 3 READ C 2 READ USUB */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp2 = tmp0 - tmp1;

    return tmp2;
}

/* Data Port Reads Coalescing metric set :: EuBytesReadPerCacheLine */
double
bdw__data_port_reads_coalescing__eu_bytes_read_per_cache_line__read(const struct intel_perf *perf,
                                                                    const struct intel_perf_metric_set *metric_set,
                                                                    uint64_t *accumulator)
{
    /* RPN equation: $EuHdc0Reads32B 32 UMUL $EuHdc0Reads64B 64 UMUL $EuHdc0Reads128B 128 UMUL $EuHdc0Reads256B 256 UMUL UADD UADD UADD $Hdc0L3DataReads FDIV */
    uint64_t tmp0 = bdw__data_port_reads_coalescing__eu_hdc0_reads32_b__read(perf, metric_set, accumulator) * 32;
    uint64_t tmp1 = bdw__data_port_reads_coalescing__eu_hdc0_reads64_b__read(perf, metric_set, accumulator) * 64;
    uint64_t tmp2 = bdw__data_port_reads_coalescing__eu_hdc0_reads128_b__read(perf, metric_set, accumulator) * 128;
    uint64_t tmp3 = bdw__data_port_reads_coalescing__eu_hdc0_reads256_b__read(perf, metric_set, accumulator) * 256;
    uint64_t tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = tmp1 + tmp4;
    uint64_t tmp6 = tmp0 + tmp5;
    double tmp7 = tmp6;
    double tmp8 = bdw__data_port_reads_coalescing__hdc0_l3_data_reads__read(perf, metric_set, accumulator);
    double tmp9 = tmp8 ? tmp7 / tmp8 : 0;

    return tmp9;
}

/* Data Port Reads Coalescing metric set :: EuDataReadsPerCacheLine */
double
bdw__data_port_reads_coalescing__eu_data_reads_per_cache_line__read(const struct intel_perf *perf,
                                                                    const struct intel_perf_metric_set *metric_set,
                                                                    uint64_t *accumulator)
{
    /* RPN equation: $EuBytesReadPerCacheLine 64 FDIV */
    double tmp0 = bdw__data_port_reads_coalescing__eu_bytes_read_per_cache_line__read(perf, metric_set, accumulator);
    double tmp1 = 64;
    double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

    return tmp2;
}

/* Data Port Writes Coalescing metric set :: EU to Data Port 0 Writes 64B */
uint64_t
bdw__data_port_writes_coalescing__eu_hdc0_writes64_b__read(const struct intel_perf *perf,
                                                           const struct intel_perf_metric_set *metric_set,
                                                           uint64_t *accumulator)
{
    /* RPN equation: B 1 READ B 4 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp2 = tmp0 + tmp1;

    return tmp2;
}

/* Data Port Writes Coalescing metric set :: EU to Data Port 0 Writes 64B */
uint64_t
bdw__data_port_writes_coalescing__eu_hdc0_writes96_b__read(const struct intel_perf *perf,
                                                           const struct intel_perf_metric_set *metric_set,
                                                           uint64_t *accumulator)
{
    /* RPN equation: B 2 READ 2 UDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = 2;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

    return tmp3;
}

/* Data Port Writes Coalescing metric set :: EU to Data Port 0 Writes 128 */
uint64_t
bdw__data_port_writes_coalescing__eu_hdc0_writes128_b__read(const struct intel_perf *perf,
                                                            const struct intel_perf_metric_set *metric_set,
                                                            uint64_t *accumulator)
{
    /* RPN equation: B 3 READ 2 UDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = 2;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

    return tmp3;
}

/* Data Port Writes Coalescing metric set :: EU to Data Port 0 Writes 128 */
uint64_t
bdw__data_port_writes_coalescing__eu_hdc0_writes192_b__read(const struct intel_perf *perf,
                                                            const struct intel_perf_metric_set *metric_set,
                                                            uint64_t *accumulator)
{
    /* RPN equation: B 6 READ 2 UDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = 2;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

    return tmp3;
}

/* Data Port Writes Coalescing metric set :: EU to Data Port 0 Writes 256B */
uint64_t
bdw__data_port_writes_coalescing__eu_hdc0_writes256_b_simd16__read(const struct intel_perf *perf,
                                                                   const struct intel_perf_metric_set *metric_set,
                                                                   uint64_t *accumulator)
{
    /* RPN equation: B 7 READ 2 UDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = 2;
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

    return tmp3;
}

/* Data Port Writes Coalescing metric set :: EuBytesWrittenPerCacheLine */
double
bdw__data_port_writes_coalescing__eu_bytes_written_per_cache_line__read(const struct intel_perf *perf,
                                                                        const struct intel_perf_metric_set *metric_set,
                                                                        uint64_t *accumulator)
{
    /* RPN equation: $EuHdc0Writes32B 32 UMUL $EuHdc0Writes64B 64 UMUL $EuHdc0Writes96B 96 UMUL $EuHdc0Writes128B 128 UMUL $EuHdc0Writes128BSimd16 128 UMUL $EuHdc0Writes256BSimd16 256 UMUL $EuHdc0Writes192B 192 UMUL UADD UADD UADD UADD UADD UADD $Hdc0L3DataWrites FDIV */
    uint64_t tmp0 = bdw__data_port_writes_coalescing__eu_hdc0_writes32_b__read(perf, metric_set, accumulator) * 32;
    uint64_t tmp1 = bdw__data_port_writes_coalescing__eu_hdc0_writes64_b__read(perf, metric_set, accumulator) * 64;
    uint64_t tmp2 = bdw__data_port_writes_coalescing__eu_hdc0_writes96_b__read(perf, metric_set, accumulator) * 96;
    uint64_t tmp3 = bdw__data_port_writes_coalescing__eu_hdc0_writes128_b__read(perf, metric_set, accumulator) * 128;
    uint64_t tmp4 = bdw__data_port_writes_coalescing__eu_hdc0_writes128_b_simd16__read(perf, metric_set, accumulator) * 128;
    uint64_t tmp5 = bdw__data_port_writes_coalescing__eu_hdc0_writes256_b_simd16__read(perf, metric_set, accumulator) * 256;
    uint64_t tmp6 = bdw__data_port_writes_coalescing__eu_hdc0_writes192_b__read(perf, metric_set, accumulator) * 192;
    uint64_t tmp7 = tmp5 + tmp6;
    uint64_t tmp8 = tmp4 + tmp7;
    uint64_t tmp9 = tmp3 + tmp8;
    uint64_t tmp10 = tmp2 + tmp9;
    uint64_t tmp11 = tmp1 + tmp10;
    uint64_t tmp12 = tmp0 + tmp11;
    double tmp13 = tmp12;
    double tmp14 = bdw__data_port_writes_coalescing__hdc0_l3_data_writes__read(perf, metric_set, accumulator);
    double tmp15 = tmp14 ? tmp13 / tmp14 : 0;

    return tmp15;
}

/* Data Port Writes Coalescing metric set :: EuDataWritesPerCacheLine */
double
bdw__data_port_writes_coalescing__eu_data_writes_per_cache_line__read(const struct intel_perf *perf,
                                                                      const struct intel_perf_metric_set *metric_set,
                                                                      uint64_t *accumulator)
{
    /* RPN equation: $EuBytesWrittenPerCacheLine 64 FDIV */
    double tmp0 = bdw__data_port_writes_coalescing__eu_bytes_written_per_cache_line__read(perf, metric_set, accumulator);
    double tmp1 = 64;
    double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

    return tmp2;
}

/* Metric set HDCAndSF :: L3 Shader Throughput */
uint64_t
bdw__hdc_and_sf__l3_shader_throughput__max(const struct intel_perf *perf,
                                           const struct intel_perf_metric_set *metric_set,
                                           uint64_t *accumulator)
{
    /* RPN equation: $GpuCoreClocks 64 UMUL $EuSubslicesTotalCount UMUL 2 UMUL */
    uint64_t tmp0 = bdw__hdc_and_sf__gpu_core_clocks__read(perf, metric_set, accumulator) * 64;
    uint64_t tmp1 = tmp0 * perf->devinfo.n_eu_sub_slices;
    uint64_t tmp2 = tmp1 * 2;

    return tmp2;
}

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss2) */
double
bdw__hdc_and_sf__non_sampler_shader02_access_stalled_on_l3__read(const struct intel_perf *perf,
                                                                 const struct intel_perf_metric_set *metric_set,
                                                                 uint64_t *accumulator)
{
    /* RPN equation: C 7 READ C 6 READ USUB 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp2 = tmp0 - tmp1;
    uint64_t tmp3 = tmp2 * 100;
    double tmp4 = tmp3;
    double tmp5 = bdw__hdc_and_sf__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

    return tmp6;
}

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss1) */
double
bdw__hdc_and_sf__non_sampler_shader01_access_stalled_on_l3__read(const struct intel_perf *perf,
                                                                 const struct intel_perf_metric_set *metric_set,
                                                                 uint64_t *accumulator)
{
    /* RPN equation: C 5 READ C 4 READ USUB 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp2 = tmp0 - tmp1;
    uint64_t tmp3 = tmp2 * 100;
    double tmp4 = tmp3;
    double tmp5 = bdw__hdc_and_sf__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

    return tmp6;
}

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss0) */
double
bdw__hdc_and_sf__non_sampler_shader00_access_stalled_on_l3__read(const struct intel_perf *perf,
                                                                 const struct intel_perf_metric_set *metric_set,
                                                                 uint64_t *accumulator)
{
    /* RPN equation: C 3 READ C 2 READ USUB 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp2 = tmp0 - tmp1;
    uint64_t tmp3 = tmp2 * 100;
    double tmp4 = tmp3;
    double tmp5 = bdw__hdc_and_sf__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

    return tmp6;
}

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss2) */
double
bdw__hdc_and_sf__non_sampler_shader12_access_stalled_on_l3__read(const struct intel_perf *perf,
                                                                 const struct intel_perf_metric_set *metric_set,
                                                                 uint64_t *accumulator)
{
    /* RPN equation: C 1 READ C 0 READ USUB 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp2 = tmp0 - tmp1;
    uint64_t tmp3 = tmp2 * 100;
    double tmp4 = tmp3;
    double tmp5 = bdw__hdc_and_sf__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

    return tmp6;
}

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss1) */
double
bdw__hdc_and_sf__non_sampler_shader11_access_stalled_on_l3__read(const struct intel_perf *perf,
                                                                 const struct intel_perf_metric_set *metric_set,
                                                                 uint64_t *accumulator)
{
    /* RPN equation: B 7 READ B 6 READ USUB 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp2 = tmp0 - tmp1;
    uint64_t tmp3 = tmp2 * 100;
    double tmp4 = tmp3;
    double tmp5 = bdw__hdc_and_sf__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

    return tmp6;
}

/* Metric set HDCAndSF :: HDC stalled by L3 (s0.ss0) */
double
bdw__hdc_and_sf__non_sampler_shader10_access_stalled_on_l3__read(const struct intel_perf *perf,
                                                                 const struct intel_perf_metric_set *metric_set,
                                                                 uint64_t *accumulator)
{
    /* RPN equation: B 5 READ B 4 READ USUB 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp2 = tmp0 - tmp1;
    uint64_t tmp3 = tmp2 * 100;
    double tmp4 = tmp3;
    double tmp5 = bdw__hdc_and_sf__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

    return tmp6;
}

/* Metric set HDCAndSF :: SQ is full */
double
bdw__hdc_and_sf__gt_request_queue_full__read(const struct intel_perf *perf,
                                             const struct intel_perf_metric_set *metric_set,
                                             uint64_t *accumulator)
{
    /* RPN equation: PERFCNT 0 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->perfcnt_offset + 0];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = bdw__hdc_and_sf__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* Compute Metrics Extra set :: EU FPU1 Pipe Active including Ext Math */
double
bdw__compute_extra__fpu1_active_adjusted__read(const struct intel_perf *perf,
                                               const struct intel_perf_metric_set *metric_set,
                                               uint64_t *accumulator)
{
    /* RPN equation: A 8 READ  C 5 READ C 6 READ FADD C 7 READ FADD C 2 READ FADD C 3 READ FADD C 4 READ FADD 8 FMUL FADD 100 FMUL $EuCoresTotalCount FDIV $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 8];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp2 = accumulator[metric_set->c_offset + 6];
    double tmp3 = tmp1 + tmp2;
    uint64_t tmp4 = accumulator[metric_set->c_offset + 7];
    double tmp5 = tmp3 + tmp4;
    uint64_t tmp6 = accumulator[metric_set->c_offset + 2];
    double tmp7 = tmp5 + tmp6;
    uint64_t tmp8 = accumulator[metric_set->c_offset + 3];
    double tmp9 = tmp7 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->c_offset + 4];
    double tmp11 = tmp9 + tmp10;
    double tmp12 = tmp11 * 8;
    double tmp13 = tmp0 + tmp12;
    double tmp14 = tmp13 * 100;
    double tmp15 = tmp14;
    double tmp16 = perf->devinfo.n_eus;
    double tmp17 = tmp16 ? tmp15 / tmp16 : 0;
    double tmp18 = tmp17;
    double tmp19 = bdw__compute_extra__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp20 = tmp19 ? tmp18 / tmp19 : 0;

    return tmp20;
}

/* Media Vme Pipe metric set :: EU Thread Occupancy */
double
bdw__vme_pipe__eu_thread_occupancy__read(const struct intel_perf *perf,
                                         const struct intel_perf_metric_set *metric_set,
                                         uint64_t *accumulator)
{
    /* RPN equation: 8 A 10 READ FMUL $EuThreadsCount FDIV $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 10];
    double tmp1 = 8 * tmp0;
    double tmp2 = tmp1;
    double tmp3 = perf->devinfo.eu_threads_count;
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;
    uint64_t tmp5 = tmp4;
    uint64_t tmp6 = perf->devinfo.n_eus;
    uint64_t tmp7 = tmp6 ? tmp5 / tmp6 : 0;
    uint64_t tmp8 = tmp7 * 100;
    double tmp9 = tmp8;
    double tmp10 = bdw__vme_pipe__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp11 = tmp10 ? tmp9 / tmp10 : 0;

    return tmp11;
}

/* Media Vme Pipe metric set :: VME Busy */
double
bdw__vme_pipe__vme_busy__read(const struct intel_perf *perf,
                              const struct intel_perf_metric_set *metric_set,
                              uint64_t *accumulator)
{
    /* RPN equation: B 0 READ B 3 READ FADD 2 FDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 3];
    double tmp2 = tmp0 + tmp1;
    double tmp3 = tmp2;
    double tmp4 = 2;
    double tmp5 = tmp4 ? tmp3 / tmp4 : 0;
    uint64_t tmp6 = tmp5 * 100;
    double tmp7 = tmp6;
    double tmp8 = bdw__vme_pipe__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp9 = tmp8 ? tmp7 / tmp8 : 0;

    return tmp9;
}

/* Render Metrics Basic set :: Samplers Busy */
double
chv__render_basic__samplers_busy__read(const struct intel_perf *perf,
                                       const struct intel_perf_metric_set *metric_set,
                                       uint64_t *accumulator)
{
    /* RPN equation: B 0 READ  B 1 READ UADD $GpuCoreClocks FDIV 2 FDIV 100 FMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp2 = tmp0 + tmp1;
    double tmp3 = tmp2;
    double tmp4 = chv__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp5 = tmp4 ? tmp3 / tmp4 : 0;
    double tmp6 = tmp5;
    double tmp7 = 2;
    double tmp8 = tmp7 ? tmp6 / tmp7 : 0;
    double tmp9 = tmp8 * 100;

    return tmp9;
}

/* Render Metrics Basic set :: L3 Sampler Throughput */
uint64_t
chv__render_basic__l3_sampler_throughput__read(const struct intel_perf *perf,
                                               const struct intel_perf_metric_set *metric_set,
                                               uint64_t *accumulator)
{
    /* RPN equation: A 29 READ 64 UMUL */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 29];
    uint64_t tmp1 = tmp0 * 64;

    return tmp1;
}

/* Render Metrics Basic set :: L3 Shader Throughput */
uint64_t
chv__render_basic__l3_shader_throughput__max(const struct intel_perf *perf,
                                             const struct intel_perf_metric_set *metric_set,
                                             uint64_t *accumulator)
{
    /* RPN equation: $GpuCoreClocks 64 UMUL $EuSlicesTotalCount UMUL 2 UMUL */
    uint64_t tmp0 = chv__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator) * 64;
    uint64_t tmp1 = tmp0 * perf->devinfo.n_eu_slices;
    uint64_t tmp2 = tmp1 * 2;

    return tmp2;
}

/* Compute Metrics Basic set :: Typed Bytes Read */
uint64_t
chv__compute_basic__typed_bytes_read__read(const struct intel_perf *perf,
                                           const struct intel_perf_metric_set *metric_set,
                                           uint64_t *accumulator)
{
    /* RPN equation: B 0 READ B 1 READ UADD 64 UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = tmp2 * 64;

    return tmp3;
}

/* Compute Metrics Basic set :: Typed Bytes Written */
uint64_t
chv__compute_basic__typed_bytes_written__read(const struct intel_perf *perf,
                                              const struct intel_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: B 2 READ B 3 READ UADD 64 UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = tmp2 * 64;

    return tmp3;
}

/* Compute Metrics Basic set :: Untyped Bytes Read */
uint64_t
chv__compute_basic__untyped_bytes_read__read(const struct intel_perf *perf,
                                             const struct intel_perf_metric_set *metric_set,
                                             uint64_t *accumulator)
{
    /* RPN equation: B 4 READ B 5 READ UADD 64 UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = tmp2 * 64;

    return tmp3;
}

/* Compute Metrics Basic set :: GTI Ring Throughput */
uint64_t
chv__compute_basic__gti_ring_throughput__read(const struct intel_perf *perf,
                                              const struct intel_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: C 2 READ 128 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp1 = tmp0 * 128;

    return tmp1;
}

/* Compute Metrics Basic set :: GTI Ring Throughput */
uint64_t
chv__compute_basic__gti_ring_throughput__max(const struct intel_perf *perf,
                                             const struct intel_perf_metric_set *metric_set,
                                             uint64_t *accumulator)
{
    /* RPN equation: $GpuCoreClocks 128 UMUL */
    uint64_t tmp0 = chv__compute_basic__gpu_core_clocks__read(perf, metric_set, accumulator) * 128;

    return tmp0;
}

/* Render Metrics Basic set :: Sampler Cache Misses */
uint64_t
sklgt2__render_basic__sampler_l1_misses__read(const struct intel_perf *perf,
                                              const struct intel_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: B 4 READ 8 UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp1 = tmp0 * 8;

    return tmp1;
}

/* Render Metrics Basic set :: L3 Lookup Accesses w/o IC */
uint64_t
sklgt2__render_basic__l3_lookups__read(const struct intel_perf *perf,
                                       const struct intel_perf_metric_set *metric_set,
                                       uint64_t *accumulator)
{
    /* RPN equation: $SamplerL1Misses $ShaderMemoryAccesses UADD */
    uint64_t tmp0 = sklgt2__render_basic__sampler_l1_misses__read(perf, metric_set, accumulator) + sklgt2__render_basic__shader_memory_accesses__read(perf, metric_set, accumulator);

    return tmp0;
}

/* Render Metrics Basic set :: L3 Sampler Throughput */
uint64_t
sklgt2__render_basic__l3_sampler_throughput__read(const struct intel_perf *perf,
                                                  const struct intel_perf_metric_set *metric_set,
                                                  uint64_t *accumulator)
{
    /* RPN equation: $SamplerL1Misses 64 UMUL */
    uint64_t tmp0 = sklgt2__render_basic__sampler_l1_misses__read(perf, metric_set, accumulator) * 64;

    return tmp0;
}

/* Compute Metrics L3 Cache metrics set :: L3 Accesses */
uint64_t
sklgt2__compute_l3_cache__l3_accesses__read(const struct intel_perf *perf,
                                            const struct intel_perf_metric_set *metric_set,
                                            uint64_t *accumulator)
{
    /* RPN equation: C 0 READ C 1 READ B 2 READ B 3 READ UADD UADD UADD 2 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp2 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp3 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = tmp1 + tmp4;
    uint64_t tmp6 = tmp0 + tmp5;
    uint64_t tmp7 = tmp6 * 2;

    return tmp7;
}

/* Compute Metrics L3 Cache metrics set :: L3 Total Throughput */
uint64_t
sklgt2__compute_l3_cache__l3_total_throughput__read(const struct intel_perf *perf,
                                                    const struct intel_perf_metric_set *metric_set,
                                                    uint64_t *accumulator)
{
    /* RPN equation: $L3Accesses 64 UMUL */
    uint64_t tmp0 = sklgt2__compute_l3_cache__l3_accesses__read(perf, metric_set, accumulator) * 64;

    return tmp0;
}

/* Compute Metrics Extra set :: EU FPU1 Pipe Active including Ext Math */
double
sklgt2__compute_extra__fpu1_active_adjusted__read(const struct intel_perf *perf,
                                                  const struct intel_perf_metric_set *metric_set,
                                                  uint64_t *accumulator)
{
    /* RPN equation: A 8 READ  C 7 READ C 6 READ FADD C 5 READ FADD 8 FMUL FADD 100 FMUL $EuCoresTotalCount FDIV $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 8];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp2 = accumulator[metric_set->c_offset + 6];
    double tmp3 = tmp1 + tmp2;
    uint64_t tmp4 = accumulator[metric_set->c_offset + 5];
    double tmp5 = tmp3 + tmp4;
    double tmp6 = tmp5 * 8;
    double tmp7 = tmp0 + tmp6;
    double tmp8 = tmp7 * 100;
    double tmp9 = tmp8;
    double tmp10 = perf->devinfo.n_eus;
    double tmp11 = tmp10 ? tmp9 / tmp10 : 0;
    double tmp12 = tmp11;
    double tmp13 = sklgt2__compute_extra__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp14 = tmp13 ? tmp12 / tmp13 : 0;

    return tmp14;
}

/* FF Bottlenecks :: EU Thread Occupancy */
double
sklgt2__ff_bottlenecks__eu_thread_occupancy__read(const struct intel_perf *perf,
                                                  const struct intel_perf_metric_set *metric_set,
                                                  uint64_t *accumulator)
{
    /* RPN equation: 8 A 17 READ FMUL $EuThreadsCount FDIV $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 17];
    double tmp1 = 8 * tmp0;
    double tmp2 = tmp1;
    double tmp3 = perf->devinfo.eu_threads_count;
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;
    uint64_t tmp5 = tmp4;
    uint64_t tmp6 = perf->devinfo.n_eus;
    uint64_t tmp7 = tmp6 ? tmp5 / tmp6 : 0;
    uint64_t tmp8 = tmp7 * 100;
    double tmp9 = tmp8;
    double tmp10 = sklgt2__ff_bottlenecks__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp11 = tmp10 ? tmp9 / tmp10 : 0;

    return tmp11;
}

/* FF Bottlenecks :: VS is sending vertices to CL */
double
sklgt2__ff_bottlenecks__vs_cl_bypass__read(const struct intel_perf *perf,
                                           const struct intel_perf_metric_set *metric_set,
                                           uint64_t *accumulator)
{
    /* RPN equation: B 0 READ B 4 READ FADD 2 FDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 4];
    double tmp2 = tmp0 + tmp1;
    double tmp3 = tmp2;
    double tmp4 = 2;
    double tmp5 = tmp4 ? tmp3 / tmp4 : 0;
    uint64_t tmp6 = tmp5 * 100;
    double tmp7 = tmp6;
    double tmp8 = sklgt2__ff_bottlenecks__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp9 = tmp8 ? tmp7 / tmp8 : 0;

    return tmp9;
}

/* FF Bottlenecks :: DS Bottleneck */
double
sklgt2__ff_bottlenecks__ds_bottleneck__read(const struct intel_perf *perf,
                                            const struct intel_perf_metric_set *metric_set,
                                            uint64_t *accumulator)
{
    /* RPN equation: B 1 READ B 5 READ FADD 2 FDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 5];
    double tmp2 = tmp0 + tmp1;
    double tmp3 = tmp2;
    double tmp4 = 2;
    double tmp5 = tmp4 ? tmp3 / tmp4 : 0;
    uint64_t tmp6 = tmp5 * 100;
    double tmp7 = tmp6;
    double tmp8 = sklgt2__ff_bottlenecks__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp9 = tmp8 ? tmp7 / tmp8 : 0;

    return tmp9;
}

/* FF Bottlenecks :: TE Bottleneck */
double
sklgt2__ff_bottlenecks__te_bottleneck__read(const struct intel_perf *perf,
                                            const struct intel_perf_metric_set *metric_set,
                                            uint64_t *accumulator)
{
    /* RPN equation: B 2 READ B 6 READ FADD 2 FDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 6];
    double tmp2 = tmp0 + tmp1;
    double tmp3 = tmp2;
    double tmp4 = 2;
    double tmp5 = tmp4 ? tmp3 / tmp4 : 0;
    uint64_t tmp6 = tmp5 * 100;
    double tmp7 = tmp6;
    double tmp8 = sklgt2__ff_bottlenecks__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp9 = tmp8 ? tmp7 / tmp8 : 0;

    return tmp9;
}

/* Metric set PMA Stall :: STC PMA stall */
double
sklgt2__pma__stall__stc_pma_stall__read(const struct intel_perf *perf,
                                        const struct intel_perf_metric_set *metric_set,
                                        uint64_t *accumulator)
{
    /* RPN equation: B 0 READ B 1 READ FADD 2 FDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 1];
    double tmp2 = tmp0 + tmp1;
    double tmp3 = tmp2;
    double tmp4 = 2;
    double tmp5 = tmp4 ? tmp3 / tmp4 : 0;
    uint64_t tmp6 = tmp5 * 100;
    double tmp7 = tmp6;
    double tmp8 = sklgt2__pma__stall__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp9 = tmp8 ? tmp7 / tmp8 : 0;

    return tmp9;
}

/* Render Metrics Basic set :: Sampler Cache Misses */
uint64_t
sklgt4__render_basic__sampler_l1_misses__read(const struct intel_perf *perf,
                                              const struct intel_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: B 4 READ B 5 READ UADD B 3 READ UADD 8 UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = tmp4 * 8;

    return tmp5;
}

/* Render Metrics Basic set :: L3 Lookup Accesses w/o IC */
uint64_t
sklgt4__render_basic__l3_lookups__read(const struct intel_perf *perf,
                                       const struct intel_perf_metric_set *metric_set,
                                       uint64_t *accumulator)
{
    /* RPN equation: $SamplerL1Misses $ShaderMemoryAccesses UADD */
    uint64_t tmp0 = sklgt4__render_basic__sampler_l1_misses__read(perf, metric_set, accumulator) + sklgt4__render_basic__shader_memory_accesses__read(perf, metric_set, accumulator);

    return tmp0;
}

/* Render Metrics Basic set :: L3 Sampler Throughput */
uint64_t
sklgt4__render_basic__l3_sampler_throughput__read(const struct intel_perf *perf,
                                                  const struct intel_perf_metric_set *metric_set,
                                                  uint64_t *accumulator)
{
    /* RPN equation: $SamplerL1Misses 64 UMUL */
    uint64_t tmp0 = sklgt4__render_basic__sampler_l1_misses__read(perf, metric_set, accumulator) * 64;

    return tmp0;
}

/* Compute Metrics Basic set :: Typed Bytes Written */
uint64_t
bxt__compute_basic__typed_bytes_written__read(const struct intel_perf *perf,
                                              const struct intel_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: B 3 READ B 4 READ UADD $EuSlicesTotalCount 64 UMUL UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = perf->devinfo.n_eu_slices * 64;
    uint64_t tmp4 = tmp2 * tmp3;

    return tmp4;
}

/* Compute Metrics Basic set :: Untyped Writes */
uint64_t
bxt__compute_basic__untyped_bytes_written__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: C 1 READ C 2 READ UADD $EuSlicesTotalCount 64 UMUL UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = perf->devinfo.n_eu_slices * 64;
    uint64_t tmp4 = tmp2 * tmp3;

    return tmp4;
}

/* Render Metrics Basic set :: Samplers Busy */
double
cnl__render_basic__samplers_busy__read(const struct intel_perf *perf,
                                       const struct intel_perf_metric_set *metric_set,
                                       uint64_t *accumulator)
{
    /* RPN equation: $SubsliceMask 1 AND $Sampler00Busy FMUL $SubsliceMask 3 >> 1 AND $Sampler10Busy FMUL FADD $SubsliceMask 1 AND $SubsliceMask 3 >> 1 AND FADD FDIV */
    uint64_t tmp0 = perf->devinfo.subslice_mask & 1;
    double tmp1 = tmp0 * cnl__render_basic__sampler00_busy__read(perf, metric_set, accumulator);
    uint64_t tmp2 = perf->devinfo.subslice_mask >> 3;
    uint64_t tmp3 = tmp2 & 1;
    double tmp4 = tmp3 * cnl__render_basic__sampler10_busy__read(perf, metric_set, accumulator);
    double tmp5 = tmp1 + tmp4;
    uint64_t tmp6 = perf->devinfo.subslice_mask & 1;
    uint64_t tmp7 = perf->devinfo.subslice_mask >> 3;
    uint64_t tmp8 = tmp7 & 1;
    double tmp9 = tmp6 + tmp8;
    double tmp10 = tmp5;
    double tmp11 = tmp9;
    double tmp12 = tmp11 ? tmp10 / tmp11 : 0;

    return tmp12;
}

/* Render Metrics Basic set :: Sampler Cache Misses */
uint64_t
cnl__render_basic__sampler_l1_misses__read(const struct intel_perf *perf,
                                           const struct intel_perf_metric_set *metric_set,
                                           uint64_t *accumulator)
{
    /* RPN equation: $SliceMask 1 AND B 4 READ UMUL $SliceMask 1 >> 1 AND B 5 READ UMUL UADD 8 UMUL */
    uint64_t tmp0 = perf->devinfo.slice_mask & 1;
    uint64_t tmp1 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp2 = tmp0 * tmp1;
    uint64_t tmp3 = perf->devinfo.slice_mask >> 1;
    uint64_t tmp4 = tmp3 & 1;
    uint64_t tmp5 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp6 = tmp4 * tmp5;
    uint64_t tmp7 = tmp2 + tmp6;
    uint64_t tmp8 = tmp7 * 8;

    return tmp8;
}

/* Render Metrics Basic set :: L3 Lookup Accesses w/o IC */
uint64_t
cnl__render_basic__l3_lookups__read(const struct intel_perf *perf,
                                    const struct intel_perf_metric_set *metric_set,
                                    uint64_t *accumulator)
{
    /* RPN equation: $SamplerL1Misses $ShaderMemoryAccesses UADD */
    uint64_t tmp0 = cnl__render_basic__sampler_l1_misses__read(perf, metric_set, accumulator) + cnl__render_basic__shader_memory_accesses__read(perf, metric_set, accumulator);

    return tmp0;
}

/* Render Metrics Basic set :: L3 Misses */
uint64_t
cnl__render_basic__l3_misses__read(const struct intel_perf *perf,
                                   const struct intel_perf_metric_set *metric_set,
                                   uint64_t *accumulator)
{
    /* RPN equation: C 2 READ C 3 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp2 = tmp0 + tmp1;

    return tmp2;
}

/* Render Metrics Basic set :: L3 Sampler Throughput */
uint64_t
cnl__render_basic__l3_sampler_throughput__read(const struct intel_perf *perf,
                                               const struct intel_perf_metric_set *metric_set,
                                               uint64_t *accumulator)
{
    /* RPN equation: 64 $SamplerL1Misses UMUL */
    uint64_t tmp0 = 64 * cnl__render_basic__sampler_l1_misses__read(perf, metric_set, accumulator);

    return tmp0;
}

/* Render Metrics Basic set :: L3 Shader Throughput */
uint64_t
cnl__render_basic__l3_shader_throughput__read(const struct intel_perf *perf,
                                              const struct intel_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: A 30 READ A 31 READ UADD A 32 READ UADD 64 UMUL */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 30];
    uint64_t tmp1 = accumulator[metric_set->a_offset + 31];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->a_offset + 32];
    uint64_t tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = tmp4 * 64;

    return tmp5;
}

/* Render Metrics Basic set :: GTI Depth Throughput */
uint64_t
cnl__render_basic__gti_depth_throughput__read(const struct intel_perf *perf,
                                              const struct intel_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: 128  B 6 READ UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp1 = 128 * tmp0;

    return tmp1;
}

/* Render Metrics Basic set :: GTI RCC Throughput */
uint64_t
cnl__render_basic__gti_rcc_throughput__read(const struct intel_perf *perf,
                                            const struct intel_perf_metric_set *metric_set,
                                            uint64_t *accumulator)
{
    /* RPN equation: C 0 READ C 1 READ UADD 128 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = tmp2 * 128;

    return tmp3;
}

/* Render Metrics Basic set :: GTI Read Throughput */
uint64_t
cnl__render_basic__gti_read_throughput__read(const struct intel_perf *perf,
                                             const struct intel_perf_metric_set *metric_set,
                                             uint64_t *accumulator)
{
    /* RPN equation: 64  C 6 READ UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp1 = 64 * tmp0;

    return tmp1;
}

/* Render Metrics Basic set :: GTI Write Throughput */
uint64_t
cnl__render_basic__gti_write_throughput__read(const struct intel_perf *perf,
                                              const struct intel_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: 64  C 7 READ UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp1 = 64 * tmp0;

    return tmp1;
}

/* Render Metrics Basic set :: Samplers Bottleneck */
double
cnl__render_basic__sampler_bottleneck__read(const struct intel_perf *perf,
                                            const struct intel_perf_metric_set *metric_set,
                                            uint64_t *accumulator)
{
    /* RPN equation: $SubsliceMask 1 AND $Sampler00Bottleneck FMUL $SubsliceMask 3 >> 1 AND $Sampler10Bottleneck FMUL FADD $SubsliceMask 1 AND $SubsliceMask 3 >> 1 AND FADD FDIV */
    uint64_t tmp0 = perf->devinfo.subslice_mask & 1;
    double tmp1 = tmp0 * cnl__render_basic__sampler00_bottleneck__read(perf, metric_set, accumulator);
    uint64_t tmp2 = perf->devinfo.subslice_mask >> 3;
    uint64_t tmp3 = tmp2 & 1;
    double tmp4 = tmp3 * cnl__render_basic__sampler10_bottleneck__read(perf, metric_set, accumulator);
    double tmp5 = tmp1 + tmp4;
    uint64_t tmp6 = perf->devinfo.subslice_mask & 1;
    uint64_t tmp7 = perf->devinfo.subslice_mask >> 3;
    uint64_t tmp8 = tmp7 & 1;
    double tmp9 = tmp6 + tmp8;
    double tmp10 = tmp5;
    double tmp11 = tmp9;
    double tmp12 = tmp11 ? tmp10 / tmp11 : 0;

    return tmp12;
}

/* Compute Metrics Basic set :: EU AVG IPC Rate */
double
cnl__compute_basic__eu_avg_ipc_rate__read(const struct intel_perf *perf,
                                          const struct intel_perf_metric_set *metric_set,
                                          uint64_t *accumulator)
{
    /* RPN equation: A 9 READ A 10 READ A 11 READ FADD A 9 READ FSUB FDIV 1 FADD */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 9];
    uint64_t tmp1 = accumulator[metric_set->a_offset + 10];
    uint64_t tmp2 = accumulator[metric_set->a_offset + 11];
    double tmp3 = tmp1 + tmp2;
    uint64_t tmp4 = accumulator[metric_set->a_offset + 9];
    double tmp5 = tmp3 - tmp4;
    double tmp6 = tmp0;
    double tmp7 = tmp5;
    double tmp8 = tmp7 ? tmp6 / tmp7 : 0;
    double tmp9 = tmp8 + 1;

    return tmp9;
}

/* Compute Metrics Basic set :: EU Thread Occupancy */
double
cnl__compute_basic__eu_thread_occupancy__read(const struct intel_perf *perf,
                                              const struct intel_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: 8 A 13 READ FMUL $EuThreadsCount FDIV $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 13];
    double tmp1 = 8 * tmp0;
    double tmp2 = tmp1;
    double tmp3 = perf->devinfo.eu_threads_count;
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;
    uint64_t tmp5 = tmp4;
    uint64_t tmp6 = perf->devinfo.n_eus;
    uint64_t tmp7 = tmp6 ? tmp5 / tmp6 : 0;
    uint64_t tmp8 = tmp7 * 100;
    double tmp9 = tmp8;
    double tmp10 = cnl__compute_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp11 = tmp10 ? tmp9 / tmp10 : 0;

    return tmp11;
}

/* Compute Metrics Basic set :: Typed Bytes Read */
uint64_t
cnl__compute_basic__typed_bytes_read__read(const struct intel_perf *perf,
                                           const struct intel_perf_metric_set *metric_set,
                                           uint64_t *accumulator)
{
    /* RPN equation: $SubsliceMask 1 AND B 0 READ UMUL $SubsliceMask 1 >> 1 AND B 1 READ UMUL UADD $SubsliceMask 2 >> 1 AND B 2 READ UMUL UADD $SubsliceMask 3 >> 1 AND B 3 READ UMUL UADD $SubsliceMask 4 >> 1 AND B 4 READ UMUL UADD 64 UMUL */
    uint64_t tmp0 = perf->devinfo.subslice_mask & 1;
    uint64_t tmp1 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp2 = tmp0 * tmp1;
    uint64_t tmp3 = perf->devinfo.subslice_mask >> 1;
    uint64_t tmp4 = tmp3 & 1;
    uint64_t tmp5 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp6 = tmp4 * tmp5;
    uint64_t tmp7 = tmp2 + tmp6;
    uint64_t tmp8 = perf->devinfo.subslice_mask >> 2;
    uint64_t tmp9 = tmp8 & 1;
    uint64_t tmp10 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp11 = tmp9 * tmp10;
    uint64_t tmp12 = tmp7 + tmp11;
    uint64_t tmp13 = perf->devinfo.subslice_mask >> 3;
    uint64_t tmp14 = tmp13 & 1;
    uint64_t tmp15 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp16 = tmp14 * tmp15;
    uint64_t tmp17 = tmp12 + tmp16;
    uint64_t tmp18 = perf->devinfo.subslice_mask >> 4;
    uint64_t tmp19 = tmp18 & 1;
    uint64_t tmp20 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp21 = tmp19 * tmp20;
    uint64_t tmp22 = tmp17 + tmp21;
    uint64_t tmp23 = tmp22 * 64;

    return tmp23;
}

/* Compute Metrics Basic set :: Typed Bytes Written */
uint64_t
cnl__compute_basic__typed_bytes_written__read(const struct intel_perf *perf,
                                              const struct intel_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: $SubsliceMask 1 AND B 5 READ UMUL $SubsliceMask 1 >> 1 AND B 6 READ UMUL UADD $SubsliceMask 2 >> 1 AND B 7 READ UMUL UADD $SubsliceMask 3 >> 1 AND C 0 READ UMUL UADD $SubsliceMask 4 >> 1 AND C 1 READ UMUL UADD 64 UMUL */
    uint64_t tmp0 = perf->devinfo.subslice_mask & 1;
    uint64_t tmp1 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp2 = tmp0 * tmp1;
    uint64_t tmp3 = perf->devinfo.subslice_mask >> 1;
    uint64_t tmp4 = tmp3 & 1;
    uint64_t tmp5 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp6 = tmp4 * tmp5;
    uint64_t tmp7 = tmp2 + tmp6;
    uint64_t tmp8 = perf->devinfo.subslice_mask >> 2;
    uint64_t tmp9 = tmp8 & 1;
    uint64_t tmp10 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp11 = tmp9 * tmp10;
    uint64_t tmp12 = tmp7 + tmp11;
    uint64_t tmp13 = perf->devinfo.subslice_mask >> 3;
    uint64_t tmp14 = tmp13 & 1;
    uint64_t tmp15 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp16 = tmp14 * tmp15;
    uint64_t tmp17 = tmp12 + tmp16;
    uint64_t tmp18 = perf->devinfo.subslice_mask >> 4;
    uint64_t tmp19 = tmp18 & 1;
    uint64_t tmp20 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp21 = tmp19 * tmp20;
    uint64_t tmp22 = tmp17 + tmp21;
    uint64_t tmp23 = tmp22 * 64;

    return tmp23;
}

/* Compute Metrics Basic set :: Untyped Bytes Read */
uint64_t
cnl__compute_basic__untyped_bytes_read__read(const struct intel_perf *perf,
                                             const struct intel_perf_metric_set *metric_set,
                                             uint64_t *accumulator)
{
    /* RPN equation: $EuSubslicesTotalCount $SubsliceMask 1 AND C 2 READ FMUL $SubsliceMask 3 >> 1 AND C 3 READ FMUL FADD FMUL $SubsliceMask 1 AND $SubsliceMask 3 >> 1 AND FADD FDIV 64 UMUL */
    uint64_t tmp0 = perf->devinfo.subslice_mask & 1;
    uint64_t tmp1 = accumulator[metric_set->c_offset + 2];
    double tmp2 = tmp0 * tmp1;
    uint64_t tmp3 = perf->devinfo.subslice_mask >> 3;
    uint64_t tmp4 = tmp3 & 1;
    uint64_t tmp5 = accumulator[metric_set->c_offset + 3];
    double tmp6 = tmp4 * tmp5;
    double tmp7 = tmp2 + tmp6;
    double tmp8 = perf->devinfo.n_eu_sub_slices * tmp7;
    uint64_t tmp9 = perf->devinfo.subslice_mask & 1;
    uint64_t tmp10 = perf->devinfo.subslice_mask >> 3;
    uint64_t tmp11 = tmp10 & 1;
    double tmp12 = tmp9 + tmp11;
    double tmp13 = tmp8;
    double tmp14 = tmp12;
    double tmp15 = tmp14 ? tmp13 / tmp14 : 0;
    uint64_t tmp16 = tmp15 * 64;

    return tmp16;
}

/* Compute Metrics Basic set :: Untyped Writes */
uint64_t
cnl__compute_basic__untyped_bytes_written__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: $EuSubslicesTotalCount $SubsliceMask 1 AND C 4 READ FMUL $SubsliceMask 3 >> 1 AND C 5 READ FMUL FADD FMUL $SubsliceMask 1 AND $SubsliceMask 3 >> 1 AND FADD FDIV 64 UMUL */
    uint64_t tmp0 = perf->devinfo.subslice_mask & 1;
    uint64_t tmp1 = accumulator[metric_set->c_offset + 4];
    double tmp2 = tmp0 * tmp1;
    uint64_t tmp3 = perf->devinfo.subslice_mask >> 3;
    uint64_t tmp4 = tmp3 & 1;
    uint64_t tmp5 = accumulator[metric_set->c_offset + 5];
    double tmp6 = tmp4 * tmp5;
    double tmp7 = tmp2 + tmp6;
    double tmp8 = perf->devinfo.n_eu_sub_slices * tmp7;
    uint64_t tmp9 = perf->devinfo.subslice_mask & 1;
    uint64_t tmp10 = perf->devinfo.subslice_mask >> 3;
    uint64_t tmp11 = tmp10 & 1;
    double tmp12 = tmp9 + tmp11;
    double tmp13 = tmp8;
    double tmp14 = tmp12;
    double tmp15 = tmp14 ? tmp13 / tmp14 : 0;
    uint64_t tmp16 = tmp15 * 64;

    return tmp16;
}

/* Memory Reads Distribution metrics set :: GtiL3Reads */
uint64_t
cnl__memory_reads__gti_l3_reads__read(const struct intel_perf *perf,
                                      const struct intel_perf_metric_set *metric_set,
                                      uint64_t *accumulator)
{
    /* RPN equation: $GtiL3Bank0Reads $GtiL3Bank1Reads UADD $GtiL3Bank2Reads UADD */
    uint64_t tmp0 = cnl__memory_reads__gti_l3_bank0_reads__read(perf, metric_set, accumulator) + cnl__memory_reads__gti_l3_bank1_reads__read(perf, metric_set, accumulator);
    uint64_t tmp1 = tmp0 + cnl__memory_reads__gti_l3_bank2_reads__read(perf, metric_set, accumulator);

    return tmp1;
}

/* Compute Metrics Extended metrics set :: TypedReadsPerCacheLine */
double
cnl__compute_extended__typed_reads_per_cache_line__read(const struct intel_perf *perf,
                                                        const struct intel_perf_metric_set *metric_set,
                                                        uint64_t *accumulator)
{
    /* RPN equation: $EuTypedReads0 $TypedReads0 FDIV */
    double tmp0 = cnl__compute_extended__eu_typed_reads0__read(perf, metric_set, accumulator);
    double tmp1 = cnl__compute_extended__typed_reads0__read(perf, metric_set, accumulator);
    double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

    return tmp2;
}

/* Compute Metrics Extended metrics set :: TypedWritesPerCacheLine */
double
cnl__compute_extended__typed_writes_per_cache_line__read(const struct intel_perf *perf,
                                                         const struct intel_perf_metric_set *metric_set,
                                                         uint64_t *accumulator)
{
    /* RPN equation: $EuTypedWrites0 $TypedWrites0 FDIV */
    double tmp0 = cnl__compute_extended__eu_typed_writes0__read(perf, metric_set, accumulator);
    double tmp1 = cnl__compute_extended__typed_writes0__read(perf, metric_set, accumulator);
    double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

    return tmp2;
}

/* Compute Metrics Extended metrics set :: UntypedReadsPerCacheLine */
double
cnl__compute_extended__untyped_reads_per_cache_line__read(const struct intel_perf *perf,
                                                          const struct intel_perf_metric_set *metric_set,
                                                          uint64_t *accumulator)
{
    /* RPN equation: $EuUntypedReads0 $EuA64UntypedReads0 FADD $UntypedReads0 FDIV */
    double tmp0 = cnl__compute_extended__eu_untyped_reads0__read(perf, metric_set, accumulator) + cnl__compute_extended__eu_a64_untyped_reads0__read(perf, metric_set, accumulator);
    double tmp1 = tmp0;
    double tmp2 = cnl__compute_extended__untyped_reads0__read(perf, metric_set, accumulator);
    double tmp3 = tmp2 ? tmp1 / tmp2 : 0;

    return tmp3;
}

/* Compute Metrics Extended metrics set :: UntypedWritesPerCacheLine */
double
cnl__compute_extended__untyped_writes_per_cache_line__read(const struct intel_perf *perf,
                                                           const struct intel_perf_metric_set *metric_set,
                                                           uint64_t *accumulator)
{
    /* RPN equation: $EuUntypedWrites0 $EuA64UntypedWrites0 FADD $UntypedWrites0 FDIV */
    double tmp0 = cnl__compute_extended__eu_untyped_writes0__read(perf, metric_set, accumulator) + cnl__compute_extended__eu_a64_untyped_writes0__read(perf, metric_set, accumulator);
    double tmp1 = tmp0;
    double tmp2 = cnl__compute_extended__untyped_writes0__read(perf, metric_set, accumulator);
    double tmp3 = tmp2 ? tmp1 / tmp2 : 0;

    return tmp3;
}

/* Compute Metrics Extended metrics set :: TypedAtomicsPerCacheLine */
double
cnl__compute_extended__typed_atomics_per_cache_line__read(const struct intel_perf *perf,
                                                          const struct intel_perf_metric_set *metric_set,
                                                          uint64_t *accumulator)
{
    /* RPN equation: $EuTypedAtomics0 $TypedAtomics0 FDIV */
    double tmp0 = cnl__compute_extended__eu_typed_atomics0__read(perf, metric_set, accumulator);
    double tmp1 = cnl__compute_extended__typed_atomics0__read(perf, metric_set, accumulator);
    double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

    return tmp2;
}

/* Compute Metrics L3 Cache metrics set :: L3 Lookup Accesses w/o IC */
uint64_t
cnl__compute_l3_cache__l3_lookups__read(const struct intel_perf *perf,
                                        const struct intel_perf_metric_set *metric_set,
                                        uint64_t *accumulator)
{
    /* RPN equation: $SliceMask 1 AND C 4 READ UMUL $SliceMask 1 >> 1 AND C 5 READ UMUL UADD 8 UMUL A 32 READ UADD */
    uint64_t tmp0 = perf->devinfo.slice_mask & 1;
    uint64_t tmp1 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp2 = tmp0 * tmp1;
    uint64_t tmp3 = perf->devinfo.slice_mask >> 1;
    uint64_t tmp4 = tmp3 & 1;
    uint64_t tmp5 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp6 = tmp4 * tmp5;
    uint64_t tmp7 = tmp2 + tmp6;
    uint64_t tmp8 = tmp7 * 8;
    uint64_t tmp9 = accumulator[metric_set->a_offset + 32];
    uint64_t tmp10 = tmp8 + tmp9;

    return tmp10;
}

/* Compute Metrics L3 Cache metrics set :: L3 Sampler Throughput */
uint64_t
cnl__compute_l3_cache__l3_sampler_throughput__read(const struct intel_perf *perf,
                                                   const struct intel_perf_metric_set *metric_set,
                                                   uint64_t *accumulator)
{
    /* RPN equation: 64  $SliceMask 1 AND C 4 READ UMUL $SliceMask 1 >> 1 AND C 5 READ UMUL UADD 8 UMUL UMUL */
    uint64_t tmp0 = perf->devinfo.slice_mask & 1;
    uint64_t tmp1 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp2 = tmp0 * tmp1;
    uint64_t tmp3 = perf->devinfo.slice_mask >> 1;
    uint64_t tmp4 = tmp3 & 1;
    uint64_t tmp5 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp6 = tmp4 * tmp5;
    uint64_t tmp7 = tmp2 + tmp6;
    uint64_t tmp8 = tmp7 * 8;
    uint64_t tmp9 = 64 * tmp8;

    return tmp9;
}

/* Compute Metrics L3 Cache metrics set :: Slice0 L3 Bank0 Accesses */
uint64_t
cnl__compute_l3_cache__l3_bank00_accesses__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: B 0 READ 2 UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp1 = tmp0 * 2;

    return tmp1;
}

/* Compute Metrics L3 Cache metrics set :: Slice0 L3 Bank1 Accesses */
uint64_t
cnl__compute_l3_cache__l3_bank01_accesses__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: B 1 READ 2 UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp1 = tmp0 * 2;

    return tmp1;
}

/* Compute Metrics L3 Cache metrics set :: Slice1 L3 Bank1 Accesses */
uint64_t
cnl__compute_l3_cache__l3_bank11_accesses__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: B 4 READ 2 UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp1 = tmp0 * 2;

    return tmp1;
}

/* Compute Metrics L3 Cache metrics set :: Slice1 L3 Bank2 Accesses */
uint64_t
cnl__compute_l3_cache__l3_bank12_accesses__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: B 5 READ 2 UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp1 = tmp0 * 2;

    return tmp1;
}

/* Compute Metrics L3 Cache metrics set :: L3 Accesses */
uint64_t
cnl__compute_l3_cache__l3_accesses__read(const struct intel_perf *perf,
                                         const struct intel_perf_metric_set *metric_set,
                                         uint64_t *accumulator)
{
    /* RPN equation: $L3Bank00Accesses $L3Bank01Accesses UADD $L3Bank02Accesses UADD $L3Bank10Accesses UADD $L3Bank11Accesses UADD $L3Bank12Accesses UADD */
    uint64_t tmp0 = cnl__compute_l3_cache__l3_bank00_accesses__read(perf, metric_set, accumulator) + cnl__compute_l3_cache__l3_bank01_accesses__read(perf, metric_set, accumulator);
    uint64_t tmp1 = tmp0 + cnl__compute_l3_cache__l3_bank02_accesses__read(perf, metric_set, accumulator);
    uint64_t tmp2 = tmp1 + cnl__compute_l3_cache__l3_bank10_accesses__read(perf, metric_set, accumulator);
    uint64_t tmp3 = tmp2 + cnl__compute_l3_cache__l3_bank11_accesses__read(perf, metric_set, accumulator);
    uint64_t tmp4 = tmp3 + cnl__compute_l3_cache__l3_bank12_accesses__read(perf, metric_set, accumulator);

    return tmp4;
}

/* Compute Metrics L3 Cache metrics set :: L3 Total Throughput */
uint64_t
cnl__compute_l3_cache__l3_total_throughput__read(const struct intel_perf *perf,
                                                 const struct intel_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: $L3Accesses 64 UMUL */
    uint64_t tmp0 = cnl__compute_l3_cache__l3_accesses__read(perf, metric_set, accumulator) * 64;

    return tmp0;
}

/* Metric set HDCAndSF :: Slice0 Subslice0 Non-sampler Shader Access Stalled On L3 */
double
cnl__hdc_and_sf__non_sampler_shader00_access_stalled_on_l3__read(const struct intel_perf *perf,
                                                                 const struct intel_perf_metric_set *metric_set,
                                                                 uint64_t *accumulator)
{
    /* RPN equation: B 2 READ B 3 READ FSUB 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 3];
    double tmp2 = tmp0 - tmp1;
    uint64_t tmp3 = tmp2 * 100;
    double tmp4 = tmp3;
    double tmp5 = cnl__hdc_and_sf__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

    return tmp6;
}

/* Metric set HDCAndSF :: Slice0 Subslice1 Non-sampler Shader Access Stalled On L3 */
double
cnl__hdc_and_sf__non_sampler_shader01_access_stalled_on_l3__read(const struct intel_perf *perf,
                                                                 const struct intel_perf_metric_set *metric_set,
                                                                 uint64_t *accumulator)
{
    /* RPN equation: B 4 READ B 5 READ FSUB 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 5];
    double tmp2 = tmp0 - tmp1;
    uint64_t tmp3 = tmp2 * 100;
    double tmp4 = tmp3;
    double tmp5 = cnl__hdc_and_sf__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

    return tmp6;
}

/* Metric set HDCAndSF :: Slice0 Subslice2 Non-sampler Shader Access Stalled On L3 */
double
cnl__hdc_and_sf__non_sampler_shader02_access_stalled_on_l3__read(const struct intel_perf *perf,
                                                                 const struct intel_perf_metric_set *metric_set,
                                                                 uint64_t *accumulator)
{
    /* RPN equation: B 6 READ B 7 READ FSUB 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 7];
    double tmp2 = tmp0 - tmp1;
    uint64_t tmp3 = tmp2 * 100;
    double tmp4 = tmp3;
    double tmp5 = cnl__hdc_and_sf__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

    return tmp6;
}

/* Metric set HDCAndSF :: Slice1 Subslice0 Non-sampler Shader Access Stalled On L3 */
double
cnl__hdc_and_sf__non_sampler_shader10_access_stalled_on_l3__read(const struct intel_perf *perf,
                                                                 const struct intel_perf_metric_set *metric_set,
                                                                 uint64_t *accumulator)
{
    /* RPN equation: C 0 READ C 1 READ FSUB 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 1];
    double tmp2 = tmp0 - tmp1;
    uint64_t tmp3 = tmp2 * 100;
    double tmp4 = tmp3;
    double tmp5 = cnl__hdc_and_sf__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

    return tmp6;
}

/* Metric set HDCAndSF :: Slice1 Subslice1 Non-sampler Shader Access Stalled On L3 */
double
cnl__hdc_and_sf__non_sampler_shader11_access_stalled_on_l3__read(const struct intel_perf *perf,
                                                                 const struct intel_perf_metric_set *metric_set,
                                                                 uint64_t *accumulator)
{
    /* RPN equation: C 2 READ C 3 READ FSUB 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 3];
    double tmp2 = tmp0 - tmp1;
    uint64_t tmp3 = tmp2 * 100;
    double tmp4 = tmp3;
    double tmp5 = cnl__hdc_and_sf__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

    return tmp6;
}

/* Metric set TDL_1 :: NonPS Thread Ready For Dispatch on Slice0 Subslice0 */
double
cnl__tdl_1__non_ps_thread00_ready_for_dispatch__read(const struct intel_perf *perf,
                                                     const struct intel_perf_metric_set *metric_set,
                                                     uint64_t *accumulator)
{
    /* RPN equation: 1  C 2 READ $GpuCoreClocks FDIV FSUB */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 2];
    double tmp1 = tmp0;
    double tmp2 = cnl__tdl_1__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    double tmp4 = 1 - tmp3;

    return tmp4;
}

/* Metric set TDL_1 :: NonPS Thread Ready For Dispatch on Slice0 Subslice1 */
double
cnl__tdl_1__non_ps_thread01_ready_for_dispatch__read(const struct intel_perf *perf,
                                                     const struct intel_perf_metric_set *metric_set,
                                                     uint64_t *accumulator)
{
    /* RPN equation: 1  C 3 READ $GpuCoreClocks FDIV FSUB */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 3];
    double tmp1 = tmp0;
    double tmp2 = cnl__tdl_1__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    double tmp4 = 1 - tmp3;

    return tmp4;
}

/* Metric set TDL_1 :: NonPS Thread Ready For Dispatch on Slice0 Subslice2 */
double
cnl__tdl_1__non_ps_thread02_ready_for_dispatch__read(const struct intel_perf *perf,
                                                     const struct intel_perf_metric_set *metric_set,
                                                     uint64_t *accumulator)
{
    /* RPN equation: 1  C 4 READ $GpuCoreClocks FDIV FSUB */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 4];
    double tmp1 = tmp0;
    double tmp2 = cnl__tdl_1__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    double tmp4 = 1 - tmp3;

    return tmp4;
}

/* Metric set TDL_1 :: NonPS Thread Ready For Dispatch on Slice1 Subslice0 */
double
cnl__tdl_1__non_ps_thread10_ready_for_dispatch__read(const struct intel_perf *perf,
                                                     const struct intel_perf_metric_set *metric_set,
                                                     uint64_t *accumulator)
{
    /* RPN equation: 1  C 5 READ $GpuCoreClocks FDIV FSUB */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 5];
    double tmp1 = tmp0;
    double tmp2 = cnl__tdl_1__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    double tmp4 = 1 - tmp3;

    return tmp4;
}

/* Metric set TDL_1 :: NonPS Thread Ready For Dispatch on Slice1 Subslice1 */
double
cnl__tdl_1__non_ps_thread11_ready_for_dispatch__read(const struct intel_perf *perf,
                                                     const struct intel_perf_metric_set *metric_set,
                                                     uint64_t *accumulator)
{
    /* RPN equation: 1  C 6 READ $GpuCoreClocks FDIV FSUB */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 6];
    double tmp1 = tmp0;
    double tmp2 = cnl__tdl_1__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp3 = tmp2 ? tmp1 / tmp2 : 0;
    double tmp4 = 1 - tmp3;

    return tmp4;
}

/* Render Metrics Basic set :: Sampler Cache Misses */
uint64_t
icl__render_basic__sampler_l1_misses__read(const struct intel_perf *perf,
                                           const struct intel_perf_metric_set *metric_set,
                                           uint64_t *accumulator)
{
    /* RPN equation: C 4 READ C 5 READ UADD 2 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = tmp2 * 2;

    return tmp3;
}

/* Render Metrics Basic set :: L3 Shader Throughput */
uint64_t
icl__render_basic__l3_shader_throughput__read(const struct intel_perf *perf,
                                              const struct intel_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: $ShaderMemoryAccesses 64 UMUL */
    uint64_t tmp0 = icl__render_basic__shader_memory_accesses__read(perf, metric_set, accumulator) * 64;

    return tmp0;
}

/* Render Metrics Basic set :: GTI Read Throughput */
uint64_t
icl__render_basic__gti_read_throughput__read(const struct intel_perf *perf,
                                             const struct intel_perf_metric_set *metric_set,
                                             uint64_t *accumulator)
{
    /* RPN equation: 64  B 1 READ B 3 READ UADD B 4 READ UADD B 5 READ UADD UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp6 = tmp4 + tmp5;
    uint64_t tmp7 = 64 * tmp6;

    return tmp7;
}

/* Render Metrics Basic set :: GTI Write Throughput */
uint64_t
icl__render_basic__gti_write_throughput__read(const struct intel_perf *perf,
                                              const struct intel_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: 64  B 0 READ B 2 READ UADD UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = 64 * tmp2;

    return tmp3;
}

/* Compute Metrics Basic set :: Typed Bytes Read */
uint64_t
icl__compute_basic__typed_bytes_read__read(const struct intel_perf *perf,
                                           const struct intel_perf_metric_set *metric_set,
                                           uint64_t *accumulator)
{
    /* RPN equation: C 7 READ C 6 READ UADD $EuSubslicesTotalCount UMUL 32 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = tmp2 * perf->devinfo.n_eu_sub_slices;
    uint64_t tmp4 = tmp3 * 32;

    return tmp4;
}

/* Compute Metrics Basic set :: Typed Bytes Written */
uint64_t
icl__compute_basic__typed_bytes_written__read(const struct intel_perf *perf,
                                              const struct intel_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: C 5 READ C 4 READ UADD $EuSubslicesTotalCount UMUL 32 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = tmp2 * perf->devinfo.n_eu_sub_slices;
    uint64_t tmp4 = tmp3 * 32;

    return tmp4;
}

/* Compute Metrics Basic set :: Untyped Bytes Read */
uint64_t
icl__compute_basic__untyped_bytes_read__read(const struct intel_perf *perf,
                                             const struct intel_perf_metric_set *metric_set,
                                             uint64_t *accumulator)
{
    /* RPN equation: C 3 READ C 2 READ UADD $EuSubslicesTotalCount UMUL 32 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = tmp2 * perf->devinfo.n_eu_sub_slices;
    uint64_t tmp4 = tmp3 * 32;

    return tmp4;
}

/* Compute Metrics Basic set :: Untyped Writes */
uint64_t
icl__compute_basic__untyped_bytes_written__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: C 1 READ C 0 READ UADD $EuSubslicesTotalCount UMUL 32 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = tmp2 * perf->devinfo.n_eu_sub_slices;
    uint64_t tmp4 = tmp3 * 32;

    return tmp4;
}

/* Compute Metrics Basic set :: Typed Atomics Accesses */
uint64_t
icl__compute_basic__typed_atomics__read(const struct intel_perf *perf,
                                        const struct intel_perf_metric_set *metric_set,
                                        uint64_t *accumulator)
{
    /* RPN equation: B 4 READ B 5 READ FADD 2 FDIV $EuSubslicesTotalCount FMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 5];
    double tmp2 = tmp0 + tmp1;
    double tmp3 = tmp2;
    double tmp4 = 2;
    double tmp5 = tmp4 ? tmp3 / tmp4 : 0;
    double tmp6 = tmp5 * perf->devinfo.n_eu_sub_slices;

    return tmp6;
}

/* Compute Metrics Basic set :: GTI Read Throughput */
uint64_t
icl__compute_basic__gti_read_throughput__read(const struct intel_perf *perf,
                                              const struct intel_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: 64  B 1 READ B 3 READ UADD B 6 READ UADD B 7 READ UADD UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp6 = tmp4 + tmp5;
    uint64_t tmp7 = 64 * tmp6;

    return tmp7;
}

/* Compute Extended metrics set :: Eu A32 Untyped Writes 00 */
uint64_t
icl__compute_extended__eu_a32_untyped_writes00__read(const struct intel_perf *perf,
                                                     const struct intel_perf_metric_set *metric_set,
                                                     uint64_t *accumulator)
{
    /* RPN equation: B 7 READ B 1 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp2 = tmp0 + tmp1;

    return tmp2;
}

/* Compute Extended metrics set :: Eu 64 Untyped Reads 00 */
double
icl__compute_extended__eu_a64_untyped_reads00__read(const struct intel_perf *perf,
                                                    const struct intel_perf_metric_set *metric_set,
                                                    uint64_t *accumulator)
{
    /* RPN equation: B 5 READ C 1 READ FADD B 6 READ FADD */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 1];
    double tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->b_offset + 6];
    double tmp4 = tmp2 + tmp3;

    return tmp4;
}

/* Compute Extended metrics set :: TypedAtomicsPerCacheLine */
double
icl__compute_extended__typed_atomics_per_cache_line__read(const struct intel_perf *perf,
                                                          const struct intel_perf_metric_set *metric_set,
                                                          uint64_t *accumulator)
{
    /* RPN equation: $EuTypedAtomics00 $TypedAtomics00 FDIV */
    double tmp0 = icl__compute_extended__eu_typed_atomics00__read(perf, metric_set, accumulator);
    double tmp1 = icl__compute_extended__typed_atomics00__read(perf, metric_set, accumulator);
    double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

    return tmp2;
}

/* Compute Extended metrics set :: TypedReadsPerCacheLine */
double
icl__compute_extended__typed_reads_per_cache_line__read(const struct intel_perf *perf,
                                                        const struct intel_perf_metric_set *metric_set,
                                                        uint64_t *accumulator)
{
    /* RPN equation: $EuTypedReads00 $TypedReads00 FDIV */
    double tmp0 = icl__compute_extended__eu_typed_reads00__read(perf, metric_set, accumulator);
    double tmp1 = icl__compute_extended__typed_reads00__read(perf, metric_set, accumulator);
    double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

    return tmp2;
}

/* Compute Extended metrics set :: TypedWritesPerCacheLine */
double
icl__compute_extended__typed_writes_per_cache_line__read(const struct intel_perf *perf,
                                                         const struct intel_perf_metric_set *metric_set,
                                                         uint64_t *accumulator)
{
    /* RPN equation: $EuTypedWrites00 $TypedWrites00 FDIV */
    double tmp0 = icl__compute_extended__eu_typed_writes00__read(perf, metric_set, accumulator);
    double tmp1 = icl__compute_extended__typed_writes00__read(perf, metric_set, accumulator);
    double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

    return tmp2;
}

/* Compute Extended metrics set :: UntypedReadsPerCacheLine */
double
icl__compute_extended__untyped_reads_per_cache_line__read(const struct intel_perf *perf,
                                                          const struct intel_perf_metric_set *metric_set,
                                                          uint64_t *accumulator)
{
    /* RPN equation: B 0 READ B 5 READ C 1 READ FADD B 6 READ FADD FADD C 4 READ FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp2 = accumulator[metric_set->c_offset + 1];
    double tmp3 = tmp1 + tmp2;
    uint64_t tmp4 = accumulator[metric_set->b_offset + 6];
    double tmp5 = tmp3 + tmp4;
    double tmp6 = tmp0 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->c_offset + 4];
    double tmp8 = tmp6;
    double tmp9 = tmp7;
    double tmp10 = tmp9 ? tmp8 / tmp9 : 0;

    return tmp10;
}

/* Compute Extended metrics set :: UntypedWritesPerCacheLine */
double
icl__compute_extended__untyped_writes_per_cache_line__read(const struct intel_perf *perf,
                                                           const struct intel_perf_metric_set *metric_set,
                                                           uint64_t *accumulator)
{
    /* RPN equation: B 7 READ B 1 READ FADD C 2 READ FADD C 3 READ FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 1];
    double tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->c_offset + 2];
    double tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->c_offset + 3];
    double tmp6 = tmp4;
    double tmp7 = tmp5;
    double tmp8 = tmp7 ? tmp6 / tmp7 : 0;

    return tmp8;
}

/* Compute Metrics L3 Cache metrics set :: Slice0 L3 Bank0 Accesses */
uint64_t
icl__compute_l3_cache__l3_bank00_accesses__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: C 7 READ 2 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp1 = tmp0 * 2;

    return tmp1;
}

/* Compute Metrics L3 Cache metrics set :: Slice0 L3 Bank2 Accesses */
uint64_t
icl__compute_l3_cache__l3_bank02_accesses__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: C 5 READ 2 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp1 = tmp0 * 2;

    return tmp1;
}

/* Compute Metrics L3 Cache metrics set :: Slice0 L3 Bank3 Accesses */
uint64_t
icl__compute_l3_cache__l3_bank03_accesses__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: C 4 READ 2 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp1 = tmp0 * 2;

    return tmp1;
}

/* Compute Metrics L3 Cache metrics set :: L3 Accesses */
uint64_t
icl__compute_l3_cache__l3_accesses__read(const struct intel_perf *perf,
                                         const struct intel_perf_metric_set *metric_set,
                                         uint64_t *accumulator)
{
    /* RPN equation: $L3Bank00Accesses $L3Bank01Accesses UADD $L3Bank02Accesses UADD $L3Bank03Accesses UADD $L3Bank04Accesses UADD $L3Bank05Accesses UADD $L3Bank06Accesses UADD $L3Bank07Accesses UADD */
    uint64_t tmp0 = icl__compute_l3_cache__l3_bank00_accesses__read(perf, metric_set, accumulator) + icl__compute_l3_cache__l3_bank01_accesses__read(perf, metric_set, accumulator);
    uint64_t tmp1 = tmp0 + icl__compute_l3_cache__l3_bank02_accesses__read(perf, metric_set, accumulator);
    uint64_t tmp2 = tmp1 + icl__compute_l3_cache__l3_bank03_accesses__read(perf, metric_set, accumulator);
    uint64_t tmp3 = tmp2 + icl__compute_l3_cache__l3_bank04_accesses__read(perf, metric_set, accumulator);
    uint64_t tmp4 = tmp3 + icl__compute_l3_cache__l3_bank05_accesses__read(perf, metric_set, accumulator);
    uint64_t tmp5 = tmp4 + icl__compute_l3_cache__l3_bank06_accesses__read(perf, metric_set, accumulator);
    uint64_t tmp6 = tmp5 + icl__compute_l3_cache__l3_bank07_accesses__read(perf, metric_set, accumulator);

    return tmp6;
}

/* Compute Metrics L3 Cache metrics set :: L3 Lookup Accesses w/o IC */
uint64_t
icl__compute_l3_cache__l3_lookups__read(const struct intel_perf *perf,
                                        const struct intel_perf_metric_set *metric_set,
                                        uint64_t *accumulator)
{
    /* RPN equation: B 7 READ B 6 READ UADD 2 UMUL A 32 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = tmp2 * 2;
    uint64_t tmp4 = accumulator[metric_set->a_offset + 32];
    uint64_t tmp5 = tmp3 + tmp4;

    return tmp5;
}

/* Compute Metrics L3 Cache metrics set :: L3 Sampler Throughput */
uint64_t
icl__compute_l3_cache__l3_sampler_throughput__read(const struct intel_perf *perf,
                                                   const struct intel_perf_metric_set *metric_set,
                                                   uint64_t *accumulator)
{
    /* RPN equation: 64  B 7 READ B 6 READ UADD 2 UMUL UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = tmp2 * 2;
    uint64_t tmp4 = 64 * tmp3;

    return tmp4;
}

/* Compute Metrics L3 Cache metrics set :: L3 Total Throughput */
uint64_t
icl__compute_l3_cache__l3_total_throughput__read(const struct intel_perf *perf,
                                                 const struct intel_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: $L3Accesses 64 UMUL */
    uint64_t tmp0 = icl__compute_l3_cache__l3_accesses__read(perf, metric_set, accumulator) * 64;

    return tmp0;
}

/* Compute Metrics L3 Cache metrics set :: GTI Read Throughput */
uint64_t
icl__compute_l3_cache__gti_read_throughput__read(const struct intel_perf *perf,
                                                 const struct intel_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: B 2 READ 64 UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp1 = tmp0 * 64;

    return tmp1;
}

/* Compute Metrics L3 Cache metrics set :: GTI Write Throughput */
uint64_t
icl__compute_l3_cache__gti_write_throughput__read(const struct intel_perf *perf,
                                                  const struct intel_perf_metric_set *metric_set,
                                                  uint64_t *accumulator)
{
    /* RPN equation: B 3 READ 64 UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp1 = tmp0 * 64;

    return tmp1;
}

/* Metric set HDCAndSF :: Slice0 Dualsubslice0 Non-sampler Shader Access Stalled On L3 */
double
icl__hdc_and_sf__non_sampler_shader00_access_stalled_on_l3__read(const struct intel_perf *perf,
                                                                 const struct intel_perf_metric_set *metric_set,
                                                                 uint64_t *accumulator)
{
    /* RPN equation: C 0 READ B 7 READ FSUB 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 7];
    double tmp2 = tmp0 - tmp1;
    uint64_t tmp3 = tmp2 * 100;
    double tmp4 = tmp3;
    double tmp5 = icl__hdc_and_sf__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

    return tmp6;
}

/* Metric set HDCAndSF :: Slice0 Dualsubslice1 Non-sampler Shader Access Stalled On L3 */
double
icl__hdc_and_sf__non_sampler_shader01_access_stalled_on_l3__read(const struct intel_perf *perf,
                                                                 const struct intel_perf_metric_set *metric_set,
                                                                 uint64_t *accumulator)
{
    /* RPN equation: C 2 READ C 1 READ FSUB 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 1];
    double tmp2 = tmp0 - tmp1;
    uint64_t tmp3 = tmp2 * 100;
    double tmp4 = tmp3;
    double tmp5 = icl__hdc_and_sf__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

    return tmp6;
}

/* Metric set HDCAndSF :: Slice0 Dualsubslice2 Non-sampler Shader Access Stalled On L3 */
double
icl__hdc_and_sf__non_sampler_shader02_access_stalled_on_l3__read(const struct intel_perf *perf,
                                                                 const struct intel_perf_metric_set *metric_set,
                                                                 uint64_t *accumulator)
{
    /* RPN equation: C 4 READ C 3 READ FSUB 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 3];
    double tmp2 = tmp0 - tmp1;
    uint64_t tmp3 = tmp2 * 100;
    double tmp4 = tmp3;
    double tmp5 = icl__hdc_and_sf__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

    return tmp6;
}

/* Metric set HDCAndSF :: Slice0 Dualsubslice3 Non-sampler Shader Access Stalled On L3 */
double
icl__hdc_and_sf__non_sampler_shader03_access_stalled_on_l3__read(const struct intel_perf *perf,
                                                                 const struct intel_perf_metric_set *metric_set,
                                                                 uint64_t *accumulator)
{
    /* RPN equation: C 6 READ C 5 READ FSUB 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 5];
    double tmp2 = tmp0 - tmp1;
    uint64_t tmp3 = tmp2 * 100;
    double tmp4 = tmp3;
    double tmp5 = icl__hdc_and_sf__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

    return tmp6;
}

/* L2Bank0 stalled metric set :: Slice0 L3 Bank0 Stalled */
double
icl__l3_2__l30_bank0_stalled__read(const struct intel_perf *perf,
                                   const struct intel_perf_metric_set *metric_set,
                                   uint64_t *accumulator)
{
    /* RPN equation: B 0 READ B 1 READ FADD B 2 READ FADD B 3 READ FADD 4 FDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 1];
    double tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->b_offset + 2];
    double tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->b_offset + 3];
    double tmp6 = tmp4 + tmp5;
    double tmp7 = tmp6;
    double tmp8 = 4;
    double tmp9 = tmp8 ? tmp7 / tmp8 : 0;
    uint64_t tmp10 = tmp9 * 100;
    double tmp11 = tmp10;
    double tmp12 = icl__l3_2__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp13 = tmp12 ? tmp11 / tmp12 : 0;

    return tmp13;
}

/* L2Bank5 stalled metric set :: Slice0 L3 Bank5 Stalled */
double
icl__l3_5__l30_bank5_stalled__read(const struct intel_perf *perf,
                                   const struct intel_perf_metric_set *metric_set,
                                   uint64_t *accumulator)
{
    /* RPN equation: B 2 READ B 3 READ FADD B 0 READ FADD B 1 READ FADD 4 FDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 3];
    double tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->b_offset + 0];
    double tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->b_offset + 1];
    double tmp6 = tmp4 + tmp5;
    double tmp7 = tmp6;
    double tmp8 = 4;
    double tmp9 = tmp8 ? tmp7 / tmp8 : 0;
    uint64_t tmp10 = tmp9 * 100;
    double tmp11 = tmp10;
    double tmp12 = icl__l3_5__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp13 = tmp12 ? tmp11 / tmp12 : 0;

    return tmp13;
}

/* Metric set TDL_1 :: VS AVG Active per Thread */
uint64_t
icl__tdl_1__vs_eu_active_per_thread__read(const struct intel_perf *perf,
                                          const struct intel_perf_metric_set *metric_set,
                                          uint64_t *accumulator)
{
    /* RPN equation: A 13 READ $VsThreads UDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 13];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = icl__tdl_1__vs_threads__read(perf, metric_set, accumulator);
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

    return tmp3;
}

/* Metric set TDL_1 :: VS AVG Stall per Thread */
uint64_t
icl__tdl_1__vs_eu_stall_per_thread__read(const struct intel_perf *perf,
                                         const struct intel_perf_metric_set *metric_set,
                                         uint64_t *accumulator)
{
    /* RPN equation: A 14 READ $VsThreads UDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 14];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = icl__tdl_1__vs_threads__read(perf, metric_set, accumulator);
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

    return tmp3;
}

/* Metric set TDL_1 :: FS AVG Active per Thread */
uint64_t
icl__tdl_1__ps_eu_active_per_thread__read(const struct intel_perf *perf,
                                          const struct intel_perf_metric_set *metric_set,
                                          uint64_t *accumulator)
{
    /* RPN equation: A 19 READ $PsThreads UDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 19];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = icl__tdl_1__ps_threads__read(perf, metric_set, accumulator);
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

    return tmp3;
}

/* Metric set TDL_1 :: FS AVG Stall per Thread */
uint64_t
icl__tdl_1__ps_eu_stall_per_thread__read(const struct intel_perf *perf,
                                         const struct intel_perf_metric_set *metric_set,
                                         uint64_t *accumulator)
{
    /* RPN equation: A 20 READ $PsThreads UDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 20];
    uint64_t tmp1 = tmp0;
    uint64_t tmp2 = icl__tdl_1__ps_threads__read(perf, metric_set, accumulator);
    uint64_t tmp3 = tmp2 ? tmp1 / tmp2 : 0;

    return tmp3;
}

/* Metric set TDL_2 :: Non-PS Thread Ready For Dispatch on Slice0 Subslice0 Thread Dispatcher */
double
icl__tdl_2__non_ps_thread00_ready_for_dispatch__read(const struct intel_perf *perf,
                                                     const struct intel_perf_metric_set *metric_set,
                                                     uint64_t *accumulator)
{
    /* RPN equation: GPU_CLOCK 0 READ B 7 READ FSUB 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->gpu_clock_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 7];
    double tmp2 = tmp0 - tmp1;
    uint64_t tmp3 = tmp2 * 100;
    double tmp4 = tmp3;
    double tmp5 = icl__tdl_2__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

    return tmp6;
}

/* Metric set TDL_2 :: Non-PS Thread Ready For Dispatch on Slice0 Subslice1 Thread Dispatcher */
double
icl__tdl_2__non_ps_thread01_ready_for_dispatch__read(const struct intel_perf *perf,
                                                     const struct intel_perf_metric_set *metric_set,
                                                     uint64_t *accumulator)
{
    /* RPN equation: GPU_CLOCK 0 READ C 0 READ FSUB 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->gpu_clock_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 0];
    double tmp2 = tmp0 - tmp1;
    uint64_t tmp3 = tmp2 * 100;
    double tmp4 = tmp3;
    double tmp5 = icl__tdl_2__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

    return tmp6;
}

/* Metric set TDL_2 :: Non-PS Thread Ready For Dispatch on Slice0 Subslice2 Thread Dispatcher */
double
icl__tdl_2__non_ps_thread02_ready_for_dispatch__read(const struct intel_perf *perf,
                                                     const struct intel_perf_metric_set *metric_set,
                                                     uint64_t *accumulator)
{
    /* RPN equation: GPU_CLOCK 0 READ C 1 READ FSUB 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->gpu_clock_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 1];
    double tmp2 = tmp0 - tmp1;
    uint64_t tmp3 = tmp2 * 100;
    double tmp4 = tmp3;
    double tmp5 = icl__tdl_2__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

    return tmp6;
}

/* Metric set TDL_2 :: Non-PS Thread Ready For Dispatch on Slice0 Subslice3 Thread Dispatcher */
double
icl__tdl_2__non_ps_thread03_ready_for_dispatch__read(const struct intel_perf *perf,
                                                     const struct intel_perf_metric_set *metric_set,
                                                     uint64_t *accumulator)
{
    /* RPN equation: GPU_CLOCK 0 READ C 2 READ FSUB 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->gpu_clock_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 2];
    double tmp2 = tmp0 - tmp1;
    uint64_t tmp3 = tmp2 * 100;
    double tmp4 = tmp3;
    double tmp5 = icl__tdl_2__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

    return tmp6;
}

/* Metric set TDL_2 :: Non-PS Thread Ready For Dispatch on Slice0 Subslice4 Thread Dispatcher */
double
icl__tdl_2__non_ps_thread04_ready_for_dispatch__read(const struct intel_perf *perf,
                                                     const struct intel_perf_metric_set *metric_set,
                                                     uint64_t *accumulator)
{
    /* RPN equation: GPU_CLOCK 0 READ C 3 READ FSUB 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->gpu_clock_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 3];
    double tmp2 = tmp0 - tmp1;
    uint64_t tmp3 = tmp2 * 100;
    double tmp4 = tmp3;
    double tmp5 = icl__tdl_2__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

    return tmp6;
}

/* Metric set TDL_2 :: Non-PS Thread Ready For Dispatch on Slice0 Subslice5 Thread Dispatcher */
double
icl__tdl_2__non_ps_thread05_ready_for_dispatch__read(const struct intel_perf *perf,
                                                     const struct intel_perf_metric_set *metric_set,
                                                     uint64_t *accumulator)
{
    /* RPN equation: GPU_CLOCK 0 READ C 4 READ FSUB 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->gpu_clock_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 4];
    double tmp2 = tmp0 - tmp1;
    uint64_t tmp3 = tmp2 * 100;
    double tmp4 = tmp3;
    double tmp5 = icl__tdl_2__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

    return tmp6;
}

/* Metric set TDL_2 :: Non-PS Thread Ready For Dispatch on Slice0 Subslice6 Thread Dispatcher */
double
icl__tdl_2__non_ps_thread06_ready_for_dispatch__read(const struct intel_perf *perf,
                                                     const struct intel_perf_metric_set *metric_set,
                                                     uint64_t *accumulator)
{
    /* RPN equation: GPU_CLOCK 0 READ C 5 READ FSUB 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->gpu_clock_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 5];
    double tmp2 = tmp0 - tmp1;
    uint64_t tmp3 = tmp2 * 100;
    double tmp4 = tmp3;
    double tmp5 = icl__tdl_2__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

    return tmp6;
}

/* Metric set TDL_2 :: Non-PS Thread Ready For Dispatch on Slice0 Subslice7 Thread Dispatcher */
double
icl__tdl_2__non_ps_thread07_ready_for_dispatch__read(const struct intel_perf *perf,
                                                     const struct intel_perf_metric_set *metric_set,
                                                     uint64_t *accumulator)
{
    /* RPN equation: GPU_CLOCK 0 READ C 6 READ FSUB 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->gpu_clock_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 6];
    double tmp2 = tmp0 - tmp1;
    uint64_t tmp3 = tmp2 * 100;
    double tmp4 = tmp3;
    double tmp5 = icl__tdl_2__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

    return tmp6;
}

/* Render Metrics Basic set :: Sampler Cache Misses */
uint64_t
ehl__render_basic__sampler_l1_misses__read(const struct intel_perf *perf,
                                           const struct intel_perf_metric_set *metric_set,
                                           uint64_t *accumulator)
{
    /* RPN equation: C 4 READ C 5 READ UADD 8 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = tmp2 * 8;

    return tmp3;
}

/* Render Metrics Basic set :: GTI Read Throughput */
uint64_t
ehl__render_basic__gti_read_throughput__read(const struct intel_perf *perf,
                                             const struct intel_perf_metric_set *metric_set,
                                             uint64_t *accumulator)
{
    /* RPN equation: 64  B 5 READ B 4 READ UADD UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = 64 * tmp2;

    return tmp3;
}

/* Compute Metrics Basic set :: GTI Read Throughput */
uint64_t
ehl__compute_basic__gti_read_throughput__read(const struct intel_perf *perf,
                                              const struct intel_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: 64  B 7 READ B 6 READ UADD UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = 64 * tmp2;

    return tmp3;
}

/* Compute Metrics L3 Cache set :: L3 Lookup Accesses w/o IC */
uint64_t
ehl__compute_l3_cache__l3_lookups__read(const struct intel_perf *perf,
                                        const struct intel_perf_metric_set *metric_set,
                                        uint64_t *accumulator)
{
    /* RPN equation: B 7 READ B 6 READ UADD 8 UMUL A 32 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = tmp2 * 8;
    uint64_t tmp4 = accumulator[metric_set->a_offset + 32];
    uint64_t tmp5 = tmp3 + tmp4;

    return tmp5;
}

/* Compute Metrics L3 Cache set :: L3 Misses */
uint64_t
ehl__compute_l3_cache__l3_misses__read(const struct intel_perf *perf,
                                       const struct intel_perf_metric_set *metric_set,
                                       uint64_t *accumulator)
{
    /* RPN equation: 2 B 5 READ B 4 READ UADD UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = 2 * tmp2;

    return tmp3;
}

/* Compute Metrics L3 Cache set :: L3 Sampler Throughput */
uint64_t
ehl__compute_l3_cache__l3_sampler_throughput__read(const struct intel_perf *perf,
                                                   const struct intel_perf_metric_set *metric_set,
                                                   uint64_t *accumulator)
{
    /* RPN equation: 64  B 7 READ B 6 READ UADD 8 UMUL UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = tmp2 * 8;
    uint64_t tmp4 = 64 * tmp3;

    return tmp4;
}

/* Compute Metrics L3 Cache set :: GTI L3 Throughput */
uint64_t
ehl__compute_l3_cache__gti_l3_throughput__read(const struct intel_perf *perf,
                                               const struct intel_perf_metric_set *metric_set,
                                               uint64_t *accumulator)
{
    /* RPN equation: $L3Misses 64 UMUL */
    uint64_t tmp0 = ehl__compute_l3_cache__l3_misses__read(perf, metric_set, accumulator) * 64;

    return tmp0;
}

/* Render Metrics Basic set :: EU Active */
double
tglgt1__render_basic__eu_active__read(const struct intel_perf *perf,
                                      const struct intel_perf_metric_set *metric_set,
                                      uint64_t *accumulator)
{
    /* RPN equation: A 7 READ A 8 READ FADD A 9 READ FADD A 10 READ FADD $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->a_offset + 8];
    double tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->a_offset + 9];
    double tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->a_offset + 10];
    double tmp6 = tmp4 + tmp5;
    uint64_t tmp7 = tmp6;
    uint64_t tmp8 = perf->devinfo.n_eus;
    uint64_t tmp9 = tmp8 ? tmp7 / tmp8 : 0;
    uint64_t tmp10 = tmp9 * 100;
    double tmp11 = tmp10;
    double tmp12 = tglgt1__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp13 = tmp12 ? tmp11 / tmp12 : 0;

    return tmp13;
}

/* Render Metrics Basic set :: EU Stall */
double
tglgt1__render_basic__eu_stall__read(const struct intel_perf *perf,
                                     const struct intel_perf_metric_set *metric_set,
                                     uint64_t *accumulator)
{
    /* RPN equation: A 11 READ A 12 READ FADD A 13 READ FADD A 14 READ FADD $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 11];
    uint64_t tmp1 = accumulator[metric_set->a_offset + 12];
    double tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->a_offset + 13];
    double tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->a_offset + 14];
    double tmp6 = tmp4 + tmp5;
    uint64_t tmp7 = tmp6;
    uint64_t tmp8 = perf->devinfo.n_eus;
    uint64_t tmp9 = tmp8 ? tmp7 / tmp8 : 0;
    uint64_t tmp10 = tmp9 * 100;
    double tmp11 = tmp10;
    double tmp12 = tglgt1__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp13 = tmp12 ? tmp11 / tmp12 : 0;

    return tmp13;
}

/* Render Metrics Basic set :: EU Thread Occupancy */
double
tglgt1__render_basic__eu_thread_occupancy__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: 8 A 15 READ A 16 READ FADD A 17 READ FADD A 18 READ FADD FMUL $EuThreadsCount FDIV $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 15];
    uint64_t tmp1 = accumulator[metric_set->a_offset + 16];
    double tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->a_offset + 17];
    double tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->a_offset + 18];
    double tmp6 = tmp4 + tmp5;
    double tmp7 = 8 * tmp6;
    double tmp8 = tmp7;
    double tmp9 = perf->devinfo.eu_threads_count;
    double tmp10 = tmp9 ? tmp8 / tmp9 : 0;
    uint64_t tmp11 = tmp10;
    uint64_t tmp12 = perf->devinfo.n_eus;
    uint64_t tmp13 = tmp12 ? tmp11 / tmp12 : 0;
    uint64_t tmp14 = tmp13 * 100;
    double tmp15 = tmp14;
    double tmp16 = tglgt1__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp17 = tmp16 ? tmp15 / tmp16 : 0;

    return tmp17;
}

/* Render Metrics Basic set :: SLM Bytes Read */
uint64_t
tglgt1__render_basic__slm_bytes_read__max(const struct intel_perf *perf,
                                          const struct intel_perf_metric_set *metric_set,
                                          uint64_t *accumulator)
{
    /* RPN equation: $GpuCoreClocks 128 UMUL $EuSubslicesTotalCount UMUL */
    uint64_t tmp0 = tglgt1__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator) * 128;
    uint64_t tmp1 = tmp0 * perf->devinfo.n_eu_sub_slices;

    return tmp1;
}

/* Render Metrics Basic set :: GTI Read Throughput */
uint64_t
tglgt1__render_basic__gti_read_throughput__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: 64  C 5 READ C 4 READ UADD C 3 READ UADD C 2 READ UADD UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp6 = tmp4 + tmp5;
    uint64_t tmp7 = 64 * tmp6;

    return tmp7;
}

/* Render Metrics Basic set :: GTI Write Throughput */
uint64_t
tglgt1__render_basic__gti_write_throughput__read(const struct intel_perf *perf,
                                                 const struct intel_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: 64  C 1 READ C 0 READ UADD UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = 64 * tmp2;

    return tmp3;
}

/* Compute Metrics Basic set :: GTI Read Throughput */
uint64_t
tglgt1__compute_basic__gti_read_throughput__read(const struct intel_perf *perf,
                                                 const struct intel_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: 64  C 7 READ C 6 READ UADD C 5 READ UADD C 4 READ UADD UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp6 = tmp4 + tmp5;
    uint64_t tmp7 = 64 * tmp6;

    return tmp7;
}

/* Compute Metrics Basic set :: GTI Write Throughput */
uint64_t
tglgt1__compute_basic__gti_write_throughput__read(const struct intel_perf *perf,
                                                  const struct intel_perf_metric_set *metric_set,
                                                  uint64_t *accumulator)
{
    /* RPN equation: 64  C 3 READ C 2 READ UADD UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = 64 * tmp2;

    return tmp3;
}

/* L3_1 :: Slice0 L3 Bank0 Input Available */
double
tglgt1__l3_1__l30_bank0_input_available__read(const struct intel_perf *perf,
                                              const struct intel_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: C 0 READ C 1 READ FADD C 2 READ FADD C 3 READ FADD 4 FDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 1];
    double tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->c_offset + 2];
    double tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->c_offset + 3];
    double tmp6 = tmp4 + tmp5;
    double tmp7 = tmp6;
    double tmp8 = 4;
    double tmp9 = tmp8 ? tmp7 / tmp8 : 0;
    uint64_t tmp10 = tmp9 * 100;
    double tmp11 = tmp10;
    double tmp12 = tglgt1__l3_1__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp13 = tmp12 ? tmp11 / tmp12 : 0;

    return tmp13;
}

/* L3_1 :: Slice0 L3 Bank1 Input Available */
double
tglgt1__l3_1__l30_bank1_input_available__read(const struct intel_perf *perf,
                                              const struct intel_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: C 4 READ C 5 READ FADD C 6 READ FADD C 7 READ FADD 4 FDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 5];
    double tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->c_offset + 6];
    double tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->c_offset + 7];
    double tmp6 = tmp4 + tmp5;
    double tmp7 = tmp6;
    double tmp8 = 4;
    double tmp9 = tmp8 ? tmp7 / tmp8 : 0;
    uint64_t tmp10 = tmp9 * 100;
    double tmp11 = tmp10;
    double tmp12 = tglgt1__l3_1__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp13 = tmp12 ? tmp11 / tmp12 : 0;

    return tmp13;
}

/* L3_2 :: Slice0 L3 Bank2 Input Available */
double
tglgt1__l3_2__l30_bank2_input_available__read(const struct intel_perf *perf,
                                              const struct intel_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: B 3 READ B 2 READ FADD B 1 READ FADD B 0 READ FADD 4 FDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 2];
    double tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->b_offset + 1];
    double tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->b_offset + 0];
    double tmp6 = tmp4 + tmp5;
    double tmp7 = tmp6;
    double tmp8 = 4;
    double tmp9 = tmp8 ? tmp7 / tmp8 : 0;
    uint64_t tmp10 = tmp9 * 100;
    double tmp11 = tmp10;
    double tmp12 = tglgt1__l3_2__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp13 = tmp12 ? tmp11 / tmp12 : 0;

    return tmp13;
}

/* L3_2 :: Slice0 L3 Bank3 Input Available */
double
tglgt1__l3_2__l30_bank3_input_available__read(const struct intel_perf *perf,
                                              const struct intel_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: B 7 READ B 6 READ FADD B 5 READ FADD B 4 READ FADD 4 FDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 6];
    double tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->b_offset + 5];
    double tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->b_offset + 4];
    double tmp6 = tmp4 + tmp5;
    double tmp7 = tmp6;
    double tmp8 = 4;
    double tmp9 = tmp8 ? tmp7 / tmp8 : 0;
    uint64_t tmp10 = tmp9 * 100;
    double tmp11 = tmp10;
    double tmp12 = tglgt1__l3_2__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp13 = tmp12 ? tmp11 / tmp12 : 0;

    return tmp13;
}

/* L3_3 :: Slice0 L3 Bank0 Output Ready */
double
tglgt1__l3_3__l30_bank0_output_ready__read(const struct intel_perf *perf,
                                           const struct intel_perf_metric_set *metric_set,
                                           uint64_t *accumulator)
{
    /* RPN equation: C 7 READ C 6 READ FADD 4 FDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 6];
    double tmp2 = tmp0 + tmp1;
    double tmp3 = tmp2;
    double tmp4 = 4;
    double tmp5 = tmp4 ? tmp3 / tmp4 : 0;
    uint64_t tmp6 = tmp5 * 100;
    double tmp7 = tmp6;
    double tmp8 = tglgt1__l3_3__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp9 = tmp8 ? tmp7 / tmp8 : 0;

    return tmp9;
}

/* L3_4 :: Slice0 L3 Bank1 Output Ready */
double
tglgt1__l3_4__l30_bank1_output_ready__read(const struct intel_perf *perf,
                                           const struct intel_perf_metric_set *metric_set,
                                           uint64_t *accumulator)
{
    /* RPN equation: C 5 READ C 4 READ FADD 4 FDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 4];
    double tmp2 = tmp0 + tmp1;
    double tmp3 = tmp2;
    double tmp4 = 4;
    double tmp5 = tmp4 ? tmp3 / tmp4 : 0;
    uint64_t tmp6 = tmp5 * 100;
    double tmp7 = tmp6;
    double tmp8 = tglgt1__l3_4__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp9 = tmp8 ? tmp7 / tmp8 : 0;

    return tmp9;
}

/* EuActivity1 :: EU Send Pipe Active */
double
tglgt1__eu_activity1__eu_send_active__read(const struct intel_perf *perf,
                                           const struct intel_perf_metric_set *metric_set,
                                           uint64_t *accumulator)
{
    /* RPN equation: A 15 READ A 16 READ FADD A 17 READ FADD A 18 READ FADD $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 15];
    uint64_t tmp1 = accumulator[metric_set->a_offset + 16];
    double tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->a_offset + 17];
    double tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->a_offset + 18];
    double tmp6 = tmp4 + tmp5;
    uint64_t tmp7 = tmp6;
    uint64_t tmp8 = perf->devinfo.n_eus;
    uint64_t tmp9 = tmp8 ? tmp7 / tmp8 : 0;
    uint64_t tmp10 = tmp9 * 100;
    double tmp11 = tmp10;
    double tmp12 = tglgt1__eu_activity1__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp13 = tmp12 ? tmp11 / tmp12 : 0;

    return tmp13;
}

/* EuActivity7 :: EU AVG IPC Rate */
double
tglgt1__eu_activity7__eu_avg_ipc_rate__read(const struct intel_perf *perf,
                                            const struct intel_perf_metric_set *metric_set,
                                            uint64_t *accumulator)
{
    /* RPN equation: A 7 READ A 8 READ FADD A 9 READ FADD A 10 READ FADD  A 11 READ A 12 READ FADD A 13 READ FADD A 14 READ FADD  A 15 READ A 16 READ FADD A 17 READ FADD A 18 READ FADD FADD  A 7 READ A 8 READ FADD A 9 READ FADD A 10 READ FADD FSUB FDIV 1 FADD */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->a_offset + 8];
    double tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->a_offset + 9];
    double tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->a_offset + 10];
    double tmp6 = tmp4 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->a_offset + 11];
    uint64_t tmp8 = accumulator[metric_set->a_offset + 12];
    double tmp9 = tmp7 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->a_offset + 13];
    double tmp11 = tmp9 + tmp10;
    uint64_t tmp12 = accumulator[metric_set->a_offset + 14];
    double tmp13 = tmp11 + tmp12;
    uint64_t tmp14 = accumulator[metric_set->a_offset + 15];
    uint64_t tmp15 = accumulator[metric_set->a_offset + 16];
    double tmp16 = tmp14 + tmp15;
    uint64_t tmp17 = accumulator[metric_set->a_offset + 17];
    double tmp18 = tmp16 + tmp17;
    uint64_t tmp19 = accumulator[metric_set->a_offset + 18];
    double tmp20 = tmp18 + tmp19;
    double tmp21 = tmp13 + tmp20;
    uint64_t tmp22 = accumulator[metric_set->a_offset + 7];
    uint64_t tmp23 = accumulator[metric_set->a_offset + 8];
    double tmp24 = tmp22 + tmp23;
    uint64_t tmp25 = accumulator[metric_set->a_offset + 9];
    double tmp26 = tmp24 + tmp25;
    uint64_t tmp27 = accumulator[metric_set->a_offset + 10];
    double tmp28 = tmp26 + tmp27;
    double tmp29 = tmp21 - tmp28;
    double tmp30 = tmp6;
    double tmp31 = tmp29;
    double tmp32 = tmp31 ? tmp30 / tmp31 : 0;
    double tmp33 = tmp32 + 1;

    return tmp33;
}

/* L3_1 :: Slice0 L3 Bank0 Input Available */
double
tglgt2__l3_1__l30_bank0_input_available__read(const struct intel_perf *perf,
                                              const struct intel_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: C 7 READ C 6 READ FADD C 5 READ FADD C 4 READ FADD 4 FDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 6];
    double tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->c_offset + 5];
    double tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->c_offset + 4];
    double tmp6 = tmp4 + tmp5;
    double tmp7 = tmp6;
    double tmp8 = 4;
    double tmp9 = tmp8 ? tmp7 / tmp8 : 0;
    uint64_t tmp10 = tmp9 * 100;
    double tmp11 = tmp10;
    double tmp12 = tglgt2__l3_1__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp13 = tmp12 ? tmp11 / tmp12 : 0;

    return tmp13;
}

/* L3_1 :: Slice0 L3 Bank1 Input Available */
double
tglgt2__l3_1__l30_bank1_input_available__read(const struct intel_perf *perf,
                                              const struct intel_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: C 3 READ C 2 READ FADD C 1 READ FADD C 0 READ FADD 4 FDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 2];
    double tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->c_offset + 1];
    double tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->c_offset + 0];
    double tmp6 = tmp4 + tmp5;
    double tmp7 = tmp6;
    double tmp8 = 4;
    double tmp9 = tmp8 ? tmp7 / tmp8 : 0;
    uint64_t tmp10 = tmp9 * 100;
    double tmp11 = tmp10;
    double tmp12 = tglgt2__l3_1__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp13 = tmp12 ? tmp11 / tmp12 : 0;

    return tmp13;
}

/* Metric set HDCAndSF (DG1) :: Slice0 Dualsubslice5 Non-sampler Shader Access Stalled On L3 */
double
dg1__hdc_and_sf__non_sampler_shader05_access_stalled_on_l3__read(const struct intel_perf *perf,
                                                                 const struct intel_perf_metric_set *metric_set,
                                                                 uint64_t *accumulator)
{
    /* RPN equation: GPU_CLOCK 0 READ C 7 READ FSUB 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->gpu_clock_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 7];
    double tmp2 = tmp0 - tmp1;
    uint64_t tmp3 = tmp2 * 100;
    double tmp4 = tmp3;
    double tmp5 = dg1__hdc_and_sf__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

    return tmp6;
}

/* Render Metrics Basic - aggregation approximation :: XVE Thread Occupancy */
double
acmgt1__render_basic__xve_thread_occupancy__read(const struct intel_perf *perf,
                                                 const struct intel_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: 8 A 9 READ FMUL $VectorEngineThreadsCount FDIV $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 9];
    double tmp1 = 8 * tmp0;
    double tmp2 = tmp1;
    double tmp3 = perf->devinfo.eu_threads_count;
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;
    uint64_t tmp5 = tmp4;
    uint64_t tmp6 = perf->devinfo.n_eus;
    uint64_t tmp7 = tmp6 ? tmp5 / tmp6 : 0;
    uint64_t tmp8 = tmp7 * 100;
    double tmp9 = tmp8;
    double tmp10 = acmgt1__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp11 = tmp10 ? tmp9 / tmp10 : 0;

    return tmp11;
}

/* Render Metrics Basic - aggregation approximation :: SLM Bytes Read */
uint64_t
acmgt1__render_basic__slm_reads__max(const struct intel_perf *perf,
                                     const struct intel_perf_metric_set *metric_set,
                                     uint64_t *accumulator)
{
    /* RPN equation: $GpuCoreClocks $XeCoreTotalCount UMUL */
    uint64_t tmp0 = acmgt1__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator) * perf->devinfo.n_eu_sub_slices;

    return tmp0;
}

/* Render Metrics Basic - aggregation approximation :: SLM Writes */
uint64_t
acmgt1__render_basic__slm_writes__read(const struct intel_perf *perf,
                                       const struct intel_perf_metric_set *metric_set,
                                       uint64_t *accumulator)
{
    /* RPN equation: A 31 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 31];

    return tmp0;
}

/* Render Metrics Basic - aggregation approximation :: GTI Read Throughput */
uint64_t
acmgt1__render_basic__gti_read_throughput__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: 128  A 36 READ UMUL */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 36];
    uint64_t tmp1 = 128 * tmp0;

    return tmp1;
}

/* Render Metrics Basic - aggregation approximation :: GTI Read Throughput */
uint64_t
acmgt1__render_basic__gti_read_throughput__max(const struct intel_perf *perf,
                                               const struct intel_perf_metric_set *metric_set,
                                               uint64_t *accumulator)
{
    /* RPN equation: $GpuCoreClocks 512 UMUL */
    uint64_t tmp0 = acmgt1__render_basic__gpu_core_clocks__read(perf, metric_set, accumulator) * 512;

    return tmp0;
}

/* Render Metrics Basic - aggregation approximation :: GTI Write Throughput */
uint64_t
acmgt1__render_basic__gti_write_throughput__read(const struct intel_perf *perf,
                                                 const struct intel_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: C 6 READ C 7 READ UADD 128 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = tmp2 * 128;

    return tmp3;
}

/* Compute Metrics Basic :: XVE AVG IPC Rate */
double
acmgt1__compute_basic__xve_avg_ipc_rate__read(const struct intel_perf *perf,
                                              const struct intel_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: A 12 READ  A 9 READ  A 10 READ FADD  A 10 READ FSUB FDIV 1 FADD */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 12];
    uint64_t tmp1 = accumulator[metric_set->a_offset + 9];
    uint64_t tmp2 = accumulator[metric_set->a_offset + 10];
    double tmp3 = tmp1 + tmp2;
    uint64_t tmp4 = accumulator[metric_set->a_offset + 10];
    double tmp5 = tmp3 - tmp4;
    double tmp6 = tmp0;
    double tmp7 = tmp5;
    double tmp8 = tmp7 ? tmp6 / tmp7 : 0;
    double tmp9 = tmp8 + 1;

    return tmp9;
}

/* Compute Metrics Basic :: XVE Thread Occupancy */
double
acmgt1__compute_basic__xve_thread_occupancy__read(const struct intel_perf *perf,
                                                  const struct intel_perf_metric_set *metric_set,
                                                  uint64_t *accumulator)
{
    /* RPN equation: 8 A 15 READ FMUL $VectorEngineThreadsCount FDIV $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 15];
    double tmp1 = 8 * tmp0;
    double tmp2 = tmp1;
    double tmp3 = perf->devinfo.eu_threads_count;
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;
    uint64_t tmp5 = tmp4;
    uint64_t tmp6 = perf->devinfo.n_eus;
    uint64_t tmp7 = tmp6 ? tmp5 / tmp6 : 0;
    uint64_t tmp8 = tmp7 * 100;
    double tmp9 = tmp8;
    double tmp10 = acmgt1__compute_basic__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp11 = tmp10 ? tmp9 / tmp10 : 0;

    return tmp11;
}

/* Compute Metrics Basic :: GTI Write Throughput */
uint64_t
acmgt1__compute_basic__gti_write_throughput__read(const struct intel_perf *perf,
                                                  const struct intel_perf_metric_set *metric_set,
                                                  uint64_t *accumulator)
{
    /* RPN equation: C 7 READ C 6 READ UADD 128 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = tmp2 * 128;

    return tmp3;
}

/* ThreadsAndRast1 :: HS Threads Dispatched */
uint64_t
acmgt1__threads_and_rast1__hs_threads__read(const struct intel_perf *perf,
                                            const struct intel_perf_metric_set *metric_set,
                                            uint64_t *accumulator)
{
    /* RPN equation: B 7 READ B 6 READ UADD B 5 READ UADD B 4 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp6 = tmp4 + tmp5;

    return tmp6;
}

/* ThreadsAndRast1 :: DS Threads Dispatched */
uint64_t
acmgt1__threads_and_rast1__ds_threads__read(const struct intel_perf *perf,
                                            const struct intel_perf_metric_set *metric_set,
                                            uint64_t *accumulator)
{
    /* RPN equation: B 3 READ B 2 READ UADD B 1 READ UADD B 0 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp6 = tmp4 + tmp5;

    return tmp6;
}

/* ThreadsAndRast2 :: PS Threads Dispatched */
uint64_t
acmgt1__threads_and_rast2__ps_threads__read(const struct intel_perf *perf,
                                            const struct intel_perf_metric_set *metric_set,
                                            uint64_t *accumulator)
{
    /* RPN equation: B 0 READ B 1 READ UADD B 2 READ UADD B 3 READ UADD B 4 READ UADD B 5 READ UADD B 6 READ UADD B 7 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp6 = tmp4 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp8 = tmp6 + tmp7;
    uint64_t tmp9 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp10 = tmp8 + tmp9;
    uint64_t tmp11 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp12 = tmp10 + tmp11;
    uint64_t tmp13 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp14 = tmp12 + tmp13;

    return tmp14;
}

/* ThreadsAndRast3 :: GS Threads Dispatched */
uint64_t
acmgt1__threads_and_rast3__gs_threads__read(const struct intel_perf *perf,
                                            const struct intel_perf_metric_set *metric_set,
                                            uint64_t *accumulator)
{
    /* RPN equation: C 7 READ C 6 READ UADD C 5 READ UADD C 4 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp6 = tmp4 + tmp5;

    return tmp6;
}

/* ThreadsAndRast3 :: Early Hi-Depth Test Fails */
uint64_t
acmgt1__threads_and_rast3__hi_depth_test_fails__read(const struct intel_perf *perf,
                                                     const struct intel_perf_metric_set *metric_set,
                                                     uint64_t *accumulator)
{
    /* RPN equation: 4 2 UMUL C 3 READ 2 C 2 READ UMUL UADD 4 C 1 READ UMUL UADD 8 C 0 READ UMUL UADD 16 B 7 READ UMUL UADD 32 B 6 READ UMUL UADD 64 B 5 READ UMUL UADD 128 B 4 READ UMUL UADD 256 B 3 READ UMUL UADD 512 B 2 READ UMUL UADD 1024 B 1 READ UMUL UADD UMUL */
    uint64_t tmp0 = 4 * 2;
    uint64_t tmp1 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp2 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp3 = 2 * tmp2;
    uint64_t tmp4 = tmp1 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp6 = 4 * tmp5;
    uint64_t tmp7 = tmp4 + tmp6;
    uint64_t tmp8 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp9 = 8 * tmp8;
    uint64_t tmp10 = tmp7 + tmp9;
    uint64_t tmp11 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp12 = 16 * tmp11;
    uint64_t tmp13 = tmp10 + tmp12;
    uint64_t tmp14 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp15 = 32 * tmp14;
    uint64_t tmp16 = tmp13 + tmp15;
    uint64_t tmp17 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp18 = 64 * tmp17;
    uint64_t tmp19 = tmp16 + tmp18;
    uint64_t tmp20 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp21 = 128 * tmp20;
    uint64_t tmp22 = tmp19 + tmp21;
    uint64_t tmp23 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp24 = 256 * tmp23;
    uint64_t tmp25 = tmp22 + tmp24;
    uint64_t tmp26 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp27 = 512 * tmp26;
    uint64_t tmp28 = tmp25 + tmp27;
    uint64_t tmp29 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp30 = 1024 * tmp29;
    uint64_t tmp31 = tmp28 + tmp30;
    uint64_t tmp32 = tmp0 * tmp31;

    return tmp32;
}

/* ThreadsAndRast4 :: Early Depth Test Fails */
uint64_t
acmgt1__threads_and_rast4__early_depth_test_fails__read(const struct intel_perf *perf,
                                                        const struct intel_perf_metric_set *metric_set,
                                                        uint64_t *accumulator)
{
    /* RPN equation: 4 C 7 READ C 6 READ UADD 2 C 5 READ C 4 READ UADD UMUL UADD 4 C 3 READ C 2 READ UADD UMUL UADD 8 C 1 READ C 0 READ UADD UMUL UADD 16 B 7 READ B 6 READ UADD UMUL UADD UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp4 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp5 = tmp3 + tmp4;
    uint64_t tmp6 = 2 * tmp5;
    uint64_t tmp7 = tmp2 + tmp6;
    uint64_t tmp8 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp9 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp10 = tmp8 + tmp9;
    uint64_t tmp11 = 4 * tmp10;
    uint64_t tmp12 = tmp7 + tmp11;
    uint64_t tmp13 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp14 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp15 = tmp13 + tmp14;
    uint64_t tmp16 = 8 * tmp15;
    uint64_t tmp17 = tmp12 + tmp16;
    uint64_t tmp18 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp19 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp20 = tmp18 + tmp19;
    uint64_t tmp21 = 16 * tmp20;
    uint64_t tmp22 = tmp17 + tmp21;
    uint64_t tmp23 = 4 * tmp22;

    return tmp23;
}

/* AsyncCompute :: XVE Thread Occupancy */
double
acmgt1__async_compute__xve_thread_occupancy__read(const struct intel_perf *perf,
                                                  const struct intel_perf_metric_set *metric_set,
                                                  uint64_t *accumulator)
{
    /* RPN equation: 8 A 17 READ FMUL $VectorEngineThreadsCount FDIV $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 17];
    double tmp1 = 8 * tmp0;
    double tmp2 = tmp1;
    double tmp3 = perf->devinfo.eu_threads_count;
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;
    uint64_t tmp5 = tmp4;
    uint64_t tmp6 = perf->devinfo.n_eus;
    uint64_t tmp7 = tmp6 ? tmp5 / tmp6 : 0;
    uint64_t tmp8 = tmp7 * 100;
    double tmp9 = tmp8;
    double tmp10 = acmgt1__async_compute__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp11 = tmp10 ? tmp9 / tmp10 : 0;

    return tmp11;
}

/* ComputeOverview :: L3 BYTE READ */
uint64_t
acmgt1__compute_overview__l3_byte_read__read(const struct intel_perf *perf,
                                             const struct intel_perf_metric_set *metric_set,
                                             uint64_t *accumulator)
{
    /* RPN equation: B 7 READ B 6 READ UADD B 5 READ UADD B 4 READ UADD B 3 READ UADD B 2 READ UADD B 1 READ UADD B 0 READ UADD 64 UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp6 = tmp4 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp8 = tmp6 + tmp7;
    uint64_t tmp9 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp10 = tmp8 + tmp9;
    uint64_t tmp11 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp12 = tmp10 + tmp11;
    uint64_t tmp13 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp14 = tmp12 + tmp13;
    uint64_t tmp15 = tmp14 * 64;

    return tmp15;
}

/* ComputeOverview :: L3 BYTE READ */
uint64_t
acmgt1__compute_overview__l3_byte_read__max(const struct intel_perf *perf,
                                            const struct intel_perf_metric_set *metric_set,
                                            uint64_t *accumulator)
{
    /* RPN equation: 256 $SliceTotalCount UMUL $GpuCoreClocks UMUL */
    uint64_t tmp0 = 256 * perf->devinfo.n_eu_slices;
    uint64_t tmp1 = tmp0 * acmgt1__compute_overview__gpu_core_clocks__read(perf, metric_set, accumulator);

    return tmp1;
}

/* ComputeOverview :: L3 BYTE WRITE */
uint64_t
acmgt1__compute_overview__l3_byte_write__read(const struct intel_perf *perf,
                                              const struct intel_perf_metric_set *metric_set,
                                              uint64_t *accumulator)
{
    /* RPN equation: C 7 READ C 6 READ UADD C 5 READ UADD C 4 READ UADD C 3 READ UADD C 2 READ UADD C 1 READ UADD C 0 READ UADD 64 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp6 = tmp4 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp8 = tmp6 + tmp7;
    uint64_t tmp9 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp10 = tmp8 + tmp9;
    uint64_t tmp11 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp12 = tmp10 + tmp11;
    uint64_t tmp13 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp14 = tmp12 + tmp13;
    uint64_t tmp15 = tmp14 * 64;

    return tmp15;
}

/* ComputeOverview :: GPU MEMORY BYTE READ */
uint64_t
acmgt1__compute_overview__gpu_memory_byte_read__read(const struct intel_perf *perf,
                                                     const struct intel_perf_metric_set *metric_set,
                                                     uint64_t *accumulator)
{
    /* RPN equation: A 36 READ 128 UMUL */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 36];
    uint64_t tmp1 = tmp0 * 128;

    return tmp1;
}

/* ComputeOverview :: GPU MEMORY BYTE READ */
uint64_t
acmgt1__compute_overview__gpu_memory_byte_read__max(const struct intel_perf *perf,
                                                    const struct intel_perf_metric_set *metric_set,
                                                    uint64_t *accumulator)
{
    /* RPN equation: 64 $SliceTotalCount UMUL $GpuCoreClocks UMUL */
    uint64_t tmp0 = 64 * perf->devinfo.n_eu_slices;
    uint64_t tmp1 = tmp0 * acmgt1__compute_overview__gpu_core_clocks__read(perf, metric_set, accumulator);

    return tmp1;
}

/* ComputeOverview :: GPU MEMORY BYTE WRITE */
uint64_t
acmgt1__compute_overview__gpu_memory_byte_write__read(const struct intel_perf *perf,
                                                      const struct intel_perf_metric_set *metric_set,
                                                      uint64_t *accumulator)
{
    /* RPN equation: A 37 READ 128 UMUL */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 37];
    uint64_t tmp1 = tmp0 * 128;

    return tmp1;
}

/* ComputeOverview :: XVE BUSY */
uint64_t
acmgt1__compute_overview__xve_busy__read(const struct intel_perf *perf,
                                         const struct intel_perf_metric_set *metric_set,
                                         uint64_t *accumulator)
{
    /* RPN equation: A 9 READ 0 UGT */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 9];
    uint64_t tmp1 = tmp0 > 0;

    return tmp1;
}

/* ComputeOverview :: XVE BUSY */
uint64_t
acmgt1__compute_overview__xve_busy__max(const struct intel_perf *perf,
                                        const struct intel_perf_metric_set *metric_set,
                                        uint64_t *accumulator)
{
    /* RPN equation: 1 */

    return 1;
}

/* ComputeOverview :: XVE INST EXECUTED ALU0 ALL */
uint64_t
acmgt1__compute_overview__xve_inst_executed_alu0_all__max(const struct intel_perf *perf,
                                                          const struct intel_perf_metric_set *metric_set,
                                                          uint64_t *accumulator)
{
    /* RPN equation: $GpuCoreClocks $VectorEngineTotalCount UMUL */
    uint64_t tmp0 = acmgt1__compute_overview__gpu_core_clocks__read(perf, metric_set, accumulator) * perf->devinfo.n_eus;

    return tmp0;
}

/* ComputeOverview :: XVE INST EXECUTED ALU1 ALL */
uint64_t
acmgt1__compute_overview__xve_inst_executed_alu1_all__read(const struct intel_perf *perf,
                                                           const struct intel_perf_metric_set *metric_set,
                                                           uint64_t *accumulator)
{
    /* RPN equation: A 11 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 11];

    return tmp0;
}

/* ComputeOverview :: XVE INST EXECUTED XMX ALL */
uint64_t
acmgt1__compute_overview__xve_inst_executed_xmx_all__read(const struct intel_perf *perf,
                                                          const struct intel_perf_metric_set *metric_set,
                                                          uint64_t *accumulator)
{
    /* RPN equation: A 12 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 12];

    return tmp0;
}

/* ComputeOverview :: XVE INST EXECUTED SEND ALL */
uint64_t
acmgt1__compute_overview__xve_inst_executed_send_all__read(const struct intel_perf *perf,
                                                           const struct intel_perf_metric_set *metric_set,
                                                           uint64_t *accumulator)
{
    /* RPN equation: A 13 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 13];

    return tmp0;
}

/* ComputeOverview :: XVE INST EXECUTED CONTROL ALL */
uint64_t
acmgt1__compute_overview__xve_inst_executed_control_all__read(const struct intel_perf *perf,
                                                              const struct intel_perf_metric_set *metric_set,
                                                              uint64_t *accumulator)
{
    /* RPN equation: A 14 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 14];

    return tmp0;
}

/* L1ProfileReads :: LOAD STORE CACHE BYTE READ */
uint64_t
acmgt1__l1_profile_reads__xe_core0__load_store_cache_byte_read__read(const struct intel_perf *perf,
                                                                     const struct intel_perf_metric_set *metric_set,
                                                                     uint64_t *accumulator)
{
    /* RPN equation: 4 $XeCoreTotalCount UMUL B 0 READ 2 B 1 READ UMUL UADD 4 B 2 READ UMUL UADD 8 B 3 READ UMUL UADD 16 B 4 READ UMUL UADD 32 B 5 READ UMUL UADD 64 B 6 READ UMUL UADD UMUL $GtSlice0XeCore0 $GtSlice1XeCore0 UADD $GtSlice2XeCore0 UADD $GtSlice3XeCore0 UADD $GtSlice4XeCore0 UADD $GtSlice5XeCore0 UADD $GtSlice6XeCore0 UADD $GtSlice7XeCore0 UADD UDIV */
    uint64_t tmp0 = 4 * perf->devinfo.n_eu_sub_slices;
    uint64_t tmp1 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp2 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp3 = 2 * tmp2;
    uint64_t tmp4 = tmp1 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp6 = 4 * tmp5;
    uint64_t tmp7 = tmp4 + tmp6;
    uint64_t tmp8 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp9 = 8 * tmp8;
    uint64_t tmp10 = tmp7 + tmp9;
    uint64_t tmp11 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp12 = 16 * tmp11;
    uint64_t tmp13 = tmp10 + tmp12;
    uint64_t tmp14 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp15 = 32 * tmp14;
    uint64_t tmp16 = tmp13 + tmp15;
    uint64_t tmp17 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp18 = 64 * tmp17;
    uint64_t tmp19 = tmp16 + tmp18;
    uint64_t tmp20 = tmp0 * tmp19;
    uint64_t tmp21 = intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0) + intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0);
    uint64_t tmp22 = tmp21 + intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0);
    uint64_t tmp23 = tmp22 + intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0);
    uint64_t tmp24 = tmp23 + intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 0);
    uint64_t tmp25 = tmp24 + intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 0);
    uint64_t tmp26 = tmp25 + intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 0);
    uint64_t tmp27 = tmp26 + intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 0);
    uint64_t tmp28 = tmp20;
    uint64_t tmp29 = tmp27;
    uint64_t tmp30 = tmp29 ? tmp28 / tmp29 : 0;

    return tmp30;
}

/* L1ProfileReads :: LOAD STORE CACHE BYTE READ */
uint64_t
acmgt1__l1_profile_reads__xe_core0__load_store_cache_byte_read__max(const struct intel_perf *perf,
                                                                    const struct intel_perf_metric_set *metric_set,
                                                                    uint64_t *accumulator)
{
    /* RPN equation: 256  $XeCoreTotalCount UMUL $GpuCoreClocks UMUL */
    uint64_t tmp0 = 256 * perf->devinfo.n_eu_sub_slices;
    uint64_t tmp1 = tmp0 * acmgt1__l1_profile_reads__xe_core0__gpu_core_clocks__read(perf, metric_set, accumulator);

    return tmp1;
}

/* L1ProfileReads :: SLM BYTE READ */
uint64_t
acmgt1__l1_profile_reads__xe_core0__slm_byte_read__read(const struct intel_perf *perf,
                                                        const struct intel_perf_metric_set *metric_set,
                                                        uint64_t *accumulator)
{
    /* RPN equation: 4 $XeCoreTotalCount UMUL C 7 READ 2 C 6 READ UMUL UADD 4 C 5 READ UMUL UADD 8 C 4 READ UMUL UADD 16 C 3 READ UMUL UADD 32 C 2 READ UMUL UADD 64 C 1 READ UMUL UADD UMUL $GtSlice0XeCore0 $GtSlice1XeCore0 UADD $GtSlice2XeCore0 UADD $GtSlice3XeCore0 UADD $GtSlice4XeCore0 UADD $GtSlice5XeCore0 UADD $GtSlice6XeCore0 UADD $GtSlice7XeCore0 UADD UDIV */
    uint64_t tmp0 = 4 * perf->devinfo.n_eu_sub_slices;
    uint64_t tmp1 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp2 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp3 = 2 * tmp2;
    uint64_t tmp4 = tmp1 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp6 = 4 * tmp5;
    uint64_t tmp7 = tmp4 + tmp6;
    uint64_t tmp8 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp9 = 8 * tmp8;
    uint64_t tmp10 = tmp7 + tmp9;
    uint64_t tmp11 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp12 = 16 * tmp11;
    uint64_t tmp13 = tmp10 + tmp12;
    uint64_t tmp14 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp15 = 32 * tmp14;
    uint64_t tmp16 = tmp13 + tmp15;
    uint64_t tmp17 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp18 = 64 * tmp17;
    uint64_t tmp19 = tmp16 + tmp18;
    uint64_t tmp20 = tmp0 * tmp19;
    uint64_t tmp21 = intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0) + intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0);
    uint64_t tmp22 = tmp21 + intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0);
    uint64_t tmp23 = tmp22 + intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0);
    uint64_t tmp24 = tmp23 + intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 0);
    uint64_t tmp25 = tmp24 + intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 0);
    uint64_t tmp26 = tmp25 + intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 0);
    uint64_t tmp27 = tmp26 + intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 0);
    uint64_t tmp28 = tmp20;
    uint64_t tmp29 = tmp27;
    uint64_t tmp30 = tmp29 ? tmp28 / tmp29 : 0;

    return tmp30;
}

/* L1ProfileReads :: LOAD STORE CACHE BYTE READ */
uint64_t
acmgt1__l1_profile_reads__xe_core3__load_store_cache_byte_read__read(const struct intel_perf *perf,
                                                                     const struct intel_perf_metric_set *metric_set,
                                                                     uint64_t *accumulator)
{
    /* RPN equation: 4 $XeCoreTotalCount UMUL B 0 READ 2 B 1 READ UMUL UADD 4 B 2 READ UMUL UADD 8 B 3 READ UMUL UADD 16 B 4 READ UMUL UADD 32 B 5 READ UMUL UADD 64 B 6 READ UMUL UADD UMUL $GtSlice0XeCore3 $GtSlice1XeCore3 UADD $GtSlice2XeCore3 UADD $GtSlice3XeCore3 UADD $GtSlice4XeCore3 UADD $GtSlice5XeCore3 UADD $GtSlice6XeCore3 UADD $GtSlice7XeCore3 UADD UDIV */
    uint64_t tmp0 = 4 * perf->devinfo.n_eu_sub_slices;
    uint64_t tmp1 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp2 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp3 = 2 * tmp2;
    uint64_t tmp4 = tmp1 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp6 = 4 * tmp5;
    uint64_t tmp7 = tmp4 + tmp6;
    uint64_t tmp8 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp9 = 8 * tmp8;
    uint64_t tmp10 = tmp7 + tmp9;
    uint64_t tmp11 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp12 = 16 * tmp11;
    uint64_t tmp13 = tmp10 + tmp12;
    uint64_t tmp14 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp15 = 32 * tmp14;
    uint64_t tmp16 = tmp13 + tmp15;
    uint64_t tmp17 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp18 = 64 * tmp17;
    uint64_t tmp19 = tmp16 + tmp18;
    uint64_t tmp20 = tmp0 * tmp19;
    uint64_t tmp21 = intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3) + intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3);
    uint64_t tmp22 = tmp21 + intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3);
    uint64_t tmp23 = tmp22 + intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3);
    uint64_t tmp24 = tmp23 + intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 3);
    uint64_t tmp25 = tmp24 + intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 3);
    uint64_t tmp26 = tmp25 + intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 3);
    uint64_t tmp27 = tmp26 + intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 3);
    uint64_t tmp28 = tmp20;
    uint64_t tmp29 = tmp27;
    uint64_t tmp30 = tmp29 ? tmp28 / tmp29 : 0;

    return tmp30;
}

/* L1ProfileReads :: SLM BYTE READ */
uint64_t
acmgt1__l1_profile_reads__xe_core3__slm_byte_read__read(const struct intel_perf *perf,
                                                        const struct intel_perf_metric_set *metric_set,
                                                        uint64_t *accumulator)
{
    /* RPN equation: 4 $XeCoreTotalCount UMUL C 7 READ 2 C 6 READ UMUL UADD 4 C 5 READ UMUL UADD 8 C 4 READ UMUL UADD 16 C 3 READ UMUL UADD 32 C 2 READ UMUL UADD 64 C 1 READ UMUL UADD UMUL $GtSlice0XeCore3 $GtSlice1XeCore3 UADD $GtSlice2XeCore3 UADD $GtSlice3XeCore3 UADD $GtSlice4XeCore3 UADD $GtSlice5XeCore3 UADD $GtSlice6XeCore3 UADD $GtSlice7XeCore3 UADD UDIV */
    uint64_t tmp0 = 4 * perf->devinfo.n_eu_sub_slices;
    uint64_t tmp1 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp2 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp3 = 2 * tmp2;
    uint64_t tmp4 = tmp1 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp6 = 4 * tmp5;
    uint64_t tmp7 = tmp4 + tmp6;
    uint64_t tmp8 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp9 = 8 * tmp8;
    uint64_t tmp10 = tmp7 + tmp9;
    uint64_t tmp11 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp12 = 16 * tmp11;
    uint64_t tmp13 = tmp10 + tmp12;
    uint64_t tmp14 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp15 = 32 * tmp14;
    uint64_t tmp16 = tmp13 + tmp15;
    uint64_t tmp17 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp18 = 64 * tmp17;
    uint64_t tmp19 = tmp16 + tmp18;
    uint64_t tmp20 = tmp0 * tmp19;
    uint64_t tmp21 = intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3) + intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3);
    uint64_t tmp22 = tmp21 + intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3);
    uint64_t tmp23 = tmp22 + intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3);
    uint64_t tmp24 = tmp23 + intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 3);
    uint64_t tmp25 = tmp24 + intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 3);
    uint64_t tmp26 = tmp25 + intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 3);
    uint64_t tmp27 = tmp26 + intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 3);
    uint64_t tmp28 = tmp20;
    uint64_t tmp29 = tmp27;
    uint64_t tmp30 = tmp29 ? tmp28 / tmp29 : 0;

    return tmp30;
}

/* L1ProfileSlmBankConflicts :: SLM BANK CONFLICT COUNT */
uint64_t
acmgt1__l1_profile_slm_bank_conflicts__xe_core0__slm_bank_conflict_count__read(const struct intel_perf *perf,
                                                                               const struct intel_perf_metric_set *metric_set,
                                                                               uint64_t *accumulator)
{
    /* RPN equation: C 7 READ 2 C 6 READ UMUL UADD 4 C 5 READ UMUL UADD 8 C 4 READ UMUL UADD C 3 READ 2 C 2 READ UMUL UADD 4 C 1 READ UMUL UADD 8 C 0 READ UMUL UADD UADD B 7 READ 2 B 6 READ UMUL UADD 4 B 5 READ UMUL UADD 8 B 4 READ UMUL UADD UADD B 3 READ 2 B 2 READ UMUL UADD 4 B 1 READ UMUL UADD 8 B 0 READ UMUL UADD UADD $XeCoreTotalCount UMUL $GtSlice0XeCore0 $GtSlice1XeCore0 UADD $GtSlice2XeCore0 UADD $GtSlice3XeCore0 UADD $GtSlice4XeCore0 UADD $GtSlice5XeCore0 UADD $GtSlice6XeCore0 UADD $GtSlice7XeCore0 UADD UDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp2 = 2 * tmp1;
    uint64_t tmp3 = tmp0 + tmp2;
    uint64_t tmp4 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp5 = 4 * tmp4;
    uint64_t tmp6 = tmp3 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp8 = 8 * tmp7;
    uint64_t tmp9 = tmp6 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp11 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp12 = 2 * tmp11;
    uint64_t tmp13 = tmp10 + tmp12;
    uint64_t tmp14 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp15 = 4 * tmp14;
    uint64_t tmp16 = tmp13 + tmp15;
    uint64_t tmp17 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp18 = 8 * tmp17;
    uint64_t tmp19 = tmp16 + tmp18;
    uint64_t tmp20 = tmp9 + tmp19;
    uint64_t tmp21 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp22 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp23 = 2 * tmp22;
    uint64_t tmp24 = tmp21 + tmp23;
    uint64_t tmp25 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp26 = 4 * tmp25;
    uint64_t tmp27 = tmp24 + tmp26;
    uint64_t tmp28 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp29 = 8 * tmp28;
    uint64_t tmp30 = tmp27 + tmp29;
    uint64_t tmp31 = tmp20 + tmp30;
    uint64_t tmp32 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp33 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp34 = 2 * tmp33;
    uint64_t tmp35 = tmp32 + tmp34;
    uint64_t tmp36 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp37 = 4 * tmp36;
    uint64_t tmp38 = tmp35 + tmp37;
    uint64_t tmp39 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp40 = 8 * tmp39;
    uint64_t tmp41 = tmp38 + tmp40;
    uint64_t tmp42 = tmp31 + tmp41;
    uint64_t tmp43 = tmp42 * perf->devinfo.n_eu_sub_slices;
    uint64_t tmp44 = intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0) + intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0);
    uint64_t tmp45 = tmp44 + intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0);
    uint64_t tmp46 = tmp45 + intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0);
    uint64_t tmp47 = tmp46 + intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 0);
    uint64_t tmp48 = tmp47 + intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 0);
    uint64_t tmp49 = tmp48 + intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 0);
    uint64_t tmp50 = tmp49 + intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 0);
    uint64_t tmp51 = tmp43;
    uint64_t tmp52 = tmp50;
    uint64_t tmp53 = tmp52 ? tmp51 / tmp52 : 0;

    return tmp53;
}

/* L1ProfileSlmBankConflicts :: SLM BANK CONFLICT COUNT */
uint64_t
acmgt1__l1_profile_slm_bank_conflicts__xe_core3__slm_bank_conflict_count__read(const struct intel_perf *perf,
                                                                               const struct intel_perf_metric_set *metric_set,
                                                                               uint64_t *accumulator)
{
    /* RPN equation: C 7 READ 2 C 6 READ UMUL UADD 4 C 5 READ UMUL UADD 8 C 4 READ UMUL UADD C 3 READ 2 C 2 READ UMUL UADD 4 C 1 READ UMUL UADD 8 C 0 READ UMUL UADD UADD B 7 READ 2 B 6 READ UMUL UADD 4 B 5 READ UMUL UADD 8 B 4 READ UMUL UADD UADD B 3 READ 2 B 2 READ UMUL UADD 4 B 1 READ UMUL UADD 8 B 0 READ UMUL UADD UADD $XeCoreTotalCount UMUL $GtSlice0XeCore3 $GtSlice1XeCore3 UADD $GtSlice2XeCore3 UADD $GtSlice3XeCore3 UADD $GtSlice4XeCore3 UADD $GtSlice5XeCore3 UADD $GtSlice6XeCore3 UADD $GtSlice7XeCore3 UADD UDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp2 = 2 * tmp1;
    uint64_t tmp3 = tmp0 + tmp2;
    uint64_t tmp4 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp5 = 4 * tmp4;
    uint64_t tmp6 = tmp3 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp8 = 8 * tmp7;
    uint64_t tmp9 = tmp6 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp11 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp12 = 2 * tmp11;
    uint64_t tmp13 = tmp10 + tmp12;
    uint64_t tmp14 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp15 = 4 * tmp14;
    uint64_t tmp16 = tmp13 + tmp15;
    uint64_t tmp17 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp18 = 8 * tmp17;
    uint64_t tmp19 = tmp16 + tmp18;
    uint64_t tmp20 = tmp9 + tmp19;
    uint64_t tmp21 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp22 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp23 = 2 * tmp22;
    uint64_t tmp24 = tmp21 + tmp23;
    uint64_t tmp25 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp26 = 4 * tmp25;
    uint64_t tmp27 = tmp24 + tmp26;
    uint64_t tmp28 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp29 = 8 * tmp28;
    uint64_t tmp30 = tmp27 + tmp29;
    uint64_t tmp31 = tmp20 + tmp30;
    uint64_t tmp32 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp33 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp34 = 2 * tmp33;
    uint64_t tmp35 = tmp32 + tmp34;
    uint64_t tmp36 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp37 = 4 * tmp36;
    uint64_t tmp38 = tmp35 + tmp37;
    uint64_t tmp39 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp40 = 8 * tmp39;
    uint64_t tmp41 = tmp38 + tmp40;
    uint64_t tmp42 = tmp31 + tmp41;
    uint64_t tmp43 = tmp42 * perf->devinfo.n_eu_sub_slices;
    uint64_t tmp44 = intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3) + intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3);
    uint64_t tmp45 = tmp44 + intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3);
    uint64_t tmp46 = tmp45 + intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3);
    uint64_t tmp47 = tmp46 + intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 3);
    uint64_t tmp48 = tmp47 + intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 3);
    uint64_t tmp49 = tmp48 + intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 3);
    uint64_t tmp50 = tmp49 + intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 3);
    uint64_t tmp51 = tmp43;
    uint64_t tmp52 = tmp50;
    uint64_t tmp53 = tmp52 ? tmp51 / tmp52 : 0;

    return tmp53;
}

/* L1ProfileWrites :: LOAD STORE CACHE BYTE WRITE */
uint64_t
acmgt1__l1_profile_writes__xe_core0__load_store_cache_byte_write__max(const struct intel_perf *perf,
                                                                      const struct intel_perf_metric_set *metric_set,
                                                                      uint64_t *accumulator)
{
    /* RPN equation: 128  $XeCoreTotalCount UMUL $GpuCoreClocks UMUL */
    uint64_t tmp0 = 128 * perf->devinfo.n_eu_sub_slices;
    uint64_t tmp1 = tmp0 * acmgt1__l1_profile_writes__xe_core0__gpu_core_clocks__read(perf, metric_set, accumulator);

    return tmp1;
}

/* DataportReads :: DATAPORT BYTE READ */
uint64_t
acmgt1__dataport_reads__dataport_byte_read__read(const struct intel_perf *perf,
                                                 const struct intel_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: 64 2 UMUL B 4 READ B 0 READ UADD B 5 READ UADD B 1 READ UADD B 2 READ UADD B 6 READ UADD B 3 READ UADD B 7 READ UADD UMUL */
    uint64_t tmp0 = 64 * 2;
    uint64_t tmp1 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp2 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp3 = tmp1 + tmp2;
    uint64_t tmp4 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp5 = tmp3 + tmp4;
    uint64_t tmp6 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp7 = tmp5 + tmp6;
    uint64_t tmp8 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp9 = tmp7 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp11 = tmp9 + tmp10;
    uint64_t tmp12 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp13 = tmp11 + tmp12;
    uint64_t tmp14 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp15 = tmp13 + tmp14;
    uint64_t tmp16 = tmp0 * tmp15;

    return tmp16;
}

/* DataportReads :: DATAPORT BYTE READ */
uint64_t
acmgt1__dataport_reads__dataport_byte_read__max(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: 64  $XeCoreTotalCount UMUL $GpuCoreClocks UMUL */
    uint64_t tmp0 = 64 * perf->devinfo.n_eu_sub_slices;
    uint64_t tmp1 = tmp0 * acmgt1__dataport_reads__gpu_core_clocks__read(perf, metric_set, accumulator);

    return tmp1;
}

/* DataportReads :: HOST TO GPUMEM BYTE READ */
uint64_t
acmgt1__dataport_reads__host_to_gpumem_byte_read__max(const struct intel_perf *perf,
                                                      const struct intel_perf_metric_set *metric_set,
                                                      uint64_t *accumulator)
{
    /* RPN equation: 64 $GpuCoreClocks UMUL */
    uint64_t tmp0 = 64 * acmgt1__dataport_reads__gpu_core_clocks__read(perf, metric_set, accumulator);

    return tmp0;
}

/* DataportWrites :: DATAPORT BYTE WRITE */
uint64_t
acmgt1__dataport_writes__dataport_byte_write__read(const struct intel_perf *perf,
                                                   const struct intel_perf_metric_set *metric_set,
                                                   uint64_t *accumulator)
{
    /* RPN equation: 32 B 4 READ B 5 READ UADD B 6 READ UADD B 7 READ UADD UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp6 = tmp4 + tmp5;
    uint64_t tmp7 = 32 * tmp6;

    return tmp7;
}

/* DataportWrites :: DATAPORT BYTE WRITE */
uint64_t
acmgt1__dataport_writes__dataport_byte_write__max(const struct intel_perf *perf,
                                                  const struct intel_perf_metric_set *metric_set,
                                                  uint64_t *accumulator)
{
    /* RPN equation: 32 $XeCoreTotalCount UMUL $GpuCoreClocks UMUL */
    uint64_t tmp0 = 32 * perf->devinfo.n_eu_sub_slices;
    uint64_t tmp1 = tmp0 * acmgt1__dataport_writes__gpu_core_clocks__read(perf, metric_set, accumulator);

    return tmp1;
}

/* DataportWrites :: SYSMEM BYTE READ */
uint64_t
acmgt1__dataport_writes__sysmem_byte_read__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: 64  B 0 READ UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp1 = 64 * tmp0;

    return tmp1;
}

/* DataportWrites :: SYSMEM BYTE WRITE */
uint64_t
acmgt1__dataport_writes__sysmem_byte_write__read(const struct intel_perf *perf,
                                                 const struct intel_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: 64  B 1 READ UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp1 = 64 * tmp0;

    return tmp1;
}

/* Ext1 :: GPU MEMORY BYTE WRITE SQIDI0 */
uint64_t
acmgt1__ext1__gpu_memory_byte_write_sqidi0__read(const struct intel_perf *perf,
                                                 const struct intel_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: C 7 READ 128 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp1 = tmp0 * 128;

    return tmp1;
}

/* Ext1 :: GPU MEMORY READ SQIDI1 */
uint64_t
acmgt1__ext1__gpu_memory_read_sqidi1__read(const struct intel_perf *perf,
                                           const struct intel_perf_metric_set *metric_set,
                                           uint64_t *accumulator)
{
    /* RPN equation: B 3 READ B 2 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp2 = tmp0 + tmp1;

    return tmp2;
}

/* Ext1 :: GPU MEMORY READ */
uint64_t
acmgt1__ext1__gpu_memory_read__read(const struct intel_perf *perf,
                                    const struct intel_perf_metric_set *metric_set,
                                    uint64_t *accumulator)
{
    /* RPN equation: $GPU_MEMORY_READ_SQIDI0 $GPU_MEMORY_READ_SQIDI1 UADD */
    uint64_t tmp0 = acmgt1__ext1__gpu_memory_read_sqidi0__read(perf, metric_set, accumulator) + acmgt1__ext1__gpu_memory_read_sqidi1__read(perf, metric_set, accumulator);

    return tmp0;
}

/* Ext1 :: GPU MEMORY BYTE READ SQIDI0 */
uint64_t
acmgt1__ext1__gpu_memory_byte_read_sqidi0__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: C 5 READ 128 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp1 = tmp0 * 128;

    return tmp1;
}

/* Ext1 :: GPU MEMORY BYTE READ SQIDI1 */
uint64_t
acmgt1__ext1__gpu_memory_byte_read_sqidi1__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: C 4 READ 128 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp1 = tmp0 * 128;

    return tmp1;
}

/* Ext1 :: GPU MEMORY BYTE READ */
uint64_t
acmgt1__ext1__gpu_memory_byte_read__read(const struct intel_perf *perf,
                                         const struct intel_perf_metric_set *metric_set,
                                         uint64_t *accumulator)
{
    /* RPN equation: C 5 READ  C 4 READ UADD 128 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = tmp2 * 128;

    return tmp3;
}

/* Ext1 :: GPU MEMORY BYTE READ BW SQIDI0 */
double
acmgt1__ext1__gpu_memory_byte_read_bw_sqidi0__read(const struct intel_perf *perf,
                                                   const struct intel_perf_metric_set *metric_set,
                                                   uint64_t *accumulator)
{
    /* RPN equation: $GPU_MEMORY_BYTE_READ_SQIDI0 $GpuTime FDIV */
    double tmp0 = acmgt1__ext1__gpu_memory_byte_read_sqidi0__read(perf, metric_set, accumulator);
    double tmp1 = acmgt1__ext1__gpu_time__read(perf, metric_set, accumulator);
    double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

    return tmp2;
}

/* Ext1 :: GPU MEMORY BYTE READ BW SQIDI1 */
double
acmgt1__ext1__gpu_memory_byte_read_bw_sqidi1__read(const struct intel_perf *perf,
                                                   const struct intel_perf_metric_set *metric_set,
                                                   uint64_t *accumulator)
{
    /* RPN equation: $GPU_MEMORY_BYTE_READ_SQIDI1 $GpuTime FDIV */
    double tmp0 = acmgt1__ext1__gpu_memory_byte_read_sqidi1__read(perf, metric_set, accumulator);
    double tmp1 = acmgt1__ext1__gpu_time__read(perf, metric_set, accumulator);
    double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

    return tmp2;
}

/* Ext1 :: GPU MEMORY BYTE WRITE BW SQIDI0 */
double
acmgt1__ext1__gpu_memory_byte_write_bw_sqidi0__read(const struct intel_perf *perf,
                                                    const struct intel_perf_metric_set *metric_set,
                                                    uint64_t *accumulator)
{
    /* RPN equation: $GPU_MEMORY_BYTE_WRITE_SQIDI0 $GpuTime FDIV */
    double tmp0 = acmgt1__ext1__gpu_memory_byte_write_sqidi0__read(perf, metric_set, accumulator);
    double tmp1 = acmgt1__ext1__gpu_time__read(perf, metric_set, accumulator);
    double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

    return tmp2;
}

/* Ext1 :: GPU MEMORY BYTE WRITE BW SQIDI1 */
double
acmgt1__ext1__gpu_memory_byte_write_bw_sqidi1__read(const struct intel_perf *perf,
                                                    const struct intel_perf_metric_set *metric_set,
                                                    uint64_t *accumulator)
{
    /* RPN equation: $GPU_MEMORY_BYTE_WRITE_SQIDI1 $GpuTime FDIV */
    double tmp0 = acmgt1__ext1__gpu_memory_byte_write_sqidi1__read(perf, metric_set, accumulator);
    double tmp1 = acmgt1__ext1__gpu_time__read(perf, metric_set, accumulator);
    double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

    return tmp2;
}

/* Ext1 :: GPU MEMORY BYTE READ BW */
double
acmgt1__ext1__gpu_memory_byte_read_bw__read(const struct intel_perf *perf,
                                            const struct intel_perf_metric_set *metric_set,
                                            uint64_t *accumulator)
{
    /* RPN equation: $GPU_MEMORY_BYTE_READ $GpuTime FDIV */
    double tmp0 = acmgt1__ext1__gpu_memory_byte_read__read(perf, metric_set, accumulator);
    double tmp1 = acmgt1__ext1__gpu_time__read(perf, metric_set, accumulator);
    double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

    return tmp2;
}

/* Ext1 :: GPU MEMORY BYTE WRITE BW */
double
acmgt1__ext1__gpu_memory_byte_write_bw__read(const struct intel_perf *perf,
                                             const struct intel_perf_metric_set *metric_set,
                                             uint64_t *accumulator)
{
    /* RPN equation: $GPU_MEMORY_BYTE_WRITE $GpuTime FDIV */
    double tmp0 = acmgt1__ext1__gpu_memory_byte_write__read(perf, metric_set, accumulator);
    double tmp1 = acmgt1__ext1__gpu_time__read(perf, metric_set, accumulator);
    double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

    return tmp2;
}

/* Ext2 :: GPU MEMORY 32B TRANSACTION READ SQIDI0 */
uint64_t
acmgt1__ext2__gpu_memory_32_b_transaction_read_sqidi0__read(const struct intel_perf *perf,
                                                            const struct intel_perf_metric_set *metric_set,
                                                            uint64_t *accumulator)
{
    /* RPN equation: 2 C 1 READ UMUL C 0 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp1 = 2 * tmp0;
    uint64_t tmp2 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp3 = tmp1 + tmp2;

    return tmp3;
}

/* Ext2 :: GPU MEMORY 64B TRANSACTION READ SQIDI0 */
uint64_t
acmgt1__ext2__gpu_memory_64_b_transaction_read_sqidi0__read(const struct intel_perf *perf,
                                                            const struct intel_perf_metric_set *metric_set,
                                                            uint64_t *accumulator)
{
    /* RPN equation: 2 B 3 READ UMUL B 2 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp1 = 2 * tmp0;
    uint64_t tmp2 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp3 = tmp1 + tmp2;

    return tmp3;
}

/* Ext2 :: GPU MEMORY 32B TRANSACTION READ SQIDI1 */
uint64_t
acmgt1__ext2__gpu_memory_32_b_transaction_read_sqidi1__read(const struct intel_perf *perf,
                                                            const struct intel_perf_metric_set *metric_set,
                                                            uint64_t *accumulator)
{
    /* RPN equation: 2 B 5 READ UMUL B 4 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp1 = 2 * tmp0;
    uint64_t tmp2 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp3 = tmp1 + tmp2;

    return tmp3;
}

/* Ext2 :: GPU MEMORY 64B TRANSACTION READ SQIDI1 */
uint64_t
acmgt1__ext2__gpu_memory_64_b_transaction_read_sqidi1__read(const struct intel_perf *perf,
                                                            const struct intel_perf_metric_set *metric_set,
                                                            uint64_t *accumulator)
{
    /* RPN equation: 2 B 7 READ UMUL B 6 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp1 = 2 * tmp0;
    uint64_t tmp2 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp3 = tmp1 + tmp2;

    return tmp3;
}

/* Ext21 :: LOAD STORE CACHE ACCESS XECORE1 */
uint64_t
acmgt1__ext21__load_store_cache_access_xecore1__read(const struct intel_perf *perf,
                                                     const struct intel_perf_metric_set *metric_set,
                                                     uint64_t *accumulator)
{
    /* RPN equation: C 3 READ C 2 READ UADD C 1 READ UADD C 0 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp6 = tmp4 + tmp5;

    return tmp6;
}

/* Ext23 :: LOAD STORE CACHE HIT XECORE0 */
uint64_t
acmgt1__ext23__load_store_cache_hit_xecore0__read(const struct intel_perf *perf,
                                                  const struct intel_perf_metric_set *metric_set,
                                                  uint64_t *accumulator)
{
    /* RPN equation: B 0 READ B 1 READ UADD B 2 READ UADD B 3 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp6 = tmp4 + tmp5;

    return tmp6;
}

/* Ext23 :: LOAD STORE CACHE HIT XECORE1 */
uint64_t
acmgt1__ext23__load_store_cache_hit_xecore1__read(const struct intel_perf *perf,
                                                  const struct intel_perf_metric_set *metric_set,
                                                  uint64_t *accumulator)
{
    /* RPN equation: B 4 READ B 5 READ UADD B 6 READ UADD B 7 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp6 = tmp4 + tmp5;

    return tmp6;
}

/* Ext27 :: LOAD STORE CACHE L3 READ XECORE4 */
uint64_t
acmgt1__ext27__load_store_cache_l3_read_xecore4__read(const struct intel_perf *perf,
                                                      const struct intel_perf_metric_set *metric_set,
                                                      uint64_t *accumulator)
{
    /* RPN equation: B 7 READ B 6 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp2 = tmp0 + tmp1;

    return tmp2;
}

/* Ext27 :: LOAD STORE CACHE L3 READ XECORE5 */
uint64_t
acmgt1__ext27__load_store_cache_l3_read_xecore5__read(const struct intel_perf *perf,
                                                      const struct intel_perf_metric_set *metric_set,
                                                      uint64_t *accumulator)
{
    /* RPN equation: B 5 READ B 4 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp2 = tmp0 + tmp1;

    return tmp2;
}

/* Ext27 :: LOAD STORE CACHE L3 READ XECORE7 */
uint64_t
acmgt1__ext27__load_store_cache_l3_read_xecore7__read(const struct intel_perf *perf,
                                                      const struct intel_perf_metric_set *metric_set,
                                                      uint64_t *accumulator)
{
    /* RPN equation: B 1 READ B 0 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp2 = tmp0 + tmp1;

    return tmp2;
}

/* Ext79 :: DATAPORT BYTE READ XECORE0 */
uint64_t
acmgt1__ext79__dataport_byte_read_xecore0__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: B 0 READ B 1 READ UADD B 2 READ UADD B 3 READ UADD 64 UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp6 = tmp4 + tmp5;
    uint64_t tmp7 = tmp6 * 64;

    return tmp7;
}

/* Ext79 :: DATAPORT BYTE READ XECORE1 */
uint64_t
acmgt1__ext79__dataport_byte_read_xecore1__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: B 4 READ B 5 READ UADD B 6 READ UADD B 7 READ UADD 64 UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp6 = tmp4 + tmp5;
    uint64_t tmp7 = tmp6 * 64;

    return tmp7;
}

/* Ext83 :: DATAPORT BYTE WRITE XECORE0 */
uint64_t
acmgt1__ext83__dataport_byte_write_xecore0__read(const struct intel_perf *perf,
                                                 const struct intel_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: 32  C 7 READ UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp1 = 32 * tmp0;

    return tmp1;
}

/* Ext83 :: DATAPORT BYTE WRITE XECORE1 */
uint64_t
acmgt1__ext83__dataport_byte_write_xecore1__read(const struct intel_perf *perf,
                                                 const struct intel_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: 32  C 6 READ UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp1 = 32 * tmp0;

    return tmp1;
}

/* Ext83 :: DATAPORT BYTE WRITE XECORE2 */
uint64_t
acmgt1__ext83__dataport_byte_write_xecore2__read(const struct intel_perf *perf,
                                                 const struct intel_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: 32  C 5 READ UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp1 = 32 * tmp0;

    return tmp1;
}

/* Ext83 :: DATAPORT BYTE WRITE XECORE3 */
uint64_t
acmgt1__ext83__dataport_byte_write_xecore3__read(const struct intel_perf *perf,
                                                 const struct intel_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: 32  C 4 READ UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp1 = 32 * tmp0;

    return tmp1;
}

/* Ext83 :: DATAPORT BYTE WRITE XECORE4 */
uint64_t
acmgt1__ext83__dataport_byte_write_xecore4__read(const struct intel_perf *perf,
                                                 const struct intel_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: 32  C 3 READ UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp1 = 32 * tmp0;

    return tmp1;
}

/* Ext83 :: DATAPORT BYTE WRITE XECORE5 */
uint64_t
acmgt1__ext83__dataport_byte_write_xecore5__read(const struct intel_perf *perf,
                                                 const struct intel_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: 32  C 2 READ UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp1 = 32 * tmp0;

    return tmp1;
}

/* Ext83 :: DATAPORT BYTE WRITE XECORE6 */
uint64_t
acmgt1__ext83__dataport_byte_write_xecore6__read(const struct intel_perf *perf,
                                                 const struct intel_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: 32  C 1 READ UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp1 = 32 * tmp0;

    return tmp1;
}

/* Ext83 :: DATAPORT BYTE WRITE XECORE7 */
uint64_t
acmgt1__ext83__dataport_byte_write_xecore7__read(const struct intel_perf *perf,
                                                 const struct intel_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: 32  C 0 READ UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp1 = 32 * tmp0;

    return tmp1;
}

/* Ext93 :: XVE DATAPORT REGISTER RESPONSE COUNT XECORE0 */
uint64_t
acmgt1__ext93__xve_dataport_register_response_count_xecore0__read(const struct intel_perf *perf,
                                                                  const struct intel_perf_metric_set *metric_set,
                                                                  uint64_t *accumulator)
{
    /* RPN equation: B 0 READ B 1 READ UADD B 2 READ UADD B 3 READ UADD 2 UDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp6 = tmp4 + tmp5;
    uint64_t tmp7 = tmp6;
    uint64_t tmp8 = 2;
    uint64_t tmp9 = tmp8 ? tmp7 / tmp8 : 0;

    return tmp9;
}

/* Ext93 :: XVE DATAPORT REGISTER RESPONSE COUNT XECORE1 */
double
acmgt1__ext93__xve_dataport_register_response_count_xecore1__read(const struct intel_perf *perf,
                                                                  const struct intel_perf_metric_set *metric_set,
                                                                  uint64_t *accumulator)
{
    /* RPN equation: B 4 READ B 5 READ FADD B 6 READ FADD B 7 READ FADD 2 FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 5];
    double tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->b_offset + 6];
    double tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->b_offset + 7];
    double tmp6 = tmp4 + tmp5;
    double tmp7 = tmp6;
    double tmp8 = 2;
    double tmp9 = tmp8 ? tmp7 / tmp8 : 0;

    return tmp9;
}

/* Ext94 :: XVE DATAPORT REGISTER RESPONSE COUNT XECORE2 */
double
acmgt1__ext94__xve_dataport_register_response_count_xecore2__read(const struct intel_perf *perf,
                                                                  const struct intel_perf_metric_set *metric_set,
                                                                  uint64_t *accumulator)
{
    /* RPN equation: B 0 READ B 1 READ FADD B 2 READ FADD B 3 READ FADD 2 FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 1];
    double tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->b_offset + 2];
    double tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->b_offset + 3];
    double tmp6 = tmp4 + tmp5;
    double tmp7 = tmp6;
    double tmp8 = 2;
    double tmp9 = tmp8 ? tmp7 / tmp8 : 0;

    return tmp9;
}

/* Ext124 :: CLIPPER INPUT VERTEX SLICE0 */
uint64_t
acmgt1__ext124__clipper_input_vertex_slice0__read(const struct intel_perf *perf,
                                                  const struct intel_perf_metric_set *metric_set,
                                                  uint64_t *accumulator)
{
    /* RPN equation: B 2 READ B 3 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp2 = tmp0 + tmp1;

    return tmp2;
}

/* Ext124 :: CLIPPER INPUT VERTEX SLICE1 */
uint64_t
acmgt1__ext124__clipper_input_vertex_slice1__read(const struct intel_perf *perf,
                                                  const struct intel_perf_metric_set *metric_set,
                                                  uint64_t *accumulator)
{
    /* RPN equation: B 4 READ B 5 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp2 = tmp0 + tmp1;

    return tmp2;
}

/* Ext128 :: URB READ SLICE0 */
uint64_t
acmgt1__ext128__urb_read_slice0__read(const struct intel_perf *perf,
                                      const struct intel_perf_metric_set *metric_set,
                                      uint64_t *accumulator)
{
    /* RPN equation: C 7 READ C 6 READ UADD C 5 READ UADD C 4 READ UADD C 3 READ UADD C 2 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp6 = tmp4 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp8 = tmp6 + tmp7;
    uint64_t tmp9 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp10 = tmp8 + tmp9;

    return tmp10;
}

/* Ext128 :: URB WRITE SLICE0 */
uint64_t
acmgt1__ext128__urb_write_slice0__read(const struct intel_perf *perf,
                                       const struct intel_perf_metric_set *metric_set,
                                       uint64_t *accumulator)
{
    /* RPN equation: C 1 READ C 0 READ UADD B 7 READ UADD B 6 READ UADD B 5 READ UADD B 4 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp6 = tmp4 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp8 = tmp6 + tmp7;
    uint64_t tmp9 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp10 = tmp8 + tmp9;

    return tmp10;
}

/* Ext130 :: EARLY DEPTH STENCIL TEST FAIL NP ZPIPE0 */
uint64_t
acmgt1__ext130__early_depth_stencil_test_fail_np_zpipe0__read(const struct intel_perf *perf,
                                                              const struct intel_perf_metric_set *metric_set,
                                                              uint64_t *accumulator)
{
    /* RPN equation: C 7 READ 2 C 6 READ UMUL UADD 4 C 5 READ UMUL UADD 8 C 4 READ UMUL UADD 16 C 3 READ UMUL UADD B 0 READ 2 B 1 READ UMUL UADD 4 B 2 READ UMUL UADD 8 B 3 READ UMUL UADD 16 B 4 READ UMUL UADD USUB */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp2 = 2 * tmp1;
    uint64_t tmp3 = tmp0 + tmp2;
    uint64_t tmp4 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp5 = 4 * tmp4;
    uint64_t tmp6 = tmp3 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp8 = 8 * tmp7;
    uint64_t tmp9 = tmp6 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp11 = 16 * tmp10;
    uint64_t tmp12 = tmp9 + tmp11;
    uint64_t tmp13 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp14 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp15 = 2 * tmp14;
    uint64_t tmp16 = tmp13 + tmp15;
    uint64_t tmp17 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp18 = 4 * tmp17;
    uint64_t tmp19 = tmp16 + tmp18;
    uint64_t tmp20 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp21 = 8 * tmp20;
    uint64_t tmp22 = tmp19 + tmp21;
    uint64_t tmp23 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp24 = 16 * tmp23;
    uint64_t tmp25 = tmp22 + tmp24;
    uint64_t tmp26 = tmp12 - tmp25;

    return tmp26;
}

/* Ext130 :: EARLY DEPTH STENCIL TEST FAIL P ZPIPE0 */
uint64_t
acmgt1__ext130__early_depth_stencil_test_fail_p_zpipe0__read(const struct intel_perf *perf,
                                                             const struct intel_perf_metric_set *metric_set,
                                                             uint64_t *accumulator)
{
    /* RPN equation: B 0 READ 2 B 1 READ UMUL UADD 4 B 2 READ UMUL UADD 8 B 3 READ UMUL UADD 16 B 4 READ UMUL UADD */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp2 = 2 * tmp1;
    uint64_t tmp3 = tmp0 + tmp2;
    uint64_t tmp4 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp5 = 4 * tmp4;
    uint64_t tmp6 = tmp3 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp8 = 8 * tmp7;
    uint64_t tmp9 = tmp6 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp11 = 16 * tmp10;
    uint64_t tmp12 = tmp9 + tmp11;

    return tmp12;
}

/* Ext134 :: HIZ DEPTH TEST AMBIG NP ZPIPE0 */
uint64_t
acmgt1__ext134__hiz_depth_test_ambig_np_zpipe0__read(const struct intel_perf *perf,
                                                     const struct intel_perf_metric_set *metric_set,
                                                     uint64_t *accumulator)
{
    /* RPN equation: B 0 READ 2 B 1 READ UMUL UADD 4 B 2 READ UMUL UADD 8 B 3 READ UMUL UADD 16 B 4 READ UMUL UADD 32 B 5 READ UMUL UADD 64 B 6 READ UMUL UADD 128 B 7 READ UMUL UADD 256 C 1 READ UMUL UADD 512 C 3 READ UMUL UADD 1024 C 5 READ UMUL UADD */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp2 = 2 * tmp1;
    uint64_t tmp3 = tmp0 + tmp2;
    uint64_t tmp4 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp5 = 4 * tmp4;
    uint64_t tmp6 = tmp3 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp8 = 8 * tmp7;
    uint64_t tmp9 = tmp6 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp11 = 16 * tmp10;
    uint64_t tmp12 = tmp9 + tmp11;
    uint64_t tmp13 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp14 = 32 * tmp13;
    uint64_t tmp15 = tmp12 + tmp14;
    uint64_t tmp16 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp17 = 64 * tmp16;
    uint64_t tmp18 = tmp15 + tmp17;
    uint64_t tmp19 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp20 = 128 * tmp19;
    uint64_t tmp21 = tmp18 + tmp20;
    uint64_t tmp22 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp23 = 256 * tmp22;
    uint64_t tmp24 = tmp21 + tmp23;
    uint64_t tmp25 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp26 = 512 * tmp25;
    uint64_t tmp27 = tmp24 + tmp26;
    uint64_t tmp28 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp29 = 1024 * tmp28;
    uint64_t tmp30 = tmp27 + tmp29;

    return tmp30;
}

/* Ext159 :: RT CLOSEST HIT THREAD RAY DISPATCH XECORE0 */
uint64_t
acmgt1__ext159__rt_closest_hit_thread_ray_dispatch_xecore0__read(const struct intel_perf *perf,
                                                                 const struct intel_perf_metric_set *metric_set,
                                                                 uint64_t *accumulator)
{
    /* RPN equation: B 0 READ B 1 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp2 = tmp0 + tmp1;

    return tmp2;
}

/* Ext159 :: RT CLOSEST HIT THREAD RAY DISPATCH XECORE3 */
uint64_t
acmgt1__ext159__rt_closest_hit_thread_ray_dispatch_xecore3__read(const struct intel_perf *perf,
                                                                 const struct intel_perf_metric_set *metric_set,
                                                                 uint64_t *accumulator)
{
    /* RPN equation: B 6 READ B 7 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp2 = tmp0 + tmp1;

    return tmp2;
}

/* Ext195 :: XVE MULTIPLE PIPE ACTIVE XECORE0 XVE0 */
double
acmgt1__ext195__xve_multiple_pipe_active_xecore0_xve0__read(const struct intel_perf *perf,
                                                            const struct intel_perf_metric_set *metric_set,
                                                            uint64_t *accumulator)
{
    /* RPN equation: B 3 READ B 5 READ USUB 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp2 = tmp0 - tmp1;
    uint64_t tmp3 = tmp2 * 100;
    double tmp4 = tmp3;
    double tmp5 = acmgt1__ext195__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

    return tmp6;
}

/* Ext195 :: XVE MULTIPLE PIPE ACTIVE XECORE1 XVE0 */
double
acmgt1__ext195__xve_multiple_pipe_active_xecore1_xve0__read(const struct intel_perf *perf,
                                                            const struct intel_perf_metric_set *metric_set,
                                                            uint64_t *accumulator)
{
    /* RPN equation: B 2 READ B 4 READ USUB 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp2 = tmp0 - tmp1;
    uint64_t tmp3 = tmp2 * 100;
    double tmp4 = tmp3;
    double tmp5 = acmgt1__ext195__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

    return tmp6;
}

/* Ext195 :: XVE MULTIPLE PIPE ACTIVE XECORE2 XVE0 */
double
acmgt1__ext195__xve_multiple_pipe_active_xecore2_xve0__read(const struct intel_perf *perf,
                                                            const struct intel_perf_metric_set *metric_set,
                                                            uint64_t *accumulator)
{
    /* RPN equation: B 1 READ B 7 READ USUB 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp2 = tmp0 - tmp1;
    uint64_t tmp3 = tmp2 * 100;
    double tmp4 = tmp3;
    double tmp5 = acmgt1__ext195__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

    return tmp6;
}

/* Ext195 :: XVE MULTIPLE PIPE ACTIVE XECORE3 XVE0 */
double
acmgt1__ext195__xve_multiple_pipe_active_xecore3_xve0__read(const struct intel_perf *perf,
                                                            const struct intel_perf_metric_set *metric_set,
                                                            uint64_t *accumulator)
{
    /* RPN equation: B 0 READ B 6 READ USUB 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp2 = tmp0 - tmp1;
    uint64_t tmp3 = tmp2 * 100;
    double tmp4 = tmp3;
    double tmp5 = acmgt1__ext195__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

    return tmp6;
}

/* Ext196 :: XVE MULTIPLE PIPE ACTIVE XECORE4 XVE0 */
double
acmgt1__ext196__xve_multiple_pipe_active_xecore4_xve0__read(const struct intel_perf *perf,
                                                            const struct intel_perf_metric_set *metric_set,
                                                            uint64_t *accumulator)
{
    /* RPN equation: B 3 READ B 7 READ USUB 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp2 = tmp0 - tmp1;
    uint64_t tmp3 = tmp2 * 100;
    double tmp4 = tmp3;
    double tmp5 = acmgt1__ext196__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

    return tmp6;
}

/* Ext196 :: XVE MULTIPLE PIPE ACTIVE XECORE5 XVE0 */
double
acmgt1__ext196__xve_multiple_pipe_active_xecore5_xve0__read(const struct intel_perf *perf,
                                                            const struct intel_perf_metric_set *metric_set,
                                                            uint64_t *accumulator)
{
    /* RPN equation: B 2 READ B 6 READ USUB 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp2 = tmp0 - tmp1;
    uint64_t tmp3 = tmp2 * 100;
    double tmp4 = tmp3;
    double tmp5 = acmgt1__ext196__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

    return tmp6;
}

/* Ext196 :: XVE MULTIPLE PIPE ACTIVE XECORE6 XVE0 */
double
acmgt1__ext196__xve_multiple_pipe_active_xecore6_xve0__read(const struct intel_perf *perf,
                                                            const struct intel_perf_metric_set *metric_set,
                                                            uint64_t *accumulator)
{
    /* RPN equation: B 1 READ B 5 READ USUB 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp2 = tmp0 - tmp1;
    uint64_t tmp3 = tmp2 * 100;
    double tmp4 = tmp3;
    double tmp5 = acmgt1__ext196__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

    return tmp6;
}

/* Ext196 :: XVE MULTIPLE PIPE ACTIVE XECORE7 XVE0 */
double
acmgt1__ext196__xve_multiple_pipe_active_xecore7_xve0__read(const struct intel_perf *perf,
                                                            const struct intel_perf_metric_set *metric_set,
                                                            uint64_t *accumulator)
{
    /* RPN equation: B 0 READ B 4 READ USUB 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp2 = tmp0 - tmp1;
    uint64_t tmp3 = tmp2 * 100;
    double tmp4 = tmp3;
    double tmp5 = acmgt1__ext196__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp6 = tmp5 ? tmp4 / tmp5 : 0;

    return tmp6;
}

/* Ext225 :: PIXEL 2x2 LIT POST RASTERIZER EARLY DEPTH SLICE0 */
uint64_t
acmgt1__ext225__pixel_2x2_lit_post_rasterizer_early_depth_slice0__read(const struct intel_perf *perf,
                                                                       const struct intel_perf_metric_set *metric_set,
                                                                       uint64_t *accumulator)
{
    /* RPN equation: 1 B 0 READ UMUL 2 B 1 READ UMUL UADD 4 B 2 READ UMUL UADD 8 B 3 READ UMUL UADD 16 B 4 READ UMUL UADD 32 B 5 READ UMUL UADD 64 B 6 READ UMUL UADD 128 B 7 READ UMUL UADD 256 C 1 READ UMUL UADD 512 C 3 READ UMUL UADD 1024 C 5 READ UMUL UADD */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp1 = 1 * tmp0;
    uint64_t tmp2 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp3 = 2 * tmp2;
    uint64_t tmp4 = tmp1 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp6 = 4 * tmp5;
    uint64_t tmp7 = tmp4 + tmp6;
    uint64_t tmp8 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp9 = 8 * tmp8;
    uint64_t tmp10 = tmp7 + tmp9;
    uint64_t tmp11 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp12 = 16 * tmp11;
    uint64_t tmp13 = tmp10 + tmp12;
    uint64_t tmp14 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp15 = 32 * tmp14;
    uint64_t tmp16 = tmp13 + tmp15;
    uint64_t tmp17 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp18 = 64 * tmp17;
    uint64_t tmp19 = tmp16 + tmp18;
    uint64_t tmp20 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp21 = 128 * tmp20;
    uint64_t tmp22 = tmp19 + tmp21;
    uint64_t tmp23 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp24 = 256 * tmp23;
    uint64_t tmp25 = tmp22 + tmp24;
    uint64_t tmp26 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp27 = 512 * tmp26;
    uint64_t tmp28 = tmp25 + tmp27;
    uint64_t tmp29 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp30 = 1024 * tmp29;
    uint64_t tmp31 = tmp28 + tmp30;

    return tmp31;
}

/* Ext229 :: SLM BANK CONFLICT COUNT XECORE0 */
uint64_t
acmgt1__ext229__slm_bank_conflict_count_xecore0__read(const struct intel_perf *perf,
                                                      const struct intel_perf_metric_set *metric_set,
                                                      uint64_t *accumulator)
{
    /* RPN equation: C 7 READ 2 C 6 READ UMUL UADD 4 C 5 READ UMUL UADD 8 C 4 READ UMUL UADD C 3 READ UADD 2 C 2 READ UMUL UADD 4 C 1 READ UMUL UADD 8 C 0 READ UMUL UADD B 7 READ UADD 2 B 6 READ UMUL UADD 4 B 5 READ UMUL UADD 8 B 4 READ UMUL UADD B 3 READ UADD 2 B 2 READ UMUL UADD 4 B 1 READ UMUL UADD 8 B 0 READ UMUL UADD */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp2 = 2 * tmp1;
    uint64_t tmp3 = tmp0 + tmp2;
    uint64_t tmp4 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp5 = 4 * tmp4;
    uint64_t tmp6 = tmp3 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp8 = 8 * tmp7;
    uint64_t tmp9 = tmp6 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp11 = tmp9 + tmp10;
    uint64_t tmp12 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp13 = 2 * tmp12;
    uint64_t tmp14 = tmp11 + tmp13;
    uint64_t tmp15 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp16 = 4 * tmp15;
    uint64_t tmp17 = tmp14 + tmp16;
    uint64_t tmp18 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp19 = 8 * tmp18;
    uint64_t tmp20 = tmp17 + tmp19;
    uint64_t tmp21 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp22 = tmp20 + tmp21;
    uint64_t tmp23 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp24 = 2 * tmp23;
    uint64_t tmp25 = tmp22 + tmp24;
    uint64_t tmp26 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp27 = 4 * tmp26;
    uint64_t tmp28 = tmp25 + tmp27;
    uint64_t tmp29 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp30 = 8 * tmp29;
    uint64_t tmp31 = tmp28 + tmp30;
    uint64_t tmp32 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp33 = tmp31 + tmp32;
    uint64_t tmp34 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp35 = 2 * tmp34;
    uint64_t tmp36 = tmp33 + tmp35;
    uint64_t tmp37 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp38 = 4 * tmp37;
    uint64_t tmp39 = tmp36 + tmp38;
    uint64_t tmp40 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp41 = 8 * tmp40;
    uint64_t tmp42 = tmp39 + tmp41;

    return tmp42;
}

/* Ext508 :: SLM BYTE READ BANK0 XECORE0 */
uint64_t
acmgt1__ext508__slm_byte_read_bank0_xecore0__read(const struct intel_perf *perf,
                                                  const struct intel_perf_metric_set *metric_set,
                                                  uint64_t *accumulator)
{
    /* RPN equation: C 7 READ 2 C 6 READ UMUL UADD 4 C 5 READ UMUL UADD 8 C 4 READ UMUL UADD 16 C 3 READ UMUL UADD 32 C 2 READ UMUL UADD 64 C 1 READ UMUL UADD */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp2 = 2 * tmp1;
    uint64_t tmp3 = tmp0 + tmp2;
    uint64_t tmp4 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp5 = 4 * tmp4;
    uint64_t tmp6 = tmp3 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp8 = 8 * tmp7;
    uint64_t tmp9 = tmp6 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp11 = 16 * tmp10;
    uint64_t tmp12 = tmp9 + tmp11;
    uint64_t tmp13 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp14 = 32 * tmp13;
    uint64_t tmp15 = tmp12 + tmp14;
    uint64_t tmp16 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp17 = 64 * tmp16;
    uint64_t tmp18 = tmp15 + tmp17;

    return tmp18;
}

/* Ext508 :: LOAD STORE CACHE BYTE READ BANK0 XECORE0 */
uint64_t
acmgt1__ext508__load_store_cache_byte_read_bank0_xecore0__read(const struct intel_perf *perf,
                                                               const struct intel_perf_metric_set *metric_set,
                                                               uint64_t *accumulator)
{
    /* RPN equation: B 0 READ 2 B 1 READ UMUL UADD 4 B 2 READ UMUL UADD 8 B 3 READ UMUL UADD 16 B 4 READ UMUL UADD 32 B 5 READ UMUL UADD 64 B 6 READ UMUL UADD */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp2 = 2 * tmp1;
    uint64_t tmp3 = tmp0 + tmp2;
    uint64_t tmp4 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp5 = 4 * tmp4;
    uint64_t tmp6 = tmp3 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp8 = 8 * tmp7;
    uint64_t tmp9 = tmp6 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp11 = 16 * tmp10;
    uint64_t tmp12 = tmp9 + tmp11;
    uint64_t tmp13 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp14 = 32 * tmp13;
    uint64_t tmp15 = tmp12 + tmp14;
    uint64_t tmp16 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp17 = 64 * tmp16;
    uint64_t tmp18 = tmp15 + tmp17;

    return tmp18;
}

/* Ext1000 :: XVE THREADS OCCUPANCY ALL */
double
acmgt1__ext1000__xve_threads_occupancy_all__read(const struct intel_perf *perf,
                                                 const struct intel_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: 8 A 14 READ FMUL $VectorEngineThreadsCount FDIV $EuCoresTotalCount UDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 14];
    double tmp1 = 8 * tmp0;
    double tmp2 = tmp1;
    double tmp3 = perf->devinfo.eu_threads_count;
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;
    uint64_t tmp5 = tmp4;
    uint64_t tmp6 = perf->devinfo.n_eus;
    uint64_t tmp7 = tmp6 ? tmp5 / tmp6 : 0;
    uint64_t tmp8 = tmp7 * 100;
    double tmp9 = tmp8;
    double tmp10 = acmgt1__ext1000__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp11 = tmp10 ? tmp9 / tmp10 : 0;

    return tmp11;
}

/* Ext1000 :: XVE INST EXECUTED ALU0 ALL */
uint64_t
acmgt1__ext1000__xve_inst_executed_alu0_all__read(const struct intel_perf *perf,
                                                  const struct intel_perf_metric_set *metric_set,
                                                  uint64_t *accumulator)
{
    /* RPN equation: A 9 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 9];

    return tmp0;
}

/* Ext1000 :: XVE ACTIVE CYCLES */
uint64_t
acmgt1__ext1000__xve_active_cycles__read(const struct intel_perf *perf,
                                         const struct intel_perf_metric_set *metric_set,
                                         uint64_t *accumulator)
{
    /* RPN equation: A 7 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 7];

    return tmp0;
}

/* Ext1000 :: XVE STALL CYCLES */
uint64_t
acmgt1__ext1000__xve_stall_cycles__read(const struct intel_perf *perf,
                                        const struct intel_perf_metric_set *metric_set,
                                        uint64_t *accumulator)
{
    /* RPN equation: A 8 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 8];

    return tmp0;
}

/* Ext1000 :: XVE THREADS OCCUPANCY CYCLES ALL */
uint64_t
acmgt1__ext1000__xve_threads_occupancy_cycles_all__read(const struct intel_perf *perf,
                                                        const struct intel_perf_metric_set *metric_set,
                                                        uint64_t *accumulator)
{
    /* RPN equation: 8  A 14 READ UMUL */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 14];
    uint64_t tmp1 = 8 * tmp0;

    return tmp1;
}

/* Ext1000 :: XVE THREADS OCCUPANCY CYCLES ALL */
uint64_t
acmgt1__ext1000__xve_threads_occupancy_cycles_all__max(const struct intel_perf *perf,
                                                       const struct intel_perf_metric_set *metric_set,
                                                       uint64_t *accumulator)
{
    /* RPN equation: $GpuCoreClocks $VectorEngineTotalCount $VectorEngineThreadsCount UMUL UMUL */
    uint64_t tmp0 = perf->devinfo.n_eus * perf->devinfo.eu_threads_count;
    uint64_t tmp1 = acmgt1__ext1000__gpu_core_clocks__read(perf, metric_set, accumulator) * tmp0;

    return tmp1;
}

/* Ext1000 :: XVE PIPE ALU0 AND ALU1 ACTIVE CYCLES */
uint64_t
acmgt1__ext1000__xve_pipe_alu0_and_alu1_active_cycles__read(const struct intel_perf *perf,
                                                            const struct intel_perf_metric_set *metric_set,
                                                            uint64_t *accumulator)
{
    /* RPN equation: A 16 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 16];

    return tmp0;
}

/* Ext1001 :: XVE INST EXECUTED ALU1 CS */
uint64_t
acmgt1__ext1001__xve_inst_executed_alu1_cs__read(const struct intel_perf *perf,
                                                 const struct intel_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: A 17 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 17];

    return tmp0;
}

/* Ext1001 :: XVE INST EXECUTED ALU1 ASYNC CS */
uint64_t
acmgt1__ext1001__xve_inst_executed_alu1_async_cs__read(const struct intel_perf *perf,
                                                       const struct intel_perf_metric_set *metric_set,
                                                       uint64_t *accumulator)
{
    /* RPN equation: A 18 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 18];

    return tmp0;
}

/* Render Metrics Basic - aggregation approximation :: GTI Write Throughput */
uint64_t
acmgt2__render_basic__gti_write_throughput__read(const struct intel_perf *perf,
                                                 const struct intel_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: 128  A 37 READ UMUL */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 37];
    uint64_t tmp1 = 128 * tmp0;

    return tmp1;
}

/* Dataport29 :: DATAPORT BYTE WRITE XECORE8 */
uint64_t
acmgt2__dataport29__dataport_byte_write_xecore8__read(const struct intel_perf *perf,
                                                      const struct intel_perf_metric_set *metric_set,
                                                      uint64_t *accumulator)
{
    /* RPN equation: 32  B 7 READ UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp1 = 32 * tmp0;

    return tmp1;
}

/* Dataport29 :: DATAPORT BYTE WRITE XECORE9 */
uint64_t
acmgt2__dataport29__dataport_byte_write_xecore9__read(const struct intel_perf *perf,
                                                      const struct intel_perf_metric_set *metric_set,
                                                      uint64_t *accumulator)
{
    /* RPN equation: 32  B 6 READ UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp1 = 32 * tmp0;

    return tmp1;
}

/* Dataport29 :: DATAPORT BYTE WRITE XECORE10 */
uint64_t
acmgt2__dataport29__dataport_byte_write_xecore10__read(const struct intel_perf *perf,
                                                       const struct intel_perf_metric_set *metric_set,
                                                       uint64_t *accumulator)
{
    /* RPN equation: 32  B 5 READ UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp1 = 32 * tmp0;

    return tmp1;
}

/* Dataport29 :: DATAPORT BYTE WRITE XECORE11 */
uint64_t
acmgt2__dataport29__dataport_byte_write_xecore11__read(const struct intel_perf *perf,
                                                       const struct intel_perf_metric_set *metric_set,
                                                       uint64_t *accumulator)
{
    /* RPN equation: 32  B 4 READ UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp1 = 32 * tmp0;

    return tmp1;
}

/* Dataport29 :: DATAPORT BYTE WRITE XECORE12 */
uint64_t
acmgt2__dataport29__dataport_byte_write_xecore12__read(const struct intel_perf *perf,
                                                       const struct intel_perf_metric_set *metric_set,
                                                       uint64_t *accumulator)
{
    /* RPN equation: 32  B 3 READ UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp1 = 32 * tmp0;

    return tmp1;
}

/* Dataport29 :: DATAPORT BYTE WRITE XECORE13 */
uint64_t
acmgt2__dataport29__dataport_byte_write_xecore13__read(const struct intel_perf *perf,
                                                       const struct intel_perf_metric_set *metric_set,
                                                       uint64_t *accumulator)
{
    /* RPN equation: 32  B 2 READ UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp1 = 32 * tmp0;

    return tmp1;
}

/* Dataport29 :: DATAPORT BYTE WRITE XECORE14 */
uint64_t
acmgt2__dataport29__dataport_byte_write_xecore14__read(const struct intel_perf *perf,
                                                       const struct intel_perf_metric_set *metric_set,
                                                       uint64_t *accumulator)
{
    /* RPN equation: 32  B 1 READ UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp1 = 32 * tmp0;

    return tmp1;
}

/* Dataport29 :: DATAPORT BYTE WRITE XECORE15 */
uint64_t
acmgt2__dataport29__dataport_byte_write_xecore15__read(const struct intel_perf *perf,
                                                       const struct intel_perf_metric_set *metric_set,
                                                       uint64_t *accumulator)
{
    /* RPN equation: 32  B 0 READ UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp1 = 32 * tmp0;

    return tmp1;
}

/* FrontEnd1 :: COMMAND PARSER COMPUTE ENGINE BUSY */
double
acmgt2__front_end1__command_parser_compute_engine_busy__read(const struct intel_perf *perf,
                                                             const struct intel_perf_metric_set *metric_set,
                                                             uint64_t *accumulator)
{
    /* RPN equation: C 7 READ  C 6 READ FADD 2 FDIV $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 6];
    double tmp2 = tmp0 + tmp1;
    double tmp3 = tmp2;
    double tmp4 = 2;
    double tmp5 = tmp4 ? tmp3 / tmp4 : 0;
    double tmp6 = tmp5;
    double tmp7 = acmgt2__front_end1__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp8 = tmp7 ? tmp6 / tmp7 : 0;

    return tmp8;
}

/* FrontEnd1 :: COMMAND PARSER VIDEO ENGINE BUSY */
double
acmgt2__front_end1__command_parser_video_engine_busy__read(const struct intel_perf *perf,
                                                           const struct intel_perf_metric_set *metric_set,
                                                           uint64_t *accumulator)
{
    /* RPN equation: C 3 READ  C 2 READ FADD 2 FDIV $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 2];
    double tmp2 = tmp0 + tmp1;
    double tmp3 = tmp2;
    double tmp4 = 2;
    double tmp5 = tmp4 ? tmp3 / tmp4 : 0;
    double tmp6 = tmp5;
    double tmp7 = acmgt2__front_end1__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp8 = tmp7 ? tmp6 / tmp7 : 0;

    return tmp8;
}

/* FrontEnd1 :: COMMAND PARSER VIDEO ENHANCEMENT ENGINE BUSY */
double
acmgt2__front_end1__command_parser_video_enhancement_engine_busy__read(const struct intel_perf *perf,
                                                                       const struct intel_perf_metric_set *metric_set,
                                                                       uint64_t *accumulator)
{
    /* RPN equation: C 1 READ  C 0 READ FADD 2 FDIV $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 0];
    double tmp2 = tmp0 + tmp1;
    double tmp3 = tmp2;
    double tmp4 = 2;
    double tmp5 = tmp4 ? tmp3 / tmp4 : 0;
    double tmp6 = tmp5;
    double tmp7 = acmgt2__front_end1__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp8 = tmp7 ? tmp6 / tmp7 : 0;

    return tmp8;
}

/* Memory1 :: GPU MEMORY BYTE WRITE SQIDI0 */
uint64_t
acmgt2__memory1__gpu_memory_byte_write_sqidi0__read(const struct intel_perf *perf,
                                                    const struct intel_perf_metric_set *metric_set,
                                                    uint64_t *accumulator)
{
    /* RPN equation: C 3 READ 128 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp1 = tmp0 * 128;

    return tmp1;
}

/* Memory1 :: GPU MEMORY BYTE WRITE SQIDI2 */
uint64_t
acmgt2__memory1__gpu_memory_byte_write_sqidi2__read(const struct intel_perf *perf,
                                                    const struct intel_perf_metric_set *metric_set,
                                                    uint64_t *accumulator)
{
    /* RPN equation: C 1 READ 128 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp1 = tmp0 * 128;

    return tmp1;
}

/* Memory1 :: GPU MEMORY BYTE WRITE SQIDI3 */
uint64_t
acmgt2__memory1__gpu_memory_byte_write_sqidi3__read(const struct intel_perf *perf,
                                                    const struct intel_perf_metric_set *metric_set,
                                                    uint64_t *accumulator)
{
    /* RPN equation: C 0 READ 128 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp1 = tmp0 * 128;

    return tmp1;
}

/* Memory1 :: GPU MEMORY BYTE WRITE BW SQIDI0 */
double
acmgt2__memory1__gpu_memory_byte_write_bw_sqidi0__read(const struct intel_perf *perf,
                                                       const struct intel_perf_metric_set *metric_set,
                                                       uint64_t *accumulator)
{
    /* RPN equation: $GPU_MEMORY_BYTE_WRITE_SQIDI0 $GpuTime FDIV */
    double tmp0 = acmgt2__memory1__gpu_memory_byte_write_sqidi0__read(perf, metric_set, accumulator);
    double tmp1 = acmgt2__memory1__gpu_time__read(perf, metric_set, accumulator);
    double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

    return tmp2;
}

/* Memory1 :: GPU MEMORY BYTE WRITE BW SQIDI1 */
double
acmgt2__memory1__gpu_memory_byte_write_bw_sqidi1__read(const struct intel_perf *perf,
                                                       const struct intel_perf_metric_set *metric_set,
                                                       uint64_t *accumulator)
{
    /* RPN equation: $GPU_MEMORY_BYTE_WRITE_SQIDI1 $GpuTime FDIV */
    double tmp0 = acmgt2__memory1__gpu_memory_byte_write_sqidi1__read(perf, metric_set, accumulator);
    double tmp1 = acmgt2__memory1__gpu_time__read(perf, metric_set, accumulator);
    double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

    return tmp2;
}

/* Memory1 :: GPU MEMORY BYTE WRITE BW SQIDI2 */
double
acmgt2__memory1__gpu_memory_byte_write_bw_sqidi2__read(const struct intel_perf *perf,
                                                       const struct intel_perf_metric_set *metric_set,
                                                       uint64_t *accumulator)
{
    /* RPN equation: $GPU_MEMORY_BYTE_WRITE_SQIDI2 $GpuTime FDIV */
    double tmp0 = acmgt2__memory1__gpu_memory_byte_write_sqidi2__read(perf, metric_set, accumulator);
    double tmp1 = acmgt2__memory1__gpu_time__read(perf, metric_set, accumulator);
    double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

    return tmp2;
}

/* Memory1 :: GPU MEMORY BYTE WRITE BW SQIDI3 */
double
acmgt2__memory1__gpu_memory_byte_write_bw_sqidi3__read(const struct intel_perf *perf,
                                                       const struct intel_perf_metric_set *metric_set,
                                                       uint64_t *accumulator)
{
    /* RPN equation: $GPU_MEMORY_BYTE_WRITE_SQIDI3 $GpuTime FDIV */
    double tmp0 = acmgt2__memory1__gpu_memory_byte_write_sqidi3__read(perf, metric_set, accumulator);
    double tmp1 = acmgt2__memory1__gpu_time__read(perf, metric_set, accumulator);
    double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

    return tmp2;
}

/* Memory1 :: GPU MEMORY BYTE READ */
uint64_t
acmgt2__memory1__gpu_memory_byte_read__read(const struct intel_perf *perf,
                                            const struct intel_perf_metric_set *metric_set,
                                            uint64_t *accumulator)
{
    /* RPN equation: C 7 READ  C 6 READ UADD  C 5 READ UADD  C 4 READ UADD 128 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp6 = tmp4 + tmp5;
    uint64_t tmp7 = tmp6 * 128;

    return tmp7;
}

/* Memory1 :: GPU MEMORY BYTE WRITE */
uint64_t
acmgt2__memory1__gpu_memory_byte_write__read(const struct intel_perf *perf,
                                             const struct intel_perf_metric_set *metric_set,
                                             uint64_t *accumulator)
{
    /* RPN equation: C 3 READ  C 2 READ UADD  C 1 READ UADD  C 0 READ UADD 128 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp6 = tmp4 + tmp5;
    uint64_t tmp7 = tmp6 * 128;

    return tmp7;
}

/* Memory1 :: GPU MEMORY BYTE READ BW */
double
acmgt2__memory1__gpu_memory_byte_read_bw__read(const struct intel_perf *perf,
                                               const struct intel_perf_metric_set *metric_set,
                                               uint64_t *accumulator)
{
    /* RPN equation: $GPU_MEMORY_BYTE_READ $GpuTime FDIV */
    double tmp0 = acmgt2__memory1__gpu_memory_byte_read__read(perf, metric_set, accumulator);
    double tmp1 = acmgt2__memory1__gpu_time__read(perf, metric_set, accumulator);
    double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

    return tmp2;
}

/* Memory1 :: GPU MEMORY BYTE WRITE BW */
double
acmgt2__memory1__gpu_memory_byte_write_bw__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: $GPU_MEMORY_BYTE_WRITE $GpuTime FDIV */
    double tmp0 = acmgt2__memory1__gpu_memory_byte_write__read(perf, metric_set, accumulator);
    double tmp1 = acmgt2__memory1__gpu_time__read(perf, metric_set, accumulator);
    double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

    return tmp2;
}

/* Memory2 :: GPU MEMORY READ */
uint64_t
acmgt2__memory2__gpu_memory_read__read(const struct intel_perf *perf,
                                       const struct intel_perf_metric_set *metric_set,
                                       uint64_t *accumulator)
{
    /* RPN equation: $GPU_MEMORY_READ_SQIDI0 $GPU_MEMORY_READ_SQIDI1 UADD $GPU_MEMORY_READ_SQIDI2 UADD $GPU_MEMORY_READ_SQIDI3 UADD */
    uint64_t tmp0 = acmgt2__memory2__gpu_memory_read_sqidi0__read(perf, metric_set, accumulator) + acmgt2__memory2__gpu_memory_read_sqidi1__read(perf, metric_set, accumulator);
    uint64_t tmp1 = tmp0 + acmgt2__memory2__gpu_memory_read_sqidi2__read(perf, metric_set, accumulator);
    uint64_t tmp2 = tmp1 + acmgt2__memory2__gpu_memory_read_sqidi3__read(perf, metric_set, accumulator);

    return tmp2;
}

/* Memory4 :: GPU MEMORY 32B TRANSACTION READ SQIDI0 */
uint64_t
acmgt2__memory4__gpu_memory_32_b_transaction_read_sqidi0__read(const struct intel_perf *perf,
                                                               const struct intel_perf_metric_set *metric_set,
                                                               uint64_t *accumulator)
{
    /* RPN equation: 2 C 7 READ UMUL C 6 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp1 = 2 * tmp0;
    uint64_t tmp2 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp3 = tmp1 + tmp2;

    return tmp3;
}

/* Memory4 :: GPU MEMORY 32B TRANSACTION READ SQIDI1 */
uint64_t
acmgt2__memory4__gpu_memory_32_b_transaction_read_sqidi1__read(const struct intel_perf *perf,
                                                               const struct intel_perf_metric_set *metric_set,
                                                               uint64_t *accumulator)
{
    /* RPN equation: 2 C 5 READ UMUL C 4 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp1 = 2 * tmp0;
    uint64_t tmp2 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp3 = tmp1 + tmp2;

    return tmp3;
}

/* Memory4 :: GPU MEMORY 32B TRANSACTION READ SQIDI2 */
uint64_t
acmgt2__memory4__gpu_memory_32_b_transaction_read_sqidi2__read(const struct intel_perf *perf,
                                                               const struct intel_perf_metric_set *metric_set,
                                                               uint64_t *accumulator)
{
    /* RPN equation: 2 C 3 READ UMUL C 2 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp1 = 2 * tmp0;
    uint64_t tmp2 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp3 = tmp1 + tmp2;

    return tmp3;
}

/* Memory4 :: GPU MEMORY 64B TRANSACTION READ SQIDI3 */
uint64_t
acmgt2__memory4__gpu_memory_64_b_transaction_read_sqidi3__read(const struct intel_perf *perf,
                                                               const struct intel_perf_metric_set *metric_set,
                                                               uint64_t *accumulator)
{
    /* RPN equation: 2 B 1 READ UMUL B 0 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp1 = 2 * tmp0;
    uint64_t tmp2 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp3 = tmp1 + tmp2;

    return tmp3;
}

/* Memory6 :: GPU MEMORY ACTIVE */
double
acmgt2__memory6__gpu_memory_active__read(const struct intel_perf *perf,
                                         const struct intel_perf_metric_set *metric_set,
                                         uint64_t *accumulator)
{
    /* RPN equation: C 7 READ  C 6 READ FADD  C 5 READ FADD  C 4 READ FADD 8 FDIV $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 6];
    double tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->c_offset + 5];
    double tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->c_offset + 4];
    double tmp6 = tmp4 + tmp5;
    double tmp7 = tmp6;
    double tmp8 = 8;
    double tmp9 = tmp8 ? tmp7 / tmp8 : 0;
    double tmp10 = tmp9;
    double tmp11 = acmgt2__memory6__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp12 = tmp11 ? tmp10 / tmp11 : 0;

    return tmp12;
}

/* Memory6 :: GPU MEMORY REQUEST QUEUE FULL */
double
acmgt2__memory6__gpu_memory_request_queue_full__read(const struct intel_perf *perf,
                                                     const struct intel_perf_metric_set *metric_set,
                                                     uint64_t *accumulator)
{
    /* RPN equation: C 3 READ  C 2 READ FADD  C 1 READ FADD  C 0 READ FADD 4 FDIV $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 2];
    double tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->c_offset + 1];
    double tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->c_offset + 0];
    double tmp6 = tmp4 + tmp5;
    double tmp7 = tmp6;
    double tmp8 = 4;
    double tmp9 = tmp8 ? tmp7 / tmp8 : 0;
    double tmp10 = tmp9;
    double tmp11 = acmgt2__memory6__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp12 = tmp11 ? tmp10 / tmp11 : 0;

    return tmp12;
}

/* VectorEngine35 :: XVE THREADS OCCUPANCY CYCLES ALL */
uint64_t
acmgt2__vector_engine35__xve_threads_occupancy_cycles_all__read(const struct intel_perf *perf,
                                                                const struct intel_perf_metric_set *metric_set,
                                                                uint64_t *accumulator)
{
    /* RPN equation: 8  A 9 READ UMUL */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 9];
    uint64_t tmp1 = 8 * tmp0;

    return tmp1;
}

/* Ext1 :: GPU MEMORY READ */
uint64_t
acmgt3__ext1__gpu_memory_read__read(const struct intel_perf *perf,
                                    const struct intel_perf_metric_set *metric_set,
                                    uint64_t *accumulator)
{
    /* RPN equation: $GPU_MEMORY_READ_SQIDI2 $GPU_MEMORY_READ_SQIDI0 UADD $GPU_MEMORY_READ_SQIDI1 UADD $GPU_MEMORY_READ_SQIDI3 UADD $GPU_MEMORY_READ_SQIDI4 UADD $GPU_MEMORY_READ_SQIDI5 UADD $GPU_MEMORY_READ_SQIDI6 UADD $GPU_MEMORY_READ_SQIDI7 UADD */
    uint64_t tmp0 = acmgt3__ext1__gpu_memory_read_sqidi2__read(perf, metric_set, accumulator) + acmgt3__ext1__gpu_memory_read_sqidi0__read(perf, metric_set, accumulator);
    uint64_t tmp1 = tmp0 + acmgt3__ext1__gpu_memory_read_sqidi1__read(perf, metric_set, accumulator);
    uint64_t tmp2 = tmp1 + acmgt3__ext1__gpu_memory_read_sqidi3__read(perf, metric_set, accumulator);
    uint64_t tmp3 = tmp2 + acmgt3__ext1__gpu_memory_read_sqidi4__read(perf, metric_set, accumulator);
    uint64_t tmp4 = tmp3 + acmgt3__ext1__gpu_memory_read_sqidi5__read(perf, metric_set, accumulator);
    uint64_t tmp5 = tmp4 + acmgt3__ext1__gpu_memory_read_sqidi6__read(perf, metric_set, accumulator);
    uint64_t tmp6 = tmp5 + acmgt3__ext1__gpu_memory_read_sqidi7__read(perf, metric_set, accumulator);

    return tmp6;
}

/* Ext2 :: GPU MEMORY BYTE READ */
uint64_t
acmgt3__ext2__gpu_memory_byte_read__read(const struct intel_perf *perf,
                                         const struct intel_perf_metric_set *metric_set,
                                         uint64_t *accumulator)
{
    /* RPN equation: C 7 READ  C 6 READ UADD  C 5 READ UADD  C 4 READ UADD  C 3 READ UADD  C 2 READ UADD  C 1 READ UADD  C 0 READ UADD 128 UMUL */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp6 = tmp4 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp8 = tmp6 + tmp7;
    uint64_t tmp9 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp10 = tmp8 + tmp9;
    uint64_t tmp11 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp12 = tmp10 + tmp11;
    uint64_t tmp13 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp14 = tmp12 + tmp13;
    uint64_t tmp15 = tmp14 * 128;

    return tmp15;
}

/* Ext2 :: GPU MEMORY BYTE WRITE SQIDI0 */
uint64_t
acmgt3__ext2__gpu_memory_byte_write_sqidi0__read(const struct intel_perf *perf,
                                                 const struct intel_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: B 7 READ 128 UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp1 = tmp0 * 128;

    return tmp1;
}

/* Ext2 :: GPU MEMORY BYTE WRITE SQIDI1 */
uint64_t
acmgt3__ext2__gpu_memory_byte_write_sqidi1__read(const struct intel_perf *perf,
                                                 const struct intel_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: B 6 READ 128 UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp1 = tmp0 * 128;

    return tmp1;
}

/* Ext2 :: GPU MEMORY BYTE WRITE SQIDI2 */
uint64_t
acmgt3__ext2__gpu_memory_byte_write_sqidi2__read(const struct intel_perf *perf,
                                                 const struct intel_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: B 5 READ 128 UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp1 = tmp0 * 128;

    return tmp1;
}

/* Ext2 :: GPU MEMORY BYTE WRITE SQIDI3 */
uint64_t
acmgt3__ext2__gpu_memory_byte_write_sqidi3__read(const struct intel_perf *perf,
                                                 const struct intel_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: B 4 READ 128 UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp1 = tmp0 * 128;

    return tmp1;
}

/* Ext2 :: GPU MEMORY BYTE WRITE SQIDI4 */
uint64_t
acmgt3__ext2__gpu_memory_byte_write_sqidi4__read(const struct intel_perf *perf,
                                                 const struct intel_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: B 3 READ 128 UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp1 = tmp0 * 128;

    return tmp1;
}

/* Ext2 :: GPU MEMORY BYTE WRITE SQIDI5 */
uint64_t
acmgt3__ext2__gpu_memory_byte_write_sqidi5__read(const struct intel_perf *perf,
                                                 const struct intel_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: B 2 READ 128 UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp1 = tmp0 * 128;

    return tmp1;
}

/* Ext2 :: GPU MEMORY BYTE WRITE SQIDI6 */
uint64_t
acmgt3__ext2__gpu_memory_byte_write_sqidi6__read(const struct intel_perf *perf,
                                                 const struct intel_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: B 1 READ 128 UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp1 = tmp0 * 128;

    return tmp1;
}

/* Ext2 :: GPU MEMORY BYTE WRITE SQIDI7 */
uint64_t
acmgt3__ext2__gpu_memory_byte_write_sqidi7__read(const struct intel_perf *perf,
                                                 const struct intel_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: B 0 READ 128 UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp1 = tmp0 * 128;

    return tmp1;
}

/* Ext2 :: GPU MEMORY BYTE WRITE */
uint64_t
acmgt3__ext2__gpu_memory_byte_write__read(const struct intel_perf *perf,
                                          const struct intel_perf_metric_set *metric_set,
                                          uint64_t *accumulator)
{
    /* RPN equation: B 7 READ  B 6 READ UADD  B 5 READ UADD  B 4 READ UADD  B 3 READ UADD  B 2 READ UADD  B 1 READ UADD  B 0 READ UADD 128 UMUL */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp6 = tmp4 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp8 = tmp6 + tmp7;
    uint64_t tmp9 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp10 = tmp8 + tmp9;
    uint64_t tmp11 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp12 = tmp10 + tmp11;
    uint64_t tmp13 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp14 = tmp12 + tmp13;
    uint64_t tmp15 = tmp14 * 128;

    return tmp15;
}

/* Ext2 :: GPU MEMORY BYTE READ BW */
double
acmgt3__ext2__gpu_memory_byte_read_bw__read(const struct intel_perf *perf,
                                            const struct intel_perf_metric_set *metric_set,
                                            uint64_t *accumulator)
{
    /* RPN equation: $GPU_MEMORY_BYTE_READ $GpuTime FDIV */
    double tmp0 = acmgt3__ext2__gpu_memory_byte_read__read(perf, metric_set, accumulator);
    double tmp1 = acmgt3__ext2__gpu_time__read(perf, metric_set, accumulator);
    double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

    return tmp2;
}

/* Ext2 :: GPU MEMORY BYTE WRITE BW SQIDI0 */
double
acmgt3__ext2__gpu_memory_byte_write_bw_sqidi0__read(const struct intel_perf *perf,
                                                    const struct intel_perf_metric_set *metric_set,
                                                    uint64_t *accumulator)
{
    /* RPN equation: $GPU_MEMORY_BYTE_WRITE_SQIDI0 $GpuTime FDIV */
    double tmp0 = acmgt3__ext2__gpu_memory_byte_write_sqidi0__read(perf, metric_set, accumulator);
    double tmp1 = acmgt3__ext2__gpu_time__read(perf, metric_set, accumulator);
    double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

    return tmp2;
}

/* Ext2 :: GPU MEMORY BYTE WRITE BW SQIDI1 */
double
acmgt3__ext2__gpu_memory_byte_write_bw_sqidi1__read(const struct intel_perf *perf,
                                                    const struct intel_perf_metric_set *metric_set,
                                                    uint64_t *accumulator)
{
    /* RPN equation: $GPU_MEMORY_BYTE_WRITE_SQIDI1 $GpuTime FDIV */
    double tmp0 = acmgt3__ext2__gpu_memory_byte_write_sqidi1__read(perf, metric_set, accumulator);
    double tmp1 = acmgt3__ext2__gpu_time__read(perf, metric_set, accumulator);
    double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

    return tmp2;
}

/* Ext2 :: GPU MEMORY BYTE WRITE BW SQIDI2 */
double
acmgt3__ext2__gpu_memory_byte_write_bw_sqidi2__read(const struct intel_perf *perf,
                                                    const struct intel_perf_metric_set *metric_set,
                                                    uint64_t *accumulator)
{
    /* RPN equation: $GPU_MEMORY_BYTE_WRITE_SQIDI2 $GpuTime FDIV */
    double tmp0 = acmgt3__ext2__gpu_memory_byte_write_sqidi2__read(perf, metric_set, accumulator);
    double tmp1 = acmgt3__ext2__gpu_time__read(perf, metric_set, accumulator);
    double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

    return tmp2;
}

/* Ext2 :: GPU MEMORY BYTE WRITE BW SQIDI3 */
double
acmgt3__ext2__gpu_memory_byte_write_bw_sqidi3__read(const struct intel_perf *perf,
                                                    const struct intel_perf_metric_set *metric_set,
                                                    uint64_t *accumulator)
{
    /* RPN equation: $GPU_MEMORY_BYTE_WRITE_SQIDI3 $GpuTime FDIV */
    double tmp0 = acmgt3__ext2__gpu_memory_byte_write_sqidi3__read(perf, metric_set, accumulator);
    double tmp1 = acmgt3__ext2__gpu_time__read(perf, metric_set, accumulator);
    double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

    return tmp2;
}

/* Ext2 :: GPU MEMORY BYTE WRITE BW SQIDI4 */
double
acmgt3__ext2__gpu_memory_byte_write_bw_sqidi4__read(const struct intel_perf *perf,
                                                    const struct intel_perf_metric_set *metric_set,
                                                    uint64_t *accumulator)
{
    /* RPN equation: $GPU_MEMORY_BYTE_WRITE_SQIDI4 $GpuTime FDIV */
    double tmp0 = acmgt3__ext2__gpu_memory_byte_write_sqidi4__read(perf, metric_set, accumulator);
    double tmp1 = acmgt3__ext2__gpu_time__read(perf, metric_set, accumulator);
    double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

    return tmp2;
}

/* Ext2 :: GPU MEMORY BYTE WRITE BW SQIDI5 */
double
acmgt3__ext2__gpu_memory_byte_write_bw_sqidi5__read(const struct intel_perf *perf,
                                                    const struct intel_perf_metric_set *metric_set,
                                                    uint64_t *accumulator)
{
    /* RPN equation: $GPU_MEMORY_BYTE_WRITE_SQIDI5 $GpuTime FDIV */
    double tmp0 = acmgt3__ext2__gpu_memory_byte_write_sqidi5__read(perf, metric_set, accumulator);
    double tmp1 = acmgt3__ext2__gpu_time__read(perf, metric_set, accumulator);
    double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

    return tmp2;
}

/* Ext2 :: GPU MEMORY BYTE WRITE BW SQIDI6 */
double
acmgt3__ext2__gpu_memory_byte_write_bw_sqidi6__read(const struct intel_perf *perf,
                                                    const struct intel_perf_metric_set *metric_set,
                                                    uint64_t *accumulator)
{
    /* RPN equation: $GPU_MEMORY_BYTE_WRITE_SQIDI6 $GpuTime FDIV */
    double tmp0 = acmgt3__ext2__gpu_memory_byte_write_sqidi6__read(perf, metric_set, accumulator);
    double tmp1 = acmgt3__ext2__gpu_time__read(perf, metric_set, accumulator);
    double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

    return tmp2;
}

/* Ext2 :: GPU MEMORY BYTE WRITE BW SQIDI7 */
double
acmgt3__ext2__gpu_memory_byte_write_bw_sqidi7__read(const struct intel_perf *perf,
                                                    const struct intel_perf_metric_set *metric_set,
                                                    uint64_t *accumulator)
{
    /* RPN equation: $GPU_MEMORY_BYTE_WRITE_SQIDI7 $GpuTime FDIV */
    double tmp0 = acmgt3__ext2__gpu_memory_byte_write_sqidi7__read(perf, metric_set, accumulator);
    double tmp1 = acmgt3__ext2__gpu_time__read(perf, metric_set, accumulator);
    double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

    return tmp2;
}

/* Ext2 :: GPU MEMORY BYTE WRITE BW */
double
acmgt3__ext2__gpu_memory_byte_write_bw__read(const struct intel_perf *perf,
                                             const struct intel_perf_metric_set *metric_set,
                                             uint64_t *accumulator)
{
    /* RPN equation: $GPU_MEMORY_BYTE_WRITE $GpuTime FDIV */
    double tmp0 = acmgt3__ext2__gpu_memory_byte_write__read(perf, metric_set, accumulator);
    double tmp1 = acmgt3__ext2__gpu_time__read(perf, metric_set, accumulator);
    double tmp2 = tmp1 ? tmp0 / tmp1 : 0;

    return tmp2;
}

/* Ext6 :: GPU MEMORY ACTIVE */
double
acmgt3__ext6__gpu_memory_active__read(const struct intel_perf *perf,
                                      const struct intel_perf_metric_set *metric_set,
                                      uint64_t *accumulator)
{
    /* RPN equation: C 5 READ  C 7 READ FADD  C 6 READ FADD  C 4 READ FADD  C 3 READ FADD  C 2 READ FADD  C 1 READ FADD  C 0 READ FADD 8 FDIV $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 7];
    double tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->c_offset + 6];
    double tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->c_offset + 4];
    double tmp6 = tmp4 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->c_offset + 3];
    double tmp8 = tmp6 + tmp7;
    uint64_t tmp9 = accumulator[metric_set->c_offset + 2];
    double tmp10 = tmp8 + tmp9;
    uint64_t tmp11 = accumulator[metric_set->c_offset + 1];
    double tmp12 = tmp10 + tmp11;
    uint64_t tmp13 = accumulator[metric_set->c_offset + 0];
    double tmp14 = tmp12 + tmp13;
    double tmp15 = tmp14;
    double tmp16 = 8;
    double tmp17 = tmp16 ? tmp15 / tmp16 : 0;
    double tmp18 = tmp17;
    double tmp19 = acmgt3__ext6__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp20 = tmp19 ? tmp18 / tmp19 : 0;

    return tmp20;
}

/* Ext6 :: GPU MEMORY REQUEST QUEUE FULL */
double
acmgt3__ext6__gpu_memory_request_queue_full__read(const struct intel_perf *perf,
                                                  const struct intel_perf_metric_set *metric_set,
                                                  uint64_t *accumulator)
{
    /* RPN equation: B 5 READ  B 7 READ FADD  B 6 READ FADD  B 4 READ FADD  B 3 READ FADD  B 2 READ FADD  B 1 READ FADD  B 0 READ FADD 8 FDIV $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 7];
    double tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->b_offset + 6];
    double tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->b_offset + 4];
    double tmp6 = tmp4 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->b_offset + 3];
    double tmp8 = tmp6 + tmp7;
    uint64_t tmp9 = accumulator[metric_set->b_offset + 2];
    double tmp10 = tmp8 + tmp9;
    uint64_t tmp11 = accumulator[metric_set->b_offset + 1];
    double tmp12 = tmp10 + tmp11;
    uint64_t tmp13 = accumulator[metric_set->b_offset + 0];
    double tmp14 = tmp12 + tmp13;
    double tmp15 = tmp14;
    double tmp16 = 8;
    double tmp17 = tmp16 ? tmp15 / tmp16 : 0;
    double tmp18 = tmp17;
    double tmp19 = acmgt3__ext6__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp20 = tmp19 ? tmp18 / tmp19 : 0;

    return tmp20;
}

/* Ext616 :: GPU MEMORY WRITE */
uint64_t
acmgt3__ext616__gpu_memory_write__read(const struct intel_perf *perf,
                                       const struct intel_perf_metric_set *metric_set,
                                       uint64_t *accumulator)
{
    /* RPN equation: $GPU_MEMORY_WRITE_SQIDI2 $GPU_MEMORY_WRITE_SQIDI0 UADD $GPU_MEMORY_WRITE_SQIDI1 UADD $GPU_MEMORY_WRITE_SQIDI3 UADD $GPU_MEMORY_WRITE_SQIDI4 UADD $GPU_MEMORY_WRITE_SQIDI5 UADD $GPU_MEMORY_WRITE_SQIDI6 UADD $GPU_MEMORY_WRITE_SQIDI7 UADD */
    uint64_t tmp0 = acmgt3__ext616__gpu_memory_write_sqidi2__read(perf, metric_set, accumulator) + acmgt3__ext616__gpu_memory_write_sqidi0__read(perf, metric_set, accumulator);
    uint64_t tmp1 = tmp0 + acmgt3__ext616__gpu_memory_write_sqidi1__read(perf, metric_set, accumulator);
    uint64_t tmp2 = tmp1 + acmgt3__ext616__gpu_memory_write_sqidi3__read(perf, metric_set, accumulator);
    uint64_t tmp3 = tmp2 + acmgt3__ext616__gpu_memory_write_sqidi4__read(perf, metric_set, accumulator);
    uint64_t tmp4 = tmp3 + acmgt3__ext616__gpu_memory_write_sqidi5__read(perf, metric_set, accumulator);
    uint64_t tmp5 = tmp4 + acmgt3__ext616__gpu_memory_write_sqidi6__read(perf, metric_set, accumulator);
    uint64_t tmp6 = tmp5 + acmgt3__ext616__gpu_memory_write_sqidi7__read(perf, metric_set, accumulator);

    return tmp6;
}

/* Ext634 :: COMMAND PARSER COMPUTE ENGINE BUSY */
double
acmgt3__ext634__command_parser_compute_engine_busy__read(const struct intel_perf *perf,
                                                         const struct intel_perf_metric_set *metric_set,
                                                         uint64_t *accumulator)
{
    /* RPN equation: B 1 READ  B 0 READ FADD  B 2 READ FADD  B 3 READ FADD 4 FDIV $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 0];
    double tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->b_offset + 2];
    double tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->b_offset + 3];
    double tmp6 = tmp4 + tmp5;
    double tmp7 = tmp6;
    double tmp8 = 4;
    double tmp9 = tmp8 ? tmp7 / tmp8 : 0;
    double tmp10 = tmp9;
    double tmp11 = acmgt3__ext634__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp12 = tmp11 ? tmp10 / tmp11 : 0;

    return tmp12;
}

/* Ext635 :: COMMAND PARSER VIDEO ENGINE BUSY */
double
acmgt3__ext635__command_parser_video_engine_busy__read(const struct intel_perf *perf,
                                                       const struct intel_perf_metric_set *metric_set,
                                                       uint64_t *accumulator)
{
    /* RPN equation: B 1 READ  B 3 READ FADD 2 FDIV $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 3];
    double tmp2 = tmp0 + tmp1;
    double tmp3 = tmp2;
    double tmp4 = 2;
    double tmp5 = tmp4 ? tmp3 / tmp4 : 0;
    double tmp6 = tmp5;
    double tmp7 = acmgt3__ext635__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp8 = tmp7 ? tmp6 / tmp7 : 0;

    return tmp8;
}

/* Ext635 :: COMMAND PARSER VIDEO ENHANCEMENT ENGINE BUSY */
double
acmgt3__ext635__command_parser_video_enhancement_engine_busy__read(const struct intel_perf *perf,
                                                                   const struct intel_perf_metric_set *metric_set,
                                                                   uint64_t *accumulator)
{
    /* RPN equation: B 2 READ  B 4 READ FADD 2 FDIV $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 4];
    double tmp2 = tmp0 + tmp1;
    double tmp3 = tmp2;
    double tmp4 = 2;
    double tmp5 = tmp4 ? tmp3 / tmp4 : 0;
    double tmp6 = tmp5;
    double tmp7 = acmgt3__ext635__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp8 = tmp7 ? tmp6 / tmp7 : 0;

    return tmp8;
}

/* Ext636 :: COMMAND PARSER COMPUTE ENGINE DISPATCH KERNEL COUNT */
uint64_t
acmgt3__ext636__command_parser_compute_engine_dispatch_kernel_count__read(const struct intel_perf *perf,
                                                                          const struct intel_perf_metric_set *metric_set,
                                                                          uint64_t *accumulator)
{
    /* RPN equation: $COMMAND_PARSER_COMPUTE_ENGINE_DISPATCH_KERNEL_COUNT_CCS1 $COMMAND_PARSER_COMPUTE_ENGINE_DISPATCH_KERNEL_COUNT_CCS0 UADD $COMMAND_PARSER_COMPUTE_ENGINE_DISPATCH_KERNEL_COUNT_CCS2 UADD $COMMAND_PARSER_COMPUTE_ENGINE_DISPATCH_KERNEL_COUNT_CCS3 UADD */
    uint64_t tmp0 = acmgt3__ext636__command_parser_compute_engine_dispatch_kernel_count_ccs1__read(perf, metric_set, accumulator) + acmgt3__ext636__command_parser_compute_engine_dispatch_kernel_count_ccs0__read(perf, metric_set, accumulator);
    uint64_t tmp1 = tmp0 + acmgt3__ext636__command_parser_compute_engine_dispatch_kernel_count_ccs2__read(perf, metric_set, accumulator);
    uint64_t tmp2 = tmp1 + acmgt3__ext636__command_parser_compute_engine_dispatch_kernel_count_ccs3__read(perf, metric_set, accumulator);

    return tmp2;
}

/* Render Metrics Basic :: GTI Read Throughput */
uint64_t
mtlgt2__render_basic__gti_read_throughput__read(const struct intel_perf *perf,
                                                const struct intel_perf_metric_set *metric_set,
                                                uint64_t *accumulator)
{
    /* RPN equation: 32  A 36 READ UMUL */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 36];
    uint64_t tmp1 = 32 * tmp0;

    return tmp1;
}

/* Render Metrics Basic :: GTI Write Throughput */
uint64_t
mtlgt2__render_basic__gti_write_throughput__read(const struct intel_perf *perf,
                                                 const struct intel_perf_metric_set *metric_set,
                                                 uint64_t *accumulator)
{
    /* RPN equation: 32  A 37 READ UMUL */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 37];
    uint64_t tmp1 = 32 * tmp0;

    return tmp1;
}

/* Ext1 :: GPU MEMORY READ */
uint64_t
mtlgt2__ext1__gpu_memory_read__read(const struct intel_perf *perf,
                                    const struct intel_perf_metric_set *metric_set,
                                    uint64_t *accumulator)
{
    /* RPN equation: $GPU_MEMORY_READ_SQIDI0 $GPU_MEMORY_READ_SQIDI1 UADD */
    uint64_t tmp0 = mtlgt2__ext1__gpu_memory_read_sqidi0__read(perf, metric_set, accumulator) + mtlgt2__ext1__gpu_memory_read_sqidi1__read(perf, metric_set, accumulator);

    return tmp0;
}

/* Ext17 :: LOAD STORE CACHE INPUT AVAILABLE XECORE0 */
double
mtlgt2__ext17__load_store_cache_input_available_xecore0__read(const struct intel_perf *perf,
                                                              const struct intel_perf_metric_set *metric_set,
                                                              uint64_t *accumulator)
{
    /* RPN equation: C 7 READ C 6 READ FADD 2 FDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 6];
    double tmp2 = tmp0 + tmp1;
    double tmp3 = tmp2;
    double tmp4 = 2;
    double tmp5 = tmp4 ? tmp3 / tmp4 : 0;
    uint64_t tmp6 = tmp5 * 100;
    double tmp7 = tmp6;
    double tmp8 = mtlgt2__ext17__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp9 = tmp8 ? tmp7 / tmp8 : 0;

    return tmp9;
}

/* Ext17 :: LOAD STORE CACHE INPUT AVAILABLE XECORE1 */
double
mtlgt2__ext17__load_store_cache_input_available_xecore1__read(const struct intel_perf *perf,
                                                              const struct intel_perf_metric_set *metric_set,
                                                              uint64_t *accumulator)
{
    /* RPN equation: C 5 READ C 4 READ FADD 2 FDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 4];
    double tmp2 = tmp0 + tmp1;
    double tmp3 = tmp2;
    double tmp4 = 2;
    double tmp5 = tmp4 ? tmp3 / tmp4 : 0;
    uint64_t tmp6 = tmp5 * 100;
    double tmp7 = tmp6;
    double tmp8 = mtlgt2__ext17__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp9 = tmp8 ? tmp7 / tmp8 : 0;

    return tmp9;
}

/* Ext17 :: LOAD STORE CACHE INPUT AVAILABLE XECORE2 */
double
mtlgt2__ext17__load_store_cache_input_available_xecore2__read(const struct intel_perf *perf,
                                                              const struct intel_perf_metric_set *metric_set,
                                                              uint64_t *accumulator)
{
    /* RPN equation: C 3 READ C 2 READ FADD 2 FDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 2];
    double tmp2 = tmp0 + tmp1;
    double tmp3 = tmp2;
    double tmp4 = 2;
    double tmp5 = tmp4 ? tmp3 / tmp4 : 0;
    uint64_t tmp6 = tmp5 * 100;
    double tmp7 = tmp6;
    double tmp8 = mtlgt2__ext17__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp9 = tmp8 ? tmp7 / tmp8 : 0;

    return tmp9;
}

/* Ext17 :: LOAD STORE CACHE INPUT AVAILABLE XECORE3 */
double
mtlgt2__ext17__load_store_cache_input_available_xecore3__read(const struct intel_perf *perf,
                                                              const struct intel_perf_metric_set *metric_set,
                                                              uint64_t *accumulator)
{
    /* RPN equation: C 1 READ C 0 READ FADD 2 FDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 0];
    double tmp2 = tmp0 + tmp1;
    double tmp3 = tmp2;
    double tmp4 = 2;
    double tmp5 = tmp4 ? tmp3 / tmp4 : 0;
    uint64_t tmp6 = tmp5 * 100;
    double tmp7 = tmp6;
    double tmp8 = mtlgt2__ext17__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp9 = tmp8 ? tmp7 / tmp8 : 0;

    return tmp9;
}

/* Ext17 :: LOAD STORE CACHE OUTPUT READY XECORE0 */
double
mtlgt2__ext17__load_store_cache_output_ready_xecore0__read(const struct intel_perf *perf,
                                                           const struct intel_perf_metric_set *metric_set,
                                                           uint64_t *accumulator)
{
    /* RPN equation: B 7 READ B 6 READ FADD 2 FDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 6];
    double tmp2 = tmp0 + tmp1;
    double tmp3 = tmp2;
    double tmp4 = 2;
    double tmp5 = tmp4 ? tmp3 / tmp4 : 0;
    uint64_t tmp6 = tmp5 * 100;
    double tmp7 = tmp6;
    double tmp8 = mtlgt2__ext17__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp9 = tmp8 ? tmp7 / tmp8 : 0;

    return tmp9;
}

/* Ext17 :: LOAD STORE CACHE OUTPUT READY XECORE1 */
double
mtlgt2__ext17__load_store_cache_output_ready_xecore1__read(const struct intel_perf *perf,
                                                           const struct intel_perf_metric_set *metric_set,
                                                           uint64_t *accumulator)
{
    /* RPN equation: B 5 READ B 4 READ FADD 2 FDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 4];
    double tmp2 = tmp0 + tmp1;
    double tmp3 = tmp2;
    double tmp4 = 2;
    double tmp5 = tmp4 ? tmp3 / tmp4 : 0;
    uint64_t tmp6 = tmp5 * 100;
    double tmp7 = tmp6;
    double tmp8 = mtlgt2__ext17__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp9 = tmp8 ? tmp7 / tmp8 : 0;

    return tmp9;
}

/* Ext17 :: LOAD STORE CACHE OUTPUT READY XECORE2 */
double
mtlgt2__ext17__load_store_cache_output_ready_xecore2__read(const struct intel_perf *perf,
                                                           const struct intel_perf_metric_set *metric_set,
                                                           uint64_t *accumulator)
{
    /* RPN equation: B 3 READ B 2 READ FADD 2 FDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 2];
    double tmp2 = tmp0 + tmp1;
    double tmp3 = tmp2;
    double tmp4 = 2;
    double tmp5 = tmp4 ? tmp3 / tmp4 : 0;
    uint64_t tmp6 = tmp5 * 100;
    double tmp7 = tmp6;
    double tmp8 = mtlgt2__ext17__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp9 = tmp8 ? tmp7 / tmp8 : 0;

    return tmp9;
}

/* Ext17 :: LOAD STORE CACHE OUTPUT READY XECORE3 */
double
mtlgt2__ext17__load_store_cache_output_ready_xecore3__read(const struct intel_perf *perf,
                                                           const struct intel_perf_metric_set *metric_set,
                                                           uint64_t *accumulator)
{
    /* RPN equation: B 1 READ B 0 READ FADD 2 FDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 0];
    double tmp2 = tmp0 + tmp1;
    double tmp3 = tmp2;
    double tmp4 = 2;
    double tmp5 = tmp4 ? tmp3 / tmp4 : 0;
    uint64_t tmp6 = tmp5 * 100;
    double tmp7 = tmp6;
    double tmp8 = mtlgt2__ext17__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp9 = tmp8 ? tmp7 / tmp8 : 0;

    return tmp9;
}

/* Ext123 :: CLIPPER PRIMITIVE FAR NEAR CLIP SLICE0 */
uint64_t
mtlgt2__ext123__clipper_primitive_far_near_clip_slice0__read(const struct intel_perf *perf,
                                                             const struct intel_perf_metric_set *metric_set,
                                                             uint64_t *accumulator)
{
    /* RPN equation: C 6 READ C 5 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp2 = tmp0 + tmp1;

    return tmp2;
}

/* Ext134 :: HIZ DEPTH TEST AMBIG NP ZPIPE0 */
uint64_t
mtlgt2__ext134__hiz_depth_test_ambig_np_zpipe0__read(const struct intel_perf *perf,
                                                     const struct intel_perf_metric_set *metric_set,
                                                     uint64_t *accumulator)
{
    /* RPN equation: C 7 READ 2 C 6 READ UMUL UADD 4 C 5 READ UMUL UADD 8 C 4 READ UMUL UADD 16 C 3 READ UMUL UADD 32 C 2 READ UMUL UADD 64 C 1 READ UMUL UADD 128 C 0 READ UMUL UADD 256 B 7 READ UMUL UADD 512 B 6 READ UMUL UADD 1024 B 5 READ UMUL UADD */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp2 = 2 * tmp1;
    uint64_t tmp3 = tmp0 + tmp2;
    uint64_t tmp4 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp5 = 4 * tmp4;
    uint64_t tmp6 = tmp3 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp8 = 8 * tmp7;
    uint64_t tmp9 = tmp6 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp11 = 16 * tmp10;
    uint64_t tmp12 = tmp9 + tmp11;
    uint64_t tmp13 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp14 = 32 * tmp13;
    uint64_t tmp15 = tmp12 + tmp14;
    uint64_t tmp16 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp17 = 64 * tmp16;
    uint64_t tmp18 = tmp15 + tmp17;
    uint64_t tmp19 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp20 = 128 * tmp19;
    uint64_t tmp21 = tmp18 + tmp20;
    uint64_t tmp22 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp23 = 256 * tmp22;
    uint64_t tmp24 = tmp21 + tmp23;
    uint64_t tmp25 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp26 = 512 * tmp25;
    uint64_t tmp27 = tmp24 + tmp26;
    uint64_t tmp28 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp29 = 1024 * tmp28;
    uint64_t tmp30 = tmp27 + tmp29;

    return tmp30;
}

/* Ext150 :: HIZ DEPTH TEST PASS P ZPIPE0 */
uint64_t
mtlgt2__ext150__hiz_depth_test_pass_p_zpipe0__read(const struct intel_perf *perf,
                                                   const struct intel_perf_metric_set *metric_set,
                                                   uint64_t *accumulator)
{
    /* RPN equation: C 7 READ 2 C 6 READ UMUL UADD 4 C 5 READ UMUL UADD 8 C 4 READ UMUL UADD 16 C 3 READ UMUL UADD 32 C 2 READ UMUL UADD 64 C 1 READ UMUL UADD 128 C 0 READ UMUL UADD 256 B 7 READ UMUL UADD 512 B 6 READ UMUL UADD */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp2 = 2 * tmp1;
    uint64_t tmp3 = tmp0 + tmp2;
    uint64_t tmp4 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp5 = 4 * tmp4;
    uint64_t tmp6 = tmp3 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp8 = 8 * tmp7;
    uint64_t tmp9 = tmp6 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp11 = 16 * tmp10;
    uint64_t tmp12 = tmp9 + tmp11;
    uint64_t tmp13 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp14 = 32 * tmp13;
    uint64_t tmp15 = tmp12 + tmp14;
    uint64_t tmp16 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp17 = 64 * tmp16;
    uint64_t tmp18 = tmp15 + tmp17;
    uint64_t tmp19 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp20 = 128 * tmp19;
    uint64_t tmp21 = tmp18 + tmp20;
    uint64_t tmp22 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp23 = 256 * tmp22;
    uint64_t tmp24 = tmp21 + tmp23;
    uint64_t tmp25 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp26 = 512 * tmp25;
    uint64_t tmp27 = tmp24 + tmp26;

    return tmp27;
}

/* Ext225 :: PIXEL 2x2 LIT POST RASTERIZER EARLY DEPTH SLICE0 */
uint64_t
mtlgt2__ext225__pixel_2x2_lit_post_rasterizer_early_depth_slice0__read(const struct intel_perf *perf,
                                                                       const struct intel_perf_metric_set *metric_set,
                                                                       uint64_t *accumulator)
{
    /* RPN equation: 1 B 0 READ UMUL 2 B 1 READ UMUL UADD 4 B 2 READ UMUL UADD 8 B 3 READ UMUL UADD 16 B 4 READ UMUL UADD 32 B 5 READ UMUL UADD 64 B 6 READ UMUL UADD 128 B 7 READ UMUL UADD 256 C 1 READ UMUL UADD */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp1 = 1 * tmp0;
    uint64_t tmp2 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp3 = 2 * tmp2;
    uint64_t tmp4 = tmp1 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp6 = 4 * tmp5;
    uint64_t tmp7 = tmp4 + tmp6;
    uint64_t tmp8 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp9 = 8 * tmp8;
    uint64_t tmp10 = tmp7 + tmp9;
    uint64_t tmp11 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp12 = 16 * tmp11;
    uint64_t tmp13 = tmp10 + tmp12;
    uint64_t tmp14 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp15 = 32 * tmp14;
    uint64_t tmp16 = tmp13 + tmp15;
    uint64_t tmp17 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp18 = 64 * tmp17;
    uint64_t tmp19 = tmp16 + tmp18;
    uint64_t tmp20 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp21 = 128 * tmp20;
    uint64_t tmp22 = tmp19 + tmp21;
    uint64_t tmp23 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp24 = 256 * tmp23;
    uint64_t tmp25 = tmp22 + tmp24;

    return tmp25;
}

/* Ext229 :: SLM BANK CONFLICT COUNT XECORE0 */
uint64_t
mtlgt2__ext229__slm_bank_conflict_count_xecore0__read(const struct intel_perf *perf,
                                                      const struct intel_perf_metric_set *metric_set,
                                                      uint64_t *accumulator)
{
    /* RPN equation: C 7 READ 2 C 6 READ UMUL UADD 4 C 5 READ UMUL UADD 8 C 4 READ UMUL UADD C 3 READ UADD 2 C 2 READ UMUL UADD 4 C 1 READ UMUL UADD 8 C 0 READ UMUL UADD */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp2 = 2 * tmp1;
    uint64_t tmp3 = tmp0 + tmp2;
    uint64_t tmp4 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp5 = 4 * tmp4;
    uint64_t tmp6 = tmp3 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp8 = 8 * tmp7;
    uint64_t tmp9 = tmp6 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp11 = tmp9 + tmp10;
    uint64_t tmp12 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp13 = 2 * tmp12;
    uint64_t tmp14 = tmp11 + tmp13;
    uint64_t tmp15 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp16 = 4 * tmp15;
    uint64_t tmp17 = tmp14 + tmp16;
    uint64_t tmp18 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp19 = 8 * tmp18;
    uint64_t tmp20 = tmp17 + tmp19;

    return tmp20;
}

/* Ext229 :: SLM BANK CONFLICT COUNT XECORE1 */
uint64_t
mtlgt2__ext229__slm_bank_conflict_count_xecore1__read(const struct intel_perf *perf,
                                                      const struct intel_perf_metric_set *metric_set,
                                                      uint64_t *accumulator)
{
    /* RPN equation: B 7 READ 2 B 6 READ UMUL UADD 4 B 5 READ UMUL UADD 8 B 4 READ UMUL UADD B 3 READ UADD 2 B 2 READ UMUL UADD 4 B 1 READ UMUL UADD 8 B 0 READ UMUL UADD */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp2 = 2 * tmp1;
    uint64_t tmp3 = tmp0 + tmp2;
    uint64_t tmp4 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp5 = 4 * tmp4;
    uint64_t tmp6 = tmp3 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp8 = 8 * tmp7;
    uint64_t tmp9 = tmp6 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp11 = tmp9 + tmp10;
    uint64_t tmp12 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp13 = 2 * tmp12;
    uint64_t tmp14 = tmp11 + tmp13;
    uint64_t tmp15 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp16 = 4 * tmp15;
    uint64_t tmp17 = tmp14 + tmp16;
    uint64_t tmp18 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp19 = 8 * tmp18;
    uint64_t tmp20 = tmp17 + tmp19;

    return tmp20;
}

/* Ext508 :: SLM BYTE READ BANK0 XECORE1 */
uint64_t
mtlgt2__ext508__slm_byte_read_bank0_xecore1__read(const struct intel_perf *perf,
                                                  const struct intel_perf_metric_set *metric_set,
                                                  uint64_t *accumulator)
{
    /* RPN equation: C 0 READ 2 B 7 READ UMUL UADD 4 B 6 READ UMUL UADD 8 B 5 READ UMUL UADD 16 B 4 READ UMUL UADD 32 B 3 READ UMUL UADD 64 B 2 READ UMUL UADD */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp2 = 2 * tmp1;
    uint64_t tmp3 = tmp0 + tmp2;
    uint64_t tmp4 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp5 = 4 * tmp4;
    uint64_t tmp6 = tmp3 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp8 = 8 * tmp7;
    uint64_t tmp9 = tmp6 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp11 = 16 * tmp10;
    uint64_t tmp12 = tmp9 + tmp11;
    uint64_t tmp13 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp14 = 32 * tmp13;
    uint64_t tmp15 = tmp12 + tmp14;
    uint64_t tmp16 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp17 = 64 * tmp16;
    uint64_t tmp18 = tmp15 + tmp17;

    return tmp18;
}

/* Ext516 :: LOAD STORE CACHE BYTE READ BANK0 XECORE0 */
uint64_t
mtlgt2__ext516__load_store_cache_byte_read_bank0_xecore0__read(const struct intel_perf *perf,
                                                               const struct intel_perf_metric_set *metric_set,
                                                               uint64_t *accumulator)
{
    /* RPN equation: C 7 READ 2 C 6 READ UMUL UADD 4 C 5 READ UMUL UADD 8 C 4 READ UMUL UADD 16 C 3 READ UMUL UADD 32 C 2 READ UMUL UADD 64 C 1 READ UMUL UADD 128 C 0 READ UMUL UADD */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp2 = 2 * tmp1;
    uint64_t tmp3 = tmp0 + tmp2;
    uint64_t tmp4 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp5 = 4 * tmp4;
    uint64_t tmp6 = tmp3 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp8 = 8 * tmp7;
    uint64_t tmp9 = tmp6 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp11 = 16 * tmp10;
    uint64_t tmp12 = tmp9 + tmp11;
    uint64_t tmp13 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp14 = 32 * tmp13;
    uint64_t tmp15 = tmp12 + tmp14;
    uint64_t tmp16 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp17 = 64 * tmp16;
    uint64_t tmp18 = tmp15 + tmp17;
    uint64_t tmp19 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp20 = 128 * tmp19;
    uint64_t tmp21 = tmp18 + tmp20;

    return tmp21;
}

/* Ext516 :: LOAD STORE CACHE BYTE READ BANK1 XECORE0 */
uint64_t
mtlgt2__ext516__load_store_cache_byte_read_bank1_xecore0__read(const struct intel_perf *perf,
                                                               const struct intel_perf_metric_set *metric_set,
                                                               uint64_t *accumulator)
{
    /* RPN equation: B 7 READ 2 B 6 READ UMUL UADD 4 B 5 READ UMUL UADD 8 B 4 READ UMUL UADD 16 B 3 READ UMUL UADD 32 B 2 READ UMUL UADD 64 B 1 READ UMUL UADD 128 B 0 READ UMUL UADD */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp2 = 2 * tmp1;
    uint64_t tmp3 = tmp0 + tmp2;
    uint64_t tmp4 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp5 = 4 * tmp4;
    uint64_t tmp6 = tmp3 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp8 = 8 * tmp7;
    uint64_t tmp9 = tmp6 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp11 = 16 * tmp10;
    uint64_t tmp12 = tmp9 + tmp11;
    uint64_t tmp13 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp14 = 32 * tmp13;
    uint64_t tmp15 = tmp12 + tmp14;
    uint64_t tmp16 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp17 = 64 * tmp16;
    uint64_t tmp18 = tmp15 + tmp17;
    uint64_t tmp19 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp20 = 128 * tmp19;
    uint64_t tmp21 = tmp18 + tmp20;

    return tmp21;
}

/* MediaSet1 :: VIDEO_DECODE_BOX0_READ_REQUEST */
uint64_t
mtlgt2__media_set1__video_decode_box0_read_request__read(const struct intel_perf *perf,
                                                         const struct intel_perf_metric_set *metric_set,
                                                         uint64_t *accumulator)
{
    /* RPN equation: A 0 READ */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 0];

    return tmp0;
}

/* MediaSet2 :: COMMAND PARSER VIDEO DECODE_ENGINE0 BUSY */
double
mtlgt2__media_set2__command_parser_video_decode_engine0_busy__read(const struct intel_perf *perf,
                                                                   const struct intel_perf_metric_set *metric_set,
                                                                   uint64_t *accumulator)
{
    /* RPN equation: A 2 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 2];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = mtlgt2__media_set2__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* MediaSet2 :: COMMAND_PARSER_VIDEO_DECODE_ENGINE1_BUSY */
double
mtlgt2__media_set2__command_parser_video_decode_engine1_busy__read(const struct intel_perf *perf,
                                                                   const struct intel_perf_metric_set *metric_set,
                                                                   uint64_t *accumulator)
{
    /* RPN equation: A 3 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 3];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = mtlgt2__media_set2__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* MediaSet2 :: COMMAND_PARSER_VIDEO_ENHANCEMENT_ENGINE0_BUSY */
double
mtlgt2__media_set2__command_parser_video_enhancement_engine0_busy__read(const struct intel_perf *perf,
                                                                        const struct intel_perf_metric_set *metric_set,
                                                                        uint64_t *accumulator)
{
    /* RPN equation: A 4 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 4];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = mtlgt2__media_set2__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* MediaSet2 :: COMMAND_PARSER_VIDEO_ENHANCEMENT_ENGINE1_BUSY */
double
mtlgt2__media_set2__command_parser_video_enhancement_engine1_busy__read(const struct intel_perf *perf,
                                                                        const struct intel_perf_metric_set *metric_set,
                                                                        uint64_t *accumulator)
{
    /* RPN equation: A 5 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 5];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = mtlgt2__media_set2__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* MediaSet2 :: COMMAND_PARSER_GRAPHICS_SECURITY_CONTROLLER_BUSY */
double
mtlgt2__media_set2__command_parser_graphics_security_controller_busy__read(const struct intel_perf *perf,
                                                                           const struct intel_perf_metric_set *metric_set,
                                                                           uint64_t *accumulator)
{
    /* RPN equation: A 6 READ 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->a_offset + 6];
    uint64_t tmp1 = tmp0 * 100;
    double tmp2 = tmp1;
    double tmp3 = mtlgt2__media_set2__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp4 = tmp3 ? tmp2 / tmp3 : 0;

    return tmp4;
}

/* Ext1 :: GPU MEMORY READ SQIDI1 */
uint64_t
mtlgt3__ext1__gpu_memory_read_sqidi1__read(const struct intel_perf *perf,
                                           const struct intel_perf_metric_set *metric_set,
                                           uint64_t *accumulator)
{
    /* RPN equation: C 0 READ C 1 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp2 = tmp0 + tmp1;

    return tmp2;
}

/* Ext1 :: GPU MEMORY READ */
uint64_t
mtlgt3__ext1__gpu_memory_read__read(const struct intel_perf *perf,
                                    const struct intel_perf_metric_set *metric_set,
                                    uint64_t *accumulator)
{
    /* RPN equation: $GPU_MEMORY_READ_SQIDI0 $GPU_MEMORY_READ_SQIDI1 UADD */
    uint64_t tmp0 = mtlgt3__ext1__gpu_memory_read_sqidi0__read(perf, metric_set, accumulator) + mtlgt3__ext1__gpu_memory_read_sqidi1__read(perf, metric_set, accumulator);

    return tmp0;
}

/* Ext3 :: GPU MEMORY 64B TRANSACTION WRITE */
uint64_t
mtlgt3__ext3__gpu_memory_64_b_transaction_write__read(const struct intel_perf *perf,
                                                      const struct intel_perf_metric_set *metric_set,
                                                      uint64_t *accumulator)
{
    /* RPN equation: C 6 READ  C 7 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp2 = tmp0 + tmp1;

    return tmp2;
}

/* Ext18 :: LOAD STORE CACHE OUTPUT READY XECORE4 */
double
mtlgt3__ext18__load_store_cache_output_ready_xecore4__read(const struct intel_perf *perf,
                                                           const struct intel_perf_metric_set *metric_set,
                                                           uint64_t *accumulator)
{
    /* RPN equation: B 7 READ B 6 READ FADD 4 FDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 6];
    double tmp2 = tmp0 + tmp1;
    double tmp3 = tmp2;
    double tmp4 = 4;
    double tmp5 = tmp4 ? tmp3 / tmp4 : 0;
    uint64_t tmp6 = tmp5 * 100;
    double tmp7 = tmp6;
    double tmp8 = mtlgt3__ext18__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp9 = tmp8 ? tmp7 / tmp8 : 0;

    return tmp9;
}

/* Ext18 :: LOAD STORE CACHE OUTPUT READY XECORE5 */
double
mtlgt3__ext18__load_store_cache_output_ready_xecore5__read(const struct intel_perf *perf,
                                                           const struct intel_perf_metric_set *metric_set,
                                                           uint64_t *accumulator)
{
    /* RPN equation: B 5 READ B 4 READ FADD 4 FDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 4];
    double tmp2 = tmp0 + tmp1;
    double tmp3 = tmp2;
    double tmp4 = 4;
    double tmp5 = tmp4 ? tmp3 / tmp4 : 0;
    uint64_t tmp6 = tmp5 * 100;
    double tmp7 = tmp6;
    double tmp8 = mtlgt3__ext18__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp9 = tmp8 ? tmp7 / tmp8 : 0;

    return tmp9;
}

/* Ext18 :: LOAD STORE CACHE OUTPUT READY XECORE6 */
double
mtlgt3__ext18__load_store_cache_output_ready_xecore6__read(const struct intel_perf *perf,
                                                           const struct intel_perf_metric_set *metric_set,
                                                           uint64_t *accumulator)
{
    /* RPN equation: B 3 READ B 2 READ FADD 4 FDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 2];
    double tmp2 = tmp0 + tmp1;
    double tmp3 = tmp2;
    double tmp4 = 4;
    double tmp5 = tmp4 ? tmp3 / tmp4 : 0;
    uint64_t tmp6 = tmp5 * 100;
    double tmp7 = tmp6;
    double tmp8 = mtlgt3__ext18__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp9 = tmp8 ? tmp7 / tmp8 : 0;

    return tmp9;
}

/* Ext18 :: LOAD STORE CACHE OUTPUT READY XECORE7 */
double
mtlgt3__ext18__load_store_cache_output_ready_xecore7__read(const struct intel_perf *perf,
                                                           const struct intel_perf_metric_set *metric_set,
                                                           uint64_t *accumulator)
{
    /* RPN equation: B 1 READ B 0 READ FADD 4 FDIV 100 UMUL $GpuCoreClocks FDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 0];
    double tmp2 = tmp0 + tmp1;
    double tmp3 = tmp2;
    double tmp4 = 4;
    double tmp5 = tmp4 ? tmp3 / tmp4 : 0;
    uint64_t tmp6 = tmp5 * 100;
    double tmp7 = tmp6;
    double tmp8 = mtlgt3__ext18__gpu_core_clocks__read(perf, metric_set, accumulator);
    double tmp9 = tmp8 ? tmp7 / tmp8 : 0;

    return tmp9;
}

/* Ext93 :: XVE DATAPORT REGISTER RESPONSE COUNT XECORE0 */
uint64_t
mtlgt3__ext93__xve_dataport_register_response_count_xecore0__read(const struct intel_perf *perf,
                                                                  const struct intel_perf_metric_set *metric_set,
                                                                  uint64_t *accumulator)
{
    /* RPN equation: B 4 READ B 5 READ UADD B 6 READ UADD B 7 READ UADD 2 UDIV */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp6 = tmp4 + tmp5;
    uint64_t tmp7 = tmp6;
    uint64_t tmp8 = 2;
    uint64_t tmp9 = tmp8 ? tmp7 / tmp8 : 0;

    return tmp9;
}

/* Ext128 :: URB READ SLICE0 */
uint64_t
mtlgt3__ext128__urb_read_slice0__read(const struct intel_perf *perf,
                                      const struct intel_perf_metric_set *metric_set,
                                      uint64_t *accumulator)
{
    /* RPN equation: B 0 READ B 1 READ UADD B 2 READ UADD B 3 READ UADD B 4 READ UADD B 5 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp6 = tmp4 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp8 = tmp6 + tmp7;
    uint64_t tmp9 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp10 = tmp8 + tmp9;

    return tmp10;
}

/* Ext128 :: URB WRITE SLICE0 */
uint64_t
mtlgt3__ext128__urb_write_slice0__read(const struct intel_perf *perf,
                                       const struct intel_perf_metric_set *metric_set,
                                       uint64_t *accumulator)
{
    /* RPN equation: B 6 READ B 7 READ UADD C 0 READ UADD C 1 READ UADD C 2 READ UADD C 3 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp6 = tmp4 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp8 = tmp6 + tmp7;
    uint64_t tmp9 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp10 = tmp8 + tmp9;

    return tmp10;
}

/* Ext128 :: URB CROSS SLICE READ SLICE0 */
uint64_t
mtlgt3__ext128__urb_cross_slice_read_slice0__read(const struct intel_perf *perf,
                                                  const struct intel_perf_metric_set *metric_set,
                                                  uint64_t *accumulator)
{
    /* RPN equation: C 4 READ C 5 READ UADD C 6 READ UADD C 7 READ UADD */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp2 = tmp0 + tmp1;
    uint64_t tmp3 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp4 = tmp2 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp6 = tmp4 + tmp5;

    return tmp6;
}

/* Ext130 :: EARLY DEPTH STENCIL TEST FAIL NP ZPIPE0 */
uint64_t
mtlgt3__ext130__early_depth_stencil_test_fail_np_zpipe0__read(const struct intel_perf *perf,
                                                              const struct intel_perf_metric_set *metric_set,
                                                              uint64_t *accumulator)
{
    /* RPN equation: C 3 READ 2 C 4 READ UMUL UADD 4 C 5 READ UMUL UADD 8 C 6 READ UMUL UADD 16 C 7 READ UMUL UADD B 0 READ 2 B 1 READ UMUL UADD 4 B 2 READ UMUL UADD 8 B 3 READ UMUL UADD 16 B 4 READ UMUL UADD USUB */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp2 = 2 * tmp1;
    uint64_t tmp3 = tmp0 + tmp2;
    uint64_t tmp4 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp5 = 4 * tmp4;
    uint64_t tmp6 = tmp3 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp8 = 8 * tmp7;
    uint64_t tmp9 = tmp6 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp11 = 16 * tmp10;
    uint64_t tmp12 = tmp9 + tmp11;
    uint64_t tmp13 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp14 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp15 = 2 * tmp14;
    uint64_t tmp16 = tmp13 + tmp15;
    uint64_t tmp17 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp18 = 4 * tmp17;
    uint64_t tmp19 = tmp16 + tmp18;
    uint64_t tmp20 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp21 = 8 * tmp20;
    uint64_t tmp22 = tmp19 + tmp21;
    uint64_t tmp23 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp24 = 16 * tmp23;
    uint64_t tmp25 = tmp22 + tmp24;
    uint64_t tmp26 = tmp12 - tmp25;

    return tmp26;
}

/* Ext134 :: HIZ DEPTH TEST AMBIG NP ZPIPE0 */
uint64_t
mtlgt3__ext134__hiz_depth_test_ambig_np_zpipe0__read(const struct intel_perf *perf,
                                                     const struct intel_perf_metric_set *metric_set,
                                                     uint64_t *accumulator)
{
    /* RPN equation: C 7 READ 2 C 6 READ UMUL UADD 4 C 5 READ UMUL UADD 8 C 4 READ UMUL UADD 16 C 3 READ UMUL UADD 32 C 2 READ UMUL UADD 64 C 1 READ UMUL UADD 128 C 0 READ UMUL UADD 256 B 5 READ UMUL UADD 512 B 6 READ UMUL UADD 1024 B 7 READ UMUL UADD */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp2 = 2 * tmp1;
    uint64_t tmp3 = tmp0 + tmp2;
    uint64_t tmp4 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp5 = 4 * tmp4;
    uint64_t tmp6 = tmp3 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp8 = 8 * tmp7;
    uint64_t tmp9 = tmp6 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp11 = 16 * tmp10;
    uint64_t tmp12 = tmp9 + tmp11;
    uint64_t tmp13 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp14 = 32 * tmp13;
    uint64_t tmp15 = tmp12 + tmp14;
    uint64_t tmp16 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp17 = 64 * tmp16;
    uint64_t tmp18 = tmp15 + tmp17;
    uint64_t tmp19 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp20 = 128 * tmp19;
    uint64_t tmp21 = tmp18 + tmp20;
    uint64_t tmp22 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp23 = 256 * tmp22;
    uint64_t tmp24 = tmp21 + tmp23;
    uint64_t tmp25 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp26 = 512 * tmp25;
    uint64_t tmp27 = tmp24 + tmp26;
    uint64_t tmp28 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp29 = 1024 * tmp28;
    uint64_t tmp30 = tmp27 + tmp29;

    return tmp30;
}

/* Ext138 :: HIZ DEPTH TEST AMBIG P ZPIPE0 */
uint64_t
mtlgt3__ext138__hiz_depth_test_ambig_p_zpipe0__read(const struct intel_perf *perf,
                                                    const struct intel_perf_metric_set *metric_set,
                                                    uint64_t *accumulator)
{
    /* RPN equation: B 5 READ 2 B 6 READ UMUL UADD 4 B 7 READ UMUL UADD 8 C 0 READ UMUL UADD 16 C 1 READ UMUL UADD 32 C 2 READ UMUL UADD 64 C 3 READ UMUL UADD 128 C 4 READ UMUL UADD 256 C 5 READ UMUL UADD 512 C 6 READ UMUL UADD 1024 C 7 READ UMUL UADD */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp2 = 2 * tmp1;
    uint64_t tmp3 = tmp0 + tmp2;
    uint64_t tmp4 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp5 = 4 * tmp4;
    uint64_t tmp6 = tmp3 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp8 = 8 * tmp7;
    uint64_t tmp9 = tmp6 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp11 = 16 * tmp10;
    uint64_t tmp12 = tmp9 + tmp11;
    uint64_t tmp13 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp14 = 32 * tmp13;
    uint64_t tmp15 = tmp12 + tmp14;
    uint64_t tmp16 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp17 = 64 * tmp16;
    uint64_t tmp18 = tmp15 + tmp17;
    uint64_t tmp19 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp20 = 128 * tmp19;
    uint64_t tmp21 = tmp18 + tmp20;
    uint64_t tmp22 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp23 = 256 * tmp22;
    uint64_t tmp24 = tmp21 + tmp23;
    uint64_t tmp25 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp26 = 512 * tmp25;
    uint64_t tmp27 = tmp24 + tmp26;
    uint64_t tmp28 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp29 = 1024 * tmp28;
    uint64_t tmp30 = tmp27 + tmp29;

    return tmp30;
}

/* Ext225 :: PIXEL 2x2 LIT POST RASTERIZER EARLY DEPTH SLICE0 */
uint64_t
mtlgt3__ext225__pixel_2x2_lit_post_rasterizer_early_depth_slice0__read(const struct intel_perf *perf,
                                                                       const struct intel_perf_metric_set *metric_set,
                                                                       uint64_t *accumulator)
{
    /* RPN equation: 1 C 1 READ UMUL 2 B 0 READ UMUL UADD 4 B 1 READ UMUL UADD 8 B 2 READ UMUL UADD 16 B 3 READ UMUL UADD 32 B 4 READ UMUL UADD 64 B 5 READ UMUL UADD 128 B 6 READ UMUL UADD 256 B 7 READ UMUL UADD */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp1 = 1 * tmp0;
    uint64_t tmp2 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp3 = 2 * tmp2;
    uint64_t tmp4 = tmp1 + tmp3;
    uint64_t tmp5 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp6 = 4 * tmp5;
    uint64_t tmp7 = tmp4 + tmp6;
    uint64_t tmp8 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp9 = 8 * tmp8;
    uint64_t tmp10 = tmp7 + tmp9;
    uint64_t tmp11 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp12 = 16 * tmp11;
    uint64_t tmp13 = tmp10 + tmp12;
    uint64_t tmp14 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp15 = 32 * tmp14;
    uint64_t tmp16 = tmp13 + tmp15;
    uint64_t tmp17 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp18 = 64 * tmp17;
    uint64_t tmp19 = tmp16 + tmp18;
    uint64_t tmp20 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp21 = 128 * tmp20;
    uint64_t tmp22 = tmp19 + tmp21;
    uint64_t tmp23 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp24 = 256 * tmp23;
    uint64_t tmp25 = tmp22 + tmp24;

    return tmp25;
}

/* Ext229 :: SLM BANK CONFLICT COUNT XECORE1 */
uint64_t
mtlgt3__ext229__slm_bank_conflict_count_xecore1__read(const struct intel_perf *perf,
                                                      const struct intel_perf_metric_set *metric_set,
                                                      uint64_t *accumulator)
{
    /* RPN equation: C 0 READ 2 C 1 READ UMUL UADD 4 C 2 READ UMUL UADD 8 C 3 READ UMUL UADD C 4 READ UADD 2 C 5 READ UMUL UADD 4 C 6 READ UMUL UADD 8 C 7 READ UMUL UADD */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp2 = 2 * tmp1;
    uint64_t tmp3 = tmp0 + tmp2;
    uint64_t tmp4 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp5 = 4 * tmp4;
    uint64_t tmp6 = tmp3 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp8 = 8 * tmp7;
    uint64_t tmp9 = tmp6 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp11 = tmp9 + tmp10;
    uint64_t tmp12 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp13 = 2 * tmp12;
    uint64_t tmp14 = tmp11 + tmp13;
    uint64_t tmp15 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp16 = 4 * tmp15;
    uint64_t tmp17 = tmp14 + tmp16;
    uint64_t tmp18 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp19 = 8 * tmp18;
    uint64_t tmp20 = tmp17 + tmp19;

    return tmp20;
}

/* Ext231 :: SLM BANK CONFLICT COUNT XECORE2 */
uint64_t
mtlgt3__ext231__slm_bank_conflict_count_xecore2__read(const struct intel_perf *perf,
                                                      const struct intel_perf_metric_set *metric_set,
                                                      uint64_t *accumulator)
{
    /* RPN equation: B 0 READ 2 B 1 READ UMUL UADD 4 B 2 READ UMUL UADD 8 B 3 READ UMUL UADD B 4 READ UADD 2 B 5 READ UMUL UADD 4 B 6 READ UMUL UADD 8 B 7 READ UMUL UADD */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp2 = 2 * tmp1;
    uint64_t tmp3 = tmp0 + tmp2;
    uint64_t tmp4 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp5 = 4 * tmp4;
    uint64_t tmp6 = tmp3 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp8 = 8 * tmp7;
    uint64_t tmp9 = tmp6 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp11 = tmp9 + tmp10;
    uint64_t tmp12 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp13 = 2 * tmp12;
    uint64_t tmp14 = tmp11 + tmp13;
    uint64_t tmp15 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp16 = 4 * tmp15;
    uint64_t tmp17 = tmp14 + tmp16;
    uint64_t tmp18 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp19 = 8 * tmp18;
    uint64_t tmp20 = tmp17 + tmp19;

    return tmp20;
}

/* Ext508 :: SLM BYTE READ BANK0 XECORE0 */
uint64_t
mtlgt3__ext508__slm_byte_read_bank0_xecore0__read(const struct intel_perf *perf,
                                                  const struct intel_perf_metric_set *metric_set,
                                                  uint64_t *accumulator)
{
    /* RPN equation: B 3 READ 2 C 7 READ UMUL UADD 4 C 6 READ UMUL UADD 8 C 5 READ UMUL UADD 16 C 4 READ UMUL UADD 32 C 3 READ UMUL UADD 64 C 2 READ UMUL UADD */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp2 = 2 * tmp1;
    uint64_t tmp3 = tmp0 + tmp2;
    uint64_t tmp4 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp5 = 4 * tmp4;
    uint64_t tmp6 = tmp3 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp8 = 8 * tmp7;
    uint64_t tmp9 = tmp6 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp11 = 16 * tmp10;
    uint64_t tmp12 = tmp9 + tmp11;
    uint64_t tmp13 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp14 = 32 * tmp13;
    uint64_t tmp15 = tmp12 + tmp14;
    uint64_t tmp16 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp17 = 64 * tmp16;
    uint64_t tmp18 = tmp15 + tmp17;

    return tmp18;
}

/* Ext508 :: SLM BYTE READ BANK0 XECORE1 */
uint64_t
mtlgt3__ext508__slm_byte_read_bank0_xecore1__read(const struct intel_perf *perf,
                                                  const struct intel_perf_metric_set *metric_set,
                                                  uint64_t *accumulator)
{
    /* RPN equation: B 2 READ 2 C 1 READ UMUL UADD 4 C 0 READ UMUL UADD 8 B 7 READ UMUL UADD 16 B 6 READ UMUL UADD 32 B 5 READ UMUL UADD 64 B 4 READ UMUL UADD */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp2 = 2 * tmp1;
    uint64_t tmp3 = tmp0 + tmp2;
    uint64_t tmp4 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp5 = 4 * tmp4;
    uint64_t tmp6 = tmp3 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp8 = 8 * tmp7;
    uint64_t tmp9 = tmp6 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp11 = 16 * tmp10;
    uint64_t tmp12 = tmp9 + tmp11;
    uint64_t tmp13 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp14 = 32 * tmp13;
    uint64_t tmp15 = tmp12 + tmp14;
    uint64_t tmp16 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp17 = 64 * tmp16;
    uint64_t tmp18 = tmp15 + tmp17;

    return tmp18;
}

/* Ext512 :: SLM BYTE READ BANK0 XECORE4 */
uint64_t
mtlgt3__ext512__slm_byte_read_bank0_xecore4__read(const struct intel_perf *perf,
                                                  const struct intel_perf_metric_set *metric_set,
                                                  uint64_t *accumulator)
{
    /* RPN equation: B 2 READ 2 C 7 READ UMUL UADD 4 C 6 READ UMUL UADD 8 C 5 READ UMUL UADD 16 C 4 READ UMUL UADD 32 C 3 READ UMUL UADD 64 C 2 READ UMUL UADD */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp2 = 2 * tmp1;
    uint64_t tmp3 = tmp0 + tmp2;
    uint64_t tmp4 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp5 = 4 * tmp4;
    uint64_t tmp6 = tmp3 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp8 = 8 * tmp7;
    uint64_t tmp9 = tmp6 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp11 = 16 * tmp10;
    uint64_t tmp12 = tmp9 + tmp11;
    uint64_t tmp13 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp14 = 32 * tmp13;
    uint64_t tmp15 = tmp12 + tmp14;
    uint64_t tmp16 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp17 = 64 * tmp16;
    uint64_t tmp18 = tmp15 + tmp17;

    return tmp18;
}

/* Ext512 :: SLM BYTE READ BANK0 XECORE5 */
uint64_t
mtlgt3__ext512__slm_byte_read_bank0_xecore5__read(const struct intel_perf *perf,
                                                  const struct intel_perf_metric_set *metric_set,
                                                  uint64_t *accumulator)
{
    /* RPN equation: B 3 READ 2 C 1 READ UMUL UADD 4 C 0 READ UMUL UADD 8 B 7 READ UMUL UADD 16 B 6 READ UMUL UADD 32 B 5 READ UMUL UADD 64 B 4 READ UMUL UADD */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp2 = 2 * tmp1;
    uint64_t tmp3 = tmp0 + tmp2;
    uint64_t tmp4 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp5 = 4 * tmp4;
    uint64_t tmp6 = tmp3 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp8 = 8 * tmp7;
    uint64_t tmp9 = tmp6 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp11 = 16 * tmp10;
    uint64_t tmp12 = tmp9 + tmp11;
    uint64_t tmp13 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp14 = 32 * tmp13;
    uint64_t tmp15 = tmp12 + tmp14;
    uint64_t tmp16 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp17 = 64 * tmp16;
    uint64_t tmp18 = tmp15 + tmp17;

    return tmp18;
}

/* Ext516 :: LOAD STORE CACHE BYTE READ BANK0 XECORE0 */
uint64_t
mtlgt3__ext516__load_store_cache_byte_read_bank0_xecore0__read(const struct intel_perf *perf,
                                                               const struct intel_perf_metric_set *metric_set,
                                                               uint64_t *accumulator)
{
    /* RPN equation: C 7 READ 2 B 7 READ UMUL UADD 4 C 0 READ UMUL UADD 8 C 1 READ UMUL UADD 16 C 2 READ UMUL UADD 32 C 3 READ UMUL UADD 64 C 4 READ UMUL UADD 128 C 5 READ UMUL UADD */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp2 = 2 * tmp1;
    uint64_t tmp3 = tmp0 + tmp2;
    uint64_t tmp4 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp5 = 4 * tmp4;
    uint64_t tmp6 = tmp3 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp8 = 8 * tmp7;
    uint64_t tmp9 = tmp6 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp11 = 16 * tmp10;
    uint64_t tmp12 = tmp9 + tmp11;
    uint64_t tmp13 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp14 = 32 * tmp13;
    uint64_t tmp15 = tmp12 + tmp14;
    uint64_t tmp16 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp17 = 64 * tmp16;
    uint64_t tmp18 = tmp15 + tmp17;
    uint64_t tmp19 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp20 = 128 * tmp19;
    uint64_t tmp21 = tmp18 + tmp20;

    return tmp21;
}

/* Ext516 :: LOAD STORE CACHE BYTE READ BANK1 XECORE0 */
uint64_t
mtlgt3__ext516__load_store_cache_byte_read_bank1_xecore0__read(const struct intel_perf *perf,
                                                               const struct intel_perf_metric_set *metric_set,
                                                               uint64_t *accumulator)
{
    /* RPN equation: C 6 READ 2 B 0 READ UMUL UADD 4 B 1 READ UMUL UADD 8 B 2 READ UMUL UADD 16 B 3 READ UMUL UADD 32 B 4 READ UMUL UADD 64 B 5 READ UMUL UADD 128 B 6 READ UMUL UADD */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp2 = 2 * tmp1;
    uint64_t tmp3 = tmp0 + tmp2;
    uint64_t tmp4 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp5 = 4 * tmp4;
    uint64_t tmp6 = tmp3 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp8 = 8 * tmp7;
    uint64_t tmp9 = tmp6 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp11 = 16 * tmp10;
    uint64_t tmp12 = tmp9 + tmp11;
    uint64_t tmp13 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp14 = 32 * tmp13;
    uint64_t tmp15 = tmp12 + tmp14;
    uint64_t tmp16 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp17 = 64 * tmp16;
    uint64_t tmp18 = tmp15 + tmp17;
    uint64_t tmp19 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp20 = 128 * tmp19;
    uint64_t tmp21 = tmp18 + tmp20;

    return tmp21;
}

/* Ext517 :: LOAD STORE CACHE BYTE WRITE BANK0 XECORE0 */
uint64_t
mtlgt3__ext517__load_store_cache_byte_write_bank0_xecore0__read(const struct intel_perf *perf,
                                                                const struct intel_perf_metric_set *metric_set,
                                                                uint64_t *accumulator)
{
    /* RPN equation: C 0 READ 2 B 7 READ UMUL UADD 4 B 6 READ UMUL UADD 8 B 5 READ UMUL UADD 16 B 4 READ UMUL UADD 32 B 3 READ UMUL UADD 64 B 2 READ UMUL UADD 128 B 1 READ UMUL UADD */
    uint64_t tmp0 = accumulator[metric_set->c_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->b_offset + 7];
    uint64_t tmp2 = 2 * tmp1;
    uint64_t tmp3 = tmp0 + tmp2;
    uint64_t tmp4 = accumulator[metric_set->b_offset + 6];
    uint64_t tmp5 = 4 * tmp4;
    uint64_t tmp6 = tmp3 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->b_offset + 5];
    uint64_t tmp8 = 8 * tmp7;
    uint64_t tmp9 = tmp6 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->b_offset + 4];
    uint64_t tmp11 = 16 * tmp10;
    uint64_t tmp12 = tmp9 + tmp11;
    uint64_t tmp13 = accumulator[metric_set->b_offset + 3];
    uint64_t tmp14 = 32 * tmp13;
    uint64_t tmp15 = tmp12 + tmp14;
    uint64_t tmp16 = accumulator[metric_set->b_offset + 2];
    uint64_t tmp17 = 64 * tmp16;
    uint64_t tmp18 = tmp15 + tmp17;
    uint64_t tmp19 = accumulator[metric_set->b_offset + 1];
    uint64_t tmp20 = 128 * tmp19;
    uint64_t tmp21 = tmp18 + tmp20;

    return tmp21;
}

/* Ext517 :: LOAD STORE CACHE BYTE WRITE BANK1 XECORE0 */
uint64_t
mtlgt3__ext517__load_store_cache_byte_write_bank1_xecore0__read(const struct intel_perf *perf,
                                                                const struct intel_perf_metric_set *metric_set,
                                                                uint64_t *accumulator)
{
    /* RPN equation: B 0 READ 2 C 7 READ UMUL UADD 4 C 6 READ UMUL UADD 8 C 5 READ UMUL UADD 16 C 4 READ UMUL UADD 32 C 3 READ UMUL UADD 64 C 2 READ UMUL UADD 128 C 1 READ UMUL UADD */
    uint64_t tmp0 = accumulator[metric_set->b_offset + 0];
    uint64_t tmp1 = accumulator[metric_set->c_offset + 7];
    uint64_t tmp2 = 2 * tmp1;
    uint64_t tmp3 = tmp0 + tmp2;
    uint64_t tmp4 = accumulator[metric_set->c_offset + 6];
    uint64_t tmp5 = 4 * tmp4;
    uint64_t tmp6 = tmp3 + tmp5;
    uint64_t tmp7 = accumulator[metric_set->c_offset + 5];
    uint64_t tmp8 = 8 * tmp7;
    uint64_t tmp9 = tmp6 + tmp8;
    uint64_t tmp10 = accumulator[metric_set->c_offset + 4];
    uint64_t tmp11 = 16 * tmp10;
    uint64_t tmp12 = tmp9 + tmp11;
    uint64_t tmp13 = accumulator[metric_set->c_offset + 3];
    uint64_t tmp14 = 32 * tmp13;
    uint64_t tmp15 = tmp12 + tmp14;
    uint64_t tmp16 = accumulator[metric_set->c_offset + 2];
    uint64_t tmp17 = 64 * tmp16;
    uint64_t tmp18 = tmp15 + tmp17;
    uint64_t tmp19 = accumulator[metric_set->c_offset + 1];
    uint64_t tmp20 = 128 * tmp19;
    uint64_t tmp21 = tmp18 + tmp20;

    return tmp21;
}
