#include "main.h"
#include "sysdeps.h"
#include "hatari-glue.h"
#include "maccess.h"
#include "memory.h"
#include "custom.h"
#include "newcpu.h"
#include "cpu_prefetch.h"
#include "cputbl.h"
#include "debugmem.h"
#define SET_ALWAYS_CFLG(x) SET_CFLG(x)
#define SET_ALWAYS_NFLG(x) SET_NFLG(x)
/* OR.B #<data>.B,Dn */
void REGPARAM2 op_0000_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 8;  
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 8 (2/0) */
/* 4 0,0   */

/* OR.B #<data>.B,(An) */
void REGPARAM2 op_0010_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* OR.B #<data>.B,(An)+ */
void REGPARAM2 op_0018_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* OR.B #<data>.B,-(An) */
void REGPARAM2 op_0020_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 18; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce000_internal(2);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 18 (3/1) */
/* 4 0,0   */

/* OR.B #<data>.B,(d16,An) */
void REGPARAM2 op_0028_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 20; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* OR.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 op_0030_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 22; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 22 (4/1) */
/* 6 4,0   */

/* OR.B #<data>.B,(xxx).W */
void REGPARAM2 op_0038_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 1;
	CurrentInstrCycles = 20; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 0);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* OR.B #<data>.B,(xxx).L */
void REGPARAM2 op_0039_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 1;
	CurrentInstrCycles = 24; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(6) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	dsta |= get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, pcoffset);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(8);
	return;
}
/* 24 (5/1) */
/* 8 0,0   */

/* ORSR.B #<data>.W */
void REGPARAM2 op_003c_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 4;
	CurrentInstrCycles = 16; 
	MakeSR();
	uae_s16 src = regs.irc;
	src &= 0xFF;
	do_cycles_ce000_internal(8);
	regs.sr |= src;
	MakeFromSR();
	m68k_incpci(4);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (2/0) */
/* 4 0,0   */

/* OR.W #<data>.W,Dn */
void REGPARAM2 op_0040_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 8 (2/0) */
/* 4 0,0   */

/* OR.W #<data>.W,(An) */
void REGPARAM2 op_0050_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* OR.W #<data>.W,(An)+ */
void REGPARAM2 op_0058_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_areg(regs, dstreg) += 2 + 0;
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) += 2 + 0;
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, dstreg) += 2;
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* OR.W #<data>.W,-(An) */
void REGPARAM2 op_0060_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	do_cycles_ce000_internal(2);
	if (dsta & 1) {
		m68k_areg(regs, dstreg) = dsta;
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 18 (3/1) */
/* 4 0,0   */

/* OR.W #<data>.W,(d16,An) */
void REGPARAM2 op_0068_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* OR.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_0070_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 22; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 22 (4/1) */
/* 6 4,0   */

/* OR.W #<data>.W,(xxx).W */
void REGPARAM2 op_0078_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 1;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* OR.W #<data>.W,(xxx).L */
void REGPARAM2 op_0079_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 1;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(6) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	dsta |= get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, pcoffset);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(8);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(8);
	return;
}
/* 24 (5/1) */
/* 8 0,0   */

/* ORSR.W #<data>.W */
void REGPARAM2 op_007c_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 4;
	CurrentInstrCycles = 16; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	MakeSR();
	uae_s16 src = regs.irc;
	do_cycles_ce000_internal(8);
	regs.sr |= src;
	MakeFromSR();
	m68k_incpci(4);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (2/0) */
/* 4 0,0   */

/* OR.L #<data>.L,Dn */
void REGPARAM2 op_0080_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 16; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	ipl_fetch_next_pre();
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_dreg(regs, dstreg) = (src);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	do_cycles_ce000_internal(4);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	return;
}
/* 16 (3/0) */
/* 6 0,0   */

/* OR.L #<data>.L,(An) */
void REGPARAM2 op_0090_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 28 (5/2) */
/* 6 0,0   */

/* OR.L #<data>.L,(An)+ */
void REGPARAM2 op_0098_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, dstreg) += 4;
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 28 (5/2) */
/* 6 0,0   */

/* OR.L #<data>.L,-(An) */
void REGPARAM2 op_00a0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 30; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	do_cycles_ce000_internal(2);
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 30 (5/2) */
/* 6 0,0   */

/* OR.L #<data>.L,(d16,An) */
void REGPARAM2 op_00a8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, -2);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return;
	}
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	m68k_incpci(8);
	return;
}
/* 32 (6/2) */
/* 8 0,0   */

/* OR.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 op_00b0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 34; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(8));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, -2);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return;
	}
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	m68k_incpci(8);
	return;
}
/* 34 (6/2) */
/* 8 4,0   */

/* OR.L #<data>.L,(xxx).W */
void REGPARAM2 op_00b8_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 1;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(8);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return;
	}
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	m68k_incpci(8);
	return;
}
/* 32 (6/2) */
/* 8 0,0   */

/* OR.L #<data>.L,(xxx).L */
void REGPARAM2 op_00b9_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 1;
	CurrentInstrCycles = 36; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(8) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, -2);
		return;
	}
	dsta |= get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 10, pcoffset);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(10);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(12);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 12, pcoffset);
		return;
	}
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(12);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(12);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	m68k_incpci(10);
	return;
}
/* 36 (7/2) */
/* 10 0,0   */

/* BTST.L Dn,Dn */
void REGPARAM2 op_0100_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 6;  
	ipl_fetch_next_pre();
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 31;
	do_cycles_ce000_internal(2);
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(2);
	return;
}
/* 6 (1/0) */
/* 2 0,0   */

/* MVPMR.W (d16,An),Dn */
void REGPARAM2 op_0108_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 29;
	CurrentInstrCycles = 16; 
	uaecptr mempa = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	uae_u16 val  = (x_get_byte(mempa) & 0xff) << 8;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		opcode |= 0x10000;
		exception2_read(opcode, mempa + 0, 0x0, 1);
		return;
	}
	val |= (x_get_byte(mempa + 2) & 0xff);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, mempa + 2, 0x0, 1);
		return;
	}
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((val) & 0xffff);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (4/0) */
/* 4 0,0   */

/* BTST.B Dn,(An) */
void REGPARAM2 op_0110_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 8;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	m68k_incpci(2);
	return;
}
/* 8 (2/0) */
/* 2 0,0   */

/* BTST.B Dn,(An)+ */
void REGPARAM2 op_0118_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 8;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	m68k_incpci(2);
	return;
}
/* 8 (2/0) */
/* 2 0,0   */

/* BTST.B Dn,-(An) */
void REGPARAM2 op_0120_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 10; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce000_internal(2);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	m68k_incpci(2);
	return;
}
/* 10 (2/0) */
/* 2 0,0   */

/* BTST.B Dn,(d16,An) */
void REGPARAM2 op_0128_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 12 (3/0) */
/* 4 0,0   */

/* BTST.B Dn,(d8,An,Xn) */
void REGPARAM2 op_0130_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 14; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 14 (3/0) */
/* 4 4,0   */

/* BTST.B Dn,(xxx).W */
void REGPARAM2 op_0138_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 21;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 12 (3/0) */
/* 4 0,0   */

/* BTST.B Dn,(xxx).L */
void REGPARAM2 op_0139_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 21;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	dsta |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 16 (4/0) */
/* 6 0,0   */

/* BTST.B Dn,(d16,PC) */
void REGPARAM2 op_013a_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = 2;
	OpcodeFamily = 21;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_getpci() + 2;
	dsta += (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, dsta + 0, 0x0, 2);
		return;
	}
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 12 (3/0) */
/* 4 0,0   */

/* BTST.B Dn,(d8,PC,Xn) */
void REGPARAM2 op_013b_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = 3;
	OpcodeFamily = 21;
	CurrentInstrCycles = 14; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	uaecptr tmppc = m68k_getpci() + 2;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(tmppc, get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, dsta + 0, 0x0, 2);
		return;
	}
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 14 (3/0) */
/* 4 4,0   */

/* BTST.B Dn,#<data>.B */
void REGPARAM2 op_013c_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 21;
	CurrentInstrCycles = 10; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_s8 dst = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	src &= 7;
	ipl_fetch_next_pre();
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	do_cycles_ce000_internal(2);
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(4);
	return;
}
/* 10 (2/0) */
/* 4 0,0   */

/* BCHG.L Dn,Dn */
void REGPARAM2 op_0140_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 6;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	ipl_fetch_next_pre();
	regs.ir = regs.irc;
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 31;
	do_cycles_ce000_internal(2);
	if (src > 15) do_cycles_ce000_internal(2);
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	m68k_dreg(regs, dstreg) = (dst);
	m68k_incpci(2);
	return;
}
/* 6 (1/0) */
/* 2 0,0   */

/* MVPMR.L (d16,An),Dn */
void REGPARAM2 op_0148_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 29;
	CurrentInstrCycles = 24; 
	uaecptr mempa = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	uae_u32 val  = (x_get_byte(mempa) & 0xff) << 24;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		opcode |= 0x10000;
		exception2_read(opcode, mempa + 0, 0x0, 1);
		return;
	}
	val |= (x_get_byte(mempa + 2) & 0xff) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, mempa + 2, 0x0, 1);
		return;
	}
	ipl_fetch_now();
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & 0x0000ffff) | val;
	val |= (x_get_byte(mempa + 4) & 0xff) << 8;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		opcode |= 0x10000;
		exception2_read(opcode, mempa + 4, 0x0, 1);
		return;
	}
	val |= (x_get_byte(mempa + 6) & 0xff);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, mempa + 6, 0x0, 1);
		return;
	}
	m68k_dreg(regs, dstreg) = (val);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 24 (6/0) */
/* 4 0,0   */

/* BCHG.B Dn,(An) */
void REGPARAM2 op_0150_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	regs.ir = regs.irc;
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(2);
	return;
}
/* 12 (2/1) */
/* 2 0,0   */

/* BCHG.B Dn,(An)+ */
void REGPARAM2 op_0158_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(2);
	return;
}
/* 12 (2/1) */
/* 2 0,0   */

/* BCHG.B Dn,-(An) */
void REGPARAM2 op_0160_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 14; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce000_internal(2);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(2);
	return;
}
/* 14 (2/1) */
/* 2 0,0   */

/* BCHG.B Dn,(d16,An) */
void REGPARAM2 op_0168_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* BCHG.B Dn,(d8,An,Xn) */
void REGPARAM2 op_0170_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 18; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 18 (3/1) */
/* 4 4,0   */

/* BCHG.B Dn,(xxx).W */
void REGPARAM2 op_0178_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 22;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* BCHG.B Dn,(xxx).L */
void REGPARAM2 op_0179_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 22;
	CurrentInstrCycles = 20; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	dsta |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* BCLR.L Dn,Dn */
void REGPARAM2 op_0180_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 8;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	ipl_fetch_next_pre();
	regs.ir = regs.irc;
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 31;
	do_cycles_ce000_internal(2);
	if (src > 15) do_cycles_ce000_internal(2);
	do_cycles_ce000_internal(2);
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_dreg(regs, dstreg) = (dst);
	m68k_incpci(2);
	return;
}
/* 8 (1/0) */
/* 2 0,0   */

/* MVPRM.W Dn,(d16,An) */
void REGPARAM2 op_0188_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 28;
	CurrentInstrCycles = 16; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr mempa = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	x_put_byte(mempa, src >> 8);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		opcode |= 0x10000;
		uae_u16 val = src;
		exception2_write(opcode, mempa + 0, 0x100, val, 1);
		return;
	}
	x_put_byte(mempa + 2, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		uae_u16 val = src;
		exception2_write(opcode, mempa + 2, 0x100, val, 1);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (2/2) */
/* 4 0,0   */

/* BCLR.B Dn,(An) */
void REGPARAM2 op_0190_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 14; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	regs.ir = regs.irc;
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	do_cycles_ce000_internal(2);
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(2);
	return;
}
/* 14 (2/1) */
/* 2 0,0   */

/* BCLR.B Dn,(An)+ */
void REGPARAM2 op_0198_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 14; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	do_cycles_ce000_internal(2);
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(2);
	return;
}
/* 14 (2/1) */
/* 2 0,0   */

/* BCLR.B Dn,-(An) */
void REGPARAM2 op_01a0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce000_internal(2);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	do_cycles_ce000_internal(2);
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(2);
	return;
}
/* 16 (2/1) */
/* 2 0,0   */

/* BCLR.B Dn,(d16,An) */
void REGPARAM2 op_01a8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 18; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	do_cycles_ce000_internal(2);
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 18 (3/1) */
/* 4 0,0   */

/* BCLR.B Dn,(d8,An,Xn) */
void REGPARAM2 op_01b0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 20; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	do_cycles_ce000_internal(2);
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 20 (3/1) */
/* 4 4,0   */

/* BCLR.B Dn,(xxx).W */
void REGPARAM2 op_01b8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 23;
	CurrentInstrCycles = 18; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	do_cycles_ce000_internal(2);
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 18 (3/1) */
/* 4 0,0   */

/* BCLR.B Dn,(xxx).L */
void REGPARAM2 op_01b9_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 23;
	CurrentInstrCycles = 22; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	dsta |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	do_cycles_ce000_internal(2);
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 22 (4/1) */
/* 6 0,0   */

/* BSET.L Dn,Dn */
void REGPARAM2 op_01c0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 6;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	ipl_fetch_next_pre();
	regs.ir = regs.irc;
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 31;
	do_cycles_ce000_internal(2);
	if (src > 15) do_cycles_ce000_internal(2);
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_dreg(regs, dstreg) = (dst);
	m68k_incpci(2);
	return;
}
/* 6 (1/0) */
/* 2 0,0   */

/* MVPRM.L Dn,(d16,An) */
void REGPARAM2 op_01c8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 28;
	CurrentInstrCycles = 24; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr mempa = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	x_put_byte(mempa, src >> 24);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		opcode |= 0x10000;
		uae_u16 val = src >> 16;
		exception2_write(opcode, mempa + 0, 0x100, val, 1);
		return;
	}
	x_put_byte(mempa + 2, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		uae_u16 val = src >> 16;
		exception2_write(opcode, mempa + 2, 0x100, val, 1);
		return;
	}
	x_put_byte(mempa + 4, src >> 8);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		opcode |= 0x10000;
		uae_u16 val = src >> 0;
		exception2_write(opcode, mempa + 4, 0x100, val, 1);
		return;
	}
	x_put_byte(mempa + 6, src); 
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		uae_u16 val = src >> 0;
		exception2_write(opcode, mempa + 6, 0x100, val, 1);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 24 (2/4) */
/* 4 0,0   */

/* BSET.B Dn,(An) */
void REGPARAM2 op_01d0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	regs.ir = regs.irc;
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(2);
	return;
}
/* 12 (2/1) */
/* 2 0,0   */

/* BSET.B Dn,(An)+ */
void REGPARAM2 op_01d8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(2);
	return;
}
/* 12 (2/1) */
/* 2 0,0   */

/* BSET.B Dn,-(An) */
void REGPARAM2 op_01e0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 14; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce000_internal(2);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(2);
	return;
}
/* 14 (2/1) */
/* 2 0,0   */

/* BSET.B Dn,(d16,An) */
void REGPARAM2 op_01e8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* BSET.B Dn,(d8,An,Xn) */
void REGPARAM2 op_01f0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 18; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 18 (3/1) */
/* 4 4,0   */

/* BSET.B Dn,(xxx).W */
void REGPARAM2 op_01f8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 24;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* BSET.B Dn,(xxx).L */
void REGPARAM2 op_01f9_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 24;
	CurrentInstrCycles = 20; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	dsta |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* AND.B #<data>.B,Dn */
void REGPARAM2 op_0200_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 8;  
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 8 (2/0) */
/* 4 0,0   */

/* AND.B #<data>.B,(An) */
void REGPARAM2 op_0210_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* AND.B #<data>.B,(An)+ */
void REGPARAM2 op_0218_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* AND.B #<data>.B,-(An) */
void REGPARAM2 op_0220_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 18; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce000_internal(2);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 18 (3/1) */
/* 4 0,0   */

/* AND.B #<data>.B,(d16,An) */
void REGPARAM2 op_0228_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 20; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* AND.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 op_0230_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 22; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 22 (4/1) */
/* 6 4,0   */

/* AND.B #<data>.B,(xxx).W */
void REGPARAM2 op_0238_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 2;
	CurrentInstrCycles = 20; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 0);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* AND.B #<data>.B,(xxx).L */
void REGPARAM2 op_0239_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 2;
	CurrentInstrCycles = 24; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(6) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	dsta |= get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, pcoffset);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(8);
	return;
}
/* 24 (5/1) */
/* 8 0,0   */

/* ANDSR.B #<data>.W */
void REGPARAM2 op_023c_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 5;
	CurrentInstrCycles = 16; 
	MakeSR();
	uae_s16 src = regs.irc;
	src &= 0xFF;
	src |= 0xff00;
	do_cycles_ce000_internal(8);
	regs.sr &= src;
	MakeFromSR();
	m68k_incpci(4);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (2/0) */
/* 4 0,0   */

/* AND.W #<data>.W,Dn */
void REGPARAM2 op_0240_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 8 (2/0) */
/* 4 0,0   */

/* AND.W #<data>.W,(An) */
void REGPARAM2 op_0250_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* AND.W #<data>.W,(An)+ */
void REGPARAM2 op_0258_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_areg(regs, dstreg) += 2 + 0;
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) += 2 + 0;
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, dstreg) += 2;
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* AND.W #<data>.W,-(An) */
void REGPARAM2 op_0260_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	do_cycles_ce000_internal(2);
	if (dsta & 1) {
		m68k_areg(regs, dstreg) = dsta;
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 18 (3/1) */
/* 4 0,0   */

/* AND.W #<data>.W,(d16,An) */
void REGPARAM2 op_0268_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* AND.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_0270_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 22; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 22 (4/1) */
/* 6 4,0   */

/* AND.W #<data>.W,(xxx).W */
void REGPARAM2 op_0278_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 2;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* AND.W #<data>.W,(xxx).L */
void REGPARAM2 op_0279_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 2;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(6) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	dsta |= get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, pcoffset);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(8);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(8);
	return;
}
/* 24 (5/1) */
/* 8 0,0   */

/* ANDSR.W #<data>.W */
void REGPARAM2 op_027c_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 5;
	CurrentInstrCycles = 16; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	MakeSR();
	uae_s16 src = regs.irc;
	do_cycles_ce000_internal(8);
	regs.sr &= src;
	MakeFromSR();
	m68k_incpci(4);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (2/0) */
/* 4 0,0   */

/* AND.L #<data>.L,Dn */
void REGPARAM2 op_0280_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 16; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	ipl_fetch_next_pre();
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_dreg(regs, dstreg) = (src);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	do_cycles_ce000_internal(4);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	return;
}
/* 16 (3/0) */
/* 6 0,0   */

/* AND.L #<data>.L,(An) */
void REGPARAM2 op_0290_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 28 (5/2) */
/* 6 0,0   */

/* AND.L #<data>.L,(An)+ */
void REGPARAM2 op_0298_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, dstreg) += 4;
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 28 (5/2) */
/* 6 0,0   */

/* AND.L #<data>.L,-(An) */
void REGPARAM2 op_02a0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 30; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	do_cycles_ce000_internal(2);
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 30 (5/2) */
/* 6 0,0   */

/* AND.L #<data>.L,(d16,An) */
void REGPARAM2 op_02a8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, -2);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return;
	}
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	m68k_incpci(8);
	return;
}
/* 32 (6/2) */
/* 8 0,0   */

/* AND.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 op_02b0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 34; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(8));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, -2);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return;
	}
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	m68k_incpci(8);
	return;
}
/* 34 (6/2) */
/* 8 4,0   */

/* AND.L #<data>.L,(xxx).W */
void REGPARAM2 op_02b8_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 2;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(8);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return;
	}
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	m68k_incpci(8);
	return;
}
/* 32 (6/2) */
/* 8 0,0   */

/* AND.L #<data>.L,(xxx).L */
void REGPARAM2 op_02b9_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 2;
	CurrentInstrCycles = 36; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(8) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, -2);
		return;
	}
	dsta |= get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 10, pcoffset);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(10);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(12);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 12, pcoffset);
		return;
	}
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(12);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(12);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	m68k_incpci(10);
	return;
}
/* 36 (7/2) */
/* 10 0,0   */

/* SUB.B #<data>.B,Dn */
void REGPARAM2 op_0400_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 8;  
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 8 (2/0) */
/* 4 0,0   */

/* SUB.B #<data>.B,(An) */
void REGPARAM2 op_0410_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, newv, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* SUB.B #<data>.B,(An)+ */
void REGPARAM2 op_0418_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, newv, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* SUB.B #<data>.B,-(An) */
void REGPARAM2 op_0420_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 18; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce000_internal(2);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, newv, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 18 (3/1) */
/* 4 0,0   */

/* SUB.B #<data>.B,(d16,An) */
void REGPARAM2 op_0428_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 20; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, newv, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* SUB.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 op_0430_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 22; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, newv, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 22 (4/1) */
/* 6 4,0   */

/* SUB.B #<data>.B,(xxx).W */
void REGPARAM2 op_0438_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 7;
	CurrentInstrCycles = 20; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 0);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, newv, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* SUB.B #<data>.B,(xxx).L */
void REGPARAM2 op_0439_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 7;
	CurrentInstrCycles = 24; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(6) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	dsta |= get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, pcoffset);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x0, newv, 1);
		return;
	}
	m68k_incpci(8);
	return;
}
/* 24 (5/1) */
/* 8 0,0   */

/* SUB.W #<data>.W,Dn */
void REGPARAM2 op_0440_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 8 (2/0) */
/* 4 0,0   */

/* SUB.W #<data>.W,(An) */
void REGPARAM2 op_0450_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, newv, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* SUB.W #<data>.W,(An)+ */
void REGPARAM2 op_0458_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_areg(regs, dstreg) += 2 + 0;
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) += 2 + 0;
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, dstreg) += 2;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, newv, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* SUB.W #<data>.W,-(An) */
void REGPARAM2 op_0460_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	do_cycles_ce000_internal(2);
	if (dsta & 1) {
		m68k_areg(regs, dstreg) = dsta;
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, newv, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 18 (3/1) */
/* 4 0,0   */

/* SUB.W #<data>.W,(d16,An) */
void REGPARAM2 op_0468_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, newv, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* SUB.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_0470_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 22; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, newv, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 22 (4/1) */
/* 6 4,0   */

/* SUB.W #<data>.W,(xxx).W */
void REGPARAM2 op_0478_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 7;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, newv, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* SUB.W #<data>.W,(xxx).L */
void REGPARAM2 op_0479_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 7;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(6) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	dsta |= get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, pcoffset);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(8);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x1, newv, 1);
		return;
	}
	m68k_incpci(8);
	return;
}
/* 24 (5/1) */
/* 8 0,0   */

/* SUB.L #<data>.L,Dn */
void REGPARAM2 op_0480_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 14; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		uae_s16 bnewv = (uae_s16)dst - (uae_s16)src;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(dst)) < 0;
		int bflgn = bnewv < 0;
		ccr_68000_long_move_ae_LZN(bnewv);
		SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
		SET_XFLG(GET_CFLG());
		SET_VFLG((bflgs ^ bflgo) & (bflgn ^ bflgo));
		dreg_68000_long_replace_low(dstreg, bnewv);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	do_cycles_ce000_internal(2);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(6);
	return;
}
/* 14 (3/0) */
/* 6 0,0   */

/* SUB.L #<data>.L,(An) */
void REGPARAM2 op_0490_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		uae_s16 bnewv = (uae_s16)dst - (uae_s16)src;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(dst)) < 0;
		int bflgn = bnewv < 0;
		ccr_68000_long_move_ae_LZN(bnewv);
		SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
		SET_XFLG(GET_CFLG());
		SET_VFLG((bflgs ^ bflgo) & (bflgn ^ bflgo));
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	x_put_word(dsta + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 2, 0x1, newv, 1);
		return;
	}
	x_put_word(dsta, newv >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, newv >> 16, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 28 (5/2) */
/* 6 0,0   */

/* SUB.L #<data>.L,(An)+ */
void REGPARAM2 op_0498_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, dstreg) += 4;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		uae_s16 bnewv = (uae_s16)dst - (uae_s16)src;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(dst)) < 0;
		int bflgn = bnewv < 0;
		ccr_68000_long_move_ae_LZN(bnewv);
		SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
		SET_XFLG(GET_CFLG());
		SET_VFLG((bflgs ^ bflgo) & (bflgn ^ bflgo));
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	x_put_word(dsta + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 2, 0x1, newv, 1);
		return;
	}
	x_put_word(dsta, newv >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, newv >> 16, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 28 (5/2) */
/* 6 0,0   */

/* SUB.L #<data>.L,-(An) */
void REGPARAM2 op_04a0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 30; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	do_cycles_ce000_internal(2);
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		uae_s16 bnewv = (uae_s16)dst - (uae_s16)src;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(dst)) < 0;
		int bflgn = bnewv < 0;
		ccr_68000_long_move_ae_LZN(bnewv);
		SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
		SET_XFLG(GET_CFLG());
		SET_VFLG((bflgs ^ bflgo) & (bflgn ^ bflgo));
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	x_put_word(dsta + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 2, 0x1, newv, 1);
		return;
	}
	x_put_word(dsta, newv >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, newv >> 16, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 30 (5/2) */
/* 6 0,0   */

/* SUB.L #<data>.L,(d16,An) */
void REGPARAM2 op_04a8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, -2);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		uae_s16 bnewv = (uae_s16)dst - (uae_s16)src;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(dst)) < 0;
		int bflgn = bnewv < 0;
		ccr_68000_long_move_ae_LZN(bnewv);
		SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
		SET_XFLG(GET_CFLG());
		SET_VFLG((bflgs ^ bflgo) & (bflgn ^ bflgo));
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return;
	}
	x_put_word(dsta + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 2, 0x1, newv, 1);
		return;
	}
	x_put_word(dsta, newv >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x1, newv >> 16, 1);
		return;
	}
	m68k_incpci(8);
	return;
}
/* 32 (6/2) */
/* 8 0,0   */

/* SUB.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 op_04b0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 34; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(8));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, -2);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		uae_s16 bnewv = (uae_s16)dst - (uae_s16)src;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(dst)) < 0;
		int bflgn = bnewv < 0;
		ccr_68000_long_move_ae_LZN(bnewv);
		SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
		SET_XFLG(GET_CFLG());
		SET_VFLG((bflgs ^ bflgo) & (bflgn ^ bflgo));
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return;
	}
	x_put_word(dsta + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 2, 0x1, newv, 1);
		return;
	}
	x_put_word(dsta, newv >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x1, newv >> 16, 1);
		return;
	}
	m68k_incpci(8);
	return;
}
/* 34 (6/2) */
/* 8 4,0   */

/* SUB.L #<data>.L,(xxx).W */
void REGPARAM2 op_04b8_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 7;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(8);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		uae_s16 bnewv = (uae_s16)dst - (uae_s16)src;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(dst)) < 0;
		int bflgn = bnewv < 0;
		ccr_68000_long_move_ae_LZN(bnewv);
		SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
		SET_XFLG(GET_CFLG());
		SET_VFLG((bflgs ^ bflgo) & (bflgn ^ bflgo));
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return;
	}
	x_put_word(dsta + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 2, 0x1, newv, 1);
		return;
	}
	x_put_word(dsta, newv >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x1, newv >> 16, 1);
		return;
	}
	m68k_incpci(8);
	return;
}
/* 32 (6/2) */
/* 8 0,0   */

/* SUB.L #<data>.L,(xxx).L */
void REGPARAM2 op_04b9_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 7;
	CurrentInstrCycles = 36; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(8) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, -2);
		return;
	}
	dsta |= get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 10, pcoffset);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(10);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(12);
	if(hardware_bus_error) {
		int pcoffset = 0;
		uae_s16 bnewv = (uae_s16)dst - (uae_s16)src;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(dst)) < 0;
		int bflgn = bnewv < 0;
		ccr_68000_long_move_ae_LZN(bnewv);
		SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
		SET_XFLG(GET_CFLG());
		SET_VFLG((bflgs ^ bflgo) & (bflgn ^ bflgo));
		exception2_fetch_opcode(opcode, 12, pcoffset);
		return;
	}
	x_put_word(dsta + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(12);
		exception2_write(opcode, dsta + 2, 0x1, newv, 1);
		return;
	}
	x_put_word(dsta, newv >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(12);
		exception2_write(opcode, dsta + 0, 0x1, newv >> 16, 1);
		return;
	}
	m68k_incpci(10);
	return;
}
/* 36 (7/2) */
/* 10 0,0   */

/* ADD.B #<data>.B,Dn */
void REGPARAM2 op_0600_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 8;  
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 8 (2/0) */
/* 4 0,0   */

/* ADD.B #<data>.B,(An) */
void REGPARAM2 op_0610_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, newv, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* ADD.B #<data>.B,(An)+ */
void REGPARAM2 op_0618_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, newv, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* ADD.B #<data>.B,-(An) */
void REGPARAM2 op_0620_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 18; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce000_internal(2);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, newv, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 18 (3/1) */
/* 4 0,0   */

/* ADD.B #<data>.B,(d16,An) */
void REGPARAM2 op_0628_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 20; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, newv, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* ADD.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 op_0630_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 22; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, newv, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 22 (4/1) */
/* 6 4,0   */

/* ADD.B #<data>.B,(xxx).W */
void REGPARAM2 op_0638_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 11;
	CurrentInstrCycles = 20; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 0);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, newv, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* ADD.B #<data>.B,(xxx).L */
void REGPARAM2 op_0639_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 11;
	CurrentInstrCycles = 24; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(6) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	dsta |= get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, pcoffset);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x0, newv, 1);
		return;
	}
	m68k_incpci(8);
	return;
}
/* 24 (5/1) */
/* 8 0,0   */

/* ADD.W #<data>.W,Dn */
void REGPARAM2 op_0640_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 8 (2/0) */
/* 4 0,0   */

/* ADD.W #<data>.W,(An) */
void REGPARAM2 op_0650_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, newv, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* ADD.W #<data>.W,(An)+ */
void REGPARAM2 op_0658_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_areg(regs, dstreg) += 2 + 0;
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) += 2 + 0;
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, dstreg) += 2;
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, newv, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* ADD.W #<data>.W,-(An) */
void REGPARAM2 op_0660_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	do_cycles_ce000_internal(2);
	if (dsta & 1) {
		m68k_areg(regs, dstreg) = dsta;
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, newv, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 18 (3/1) */
/* 4 0,0   */

/* ADD.W #<data>.W,(d16,An) */
void REGPARAM2 op_0668_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, newv, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* ADD.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_0670_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 22; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, newv, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 22 (4/1) */
/* 6 4,0   */

/* ADD.W #<data>.W,(xxx).W */
void REGPARAM2 op_0678_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 11;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, newv, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* ADD.W #<data>.W,(xxx).L */
void REGPARAM2 op_0679_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 11;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(6) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	dsta |= get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, pcoffset);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(8);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(dsta, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x1, newv, 1);
		return;
	}
	m68k_incpci(8);
	return;
}
/* 24 (5/1) */
/* 8 0,0   */

/* ADD.L #<data>.L,Dn */
void REGPARAM2 op_0680_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 14; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		uae_s16 bnewv = (uae_s16)dst + (uae_s16)src;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(dst)) < 0;
		int bflgn = bnewv < 0;
		ccr_68000_long_move_ae_LZN(bnewv);
		SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
		SET_XFLG(GET_CFLG());
		SET_VFLG((bflgs ^ bflgn) & (bflgo ^ bflgn));
		dreg_68000_long_replace_low(dstreg, bnewv);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	do_cycles_ce000_internal(2);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(6);
	return;
}
/* 14 (3/0) */
/* 6 0,0   */

/* ADD.L #<data>.L,(An) */
void REGPARAM2 op_0690_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		uae_s16 bnewv = (uae_s16)dst + (uae_s16)src;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(dst)) < 0;
		int bflgn = bnewv < 0;
		ccr_68000_long_move_ae_LZN(bnewv);
		SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
		SET_XFLG(GET_CFLG());
		SET_VFLG((bflgs ^ bflgn) & (bflgo ^ bflgn));
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	x_put_word(dsta + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 2, 0x1, newv, 1);
		return;
	}
	x_put_word(dsta, newv >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, newv >> 16, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 28 (5/2) */
/* 6 0,0   */

/* ADD.L #<data>.L,(An)+ */
void REGPARAM2 op_0698_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, dstreg) += 4;
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		uae_s16 bnewv = (uae_s16)dst + (uae_s16)src;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(dst)) < 0;
		int bflgn = bnewv < 0;
		ccr_68000_long_move_ae_LZN(bnewv);
		SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
		SET_XFLG(GET_CFLG());
		SET_VFLG((bflgs ^ bflgn) & (bflgo ^ bflgn));
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	x_put_word(dsta + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 2, 0x1, newv, 1);
		return;
	}
	x_put_word(dsta, newv >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, newv >> 16, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 28 (5/2) */
/* 6 0,0   */

/* ADD.L #<data>.L,-(An) */
void REGPARAM2 op_06a0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 30; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	do_cycles_ce000_internal(2);
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		uae_s16 bnewv = (uae_s16)dst + (uae_s16)src;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(dst)) < 0;
		int bflgn = bnewv < 0;
		ccr_68000_long_move_ae_LZN(bnewv);
		SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
		SET_XFLG(GET_CFLG());
		SET_VFLG((bflgs ^ bflgn) & (bflgo ^ bflgn));
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	x_put_word(dsta + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 2, 0x1, newv, 1);
		return;
	}
	x_put_word(dsta, newv >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, newv >> 16, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 30 (5/2) */
/* 6 0,0   */

/* ADD.L #<data>.L,(d16,An) */
void REGPARAM2 op_06a8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, -2);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		uae_s16 bnewv = (uae_s16)dst + (uae_s16)src;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(dst)) < 0;
		int bflgn = bnewv < 0;
		ccr_68000_long_move_ae_LZN(bnewv);
		SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
		SET_XFLG(GET_CFLG());
		SET_VFLG((bflgs ^ bflgn) & (bflgo ^ bflgn));
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return;
	}
	x_put_word(dsta + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 2, 0x1, newv, 1);
		return;
	}
	x_put_word(dsta, newv >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x1, newv >> 16, 1);
		return;
	}
	m68k_incpci(8);
	return;
}
/* 32 (6/2) */
/* 8 0,0   */

/* ADD.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 op_06b0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 34; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(8));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, -2);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		uae_s16 bnewv = (uae_s16)dst + (uae_s16)src;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(dst)) < 0;
		int bflgn = bnewv < 0;
		ccr_68000_long_move_ae_LZN(bnewv);
		SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
		SET_XFLG(GET_CFLG());
		SET_VFLG((bflgs ^ bflgn) & (bflgo ^ bflgn));
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return;
	}
	x_put_word(dsta + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 2, 0x1, newv, 1);
		return;
	}
	x_put_word(dsta, newv >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x1, newv >> 16, 1);
		return;
	}
	m68k_incpci(8);
	return;
}
/* 34 (6/2) */
/* 8 4,0   */

/* ADD.L #<data>.L,(xxx).W */
void REGPARAM2 op_06b8_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 11;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(8);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		uae_s16 bnewv = (uae_s16)dst + (uae_s16)src;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(dst)) < 0;
		int bflgn = bnewv < 0;
		ccr_68000_long_move_ae_LZN(bnewv);
		SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
		SET_XFLG(GET_CFLG());
		SET_VFLG((bflgs ^ bflgn) & (bflgo ^ bflgn));
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return;
	}
	x_put_word(dsta + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 2, 0x1, newv, 1);
		return;
	}
	x_put_word(dsta, newv >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x1, newv >> 16, 1);
		return;
	}
	m68k_incpci(8);
	return;
}
/* 32 (6/2) */
/* 8 0,0   */

/* ADD.L #<data>.L,(xxx).L */
void REGPARAM2 op_06b9_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 11;
	CurrentInstrCycles = 36; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(8) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, -2);
		return;
	}
	dsta |= get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 10, pcoffset);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(10);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(12);
	if(hardware_bus_error) {
		int pcoffset = 0;
		uae_s16 bnewv = (uae_s16)dst + (uae_s16)src;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(dst)) < 0;
		int bflgn = bnewv < 0;
		ccr_68000_long_move_ae_LZN(bnewv);
		SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
		SET_XFLG(GET_CFLG());
		SET_VFLG((bflgs ^ bflgn) & (bflgo ^ bflgn));
		exception2_fetch_opcode(opcode, 12, pcoffset);
		return;
	}
	x_put_word(dsta + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(12);
		exception2_write(opcode, dsta + 2, 0x1, newv, 1);
		return;
	}
	x_put_word(dsta, newv >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(12);
		exception2_write(opcode, dsta + 0, 0x1, newv >> 16, 1);
		return;
	}
	m68k_incpci(10);
	return;
}
/* 36 (7/2) */
/* 10 0,0   */

/* BTST.L #<data>.W,Dn */
void REGPARAM2 op_0800_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 10; 
	ipl_fetch_now();
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 31;
	do_cycles_ce000_internal(2);
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(4);
	return;
}
/* 10 (2/0) */
/* 4 0,0   */

/* BTST.B #<data>.W,(An) */
void REGPARAM2 op_0810_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 12; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 12 (3/0) */
/* 4 0,0   */

/* BTST.B #<data>.W,(An)+ */
void REGPARAM2 op_0818_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 12; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 12 (3/0) */
/* 4 0,0   */

/* BTST.B #<data>.W,-(An) */
void REGPARAM2 op_0820_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 14; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce000_internal(2);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 14 (3/0) */
/* 4 0,0   */

/* BTST.B #<data>.W,(d16,An) */
void REGPARAM2 op_0828_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 16 (4/0) */
/* 6 0,0   */

/* BTST.B #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_0830_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 18 (4/0) */
/* 6 4,0   */

/* BTST.B #<data>.W,(xxx).W */
void REGPARAM2 op_0838_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 21;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 0);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 16 (4/0) */
/* 6 0,0   */

/* BTST.B #<data>.W,(xxx).L */
void REGPARAM2 op_0839_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 21;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(6) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	dsta |= get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, pcoffset);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return;
	}
	m68k_incpci(8);
	return;
}
/* 20 (5/0) */
/* 8 0,0   */

/* BTST.B #<data>.W,(d16,PC) */
void REGPARAM2 op_083a_13_ff(uae_u32 opcode)
{
	uae_u32 dstreg = 2;
	OpcodeFamily = 21;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_getpci() + 4;
	dsta += (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 2);
		return;
	}
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 16 (4/0) */
/* 6 0,0   */

/* BTST.B #<data>.W,(d8,PC,Xn) */
void REGPARAM2 op_083b_13_ff(uae_u32 opcode)
{
	uae_u32 dstreg = 3;
	OpcodeFamily = 21;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	uaecptr tmppc = m68k_getpci() + 4;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(tmppc, get_word_ce000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 2);
		return;
	}
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 18 (4/0) */
/* 6 4,0   */

/* BCHG.L #<data>.W,Dn */
void REGPARAM2 op_0840_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 10; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uae_s32 dst = m68k_dreg(regs, dstreg);
	ipl_fetch_next_pre();
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 31;
	do_cycles_ce000_internal(2);
	if (src > 15) do_cycles_ce000_internal(2);
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	m68k_dreg(regs, dstreg) = (dst);
	m68k_incpci(4);
	return;
}
/* 10 (2/0) */
/* 4 0,0   */

/* BCHG.B #<data>.W,(An) */
void REGPARAM2 op_0850_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* BCHG.B #<data>.W,(An)+ */
void REGPARAM2 op_0858_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* BCHG.B #<data>.W,-(An) */
void REGPARAM2 op_0860_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce000_internal(2);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 18 (3/1) */
/* 4 0,0   */

/* BCHG.B #<data>.W,(d16,An) */
void REGPARAM2 op_0868_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* BCHG.B #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_0870_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 22; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 22 (4/1) */
/* 6 4,0   */

/* BCHG.B #<data>.W,(xxx).W */
void REGPARAM2 op_0878_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 22;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 0);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* BCHG.B #<data>.W,(xxx).L */
void REGPARAM2 op_0879_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 22;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(6) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	dsta |= get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, pcoffset);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	regs.ir = regs.irc;
	get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(8);
	return;
}
/* 24 (5/1) */
/* 8 0,0   */

/* BCLR.L #<data>.W,Dn */
void REGPARAM2 op_0880_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 12; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uae_s32 dst = m68k_dreg(regs, dstreg);
	ipl_fetch_next_pre();
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 31;
	do_cycles_ce000_internal(2);
	if (src > 15) do_cycles_ce000_internal(2);
	do_cycles_ce000_internal(2);
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_dreg(regs, dstreg) = (dst);
	m68k_incpci(4);
	return;
}
/* 12 (2/0) */
/* 4 0,0   */

/* BCLR.B #<data>.W,(An) */
void REGPARAM2 op_0890_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	do_cycles_ce000_internal(2);
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 18 (3/1) */
/* 4 0,0   */

/* BCLR.B #<data>.W,(An)+ */
void REGPARAM2 op_0898_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	do_cycles_ce000_internal(2);
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 18 (3/1) */
/* 4 0,0   */

/* BCLR.B #<data>.W,-(An) */
void REGPARAM2 op_08a0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce000_internal(2);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	do_cycles_ce000_internal(2);
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 20 (3/1) */
/* 4 0,0   */

/* BCLR.B #<data>.W,(d16,An) */
void REGPARAM2 op_08a8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 22; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	do_cycles_ce000_internal(2);
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 22 (4/1) */
/* 6 0,0   */

/* BCLR.B #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_08b0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	do_cycles_ce000_internal(2);
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 24 (4/1) */
/* 6 4,0   */

/* BCLR.B #<data>.W,(xxx).W */
void REGPARAM2 op_08b8_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 23;
	CurrentInstrCycles = 22; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 0);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	do_cycles_ce000_internal(2);
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 22 (4/1) */
/* 6 0,0   */

/* BCLR.B #<data>.W,(xxx).L */
void REGPARAM2 op_08b9_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 23;
	CurrentInstrCycles = 26; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(6) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	dsta |= get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, pcoffset);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	regs.ir = regs.irc;
	get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	do_cycles_ce000_internal(2);
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(8);
	return;
}
/* 26 (5/1) */
/* 8 0,0   */

/* BSET.L #<data>.W,Dn */
void REGPARAM2 op_08c0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 10; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uae_s32 dst = m68k_dreg(regs, dstreg);
	ipl_fetch_next_pre();
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 31;
	do_cycles_ce000_internal(2);
	if (src > 15) do_cycles_ce000_internal(2);
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_dreg(regs, dstreg) = (dst);
	m68k_incpci(4);
	return;
}
/* 10 (2/0) */
/* 4 0,0   */

/* BSET.B #<data>.W,(An) */
void REGPARAM2 op_08d0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* BSET.B #<data>.W,(An)+ */
void REGPARAM2 op_08d8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* BSET.B #<data>.W,-(An) */
void REGPARAM2 op_08e0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce000_internal(2);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 18 (3/1) */
/* 4 0,0   */

/* BSET.B #<data>.W,(d16,An) */
void REGPARAM2 op_08e8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* BSET.B #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_08f0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 22; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 22 (4/1) */
/* 6 4,0   */

/* BSET.B #<data>.W,(xxx).W */
void REGPARAM2 op_08f8_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 24;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 0);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* BSET.B #<data>.W,(xxx).L */
void REGPARAM2 op_08f9_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 24;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(6) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	dsta |= get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, pcoffset);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	regs.ir = regs.irc;
	get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return;
	}
	opcode = regs.ir;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	x_put_byte(dsta, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(8);
	return;
}
/* 24 (5/1) */
/* 8 0,0   */

/* EOR.B #<data>.B,Dn */
void REGPARAM2 op_0a00_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 8;  
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 8 (2/0) */
/* 4 0,0   */

/* EOR.B #<data>.B,(An) */
void REGPARAM2 op_0a10_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* EOR.B #<data>.B,(An)+ */
void REGPARAM2 op_0a18_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* EOR.B #<data>.B,-(An) */
void REGPARAM2 op_0a20_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 18; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce000_internal(2);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 18 (3/1) */
/* 4 0,0   */

/* EOR.B #<data>.B,(d16,An) */
void REGPARAM2 op_0a28_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 20; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* EOR.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 op_0a30_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 22; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 22 (4/1) */
/* 6 4,0   */

/* EOR.B #<data>.B,(xxx).W */
void REGPARAM2 op_0a38_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 3;
	CurrentInstrCycles = 20; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 0);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* EOR.B #<data>.B,(xxx).L */
void REGPARAM2 op_0a39_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 3;
	CurrentInstrCycles = 24; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(6) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	dsta |= get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, pcoffset);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(8);
	return;
}
/* 24 (5/1) */
/* 8 0,0   */

/* EORSR.B #<data>.W */
void REGPARAM2 op_0a3c_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 6;
	CurrentInstrCycles = 16; 
	MakeSR();
	uae_s16 src = regs.irc;
	src &= 0xFF;
	do_cycles_ce000_internal(8);
	regs.sr ^= src;
	MakeFromSR();
	m68k_incpci(4);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (2/0) */
/* 4 0,0   */

/* EOR.W #<data>.W,Dn */
void REGPARAM2 op_0a40_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 8 (2/0) */
/* 4 0,0   */

/* EOR.W #<data>.W,(An) */
void REGPARAM2 op_0a50_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* EOR.W #<data>.W,(An)+ */
void REGPARAM2 op_0a58_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_areg(regs, dstreg) += 2 + 0;
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) += 2 + 0;
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, dstreg) += 2;
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* EOR.W #<data>.W,-(An) */
void REGPARAM2 op_0a60_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	do_cycles_ce000_internal(2);
	if (dsta & 1) {
		m68k_areg(regs, dstreg) = dsta;
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 18 (3/1) */
/* 4 0,0   */

/* EOR.W #<data>.W,(d16,An) */
void REGPARAM2 op_0a68_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* EOR.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_0a70_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 22; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 22 (4/1) */
/* 6 4,0   */

/* EOR.W #<data>.W,(xxx).W */
void REGPARAM2 op_0a78_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 3;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* EOR.W #<data>.W,(xxx).L */
void REGPARAM2 op_0a79_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 3;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(6) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	dsta |= get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, pcoffset);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(8);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(8);
	return;
}
/* 24 (5/1) */
/* 8 0,0   */

/* EORSR.W #<data>.W */
void REGPARAM2 op_0a7c_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 6;
	CurrentInstrCycles = 16; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	MakeSR();
	uae_s16 src = regs.irc;
	do_cycles_ce000_internal(8);
	regs.sr ^= src;
	MakeFromSR();
	m68k_incpci(4);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (2/0) */
/* 4 0,0   */

/* EOR.L #<data>.L,Dn */
void REGPARAM2 op_0a80_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 16; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	ipl_fetch_next_pre();
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_dreg(regs, dstreg) = (src);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	do_cycles_ce000_internal(4);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	return;
}
/* 16 (3/0) */
/* 6 0,0   */

/* EOR.L #<data>.L,(An) */
void REGPARAM2 op_0a90_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 28 (5/2) */
/* 6 0,0   */

/* EOR.L #<data>.L,(An)+ */
void REGPARAM2 op_0a98_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, dstreg) += 4;
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 28 (5/2) */
/* 6 0,0   */

/* EOR.L #<data>.L,-(An) */
void REGPARAM2 op_0aa0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 30; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	do_cycles_ce000_internal(2);
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 30 (5/2) */
/* 6 0,0   */

/* EOR.L #<data>.L,(d16,An) */
void REGPARAM2 op_0aa8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, -2);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return;
	}
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	m68k_incpci(8);
	return;
}
/* 32 (6/2) */
/* 8 0,0   */

/* EOR.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 op_0ab0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 34; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(8));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, -2);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return;
	}
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	m68k_incpci(8);
	return;
}
/* 34 (6/2) */
/* 8 4,0   */

/* EOR.L #<data>.L,(xxx).W */
void REGPARAM2 op_0ab8_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 3;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(8);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return;
	}
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	m68k_incpci(8);
	return;
}
/* 32 (6/2) */
/* 8 0,0   */

/* EOR.L #<data>.L,(xxx).L */
void REGPARAM2 op_0ab9_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 3;
	CurrentInstrCycles = 36; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(8) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, -2);
		return;
	}
	dsta |= get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 10, pcoffset);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(10);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(12);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 12, pcoffset);
		return;
	}
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(12);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(12);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	m68k_incpci(10);
	return;
}
/* 36 (7/2) */
/* 10 0,0   */

/* CMP.B #<data>.B,Dn */
void REGPARAM2 op_0c00_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 8;  
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 8 (2/0) */
/* 4 0,0   */

/* CMP.B #<data>.B,(An) */
void REGPARAM2 op_0c10_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 12 (3/0) */
/* 4 0,0   */

/* CMP.B #<data>.B,(An)+ */
void REGPARAM2 op_0c18_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 12 (3/0) */
/* 4 0,0   */

/* CMP.B #<data>.B,-(An) */
void REGPARAM2 op_0c20_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 14; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	do_cycles_ce000_internal(2);
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 14 (3/0) */
/* 4 0,0   */

/* CMP.B #<data>.B,(d16,An) */
void REGPARAM2 op_0c28_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 16 (4/0) */
/* 6 0,0   */

/* CMP.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 op_0c30_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 18; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 18 (4/0) */
/* 6 4,0   */

/* CMP.B #<data>.B,(xxx).W */
void REGPARAM2 op_0c38_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 25;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 0);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 16 (4/0) */
/* 6 0,0   */

/* CMP.B #<data>.B,(xxx).L */
void REGPARAM2 op_0c39_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 25;
	CurrentInstrCycles = 20; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(6) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	dsta |= get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, pcoffset);
		return;
	}
	ipl_fetch_now();
	uae_s8 dst = x_get_byte(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x0, 1);
		return;
	}
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return;
	}
	m68k_incpci(8);
	return;
}
/* 20 (5/0) */
/* 8 0,0   */

/* CMP.W #<data>.W,Dn */
void REGPARAM2 op_0c40_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 8 (2/0) */
/* 4 0,0   */

/* CMP.W #<data>.W,(An) */
void REGPARAM2 op_0c50_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 12 (3/0) */
/* 4 0,0   */

/* CMP.W #<data>.W,(An)+ */
void REGPARAM2 op_0c58_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_areg(regs, dstreg) += 2 + 0;
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) += 2 + 0;
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, dstreg) += 2;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 12 (3/0) */
/* 4 0,0   */

/* CMP.W #<data>.W,-(An) */
void REGPARAM2 op_0c60_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 14; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	do_cycles_ce000_internal(2);
	if (dsta & 1) {
		m68k_areg(regs, dstreg) = dsta;
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 14 (3/0) */
/* 4 0,0   */

/* CMP.W #<data>.W,(d16,An) */
void REGPARAM2 op_0c68_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 16 (4/0) */
/* 6 0,0   */

/* CMP.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_0c70_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 18 (4/0) */
/* 6 4,0   */

/* CMP.W #<data>.W,(xxx).W */
void REGPARAM2 op_0c78_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 25;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 16 (4/0) */
/* 6 0,0   */

/* CMP.W #<data>.W,(xxx).L */
void REGPARAM2 op_0c79_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 25;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(6) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	dsta |= get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, pcoffset);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(8);
		exception3_read_access(opcode, dsta, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 dst = x_get_word(dsta);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return;
	}
	m68k_incpci(8);
	return;
}
/* 20 (5/0) */
/* 8 0,0   */

/* CMP.L #<data>.L,Dn */
void REGPARAM2 op_0c80_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 14; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	ipl_fetch_next_pre();
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	do_cycles_ce000_internal(2);
	m68k_incpci(6);
	return;
}
/* 14 (3/0) */
/* 6 0,0   */

/* CMP.L #<data>.L,(An) */
void REGPARAM2 op_0c90_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 20; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 20 (5/0) */
/* 6 0,0   */

/* CMP.L #<data>.L,(An)+ */
void REGPARAM2 op_0c98_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 20; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, dstreg) += 4;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 20 (5/0) */
/* 6 0,0   */

/* CMP.L #<data>.L,-(An) */
void REGPARAM2 op_0ca0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 22; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	do_cycles_ce000_internal(2);
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		m68k_areg(regs, dstreg) = dsta;
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 22 (5/0) */
/* 6 0,0   */

/* CMP.L #<data>.L,(d16,An) */
void REGPARAM2 op_0ca8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 24; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, -2);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return;
	}
	m68k_incpci(8);
	return;
}
/* 24 (6/0) */
/* 8 0,0   */

/* CMP.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 op_0cb0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 26; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(8));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, -2);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return;
	}
	m68k_incpci(8);
	return;
}
/* 26 (6/0) */
/* 8 4,0   */

/* CMP.L #<data>.L,(xxx).W */
void REGPARAM2 op_0cb8_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 25;
	CurrentInstrCycles = 24; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(8);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return;
	}
	m68k_incpci(8);
	return;
}
/* 24 (6/0) */
/* 8 0,0   */

/* CMP.L #<data>.L,(xxx).L */
void REGPARAM2 op_0cb9_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 25;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(8) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, -2);
		return;
	}
	dsta |= get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 10, pcoffset);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(10);
		exception3_read_access(opcode, dsta, 2, 1);
		return;
	}
	uae_s32 dst = x_get_word(dsta) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_read(opcode, dsta + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	dst |= x_get_word(dsta + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		exception2_read(opcode, dsta + 2, 0x1, 1);
		return;
	}
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(12);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 12, pcoffset);
		return;
	}
	m68k_incpci(10);
	return;
}
/* 28 (7/0) */
/* 10 0,0   */

/* MOVES.B #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e10_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 18; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	do_cycles_ce000_internal(4);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg);
		do_cycles_ce000_internal(2);
		dfc_nommu_put_byte(dsta, src);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			regs.irc = extra;
			exception2_write(opcode, dsta + 0, 0x0, src, 1);
			return;
		}
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg);
		do_cycles_ce000_internal(2);
		ipl_fetch_now();
		uae_s8 src = sfc_nommu_get_byte(srca);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			regs.irc = extra;
			regs.write_buffer = extra;
			exception2_read(opcode, srca + 0, 0x0, 1);
			return;
		}
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
		m68k_incpci(4);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 18 (3/0) */
/* 4 0,0   */

#endif
/* MOVES.B #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e18_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 20; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	do_cycles_ce000_internal(4);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg);
		do_cycles_ce000_internal(4);
		m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
		src = regs.regs[(extra >> 12) & 15];
		dfc_nommu_put_byte(dsta, src);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			regs.irc = extra;
			exception2_write(opcode, dsta + 0, 0x0, src, 1);
			return;
		}
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg);
		do_cycles_ce000_internal(4);
		ipl_fetch_now();
		uae_s8 src = sfc_nommu_get_byte(srca);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			regs.irc = extra;
			regs.write_buffer = extra;
			exception2_read(opcode, srca + 0, 0x0, 1);
			return;
		}
		m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
		m68k_incpci(4);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (3/0) */
/* 4 0,0   */

#endif
/* MOVES.B #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e20_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 20; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	do_cycles_ce000_internal(4);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
		do_cycles_ce000_internal(4);
		m68k_areg(regs, dstreg) = dsta;
		src = regs.regs[(extra >> 12) & 15];
		dfc_nommu_put_byte(dsta, src);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			regs.irc = extra;
			exception2_write(opcode, dsta + 0, 0x0, src, 1);
			return;
		}
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
		do_cycles_ce000_internal(4);
		ipl_fetch_now();
		uae_s8 src = sfc_nommu_get_byte(srca);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			m68k_areg(regs, dstreg) = srca;
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(2);
			exception2_read(opcode, srca + 0, 0x0, 1);
			return;
		}
		m68k_areg(regs, dstreg) = srca;
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
		m68k_incpci(4);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (3/0) */
/* 4 0,0   */

#endif
/* MOVES.B #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e28_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 20; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	do_cycles_ce000_internal(4);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, -2);
			return;
		}
		dfc_nommu_put_byte(dsta, src);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			regs.irc = extra;
			exception2_write(opcode, dsta + 0, 0x0, src, 1);
			return;
		}
		m68k_incpci(6);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, -2);
			return;
		}
		ipl_fetch_now();
		uae_s8 src = sfc_nommu_get_byte(srca);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(4);
			exception2_read(opcode, srca + 0, 0x0, 1);
			return;
		}
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
		m68k_incpci(6);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (4/0) */
/* 6 0,0   */

#endif
/* MOVES.B #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e30_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 24; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	do_cycles_ce000_internal(4);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(6));
		do_cycles_ce000_internal(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, -2);
			return;
		}
		dfc_nommu_put_byte(dsta, src);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			regs.irc = extra;
			exception2_write(opcode, dsta + 0, 0x0, src, 1);
			return;
		}
		m68k_incpci(6);
	} else {
		uaecptr srca;
		srca = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(6));
		do_cycles_ce000_internal(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, -2);
			return;
		}
		ipl_fetch_now();
		uae_s8 src = sfc_nommu_get_byte(srca);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(4);
			exception2_read(opcode, srca + 0, 0x0, 1);
			return;
		}
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
		m68k_incpci(6);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 24 (4/0) */
/* 6 4,4   */

#endif
/* MOVES.B #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e38_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 103;
	CurrentInstrCycles = 20; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	do_cycles_ce000_internal(4);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, 0);
			return;
		}
		dfc_nommu_put_byte(dsta, src);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			regs.irc = extra;
			exception2_write(opcode, dsta + 0, 0x0, src, 1);
			return;
		}
		m68k_incpci(6);
	} else {
		uaecptr srca;
		srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, 0);
			return;
		}
		ipl_fetch_now();
		uae_s8 src = sfc_nommu_get_byte(srca);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(4);
			exception2_read(opcode, srca + 0, 0x0, 1);
			return;
		}
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
		m68k_incpci(6);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (4/0) */
/* 6 0,0   */

#endif
/* MOVES.B #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e39_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 103;
	CurrentInstrCycles = 24; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	do_cycles_ce000_internal(4);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = get_word_ce000_prefetch(6) << 16;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, -2);
			return;
		}
		dsta |= get_word_ce000_prefetch(8);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 8, pcoffset);
			return;
		}
		dfc_nommu_put_byte(dsta, src);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(10);
			regs.irc = extra;
			exception2_write(opcode, dsta + 0, 0x0, src, 1);
			return;
		}
		m68k_incpci(8);
	} else {
		uaecptr srca;
		srca = get_word_ce000_prefetch(6) << 16;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, -2);
			return;
		}
		srca |= get_word_ce000_prefetch(8);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 8, pcoffset);
			return;
		}
		ipl_fetch_now();
		uae_s8 src = sfc_nommu_get_byte(srca);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(2);
			exception2_read(opcode, srca + 0, 0x0, 1);
			return;
		}
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
		m68k_incpci(8);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 24 (5/0) */
/* 8 0,0   */

#endif
/* MOVES.W #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e50_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 18; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	do_cycles_ce000_internal(4);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg);
		do_cycles_ce000_internal(2);
		if (dsta & 1) {
			regs.irc = extra;
			m68k_incpci(6);
			exception3_write_access(opcode, dsta, 1, src, 1);
			return;
		}
		dfc_nommu_put_word(dsta, src);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			regs.irc = extra;
			exception2_write(opcode, dsta + 0, 0x1, src, 1);
			return;
		}
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg);
		do_cycles_ce000_internal(2);
		if (srca & 1) {
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(6);
			exception3_read_access(opcode, srca, 1, 1);
			return;
		}
		ipl_fetch_now();
		uae_s16 src = sfc_nommu_get_word(srca);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			regs.irc = extra;
			regs.write_buffer = extra;
			exception2_read(opcode, srca + 0, 0x1, 1);
			return;
		}
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
		m68k_incpci(4);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 18 (3/0) */
/* 4 0,0   */

#endif
/* MOVES.W #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e58_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 20; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	do_cycles_ce000_internal(4);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg);
		do_cycles_ce000_internal(4);
		if (dsta & 1) {
			m68k_areg(regs, dstreg) += 2 + 0;
			regs.irc = extra;
			if (dstreg + 8 == ((extra >> 12) & 15)) {
				src += 2;
			}
			m68k_incpci(6);
			exception3_write_access(opcode, dsta, 1, src, 1);
			return;
		}
		m68k_areg(regs, dstreg) += 2;
		src = regs.regs[(extra >> 12) & 15];
		dfc_nommu_put_word(dsta, src);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			regs.irc = extra;
			exception2_write(opcode, dsta + 0, 0x1, src, 1);
			return;
		}
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg);
		do_cycles_ce000_internal(4);
		if (srca & 1) {
			m68k_areg(regs, dstreg) += 2 + 0;
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(6);
			exception3_read_access(opcode, srca, 1, 1);
			return;
		}
		ipl_fetch_now();
		uae_s16 src = sfc_nommu_get_word(srca);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			m68k_areg(regs, dstreg) += 2 + 0;
			regs.irc = extra;
			regs.write_buffer = extra;
			exception2_read(opcode, srca + 0, 0x1, 1);
			return;
		}
		m68k_areg(regs, dstreg) += 2;
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
		m68k_incpci(4);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (3/0) */
/* 4 0,0   */

#endif
/* MOVES.W #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e60_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 20; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	do_cycles_ce000_internal(4);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg) - 2;
		do_cycles_ce000_internal(4);
		if (dsta & 1) {
			regs.irc = extra;
			if (dstreg + 8 == ((extra >> 12) & 15)) {
				src += -2;
			}
			m68k_areg(regs, dstreg) = dsta;
			m68k_incpci(6);
			exception3_write_access(opcode, dsta, 1, src, 1);
			return;
		}
		m68k_areg(regs, dstreg) = dsta;
		src = regs.regs[(extra >> 12) & 15];
		dfc_nommu_put_word(dsta, src);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			regs.irc = extra;
			exception2_write(opcode, dsta + 0, 0x1, src, 1);
			return;
		}
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg) - 2;
		do_cycles_ce000_internal(4);
		if (srca & 1) {
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_areg(regs, dstreg) = srca;
			m68k_incpci(6);
			exception3_read_access(opcode, srca, 1, 1);
			return;
		}
		ipl_fetch_now();
		uae_s16 src = sfc_nommu_get_word(srca);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			m68k_areg(regs, dstreg) = srca;
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(2);
			exception2_read(opcode, srca + 0, 0x1, 1);
			return;
		}
		m68k_areg(regs, dstreg) = srca;
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
		m68k_incpci(4);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (3/0) */
/* 4 0,0   */

#endif
/* MOVES.W #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e68_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 20; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	do_cycles_ce000_internal(4);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, -2);
			return;
		}
		if (dsta & 1) {
			regs.irc = extra;
			m68k_incpci(8);
			exception3_write_access(opcode, dsta, 1, src, 1);
			return;
		}
		dfc_nommu_put_word(dsta, src);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			regs.irc = extra;
			exception2_write(opcode, dsta + 0, 0x1, src, 1);
			return;
		}
		m68k_incpci(6);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, -2);
			return;
		}
		if (srca & 1) {
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(6);
			exception3_read_access(opcode, srca, 1, 1);
			return;
		}
		ipl_fetch_now();
		uae_s16 src = sfc_nommu_get_word(srca);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(4);
			exception2_read(opcode, srca + 0, 0x1, 1);
			return;
		}
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
		m68k_incpci(6);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (4/0) */
/* 6 0,0   */

#endif
/* MOVES.W #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e70_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 24; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	do_cycles_ce000_internal(4);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(6));
		do_cycles_ce000_internal(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, -2);
			return;
		}
		if (dsta & 1) {
			regs.irc = extra;
			m68k_incpci(8);
			exception3_write_access(opcode, dsta, 1, src, 1);
			return;
		}
		dfc_nommu_put_word(dsta, src);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			regs.irc = extra;
			exception2_write(opcode, dsta + 0, 0x1, src, 1);
			return;
		}
		m68k_incpci(6);
	} else {
		uaecptr srca;
		srca = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(6));
		do_cycles_ce000_internal(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, -2);
			return;
		}
		if (srca & 1) {
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(8);
			exception3_read_access(opcode, srca, 1, 1);
			return;
		}
		ipl_fetch_now();
		uae_s16 src = sfc_nommu_get_word(srca);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(4);
			exception2_read(opcode, srca + 0, 0x1, 1);
			return;
		}
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
		m68k_incpci(6);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 24 (4/0) */
/* 6 4,4   */

#endif
/* MOVES.W #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e78_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 103;
	CurrentInstrCycles = 20; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	do_cycles_ce000_internal(4);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, 0);
			return;
		}
		if (dsta & 1) {
			regs.irc = extra;
			m68k_incpci(8);
			exception3_write_access(opcode, dsta, 1, src, 1);
			return;
		}
		dfc_nommu_put_word(dsta, src);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			regs.irc = extra;
			exception2_write(opcode, dsta + 0, 0x1, src, 1);
			return;
		}
		m68k_incpci(6);
	} else {
		uaecptr srca;
		srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, 0);
			return;
		}
		if (srca & 1) {
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(8);
			exception3_read_access(opcode, srca, 1, 1);
			return;
		}
		ipl_fetch_now();
		uae_s16 src = sfc_nommu_get_word(srca);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(4);
			exception2_read(opcode, srca + 0, 0x1, 1);
			return;
		}
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
		m68k_incpci(6);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (4/0) */
/* 6 0,0   */

#endif
/* MOVES.W #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e79_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 103;
	CurrentInstrCycles = 24; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	do_cycles_ce000_internal(4);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = get_word_ce000_prefetch(6) << 16;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, -2);
			return;
		}
		dsta |= get_word_ce000_prefetch(8);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 8, pcoffset);
			return;
		}
		if (dsta & 1) {
			regs.irc = extra;
			m68k_incpci(10);
			exception3_write_access(opcode, dsta, 1, src, 1);
			return;
		}
		dfc_nommu_put_word(dsta, src);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(10);
			regs.irc = extra;
			exception2_write(opcode, dsta + 0, 0x1, src, 1);
			return;
		}
		m68k_incpci(8);
	} else {
		uaecptr srca;
		srca = get_word_ce000_prefetch(6) << 16;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, -2);
			return;
		}
		srca |= get_word_ce000_prefetch(8);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 8, pcoffset);
			return;
		}
		if (srca & 1) {
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(10);
			exception3_read_access(opcode, srca, 1, 1);
			return;
		}
		ipl_fetch_now();
		uae_s16 src = sfc_nommu_get_word(srca);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(2);
			exception2_read(opcode, srca + 0, 0x1, 1);
			return;
		}
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
		m68k_incpci(8);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 24 (5/0) */
/* 8 0,0   */

#endif
/* MOVES.L #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e90_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 22; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	do_cycles_ce000_internal(4);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg);
		do_cycles_ce000_internal(2);
		if (dsta & 1) {
			regs.irc = extra;
			m68k_incpci(6);
			exception3_write_access(opcode, dsta, 2, src >> 16, 1);
			return;
		}
		src = regs.regs[(extra >> 12) & 15];
		dfc_nommu_put_word(dsta, src >> 16);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			regs.irc = extra;
			exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
			return;
		}
		dfc_nommu_put_word(dsta + 2, src);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			regs.irc = extra;
			exception2_write(opcode, dsta + 2, 0x1, src, 1);
			return;
		}
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg);
		do_cycles_ce000_internal(2);
		if (srca & 1) {
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(6);
			exception3_read_access(opcode, srca, 2, 1);
			return;
		}
		uae_s32 src = sfc_nommu_get_word(srca) << 16;
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			regs.irc = extra;
			regs.write_buffer = extra;
			exception2_read(opcode, srca + 0, 0x1, 1);
			return;
		}
		ipl_fetch_now();
		src |= sfc_nommu_get_word(srca + 2);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			regs.irc = extra;
			regs.write_buffer = extra;
			exception2_read(opcode, srca + 2, 0x1, 1);
			return;
		}
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
		m68k_incpci(4);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 22 (4/0) */
/* 4 0,0   */

#endif
/* MOVES.L #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e98_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 24; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	do_cycles_ce000_internal(4);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg);
		do_cycles_ce000_internal(4);
		if (dsta & 1) {
			regs.irc = extra;
			if (dstreg + 8 == ((extra >> 12) & 15)) {
				src += 2;
			}
			m68k_areg(regs, dstreg) += 4;
			m68k_incpci(6);
			exception3_write_access(opcode, dsta, 2, src >> 16, 1);
			return;
		}
		m68k_areg(regs, dstreg) += 4;
		src = regs.regs[(extra >> 12) & 15];
		dfc_nommu_put_word(dsta, src >> 16);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			regs.irc = extra;
			m68k_areg(regs, dstreg) += 4;
			exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
			return;
		}
		dfc_nommu_put_word(dsta + 2, src);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			regs.irc = extra;
			m68k_areg(regs, dstreg) += 4;
			exception2_write(opcode, dsta + 2, 0x1, src, 1);
			return;
		}
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg);
		do_cycles_ce000_internal(4);
		if (srca & 1) {
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_areg(regs, dstreg) += 4;
			m68k_incpci(6);
			exception3_read_access(opcode, srca, 2, 1);
			return;
		}
		uae_s32 src = sfc_nommu_get_word(srca) << 16;
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_areg(regs, dstreg) += 4;
			exception2_read(opcode, srca + 0, 0x1, 1);
			return;
		}
		ipl_fetch_now();
		src |= sfc_nommu_get_word(srca + 2);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_areg(regs, dstreg) += 4;
			exception2_read(opcode, srca + 2, 0x1, 1);
			return;
		}
		m68k_areg(regs, dstreg) += 4;
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
		m68k_incpci(4);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 24 (4/0) */
/* 4 0,0   */

#endif
/* MOVES.L #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0ea0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 24; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	do_cycles_ce000_internal(4);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg) - 4;
		do_cycles_ce000_internal(4);
		if (dsta & 1) {
			regs.irc = extra;
			if (dstreg + 8 == ((extra >> 12) & 15)) {
				src += -2;
			}
			m68k_incpci(6);
			m68k_areg(regs, dstreg) = dsta;
			exception3_write_access(opcode, dsta, 2, src >> 16, 1);
			return;
		}
		m68k_areg(regs, dstreg) = dsta;
		src = regs.regs[(extra >> 12) & 15];
		dfc_nommu_put_word(dsta, src >> 16);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			regs.irc = extra;
			exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
			return;
		}
		dfc_nommu_put_word(dsta + 2, src);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			regs.irc = extra;
			exception2_write(opcode, dsta + 2, 0x1, src, 1);
			return;
		}
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg) - 4;
		do_cycles_ce000_internal(4);
		if (srca & 1) {
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(6);
			m68k_areg(regs, dstreg) = srca;
			exception3_read_access(opcode, srca, 2, 1);
			return;
		}
		uae_s32 src = sfc_nommu_get_word(srca) << 16;
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_areg(regs, dstreg) = srca;
			m68k_incpci(2);
			exception2_read(opcode, srca + 0, 0x1, 1);
			return;
		}
		ipl_fetch_now();
		src |= sfc_nommu_get_word(srca + 2);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			m68k_areg(regs, dstreg) = srca;
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_areg(regs, dstreg) = srca;
			m68k_incpci(2);
			exception2_read(opcode, srca + 2, 0x1, 1);
			return;
		}
		m68k_areg(regs, dstreg) = srca;
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
		m68k_incpci(4);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 24 (4/0) */
/* 4 0,0   */

#endif
/* MOVES.L #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0ea8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 24; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	do_cycles_ce000_internal(4);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, -2);
			return;
		}
		if (dsta & 1) {
			regs.irc = extra;
			m68k_incpci(8);
			exception3_write_access(opcode, dsta, 2, src >> 16, 1);
			return;
		}
		src = regs.regs[(extra >> 12) & 15];
		dfc_nommu_put_word(dsta, src >> 16);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			regs.irc = extra;
			exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
			return;
		}
		dfc_nommu_put_word(dsta + 2, src);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			regs.irc = extra;
			exception2_write(opcode, dsta + 2, 0x1, src, 1);
			return;
		}
		m68k_incpci(6);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, -2);
			return;
		}
		if (srca & 1) {
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(6);
			exception3_read_access(opcode, srca, 2, 1);
			return;
		}
		uae_s32 src = sfc_nommu_get_word(srca) << 16;
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(4);
			exception2_read(opcode, srca + 0, 0x1, 1);
			return;
		}
		ipl_fetch_now();
		src |= sfc_nommu_get_word(srca + 2);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(4);
			exception2_read(opcode, srca + 2, 0x1, 1);
			return;
		}
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
		m68k_incpci(6);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 24 (5/0) */
/* 6 0,0   */

#endif
/* MOVES.L #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0eb0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 28; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	do_cycles_ce000_internal(4);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(6));
		do_cycles_ce000_internal(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, -2);
			return;
		}
		if (dsta & 1) {
			regs.irc = extra;
			m68k_incpci(8);
			exception3_write_access(opcode, dsta, 2, src >> 16, 1);
			return;
		}
		src = regs.regs[(extra >> 12) & 15];
		dfc_nommu_put_word(dsta, src >> 16);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			regs.irc = extra;
			exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
			return;
		}
		dfc_nommu_put_word(dsta + 2, src);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			regs.irc = extra;
			exception2_write(opcode, dsta + 2, 0x1, src, 1);
			return;
		}
		m68k_incpci(6);
	} else {
		uaecptr srca;
		srca = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(6));
		do_cycles_ce000_internal(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, -2);
			return;
		}
		if (srca & 1) {
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(8);
			exception3_read_access(opcode, srca, 2, 1);
			return;
		}
		uae_s32 src = sfc_nommu_get_word(srca) << 16;
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(4);
			exception2_read(opcode, srca + 0, 0x1, 1);
			return;
		}
		ipl_fetch_now();
		src |= sfc_nommu_get_word(srca + 2);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(4);
			exception2_read(opcode, srca + 2, 0x1, 1);
			return;
		}
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
		m68k_incpci(6);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 28 (5/0) */
/* 6 4,4   */

#endif
/* MOVES.L #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0eb8_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 103;
	CurrentInstrCycles = 24; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	do_cycles_ce000_internal(4);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, 0);
			return;
		}
		if (dsta & 1) {
			regs.irc = extra;
			m68k_incpci(8);
			exception3_write_access(opcode, dsta, 2, src >> 16, 1);
			return;
		}
		src = regs.regs[(extra >> 12) & 15];
		dfc_nommu_put_word(dsta, src >> 16);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			regs.irc = extra;
			exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
			return;
		}
		dfc_nommu_put_word(dsta + 2, src);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			regs.irc = extra;
			exception2_write(opcode, dsta + 2, 0x1, src, 1);
			return;
		}
		m68k_incpci(6);
	} else {
		uaecptr srca;
		srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, 0);
			return;
		}
		if (srca & 1) {
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(8);
			exception3_read_access(opcode, srca, 2, 1);
			return;
		}
		uae_s32 src = sfc_nommu_get_word(srca) << 16;
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(4);
			exception2_read(opcode, srca + 0, 0x1, 1);
			return;
		}
		ipl_fetch_now();
		src |= sfc_nommu_get_word(srca + 2);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(4);
			exception2_read(opcode, srca + 2, 0x1, 1);
			return;
		}
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
		m68k_incpci(6);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 24 (5/0) */
/* 6 0,0   */

#endif
/* MOVES.L #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0eb9_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 103;
	CurrentInstrCycles = 28; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	do_cycles_ce000_internal(4);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = get_word_ce000_prefetch(6) << 16;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, -2);
			return;
		}
		dsta |= get_word_ce000_prefetch(8);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 8, pcoffset);
			return;
		}
		if (dsta & 1) {
			regs.irc = extra;
			m68k_incpci(10);
			exception3_write_access(opcode, dsta, 2, src >> 16, 1);
			return;
		}
		src = regs.regs[(extra >> 12) & 15];
		dfc_nommu_put_word(dsta, src >> 16);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(10);
			regs.irc = extra;
			exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
			return;
		}
		dfc_nommu_put_word(dsta + 2, src);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(10);
			regs.irc = extra;
			exception2_write(opcode, dsta + 2, 0x1, src, 1);
			return;
		}
		m68k_incpci(8);
	} else {
		uaecptr srca;
		srca = get_word_ce000_prefetch(6) << 16;
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 6, -2);
			return;
		}
		srca |= get_word_ce000_prefetch(8);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch(opcode, 8, pcoffset);
			return;
		}
		if (srca & 1) {
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(10);
			exception3_read_access(opcode, srca, 2, 1);
			return;
		}
		uae_s32 src = sfc_nommu_get_word(srca) << 16;
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(2);
			exception2_read(opcode, srca + 0, 0x1, 1);
			return;
		}
		ipl_fetch_now();
		src |= sfc_nommu_get_word(srca + 2);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			regs.irc = extra;
			regs.write_buffer = extra;
			m68k_incpci(2);
			exception2_read(opcode, srca + 2, 0x1, 1);
			return;
		}
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
		m68k_incpci(8);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 28 (6/0) */
/* 8 0,0   */

#endif
/* MOVE.B Dn,Dn */
void REGPARAM2 op_1000_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 4;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 4 (1/0) */
/* 2 0,0   */

/* MOVE.B (An),Dn */
void REGPARAM2 op_1010_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 8 (2/0) */
/* 2 0,0   */

/* MOVE.B (An)+,Dn */
void REGPARAM2 op_1018_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 8 (2/0) */
/* 2 0,0   */

/* MOVE.B -(An),Dn */
void REGPARAM2 op_1020_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal(2);
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 10 (2/0) */
/* 2 0,0   */

/* MOVE.B (d16,An),Dn */
void REGPARAM2 op_1028_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 12 (3/0) */
/* 4 0,0   */

/* MOVE.B (d8,An,Xn),Dn */
void REGPARAM2 op_1030_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 14 (3/0) */
/* 4 4,0   */

/* MOVE.B (xxx).W,Dn */
void REGPARAM2 op_1038_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 12 (3/0) */
/* 4 0,0   */

/* MOVE.B (xxx).L,Dn */
void REGPARAM2 op_1039_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (4/0) */
/* 6 0,0   */

/* MOVE.B (d16,PC),Dn */
void REGPARAM2 op_103a_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 2);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 12 (3/0) */
/* 4 0,0   */

/* MOVE.B (d8,PC,Xn),Dn */
void REGPARAM2 op_103b_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(tmppc, get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 2);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 14 (3/0) */
/* 4 4,0   */

/* MOVE.B #<data>.B,Dn */
void REGPARAM2 op_103c_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 8 (2/0) */
/* 4 0,0   */

/* MOVE.B Dn,(An) */
void REGPARAM2 op_1080_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	int loop_mode = regs.loop_mode;
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	ipl_fetch_now();
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_ce000_prefetch(2);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 4 << 16;
	}
	regs.loop_mode = loop_mode;
	return;
}
/* 8 (1/1) */
/* 2 0,0   */

/* MOVE.B (An),(An) */
void REGPARAM2 op_1090_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	ipl_fetch_now();
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_ce000_prefetch(2);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 2 << 16;
	}
	regs.loop_mode = loop_mode;
	return;
}
/* 12 (2/1) */
/* 2 0,0   */

/* MOVE.B (An)+,(An) */
void REGPARAM2 op_1098_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	ipl_fetch_now();
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_ce000_prefetch(2);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 2 << 16;
	}
	regs.loop_mode = loop_mode;
	return;
}
/* 12 (2/1) */
/* 2 0,0   */

/* MOVE.B -(An),(An) */
void REGPARAM2 op_10a0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 14; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal(2);
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	ipl_fetch_now();
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_ce000_prefetch(2);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 2 << 16;
	}
	regs.loop_mode = loop_mode;
	return;
}
/* 14 (2/1) */
/* 2 0,0   */

/* MOVE.B (d16,An),(An) */
void REGPARAM2 op_10a8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	ipl_fetch_now();
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.B (d8,An,Xn),(An) */
void REGPARAM2 op_10b0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	ipl_fetch_now();
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 18 (3/1) */
/* 4 4,0   */

/* MOVE.B (xxx).W,(An) */
void REGPARAM2 op_10b8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	ipl_fetch_now();
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.B (xxx).L,(An) */
void REGPARAM2 op_10b9_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	ipl_fetch_now();
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.B (d16,PC),(An) */
void REGPARAM2 op_10ba_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 2);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	ipl_fetch_now();
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.B (d8,PC,Xn),(An) */
void REGPARAM2 op_10bb_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(tmppc, get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 2);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	ipl_fetch_now();
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 18 (3/1) */
/* 4 4,0   */

/* MOVE.B #<data>.B,(An) */
void REGPARAM2 op_10bc_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	ipl_fetch_now();
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 12 (2/1) */
/* 4 0,0   */

/* MOVE.B Dn,(An)+ */
void REGPARAM2 op_10c0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	int loop_mode = regs.loop_mode;
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	ipl_fetch_next_pre();
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, dstreg) -= areg_byteinc[dstreg];
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_ce000_prefetch(2);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 4 << 16;
	}
	regs.loop_mode = loop_mode;
	return;
}
/* 8 (1/1) */
/* 2 0,0   */

/* MOVE.B (An),(An)+ */
void REGPARAM2 op_10d0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, dstreg) -= areg_byteinc[dstreg];
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_ce000_prefetch(2);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 2 << 16;
	}
	regs.loop_mode = loop_mode;
	return;
}
/* 12 (2/1) */
/* 2 0,0   */

/* MOVE.B (An)+,(An)+ */
void REGPARAM2 op_10d8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, dstreg) -= areg_byteinc[dstreg];
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_ce000_prefetch(2);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 2 << 16;
	}
	regs.loop_mode = loop_mode;
	return;
}
/* 12 (2/1) */
/* 2 0,0   */

/* MOVE.B -(An),(An)+ */
void REGPARAM2 op_10e0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 14; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal(2);
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, dstreg) -= areg_byteinc[dstreg];
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_ce000_prefetch(2);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 2 << 16;
	}
	regs.loop_mode = loop_mode;
	return;
}
/* 14 (2/1) */
/* 2 0,0   */

/* MOVE.B (d16,An),(An)+ */
void REGPARAM2 op_10e8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) -= areg_byteinc[dstreg];
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.B (d8,An,Xn),(An)+ */
void REGPARAM2 op_10f0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) -= areg_byteinc[dstreg];
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 18 (3/1) */
/* 4 4,0   */

/* MOVE.B (xxx).W,(An)+ */
void REGPARAM2 op_10f8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) -= areg_byteinc[dstreg];
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.B (xxx).L,(An)+ */
void REGPARAM2 op_10f9_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		m68k_areg(regs, dstreg) -= areg_byteinc[dstreg];
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.B (d16,PC),(An)+ */
void REGPARAM2 op_10fa_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 2);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) -= areg_byteinc[dstreg];
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.B (d8,PC,Xn),(An)+ */
void REGPARAM2 op_10fb_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(tmppc, get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 2);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) -= areg_byteinc[dstreg];
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 18 (3/1) */
/* 4 4,0   */

/* MOVE.B #<data>.B,(An)+ */
void REGPARAM2 op_10fc_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	ipl_fetch_now();
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) -= areg_byteinc[dstreg];
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 12 (2/1) */
/* 4 0,0   */

/* MOVE.B Dn,-(An) */
void REGPARAM2 op_1100_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	ipl_fetch_next_pre();
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	opcode = regs.ir;
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(2);
	return;
}
/* 8 (1/1) */
/* 2 0,0   */

/* MOVE.B (An),-(An) */
void REGPARAM2 op_1110_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
			ccr_68000_word_move_ae_normal((uae_s16)src);
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode = 1;
	}
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(2);
	regs.loop_mode = loop_mode;
	return;
}
/* 12 (2/1) */
/* 2 0,0   */

/* MOVE.B (An)+,-(An) */
void REGPARAM2 op_1118_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
			ccr_68000_word_move_ae_normal((uae_s16)src);
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode = 1;
	}
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(2);
	regs.loop_mode = loop_mode;
	return;
}
/* 12 (2/1) */
/* 2 0,0   */

/* MOVE.B -(An),-(An) */
void REGPARAM2 op_1120_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 14; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal(2);
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
			ccr_68000_word_move_ae_normal((uae_s16)src);
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode = 1;
	}
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(2);
	regs.loop_mode = loop_mode;
	return;
}
/* 14 (2/1) */
/* 2 0,0   */

/* MOVE.B (d16,An),-(An) */
void REGPARAM2 op_1128_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.B (d8,An,Xn),-(An) */
void REGPARAM2 op_1130_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 18 (3/1) */
/* 4 4,0   */

/* MOVE.B (xxx).W,-(An) */
void REGPARAM2 op_1138_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.B (xxx).L,-(An) */
void REGPARAM2 op_1139_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.B (d16,PC),-(An) */
void REGPARAM2 op_113a_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 2);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.B (d8,PC,Xn),-(An) */
void REGPARAM2 op_113b_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(tmppc, get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 2);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 18 (3/1) */
/* 4 4,0   */

/* MOVE.B #<data>.B,-(An) */
void REGPARAM2 op_113c_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	ipl_fetch_now();
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 12 (2/1) */
/* 4 0,0   */

/* MOVE.B Dn,(d16,An) */
void REGPARAM2 op_1140_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	ipl_fetch_now();
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 12 (2/1) */
/* 4 0,0   */

/* MOVE.B (An),(d16,An) */
void REGPARAM2 op_1150_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	ipl_fetch_now();
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.B (An)+,(d16,An) */
void REGPARAM2 op_1158_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	ipl_fetch_now();
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.B -(An),(d16,An) */
void REGPARAM2 op_1160_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal(2);
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	ipl_fetch_now();
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 18 (3/1) */
/* 4 0,0   */

/* MOVE.B (d16,An),(d16,An) */
void REGPARAM2 op_1168_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	ipl_fetch_now();
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.B (d8,An,Xn),(d16,An) */
void REGPARAM2 op_1170_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	ipl_fetch_now();
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 22 (4/1) */
/* 6 6,0   */

/* MOVE.B (xxx).W,(d16,An) */
void REGPARAM2 op_1178_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	ipl_fetch_now();
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.B (xxx).L,(d16,An) */
void REGPARAM2 op_1179_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 8, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	ipl_fetch_now();
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(8);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 24 (5/1) */
/* 8 0,0   */

/* MOVE.B (d16,PC),(d16,An) */
void REGPARAM2 op_117a_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 2);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	ipl_fetch_now();
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.B (d8,PC,Xn),(d16,An) */
void REGPARAM2 op_117b_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(tmppc, get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 2);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	ipl_fetch_now();
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 22 (4/1) */
/* 6 6,0   */

/* MOVE.B #<data>.B,(d16,An) */
void REGPARAM2 op_117c_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 0);
		return;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	ipl_fetch_now();
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (3/1) */
/* 6 0,0   */

/* MOVE.B Dn,(d8,An,Xn) */
void REGPARAM2 op_1180_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 14; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	ipl_fetch_now();
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 14 (2/1) */
/* 4 4,0   */

/* MOVE.B (An),(d8,An,Xn) */
void REGPARAM2 op_1190_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	ipl_fetch_now();
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 18 (3/1) */
/* 4 4,0   */

/* MOVE.B (An)+,(d8,An,Xn) */
void REGPARAM2 op_1198_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	ipl_fetch_now();
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 18 (3/1) */
/* 4 4,0   */

/* MOVE.B -(An),(d8,An,Xn) */
void REGPARAM2 op_11a0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal(2);
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	ipl_fetch_now();
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (3/1) */
/* 4 4,0   */

/* MOVE.B (d16,An),(d8,An,Xn) */
void REGPARAM2 op_11a8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	ipl_fetch_now();
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 22 (4/1) */
/* 6 4,0   */

/* MOVE.B (d8,An,Xn),(d8,An,Xn) */
void REGPARAM2 op_11b0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	ipl_fetch_now();
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 24 (4/1) */
/* 6 6,4   */

/* MOVE.B (xxx).W,(d8,An,Xn) */
void REGPARAM2 op_11b8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	ipl_fetch_now();
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 22 (4/1) */
/* 6 4,0   */

/* MOVE.B (xxx).L,(d8,An,Xn) */
void REGPARAM2 op_11b9_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(8));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 8, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	ipl_fetch_now();
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(8);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 26 (5/1) */
/* 8 4,0   */

/* MOVE.B (d16,PC),(d8,An,Xn) */
void REGPARAM2 op_11ba_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 2);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	ipl_fetch_now();
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 22 (4/1) */
/* 6 4,0   */

/* MOVE.B (d8,PC,Xn),(d8,An,Xn) */
void REGPARAM2 op_11bb_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(tmppc, get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 2);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	ipl_fetch_now();
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 24 (4/1) */
/* 6 6,4   */

/* MOVE.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 op_11bc_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 0);
		return;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	ipl_fetch_now();
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 18 (3/1) */
/* 6 4,0   */

/* MOVE.B Dn,(xxx).W */
void REGPARAM2 op_11c0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	ipl_fetch_next();
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 12 (2/1) */
/* 4 0,0   */

/* MOVE.B (An),(xxx).W */
void REGPARAM2 op_11d0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	ipl_fetch_next();
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.B (An)+,(xxx).W */
void REGPARAM2 op_11d8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	ipl_fetch_next();
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.B -(An),(xxx).W */
void REGPARAM2 op_11e0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal(2);
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	ipl_fetch_next();
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 18 (3/1) */
/* 4 0,0   */

/* MOVE.B (d16,An),(xxx).W */
void REGPARAM2 op_11e8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	ipl_fetch_next();
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.B (d8,An,Xn),(xxx).W */
void REGPARAM2 op_11f0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	ipl_fetch_next();
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 22 (4/1) */
/* 6 6,0   */

/* MOVE.B (xxx).W,(xxx).W */
void REGPARAM2 op_11f8_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	ipl_fetch_next();
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.B (xxx).L,(xxx).W */
void REGPARAM2 op_11f9_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 8, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	ipl_fetch_next();
	m68k_incpci(8);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 24 (5/1) */
/* 8 0,0   */

/* MOVE.B (d16,PC),(xxx).W */
void REGPARAM2 op_11fa_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 2);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	ipl_fetch_next();
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.B (d8,PC,Xn),(xxx).W */
void REGPARAM2 op_11fb_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(tmppc, get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 2);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	ipl_fetch_next();
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 22 (4/1) */
/* 6 6,0   */

/* MOVE.B #<data>.B,(xxx).W */
void REGPARAM2 op_11fc_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	ipl_fetch_next();
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (3/1) */
/* 6 0,0   */

/* MOVE.B Dn,(xxx).L */
void REGPARAM2 op_13c0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	dsta |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	ipl_fetch_next();
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (3/1) */
/* 6 0,0   */

/* MOVE.B (An),(xxx).L */
void REGPARAM2 op_13d0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(4) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	ipl_fetch_now();
	m68k_incpci(6);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.B (An)+,(xxx).L */
void REGPARAM2 op_13d8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(4) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	ipl_fetch_now();
	m68k_incpci(6);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.B -(An),(xxx).L */
void REGPARAM2 op_13e0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal(2);
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(4) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	ipl_fetch_now();
	m68k_incpci(6);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 22 (4/1) */
/* 6 0,0   */

/* MOVE.B (d16,An),(xxx).L */
void REGPARAM2 op_13e8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(6) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	ipl_fetch_now();
	m68k_incpci(8);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 24 (5/1) */
/* 8 0,0   */

/* MOVE.B (d8,An,Xn),(xxx).L */
void REGPARAM2 op_13f0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(6) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	ipl_fetch_now();
	m68k_incpci(8);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 26 (5/1) */
/* 8 8,0   */

/* MOVE.B (xxx).W,(xxx).L */
void REGPARAM2 op_13f8_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(6) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	ipl_fetch_now();
	m68k_incpci(8);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 24 (5/1) */
/* 8 0,0   */

/* MOVE.B (xxx).L,(xxx).L */
void REGPARAM2 op_13f9_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(8) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 8, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	ipl_fetch_now();
	m68k_incpci(10);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 28 (6/1) */
/* 10 0,0   */

/* MOVE.B (d16,PC),(xxx).L */
void REGPARAM2 op_13fa_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 2);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(6) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	ipl_fetch_now();
	m68k_incpci(8);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 24 (5/1) */
/* 8 0,0   */

/* MOVE.B (d8,PC,Xn),(xxx).L */
void REGPARAM2 op_13fb_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(tmppc, get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 2);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(6) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	ipl_fetch_now();
	m68k_incpci(8);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 26 (5/1) */
/* 8 8,0   */

/* MOVE.B #<data>.B,(xxx).L */
void REGPARAM2 op_13fc_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uae_s8 src = (uae_u8)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(6) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	dsta |= get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 8, pcoffset);
		return;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x0, src, 1);
		return;
	}
	ipl_fetch_next();
	m68k_incpci(8);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (4/1) */
/* 8 0,0   */

/* MOVE.L Dn,Dn */
void REGPARAM2 op_2000_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 4 (1/0) */
/* 2 0,0   */

/* MOVE.L An,Dn */
void REGPARAM2 op_2008_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_areg(regs, srcreg);
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 4 (1/0) */
/* 2 0,0   */

/* MOVE.L (An),Dn */
void REGPARAM2 op_2010_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 12 (3/0) */
/* 2 0,0   */

/* MOVE.L (An)+,Dn */
void REGPARAM2 op_2018_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) += 4;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 12 (3/0) */
/* 2 0,0   */

/* MOVE.L -(An),Dn */
void REGPARAM2 op_2020_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	do_cycles_ce000_internal(2);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 14 (3/0) */
/* 2 0,0   */

/* MOVE.L (d16,An),Dn */
void REGPARAM2 op_2028_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (4/0) */
/* 4 0,0   */

/* MOVE.L (d8,An,Xn),Dn */
void REGPARAM2 op_2030_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 18 (4/0) */
/* 4 4,0   */

/* MOVE.L (xxx).W,Dn */
void REGPARAM2 op_2038_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (4/0) */
/* 4 0,0   */

/* MOVE.L (xxx).L,Dn */
void REGPARAM2 op_2039_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (5/0) */
/* 6 0,0   */

/* MOVE.L (d16,PC),Dn */
void REGPARAM2 op_203a_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 2);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 2);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (4/0) */
/* 4 0,0   */

/* MOVE.L (d8,PC,Xn),Dn */
void REGPARAM2 op_203b_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(tmppc, get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 2);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 2);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 18 (4/0) */
/* 4 4,0   */

/* MOVE.L #<data>.L,Dn */
void REGPARAM2 op_203c_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 12 (3/0) */
/* 6 0,0   */

/* MOVEA.L Dn,An */
void REGPARAM2 op_2040_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 4 (1/0) */
/* 2 0,0   */

/* MOVEA.L An,An */
void REGPARAM2 op_2048_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_areg(regs, srcreg);
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 4 (1/0) */
/* 2 0,0   */

/* MOVEA.L (An),An */
void REGPARAM2 op_2050_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 12 (3/0) */
/* 2 0,0   */

/* MOVEA.L (An)+,An */
void REGPARAM2 op_2058_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) += 4;
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 12 (3/0) */
/* 2 0,0   */

/* MOVEA.L -(An),An */
void REGPARAM2 op_2060_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	do_cycles_ce000_internal(2);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 14 (3/0) */
/* 2 0,0   */

/* MOVEA.L (d16,An),An */
void REGPARAM2 op_2068_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (4/0) */
/* 4 0,0   */

/* MOVEA.L (d8,An,Xn),An */
void REGPARAM2 op_2070_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 18 (4/0) */
/* 4 4,0   */

/* MOVEA.L (xxx).W,An */
void REGPARAM2 op_2078_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (4/0) */
/* 4 0,0   */

/* MOVEA.L (xxx).L,An */
void REGPARAM2 op_2079_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (5/0) */
/* 6 0,0   */

/* MOVEA.L (d16,PC),An */
void REGPARAM2 op_207a_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 2);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 2);
		return;
	}
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (4/0) */
/* 4 0,0   */

/* MOVEA.L (d8,PC,Xn),An */
void REGPARAM2 op_207b_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(tmppc, get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 2);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 2);
		return;
	}
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 18 (4/0) */
/* 4 4,0   */

/* MOVEA.L #<data>.L,An */
void REGPARAM2 op_207c_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 12; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 12 (3/0) */
/* 6 0,0   */

/* MOVE.L Dn,(An) */
void REGPARAM2 op_2080_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	int loop_mode = regs.loop_mode;
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	if (dsta & 1) {
		m68k_incpci(4);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_ce000_prefetch(2);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 4 << 16;
	}
	regs.loop_mode = loop_mode;
	return;
}
/* 12 (1/2) */
/* 2 0,0   */

/* MOVE.L An,(An) */
void REGPARAM2 op_2088_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	int loop_mode = regs.loop_mode;
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	if (dsta & 1) {
		m68k_incpci(4);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_ce000_prefetch(2);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 4 << 16;
	}
	regs.loop_mode = loop_mode;
	return;
}
/* 12 (1/2) */
/* 2 0,0   */

/* MOVE.L (An),(An) */
void REGPARAM2 op_2090_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	ipl_fetch_now();
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_ce000_prefetch(2);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 2 << 16;
	}
	regs.loop_mode = loop_mode;
	return;
}
/* 20 (3/2) */
/* 2 0,0   */

/* MOVE.L (An)+,(An) */
void REGPARAM2 op_2098_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	ipl_fetch_now();
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_ce000_prefetch(2);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 2 << 16;
	}
	regs.loop_mode = loop_mode;
	return;
}
/* 20 (3/2) */
/* 2 0,0   */

/* MOVE.L -(An),(An) */
void REGPARAM2 op_20a0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	do_cycles_ce000_internal(2);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	ipl_fetch_now();
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_ce000_prefetch(2);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 2 << 16;
	}
	regs.loop_mode = loop_mode;
	return;
}
/* 22 (3/2) */
/* 2 0,0   */

/* MOVE.L (d16,An),(An) */
void REGPARAM2 op_20a8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	ipl_fetch_now();
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 24 (4/2) */
/* 4 0,0   */

/* MOVE.L (d8,An,Xn),(An) */
void REGPARAM2 op_20b0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	ipl_fetch_now();
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 26 (4/2) */
/* 4 4,0   */

/* MOVE.L (xxx).W,(An) */
void REGPARAM2 op_20b8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	ipl_fetch_now();
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 24 (4/2) */
/* 4 0,0   */

/* MOVE.L (xxx).L,(An) */
void REGPARAM2 op_20b9_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(8);
		ccr_68000_long_move_ae_LZN(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	ipl_fetch_next();
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 28 (5/2) */
/* 6 0,0   */

/* MOVE.L (d16,PC),(An) */
void REGPARAM2 op_20ba_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 2);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 2);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	ipl_fetch_now();
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 24 (4/2) */
/* 4 0,0   */

/* MOVE.L (d8,PC,Xn),(An) */
void REGPARAM2 op_20bb_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(tmppc, get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 2);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 2);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	ipl_fetch_now();
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 26 (4/2) */
/* 4 4,0   */

/* MOVE.L #<data>.L,(An) */
void REGPARAM2 op_20bc_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	ipl_fetch_now();
	if (dsta & 1) {
		m68k_incpci(8);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (3/2) */
/* 6 0,0   */

/* MOVE.L Dn,(An)+ */
void REGPARAM2 op_20c0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	int loop_mode = regs.loop_mode;
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	if (dsta & 1) {
		m68k_incpci(4);
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_ce000_prefetch(2);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 4 << 16;
	}
	regs.loop_mode = loop_mode;
	return;
}
/* 12 (1/2) */
/* 2 0,0   */

/* MOVE.L An,(An)+ */
void REGPARAM2 op_20c8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	int loop_mode = regs.loop_mode;
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	if (dsta & 1) {
		m68k_incpci(4);
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_ce000_prefetch(2);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 4 << 16;
	}
	regs.loop_mode = loop_mode;
	return;
}
/* 12 (1/2) */
/* 2 0,0   */

/* MOVE.L (An),(An)+ */
void REGPARAM2 op_20d0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	ipl_fetch_now();
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_ce000_prefetch(2);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 2 << 16;
	}
	regs.loop_mode = loop_mode;
	return;
}
/* 20 (3/2) */
/* 2 0,0   */

/* MOVE.L (An)+,(An)+ */
void REGPARAM2 op_20d8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	ipl_fetch_now();
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_ce000_prefetch(2);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 2 << 16;
	}
	regs.loop_mode = loop_mode;
	return;
}
/* 20 (3/2) */
/* 2 0,0   */

/* MOVE.L -(An),(An)+ */
void REGPARAM2 op_20e0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	do_cycles_ce000_internal(2);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	ipl_fetch_now();
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_ce000_prefetch(2);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 2 << 16;
	}
	regs.loop_mode = loop_mode;
	return;
}
/* 22 (3/2) */
/* 2 0,0   */

/* MOVE.L (d16,An),(An)+ */
void REGPARAM2 op_20e8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	ipl_fetch_now();
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 24 (4/2) */
/* 4 0,0   */

/* MOVE.L (d8,An,Xn),(An)+ */
void REGPARAM2 op_20f0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	ipl_fetch_now();
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 26 (4/2) */
/* 4 4,0   */

/* MOVE.L (xxx).W,(An)+ */
void REGPARAM2 op_20f8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	ipl_fetch_now();
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 24 (4/2) */
/* 4 0,0   */

/* MOVE.L (xxx).L,(An)+ */
void REGPARAM2 op_20f9_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	ipl_fetch_now();
	if (dsta & 1) {
		m68k_incpci(8);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 28 (5/2) */
/* 6 0,0   */

/* MOVE.L (d16,PC),(An)+ */
void REGPARAM2 op_20fa_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 2);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 2);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	ipl_fetch_now();
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 24 (4/2) */
/* 4 0,0   */

/* MOVE.L (d8,PC,Xn),(An)+ */
void REGPARAM2 op_20fb_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(tmppc, get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 2);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 2);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	ipl_fetch_now();
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 26 (4/2) */
/* 4 4,0   */

/* MOVE.L #<data>.L,(An)+ */
void REGPARAM2 op_20fc_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	ipl_fetch_now();
	if (dsta & 1) {
		m68k_incpci(8);
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		m68k_areg(regs, dstreg) -= 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (3/2) */
/* 6 0,0   */

/* MOVE.L Dn,-(An) */
void REGPARAM2 op_2100_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 14; 
	ipl_fetch_next_pre();
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += 4;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	do_cycles_ce000_internal(2);
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) = dsta + 4;
		dsta += 2;
		exception3_write_access(opcode, dsta, 2, src, 1);
		return;
	}
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	m68k_incpci(2);
	return;
}
/* 14 (1/2) */
/* 2 0,0   */

/* MOVE.L An,-(An) */
void REGPARAM2 op_2108_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 14; 
	ipl_fetch_next_pre();
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += 4;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	do_cycles_ce000_internal(2);
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) = dsta + 4;
		dsta += 2;
		exception3_write_access(opcode, dsta, 2, src, 1);
		return;
	}
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	m68k_incpci(2);
	return;
}
/* 14 (1/2) */
/* 2 0,0   */

/* MOVE.L (An),-(An) */
void REGPARAM2 op_2110_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			m68k_areg(regs, dstreg) += 4;
			ccr_68000_long_move_ae_LZN(src);
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode = 1;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) = dsta + 4;
		dsta += 2;
		exception3_write_access(opcode, dsta, 2, src, 1);
		return;
	}
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	m68k_incpci(2);
	regs.loop_mode = loop_mode;
	return;
}
/* 20 (3/2) */
/* 2 0,0   */

/* MOVE.L (An)+,-(An) */
void REGPARAM2 op_2118_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			m68k_areg(regs, dstreg) += 4;
			ccr_68000_long_move_ae_LZN(src);
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode = 1;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) = dsta + 4;
		dsta += 2;
		exception3_write_access(opcode, dsta, 2, src, 1);
		return;
	}
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	m68k_incpci(2);
	regs.loop_mode = loop_mode;
	return;
}
/* 20 (3/2) */
/* 2 0,0   */

/* MOVE.L -(An),-(An) */
void REGPARAM2 op_2120_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	do_cycles_ce000_internal(2);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			m68k_areg(regs, dstreg) += 4;
			ccr_68000_long_move_ae_LZN(src);
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode = 1;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) = dsta + 4;
		dsta += 2;
		exception3_write_access(opcode, dsta, 2, src, 1);
		return;
	}
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	m68k_incpci(2);
	regs.loop_mode = loop_mode;
	return;
}
/* 22 (3/2) */
/* 2 0,0   */

/* MOVE.L (d16,An),-(An) */
void REGPARAM2 op_2128_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += 4;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) = dsta + 4;
		dsta += 2;
		exception3_write_access(opcode, dsta, 2, src, 1);
		return;
	}
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 24 (4/2) */
/* 4 0,0   */

/* MOVE.L (d8,An,Xn),-(An) */
void REGPARAM2 op_2130_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += 4;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) = dsta + 4;
		dsta += 2;
		exception3_write_access(opcode, dsta, 2, src, 1);
		return;
	}
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 26 (4/2) */
/* 4 4,0   */

/* MOVE.L (xxx).W,-(An) */
void REGPARAM2 op_2138_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += 4;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) = dsta + 4;
		dsta += 2;
		exception3_write_access(opcode, dsta, 2, src, 1);
		return;
	}
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 24 (4/2) */
/* 4 0,0   */

/* MOVE.L (xxx).L,-(An) */
void REGPARAM2 op_2139_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += 4;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(8);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) = dsta + 4;
		dsta += 2;
		exception3_write_access(opcode, dsta, 2, src, 1);
		return;
	}
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 28 (5/2) */
/* 6 0,0   */

/* MOVE.L (d16,PC),-(An) */
void REGPARAM2 op_213a_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 2);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 2);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += 4;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) = dsta + 4;
		dsta += 2;
		exception3_write_access(opcode, dsta, 2, src, 1);
		return;
	}
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 24 (4/2) */
/* 4 0,0   */

/* MOVE.L (d8,PC,Xn),-(An) */
void REGPARAM2 op_213b_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(tmppc, get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 2);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 2);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += 4;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) = dsta + 4;
		dsta += 2;
		exception3_write_access(opcode, dsta, 2, src, 1);
		return;
	}
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 26 (4/2) */
/* 4 4,0   */

/* MOVE.L #<data>.L,-(An) */
void REGPARAM2 op_213c_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += 4;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	if (dsta & 1) {
		m68k_incpci(8);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) = dsta + 4;
		dsta += 2;
		exception3_write_access(opcode, dsta, 2, src, 1);
		return;
	}
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		ccr_68000_long_move_ae_normal(src);
		m68k_areg(regs, dstreg) += 4;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 20 (3/2) */
/* 6 0,0   */

/* MOVE.L Dn,(d16,An) */
void REGPARAM2 op_2140_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_HNZ(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		SET_NFLG(src < 0);
		if((src & 0xffff0000)) SET_ZFLG(0);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (2/2) */
/* 4 0,0   */

/* MOVE.L An,(d16,An) */
void REGPARAM2 op_2148_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_HNZ(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		SET_NFLG(src < 0);
		if((src & 0xffff0000)) SET_ZFLG(0);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (2/2) */
/* 4 0,0   */

/* MOVE.L (An),(d16,An) */
void REGPARAM2 op_2150_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 4, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	ipl_fetch_now();
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 24 (4/2) */
/* 4 0,0   */

/* MOVE.L (An)+,(d16,An) */
void REGPARAM2 op_2158_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 4, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	ipl_fetch_now();
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 24 (4/2) */
/* 4 0,0   */

/* MOVE.L -(An),(d16,An) */
void REGPARAM2 op_2160_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	do_cycles_ce000_internal(2);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 4, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	ipl_fetch_now();
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 26 (4/2) */
/* 4 0,0   */

/* MOVE.L (d16,An),(d16,An) */
void REGPARAM2 op_2168_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	ipl_fetch_now();
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 28 (5/2) */
/* 6 0,0   */

/* MOVE.L (d8,An,Xn),(d16,An) */
void REGPARAM2 op_2170_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 30; 
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	ipl_fetch_now();
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 30 (5/2) */
/* 6 6,0   */

/* MOVE.L (xxx).W,(d16,An) */
void REGPARAM2 op_2178_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	ipl_fetch_now();
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 28 (5/2) */
/* 6 0,0   */

/* MOVE.L (xxx).L,(d16,An) */
void REGPARAM2 op_2179_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 32; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 8, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(8);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	ipl_fetch_now();
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(8);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 32 (6/2) */
/* 8 0,0   */

/* MOVE.L (d16,PC),(d16,An) */
void REGPARAM2 op_217a_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 2);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 2);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	ipl_fetch_now();
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 28 (5/2) */
/* 6 0,0   */

/* MOVE.L (d8,PC,Xn),(d16,An) */
void REGPARAM2 op_217b_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 30; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(tmppc, get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 2);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 2);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	ipl_fetch_now();
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 30 (5/2) */
/* 6 6,0   */

/* MOVE.L #<data>.L,(d16,An) */
void REGPARAM2 op_217c_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, 0);
		return;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	if (dsta & 1) {
		m68k_incpci(8);
		ccr_68000_long_move_ae_HNZ(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		ccr_68000_long_move_ae_HNZ(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(8);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 24 (4/2) */
/* 8 0,0   */

/* MOVE.L Dn,(d8,An,Xn) */
void REGPARAM2 op_2180_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_HNZ(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		SET_NFLG(src < 0);
		if((src & 0xffff0000)) SET_ZFLG(0);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 18 (2/2) */
/* 4 4,0   */

/* MOVE.L An,(d8,An,Xn) */
void REGPARAM2 op_2188_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_HNZ(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		SET_NFLG(src < 0);
		if((src & 0xffff0000)) SET_ZFLG(0);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 18 (2/2) */
/* 4 4,0   */

/* MOVE.L (An),(d8,An,Xn) */
void REGPARAM2 op_2190_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 4, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	ipl_fetch_now();
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 26 (4/2) */
/* 4 4,0   */

/* MOVE.L (An)+,(d8,An,Xn) */
void REGPARAM2 op_2198_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 4, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	ipl_fetch_now();
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 26 (4/2) */
/* 4 4,0   */

/* MOVE.L -(An),(d8,An,Xn) */
void REGPARAM2 op_21a0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	do_cycles_ce000_internal(2);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 4, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	ipl_fetch_now();
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 28 (4/2) */
/* 4 4,0   */

/* MOVE.L (d16,An),(d8,An,Xn) */
void REGPARAM2 op_21a8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 30; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	ipl_fetch_now();
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 30 (5/2) */
/* 6 4,0   */

/* MOVE.L (d8,An,Xn),(d8,An,Xn) */
void REGPARAM2 op_21b0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 32; 
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	ipl_fetch_now();
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 32 (5/2) */
/* 6 6,4   */

/* MOVE.L (xxx).W,(d8,An,Xn) */
void REGPARAM2 op_21b8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 30; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	ipl_fetch_now();
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 30 (5/2) */
/* 6 4,0   */

/* MOVE.L (xxx).L,(d8,An,Xn) */
void REGPARAM2 op_21b9_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 34; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(8));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 8, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(8);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	ipl_fetch_now();
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(8);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 34 (6/2) */
/* 8 4,0   */

/* MOVE.L (d16,PC),(d8,An,Xn) */
void REGPARAM2 op_21ba_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 30; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 2);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 2);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	ipl_fetch_now();
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 30 (5/2) */
/* 6 4,0   */

/* MOVE.L (d8,PC,Xn),(d8,An,Xn) */
void REGPARAM2 op_21bb_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 32; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(tmppc, get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 2);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 2);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	ipl_fetch_now();
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 32 (5/2) */
/* 6 6,4   */

/* MOVE.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 op_21bc_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(8));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, 0);
		return;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	if (dsta & 1) {
		m68k_incpci(8);
		ccr_68000_long_move_ae_HNZ(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		ccr_68000_long_move_ae_HNZ(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(8);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 26 (4/2) */
/* 8 4,0   */

/* MOVE.L Dn,(xxx).W */
void REGPARAM2 op_21c0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 4, 0);
		return;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	ipl_fetch_now();
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (2/2) */
/* 4 0,0   */

/* MOVE.L An,(xxx).W */
void REGPARAM2 op_21c8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 4, 0);
		return;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	ipl_fetch_now();
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (2/2) */
/* 4 0,0   */

/* MOVE.L (An),(xxx).W */
void REGPARAM2 op_21d0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 4, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	ipl_fetch_now();
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 24 (4/2) */
/* 4 0,0   */

/* MOVE.L (An)+,(xxx).W */
void REGPARAM2 op_21d8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 4, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	ipl_fetch_now();
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 24 (4/2) */
/* 4 0,0   */

/* MOVE.L -(An),(xxx).W */
void REGPARAM2 op_21e0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	do_cycles_ce000_internal(2);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 4, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	ipl_fetch_now();
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 26 (4/2) */
/* 4 0,0   */

/* MOVE.L (d16,An),(xxx).W */
void REGPARAM2 op_21e8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	ipl_fetch_now();
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 28 (5/2) */
/* 6 0,0   */

/* MOVE.L (d8,An,Xn),(xxx).W */
void REGPARAM2 op_21f0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 30; 
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	ipl_fetch_now();
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 30 (5/2) */
/* 6 6,0   */

/* MOVE.L (xxx).W,(xxx).W */
void REGPARAM2 op_21f8_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	ipl_fetch_now();
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 28 (5/2) */
/* 6 0,0   */

/* MOVE.L (xxx).L,(xxx).W */
void REGPARAM2 op_21f9_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 30;
	CurrentInstrCycles = 32; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 8, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(8);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	ipl_fetch_now();
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(8);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 32 (6/2) */
/* 8 0,0   */

/* MOVE.L (d16,PC),(xxx).W */
void REGPARAM2 op_21fa_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 2);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 2);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	ipl_fetch_now();
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 28 (5/2) */
/* 6 0,0   */

/* MOVE.L (d8,PC,Xn),(xxx).W */
void REGPARAM2 op_21fb_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 30;
	CurrentInstrCycles = 30; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(tmppc, get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 2);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 2);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	ipl_fetch_now();
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 30 (5/2) */
/* 6 6,0   */

/* MOVE.L #<data>.L,(xxx).W */
void REGPARAM2 op_21fc_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 8, 0);
		return;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	if (dsta & 1) {
		m68k_incpci(8);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	ipl_fetch_now();
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	m68k_incpci(8);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 24 (4/2) */
/* 8 0,0   */

/* MOVE.L Dn,(xxx).L */
void REGPARAM2 op_23c0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		// nothing;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	dsta |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	ipl_fetch_next();
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (3/2) */
/* 6 0,0   */

/* MOVE.L An,(xxx).L */
void REGPARAM2 op_23c8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		// nothing;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	dsta |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	ipl_fetch_next();
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (3/2) */
/* 6 0,0   */

/* MOVE.L (An),(xxx).L */
void REGPARAM2 op_23d0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(4) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		// nothing;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		regs.irc = dsta >> 16;
		ccr_68000_long_move_ae_LZN(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	ipl_fetch_now();
	m68k_incpci(6);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 28 (5/2) */
/* 6 0,0   */

/* MOVE.L (An)+,(xxx).L */
void REGPARAM2 op_23d8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(4) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		// nothing;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		regs.irc = dsta >> 16;
		ccr_68000_long_move_ae_LZN(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	ipl_fetch_now();
	m68k_incpci(6);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 28 (5/2) */
/* 6 0,0   */

/* MOVE.L -(An),(xxx).L */
void REGPARAM2 op_23e0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 30; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	do_cycles_ce000_internal(2);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(4) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		// nothing;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(4);
		regs.irc = dsta >> 16;
		ccr_68000_long_move_ae_LZN(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_LZN(src);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		ccr_68000_long_move_ae_normal(src);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	ipl_fetch_now();
	m68k_incpci(6);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 30 (5/2) */
/* 6 0,0   */

/* MOVE.L (d16,An),(xxx).L */
void REGPARAM2 op_23e8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 32; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(6) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		// nothing;
		exception2_fetch(opcode, 6, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		regs.irc = dsta >> 16;
		ccr_68000_long_move_ae_LZN(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	ipl_fetch_now();
	m68k_incpci(8);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 32 (6/2) */
/* 8 0,0   */

/* MOVE.L (d8,An,Xn),(xxx).L */
void REGPARAM2 op_23f0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 34; 
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(6) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		// nothing;
		exception2_fetch(opcode, 6, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		regs.irc = dsta >> 16;
		ccr_68000_long_move_ae_LZN(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	ipl_fetch_now();
	m68k_incpci(8);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 34 (6/2) */
/* 8 8,0   */

/* MOVE.L (xxx).W,(xxx).L */
void REGPARAM2 op_23f8_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 30;
	CurrentInstrCycles = 32; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(6) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		// nothing;
		exception2_fetch(opcode, 6, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		regs.irc = dsta >> 16;
		ccr_68000_long_move_ae_LZN(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	ipl_fetch_now();
	m68k_incpci(8);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 32 (6/2) */
/* 8 0,0   */

/* MOVE.L (xxx).L,(xxx).L */
void REGPARAM2 op_23f9_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 30;
	CurrentInstrCycles = 36; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(8) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		// nothing;
		exception2_fetch(opcode, 8, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(8);
		regs.irc = dsta >> 16;
		ccr_68000_long_move_ae_LZN(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		ccr_68000_long_move_ae_LZN(src);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		ccr_68000_long_move_ae_normal(src);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	ipl_fetch_now();
	m68k_incpci(10);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 36 (7/2) */
/* 10 0,0   */

/* MOVE.L (d16,PC),(xxx).L */
void REGPARAM2 op_23fa_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 30;
	CurrentInstrCycles = 32; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 2);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 2);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(6) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		// nothing;
		exception2_fetch(opcode, 6, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		regs.irc = dsta >> 16;
		ccr_68000_long_move_ae_LZN(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	ipl_fetch_now();
	m68k_incpci(8);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 32 (6/2) */
/* 8 0,0   */

/* MOVE.L (d8,PC,Xn),(xxx).L */
void REGPARAM2 op_23fb_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 30;
	CurrentInstrCycles = 34; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(tmppc, get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 2);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 2);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(6) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		// nothing;
		exception2_fetch(opcode, 6, 0);
		return;
	}
	if (dsta & 1) {
		m68k_incpci(6);
		regs.irc = dsta >> 16;
		ccr_68000_long_move_ae_LZN(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_LZN(src);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		ccr_68000_long_move_ae_normal(src);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	ipl_fetch_now();
	m68k_incpci(8);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 34 (6/2) */
/* 8 8,0   */

/* MOVE.L #<data>.L,(xxx).L */
void REGPARAM2 op_23fc_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	src |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(8) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 8, -2);
		return;
	}
	dsta |= get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_long_move_ae_LZN(src);
		exception2_fetch(opcode, 10, pcoffset);
		return;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	if (dsta & 1) {
		m68k_incpci(10);
		ccr_68000_long_move_ae_normal(src);
		exception3_write_access(opcode, dsta, 2, src >> 16, 1);
		return;
	}
	x_put_word(dsta, src >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 0, 0x1, src >> 16, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_word(dsta + 2, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(10);
		ccr_68000_long_move_ae_normal(src);
		exception2_write(opcode, dsta + 2, 0x1, src, 1);
		return;
	}
	ipl_fetch_next();
	m68k_incpci(10);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 28 (5/2) */
/* 10 0,0   */

/* MOVE.W Dn,Dn */
void REGPARAM2 op_3000_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 4 (1/0) */
/* 2 0,0   */

/* MOVE.W An,Dn */
void REGPARAM2 op_3008_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_areg(regs, srcreg);
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 4 (1/0) */
/* 2 0,0   */

/* MOVE.W (An),Dn */
void REGPARAM2 op_3010_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 8 (2/0) */
/* 2 0,0   */

/* MOVE.W (An)+,Dn */
void REGPARAM2 op_3018_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_areg(regs, srcreg) += 2 + 0;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) += 2 + 0;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 8 (2/0) */
/* 2 0,0   */

/* MOVE.W -(An),Dn */
void REGPARAM2 op_3020_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	do_cycles_ce000_internal(2);
	if (srca & 1) {
		m68k_areg(regs, srcreg) = srca;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 10 (2/0) */
/* 2 0,0   */

/* MOVE.W (d16,An),Dn */
void REGPARAM2 op_3028_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 12 (3/0) */
/* 4 0,0   */

/* MOVE.W (d8,An,Xn),Dn */
void REGPARAM2 op_3030_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 14 (3/0) */
/* 4 4,0   */

/* MOVE.W (xxx).W,Dn */
void REGPARAM2 op_3038_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 12 (3/0) */
/* 4 0,0   */

/* MOVE.W (xxx).L,Dn */
void REGPARAM2 op_3039_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (4/0) */
/* 6 0,0   */

/* MOVE.W (d16,PC),Dn */
void REGPARAM2 op_303a_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 12 (3/0) */
/* 4 0,0   */

/* MOVE.W (d8,PC,Xn),Dn */
void REGPARAM2 op_303b_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(tmppc, get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 14 (3/0) */
/* 4 4,0   */

/* MOVE.W #<data>.W,Dn */
void REGPARAM2 op_303c_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 8 (2/0) */
/* 4 0,0   */

/* MOVEA.W Dn,An */
void REGPARAM2 op_3040_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 4 (1/0) */
/* 2 0,0   */

/* MOVEA.W An,An */
void REGPARAM2 op_3048_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_areg(regs, srcreg);
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 4 (1/0) */
/* 2 0,0   */

/* MOVEA.W (An),An */
void REGPARAM2 op_3050_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 8 (2/0) */
/* 2 0,0   */

/* MOVEA.W (An)+,An */
void REGPARAM2 op_3058_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_areg(regs, srcreg) += 2 + 0;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) += 2 + 0;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) += 2;
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 8 (2/0) */
/* 2 0,0   */

/* MOVEA.W -(An),An */
void REGPARAM2 op_3060_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	do_cycles_ce000_internal(2);
	if (srca & 1) {
		m68k_areg(regs, srcreg) = srca;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(2);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 10 (2/0) */
/* 2 0,0   */

/* MOVEA.W (d16,An),An */
void REGPARAM2 op_3068_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 12 (3/0) */
/* 4 0,0   */

/* MOVEA.W (d8,An,Xn),An */
void REGPARAM2 op_3070_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 14 (3/0) */
/* 4 4,0   */

/* MOVEA.W (xxx).W,An */
void REGPARAM2 op_3078_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 12 (3/0) */
/* 4 0,0   */

/* MOVEA.W (xxx).L,An */
void REGPARAM2 op_3079_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (4/0) */
/* 6 0,0   */

/* MOVEA.W (d16,PC),An */
void REGPARAM2 op_307a_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 12 (3/0) */
/* 4 0,0   */

/* MOVEA.W (d8,PC,Xn),An */
void REGPARAM2 op_307b_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(tmppc, get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 14 (3/0) */
/* 4 4,0   */

/* MOVEA.W #<data>.W,An */
void REGPARAM2 op_307c_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 8 (2/0) */
/* 4 0,0   */

/* MOVE.W Dn,(An) */
void REGPARAM2 op_3080_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	int loop_mode = regs.loop_mode;
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		regflags.cznv = oldflags.cznv;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_ce000_prefetch(2);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 4 << 16;
	}
	regs.loop_mode = loop_mode;
	return;
}
/* 8 (1/1) */
/* 2 0,0   */

/* MOVE.W An,(An) */
void REGPARAM2 op_3088_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	int loop_mode = regs.loop_mode;
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		regflags.cznv = oldflags.cznv;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_ce000_prefetch(2);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 4 << 16;
	}
	regs.loop_mode = loop_mode;
	return;
}
/* 8 (1/1) */
/* 2 0,0   */

/* MOVE.W (An),(An) */
void REGPARAM2 op_3090_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_ce000_prefetch(2);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 2 << 16;
	}
	regs.loop_mode = loop_mode;
	return;
}
/* 12 (2/1) */
/* 2 0,0   */

/* MOVE.W (An)+,(An) */
void REGPARAM2 op_3098_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_areg(regs, srcreg) += 2 + 0;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) += 2 + 0;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_ce000_prefetch(2);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 2 << 16;
	}
	regs.loop_mode = loop_mode;
	return;
}
/* 12 (2/1) */
/* 2 0,0   */

/* MOVE.W -(An),(An) */
void REGPARAM2 op_30a0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 14; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	do_cycles_ce000_internal(2);
	if (srca & 1) {
		m68k_areg(regs, srcreg) = srca;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_ce000_prefetch(2);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 2 << 16;
	}
	regs.loop_mode = loop_mode;
	return;
}
/* 14 (2/1) */
/* 2 0,0   */

/* MOVE.W (d16,An),(An) */
void REGPARAM2 op_30a8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.W (d8,An,Xn),(An) */
void REGPARAM2 op_30b0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 18 (3/1) */
/* 4 4,0   */

/* MOVE.W (xxx).W,(An) */
void REGPARAM2 op_30b8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.W (xxx).L,(An) */
void REGPARAM2 op_30b9_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(8);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.W (d16,PC),(An) */
void REGPARAM2 op_30ba_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.W (d8,PC,Xn),(An) */
void REGPARAM2 op_30bb_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(tmppc, get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 18 (3/1) */
/* 4 4,0   */

/* MOVE.W #<data>.W,(An) */
void REGPARAM2 op_30bc_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		regflags.cznv = oldflags.cznv;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 12 (2/1) */
/* 4 0,0   */

/* MOVE.W Dn,(An)+ */
void REGPARAM2 op_30c0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	int loop_mode = regs.loop_mode;
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	ipl_fetch_next_pre();
	if (dsta & 1) {
		m68k_incpci(4);
		regflags.cznv = oldflags.cznv;
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, dstreg) -= 2;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_ce000_prefetch(2);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 4 << 16;
	}
	regs.loop_mode = loop_mode;
	return;
}
/* 8 (1/1) */
/* 2 0,0   */

/* MOVE.W An,(An)+ */
void REGPARAM2 op_30c8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	int loop_mode = regs.loop_mode;
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	ipl_fetch_next_pre();
	if (dsta & 1) {
		m68k_incpci(4);
		regflags.cznv = oldflags.cznv;
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, dstreg) -= 2;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_ce000_prefetch(2);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 4 << 16;
	}
	regs.loop_mode = loop_mode;
	return;
}
/* 8 (1/1) */
/* 2 0,0   */

/* MOVE.W (An),(An)+ */
void REGPARAM2 op_30d0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, dstreg) -= 2;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_ce000_prefetch(2);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 2 << 16;
	}
	regs.loop_mode = loop_mode;
	return;
}
/* 12 (2/1) */
/* 2 0,0   */

/* MOVE.W (An)+,(An)+ */
void REGPARAM2 op_30d8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_areg(regs, srcreg) += 2 + 0;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) += 2 + 0;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, dstreg) -= 2;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_ce000_prefetch(2);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 2 << 16;
	}
	regs.loop_mode = loop_mode;
	return;
}
/* 12 (2/1) */
/* 2 0,0   */

/* MOVE.W -(An),(An)+ */
void REGPARAM2 op_30e0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 14; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	do_cycles_ce000_internal(2);
	if (srca & 1) {
		m68k_areg(regs, srcreg) = srca;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, dstreg) -= 2;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(2);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_ce000_prefetch(2);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 2, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 2 << 16;
	}
	regs.loop_mode = loop_mode;
	return;
}
/* 14 (2/1) */
/* 2 0,0   */

/* MOVE.W (d16,An),(An)+ */
void REGPARAM2 op_30e8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) -= 2;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.W (d8,An,Xn),(An)+ */
void REGPARAM2 op_30f0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) -= 2;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 18 (3/1) */
/* 4 4,0   */

/* MOVE.W (xxx).W,(An)+ */
void REGPARAM2 op_30f8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) -= 2;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.W (xxx).L,(An)+ */
void REGPARAM2 op_30f9_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(8);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		m68k_areg(regs, dstreg) -= 2;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.W (d16,PC),(An)+ */
void REGPARAM2 op_30fa_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) -= 2;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.W (d8,PC,Xn),(An)+ */
void REGPARAM2 op_30fb_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(tmppc, get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) -= 2;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 18 (3/1) */
/* 4 4,0   */

/* MOVE.W #<data>.W,(An)+ */
void REGPARAM2 op_30fc_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	ipl_fetch_now();
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		regflags.cznv = oldflags.cznv;
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		m68k_areg(regs, dstreg) -= 2;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 12 (2/1) */
/* 4 0,0   */

/* MOVE.W Dn,-(An) */
void REGPARAM2 op_3100_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	ipl_fetch_next_pre();
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += 2;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	opcode = regs.ir;
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_areg(regs, dstreg) = dsta;
		m68k_incpci(4);
		get_word_ce000_prefetch((m68k_getpci() & 1) ? -1 : 0);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(2);
	return;
}
/* 8 (1/1) */
/* 2 0,0   */

/* MOVE.W An,-(An) */
void REGPARAM2 op_3108_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	ipl_fetch_next_pre();
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += 2;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	opcode = regs.ir;
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_areg(regs, dstreg) = dsta;
		m68k_incpci(4);
		get_word_ce000_prefetch((m68k_getpci() & 1) ? -1 : 0);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(2);
	return;
}
/* 8 (1/1) */
/* 2 0,0   */

/* MOVE.W (An),-(An) */
void REGPARAM2 op_3110_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			m68k_areg(regs, dstreg) += 2;
			ccr_68000_word_move_ae_normal((uae_s16)src);
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode = 1;
	}
	if (dsta & 1) {
		m68k_areg(regs, dstreg) = dsta;
		m68k_incpci(4);
		get_word_ce000_prefetch((m68k_getpci() & 1) ? -1 : 0);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(2);
	regs.loop_mode = loop_mode;
	return;
}
/* 12 (2/1) */
/* 2 0,0   */

/* MOVE.W (An)+,-(An) */
void REGPARAM2 op_3118_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_areg(regs, srcreg) += 2 + 0;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) += 2 + 0;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			m68k_areg(regs, dstreg) += 2;
			ccr_68000_word_move_ae_normal((uae_s16)src);
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode = 1;
	}
	if (dsta & 1) {
		m68k_areg(regs, dstreg) = dsta;
		m68k_incpci(4);
		get_word_ce000_prefetch((m68k_getpci() & 1) ? -1 : 0);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(2);
	regs.loop_mode = loop_mode;
	return;
}
/* 12 (2/1) */
/* 2 0,0   */

/* MOVE.W -(An),-(An) */
void REGPARAM2 op_3120_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 14; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	do_cycles_ce000_internal(2);
	if (srca & 1) {
		m68k_areg(regs, srcreg) = srca;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			m68k_areg(regs, dstreg) += 2;
			ccr_68000_word_move_ae_normal((uae_s16)src);
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode = 1;
	}
	if (dsta & 1) {
		m68k_areg(regs, dstreg) = dsta;
		m68k_incpci(4);
		get_word_ce000_prefetch((m68k_getpci() & 1) ? -1 : 0);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(2);
	regs.loop_mode = loop_mode;
	return;
}
/* 14 (2/1) */
/* 2 0,0   */

/* MOVE.W (d16,An),-(An) */
void REGPARAM2 op_3128_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += 2;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_areg(regs, dstreg) = dsta;
		m68k_incpci(6);
		get_word_ce000_prefetch((m68k_getpci() & 1) ? -1 : 0);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.W (d8,An,Xn),-(An) */
void REGPARAM2 op_3130_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += 2;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_areg(regs, dstreg) = dsta;
		m68k_incpci(6);
		get_word_ce000_prefetch((m68k_getpci() & 1) ? -1 : 0);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 18 (3/1) */
/* 4 4,0   */

/* MOVE.W (xxx).W,-(An) */
void REGPARAM2 op_3138_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += 2;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_areg(regs, dstreg) = dsta;
		m68k_incpci(6);
		get_word_ce000_prefetch((m68k_getpci() & 1) ? -1 : 0);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.W (xxx).L,-(An) */
void REGPARAM2 op_3139_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += 2;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_areg(regs, dstreg) = dsta;
		m68k_incpci(8);
		get_word_ce000_prefetch((m68k_getpci() & 1) ? -1 : 0);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.W (d16,PC),-(An) */
void REGPARAM2 op_313a_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += 2;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_areg(regs, dstreg) = dsta;
		m68k_incpci(6);
		get_word_ce000_prefetch((m68k_getpci() & 1) ? -1 : 0);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.W (d8,PC,Xn),-(An) */
void REGPARAM2 op_313b_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(tmppc, get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += 2;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_areg(regs, dstreg) = dsta;
		m68k_incpci(6);
		get_word_ce000_prefetch((m68k_getpci() & 1) ? -1 : 0);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 18 (3/1) */
/* 4 4,0   */

/* MOVE.W #<data>.W,-(An) */
void REGPARAM2 op_313c_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	ipl_fetch_now();
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, dstreg) += 2;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_areg(regs, dstreg) = dsta;
		m68k_incpci(6);
		get_word_ce000_prefetch((m68k_getpci() & 1) ? -1 : 0);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		m68k_areg(regs, dstreg) = dsta;
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 12 (2/1) */
/* 4 0,0   */

/* MOVE.W Dn,(d16,An) */
void REGPARAM2 op_3140_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 12 (2/1) */
/* 4 0,0   */

/* MOVE.W An,(d16,An) */
void REGPARAM2 op_3148_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 12 (2/1) */
/* 4 0,0   */

/* MOVE.W (An),(d16,An) */
void REGPARAM2 op_3150_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.W (An)+,(d16,An) */
void REGPARAM2 op_3158_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_areg(regs, srcreg) += 2 + 0;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) += 2 + 0;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.W -(An),(d16,An) */
void REGPARAM2 op_3160_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	do_cycles_ce000_internal(2);
	if (srca & 1) {
		m68k_areg(regs, srcreg) = srca;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 18 (3/1) */
/* 4 0,0   */

/* MOVE.W (d16,An),(d16,An) */
void REGPARAM2 op_3168_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.W (d8,An,Xn),(d16,An) */
void REGPARAM2 op_3170_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 22 (4/1) */
/* 6 6,0   */

/* MOVE.W (xxx).W,(d16,An) */
void REGPARAM2 op_3178_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.W (xxx).L,(d16,An) */
void REGPARAM2 op_3179_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 8, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(8);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(8);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 24 (5/1) */
/* 8 0,0   */

/* MOVE.W (d16,PC),(d16,An) */
void REGPARAM2 op_317a_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.W (d8,PC,Xn),(d16,An) */
void REGPARAM2 op_317b_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(tmppc, get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 22 (4/1) */
/* 6 6,0   */

/* MOVE.W #<data>.W,(d16,An) */
void REGPARAM2 op_317c_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 0);
		return;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (3/1) */
/* 6 0,0   */

/* MOVE.W Dn,(d8,An,Xn) */
void REGPARAM2 op_3180_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 14; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 14 (2/1) */
/* 4 4,0   */

/* MOVE.W An,(d8,An,Xn) */
void REGPARAM2 op_3188_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 14; 
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 14 (2/1) */
/* 4 4,0   */

/* MOVE.W (An),(d8,An,Xn) */
void REGPARAM2 op_3190_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 18 (3/1) */
/* 4 4,0   */

/* MOVE.W (An)+,(d8,An,Xn) */
void REGPARAM2 op_3198_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_areg(regs, srcreg) += 2 + 0;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) += 2 + 0;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 18 (3/1) */
/* 4 4,0   */

/* MOVE.W -(An),(d8,An,Xn) */
void REGPARAM2 op_31a0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	do_cycles_ce000_internal(2);
	if (srca & 1) {
		m68k_areg(regs, srcreg) = srca;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (3/1) */
/* 4 4,0   */

/* MOVE.W (d16,An),(d8,An,Xn) */
void REGPARAM2 op_31a8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 22 (4/1) */
/* 6 4,0   */

/* MOVE.W (d8,An,Xn),(d8,An,Xn) */
void REGPARAM2 op_31b0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 24 (4/1) */
/* 6 6,4   */

/* MOVE.W (xxx).W,(d8,An,Xn) */
void REGPARAM2 op_31b8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 22 (4/1) */
/* 6 4,0   */

/* MOVE.W (xxx).L,(d8,An,Xn) */
void REGPARAM2 op_31b9_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(8));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 8, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(8);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(8);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 26 (5/1) */
/* 8 4,0   */

/* MOVE.W (d16,PC),(d8,An,Xn) */
void REGPARAM2 op_31ba_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 22 (4/1) */
/* 6 4,0   */

/* MOVE.W (d8,PC,Xn),(d8,An,Xn) */
void REGPARAM2 op_31bb_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(tmppc, get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 24 (4/1) */
/* 6 6,4   */

/* MOVE.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_31bc_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	do_cycles_ce000_internal(2);
	dsta = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 0);
		return;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	ipl_fetch_now();
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 18 (3/1) */
/* 6 4,0   */

/* MOVE.W Dn,(xxx).W */
void REGPARAM2 op_31c0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	ipl_fetch_next();
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 12 (2/1) */
/* 4 0,0   */

/* MOVE.W An,(xxx).W */
void REGPARAM2 op_31c8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	ipl_fetch_next();
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 12 (2/1) */
/* 4 0,0   */

/* MOVE.W (An),(xxx).W */
void REGPARAM2 op_31d0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	ipl_fetch_next();
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.W (An)+,(xxx).W */
void REGPARAM2 op_31d8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_areg(regs, srcreg) += 2 + 0;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) += 2 + 0;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	ipl_fetch_next();
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* MOVE.W -(An),(xxx).W */
void REGPARAM2 op_31e0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	do_cycles_ce000_internal(2);
	if (srca & 1) {
		m68k_areg(regs, srcreg) = srca;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	ipl_fetch_next();
	m68k_incpci(4);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 18 (3/1) */
/* 4 0,0   */

/* MOVE.W (d16,An),(xxx).W */
void REGPARAM2 op_31e8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	ipl_fetch_next();
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.W (d8,An,Xn),(xxx).W */
void REGPARAM2 op_31f0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	ipl_fetch_next();
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 22 (4/1) */
/* 6 6,0   */

/* MOVE.W (xxx).W,(xxx).W */
void REGPARAM2 op_31f8_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	ipl_fetch_next();
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.W (xxx).L,(xxx).W */
void REGPARAM2 op_31f9_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 8, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(8);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	ipl_fetch_next();
	m68k_incpci(8);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 24 (5/1) */
/* 8 0,0   */

/* MOVE.W (d16,PC),(xxx).W */
void REGPARAM2 op_31fa_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	ipl_fetch_next();
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.W (d8,PC,Xn),(xxx).W */
void REGPARAM2 op_31fb_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(tmppc, get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	ipl_fetch_next();
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 22 (4/1) */
/* 6 6,0   */

/* MOVE.W #<data>.W,(xxx).W */
void REGPARAM2 op_31fc_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	ipl_fetch_next();
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (3/1) */
/* 6 0,0   */

/* MOVE.W Dn,(xxx).L */
void REGPARAM2 op_33c0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	dsta |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	ipl_fetch_next();
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (3/1) */
/* 6 0,0   */

/* MOVE.W An,(xxx).L */
void REGPARAM2 op_33c8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	dsta |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	ipl_fetch_next();
	m68k_incpci(6);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (3/1) */
/* 6 0,0   */

/* MOVE.W (An),(xxx).L */
void REGPARAM2 op_33d0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(4) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		regs.irc = dsta >> 16;
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	ipl_fetch_now();
	m68k_incpci(6);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.W (An)+,(xxx).L */
void REGPARAM2 op_33d8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_areg(regs, srcreg) += 2 + 0;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) += 2 + 0;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(4) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		regs.irc = dsta >> 16;
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	ipl_fetch_now();
	m68k_incpci(6);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* MOVE.W -(An),(xxx).L */
void REGPARAM2 op_33e0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	do_cycles_ce000_internal(2);
	if (srca & 1) {
		m68k_areg(regs, srcreg) = srca;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(4) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 4, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(4);
		regs.irc = dsta >> 16;
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	ipl_fetch_now();
	m68k_incpci(6);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 22 (4/1) */
/* 6 0,0   */

/* MOVE.W (d16,An),(xxx).L */
void REGPARAM2 op_33e8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(6) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		regs.irc = dsta >> 16;
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	ipl_fetch_now();
	m68k_incpci(8);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 24 (5/1) */
/* 8 0,0   */

/* MOVE.W (d8,An,Xn),(xxx).L */
void REGPARAM2 op_33f0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(6) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		regs.irc = dsta >> 16;
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	ipl_fetch_now();
	m68k_incpci(8);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 26 (5/1) */
/* 8 8,0   */

/* MOVE.W (xxx).W,(xxx).L */
void REGPARAM2 op_33f8_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(6) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		regs.irc = dsta >> 16;
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	ipl_fetch_now();
	m68k_incpci(8);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 24 (5/1) */
/* 8 0,0   */

/* MOVE.W (xxx).L,(xxx).L */
void REGPARAM2 op_33f9_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(8) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 8, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(8);
		regs.irc = dsta >> 16;
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	ipl_fetch_now();
	m68k_incpci(10);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 28 (6/1) */
/* 10 0,0   */

/* MOVE.W (d16,PC),(xxx).L */
void REGPARAM2 op_33fa_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(6) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		regs.irc = dsta >> 16;
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	ipl_fetch_now();
	m68k_incpci(8);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 24 (5/1) */
/* 8 0,0   */

/* MOVE.W (d8,PC,Xn),(xxx).L */
void REGPARAM2 op_33fb_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 30;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(tmppc, get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(6) << 16;
	dsta |= regs.irc;
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 6, 0);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(6);
		regs.irc = dsta >> 16;
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		regs.irc = dsta >> 16;
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	ipl_fetch_now();
	m68k_incpci(8);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 26 (5/1) */
/* 8 8,0   */

/* MOVE.W #<data>.W,(xxx).L */
void REGPARAM2 op_33fc_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = get_word_ce000_prefetch(6) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	dsta |= get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		ccr_68000_word_move_ae_normal((uae_s16)src);
		exception2_fetch(opcode, 8, pcoffset);
		return;
	}
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if (dsta & 1) {
		m68k_incpci(8);
		ccr_68000_word_move_ae_normal((uae_s16)(src));
		exception3_write_access(opcode, dsta, 1, src, 1);
		return;
	}
	x_put_word(dsta, src);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, src, 1);
		return;
	}
	ipl_fetch_next();
	m68k_incpci(8);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (4/1) */
/* 8 0,0   */

/* NEGX.B Dn */
void REGPARAM2 op_4000_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 4;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((newv) & 0xff);
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	m68k_incpci(2);
	return;
}
/* 4 (1/0) */
/* 2 0,0   */

/* NEGX.B (An) */
void REGPARAM2 op_4010_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 12; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode = 1;
	}
	x_put_byte(srca, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x0, newv, 1);
		return;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 12 (2/1) */
/* 2 0,0   */

/* NEGX.B (An)+ */
void REGPARAM2 op_4018_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 12; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode = 1;
	}
	x_put_byte(srca, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x0, newv, 1);
		return;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 12 (2/1) */
/* 2 0,0   */

/* NEGX.B -(An) */
void REGPARAM2 op_4020_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 14; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal(2);
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode = 1;
	}
	x_put_byte(srca, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x0, newv, 1);
		return;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 14 (2/1) */
/* 2 0,0   */

/* NEGX.B (d16,An) */
void REGPARAM2 op_4028_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(srca, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x0, newv, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* NEGX.B (d8,An,Xn) */
void REGPARAM2 op_4030_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(srca, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x0, newv, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 18 (3/1) */
/* 4 4,0   */

/* NEGX.B (xxx).W */
void REGPARAM2 op_4038_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 16;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(srca, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x0, newv, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* NEGX.B (xxx).L */
void REGPARAM2 op_4039_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 16;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(srca, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, srca + 0, 0x0, newv, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* NEGX.W Dn */
void REGPARAM2 op_4040_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((newv) & 0xffff);
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	m68k_incpci(2);
	return;
}
/* 4 (1/0) */
/* 2 0,0   */

/* NEGX.W (An) */
void REGPARAM2 op_4050_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 12; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode = 1;
	}
	x_put_word(srca, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x1, newv, 1);
		return;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 12 (2/1) */
/* 2 0,0   */

/* NEGX.W (An)+ */
void REGPARAM2 op_4058_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 12; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_areg(regs, srcreg) += 2 + 0;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) += 2 + 0;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) += 2;
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode = 1;
	}
	x_put_word(srca, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x1, newv, 1);
		return;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 12 (2/1) */
/* 2 0,0   */

/* NEGX.W -(An) */
void REGPARAM2 op_4060_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 14; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	do_cycles_ce000_internal(2);
	if (srca & 1) {
		m68k_areg(regs, srcreg) = srca;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode = 1;
	}
	x_put_word(srca, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x1, newv, 1);
		return;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 14 (2/1) */
/* 2 0,0   */

/* NEGX.W (d16,An) */
void REGPARAM2 op_4068_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(srca, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, newv, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* NEGX.W (d8,An,Xn) */
void REGPARAM2 op_4070_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(srca, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, newv, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 18 (3/1) */
/* 4 4,0   */

/* NEGX.W (xxx).W */
void REGPARAM2 op_4078_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 16;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(srca, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, newv, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* NEGX.W (xxx).L */
void REGPARAM2 op_4079_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 16;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(srca, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, srca + 0, 0x1, newv, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* NEGX.L Dn */
void REGPARAM2 op_4080_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 6;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	ipl_fetch_next_pre();
	regs.ir = regs.irc;
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		dreg_68000_long_replace_low(srcreg, newv);
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	opcode = regs.ir;
	m68k_dreg(regs, srcreg) = (newv);
	do_cycles_ce000_internal(2);
	m68k_incpci(2);
	return;
}
/* 6 (1/0) */
/* 2 0,0   */

/* NEGX.L (An) */
void REGPARAM2 op_4090_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 20; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			int bflgs = ((uae_s16)(src)) < 0;
			int bflgo = ((uae_s16)(0)) < 0;
			int bflgn = ((uae_s16)(newv)) < 0;
			SET_VFLG((bflgs ^ bflgo) & (bflgo ^ bflgn));
			SET_CFLG(bflgs ^ ((bflgs ^ bflgn) & (bflgo ^ bflgn)));
			SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
			SET_NFLG(((uae_s16)(newv)) < 0);
			SET_XFLG(GET_CFLG());
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode = 1;
	}
	x_put_word(srca + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 2, 0x1, newv, 1);
		return;
	}
	x_put_word(srca, newv >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x1, newv >> 16, 1);
		return;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 20 (3/2) */
/* 2 0,0   */

/* NEGX.L (An)+ */
void REGPARAM2 op_4098_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 20; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) += 4;
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			int bflgs = ((uae_s16)(src)) < 0;
			int bflgo = ((uae_s16)(0)) < 0;
			int bflgn = ((uae_s16)(newv)) < 0;
			SET_VFLG((bflgs ^ bflgo) & (bflgo ^ bflgn));
			SET_CFLG(bflgs ^ ((bflgs ^ bflgn) & (bflgo ^ bflgn)));
			SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
			SET_NFLG(((uae_s16)(newv)) < 0);
			SET_XFLG(GET_CFLG());
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode = 1;
	}
	x_put_word(srca + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 2, 0x1, newv, 1);
		return;
	}
	x_put_word(srca, newv >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x1, newv >> 16, 1);
		return;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 20 (3/2) */
/* 2 0,0   */

/* NEGX.L -(An) */
void REGPARAM2 op_40a0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 22; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	do_cycles_ce000_internal(2);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			int bflgs = ((uae_s16)(src)) < 0;
			int bflgo = ((uae_s16)(0)) < 0;
			int bflgn = ((uae_s16)(newv)) < 0;
			SET_VFLG((bflgs ^ bflgo) & (bflgo ^ bflgn));
			SET_CFLG(bflgs ^ ((bflgs ^ bflgn) & (bflgo ^ bflgn)));
			SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
			SET_NFLG(((uae_s16)(newv)) < 0);
			SET_XFLG(GET_CFLG());
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode = 1;
	}
	x_put_word(srca + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 2, 0x1, newv, 1);
		return;
	}
	x_put_word(srca, newv >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x1, newv >> 16, 1);
		return;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 22 (3/2) */
/* 2 0,0   */

/* NEGX.L (d16,An) */
void REGPARAM2 op_40a8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(0)) < 0;
		int bflgn = ((uae_s16)(newv)) < 0;
		SET_VFLG((bflgs ^ bflgo) & (bflgo ^ bflgn));
		SET_CFLG(bflgs ^ ((bflgs ^ bflgn) & (bflgo ^ bflgn)));
		SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
		SET_NFLG(((uae_s16)(newv)) < 0);
		SET_XFLG(GET_CFLG());
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	x_put_word(srca + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 2, 0x1, newv, 1);
		return;
	}
	x_put_word(srca, newv >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, newv >> 16, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 24 (4/2) */
/* 4 0,0   */

/* NEGX.L (d8,An,Xn) */
void REGPARAM2 op_40b0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(0)) < 0;
		int bflgn = ((uae_s16)(newv)) < 0;
		SET_VFLG((bflgs ^ bflgo) & (bflgo ^ bflgn));
		SET_CFLG(bflgs ^ ((bflgs ^ bflgn) & (bflgo ^ bflgn)));
		SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
		SET_NFLG(((uae_s16)(newv)) < 0);
		SET_XFLG(GET_CFLG());
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	x_put_word(srca + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 2, 0x1, newv, 1);
		return;
	}
	x_put_word(srca, newv >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, newv >> 16, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 26 (4/2) */
/* 4 4,0   */

/* NEGX.L (xxx).W */
void REGPARAM2 op_40b8_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 16;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(0)) < 0;
		int bflgn = ((uae_s16)(newv)) < 0;
		SET_VFLG((bflgs ^ bflgo) & (bflgo ^ bflgn));
		SET_CFLG(bflgs ^ ((bflgs ^ bflgn) & (bflgo ^ bflgn)));
		SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
		SET_NFLG(((uae_s16)(newv)) < 0);
		SET_XFLG(GET_CFLG());
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	x_put_word(srca + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 2, 0x1, newv, 1);
		return;
	}
	x_put_word(srca, newv >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, newv >> 16, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 24 (4/2) */
/* 4 0,0   */

/* NEGX.L (xxx).L */
void REGPARAM2 op_40b9_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 16;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(0)) < 0;
		int bflgn = ((uae_s16)(newv)) < 0;
		SET_VFLG((bflgs ^ bflgo) & (bflgo ^ bflgn));
		SET_CFLG(bflgs ^ ((bflgs ^ bflgn) & (bflgo ^ bflgn)));
		SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
		SET_NFLG(((uae_s16)(newv)) < 0);
		SET_XFLG(GET_CFLG());
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	x_put_word(srca + 2, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, srca + 2, 0x1, newv, 1);
		return;
	}
	x_put_word(srca, newv >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, srca + 0, 0x1, newv >> 16, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 28 (5/2) */
/* 6 0,0   */

/* MVSR2.W Dn */
void REGPARAM2 op_40c0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 4;  
	if (!regs.s) {
		Exception(8);
		return;
	}
	MakeSR();
	regs.ir = regs.irc;
	ipl_fetch_next();
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	opcode = regs.ir;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((regs.sr) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 4 (1/0) */
/* 2 0,0   */

/* MVSR2.W (An) */
void REGPARAM2 op_40d0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 10; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	do_cycles_ce000_internal(2);
	ipl_fetch_now();
	MakeSR();
	regs.ir = regs.irc;
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	opcode = regs.ir;
	if(srca & 1) {
		m68k_incpci(4);
		exception3_write(opcode, srca, 1, regs.sr & 0xffff, 1);
		return;
	}
	x_put_word(srca, regs.sr);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x1, regs.sr, 1);
		return;
	}
	m68k_incpci(2);
	return;
}
/* 10 (1/1) */
/* 2 0,0   */

/* MVSR2.W (An)+ */
void REGPARAM2 op_40d8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 12; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	do_cycles_ce000_internal(4);
	ipl_fetch_now();
	m68k_areg(regs, srcreg) += 2;
	MakeSR();
	regs.ir = regs.irc;
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	opcode = regs.ir;
	if(srca & 1) {
		m68k_incpci(4);
		exception3_write(opcode, srca, 1, regs.sr & 0xffff, 1);
		return;
	}
	x_put_word(srca, regs.sr);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x1, regs.sr, 1);
		return;
	}
	m68k_incpci(2);
	return;
}
/* 12 (1/1) */
/* 2 0,0   */

/* MVSR2.W -(An) */
void REGPARAM2 op_40e0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 12; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	do_cycles_ce000_internal(4);
	ipl_fetch_now();
	m68k_areg(regs, srcreg) = srca;
	MakeSR();
	regs.ir = regs.irc;
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	opcode = regs.ir;
	if(srca & 1) {
		m68k_incpci(4);
		exception3_write(opcode, srca, 1, regs.sr & 0xffff, 1);
		return;
	}
	x_put_word(srca, regs.sr);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x1, regs.sr, 1);
		return;
	}
	m68k_incpci(2);
	return;
}
/* 12 (1/1) */
/* 2 0,0   */

/* MVSR2.W (d16,An) */
void REGPARAM2 op_40e8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 12; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	MakeSR();
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	if(srca & 1) {
		m68k_incpci(6);
		exception3_write(opcode, srca, 1, regs.sr & 0xffff, 1);
		return;
	}
	x_put_word(srca, regs.sr);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, regs.sr, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 12 (2/1) */
/* 4 0,0   */

/* MVSR2.W (d8,An,Xn) */
void REGPARAM2 op_40f0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 16; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	uaecptr srca;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	do_cycles_ce000_internal(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	MakeSR();
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	if(srca & 1) {
		m68k_incpci(6);
		exception3_write(opcode, srca, 1, regs.sr & 0xffff, 1);
		return;
	}
	x_put_word(srca, regs.sr);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, regs.sr, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (2/1) */
/* 4 4,0   */

/* MVSR2.W (xxx).W */
void REGPARAM2 op_40f8_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 32;
	CurrentInstrCycles = 12; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	ipl_fetch_now();
	MakeSR();
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	if(srca & 1) {
		m68k_incpci(6);
		exception3_write(opcode, srca, 1, regs.sr & 0xffff, 1);
		return;
	}
	x_put_word(srca, regs.sr);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, regs.sr, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 12 (2/1) */
/* 4 0,0   */

/* MVSR2.W (xxx).L */
void REGPARAM2 op_40f9_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 32;
	CurrentInstrCycles = 16; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	ipl_fetch_now();
	MakeSR();
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	if(srca & 1) {
		m68k_incpci(8);
		exception3_write(opcode, srca, 1, regs.sr & 0xffff, 1);
		return;
	}
	x_put_word(srca, regs.sr);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, srca + 0, 0x1, regs.sr, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 16 (3/1) */
/* 6 0,0   */

/* CHK.W Dn,Dn */
void REGPARAM2 op_4180_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 10; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(2);
	do_cycles_ce000_internal(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	do_cycles_ce000_internal(2);
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 1);
	ipl_fetch_next();
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 10 (1/0) */
/* 2 0,0   */

/* CHK.W (An),Dn */
void REGPARAM2 op_4190_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uae_s16 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(2);
	do_cycles_ce000_internal(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	do_cycles_ce000_internal(2);
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 1);
	ipl_fetch_next();
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 14 (2/0) */
/* 2 0,0   */

/* CHK.W (An)+,Dn */
void REGPARAM2 op_4198_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_areg(regs, srcreg) += 2 + 0;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) += 2 + 0;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) += 2;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(2);
	do_cycles_ce000_internal(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	do_cycles_ce000_internal(2);
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 1);
	ipl_fetch_next();
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 14 (2/0) */
/* 2 0,0   */

/* CHK.W -(An),Dn */
void REGPARAM2 op_41a0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	do_cycles_ce000_internal(2);
	if (srca & 1) {
		m68k_areg(regs, srcreg) = srca;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(2);
	do_cycles_ce000_internal(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	do_cycles_ce000_internal(2);
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 1);
	ipl_fetch_next();
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (2/0) */
/* 2 0,0   */

/* CHK.W (d16,An),Dn */
void REGPARAM2 op_41a8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uae_s16 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(4);
	do_cycles_ce000_internal(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	do_cycles_ce000_internal(2);
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 1);
	ipl_fetch_next();
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 18 (3/0) */
/* 4 0,0   */

/* CHK.W (d8,An,Xn),Dn */
void REGPARAM2 op_41b0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uae_s16 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(4);
	do_cycles_ce000_internal(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	do_cycles_ce000_internal(2);
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 1);
	ipl_fetch_next();
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (3/0) */
/* 4 4,0   */

/* CHK.W (xxx).W,Dn */
void REGPARAM2 op_41b8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uae_s16 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(4);
	do_cycles_ce000_internal(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	do_cycles_ce000_internal(2);
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 1);
	ipl_fetch_next();
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 18 (3/0) */
/* 4 0,0   */

/* CHK.W (xxx).L,Dn */
void REGPARAM2 op_41b9_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uae_s16 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(6);
	do_cycles_ce000_internal(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	do_cycles_ce000_internal(2);
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 1);
	ipl_fetch_next();
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 22 (4/0) */
/* 6 0,0   */

/* CHK.W (d16,PC),Dn */
void REGPARAM2 op_41ba_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	uae_s16 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(4);
	do_cycles_ce000_internal(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	do_cycles_ce000_internal(2);
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 1);
	ipl_fetch_next();
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 18 (3/0) */
/* 4 0,0   */

/* CHK.W (d8,PC,Xn),Dn */
void REGPARAM2 op_41bb_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(tmppc, get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	uae_s16 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(4);
	do_cycles_ce000_internal(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	do_cycles_ce000_internal(2);
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 1);
	ipl_fetch_next();
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (3/0) */
/* 4 4,0   */

/* CHK.W #<data>.W,Dn */
void REGPARAM2 op_41bc_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 14; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uae_s16 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(4);
	do_cycles_ce000_internal(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	do_cycles_ce000_internal(2);
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 1);
	ipl_fetch_next();
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 14 (2/0) */
/* 4 0,0   */

/* LEA.L (An),An */
void REGPARAM2 op_41d0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	CurrentInstrCycles = 4;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, dstreg) = (srca);
	ipl_fetch_next();
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	m68k_incpci(2);
	return;
}
/* 4 (1/0) */
/* 2 0,0   */

/* LEA.L (d16,An),An */
void REGPARAM2 op_41e8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	m68k_areg(regs, dstreg) = (srca);
	ipl_fetch_next();
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 8 (2/0) */
/* 4 0,0   */

/* LEA.L (d8,An,Xn),An */
void REGPARAM2 op_41f0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	CurrentInstrCycles = 12; 
	do_cycles_ce000_internal(2);
	uaecptr srca;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	do_cycles_ce000_internal(2);
	m68k_areg(regs, dstreg) = (srca);
	ipl_fetch_next();
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 12 (2/0) */
/* 4 4,0   */

/* LEA.L (xxx).W,An */
void REGPARAM2 op_41f8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	m68k_areg(regs, dstreg) = (srca);
	ipl_fetch_next();
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 8 (2/0) */
/* 4 0,0   */

/* LEA.L (xxx).L,An */
void REGPARAM2 op_41f9_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	m68k_areg(regs, dstreg) = (srca);
	ipl_fetch_next();
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 12 (3/0) */
/* 6 0,0   */

/* LEA.L (d16,PC),An */
void REGPARAM2 op_41fa_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	m68k_areg(regs, dstreg) = (srca);
	ipl_fetch_next();
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 8 (2/0) */
/* 4 0,0   */

/* LEA.L (d8,PC,Xn),An */
void REGPARAM2 op_41fb_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	CurrentInstrCycles = 12; 
	do_cycles_ce000_internal(2);
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	srca = get_disp_ea_000(tmppc, get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	do_cycles_ce000_internal(2);
	m68k_areg(regs, dstreg) = (srca);
	ipl_fetch_next();
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 12 (2/0) */
/* 4 4,0   */

/* CLR.B Dn */
void REGPARAM2 op_4200_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 4;  
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	regs.ir = regs.irc;
	ipl_fetch_next();
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		CLEAR_CZNV();
		SET_ZFLG(1);
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((0) & 0xff);
	m68k_incpci(2);
	return;
}
/* 4 (1/0) */
/* 2 0,0   */

/* CLR.B (An) */
void REGPARAM2 op_4210_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 8;  
	int loop_mode = regs.loop_mode;
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	ipl_fetch_now();
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			CLEAR_CZNV();
			SET_ZFLG(1);
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 4 << 16;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode &= 0xffff0000;
		loop_mode |= 1;
	}
	x_put_byte(srca, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		regflags.cznv = oldflags.cznv;
		exception2_write(opcode, srca + 0, 0x0, 0, 1);
		return;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 8 (1/1) */
/* 2 0,0   */

/* CLR.B (An)+ */
void REGPARAM2 op_4218_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 8;  
	int loop_mode = regs.loop_mode;
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	ipl_fetch_now();
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			CLEAR_CZNV();
			SET_ZFLG(1);
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 4 << 16;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode &= 0xffff0000;
		loop_mode |= 1;
	}
	x_put_byte(srca, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		regflags.cznv = oldflags.cznv;
		m68k_areg(regs, srcreg) -= areg_byteinc[srcreg];
		exception2_write(opcode, srca + 0, 0x0, 0, 1);
		return;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 8 (1/1) */
/* 2 0,0   */

/* CLR.B -(An) */
void REGPARAM2 op_4220_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 10; 
	int loop_mode = regs.loop_mode;
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal(2);
	ipl_fetch_now();
	m68k_areg(regs, srcreg) = srca;
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			CLEAR_CZNV();
			SET_ZFLG(1);
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 4 << 16;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode &= 0xffff0000;
		loop_mode |= 1;
	}
	x_put_byte(srca, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		regflags.cznv = oldflags.cznv;
		m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
		exception2_write(opcode, srca + 0, 0x0, 0, 1);
		return;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 10 (1/1) */
/* 2 0,0   */

/* CLR.B (d16,An) */
void REGPARAM2 op_4228_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 12; 
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		CLEAR_CZNV();
		SET_ZFLG(1);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	x_put_byte(srca, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x0, 0, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 12 (2/1) */
/* 4 0,0   */

/* CLR.B (d8,An,Xn) */
void REGPARAM2 op_4230_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 16; 
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	do_cycles_ce000_internal(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		CLEAR_CZNV();
		SET_ZFLG(1);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	x_put_byte(srca, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x0, 0, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (2/1) */
/* 4 4,0   */

/* CLR.B (xxx).W */
void REGPARAM2 op_4238_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 18;
	CurrentInstrCycles = 12; 
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	ipl_fetch_now();
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		CLEAR_CZNV();
		SET_ZFLG(1);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	x_put_byte(srca, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x0, 0, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 12 (2/1) */
/* 4 0,0   */

/* CLR.B (xxx).L */
void REGPARAM2 op_4239_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 18;
	CurrentInstrCycles = 16; 
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	ipl_fetch_now();
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		CLEAR_CZNV();
		SET_ZFLG(1);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	x_put_byte(srca, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, srca + 0, 0x0, 0, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 16 (3/1) */
/* 6 0,0   */

/* CLR.W Dn */
void REGPARAM2 op_4240_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 4;  
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	regs.ir = regs.irc;
	ipl_fetch_next();
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		CLEAR_CZNV();
		SET_ZFLG(1);
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((0) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 4 (1/0) */
/* 2 0,0   */

/* CLR.W (An) */
void REGPARAM2 op_4250_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 8;  
	int loop_mode = regs.loop_mode;
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	ipl_fetch_now();
	if(srca & 1) {
		m68k_incpci(4);
		exception3_write(opcode, srca, 1, 0, 1);
		return;
	}
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			CLEAR_CZNV();
			SET_ZFLG(1);
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 4 << 16;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode &= 0xffff0000;
		loop_mode |= 1;
	}
	x_put_word(srca, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		regflags.cznv = oldflags.cznv;
		exception2_write(opcode, srca + 0, 0x1, 0, 1);
		return;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 8 (1/1) */
/* 2 0,0   */

/* CLR.W (An)+ */
void REGPARAM2 op_4258_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 8;  
	int loop_mode = regs.loop_mode;
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	ipl_fetch_now();
	m68k_areg(regs, srcreg) += 2;
	if(srca & 1) {
		m68k_areg(regs, srcreg) -= 2;
		m68k_incpci(4);
		exception3_write(opcode, srca, 1, 0, 1);
		return;
	}
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			CLEAR_CZNV();
			SET_ZFLG(1);
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 4 << 16;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode &= 0xffff0000;
		loop_mode |= 1;
	}
	x_put_word(srca, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		regflags.cznv = oldflags.cznv;
		m68k_areg(regs, srcreg) -= 2;
		exception2_write(opcode, srca + 0, 0x1, 0, 1);
		return;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 8 (1/1) */
/* 2 0,0   */

/* CLR.W -(An) */
void REGPARAM2 op_4260_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 10; 
	int loop_mode = regs.loop_mode;
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	do_cycles_ce000_internal(2);
	ipl_fetch_now();
	m68k_areg(regs, srcreg) = srca;
	if(srca & 1) {
		m68k_areg(regs, srcreg) += 2;
		m68k_incpci(4);
		exception3_write(opcode, srca, 1, 0, 1);
		return;
	}
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			CLEAR_CZNV();
			SET_ZFLG(1);
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 4 << 16;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode &= 0xffff0000;
		loop_mode |= 1;
	}
	x_put_word(srca, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		regflags.cznv = oldflags.cznv;
		m68k_areg(regs, srcreg) += 2;
		exception2_write(opcode, srca + 0, 0x1, 0, 1);
		return;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 10 (1/1) */
/* 2 0,0   */

/* CLR.W (d16,An) */
void REGPARAM2 op_4268_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 12; 
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	if(srca & 1) {
		get_word_ce000_prefetch(6);
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(0)) == 0);
		SET_NFLG(((uae_s16)(0)) < 0);
		m68k_incpci(6);
		exception3_write(opcode, srca, 1, 0, 1);
		return;
	}
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		CLEAR_CZNV();
		SET_ZFLG(1);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	x_put_word(srca, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, 0, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 12 (2/1) */
/* 4 0,0   */

/* CLR.W (d8,An,Xn) */
void REGPARAM2 op_4270_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 16; 
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	do_cycles_ce000_internal(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	if(srca & 1) {
		get_word_ce000_prefetch(6);
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(0)) == 0);
		SET_NFLG(((uae_s16)(0)) < 0);
		m68k_incpci(6);
		exception3_write(opcode, srca, 1, 0, 1);
		return;
	}
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		CLEAR_CZNV();
		SET_ZFLG(1);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	x_put_word(srca, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, 0, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (2/1) */
/* 4 4,0   */

/* CLR.W (xxx).W */
void REGPARAM2 op_4278_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 18;
	CurrentInstrCycles = 12; 
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	ipl_fetch_now();
	if(srca & 1) {
		get_word_ce000_prefetch(6);
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(0)) == 0);
		SET_NFLG(((uae_s16)(0)) < 0);
		m68k_incpci(6);
		exception3_write(opcode, srca, 1, 0, 1);
		return;
	}
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		CLEAR_CZNV();
		SET_ZFLG(1);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	x_put_word(srca, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, 0, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 12 (2/1) */
/* 4 0,0   */

/* CLR.W (xxx).L */
void REGPARAM2 op_4279_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 18;
	CurrentInstrCycles = 16; 
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	ipl_fetch_now();
	if(srca & 1) {
		get_word_ce000_prefetch(8);
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(0)) == 0);
		SET_NFLG(((uae_s16)(0)) < 0);
		m68k_incpci(8);
		exception3_write(opcode, srca, 1, 0, 1);
		return;
	}
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		CLEAR_CZNV();
		SET_ZFLG(1);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	x_put_word(srca, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, srca + 0, 0x1, 0, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 16 (3/1) */
/* 6 0,0   */

/* CLR.L Dn */
void REGPARAM2 op_4280_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 6;  
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	do_cycles_ce000_internal(2);
	regs.ir = regs.irc;
	ipl_fetch_next();
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		CLEAR_CZNV();
		SET_ZFLG(1);
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	m68k_dreg(regs, srcreg) = (0);
	m68k_incpci(2);
	return;
}
/* 6 (1/0) */
/* 2 0,0   */

/* CLR.L (An) */
void REGPARAM2 op_4290_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 12; 
	int loop_mode = regs.loop_mode;
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	ipl_fetch_now();
	if(srca & 1) {
		m68k_incpci(4);
		exception3_write(opcode, srca, 1, 0, 1);
		return;
	}
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			CLEAR_CZNV();
			SET_ZFLG(1);
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 4 << 16;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode &= 0xffff0000;
		loop_mode |= 1;
	}
	x_put_word(srca + 2, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		regflags.cznv = oldflags.cznv;
		exception2_write(opcode, srca + 2, 0x1, 0, 1);
		return;
	}
	x_put_word(srca, 0 >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		regflags.cznv = oldflags.cznv;
		exception2_write(opcode, srca + 0, 0x1, 0 >> 16, 1);
		return;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 12 (1/2) */
/* 2 0,0   */

/* CLR.L (An)+ */
void REGPARAM2 op_4298_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 12; 
	int loop_mode = regs.loop_mode;
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	ipl_fetch_now();
	m68k_areg(regs, srcreg) += 4;
	if(srca & 1) {
		m68k_areg(regs, srcreg) -= 4;
		m68k_incpci(4);
		exception3_write(opcode, srca, 1, 0, 1);
		return;
	}
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			CLEAR_CZNV();
			SET_ZFLG(1);
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 4 << 16;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode &= 0xffff0000;
		loop_mode |= 1;
	}
	x_put_word(srca + 2, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		regflags.cznv = oldflags.cznv;
		m68k_areg(regs, srcreg) -= 4;
		exception2_write(opcode, srca + 2, 0x1, 0, 1);
		return;
	}
	x_put_word(srca, 0 >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		regflags.cznv = oldflags.cznv;
		m68k_areg(regs, srcreg) -= 4;
		exception2_write(opcode, srca + 0, 0x1, 0 >> 16, 1);
		return;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 12 (1/2) */
/* 2 0,0   */

/* CLR.L -(An) */
void REGPARAM2 op_42a0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 14; 
	int loop_mode = regs.loop_mode;
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	do_cycles_ce000_internal(2);
	ipl_fetch_now();
	m68k_areg(regs, srcreg) = srca;
	if(srca & 1) {
		m68k_areg(regs, srcreg) += 4;
		srca += 2;
		m68k_incpci(4);
		exception3_write(opcode, srca, 1, 0, 1);
		return;
	}
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			CLEAR_CZNV();
			SET_ZFLG(1);
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 2;
		loop_mode |= 4 << 16;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode &= 0xffff0000;
		loop_mode |= 1;
	}
	x_put_word(srca + 2, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		regflags.cznv = oldflags.cznv;
		m68k_areg(regs, srcreg) += 4;
		exception2_write(opcode, srca + 2, 0x1, 0, 1);
		return;
	}
	x_put_word(srca, 0 >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		regflags.cznv = oldflags.cznv;
		m68k_areg(regs, srcreg) += 4;
		exception2_write(opcode, srca + 0, 0x1, 0 >> 16, 1);
		return;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 14 (1/2) */
/* 2 0,0   */

/* CLR.L (d16,An) */
void REGPARAM2 op_42a8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 16; 
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	if(srca & 1) {
		srca += 2;
		get_word_ce000_prefetch(6);
		CLEAR_CZNV();
		SET_ZFLG(((uae_s32)(0)) == 0);
		SET_NFLG(((uae_s32)(0)) < 0);
		m68k_incpci(6);
		exception3_write(opcode, srca, 1, 0, 1);
		return;
	}
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		CLEAR_CZNV();
		SET_ZFLG(1);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	x_put_word(srca + 2, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 2, 0x1, 0, 1);
		return;
	}
	x_put_word(srca, 0 >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, 0 >> 16, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (2/2) */
/* 4 0,0   */

/* CLR.L (d8,An,Xn) */
void REGPARAM2 op_42b0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 20; 
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	do_cycles_ce000_internal(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	if(srca & 1) {
		srca += 2;
		get_word_ce000_prefetch(6);
		CLEAR_CZNV();
		SET_ZFLG(((uae_s32)(0)) == 0);
		SET_NFLG(((uae_s32)(0)) < 0);
		m68k_incpci(6);
		exception3_write(opcode, srca, 1, 0, 1);
		return;
	}
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		CLEAR_CZNV();
		SET_ZFLG(1);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	x_put_word(srca + 2, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 2, 0x1, 0, 1);
		return;
	}
	x_put_word(srca, 0 >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, 0 >> 16, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 20 (2/2) */
/* 4 4,0   */

/* CLR.L (xxx).W */
void REGPARAM2 op_42b8_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 18;
	CurrentInstrCycles = 16; 
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	ipl_fetch_now();
	if(srca & 1) {
		srca += 2;
		get_word_ce000_prefetch(6);
		CLEAR_CZNV();
		SET_ZFLG(((uae_s32)(0)) == 0);
		SET_NFLG(((uae_s32)(0)) < 0);
		m68k_incpci(6);
		exception3_write(opcode, srca, 1, 0, 1);
		return;
	}
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		CLEAR_CZNV();
		SET_ZFLG(1);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	x_put_word(srca + 2, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 2, 0x1, 0, 1);
		return;
	}
	x_put_word(srca, 0 >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, 0 >> 16, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (2/2) */
/* 4 0,0   */

/* CLR.L (xxx).L */
void REGPARAM2 op_42b9_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 18;
	CurrentInstrCycles = 20; 
	struct flag_struct oldflags;
	oldflags.cznv = regflags.cznv;
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	ipl_fetch_now();
	if(srca & 1) {
		srca += 2;
		get_word_ce000_prefetch(8);
		CLEAR_CZNV();
		SET_ZFLG(((uae_s32)(0)) == 0);
		SET_NFLG(((uae_s32)(0)) < 0);
		m68k_incpci(8);
		exception3_write(opcode, srca, 1, 0, 1);
		return;
	}
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		CLEAR_CZNV();
		SET_ZFLG(1);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	x_put_word(srca + 2, 0);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, srca + 2, 0x1, 0, 1);
		return;
	}
	x_put_word(srca, 0 >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, srca + 0, 0x1, 0 >> 16, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 20 (3/2) */
/* 6 0,0   */

/* MVSR2.B Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_42c0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 4;  
	MakeSR();
	regs.ir = regs.irc;
	ipl_fetch_next();
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	opcode = regs.ir;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((regs.sr & 0xff) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 4 (1/0) */
/* 2 0,0   */

#endif
/* MVSR2.B (An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_42d0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 10; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	do_cycles_ce000_internal(2);
	ipl_fetch_now();
	MakeSR();
	regs.ir = regs.irc;
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	opcode = regs.ir;
	if(srca & 1) {
		m68k_incpci(4);
		exception3_write(opcode, srca, 1, regs.sr & 0xff, 1);
		return;
	}
	x_put_word(srca, regs.sr & 0xff);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x1, regs.sr & 0xff, 1);
		return;
	}
	m68k_incpci(2);
	return;
}
/* 10 (1/1) */
/* 2 0,0   */

#endif
/* MVSR2.B (An)+ */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_42d8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	do_cycles_ce000_internal(4);
	ipl_fetch_now();
	m68k_areg(regs, srcreg) += 2;
	MakeSR();
	regs.ir = regs.irc;
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	opcode = regs.ir;
	if(srca & 1) {
		m68k_incpci(4);
		exception3_write(opcode, srca, 1, regs.sr & 0xff, 1);
		return;
	}
	x_put_word(srca, regs.sr & 0xff);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x1, regs.sr & 0xff, 1);
		return;
	}
	m68k_incpci(2);
	return;
}
/* 12 (1/1) */
/* 2 0,0   */

#endif
/* MVSR2.B -(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_42e0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	do_cycles_ce000_internal(4);
	ipl_fetch_now();
	m68k_areg(regs, srcreg) = srca;
	MakeSR();
	regs.ir = regs.irc;
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	opcode = regs.ir;
	if(srca & 1) {
		m68k_incpci(4);
		exception3_write(opcode, srca, 1, regs.sr & 0xff, 1);
		return;
	}
	x_put_word(srca, regs.sr & 0xff);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x1, regs.sr & 0xff, 1);
		return;
	}
	m68k_incpci(2);
	return;
}
/* 12 (1/1) */
/* 2 0,0   */

#endif
/* MVSR2.B (d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_42e8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	MakeSR();
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	if(srca & 1) {
		m68k_incpci(6);
		exception3_write(opcode, srca, 1, regs.sr & 0xff, 1);
		return;
	}
	x_put_word(srca, regs.sr & 0xff);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, regs.sr & 0xff, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 12 (2/1) */
/* 4 0,0   */

#endif
/* MVSR2.B (d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_42f0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	do_cycles_ce000_internal(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	MakeSR();
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	if(srca & 1) {
		m68k_incpci(6);
		exception3_write(opcode, srca, 1, regs.sr & 0xff, 1);
		return;
	}
	x_put_word(srca, regs.sr & 0xff);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, regs.sr & 0xff, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (2/1) */
/* 4 4,0   */

#endif
/* MVSR2.B (xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_42f8_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 32;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	ipl_fetch_now();
	MakeSR();
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	if(srca & 1) {
		m68k_incpci(6);
		exception3_write(opcode, srca, 1, regs.sr & 0xff, 1);
		return;
	}
	x_put_word(srca, regs.sr & 0xff);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, regs.sr & 0xff, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 12 (2/1) */
/* 4 0,0   */

#endif
/* MVSR2.B (xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_42f9_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 32;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	ipl_fetch_now();
	MakeSR();
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	if(srca & 1) {
		m68k_incpci(8);
		exception3_write(opcode, srca, 1, regs.sr & 0xff, 1);
		return;
	}
	x_put_word(srca, regs.sr & 0xff);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, srca + 0, 0x1, regs.sr & 0xff, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 16 (3/1) */
/* 6 0,0   */

#endif
/* NEG.B Dn */
void REGPARAM2 op_4400_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 4;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((dst) & 0xff);
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	m68k_incpci(2);
	return;
}
/* 4 (1/0) */
/* 2 0,0   */

/* NEG.B (An) */
void REGPARAM2 op_4410_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 12; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode = 1;
	}
	x_put_byte(srca, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x0, dst, 1);
		return;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 12 (2/1) */
/* 2 0,0   */

/* NEG.B (An)+ */
void REGPARAM2 op_4418_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 12; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode = 1;
	}
	x_put_byte(srca, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x0, dst, 1);
		return;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 12 (2/1) */
/* 2 0,0   */

/* NEG.B -(An) */
void REGPARAM2 op_4420_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 14; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal(2);
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode = 1;
	}
	x_put_byte(srca, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x0, dst, 1);
		return;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 14 (2/1) */
/* 2 0,0   */

/* NEG.B (d16,An) */
void REGPARAM2 op_4428_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(srca, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* NEG.B (d8,An,Xn) */
void REGPARAM2 op_4430_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(srca, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 18 (3/1) */
/* 4 4,0   */

/* NEG.B (xxx).W */
void REGPARAM2 op_4438_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 15;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(srca, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* NEG.B (xxx).L */
void REGPARAM2 op_4439_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 15;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(srca, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, srca + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* NEG.W Dn */
void REGPARAM2 op_4440_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((dst) & 0xffff);
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	m68k_incpci(2);
	return;
}
/* 4 (1/0) */
/* 2 0,0   */

/* NEG.W (An) */
void REGPARAM2 op_4450_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 12; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode = 1;
	}
	x_put_word(srca, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x1, dst, 1);
		return;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 12 (2/1) */
/* 2 0,0   */

/* NEG.W (An)+ */
void REGPARAM2 op_4458_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 12; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_areg(regs, srcreg) += 2 + 0;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) += 2 + 0;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) += 2;
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode = 1;
	}
	x_put_word(srca, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x1, dst, 1);
		return;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 12 (2/1) */
/* 2 0,0   */

/* NEG.W -(An) */
void REGPARAM2 op_4460_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 14; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	do_cycles_ce000_internal(2);
	if (srca & 1) {
		m68k_areg(regs, srcreg) = srca;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode = 1;
	}
	x_put_word(srca, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x1, dst, 1);
		return;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 14 (2/1) */
/* 2 0,0   */

/* NEG.W (d16,An) */
void REGPARAM2 op_4468_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(srca, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, dst, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* NEG.W (d8,An,Xn) */
void REGPARAM2 op_4470_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(srca, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, dst, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 18 (3/1) */
/* 4 4,0   */

/* NEG.W (xxx).W */
void REGPARAM2 op_4478_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 15;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(srca, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, dst, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* NEG.W (xxx).L */
void REGPARAM2 op_4479_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 15;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(srca, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, srca + 0, 0x1, dst, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* NEG.L Dn */
void REGPARAM2 op_4480_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 6;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	ipl_fetch_next_pre();
	regs.ir = regs.irc;
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		dreg_68000_long_replace_low(srcreg, dst);
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	opcode = regs.ir;
	m68k_dreg(regs, srcreg) = (dst);
	do_cycles_ce000_internal(2);
	m68k_incpci(2);
	return;
}
/* 6 (1/0) */
/* 2 0,0   */

/* NEG.L (An) */
void REGPARAM2 op_4490_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 20; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			int bflgs = ((uae_s16)(src)) < 0;
			int bflgo = ((uae_s16)(0)) < 0;
			int bflgn = ((uae_s16)(dst)) < 0;
			SET_ZFLG(((uae_s16)(dst)) == 0);
			SET_VFLG((bflgs ^ bflgo) & (bflgn ^ bflgo));
			SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
			SET_NFLG(bflgn != 0);
			SET_XFLG(GET_CFLG());
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode = 1;
	}
	x_put_word(srca + 2, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 2, 0x1, dst, 1);
		return;
	}
	x_put_word(srca, dst >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x1, dst >> 16, 1);
		return;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 20 (3/2) */
/* 2 0,0   */

/* NEG.L (An)+ */
void REGPARAM2 op_4498_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 20; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) += 4;
	uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			int bflgs = ((uae_s16)(src)) < 0;
			int bflgo = ((uae_s16)(0)) < 0;
			int bflgn = ((uae_s16)(dst)) < 0;
			SET_ZFLG(((uae_s16)(dst)) == 0);
			SET_VFLG((bflgs ^ bflgo) & (bflgn ^ bflgo));
			SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
			SET_NFLG(bflgn != 0);
			SET_XFLG(GET_CFLG());
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode = 1;
	}
	x_put_word(srca + 2, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 2, 0x1, dst, 1);
		return;
	}
	x_put_word(srca, dst >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x1, dst >> 16, 1);
		return;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 20 (3/2) */
/* 2 0,0   */

/* NEG.L -(An) */
void REGPARAM2 op_44a0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 22; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	do_cycles_ce000_internal(2);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			int bflgs = ((uae_s16)(src)) < 0;
			int bflgo = ((uae_s16)(0)) < 0;
			int bflgn = ((uae_s16)(dst)) < 0;
			SET_ZFLG(((uae_s16)(dst)) == 0);
			SET_VFLG((bflgs ^ bflgo) & (bflgn ^ bflgo));
			SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
			SET_NFLG(bflgn != 0);
			SET_XFLG(GET_CFLG());
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode = 1;
	}
	x_put_word(srca + 2, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 2, 0x1, dst, 1);
		return;
	}
	x_put_word(srca, dst >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x1, dst >> 16, 1);
		return;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 22 (3/2) */
/* 2 0,0   */

/* NEG.L (d16,An) */
void REGPARAM2 op_44a8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(0)) < 0;
		int bflgn = ((uae_s16)(dst)) < 0;
		SET_ZFLG(((uae_s16)(dst)) == 0);
		SET_VFLG((bflgs ^ bflgo) & (bflgn ^ bflgo));
		SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
		SET_NFLG(bflgn != 0);
		SET_XFLG(GET_CFLG());
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	x_put_word(srca + 2, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 2, 0x1, dst, 1);
		return;
	}
	x_put_word(srca, dst >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, dst >> 16, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 24 (4/2) */
/* 4 0,0   */

/* NEG.L (d8,An,Xn) */
void REGPARAM2 op_44b0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(0)) < 0;
		int bflgn = ((uae_s16)(dst)) < 0;
		SET_ZFLG(((uae_s16)(dst)) == 0);
		SET_VFLG((bflgs ^ bflgo) & (bflgn ^ bflgo));
		SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
		SET_NFLG(bflgn != 0);
		SET_XFLG(GET_CFLG());
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	x_put_word(srca + 2, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 2, 0x1, dst, 1);
		return;
	}
	x_put_word(srca, dst >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, dst >> 16, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 26 (4/2) */
/* 4 4,0   */

/* NEG.L (xxx).W */
void REGPARAM2 op_44b8_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 15;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(0)) < 0;
		int bflgn = ((uae_s16)(dst)) < 0;
		SET_ZFLG(((uae_s16)(dst)) == 0);
		SET_VFLG((bflgs ^ bflgo) & (bflgn ^ bflgo));
		SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
		SET_NFLG(bflgn != 0);
		SET_XFLG(GET_CFLG());
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	x_put_word(srca + 2, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 2, 0x1, dst, 1);
		return;
	}
	x_put_word(srca, dst >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, dst >> 16, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 24 (4/2) */
/* 4 0,0   */

/* NEG.L (xxx).L */
void REGPARAM2 op_44b9_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 15;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		int bflgs = ((uae_s16)(src)) < 0;
		int bflgo = ((uae_s16)(0)) < 0;
		int bflgn = ((uae_s16)(dst)) < 0;
		SET_ZFLG(((uae_s16)(dst)) == 0);
		SET_VFLG((bflgs ^ bflgo) & (bflgn ^ bflgo));
		SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
		SET_NFLG(bflgn != 0);
		SET_XFLG(GET_CFLG());
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	x_put_word(srca + 2, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, srca + 2, 0x1, dst, 1);
		return;
	}
	x_put_word(srca, dst >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, srca + 0, 0x1, dst >> 16, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 28 (5/2) */
/* 6 0,0   */

/* MV2SR.B Dn */
void REGPARAM2 op_44c0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	CurrentInstrCycles = 12; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	do_cycles_ce000_internal(4);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	m68k_incpci(2);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 12 (2/0) */
/* 2 0,0   */

/* MV2SR.B (An) */
void REGPARAM2 op_44d0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	do_cycles_ce000_internal(4);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	m68k_incpci(2);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (3/0) */
/* 2 0,0   */

/* MV2SR.B (An)+ */
void REGPARAM2 op_44d8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_areg(regs, srcreg) += 2 + 0;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) += 2 + 0;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) += 2;
	do_cycles_ce000_internal(4);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	m68k_incpci(2);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (3/0) */
/* 2 0,0   */

/* MV2SR.B -(An) */
void REGPARAM2 op_44e0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	do_cycles_ce000_internal(2);
	if (srca & 1) {
		m68k_areg(regs, srcreg) = srca;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	do_cycles_ce000_internal(4);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	m68k_incpci(2);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 18 (3/0) */
/* 2 0,0   */

/* MV2SR.B (d16,An) */
void REGPARAM2 op_44e8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	do_cycles_ce000_internal(4);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	m68k_incpci(4);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (4/0) */
/* 4 0,0   */

/* MV2SR.B (d8,An,Xn) */
void REGPARAM2 op_44f0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	do_cycles_ce000_internal(4);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	m68k_incpci(4);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 22 (4/0) */
/* 4 4,0   */

/* MV2SR.B (xxx).W */
void REGPARAM2 op_44f8_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 33;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	do_cycles_ce000_internal(4);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	m68k_incpci(4);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (4/0) */
/* 4 0,0   */

/* MV2SR.B (xxx).L */
void REGPARAM2 op_44f9_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 33;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	do_cycles_ce000_internal(4);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	m68k_incpci(6);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 24 (5/0) */
/* 6 0,0   */

/* MV2SR.B (d16,PC) */
void REGPARAM2 op_44fa_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 33;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	do_cycles_ce000_internal(4);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	m68k_incpci(4);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (4/0) */
/* 4 0,0   */

/* MV2SR.B (d8,PC,Xn) */
void REGPARAM2 op_44fb_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 33;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(tmppc, get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	do_cycles_ce000_internal(4);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	m68k_incpci(4);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 22 (4/0) */
/* 4 4,0   */

/* MV2SR.B #<data>.B */
void REGPARAM2 op_44fc_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 33;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	do_cycles_ce000_internal(4);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	m68k_incpci(4);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (3/0) */
/* 4 0,0   */

/* NOT.B Dn */
void REGPARAM2 op_4600_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 4;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_NFLG(((uae_s8)(dst)) < 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((dst) & 0xff);
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	m68k_incpci(2);
	return;
}
/* 4 (1/0) */
/* 2 0,0   */

/* NOT.B (An) */
void REGPARAM2 op_4610_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 12; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_NFLG(((uae_s8)(dst)) < 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode = 1;
	}
	x_put_byte(srca, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x0, dst, 1);
		return;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 12 (2/1) */
/* 2 0,0   */

/* NOT.B (An)+ */
void REGPARAM2 op_4618_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 12; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_NFLG(((uae_s8)(dst)) < 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode = 1;
	}
	x_put_byte(srca, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x0, dst, 1);
		return;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 12 (2/1) */
/* 2 0,0   */

/* NOT.B -(An) */
void REGPARAM2 op_4620_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 14; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal(2);
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_NFLG(((uae_s8)(dst)) < 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode = 1;
	}
	x_put_byte(srca, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x0, dst, 1);
		return;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 14 (2/1) */
/* 2 0,0   */

/* NOT.B (d16,An) */
void REGPARAM2 op_4628_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_NFLG(((uae_s8)(dst)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(srca, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* NOT.B (d8,An,Xn) */
void REGPARAM2 op_4630_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_NFLG(((uae_s8)(dst)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(srca, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 18 (3/1) */
/* 4 4,0   */

/* NOT.B (xxx).W */
void REGPARAM2 op_4638_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 19;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_NFLG(((uae_s8)(dst)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(srca, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* NOT.B (xxx).L */
void REGPARAM2 op_4639_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 19;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_NFLG(((uae_s8)(dst)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(srca, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, srca + 0, 0x0, dst, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* NOT.W Dn */
void REGPARAM2 op_4640_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((dst) & 0xffff);
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	m68k_incpci(2);
	return;
}
/* 4 (1/0) */
/* 2 0,0   */

/* NOT.W (An) */
void REGPARAM2 op_4650_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 12; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode = 1;
	}
	x_put_word(srca, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x1, dst, 1);
		return;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 12 (2/1) */
/* 2 0,0   */

/* NOT.W (An)+ */
void REGPARAM2 op_4658_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 12; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_areg(regs, srcreg) += 2 + 0;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) += 2 + 0;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) += 2;
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode = 1;
	}
	x_put_word(srca, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x1, dst, 1);
		return;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 12 (2/1) */
/* 2 0,0   */

/* NOT.W -(An) */
void REGPARAM2 op_4660_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 14; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	do_cycles_ce000_internal(2);
	if (srca & 1) {
		m68k_areg(regs, srcreg) = srca;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode = 1;
	}
	x_put_word(srca, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x1, dst, 1);
		return;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 14 (2/1) */
/* 2 0,0   */

/* NOT.W (d16,An) */
void REGPARAM2 op_4668_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(srca, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, dst, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* NOT.W (d8,An,Xn) */
void REGPARAM2 op_4670_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(srca, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, dst, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 18 (3/1) */
/* 4 4,0   */

/* NOT.W (xxx).W */
void REGPARAM2 op_4678_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 19;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(srca, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, dst, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* NOT.W (xxx).L */
void REGPARAM2 op_4679_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 19;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_word(srca, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, srca + 0, 0x1, dst, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* NOT.L Dn */
void REGPARAM2 op_4680_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 6;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	ipl_fetch_next_pre();
	regs.ir = regs.irc;
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		dreg_68000_long_replace_low(srcreg, dst);
		SET_VFLG(0);SET_ZFLG(!dst);
		SET_NFLG(dst & 0x80000000);
		SET_CFLG(0);
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	opcode = regs.ir;
	m68k_dreg(regs, srcreg) = (dst);
	do_cycles_ce000_internal(2);
	m68k_incpci(2);
	return;
}
/* 6 (1/0) */
/* 2 0,0   */

/* NOT.L (An) */
void REGPARAM2 op_4690_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 20; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			SET_VFLG(0);
			SET_ZFLG(!(dst & 0xffff));
			SET_NFLG(dst & 0x8000);
			SET_CFLG(0);
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode = 1;
	}
	x_put_word(srca + 2, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 2, 0x1, dst, 1);
		return;
	}
	x_put_word(srca, dst >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x1, dst >> 16, 1);
		return;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 20 (3/2) */
/* 2 0,0   */

/* NOT.L (An)+ */
void REGPARAM2 op_4698_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 20; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) += 4;
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			SET_VFLG(0);
			SET_ZFLG(!(dst & 0xffff));
			SET_NFLG(dst & 0x8000);
			SET_CFLG(0);
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode = 1;
	}
	x_put_word(srca + 2, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 2, 0x1, dst, 1);
		return;
	}
	x_put_word(srca, dst >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x1, dst >> 16, 1);
		return;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 20 (3/2) */
/* 2 0,0   */

/* NOT.L -(An) */
void REGPARAM2 op_46a0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 22; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	do_cycles_ce000_internal(2);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			SET_VFLG(0);
			SET_ZFLG(!(dst & 0xffff));
			SET_NFLG(dst & 0x8000);
			SET_CFLG(0);
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode = 1;
	}
	x_put_word(srca + 2, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 2, 0x1, dst, 1);
		return;
	}
	x_put_word(srca, dst >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x1, dst >> 16, 1);
		return;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 22 (3/2) */
/* 2 0,0   */

/* NOT.L (d16,An) */
void REGPARAM2 op_46a8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		SET_VFLG(0);
		SET_ZFLG(!(dst & 0xffff));
		SET_NFLG(dst & 0x8000);
		SET_CFLG(0);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	x_put_word(srca + 2, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 2, 0x1, dst, 1);
		return;
	}
	x_put_word(srca, dst >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, dst >> 16, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 24 (4/2) */
/* 4 0,0   */

/* NOT.L (d8,An,Xn) */
void REGPARAM2 op_46b0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 26; 
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		SET_VFLG(0);
		SET_ZFLG(!(dst & 0xffff));
		SET_NFLG(dst & 0x8000);
		SET_CFLG(0);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	x_put_word(srca + 2, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 2, 0x1, dst, 1);
		return;
	}
	x_put_word(srca, dst >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, dst >> 16, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 26 (4/2) */
/* 4 4,0   */

/* NOT.L (xxx).W */
void REGPARAM2 op_46b8_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 19;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		SET_VFLG(0);
		SET_ZFLG(!(dst & 0xffff));
		SET_NFLG(dst & 0x8000);
		SET_CFLG(0);
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	x_put_word(srca + 2, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 2, 0x1, dst, 1);
		return;
	}
	x_put_word(srca, dst >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x1, dst >> 16, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 24 (4/2) */
/* 4 0,0   */

/* NOT.L (xxx).L */
void REGPARAM2 op_46b9_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 19;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		SET_VFLG(0);
		SET_ZFLG(!(dst & 0xffff));
		SET_NFLG(dst & 0x8000);
		SET_CFLG(0);
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	x_put_word(srca + 2, dst);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, srca + 2, 0x1, dst, 1);
		return;
	}
	x_put_word(srca, dst >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, srca + 0, 0x1, dst >> 16, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 28 (5/2) */
/* 6 0,0   */

/* MV2SR.W Dn */
void REGPARAM2 op_46c0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	CurrentInstrCycles = 12; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 src = m68k_dreg(regs, srcreg);
	do_cycles_ce000_internal(4);
	regs.sr = src;
	MakeFromSR();
	m68k_incpci(2);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 12 (2/0) */
/* 2 0,0   */

/* MV2SR.W (An) */
void REGPARAM2 op_46d0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	CurrentInstrCycles = 16; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	do_cycles_ce000_internal(4);
	regs.sr = src;
	MakeFromSR();
	m68k_incpci(2);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (3/0) */
/* 2 0,0   */

/* MV2SR.W (An)+ */
void REGPARAM2 op_46d8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	CurrentInstrCycles = 16; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_areg(regs, srcreg) += 2 + 0;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) += 2 + 0;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) += 2;
	do_cycles_ce000_internal(4);
	regs.sr = src;
	MakeFromSR();
	m68k_incpci(2);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (3/0) */
/* 2 0,0   */

/* MV2SR.W -(An) */
void REGPARAM2 op_46e0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	CurrentInstrCycles = 18; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	do_cycles_ce000_internal(2);
	if (srca & 1) {
		m68k_areg(regs, srcreg) = srca;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	do_cycles_ce000_internal(4);
	regs.sr = src;
	MakeFromSR();
	m68k_incpci(2);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 18 (3/0) */
/* 2 0,0   */

/* MV2SR.W (d16,An) */
void REGPARAM2 op_46e8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	CurrentInstrCycles = 20; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	do_cycles_ce000_internal(4);
	regs.sr = src;
	MakeFromSR();
	m68k_incpci(4);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (4/0) */
/* 4 0,0   */

/* MV2SR.W (d8,An,Xn) */
void REGPARAM2 op_46f0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	CurrentInstrCycles = 22; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	do_cycles_ce000_internal(4);
	regs.sr = src;
	MakeFromSR();
	m68k_incpci(4);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 22 (4/0) */
/* 4 4,0   */

/* MV2SR.W (xxx).W */
void REGPARAM2 op_46f8_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 33;
	CurrentInstrCycles = 20; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	do_cycles_ce000_internal(4);
	regs.sr = src;
	MakeFromSR();
	m68k_incpci(4);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (4/0) */
/* 4 0,0   */

/* MV2SR.W (xxx).L */
void REGPARAM2 op_46f9_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 33;
	CurrentInstrCycles = 24; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	do_cycles_ce000_internal(4);
	regs.sr = src;
	MakeFromSR();
	m68k_incpci(6);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 24 (5/0) */
/* 6 0,0   */

/* MV2SR.W (d16,PC) */
void REGPARAM2 op_46fa_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 33;
	CurrentInstrCycles = 20; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	do_cycles_ce000_internal(4);
	regs.sr = src;
	MakeFromSR();
	m68k_incpci(4);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 20 (4/0) */
/* 4 0,0   */

/* MV2SR.W (d8,PC,Xn) */
void REGPARAM2 op_46fb_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 33;
	CurrentInstrCycles = 22; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(tmppc, get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 2);
		return;
	}
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 2);
		return;
	}
	do_cycles_ce000_internal(4);
	regs.sr = src;
	MakeFromSR();
	m68k_incpci(4);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 22 (4/0) */
/* 4 4,0   */

/* MV2SR.W #<data>.W */
void REGPARAM2 op_46fc_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 33;
	CurrentInstrCycles = 16; 
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 src = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	do_cycles_ce000_internal(4);
	regs.sr = src;
	MakeFromSR();
	m68k_incpci(4);
	get_word_ce000_prefetch(0);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 0, 0);
		return;
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(2);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 2, pcoffset);
		return;
	}
	return;
}
/* 16 (3/0) */
/* 4 0,0   */

/* NBCD.B Dn */
void REGPARAM2 op_4800_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 17;
	CurrentInstrCycles = 6;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	tmp_newv = newv_hi + newv_lo;
	if (newv_lo > 9) newv_lo -= 6;
	newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	ipl_fetch_next_pre();
	regs.ir = regs.irc;
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	opcode = regs.ir;
	do_cycles_ce000_internal(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return;
}
/* 6 (1/0) */
/* 2 0,0   */

/* NBCD.B (An) */
void REGPARAM2 op_4810_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 17;
	CurrentInstrCycles = 12; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	tmp_newv = newv_hi + newv_lo;
	if (newv_lo > 9) newv_lo -= 6;
	newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 6;
		loop_mode |= 6 << 16;
	}
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode = 1;
	}
	x_put_byte(srca, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x0, newv, 1);
		return;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 12 (2/1) */
/* 2 0,0   */

/* NBCD.B (An)+ */
void REGPARAM2 op_4818_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 17;
	CurrentInstrCycles = 12; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	tmp_newv = newv_hi + newv_lo;
	if (newv_lo > 9) newv_lo -= 6;
	newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 6;
		loop_mode |= 6 << 16;
	}
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode = 1;
	}
	x_put_byte(srca, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x0, newv, 1);
		return;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 12 (2/1) */
/* 2 0,0   */

/* NBCD.B -(An) */
void REGPARAM2 op_4820_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 17;
	CurrentInstrCycles = 14; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal(2);
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	tmp_newv = newv_hi + newv_lo;
	if (newv_lo > 9) newv_lo -= 6;
	newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
		opcode = regs.ir;
	} else {
		loop_mode = 0;
		loop_mode |= 6;
		loop_mode |= 6 << 16;
	}
	if(loop_mode & 0xfffe) {
		do_cycles_ce000_internal(loop_mode & 0xfffe);
		loop_mode = 1;
	}
	x_put_byte(srca, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, srca + 0, 0x0, newv, 1);
		return;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 14 (2/1) */
/* 2 0,0   */

/* NBCD.B (d16,An) */
void REGPARAM2 op_4828_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 17;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	tmp_newv = newv_hi + newv_lo;
	if (newv_lo > 9) newv_lo -= 6;
	newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(srca, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x0, newv, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* NBCD.B (d8,An,Xn) */
void REGPARAM2 op_4830_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 17;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	tmp_newv = newv_hi + newv_lo;
	if (newv_lo > 9) newv_lo -= 6;
	newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(srca, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x0, newv, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 18 (3/1) */
/* 4 4,0   */

/* NBCD.B (xxx).W */
void REGPARAM2 op_4838_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 17;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	tmp_newv = newv_hi + newv_lo;
	if (newv_lo > 9) newv_lo -= 6;
	newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(srca, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, srca + 0, 0x0, newv, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (3/1) */
/* 4 0,0   */

/* NBCD.B (xxx).L */
void REGPARAM2 op_4839_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 17;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	tmp_newv = newv_hi + newv_lo;
	if (newv_lo > 9) newv_lo -= 6;
	newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG((tmp_newv & 0x80) != 0 && (newv & 0x80) == 0);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	opcode = regs.ir;
	x_put_byte(srca, newv);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, srca + 0, 0x0, newv, 1);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 20 (4/1) */
/* 6 0,0   */

/* SWAP.W Dn */
void REGPARAM2 op_4840_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 34;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_u32 dst = ((src >> 16)&0xFFFF) | ((src&0xFFFF)<<16);
	m68k_dreg(regs, srcreg) = (dst);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	m68k_incpci(2);
	return;
}
/* 4 (1/0) */
/* 2 0,0   */

/* BKPTQ.L #<data> */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4848_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 99;
	CurrentInstrCycles = 4;  
	do_cycles_ce000_internal(4);
	op_illg_noret(opcode);
	return;
}
/* 4 (0/0) */
/* 2 0,0   */

#endif
/* PEA.L (An) */
void REGPARAM2 op_4850_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 57;
	CurrentInstrCycles = 12; 
	uae_u16 old_opcode = opcode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, 7) - 4;
	m68k_areg(regs, 7) = dsta;
	ipl_fetch_next_pre();
	regs.ir = regs.irc;
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, 7) += 4;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	if (dsta & 1) {
		regs.ir = old_opcode;
		m68k_incpci(2);
		exception3_write_access(old_opcode, dsta, sz_word, srca >> 16, 1);
		return;
	}
	x_put_word(dsta, srca >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 0, 0x1, srca >> 16, 1);
		return;
	}
	x_put_word(dsta + 2, srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_write(opcode, dsta + 2, 0x1, srca, 1);
		return;
	}
	m68k_incpci(2);
	return;
}
/* 12 (1/2) */
/* 2 0,0   */

/* PEA.L (d16,An) */
void REGPARAM2 op_4868_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 57;
	CurrentInstrCycles = 16; 
	uae_u16 old_opcode = opcode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, 7) - 4;
	m68k_areg(regs, 7) = dsta;
	ipl_fetch_next_pre();
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, 7) += 4;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	if (dsta & 1) {
		regs.ir = old_opcode;
		m68k_incpci(2);
		exception3_write_access(old_opcode, dsta, sz_word, srca >> 16, 1);
		return;
	}
	x_put_word(dsta, srca >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, srca >> 16, 1);
		return;
	}
	x_put_word(dsta + 2, srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 2, 0x1, srca, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (2/2) */
/* 4 0,0   */

/* PEA.L (d8,An,Xn) */
void REGPARAM2 op_4870_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 57;
	CurrentInstrCycles = 20; 
	do_cycles_ce000_internal(2);
	ipl_fetch_now();
	uae_u16 old_opcode = opcode;
	uaecptr srca;
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, 7) - 4;
	m68k_areg(regs, 7) = dsta;
	do_cycles_ce000_internal(2);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, 7) += 4;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	if (dsta & 1) {
		regs.ir = old_opcode;
		m68k_incpci(2);
		exception3_write_access(old_opcode, dsta, sz_word, srca >> 16, 1);
		return;
	}
	x_put_word(dsta, srca >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, srca >> 16, 1);
		return;
	}
	x_put_word(dsta + 2, srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 2, 0x1, srca, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 20 (2/2) */
/* 4 4,0   */

/* PEA.L (xxx).W */
void REGPARAM2 op_4878_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 57;
	CurrentInstrCycles = 16; 
	uae_u16 old_opcode = opcode;
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, 7) - 4;
	m68k_areg(regs, 7) = dsta;
	if (dsta & 1) {
		regs.ir = old_opcode;
		m68k_incpci(2);
		exception3_write_access(old_opcode, dsta, sz_word, srca >> 16, 1);
		return;
	}
	x_put_word(dsta, srca >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, srca >> 16, 1);
		return;
	}
	x_put_word(dsta + 2, srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 2, 0x1, srca, 1);
		return;
	}
	ipl_fetch_next();
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (2/2) */
/* 4 0,0   */

/* PEA.L (xxx).L */
void REGPARAM2 op_4879_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 57;
	CurrentInstrCycles = 20; 
	uae_u16 old_opcode = opcode;
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, 7) - 4;
	m68k_areg(regs, 7) = dsta;
	if (dsta & 1) {
		regs.ir = old_opcode;
		m68k_incpci(2);
		exception3_write_access(old_opcode, dsta, sz_word, srca >> 16, 1);
		return;
	}
	x_put_word(dsta, srca >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 0, 0x1, srca >> 16, 1);
		return;
	}
	x_put_word(dsta + 2, srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(8);
		exception2_write(opcode, dsta + 2, 0x1, srca, 1);
		return;
	}
	ipl_fetch_next();
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 20 (3/2) */
/* 6 0,0   */

/* PEA.L (d16,PC) */
void REGPARAM2 op_487a_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 57;
	CurrentInstrCycles = 16; 
	uae_u16 old_opcode = opcode;
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, 7) - 4;
	m68k_areg(regs, 7) = dsta;
	ipl_fetch_next_pre();
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, 7) += 4;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	if (dsta & 1) {
		regs.ir = old_opcode;
		m68k_incpci(2);
		exception3_write_access(old_opcode, dsta, sz_word, srca >> 16, 1);
		return;
	}
	x_put_word(dsta, srca >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, srca >> 16, 1);
		return;
	}
	x_put_word(dsta + 2, srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 2, 0x1, srca, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (2/2) */
/* 4 0,0   */

/* PEA.L (d8,PC,Xn) */
void REGPARAM2 op_487b_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 57;
	CurrentInstrCycles = 20; 
	do_cycles_ce000_internal(2);
	ipl_fetch_now();
	uae_u16 old_opcode = opcode;
	uaecptr srca;
	uaecptr tmppc = m68k_getpci() + 2;
	srca = get_disp_ea_000(tmppc, get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	uaecptr dsta;
	dsta = m68k_areg(regs, 7) - 4;
	m68k_areg(regs, 7) = dsta;
	do_cycles_ce000_internal(2);
	regs.ir = regs.irc;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		m68k_areg(regs, 7) += 4;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	if (dsta & 1) {
		regs.ir = old_opcode;
		m68k_incpci(2);
		exception3_write_access(old_opcode, dsta, sz_word, srca >> 16, 1);
		return;
	}
	x_put_word(dsta, srca >> 16);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 0, 0x1, srca >> 16, 1);
		return;
	}
	x_put_word(dsta + 2, srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_write(opcode, dsta + 2, 0x1, srca, 1);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 20 (2/2) */
/* 4 4,0   */

/* EXT.W Dn */
void REGPARAM2 op_4880_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 36;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_u16 dst = (uae_s16)(uae_s8)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((dst) & 0xffff);
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	m68k_incpci(2);
	return;
}
/* 4 (1/0) */
/* 2 0,0   */

/* MVMLE.W #<data>.W,(An) */
void REGPARAM2 op_4890_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 38;
	CurrentInstrCycles = 8;  
	uae_u16 mask = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 2);
		return;
	}
	uaecptr srca;
	srca = m68k_areg(regs, dstreg);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	if ((amask || dmask) && (srca & 1)) {
		uaecptr srcav = srca;
		if(dmask) {
			srcav = m68k_dreg(regs, movem_index1[dmask]) >> 0;
		} else if (amask) {
			srcav = m68k_areg(regs, movem_index1[amask]) >> 0;
		}
		regs.read_buffer = mask;
		m68k_incpci(6);
		exception3_write_access(opcode, srca, 1, srcav, 1);
		return;
	}
	while (dmask) {
		x_put_word(srca, m68k_dreg(regs, movem_index1[dmask]));
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			exception2_write(opcode, srca + 0, 0x1, m68k_dreg(regs, movem_index1[dmask]), 1);
			return;
		}
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		x_put_word(srca, m68k_areg(regs, movem_index1[amask]));
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			exception2_write(opcode, srca + 0, 0x1, m68k_areg(regs, movem_index1[amask]), 1);
			return;
		}
		srca += 2;
		amask = movem_next[amask];
	}
	ipl_fetch_next();
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 8+ (2/0) */
/* 4 0,0   */

/* MVMLE.W #<data>.W,-(An) */
void REGPARAM2 op_48a0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 38;
	CurrentInstrCycles = 8;  
	uae_u16 mask = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 2);
		return;
	}
	uaecptr srca;
	srca = m68k_areg(regs, dstreg) - 0;
	uae_u16 amask = mask & 0xff, dmask = (mask >> 8) & 0xff;
	if ((amask || dmask) && (srca & 1)) {
		srca -= 2;
		uaecptr srcav = srca;
		if(amask) {
			srcav = m68k_areg(regs, movem_index2[amask]);
		} else if (dmask) {
			srcav = m68k_dreg(regs, movem_index2[dmask]);
		}
		regs.read_buffer = mask;
		m68k_incpci(6);
		exception3_write_access(opcode, srca, 1, srcav, 1);
		return;
	}
	while (amask) {
		srca -= 2;
		x_put_word(srca, m68k_areg(regs, movem_index2[amask]));
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			exception2_write(opcode, srca + 0, 0x1, m68k_areg(regs, movem_index2[amask]), 1);
			return;
		}
		amask = movem_next[amask];
	}
	while (dmask) {
		srca -= 2;
		x_put_word(srca, m68k_dreg(regs, movem_index2[dmask]));
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			exception2_write(opcode, srca + 0, 0x1, m68k_dreg(regs, movem_index2[dmask]), 1);
			return;
		}
		dmask = movem_next[dmask];
	}
	m68k_areg(regs, dstreg) = srca;
	ipl_fetch_next();
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 8+ (2/0) */
/* 4 0,0   */

/* MVMLE.W #<data>.W,(d16,An) */
void REGPARAM2 op_48a8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 38;
	CurrentInstrCycles = 12; 
	uae_u16 mask = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr srca;
	srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 2);
		return;
	}
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	if ((amask || dmask) && (srca & 1)) {
		uaecptr srcav = srca;
		if(dmask) {
			srcav = m68k_dreg(regs, movem_index1[dmask]) >> 0;
		} else if (amask) {
			srcav = m68k_areg(regs, movem_index1[amask]) >> 0;
		}
		m68k_incpci(8);
		exception3_write_access(opcode, srca, 1, srcav, 1);
		return;
	}
	while (dmask) {
		x_put_word(srca, m68k_dreg(regs, movem_index1[dmask]));
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			exception2_write(opcode, srca + 0, 0x1, m68k_dreg(regs, movem_index1[dmask]), 1);
			return;
		}
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		x_put_word(srca, m68k_areg(regs, movem_index1[amask]));
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			exception2_write(opcode, srca + 0, 0x1, m68k_areg(regs, movem_index1[amask]), 1);
			return;
		}
		srca += 2;
		amask = movem_next[amask];
	}
	ipl_fetch_next();
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 12+ (3/0) */
/* 6 0,0   */

/* MVMLE.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_48b0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 38;
	CurrentInstrCycles = 14; 
	uae_u16 mask = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	do_cycles_ce000_internal(2);
	uaecptr srca;
	srca = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 2);
		return;
	}
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	if ((amask || dmask) && (srca & 1)) {
		uaecptr srcav = srca;
		if(dmask) {
			srcav = m68k_dreg(regs, movem_index1[dmask]) >> 0;
		} else if (amask) {
			srcav = m68k_areg(regs, movem_index1[amask]) >> 0;
		}
		m68k_incpci(8);
		exception3_write_access(opcode, srca, 1, srcav, 1);
		return;
	}
	while (dmask) {
		x_put_word(srca, m68k_dreg(regs, movem_index1[dmask]));
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			exception2_write(opcode, srca + 0, 0x1, m68k_dreg(regs, movem_index1[dmask]), 1);
			return;
		}
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		x_put_word(srca, m68k_areg(regs, movem_index1[amask]));
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			exception2_write(opcode, srca + 0, 0x1, m68k_areg(regs, movem_index1[amask]), 1);
			return;
		}
		srca += 2;
		amask = movem_next[amask];
	}
	ipl_fetch_next();
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 14+ (3/0) */
/* 6 4,0   */

/* MVMLE.W #<data>.W,(xxx).W */
void REGPARAM2 op_48b8_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 38;
	CurrentInstrCycles = 12; 
	uae_u16 mask = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 2);
		return;
	}
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	if ((amask || dmask) && (srca & 1)) {
		uaecptr srcav = srca;
		if(dmask) {
			srcav = m68k_dreg(regs, movem_index1[dmask]) >> 0;
		} else if (amask) {
			srcav = m68k_areg(regs, movem_index1[amask]) >> 0;
		}
		m68k_incpci(8);
		exception3_write_access(opcode, srca, 1, srcav, 1);
		return;
	}
	while (dmask) {
		x_put_word(srca, m68k_dreg(regs, movem_index1[dmask]));
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			exception2_write(opcode, srca + 0, 0x1, m68k_dreg(regs, movem_index1[dmask]), 1);
			return;
		}
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		x_put_word(srca, m68k_areg(regs, movem_index1[amask]));
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			exception2_write(opcode, srca + 0, 0x1, m68k_areg(regs, movem_index1[amask]), 1);
			return;
		}
		srca += 2;
		amask = movem_next[amask];
	}
	ipl_fetch_next();
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 12+ (3/0) */
/* 6 0,0   */

/* MVMLE.W #<data>.W,(xxx).L */
void REGPARAM2 op_48b9_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 38;
	CurrentInstrCycles = 16; 
	uae_u16 mask = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr srca;
	srca = get_word_ce000_prefetch(6) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		pcoffset += 2;
		exception2_fetch(opcode, 8, pcoffset);
		return;
	}
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	if ((amask || dmask) && (srca & 1)) {
		uaecptr srcav = srca;
		if(dmask) {
			srcav = m68k_dreg(regs, movem_index1[dmask]) >> 0;
		} else if (amask) {
			srcav = m68k_areg(regs, movem_index1[amask]) >> 0;
		}
		m68k_incpci(10);
		exception3_write_access(opcode, srca, 1, srcav, 1);
		return;
	}
	while (dmask) {
		x_put_word(srca, m68k_dreg(regs, movem_index1[dmask]));
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(10);
			exception2_write(opcode, srca + 0, 0x1, m68k_dreg(regs, movem_index1[dmask]), 1);
			return;
		}
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		x_put_word(srca, m68k_areg(regs, movem_index1[amask]));
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(10);
			exception2_write(opcode, srca + 0, 0x1, m68k_areg(regs, movem_index1[amask]), 1);
			return;
		}
		srca += 2;
		amask = movem_next[amask];
	}
	ipl_fetch_next();
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return;
	}
	m68k_incpci(8);
	return;
}
/* 16+ (4/0) */
/* 8 0,0   */

/* EXT.L Dn */
void REGPARAM2 op_48c0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 36;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_u32 dst = (uae_s32)(uae_s16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	m68k_dreg(regs, srcreg) = (dst);
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	m68k_incpci(2);
	return;
}
/* 4 (1/0) */
/* 2 0,0   */

/* MVMLE.L #<data>.W,(An) */
void REGPARAM2 op_48d0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 38;
	CurrentInstrCycles = 8;  
	uae_u16 mask = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 2);
		return;
	}
	uaecptr srca;
	srca = m68k_areg(regs, dstreg);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	if ((amask || dmask) && (srca & 1)) {
		uaecptr srcav = srca;
		if(dmask) {
			srcav = m68k_dreg(regs, movem_index1[dmask]) >> 16;
		} else if (amask) {
			srcav = m68k_areg(regs, movem_index1[amask]) >> 16;
		}
		regs.read_buffer = mask;
		m68k_incpci(6);
		exception3_write_access(opcode, srca, 2, srcav, 1);
		return;
	}
	while (dmask) {
		x_put_word(srca, m68k_dreg(regs, movem_index1[dmask]) >> 16);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			exception2_write(opcode, srca + 0, 0x1, m68k_dreg(regs, movem_index1[dmask]) >> 16, 1);
			return;
		}
		x_put_word(srca + 2, m68k_dreg(regs, movem_index1[dmask]));
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			exception2_write(opcode, srca + 2, 0x1, m68k_dreg(regs, movem_index1[dmask]), 1);
			return;
		}
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		x_put_word(srca, m68k_areg(regs, movem_index1[amask]) >> 16);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			exception2_write(opcode, srca + 0, 0x1, m68k_areg(regs, movem_index1[amask]) >> 16, 1);
			return;
		}
		x_put_word(srca + 2, m68k_areg(regs, movem_index1[amask]));
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			exception2_write(opcode, srca + 2, 0x1, m68k_areg(regs, movem_index1[amask]), 1);
			return;
		}
		srca += 4;
		amask = movem_next[amask];
	}
	ipl_fetch_next();
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 8+ (2/0) */
/* 4 0,0   */

/* MVMLE.L #<data>.W,-(An) */
void REGPARAM2 op_48e0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 38;
	CurrentInstrCycles = 8;  
	uae_u16 mask = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 2);
		return;
	}
	uaecptr srca;
	srca = m68k_areg(regs, dstreg) - 0;
	uae_u16 amask = mask & 0xff, dmask = (mask >> 8) & 0xff;
	if ((amask || dmask) && (srca & 1)) {
		srca -= 2;
		uaecptr srcav = srca;
		if(amask) {
			srcav = m68k_areg(regs, movem_index2[amask]);
		} else if (dmask) {
			srcav = m68k_dreg(regs, movem_index2[dmask]);
		}
		regs.read_buffer = mask;
		m68k_incpci(6);
		exception3_write_access(opcode, srca, 2, srcav, 1);
		return;
	}
	while (amask) {
		x_put_word(srca - 2, m68k_areg(regs, movem_index2[amask]));
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			exception2_write(opcode, srca + -2, 0x1, m68k_areg(regs, movem_index2[amask]), 1);
			return;
		}
		x_put_word(srca - 4, m68k_areg(regs, movem_index2[amask]) >> 16);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			exception2_write(opcode, srca + -4, 0x1, m68k_areg(regs, movem_index2[amask]) >> 16, 1);
			return;
		}
		srca -= 4;
		amask = movem_next[amask];
	}
	while (dmask) {
		x_put_word(srca - 2, m68k_dreg(regs, movem_index2[dmask]));
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			exception2_write(opcode, srca + -2, 0x1, m68k_dreg(regs, movem_index2[dmask]), 1);
			return;
		}
		x_put_word(srca - 4, m68k_dreg(regs, movem_index2[dmask]) >> 16);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(6);
			exception2_write(opcode, srca + -4, 0x1, m68k_dreg(regs, movem_index2[dmask]) >> 16, 1);
			return;
		}
		srca -= 4;
		dmask = movem_next[dmask];
	}
	m68k_areg(regs, dstreg) = srca;
	ipl_fetch_next();
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 8+ (2/0) */
/* 4 0,0   */

/* MVMLE.L #<data>.W,(d16,An) */
void REGPARAM2 op_48e8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 38;
	CurrentInstrCycles = 12; 
	uae_u16 mask = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr srca;
	srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 2);
		return;
	}
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	if ((amask || dmask) && (srca & 1)) {
		uaecptr srcav = srca;
		if(dmask) {
			srcav = m68k_dreg(regs, movem_index1[dmask]) >> 16;
		} else if (amask) {
			srcav = m68k_areg(regs, movem_index1[amask]) >> 16;
		}
		m68k_incpci(8);
		exception3_write_access(opcode, srca, 2, srcav, 1);
		return;
	}
	while (dmask) {
		x_put_word(srca, m68k_dreg(regs, movem_index1[dmask]) >> 16);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			exception2_write(opcode, srca + 0, 0x1, m68k_dreg(regs, movem_index1[dmask]) >> 16, 1);
			return;
		}
		x_put_word(srca + 2, m68k_dreg(regs, movem_index1[dmask]));
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			exception2_write(opcode, srca + 2, 0x1, m68k_dreg(regs, movem_index1[dmask]), 1);
			return;
		}
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		x_put_word(srca, m68k_areg(regs, movem_index1[amask]) >> 16);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			exception2_write(opcode, srca + 0, 0x1, m68k_areg(regs, movem_index1[amask]) >> 16, 1);
			return;
		}
		x_put_word(srca + 2, m68k_areg(regs, movem_index1[amask]));
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			exception2_write(opcode, srca + 2, 0x1, m68k_areg(regs, movem_index1[amask]), 1);
			return;
		}
		srca += 4;
		amask = movem_next[amask];
	}
	ipl_fetch_next();
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 12+ (3/0) */
/* 6 0,0   */

/* MVMLE.L #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_48f0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 38;
	CurrentInstrCycles = 14; 
	uae_u16 mask = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	do_cycles_ce000_internal(2);
	uaecptr srca;
	srca = get_disp_ea_000(m68k_areg(regs, dstreg), get_word_ce000_prefetch(6));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 2);
		return;
	}
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	if ((amask || dmask) && (srca & 1)) {
		uaecptr srcav = srca;
		if(dmask) {
			srcav = m68k_dreg(regs, movem_index1[dmask]) >> 16;
		} else if (amask) {
			srcav = m68k_areg(regs, movem_index1[amask]) >> 16;
		}
		m68k_incpci(8);
		exception3_write_access(opcode, srca, 2, srcav, 1);
		return;
	}
	while (dmask) {
		x_put_word(srca, m68k_dreg(regs, movem_index1[dmask]) >> 16);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			exception2_write(opcode, srca + 0, 0x1, m68k_dreg(regs, movem_index1[dmask]) >> 16, 1);
			return;
		}
		x_put_word(srca + 2, m68k_dreg(regs, movem_index1[dmask]));
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			exception2_write(opcode, srca + 2, 0x1, m68k_dreg(regs, movem_index1[dmask]), 1);
			return;
		}
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		x_put_word(srca, m68k_areg(regs, movem_index1[amask]) >> 16);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			exception2_write(opcode, srca + 0, 0x1, m68k_areg(regs, movem_index1[amask]) >> 16, 1);
			return;
		}
		x_put_word(srca + 2, m68k_areg(regs, movem_index1[amask]));
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			exception2_write(opcode, srca + 2, 0x1, m68k_areg(regs, movem_index1[amask]), 1);
			return;
		}
		srca += 4;
		amask = movem_next[amask];
	}
	ipl_fetch_next();
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 14+ (3/0) */
/* 6 4,0   */

/* MVMLE.L #<data>.W,(xxx).W */
void REGPARAM2 op_48f8_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 38;
	CurrentInstrCycles = 12; 
	uae_u16 mask = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, 2);
		return;
	}
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	if ((amask || dmask) && (srca & 1)) {
		uaecptr srcav = srca;
		if(dmask) {
			srcav = m68k_dreg(regs, movem_index1[dmask]) >> 16;
		} else if (amask) {
			srcav = m68k_areg(regs, movem_index1[amask]) >> 16;
		}
		m68k_incpci(8);
		exception3_write_access(opcode, srca, 2, srcav, 1);
		return;
	}
	while (dmask) {
		x_put_word(srca, m68k_dreg(regs, movem_index1[dmask]) >> 16);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			exception2_write(opcode, srca + 0, 0x1, m68k_dreg(regs, movem_index1[dmask]) >> 16, 1);
			return;
		}
		x_put_word(srca + 2, m68k_dreg(regs, movem_index1[dmask]));
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			exception2_write(opcode, srca + 2, 0x1, m68k_dreg(regs, movem_index1[dmask]), 1);
			return;
		}
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		x_put_word(srca, m68k_areg(regs, movem_index1[amask]) >> 16);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			exception2_write(opcode, srca + 0, 0x1, m68k_areg(regs, movem_index1[amask]) >> 16, 1);
			return;
		}
		x_put_word(srca + 2, m68k_areg(regs, movem_index1[amask]));
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(8);
			exception2_write(opcode, srca + 2, 0x1, m68k_areg(regs, movem_index1[amask]), 1);
			return;
		}
		srca += 4;
		amask = movem_next[amask];
	}
	ipl_fetch_next();
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 12+ (3/0) */
/* 6 0,0   */

/* MVMLE.L #<data>.W,(xxx).L */
void REGPARAM2 op_48f9_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 38;
	CurrentInstrCycles = 16; 
	uae_u16 mask = get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	uaecptr srca;
	srca = get_word_ce000_prefetch(6) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		pcoffset += 2;
		exception2_fetch(opcode, 8, pcoffset);
		return;
	}
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	if ((amask || dmask) && (srca & 1)) {
		uaecptr srcav = srca;
		if(dmask) {
			srcav = m68k_dreg(regs, movem_index1[dmask]) >> 16;
		} else if (amask) {
			srcav = m68k_areg(regs, movem_index1[amask]) >> 16;
		}
		m68k_incpci(10);
		exception3_write_access(opcode, srca, 2, srcav, 1);
		return;
	}
	while (dmask) {
		x_put_word(srca, m68k_dreg(regs, movem_index1[dmask]) >> 16);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(10);
			exception2_write(opcode, srca + 0, 0x1, m68k_dreg(regs, movem_index1[dmask]) >> 16, 1);
			return;
		}
		x_put_word(srca + 2, m68k_dreg(regs, movem_index1[dmask]));
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(10);
			exception2_write(opcode, srca + 2, 0x1, m68k_dreg(regs, movem_index1[dmask]), 1);
			return;
		}
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		x_put_word(srca, m68k_areg(regs, movem_index1[amask]) >> 16);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(10);
			exception2_write(opcode, srca + 0, 0x1, m68k_areg(regs, movem_index1[amask]) >> 16, 1);
			return;
		}
		x_put_word(srca + 2, m68k_areg(regs, movem_index1[amask]));
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(10);
			exception2_write(opcode, srca + 2, 0x1, m68k_areg(regs, movem_index1[amask]), 1);
			return;
		}
		srca += 4;
		amask = movem_next[amask];
	}
	ipl_fetch_next();
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(10);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 10, pcoffset);
		return;
	}
	m68k_incpci(8);
	return;
}
/* 16+ (4/0) */
/* 8 0,0   */

/* TST.B Dn */
void REGPARAM2 op_4a00_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 4;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	m68k_incpci(2);
	return;
}
/* 4 (1/0) */
/* 2 0,0   */

/* TST.B (An) */
void REGPARAM2 op_4a10_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 8;  
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 8 (2/0) */
/* 2 0,0   */

/* TST.B (An)+ */
void REGPARAM2 op_4a18_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 8;  
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 8 (2/0) */
/* 2 0,0   */

/* TST.B -(An) */
void REGPARAM2 op_4a20_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 10; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	do_cycles_ce000_internal(2);
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 10 (2/0) */
/* 2 0,0   */

/* TST.B (d16,An) */
void REGPARAM2 op_4a28_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 12 (3/0) */
/* 4 0,0   */

/* TST.B (d8,An,Xn) */
void REGPARAM2 op_4a30_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 14 (3/0) */
/* 4 4,0   */

/* TST.B (xxx).W */
void REGPARAM2 op_4a38_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 20;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 12 (3/0) */
/* 4 0,0   */

/* TST.B (xxx).L */
void REGPARAM2 op_4a39_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 20;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	ipl_fetch_now();
	uae_s8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 16 (4/0) */
/* 6 0,0   */

/* TST.W Dn */
void REGPARAM2 op_4a40_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	m68k_incpci(2);
	return;
}
/* 4 (1/0) */
/* 2 0,0   */

/* TST.W (An) */
void REGPARAM2 op_4a50_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 8;  
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 8 (2/0) */
/* 2 0,0   */

/* TST.W (An)+ */
void REGPARAM2 op_4a58_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 8;  
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_areg(regs, srcreg) += 2 + 0;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) += 2 + 0;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 8 (2/0) */
/* 2 0,0   */

/* TST.W -(An) */
void REGPARAM2 op_4a60_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 10; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	do_cycles_ce000_internal(2);
	if (srca & 1) {
		m68k_areg(regs, srcreg) = srca;
		m68k_incpci(2);
		exception3_read_access2(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 4;
		loop_mode |= 4 << 16;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 10 (2/0) */
/* 2 0,0   */

/* TST.W (d16,An) */
void REGPARAM2 op_4a68_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 12 (3/0) */
/* 4 0,0   */

/* TST.W (d8,An,Xn) */
void REGPARAM2 op_4a70_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 14 (3/0) */
/* 4 4,0   */

/* TST.W (xxx).W */
void REGPARAM2 op_4a78_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 20;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 12 (3/0) */
/* 4 0,0   */

/* TST.W (xxx).L */
void REGPARAM2 op_4a79_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 20;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 1, 1);
		return;
	}
	ipl_fetch_now();
	uae_s16 src = x_get_word(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 16 (4/0) */
/* 6 0,0   */

/* TST.L Dn */
void REGPARAM2 op_4a80_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	m68k_incpci(2);
	return;
}
/* 4 (1/0) */
/* 2 0,0   */

/* TST.L (An) */
void REGPARAM2 op_4a90_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 12; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 6;
		loop_mode |= 4 << 16;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 12 (3/0) */
/* 2 0,0   */

/* TST.L (An)+ */
void REGPARAM2 op_4a98_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 12; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) += 4;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 6;
		loop_mode |= 4 << 16;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 12 (3/0) */
/* 2 0,0   */

/* TST.L -(An) */
void REGPARAM2 op_4aa0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 14; 
	int loop_mode = regs.loop_mode;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	do_cycles_ce000_internal(2);
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		m68k_areg(regs, srcreg) = srca;
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	m68k_areg(regs, srcreg) = srca;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	if(!loop_mode) {
		regs.ir = regs.irc;
		opcode = regs.ir;
		get_word_ce000_prefetch(4);
		if(hardware_bus_error) {
			int pcoffset = 0;
			exception2_fetch_opcode(opcode, 4, pcoffset);
			return;
		}
	} else {
		loop_mode = 0;
		loop_mode |= 6;
		loop_mode |= 4 << 16;
	}
	regs.loop_mode = loop_mode;
	m68k_incpci(2);
	return;
}
/* 14 (3/0) */
/* 2 0,0   */

/* TST.L (d16,An) */
void REGPARAM2 op_4aa8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (4/0) */
/* 4 0,0   */

/* TST.L (d8,An,Xn) */
void REGPARAM2 op_4ab0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	do_cycles_ce000_internal(2);
	srca = get_disp_ea_000(m68k_areg(regs, srcreg), get_word_ce000_prefetch(4));
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(2);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 18 (4/0) */
/* 4 4,0   */

/* TST.L (xxx).W */
void REGPARAM2 op_4ab8_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 20;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, 0);
		return;
	}
	if (srca & 1) {
		m68k_incpci(4);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 6, pcoffset);
		return;
	}
	m68k_incpci(4);
	return;
}
/* 16 (4/0) */
/* 4 0,0   */

/* TST.L (xxx).L */
void REGPARAM2 op_4ab9_13_ff(uae_u32 opcode)
{
	OpcodeFamily = 20;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_word_ce000_prefetch(4) << 16;
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 4, -2);
		return;
	}
	srca |= get_word_ce000_prefetch(6);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch(opcode, 6, pcoffset);
		return;
	}
	if (srca & 1) {
		m68k_incpci(6);
		exception3_read_access(opcode, srca, 2, 1);
		return;
	}
	uae_s32 src = x_get_word(srca) << 16;
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 0, 0x1, 1);
		return;
	}
	ipl_fetch_now();
	src |= x_get_word(srca + 2);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(6);
		exception2_read(opcode, srca + 2, 0x1, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(8);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 8, pcoffset);
		return;
	}
	m68k_incpci(6);
	return;
}
/* 20 (5/0) */
/* 6 0,0   */

/* TAS.B Dn */
void REGPARAM2 op_4ac0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 98;
	CurrentInstrCycles = 4;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	src |= 0x80;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((src) & 0xff);
	regs.ir = regs.irc;
	opcode = regs.ir;
	ipl_fetch_next();
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	m68k_incpci(2);
	return;
}
/* 4 (1/0) */
/* 2 0,0   */

/* TAS.B (An) */
void REGPARAM2 op_4ad0_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 98;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	do_cycles_ce000_internal(2);
	uae_u8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		regs.read_buffer = regs.irc & 0xff00;
		regs.read_buffer |= 0x80;
		opcode |= 0x80000;
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	do_cycles_ce000_internal(2);
	src |= 0x80;
	if (!is_cycle_ce(srca)) {
		ipl_fetch_now();
		x_put_byte(srca, src);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			opcode |= 0x80000;
			exception2_write(opcode, srca + 0, 0x0, src, 1);
			return;
		}
	} else {
		do_cycles_ce000_internal(4);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	m68k_incpci(2);
	return;
}
/* 12 (1/1) */
/* 2 0,0   */

/* TAS.B (An)+ */
void REGPARAM2 op_4ad8_13_ff(uae_u32 opcode)
{
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 98;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	do_cycles_ce000_internal(4);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uae_u8 src = x_get_byte(srca);
	if(hardware_bus_error) {
		cpu_bus_rmw=false;
		m68k_incpci(4);
		regs.read_buffer = regs.irc & 0xff00;
		regs.read_buffer |= 0x80;
		opcode |= 0x80000;
		exception2_read(opcode, srca + 0, 0x0, 1);
		return;
	}
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	do_cycles_ce000_internal(2);
	src |= 0x80;
	if (!is_cycle_ce(srca)) {
		ipl_fetch_now();
		x_put_byte(srca, src);
		if(hardware_bus_error) {
			cpu_bus_rmw=false;
			m68k_incpci(4);
			opcode |= 0x80000;
			exception2_write(opcode, srca + 0, 0x0, src, 1);
			return;
		}
	} else {
		do_cycles_ce000_internal(4);
	}
	regs.ir = regs.irc;
	opcode = regs.ir;
	get_word_ce000_prefetch(4);
	if(hardware_bus_error) {
		int pcoffset = 0;
		exception2_fetch_opcode(opcode, 4, pcoffset);
		return;
	}
	m68k_incpci(2);
	return;
}
/* 14 (1/1) */
/* 2 0,0   */

/* TAS.B -(An) */
void REGPARAM